import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import quadbase.ChartAPI.ColInfo;
import quadbase.ChartAPI.DBInfo;
import quadbase.ChartAPI.QbChart;
import quadbase.reportdesigner.ReportAPI.QbReport;
import quadbase.reportdesigner.ReportElements.ReportChartObject;
import quadbase.reportdesigner.ReportViewer.Viewer;

public class AddingIndependentDataChart extends Applet {

	static final long serialVersionUID = 1;

	public static void main(String[] args) {
		try {
			AddingIndependentDataChart chart = new AddingIndependentDataChart();
			Frame frame = new Frame();
			frame.setLayout(new BorderLayout());
			frame.add("Center", chart.doAddingIndependentDataChart(frame));
			frame.addWindowListener(new WindowAdapter() {
				public void windowClosing(WindowEvent e) {
					System.exit(0);
				}
			});
			frame.setSize(800, 600);
			frame.setVisible(true);

		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}

	public void init() {
		setLayout(new BorderLayout());
		add("Center", doAddingIndependentDataChart(this));
	}

	Component doAddingIndependentDataChart(Object parent)  {

		// Do not use EspressManager
		QbReport.setEspressManagerUsed(false);

		// Template Location
		String templateLocation = "AddingChartTemplate.rpt";

		// Create QbReport object from template
		QbReport report = new QbReport(parent, templateLocation);

		// Chart column mapping using report data as data source
		ColInfo chartColInfo = new ColInfo();
		chartColInfo.category = 0;
		chartColInfo.value = 1;
		
		// Data Source for chart
		String chartQuery = "SELECT ProductName, Sum(Order_Details.Quantity) " + 
							"FROM Products, Order_Details " + 
							"WHERE (Order_Details.ProductID = Products.ProductID) " +
							"GROUP BY Products.ProductName " +
							"ORDER BY Sum(Order_Details.Quantity) DESC";
		
		DBInfo chartDatabaseInfo = new DBInfo("jdbc:hsqldb:database/woodview", "org.hsqldb.jdbcDriver",
											  "sa", "", chartQuery);
		
		QbChart chartObj = new QbChart((Applet)null, QbChart.VIEW2D, QbChart.COL, chartDatabaseInfo,
									   false, chartColInfo, "AddingChartTemplate.tpl");

		// Add ChartObject to report
		ReportChartObject chartObject = new ReportChartObject();
		chartObject.setChart(chartObj);
		chartObject.setWidth(7.40);
		chartObject.setHeight(4.90);
		chartObject.setReportDataUsed(false);
		chartObject.setY(0.10);
		chartObject.setImageType(QbReport.PNG);
		report.getTable().getFooter().addData(chartObject);

		// Show report in Viewer
		return (new Viewer().getComponent(report));
	}

}
