/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core;

import com.sun.jimi.core.JimiControl;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.JimiFactoryManager;
import com.sun.jimi.core.JimiImage;
import com.sun.jimi.core.JimiImageFactory;
import com.sun.jimi.core.JimiProExtension;
import com.sun.jimi.core.JimiReader;
import com.sun.jimi.core.JimiWriter;
import com.sun.jimi.core.raster.JimiRasterImage;
import com.sun.jimi.core.raster.JimiRasterImageImporter;
import com.sun.jimi.core.util.JimiImageFactoryProxy;
import com.sun.jimi.core.util.JimiUtil;
import com.sun.jimi.core.util.QueuedImageProducerProxy;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;

public class Jimi {
    public static final int ASYNCHRONOUS = 1;
    public static final int SYNCHRONOUS = 2;
    public static final int IN_MEMORY = 4;
    public static final int VIRTUAL_MEMORY = 8;
    public static final int ONE_SHOT = 16;
    protected static int defaultFlags = 5;
    protected static JimiImageFactory memoryFactory = JimiFactoryManager.getMemoryFactory();
    protected static JimiImageFactory vmemFactory;
    protected static JimiImageFactory oneshotFactory;
    static boolean limited;
    static boolean crippled;
    static boolean demoversion;
    static /* synthetic */ Class class$0;

    static {
        oneshotFactory = JimiFactoryManager.getOneshotFactory();
        limited = false;
        crippled = false;
        demoversion = false;
        JimiControl.addExtension(new JimiProExtension());
    }

    private Jimi() {
    }

    static Class _mthclass$(String s) {
        try {
            return Class.forName(s);
        }
        catch (ClassNotFoundException classnotfoundexception) {
            throw new NoClassDefFoundError(classnotfoundexception.getMessage());
        }
    }

    public static JimiReader createJimiReader(InputStream inputstream) throws JimiException {
        return Jimi.createJimiReader(inputstream, defaultFlags);
    }

    public static JimiReader createJimiReader(InputStream inputstream, int i) throws JimiException {
        return new JimiReader(Jimi.getFactory(i), inputstream);
    }

    public static JimiReader createJimiReader(String s) throws JimiException {
        return Jimi.createJimiReader(s, defaultFlags);
    }

    public static JimiReader createJimiReader(String s, int i) throws JimiException {
        return new JimiReader(Jimi.getFactory(i), s);
    }

    public static JimiReader createJimiReader(URL url) throws JimiException {
        return Jimi.createJimiReader(url, defaultFlags);
    }

    public static JimiReader createJimiReader(URL url, int i) throws JimiException {
        return new JimiReader(Jimi.getFactory(i), url);
    }

    public static JimiWriter createJimiWriter(String s) throws JimiException {
        return new JimiWriter(s);
    }

    public static JimiWriter createJimiWriter(String s, OutputStream outputstream) throws JimiException {
        return new JimiWriter(outputstream, s);
    }

    public static JimiRasterImage createRasterImage(ImageProducer imageproducer) throws JimiException {
        return Jimi.createRasterImage(imageproducer, 4);
    }

    public static JimiRasterImage createRasterImage(ImageProducer imageproducer, int i) throws JimiException {
        if (imageproducer instanceof QueuedImageProducerProxy) {
            imageproducer = ((QueuedImageProducerProxy)imageproducer).getImageProducer();
        }
        if (imageproducer instanceof JimiRasterImage) {
            return (JimiRasterImage)((Object)imageproducer);
        }
        return Jimi.createRasterImage(imageproducer, Jimi.getFactory(i));
    }

    protected static JimiRasterImage createRasterImage(ImageProducer imageproducer, JimiImageFactory jimiimagefactory) throws JimiException {
        while (jimiimagefactory instanceof JimiImageFactoryProxy) {
            jimiimagefactory = ((JimiImageFactoryProxy)jimiimagefactory).getProxiedFactory();
        }
        return JimiRasterImageImporter.importImage(imageproducer, jimiimagefactory);
    }

    public static JimiReader createTypedJimiReader(InputStream inputstream, String s) throws JimiException {
        return Jimi.createTypedJimiReader(inputstream, s);
    }

    public static JimiReader createTypedJimiReader(InputStream inputstream, String s, int i) throws JimiException {
        return new JimiReader(Jimi.getFactory(i), inputstream, s);
    }

    public static JimiReader createTypedJimiReader(String s) throws JimiException {
        return Jimi.createTypedJimiReader(s, defaultFlags);
    }

    public static JimiReader createTypedJimiReader(String s, int i) throws JimiException {
        JimiReader jimireader = new JimiReader(Jimi.getFactory(i));
        jimireader.setMimeType(s);
        return jimireader;
    }

    public static JimiWriter createTypedJimiWriter(String s) throws JimiException {
        return new JimiWriter(null, s);
    }

    public static String[] getDecoderTypes() {
        String[] as = new String[JimiControl.mimeToDecoderMap.size()];
        Enumeration enumeration = JimiControl.mimeToDecoderMap.keys();
        int i = 0;
        while (i < as.length && enumeration.hasMoreElements()) {
            as[i] = (String)enumeration.nextElement();
            ++i;
        }
        return as;
    }

    public static String[] getEncoderTypes() {
        String[] as = new String[JimiControl.mimeToEncoderMap.size()];
        Enumeration enumeration = JimiControl.mimeToEncoderMap.keys();
        int i = 0;
        while (i < as.length && enumeration.hasMoreElements()) {
            as[i] = (String)enumeration.nextElement();
            ++i;
        }
        return as;
    }

    public static JimiImageFactory getFactory(int i) {
        if ((i & 0x10) != 0) {
            return oneshotFactory;
        }
        if ((i & 8) != 0) {
            if (vmemFactory == null) {
                if (limited) {
                    vmemFactory = memoryFactory;
                }
                try {
                    Class<?> class1 = Class.forName("com.sun.jimi.core.VMemJimiImageFactory");
                    vmemFactory = (JimiImageFactory)class1.newInstance();
                }
                catch (Exception _ex) {
                    vmemFactory = memoryFactory;
                }
            }
            return vmemFactory;
        }
        return memoryFactory;
    }

    public static Image getImage(InputStream inputstream) {
        return Jimi.getImage(inputstream, defaultFlags);
    }

    public static Image getImage(InputStream inputstream, int i) {
        return Toolkit.getDefaultToolkit().createImage(Jimi.getImageProducer(inputstream, i));
    }

    public static Image getImage(InputStream inputstream, String s) {
        return Jimi.getImage(inputstream, s, defaultFlags);
    }

    public static Image getImage(InputStream inputstream, String s, int i) {
        return Toolkit.getDefaultToolkit().createImage(Jimi.getImageProducer(inputstream, s, i));
    }

    public static Image getImage(String s) {
        return Jimi.getImage(s, defaultFlags);
    }

    public static Image getImage(String s, int i) {
        return Toolkit.getDefaultToolkit().createImage(Jimi.getImageProducer(s, i));
    }

    public static Image getImage(String s, String s1) {
        return Jimi.getImage(s, s1, defaultFlags);
    }

    public static Image getImage(String s, String s1, int i) {
        return Toolkit.getDefaultToolkit().createImage(Jimi.getImageProducer(s, s1, i));
    }

    public static Image getImage(URL url) {
        return Jimi.getImage(url, defaultFlags);
    }

    public static Image getImage(URL url, int i) {
        return Toolkit.getDefaultToolkit().createImage(Jimi.getImageProducer(url, i));
    }

    public static Image getImage(URL url, String s) {
        return Jimi.getImage(url, s, defaultFlags);
    }

    public static Image getImage(URL url, String s, int i) {
        return Toolkit.getDefaultToolkit().createImage(Jimi.getImageProducer(url, s, i));
    }

    public static ImageProducer getImageProducer(InputStream inputstream) {
        return Jimi.getImageProducer(inputstream, defaultFlags);
    }

    public static ImageProducer getImageProducer(InputStream inputstream, int i) {
        try {
            JimiReader jimireader = new JimiReader(Jimi.getFactory(i), inputstream);
            jimireader.setBlocking(JimiUtil.flagSet(i, 2));
            return jimireader.getImageProducer();
        }
        catch (JimiException _ex) {
            return JimiUtil.getErrorImageProducer();
        }
    }

    public static ImageProducer getImageProducer(InputStream inputstream, String s) {
        return Jimi.getImageProducer(inputstream, s, defaultFlags);
    }

    public static ImageProducer getImageProducer(InputStream inputstream, String s, int i) {
        try {
            JimiReader jimireader = new JimiReader(Jimi.getFactory(i), inputstream, s);
            jimireader.setBlocking(JimiUtil.flagSet(i, 2));
            return jimireader.getImageProducer();
        }
        catch (JimiException _ex) {
            return JimiUtil.getErrorImageProducer();
        }
    }

    public static ImageProducer getImageProducer(String s) {
        return Jimi.getImageProducer(s, defaultFlags);
    }

    public static ImageProducer getImageProducer(String s, int i) {
        try {
            JimiReader jimireader = new JimiReader(Jimi.getFactory(i), s);
            jimireader.setBlocking(JimiUtil.flagSet(i, 2));
            return jimireader.getImageProducer();
        }
        catch (JimiException _ex) {
            return JimiUtil.getErrorImageProducer();
        }
    }

    public static ImageProducer getImageProducer(String s, String s1) {
        return Jimi.getImageProducer(s, s1, defaultFlags);
    }

    public static ImageProducer getImageProducer(String s, String s1, int i) {
        try {
            JimiReader jimireader = new JimiReader(Jimi.getFactory(i), s, s1);
            jimireader.setBlocking(JimiUtil.flagSet(i, 2));
            return jimireader.getImageProducer();
        }
        catch (JimiException _ex) {
            return JimiUtil.getErrorImageProducer();
        }
    }

    public static ImageProducer getImageProducer(URL url) {
        return Jimi.getImageProducer(url, defaultFlags);
    }

    public static ImageProducer getImageProducer(URL url, int i) {
        try {
            JimiReader jimireader = new JimiReader(Jimi.getFactory(i), url);
            return jimireader.getImageProducer();
        }
        catch (JimiException _ex) {
            return JimiUtil.getErrorImageProducer();
        }
    }

    public static ImageProducer getImageProducer(URL url, String s) {
        return Jimi.getImageProducer(url, s, defaultFlags);
    }

    public static ImageProducer getImageProducer(URL url, String s, int i) {
        try {
            JimiReader jimireader = new JimiReader(Jimi.getFactory(i), url, s);
            return jimireader.getImageProducer();
        }
        catch (JimiException _ex) {
            return JimiUtil.getErrorImageProducer();
        }
    }

    public static JimiRasterImage getRasterImage(InputStream inputstream) throws JimiException {
        return Jimi.getRasterImage(inputstream, defaultFlags);
    }

    public static JimiRasterImage getRasterImage(InputStream inputstream, int i) throws JimiException {
        JimiReader jimireader = new JimiReader(Jimi.getFactory(i), inputstream);
        return jimireader.getRasterImage();
    }

    public static JimiRasterImage getRasterImage(InputStream inputstream, String s) throws JimiException {
        return Jimi.getRasterImage(inputstream, s, defaultFlags);
    }

    public static JimiRasterImage getRasterImage(InputStream inputstream, String s, int i) throws JimiException {
        JimiReader jimireader = new JimiReader(Jimi.getFactory(i), inputstream, s);
        return jimireader.getRasterImage();
    }

    public static JimiRasterImage getRasterImage(String s) throws JimiException {
        return Jimi.getRasterImage(s, defaultFlags);
    }

    public static JimiRasterImage getRasterImage(String s, int i) throws JimiException {
        JimiReader jimireader = new JimiReader(Jimi.getFactory(i), s);
        jimireader.setBlocking(JimiUtil.flagSet(i, 2));
        return jimireader.getRasterImage();
    }

    public static JimiRasterImage getRasterImage(URL url) throws JimiException {
        return Jimi.getRasterImage(url, defaultFlags);
    }

    public static JimiRasterImage getRasterImage(URL url, int i) throws JimiException {
        JimiReader jimireader = new JimiReader(Jimi.getFactory(i), url);
        return jimireader.getRasterImage();
    }

    public static JimiRasterImage getRasterImage(URL url, String s) throws JimiException {
        return Jimi.getRasterImage(url, s, defaultFlags);
    }

    public static JimiRasterImage getRasterImage(URL url, String s, int i) throws JimiException {
        JimiReader jimireader = new JimiReader(Jimi.getFactory(i), url, s);
        return jimireader.getRasterImage();
    }

    static void init() {
    }

    public static void main(String[] args) {
        block10: {
            block11: {
                block9: {
                    if (args.length == 0) {
                        System.err.println("Usage: Jimi <-version | -encoders | -decoders>");
                    }
                    if (!args[0].equals("-version")) break block9;
                    try {
                        Properties properties = new Properties();
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("com.sun.jimi.core.Jimi");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        properties.load(clazz.getResourceAsStream("version"));
                        System.out.println("Jimi version: " + properties.getProperty("jimi.version") + " (build " + properties.getProperty("jimi.build") + ")");
                    }
                    catch (Exception exception) {
                        System.err.println("Unable to read version information: " + exception.toString());
                    }
                    break block10;
                }
                if (!args[0].equals("-encoders")) break block11;
                System.out.println("Supported encoder mimetypes:");
                String[] args1 = Jimi.getEncoderTypes();
                int i = 0;
                while (i < args1.length) {
                    System.out.println(args1[i]);
                    ++i;
                }
                break block10;
            }
            if (!args[0].equals("-decoders")) break block10;
            System.out.println("Supported decoder mimetypes:");
            String[] args2 = Jimi.getDecoderTypes();
            int j = 0;
            while (j < args2.length) {
                System.out.println(args2[j]);
                ++j;
            }
        }
    }

    public static void putImage(JimiImage jimiimage, String s) throws JimiException {
        JimiWriter jimiwriter = new JimiWriter(s);
        jimiwriter.setSource(jimiimage);
        jimiwriter.putImage(s);
    }

    public static void putImage(Image image, String s) throws JimiException {
        Jimi.putImage(image.getSource(), s);
    }

    public static void putImage(ImageProducer imageproducer, String s) throws JimiException {
        Jimi.putImage(Jimi.createRasterImage(imageproducer), s);
    }

    public static void putImage(String s, JimiImage jimiimage, OutputStream outputstream) throws JimiException {
        JimiWriter jimiwriter = new JimiWriter(outputstream, s);
        jimiwriter.setSource(jimiimage);
        jimiwriter.putImage(outputstream);
    }

    public static void putImage(String s, JimiImage jimiimage, String s1) throws JimiException {
        JimiWriter jimiwriter = new JimiWriter(s1, s);
        jimiwriter.setSource(jimiimage);
        jimiwriter.putImage(s1);
    }

    public static void putImage(String s, Image image, OutputStream outputstream) throws JimiException {
        Jimi.putImage(s, image.getSource(), outputstream);
    }

    public static void putImage(String s, Image image, String s1) throws JimiException {
        JimiWriter jimiwriter = new JimiWriter(s1, s);
        jimiwriter.setSource(image);
        jimiwriter.putImage(s1);
    }

    public static void putImage(String s, ImageProducer imageproducer, OutputStream outputstream) throws JimiException {
        Jimi.putImage(s, (JimiImage)Jimi.createRasterImage(imageproducer), outputstream);
    }

    public static void putImage(String s, ImageProducer imageproducer, String s1) throws JimiException {
        JimiWriter jimiwriter = new JimiWriter(s1, s);
        jimiwriter.setSource(imageproducer);
        jimiwriter.putImage(s1);
    }

    public static void setDefaultFlags(int i) {
        defaultFlags = i;
    }
}

