/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core;

import com.sun.jimi.core.Jimi;
import com.sun.jimi.core.filters.AspectAdjustReplicateScaleFilter;
import com.sun.jimi.core.filters.AspectReplicateScaleFilter;
import com.sun.jimi.core.raster.JimiRasterImage;
import com.sun.jimi.core.util.JimiUtil;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.ImageProducer;
import java.io.InputStream;
import java.net.URL;

public class JimiUtils {
    public static ImageProducer aspectAdjust(JimiRasterImage jimiRasterImage) {
        if (jimiRasterImage == null) {
            return JimiUtil.getErrorImageProducer();
        }
        jimiRasterImage.waitInfoAvailable();
        if (jimiRasterImage.getProperties() == null) {
            return jimiRasterImage.getImageProducer();
        }
        if (jimiRasterImage.getProperties().get("fixedaspect") != null) {
            return jimiRasterImage.getImageProducer();
        }
        Object v = jimiRasterImage.getProperties().get("xres");
        Object v2 = jimiRasterImage.getProperties().get("yres");
        if (v != null && v2 != null && v instanceof Number && v2 instanceof Number) {
            double d;
            double d2 = ((Number)v).doubleValue();
            if (d2 == (d = ((Number)v2).doubleValue())) {
                return jimiRasterImage.getImageProducer();
            }
            AspectAdjustReplicateScaleFilter aspectAdjustReplicateScaleFilter = new AspectAdjustReplicateScaleFilter(d2, d);
            FilteredImageSource filteredImageSource = new FilteredImageSource(jimiRasterImage.getImageProducer(), (ImageFilter)aspectAdjustReplicateScaleFilter);
            return filteredImageSource;
        }
        return jimiRasterImage.getImageProducer();
    }

    public static Image getThumbnail(InputStream inputStream, int n, int n2, int n3) {
        return Toolkit.getDefaultToolkit().createImage(JimiUtils.getThumbnailProducer(inputStream, n, n2, n3));
    }

    public static Image getThumbnail(InputStream inputStream, int n, int n2, int n3, String string) {
        return Toolkit.getDefaultToolkit().createImage(JimiUtils.getThumbnailProducer(inputStream, n, n2, n3, string));
    }

    public static Image getThumbnail(String string, int n, int n2, int n3) {
        return Toolkit.getDefaultToolkit().createImage(JimiUtils.getThumbnailProducer(string, n, n2, n3));
    }

    public static Image getThumbnail(URL uRL, int n, int n2, int n3) {
        return Toolkit.getDefaultToolkit().createImage(JimiUtils.getThumbnailProducer(uRL, n, n2, n3));
    }

    public static ImageProducer getThumbnailProducer(InputStream inputStream, int n, int n2, int n3) {
        ImageProducer imageProducer = Jimi.getImageProducer(inputStream, n3);
        AspectReplicateScaleFilter aspectReplicateScaleFilter = new AspectReplicateScaleFilter(n, n2);
        FilteredImageSource filteredImageSource = new FilteredImageSource(imageProducer, (ImageFilter)aspectReplicateScaleFilter);
        return filteredImageSource;
    }

    public static ImageProducer getThumbnailProducer(InputStream inputStream, int n, int n2, int n3, String string) {
        ImageProducer imageProducer = Jimi.getImageProducer(inputStream, string, n3);
        AspectReplicateScaleFilter aspectReplicateScaleFilter = new AspectReplicateScaleFilter(n, n2);
        FilteredImageSource filteredImageSource = new FilteredImageSource(imageProducer, (ImageFilter)aspectReplicateScaleFilter);
        return filteredImageSource;
    }

    public static ImageProducer getThumbnailProducer(String string, int n, int n2, int n3) {
        ImageProducer imageProducer = Jimi.getImageProducer(string, n3);
        AspectReplicateScaleFilter aspectReplicateScaleFilter = new AspectReplicateScaleFilter(n, n2);
        FilteredImageSource filteredImageSource = new FilteredImageSource(imageProducer, (ImageFilter)aspectReplicateScaleFilter);
        return filteredImageSource;
    }

    public static ImageProducer getThumbnailProducer(URL uRL, int n, int n2, int n3) {
        ImageProducer imageProducer = Jimi.getImageProducer(uRL, n3);
        AspectReplicateScaleFilter aspectReplicateScaleFilter = new AspectReplicateScaleFilter(n, n2);
        FilteredImageSource filteredImageSource = new FilteredImageSource(imageProducer, (ImageFilter)aspectReplicateScaleFilter);
        return filteredImageSource;
    }
}

