/*
 * Decompiled with CFR 0.152.
 */
package quadbase.ChartAPI;

import quadbase.chart.Chart;
import quadbase.util.IColumnMap;
import quadbase.util.IMapConstants;

public class ColInfo
implements IColumnMap,
IMapConstants {
    public int value = -1;
    public int subvalue = -1;
    public int category = -1;
    public int series = -1;
    public int subseries = -1;
    public int sumBy = -1;
    public int xvalue = -1;
    public int yvalue = -1;
    public int zvalue = -1;
    public int high = -1;
    public int low = -1;
    public int open = -1;
    public int close = -1;
    int seriesDim = -1;
    int categoryDim = -1;
    int sumByDim = -1;

    public ColInfo() {
    }

    public ColInfo(int series, int category, int sumBy, int value) {
        this.series = series;
        this.category = category;
        this.sumBy = sumBy;
        this.value = value;
    }

    public ColInfo(int series, int category, int sumBy, int value, int subvalue) {
        this.series = series;
        this.category = category;
        this.sumBy = sumBy;
        this.value = value;
        this.subvalue = subvalue;
    }

    public ColInfo(int series, int[] values) {
        this.series = series;
        if (values.length >= 2) {
            this.xvalue = values[0];
            this.yvalue = values[1];
            if (values.length >= 3) {
                this.zvalue = values[2];
            }
        }
    }

    public ColInfo(int series, int category, int high, int low, int open, int close) {
        this.series = series;
        this.category = category;
        this.high = high;
        this.low = low;
        this.open = open;
        this.close = close;
    }

    public ColInfo(int series, int category, int high, int low, int open, int close, int subvalue) {
        this.series = series;
        this.category = category;
        this.high = high;
        this.low = low;
        this.open = open;
        this.close = close;
        this.subvalue = subvalue;
    }

    public ColInfo(int series, int category, int value, int sumBy, int high, int low, int open, int close, int subvalue, int subseries) {
        this.series = series;
        this.category = category;
        this.value = value;
        this.sumBy = sumBy;
        this.high = high;
        this.low = low;
        this.open = open;
        this.close = close;
        this.subvalue = subvalue;
        this.subseries = subseries;
    }

    ColInfo(Chart chart) {
        int[] map = chart.getDataMap();
        switch (chart.getChartType()) {
            case 2: 
            case 12: 
            case 13: {
                if (chart.getDataDimension() == 2) {
                    this.series = map[0];
                    this.seriesDim = 0;
                }
                int[] cmap = chart.getCoordMap();
                this.xvalue = cmap[0];
                this.yvalue = cmap[1];
                this.zvalue = cmap[2];
                break;
            }
            case 9: 
            case 10: 
            case 18: {
                if (chart.getDataDimension() == 2) {
                    this.series = map[0];
                    this.category = map[1];
                    this.seriesDim = 0;
                    this.categoryDim = 1;
                } else {
                    this.category = map[0];
                    this.categoryDim = 0;
                }
                this.high = chart.hilowCol.hi;
                this.low = chart.hilowCol.low;
                this.close = chart.hilowCol.close;
                this.open = chart.hilowCol.open;
                this.subvalue = chart.getSubValueMap();
                this.subseries = chart.getComboSeries();
                break;
            }
            default: {
                if (chart.isStackType()) {
                    if (chart.getDataDimension() == 2) {
                        this.category = map[0];
                        this.sumBy = map[1];
                        this.categoryDim = 0;
                        this.sumByDim = 1;
                    } else {
                        this.series = map[0];
                        this.category = map[1];
                        this.sumBy = map[2];
                        this.seriesDim = 0;
                        this.categoryDim = 1;
                        this.sumByDim = 2;
                    }
                } else if (chart.getDataDimension() == 1) {
                    this.category = map[0];
                    this.categoryDim = 0;
                } else {
                    this.series = map[0];
                    this.category = map[1];
                    this.seriesDim = 0;
                    this.categoryDim = 1;
                }
                this.value = chart.getValueMap();
                this.subvalue = chart.getSubValueMap();
                this.subseries = chart.getComboSeries();
            }
        }
    }

    public void setDataColumn(Chart chart) throws IllegalArgumentException {
        if (chart.getChartType() == 9 || chart.getChartType() == 10 || chart.getChartType() == 18) {
            chart.setDataColumn(this.series, this.category, -1, this.high, this.low, this.close, this.open, this.subvalue, this.subseries);
        } else {
            chart.setDataColumn(this.series, this.category, this.sumBy, this.value, this.xvalue, this.yvalue, this.zvalue, this.subvalue, this.subseries);
        }
    }

    @Override
    public final int getColumn(int map) {
        switch (map) {
            case 0: {
                return this.category;
            }
            case 1: {
                return this.series;
            }
            case 2: {
                return this.sumBy;
            }
            case 3: {
                return this.value;
            }
            case 4: {
                return this.subvalue;
            }
            case 5: {
                return this.xvalue;
            }
            case 6: {
                return this.yvalue;
            }
            case 7: {
                return this.zvalue;
            }
            case 8: {
                return this.high;
            }
            case 9: {
                return this.low;
            }
            case 10: {
                return this.open;
            }
            case 11: {
                return this.close;
            }
            case 12: {
                return this.subseries;
            }
        }
        return -1;
    }

    public boolean compare(ColInfo colInfo) {
        if (this.category != colInfo.category) {
            return false;
        }
        if (this.categoryDim != colInfo.categoryDim) {
            return false;
        }
        if (this.close != colInfo.close) {
            return false;
        }
        if (this.high != colInfo.high) {
            return false;
        }
        if (this.low != colInfo.low) {
            return false;
        }
        if (this.open != colInfo.open) {
            return false;
        }
        if (this.series != colInfo.series) {
            return false;
        }
        if (this.seriesDim != colInfo.seriesDim) {
            return false;
        }
        if (this.subseries != colInfo.subseries) {
            return false;
        }
        if (this.subvalue != colInfo.subvalue) {
            return false;
        }
        if (this.sumBy != colInfo.sumBy) {
            return false;
        }
        if (this.sumByDim != colInfo.sumByDim) {
            return false;
        }
        if (this.value != colInfo.value) {
            return false;
        }
        if (this.xvalue != colInfo.xvalue) {
            return false;
        }
        if (this.yvalue != colInfo.yvalue) {
            return false;
        }
        return this.zvalue == colInfo.zvalue;
    }

    public int hashCode() {
        int result = this.value;
        result = 31 * result + this.subvalue;
        result = 31 * result + this.category;
        result = 31 * result + this.series;
        result = 31 * result + this.subseries;
        result = 31 * result + this.sumBy;
        result = 31 * result + this.xvalue;
        result = 31 * result + this.yvalue;
        result = 31 * result + this.zvalue;
        result = 31 * result + this.high;
        result = 31 * result + this.low;
        result = 31 * result + this.open;
        result = 31 * result + this.close;
        result = 31 * result + this.seriesDim;
        result = 31 * result + this.categoryDim;
        result = 31 * result + this.sumByDim;
        return result;
    }
}

