/*
 * Decompiled with CFR 0.152.
 */
package quadbase.awt;

import java.applet.AppletContext;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import quadbase.awt.ArrowButton;
import quadbase.awt.PanelAction;
import quadbase.awt.SlideBar;

public class ArrowSlideBar
extends PanelAction {
    private ArrowButton leftbutton;
    private ArrowButton rightbutton;
    private SlideBar slideBar;
    private double step;

    public ArrowSlideBar(double min, double max, double step, boolean horz) {
        this.step = step;
        this.setLayout(new BorderLayout());
        this.slideBar = new SlideBar(min, max, !horz);
        if (horz) {
            this.leftbutton = new ArrowButton(2);
            this.rightbutton = new ArrowButton(3);
            this.add("West", this.leftbutton);
            this.add("East", this.rightbutton);
        } else {
            this.rightbutton = new ArrowButton(0);
            this.leftbutton = new ArrowButton(1);
            this.add("North", this.rightbutton);
            this.add("South", this.leftbutton);
        }
        this.add("Center", this.slideBar);
        this.slideBar.addActionListener(this);
        this.rightbutton.addActionListener(this);
        this.leftbutton.addActionListener(this);
    }

    public final void setValue(double value) {
        this.slideBar.setValue(value);
    }

    public final double getValue() {
        return this.slideBar.getValue();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.leftbutton) {
            this.setValue(this.getValue() - this.step);
        } else if (e.getSource() == this.rightbutton) {
            this.setValue(this.getValue() + this.step);
        }
        this.fireEvent(this, e.getID());
    }

    public final void setHint(AppletContext app, String hintText) {
        this.slideBar.setHint(app, hintText);
    }
}

