/*
 * Decompiled with CFR 0.152.
 */
package quadbase.awt;

import java.applet.AppletContext;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.image.FilteredImageSource;
import java.net.URL;
import quadbase.awt.GrayFilter;
import quadbase.awt.ImageLabel;

public class ImageButton
extends ImageLabel {
    protected static final int defaultBorderWidth = 2;
    protected static final Color defaultBorderColor = new Color(160, 160, 160);
    protected Image grayImage = null;
    public int darkness = -5263441;
    protected boolean pressed = false;
    String hintText;
    AppletContext app;

    public ImageButton() {
        this.setDefaults();
    }

    public ImageButton(String imageURLString) {
        super(imageURLString);
        this.setDefaults();
    }

    public ImageButton(URL imageURL) {
        super(imageURL);
        this.setDefaults();
    }

    public ImageButton(String imageString, boolean isURL) {
        super(imageString, isURL);
        this.setDefaults();
    }

    public ImageButton(Image image) {
        super(image);
        this.setDefaults();
    }

    public void setBorderWidth(int borderWidth) {
        this.margin = borderWidth;
    }

    public int getBorderWidth() {
        return this.margin;
    }

    public void setBorderColor(Color borderColor) {
        this.marginColor = borderColor;
    }

    public Color getBorderColor() {
        return this.marginColor;
    }

    @Override
    public void paint(Graphics g) {
        if (this.grayImage == null) {
            this.waitForImage(true);
            this.createGrayImage(g);
        }
        if (this.pressed) {
            if (this.explicitSize) {
                g.drawImage(this.grayImage, this.margin, this.margin, this.width - 2 * this.margin, this.height - 2 * this.margin, this);
            } else {
                g.drawImage(this.grayImage, this.margin, this.margin, this);
            }
            this.drawBorder(false, g);
        } else {
            super.paint(g);
            this.drawBorder(true, g);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.contains(e.getX(), e.getY())) {
            this.pressed = true;
            this.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.pressed = false;
        if (this.contains(e.getX(), e.getY())) {
            this.repaint();
            this.fireEvent(this, 0);
        }
    }

    protected void showHint(String s) {
        if (this.app != null) {
            this.app.showStatus(s);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.pressed) {
            this.repaint();
            this.pressed = false;
        }
        this.showHint("");
    }

    private void drawBorder(boolean isUp, Graphics g) {
        g.setColor(this.marginColor);
        int left = 0;
        int top = 0;
        int width = this.width;
        int height = this.height;
        for (int i = 0; i < this.margin; ++i) {
            g.draw3DRect(left, top, width, height, isUp);
            ++left;
            ++top;
            width -= 2;
            height -= 2;
        }
    }

    private void setDefaults() {
        this.margin = 2;
        this.marginColor = defaultBorderColor;
    }

    private void createGrayImage(Graphics g) {
        GrayFilter filter = new GrayFilter(this.darkness);
        FilteredImageSource producer = new FilteredImageSource(this.image.getSource(), filter);
        this.grayImage = this.createImage(producer);
        if (this.explicitSize) {
            g.drawImage(this.grayImage, this.margin, this.margin, this.width - 2 * this.margin, this.height - 2 * this.margin, this);
        } else {
            g.drawImage(this.grayImage, this.margin, this.margin, this);
        }
        super.paint(g);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.showHint(this.hintText);
    }

    public void setHint(AppletContext app, String hintText) {
        this.hintText = hintText;
        this.app = app;
    }
}

