/*
 * Decompiled with CFR 0.152.
 */
package quadbase.awt;

import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;
import java.util.Hashtable;

public class RotateFilter
extends ImageFilter {
    private static ColorModel defaultRGB = ColorModel.getRGBdefault();
    private double angle;
    private double sin;
    private double cos;
    private double[] coord = new double[2];
    private int[] raster;
    private int xoffset;
    private int yoffset;
    private int srcW;
    private int srcH;
    private int dstW;
    private int dstH;
    private int maskcolor = 0xFFFFFF;
    private boolean isFlash = false;

    public RotateFilter(double angle) {
        this(angle, false);
    }

    public RotateFilter(double angle, boolean isFlash) {
        this.isFlash = isFlash;
        this.angle = angle;
        this.sin = Math.sin(angle);
        this.cos = Math.cos(angle);
    }

    public final void reverseMask() {
        this.maskcolor = 0;
    }

    public void transform(double x, double y, double[] retcoord) {
        retcoord[0] = this.cos * x + this.sin * y;
        retcoord[1] = this.cos * y - this.sin * x;
    }

    public void itransform(double x, double y, double[] retcoord) {
        retcoord[0] = this.cos * x - this.sin * y;
        retcoord[1] = this.cos * y + this.sin * x;
    }

    public void transformBBox(Rectangle rect) {
        double minx = Double.POSITIVE_INFINITY;
        double miny = Double.POSITIVE_INFINITY;
        double maxx = Double.NEGATIVE_INFINITY;
        double maxy = Double.NEGATIVE_INFINITY;
        for (int y = 0; y <= 1; ++y) {
            for (int x = 0; x <= 1; ++x) {
                this.transform(rect.x + x * rect.width, rect.y + y * rect.height, this.coord);
                minx = Math.min(minx, this.coord[0]);
                miny = Math.min(miny, this.coord[1]);
                maxx = Math.max(maxx, this.coord[0]);
                maxy = Math.max(maxy, this.coord[1]);
            }
        }
        rect.x = (int)Math.floor(minx);
        rect.y = (int)Math.floor(miny);
        rect.width = (int)Math.ceil(maxx) - rect.x + 1;
        rect.height = (int)Math.ceil(maxy) - rect.y + 1;
    }

    @Override
    public void setDimensions(int width, int height) {
        Rectangle rect = new Rectangle(0, 0, width, height);
        this.transformBBox(rect);
        this.xoffset = -rect.x;
        this.yoffset = -rect.y;
        this.srcW = width;
        this.srcH = height;
        this.dstW = rect.width;
        this.dstH = rect.height;
        this.raster = new int[this.srcW * this.srcH];
        this.consumer.setDimensions(this.dstW, this.dstH);
    }

    public void setProperties(Hashtable props) {
        Object o = (props = (Hashtable)props.clone()).get("filters");
        if (o == null) {
            props.put("filters", this.toString());
        } else if (o instanceof String) {
            props.put("filters", (String)o + this.toString());
        }
        this.consumer.setProperties(props);
    }

    @Override
    public void setColorModel(ColorModel model) {
        this.consumer.setColorModel(defaultRGB);
    }

    @Override
    public void setHints(int hintflags) {
        this.consumer.setHints(0xE | hintflags & 0x10);
    }

    @Override
    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        int srcoff = off;
        int dstoff = y * this.srcW + x;
        for (int yc = 0; yc < h; ++yc) {
            for (int xc = 0; xc < w; ++xc) {
                int pixel = model.getRGB(pixels[srcoff++] & 0xFF);
                if (this.isFlash) {
                    this.raster[dstoff++] = pixel;
                    continue;
                }
                this.raster[dstoff++] = (pixel & 0xFFFFFF) == this.maskcolor ? 0 : pixel;
            }
            srcoff += scansize - w;
            dstoff += this.srcW - w;
        }
    }

    @Override
    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        int srcoff = off;
        int dstoff = y * this.srcW + x;
        for (int yc = 0; yc < h; ++yc) {
            for (int xc = 0; xc < w; ++xc) {
                int pixel = model.getRGB(pixels[srcoff++]);
                if (this.isFlash) {
                    this.raster[dstoff++] = pixel;
                    continue;
                }
                this.raster[dstoff++] = (pixel & 0xFFFFFF) == this.maskcolor ? 0 : pixel;
            }
            srcoff += scansize - w;
            dstoff += this.srcW - w;
        }
    }

    @Override
    public void imageComplete(int status) {
        if (status == 1 || status == 4) {
            this.consumer.imageComplete(status);
            return;
        }
        int[] pixels = new int[this.dstW];
        for (int dy = 0; dy < this.dstH; ++dy) {
            this.itransform(0 - this.xoffset, dy - this.yoffset, this.coord);
            double x1 = this.coord[0];
            double y1 = this.coord[1];
            this.itransform(this.dstW - this.xoffset, dy - this.yoffset, this.coord);
            double x2 = this.coord[0];
            double y2 = this.coord[1];
            double xinc = (x2 - x1) / (double)this.dstW;
            double yinc = (y2 - y1) / (double)this.dstW;
            for (int dx = 0; dx < this.dstW; ++dx) {
                int sx = (int)Math.round(x1);
                int sy = (int)Math.round(y1);
                pixels[dx] = sx < 0 || sy < 0 || sx >= this.srcW || sy >= this.srcH ? (this.isFlash ? this.maskcolor : 0) : this.raster[sy * this.srcW + sx];
                x1 += xinc;
                y1 += yinc;
            }
            this.consumer.setPixels(0, dy, this.dstW, 1, defaultRGB, pixels, 0, this.dstW);
        }
        this.consumer.imageComplete(status);
    }
}

