/*
 * Decompiled with CFR 0.152.
 */
package quadbase.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.FilteredImageSource;
import quadbase.awt.RotateFilter;
import quadbase.chart.CString;
import quadbase.common.util.internal.IFlashGraphics;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.IQbGraphics;
import quadbase.common.util.internal.QbUtil;
import quadbase.common.util.output.pdf.PdfGraphics2D;
import quadbase.util.internal.AffineTransformText;
import quadbase.util.internal.IWMFGraphics;

public class RotateText {
    private String text;
    private Point pos;
    private Color color;
    private Font font;
    private Component component;
    private Image rotImage;
    private double angle;
    private boolean isJ2DRotate = false;
    private Color bgColor = Color.white;
    private boolean isAdjustFont = true;

    public RotateText(String text, Component component) {
        this(text, component, 0, 0, 0.0, false);
    }

    public RotateText(String text, Component component, double angle) {
        this(text, component, 0, 0, angle, false);
    }

    public RotateText(String text, Component component, double angle, boolean isJ2DRotate) {
        this(text, component, 0, 0, angle, isJ2DRotate);
    }

    public RotateText(String text, Component component, int x, int y, double angle) {
        this(text, component, x, y, angle, false);
    }

    public RotateText(String text, Component component, int x, int y, double angle, boolean isJ2DRotate) {
        this(text, component, x, y, angle, isJ2DRotate, false);
    }

    public RotateText(String text, Component component, int x, int y, double angle, boolean isJ2DRotate, boolean isAdjustFont) {
        this.text = text;
        this.angle = angle * Math.PI / 180.0;
        this.component = component;
        this.pos = new Point(x, y);
        this.isJ2DRotate = isJ2DRotate;
        this.color = Color.black;
        this.font = QbUtil.getDefaultFont(new Font("TimesRoman", 0, 8), new Font("Arial", 0, 8));
        this.isAdjustFont = isAdjustFont;
    }

    public void setJava2DRotateTextEnabled(boolean b) {
        this.isJ2DRotate = b;
    }

    public boolean isJava2DRotateTextEnabled() {
        return this.isJ2DRotate;
    }

    public void setAdjustFont(boolean b) {
        this.isAdjustFont = b;
    }

    public boolean isAdjustFont() {
        return this.isAdjustFont;
    }

    public void setString(String text) {
        this.text = text;
        this.rotImage = null;
    }

    public String getString() {
        return this.text;
    }

    public void setComponent(Component component) {
        this.component = component;
        this.rotImage = null;
    }

    public Component getComponent() {
        return this.component;
    }

    public void setPos(int x, int y) {
        this.pos = new Point(x, y);
    }

    public Point getPos() {
        return this.pos;
    }

    public void setFont(Font _font) {
        this.font = _font;
        this.rotImage = null;
    }

    public Font getFont() {
        return this.font;
    }

    public void setColor(Color _color) {
        this.color = _color;
        this.rotImage = null;
    }

    public Color getColor() {
        return this.color;
    }

    public void setAngle(double _angle) {
        this.angle = _angle * Math.PI / 180.0;
        this.rotImage = null;
    }

    public double getAngle() {
        return this.angle * 180.0 / Math.PI;
    }

    public Image getImage() {
        return this.rotImage;
    }

    public void invalidate() {
        this.rotImage = null;
    }

    public int getWidth() {
        return this.rotImage == null ? 0 : this.rotImage.getWidth(null);
    }

    public int getHeight() {
        return this.rotImage == null ? 0 : this.rotImage.getHeight(null);
    }

    public void prepareImage(Graphics g) {
        if (g instanceof IWMFGraphics) {
            return;
        }
        try {
            Frame f;
            Image image;
            FontMetrics fm;
            Font oldfont = g.getFont();
            Font newFont = QbUtil.resizeViewerFont(this.font, this.isAdjustFont);
            if (g instanceof PdfGraphics2D) {
                ((PdfGraphics2D)g).setFont(newFont, IOUtil.containsUnicode(this.text));
                fm = ((PdfGraphics2D)g).getFontMetrics(newFont, IOUtil.containsUnicode(this.text));
            } else {
                g.setFont(newFont);
                fm = g.getFontMetrics();
            }
            String[] str = CString.tokenizer(this.text);
            int height = (fm.getMaxAscent() + fm.getMaxDescent()) * str.length;
            int width = RotateText.getCharsWidth(str, fm);
            int imagesize = height * width;
            if (imagesize == 0) {
                height = 1;
                width = 1;
            }
            if ((image = IOUtil.getOffScreenImage(this.component, width, height)) == null) {
                f = new Frame();
                f.addNotify();
                image = f.createImage(width, height);
                f.removeNotify();
            }
            Graphics gbuffer = image.getGraphics();
            RotateFilter rotfilter = new RotateFilter(this.angle, g instanceof IFlashGraphics);
            if (this.color.getRed() + this.color.getGreen() + this.color.getBlue() < 384) {
                this.bgColor = Color.white;
                gbuffer.setColor(this.bgColor);
            } else {
                this.bgColor = Color.black;
                gbuffer.setColor(this.bgColor);
                rotfilter.reverseMask();
            }
            gbuffer.fillRect(0, 0, width, height);
            gbuffer.setFont(newFont);
            gbuffer.setColor(this.color);
            for (int i = 0; i < str.length; ++i) {
                gbuffer.drawString(str[i], 0, fm.getMaxAscent() + (fm.getMaxAscent() + fm.getMaxDescent()) * i);
            }
            FilteredImageSource prod = new FilteredImageSource(image.getSource(), rotfilter);
            if (this.rotImage != null) {
                this.rotImage.flush();
            }
            if (this.component != null) {
                this.rotImage = this.component.createImage(prod);
            } else {
                f = new Frame();
                f.addNotify();
                this.rotImage = f.createImage(prod);
                f.removeNotify();
            }
            if (System.getProperty("java.vendor").indexOf("IBM") < 0 && System.getProperty("java.vendor.url").indexOf("ibm") < 0) {
                image.flush();
            }
            g.setFont(oldfont);
            gbuffer.dispose();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static int getCharsWidth(String[] list, FontMetrics fm) {
        int max = 0;
        for (String element : list) {
            int width = fm.charsWidth(element.toCharArray(), 0, element.length());
            if (width <= max) continue;
            max = width;
        }
        return max;
    }

    public void draw(Graphics g) {
        Font newFont = QbUtil.resizeViewerFont(this.font, this.isAdjustFont);
        if (g instanceof IWMFGraphics) {
            Font oldfont = g.getFont();
            g.setFont(newFont);
            String[] str = CString.tokenizer(this.text);
            FontMetrics fm = g.getFontMetrics();
            g.setColor(this.color);
            int degree = (int)(this.angle * 180.0 * 10.0 / Math.PI % 3600.0);
            int height = fm.getMaxAscent() + fm.getMaxDescent();
            for (int i = 0; i < str.length; ++i) {
                int width = fm.charsWidth(str[i].toCharArray(), 0, str[i].length());
                int offsetx = (int)((double)(height * i) * Math.sin(this.toRadian(degree)));
                int offsety = (int)((double)(height * i) * Math.cos(this.toRadian(degree)));
                int dx = 0;
                int dy = 0;
                if (degree == 0) {
                    dy = height;
                } else if (degree <= 200) {
                    dx = height * 4 / 5;
                    dy = width * 1 / 2;
                } else if (degree <= 400) {
                    dx = height * 4 / 5;
                    dy = width * 2 / 3;
                } else if (degree <= 900) {
                    dx = height * 7 / 20;
                    dy = width;
                } else if (degree < 1800) {
                    dx = width;
                    dy = width;
                } else if (degree < 2250) {
                    dx = width;
                } else if (degree <= 2700) {
                    dx = height * 1 / 3;
                }
                ((IWMFGraphics)((Object)g)).setFontEscapement(degree);
                g.drawString(str[i], this.pos.x + dx + offsetx, this.pos.y + dy + offsety);
                ((IWMFGraphics)((Object)g)).reset();
            }
            g.setFont(oldfont);
        } else if (g instanceof IFlashGraphics) {
            float degree = 360.0f - (float)(this.angle * 180.0 / Math.PI % 360.0);
            ((IFlashGraphics)((Object)g)).drawRotateString(this.text, newFont, this.color, degree, this.pos.x, this.pos.y);
        } else if (g instanceof IQbGraphics) {
            float degree = (float)(this.angle * 180.0 / Math.PI % 360.0);
            ((IQbGraphics)((Object)g)).drawRotateString(this.text, newFont, this.isJ2DRotate, this.color, degree, this.pos.x, this.pos.y);
        } else if (IOUtil.isJava2D() && this.isJ2DRotate) {
            FontMetrics fm;
            Font oldfont = g.getFont();
            if (g instanceof PdfGraphics2D) {
                ((PdfGraphics2D)g).setFont(newFont, IOUtil.containsUnicode(this.text));
                fm = ((PdfGraphics2D)g).getFontMetrics(newFont, IOUtil.containsUnicode(this.text));
            } else {
                g.setFont(newFont);
                fm = g.getFontMetrics();
            }
            int degree = (int)(this.angle * 180.0 * 10.0 / Math.PI % 3600.0);
            int height = fm.getMaxAscent() + fm.getMaxDescent();
            int dx = 0;
            int dy = 0;
            String[] str = CString.tokenizer(this.text);
            int width = 0;
            for (String element : str) {
                int wid = fm.charsWidth(element.toCharArray(), 0, element.length());
                if (wid <= width) continue;
                width = wid;
            }
            if (degree != 0 && degree > 500) {
                if (degree <= 950) {
                    dy = -(height / 2 * str.length);
                } else if (degree <= 1400) {
                    dy = height;
                    dx = -width;
                } else if (degree <= 1850) {
                    dx = width;
                    dy = height * str.length;
                } else if (degree <= 2300) {
                    dx = width;
                    dy = height / 2 * str.length;
                } else if (degree <= 2750) {
                    dy = -(height * str.length);
                } else if (degree <= 3200) {
                    dy = -(height / 2 * str.length);
                }
            }
            this.pos.x += dx;
            this.pos.y += dy;
            AffineTransformText.setRotateText(g, this.text, this.angle, this.pos, newFont, this.color);
            g.setFont(oldfont);
        } else {
            if (this.rotImage == null) {
                this.prepareImage(g);
            }
            if (this.rotImage != null) {
                g.drawImage(this.rotImage, this.pos.x, this.pos.y, null);
            }
        }
    }

    private double toRadian(int degree) {
        return (double)degree / 1800.0 * Math.PI;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<< RotateText >>\n");
        sb.append("text\t= " + this.text + "\n");
        sb.append("pos\t = " + this.pos.toString() + "\n");
        sb.append("color\t= " + this.color + "\n");
        sb.append("font\t= " + this.font + "\n");
        sb.append("angle\t= " + this.angle + "\n");
        return sb.toString();
    }
}

