/*
 * Decompiled with CFR 0.152.
 */
package quadbase.awt;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.TextArea;
import java.util.StringTokenizer;
import java.util.Vector;

public class TextParagraph
extends TextArea {
    static final String DELIMITERS = " \n\t\r[];:";

    public TextParagraph(int rows, int cols) {
        super(rows, cols);
    }

    @Override
    public void setText(String text) {
        if (text == null) {
            return;
        }
        FontMetrics fm = this.getFontMetrics(this.getFont());
        Dimension d = this.getSize();
        if (d.width <= 1) {
            d.width = 300;
        }
        StringTokenizer st = new StringTokenizer(text, DELIMITERS, true);
        Vector<String> token = new Vector<String>();
        while (st.hasMoreTokens()) {
            token.addElement(st.nextToken());
        }
        StringBuffer sb = new StringBuffer();
        int totalLen = 0;
        int nToken = token.size();
        for (int i = 0; i < nToken; ++i) {
            String currentToken = (String)token.elementAt(i);
            int currentLen = fm.stringWidth(currentToken);
            if (totalLen + currentLen > d.width) {
                if (currentToken.equals("\r") || currentToken.equals("\n")) {
                    sb.append("\n");
                    totalLen = 0;
                    continue;
                }
                sb.append(currentToken);
                continue;
            }
            sb.append(currentToken);
            totalLen += currentLen;
        }
        super.setText(sb.toString());
    }
}

