/*
 * Decompiled with CFR 0.152.
 */
package quadbase.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Panel;

public class VerticalLayout
implements LayoutManager {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    int align;
    int hgap;
    int vgap;

    public VerticalLayout() {
        this(0, 5, 5);
    }

    public VerticalLayout(int align) {
        this(align, 5, 5);
    }

    public VerticalLayout(int align, int hgap, int vgap) {
        this.align = align;
        this.hgap = hgap;
        this.vgap = vgap;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container target) {
        Dimension dim = new Dimension(0, 0);
        int nmembers = target.getComponentCount();
        for (int i = 0; i < nmembers; ++i) {
            Component m = target.getComponent(i);
            if (!m.isVisible()) continue;
            Dimension d = m.getPreferredSize();
            dim.height += d.height;
            if (i > 0) {
                dim.height += this.vgap;
            }
            dim.width = Math.max(dim.width, d.width);
        }
        Insets insets = target.getInsets();
        dim.width += insets.left + insets.right + this.hgap * 2;
        dim.height += insets.top + insets.bottom + this.vgap * 2;
        return dim;
    }

    @Override
    public Dimension minimumLayoutSize(Container target) {
        Dimension dim = new Dimension(0, 0);
        int nmembers = target.getComponentCount();
        for (int i = 0; i < nmembers; ++i) {
            Component m = target.getComponent(i);
            if (!m.isVisible()) continue;
            Dimension d = m.getMinimumSize();
            dim.height += d.height;
            if (i > 0) {
                dim.height += this.vgap;
            }
            dim.width = Math.max(dim.width, d.width);
        }
        Insets insets = target.getInsets();
        dim.width += insets.left + insets.right + this.hgap * 2;
        dim.height += insets.top + insets.bottom + this.vgap * 2;
        return dim;
    }

    @Override
    public void layoutContainer(Container target) {
        Insets insets = target.getInsets();
        int maxwidth = target.getSize().width - (insets.left + insets.right + this.hgap * 2);
        int nmembers = target.getComponentCount();
        int y = insets.top + this.vgap;
        for (int i = 0; i < nmembers; ++i) {
            Component m = target.getComponent(i);
            if (!m.isVisible()) continue;
            Dimension d = m.getPreferredSize();
            int x = insets.left + this.hgap;
            switch (this.align) {
                case 1: {
                    x += (maxwidth - d.width) / 2;
                    break;
                }
                case 2: {
                    x += maxwidth - d.width;
                }
            }
            m.setBounds(x, y, d.width, d.height);
            y += d.height + this.vgap;
        }
    }

    public static Panel newVerticalPanel() {
        Panel panel = new Panel();
        panel.setLayout(new VerticalLayout(0, 5, 2));
        return panel;
    }
}

