/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.awt.Color;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Vector;
import quadbase.chart.CAnnotation;
import quadbase.chart.CGraphics;
import quadbase.chart.Chart;
import quadbase.chart.DataLine;
import quadbase.chart.DataLineSet;
import quadbase.util.IAnnotation;
import quadbase.util.IAnnotationSet;
import quadbase.util.IReferenceObj;

public class AnnotationSet
implements IAnnotationSet {
    private Chart chart;
    private Vector<IAnnotation> annotationList;

    public AnnotationSet(Chart chart) {
        this.chart = chart;
    }

    public AnnotationSet(Chart chart, AnnotationSet set) {
        this.chart = chart;
        Vector<IAnnotation> target = set.getAnnotationList();
        if (target != null) {
            this.annotationList = new Vector();
            int nAnno = target.size();
            for (int i = 0; i < nAnno; ++i) {
                CAnnotation tempAnno = ((CAnnotation)target.elementAt(i)).copy(chart);
                IReferenceObj refObj = tempAnno.getReferenceObject();
                if (refObj != null && refObj instanceof Chart) {
                    tempAnno.setReferenceObject(chart);
                }
                tempAnno.setChart(chart);
                this.addAnnotation(tempAnno);
            }
        }
    }

    @Override
    public final Vector<IAnnotation> getAnnotationList() {
        return this.annotationList;
    }

    @Override
    public IAnnotation newAnnotation(String text) {
        return new CAnnotation(this.chart, (IReferenceObj)this.chart, text);
    }

    @Override
    public IAnnotation newAnnotation(String[] text) {
        return new CAnnotation(this.chart, (IReferenceObj)this.chart, text);
    }

    @Override
    public IAnnotation newAnnotation(String[] text, int[] shape, Color[] color) {
        return new CAnnotation(this.chart, this.chart, text, shape, color);
    }

    @Override
    public IAnnotation newAnnotation(String text, IReferenceObj refObj) {
        return new CAnnotation(this.chart, refObj, text);
    }

    @Override
    public IAnnotation newAnnotation(String[] text, IReferenceObj refObj) {
        return new CAnnotation(this.chart, refObj, text);
    }

    @Override
    public IAnnotation newAnnotation(String[] text, int[] shape, Color[] color, IReferenceObj refObj) {
        return new CAnnotation(this.chart, refObj, text, shape, color);
    }

    @Override
    public final void addAnnotation(IAnnotation anno) {
        if (this.annotationList == null) {
            this.annotationList = new Vector();
        }
        this.annotationList.addElement(anno);
    }

    @Override
    public final boolean removeAnnotation(IAnnotation anno) {
        if (this.annotationList == null) {
            return false;
        }
        return this.annotationList.removeElement(anno);
    }

    public Vector<IAnnotation> getAllAnnotations() {
        Vector<IAnnotation> list = new Vector<IAnnotation>();
        int nAnno = this.annotationList == null ? 0 : this.annotationList.size();
        for (int i = 0; i < nAnno; ++i) {
            list.addElement(this.annotationList.elementAt(i));
        }
        DataLineSet dlSet = this.chart.dataLineSet;
        int nDataLine = dlSet == null ? 0 : dlSet.getSize();
        for (int i = 0; i < nDataLine; ++i) {
            DataLine dLine = dlSet.elementAt(i);
            Vector<IAnnotation> annoVector = dLine.getAnnotations();
            if (annoVector == null) continue;
            nAnno = annoVector.size();
            for (int j = 0; j < nAnno; ++j) {
                list.addElement(annoVector.elementAt(j));
            }
        }
        return list;
    }

    public void invalidate() {
        Vector<IAnnotation> list = this.getAllAnnotations();
        int nAnno = list.size();
        for (int i = 0; i < nAnno; ++i) {
            ((CAnnotation)list.elementAt(i)).invalidate();
        }
    }

    public final void draw(CGraphics g) {
        Vector<IAnnotation> list = this.getAllAnnotations();
        int nAnno = list.size();
        for (int i = 0; i < nAnno; ++i) {
            ((CAnnotation)list.elementAt(i)).draw(g);
        }
    }

    CAnnotation select(CGraphics g, int x, int y) {
        if (this.annotationList == null) {
            return null;
        }
        int nAnno = this.annotationList.size();
        for (int i = 0; i < nAnno; ++i) {
            CAnnotation annoObj = (CAnnotation)this.annotationList.elementAt(i);
            if (annoObj.selectPart(g, x, y) == null) continue;
            return annoObj;
        }
        return null;
    }

    public void write(DataOutput dout) throws IOException {
        int size = this.annotationList == null ? 0 : this.annotationList.size();
        dout.writeInt(size);
        for (int i = 0; i < size; ++i) {
            IAnnotation target = this.annotationList.elementAt(i);
            if (!(target instanceof CAnnotation)) continue;
            ((CAnnotation)target).write(dout);
        }
    }

    public void read(DataInput din, int version) throws IOException {
        if (version > 70) {
            int size = din.readInt();
            for (int i = 0; i < size; ++i) {
                this.addAnnotation(CAnnotation.read(din, version, this.chart, this.chart));
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<< AnnotationSet >>\n");
        int size = this.annotationList == null ? 0 : this.annotationList.size();
        sb.append("size\t\t= " + size + "\n");
        for (int i = 0; i < size; ++i) {
            sb.append(this.annotationList.elementAt(i));
        }
        return sb.toString();
    }
}

