/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.awt.Color;
import quadbase.chart.CGraphics;
import quadbase.chart.GradientSupport;
import quadbase.chart.Line;
import quadbase.chart.MultiDimData;
import quadbase.chart.Point3D;
import quadbase.common.util.internal.IFlashGraphics;
import quadbase.util.IGradientPropertySet;
import quadbase.util.IGradientSupport;
import quadbase.util.internal.IOUtil;
import quadbase.util.internal.IWMFGraphics;

public abstract class Area
implements IGradientPropertySet {
    public static final int NONE = 0;
    public static final int RAISE = 1;
    public static final int LOWER = 2;
    public static final int SHADOW = 3;
    public static final int CUT_CORNER = 4;
    public Color areaColor;
    public Color borderColor = Color.black;
    public boolean drawBorder = false;
    public boolean drawBlackBorder = false;
    public boolean drawArea = true;
    public boolean automatic = true;
    public boolean is2D = true;
    public Point3D p1;
    public Point3D p2;
    public int appearance = 1;
    public int depth = 1;
    public int cornerArea = 12;
    public static int DCXAXIS = 0;
    public static int DCYAXIS = 1;
    private boolean isGradientOn = false;
    private boolean is3DShadingOn = false;
    private double gradientStartX = 0.0;
    private double gradientStartY = 0.0;
    private double gradientEndX = 1.0;
    private double gradientEndY = 1.0;
    private Color gradientDesColor = null;
    private int gradientShade = -2;
    private boolean gradientCyclic = true;

    public Area() {
        this.areaColor = Color.orange;
        this.p1 = new Point3D();
        this.p2 = new Point3D();
    }

    public Area(Color c) {
        this.areaColor = c;
        this.p1 = new Point3D();
        this.p2 = new Point3D();
    }

    public abstract Object getFaceList();

    public abstract Object getFaceList(int var1);

    public void setAppearance(int appear) {
        if (appear < 0) {
            appear = 0;
        } else if (appear > 4) {
            appear = 4;
        }
        this.appearance = appear;
    }

    public void setCutCornerWidth(int cutCorner) {
        this.cornerArea = cutCorner;
    }

    public int getCutCornerWidth() {
        return this.cornerArea;
    }

    public int getAppearance() {
        return this.appearance;
    }

    public void copy(Area area) {
        this.areaColor = area.areaColor;
        this.borderColor = area.borderColor;
        this.automatic = area.automatic;
        this.is2D = area.is2D;
        this.drawBorder = area.drawBorder;
        this.drawBlackBorder = area.drawBlackBorder;
        this.drawArea = area.drawArea;
        this.appearance = area.appearance;
        this.depth = area.depth;
        this.cornerArea = area.cornerArea;
        this.p1 = area.p1.copy();
        this.p2 = area.p2.copy();
        this.isGradientOn = area.isGradientOn;
        this.is3DShadingOn = area.is3DShadingOn;
        this.gradientStartX = area.gradientStartX;
        this.gradientStartY = area.gradientStartY;
        this.gradientEndX = area.gradientEndX;
        this.gradientEndY = area.gradientEndY;
        this.gradientDesColor = area.gradientDesColor;
        this.gradientShade = area.gradientShade;
        this.gradientCyclic = area.gradientCyclic;
    }

    public Area copyArea(Area newArea) {
        newArea.areaColor = this.areaColor;
        newArea.automatic = this.automatic;
        newArea.is2D = this.is2D;
        newArea.p1 = this.p1.copy();
        newArea.p2 = this.p2.copy();
        newArea.drawBorder = this.drawBorder;
        newArea.drawBlackBorder = this.drawBlackBorder;
        newArea.drawArea = this.drawArea;
        newArea.depth = this.depth;
        newArea.cornerArea = this.cornerArea;
        newArea.appearance = this.appearance;
        newArea.isGradientOn = this.isGradientOn;
        newArea.is3DShadingOn = this.is3DShadingOn;
        newArea.gradientStartX = this.gradientStartX;
        newArea.gradientStartY = this.gradientStartY;
        newArea.gradientEndX = this.gradientEndX;
        newArea.gradientEndY = this.gradientEndY;
        newArea.gradientDesColor = this.gradientDesColor;
        newArea.gradientShade = this.gradientShade;
        newArea.gradientCyclic = this.gradientCyclic;
        return newArea;
    }

    public final boolean select(CGraphics g, int x, int y) {
        return this.drawArea && Area.inside(this.p1.x, g.height - this.p1.y, this.p2.x, g.height - this.p2.y, x, y);
    }

    public static final boolean inside(int x1, int y1, int x2, int y2, int x, int y) {
        int ymax;
        int ymin;
        int xmax;
        int xmin;
        if (x1 >= x2) {
            xmin = x2;
            xmax = x1;
        } else {
            xmin = x1;
            xmax = x2;
        }
        if (y1 >= y2) {
            ymin = y2;
            ymax = y1;
        } else {
            ymin = y1;
            ymax = y2;
        }
        return xmin <= x && x <= xmax && ymin <= y && y <= ymax;
    }

    public final boolean borderSelect(CGraphics g, int x, int y) {
        y = g.height - y;
        return this.drawBorder && (Line.pickLine(this.p1.x, this.p1.y, this.p2.x, this.p1.y, x, y) || Line.pickLine(this.p2.x, this.p1.y, this.p2.x, this.p2.y, x, y) || Line.pickLine(this.p2.x, this.p2.y, this.p1.x, this.p2.y, x, y) || Line.pickLine(this.p1.x, this.p2.y, this.p1.x, this.p1.y, x, y));
    }

    public void setpos(int x1, int y1, int x2, int y2) {
        this.p1.x = x1;
        this.p1.y = y1;
        this.p2.x = x2;
        this.p2.y = y2;
        this.is2D = true;
    }

    public void setpos(int x1, int y1, int z1, int x2, int y2, int z2) {
        this.p1.x = x1;
        this.p1.y = y1;
        this.p1.z = z1;
        this.p2.x = x2;
        this.p2.y = y2;
        this.p2.z = z2;
        this.is2D = true;
    }

    public abstract void prepare3D(Object var1, Area var2, Object var3);

    public void setColor(Color color) {
        this.areaColor = color;
    }

    public abstract void setColor(Object var1, Color var2);

    @Override
    public boolean isGradientEnabled() {
        return this.isGradientOn && IOUtil.isJava2D();
    }

    @Override
    public void setGradientEnabled(boolean b) {
        this.isGradientOn = b;
    }

    @Override
    public boolean is3DShadingEnabled() {
        return this.is3DShadingOn && IOUtil.isJava2D();
    }

    @Override
    public void set3DShadingEnabled(boolean b) {
        this.is3DShadingOn = b;
    }

    @Override
    public double getGradientStartX() {
        return this.gradientStartX;
    }

    @Override
    public double getGradientStartY() {
        return this.gradientStartY;
    }

    @Override
    public double getGradientEndX() {
        return this.gradientEndX;
    }

    @Override
    public double getGradientEndY() {
        return this.gradientEndY;
    }

    @Override
    public Color getGradientDesColor() {
        return this.gradientDesColor;
    }

    @Override
    public int getGradientShade() {
        return this.gradientShade;
    }

    @Override
    public boolean isGradientCyclic() {
        return this.gradientCyclic;
    }

    @Override
    public void setGradientStartX(double x) {
        this.gradientStartX = x;
    }

    @Override
    public void setGradientStartY(double y) {
        this.gradientStartY = y;
    }

    @Override
    public void setGradientEndX(double x) {
        this.gradientEndX = x;
    }

    @Override
    public void setGradientEndY(double y) {
        this.gradientEndY = y;
    }

    @Override
    public void setGradientDesColor(Color c) {
        this.gradientDesColor = c;
    }

    @Override
    public void setGradientShade(int s) {
        this.gradientShade = s;
    }

    @Override
    public void setGradientCyclic(boolean c) {
        this.gradientCyclic = c;
    }

    public void draw(CGraphics g) {
        this.draw(g, this, null);
    }

    public void draw(CGraphics g, Area area, MultiDimData data) {
        this.draw(g, area, data, true);
    }

    public void draw(CGraphics g, Area area, MultiDimData data, boolean drawShadow) {
        GradientSupport gradientSupport = null;
        if (data != null) {
            gradientSupport = data.chart.getPrimaryDataGradientSupport();
            if (data.isSecondary()) {
                gradientSupport = g.chart.getSecondaryDataGradientSupport();
            }
        }
        this.draw(g, area, data, drawShadow, gradientSupport);
    }

    public void draw(CGraphics g, Area area, MultiDimData data, boolean drawShadow, IGradientSupport gradSupport) {
        if (this.drawBlackBorder) {
            drawShadow = false;
        }
        if (gradSupport == null && area != null) {
            gradSupport = area;
        }
        if (this.drawArea) {
            g.setColor(area.areaColor);
            if (this.is2D) {
                if (g.chart.isDrawBorderForWMF() && g.g instanceof IWMFGraphics) {
                    ((IWMFGraphics)((Object)g.g)).setDrawBorderFor3DRect(true);
                    g.fillArea(this.p1.x, this.p1.y, this.p2.x, this.p2.y, drawShadow ? this.appearance : 0, this.depth, data, this.appearance == 4, this.cornerArea, gradSupport);
                    ((IWMFGraphics)((Object)g.g)).setDrawBorderFor3DRect(false);
                } else {
                    g.fillArea(this.p1.x, this.p1.y, this.p2.x, this.p2.y, drawShadow ? this.appearance : 0, this.depth, data, this.appearance == 4, this.cornerArea, gradSupport);
                }
            }
        }
        boolean setToolTipsForFlash = false;
        if (g.g instanceof IFlashGraphics) {
            ((IFlashGraphics)((Object)g.g)).setToolTipsAndLink(data);
            setToolTipsForFlash = true;
        }
        if (this.drawBorder) {
            this.doDrawBorder(g, area.areaColor);
        }
        if (this.drawBlackBorder) {
            this.doDrawBorder(g, this.borderColor);
        }
        if (g.chart.isDrawBorderForWhiteArea() && area.areaColor.getRGB() == Color.white.getRGB()) {
            this.doDrawBorder(g, this.borderColor);
        }
        if (setToolTipsForFlash) {
            ((IFlashGraphics)((Object)g.g)).resetToolTipsAndLink();
        }
    }

    private void doDrawBorder(CGraphics g, Color c) {
        g.setColor(c);
        g.drawBorder(this.p1.x, this.p1.y, this.p2.x, this.p2.y, this.depth, this.appearance == 4, this.cornerArea);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<< Area >>\n");
        sb.append("color\t\t= " + this.areaColor + "\n");
        sb.append("drawBorder\t= " + this.drawBorder + "\n");
        sb.append("drawArea\t= " + this.drawArea + "\n");
        sb.append("automatic\t= " + this.automatic + "\n");
        sb.append("is2D\t\t= " + this.is2D + "\n");
        sb.append("p1\t\t= " + this.p1 + "\n");
        sb.append("p2\t\t= " + this.p2 + "\n");
        sb.append("appearance\t= " + this.appearance + "\n");
        sb.append("depth\t\t= " + this.depth + "\n");
        return sb.toString();
    }
}

