/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Polygon;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import quadbase.chart.CGraphics;
import quadbase.chart.CString;
import quadbase.chart.ColData;
import quadbase.chart.Grid;
import quadbase.chart.Point3D;
import quadbase.chart.StepSize;
import quadbase.chart.Ticker;
import quadbase.chart.chart2d.Grid2D;
import quadbase.chart.chart2d.Ticker2D;
import quadbase.common.util.internal.DataType;
import quadbase.util.internal.DateTime;

public abstract class Axis {
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = 2;
    public static final int S = 3;
    public static final int SCALE_STEP_DATE_DYNAMIC = -99;
    public static final long SCALE_STEP_DAY = 86400000L;
    public static final int FORWARD_ARROW = 0;
    public static final int REVERSE_ARROW = 1;
    public static final int DOUBLE_ARROW = 2;
    protected static final int DELTA = 5;
    protected static final float DELTA2 = 0.5f;
    public Point startp;
    public Point endp;
    public int thickness;
    public int gridThickness = 1;
    public int gridLineStyle = 0;
    public boolean skipGridOffset = false;
    public int orient;
    public int xorigin;
    public int yorigin;
    public double axisShift;
    public Color color;
    public Grid grid;
    public Ticker ticker;
    public CString title;
    public boolean bshow = true;
    public boolean is3D = false;
    public int arrowType;
    public boolean showTicker = true;
    public boolean xyzchart = false;
    public boolean reversexlabel = false;
    public boolean xAtTop = false;
    public Font font = CString.defaultfont;
    public boolean showTitleTicker = true;
    public int titleoffset = 5;
    public int titlevoffset = 0;
    public boolean autoscale = true;
    public boolean autoOrigin = false;
    public static boolean DEFAULTADDAXISPADDING = true;
    public static boolean DEFAULTAUTOSCALEFORVALLESSTHAN1 = true;
    public static boolean DEFAULTUSEINTVALUEFORAUTOSCALE = false;
    public boolean addAxisPadding = DEFAULTADDAXISPADDING;
    public boolean autoScaleForValLessThan1 = DEFAULTAUTOSCALEFORVALLESSTHAN1;
    public boolean useIntValueForAutoScale = DEFAULTUSEINTVALUEFORAUTOSCALE;
    boolean isLabelOutsidePlotArea = false;
    public double maxScale = 0.0;
    public double minScale = 0.0;
    public double stepScale = 1.0;
    public int stepScaleMonth = 0;
    public StepSize stepsize;
    public boolean logScale = false;
    private boolean isShowLogValue = false;
    private boolean isShowSubTickers = false;
    protected double logBase = 10.0;
    public ColData columnField = null;
    private boolean dynamicAutoScale = false;
    public boolean displayLabelAsDate = false;
    private boolean isDateTimeColumn = false;
    private boolean timeChart = false;

    public Axis(int direction, CString name) {
        this.addAxisPadding = DEFAULTADDAXISPADDING;
        this.autoScaleForValLessThan1 = DEFAULTAUTOSCALEFORVALLESSTHAN1;
        this.useIntValueForAutoScale = DEFAULTUSEINTVALUEFORAUTOSCALE;
        this.startp = new Point(0, 0);
        this.endp = new Point(0, 0);
        this.color = new Color(108, 100, 100);
        this.orient = direction;
        this.title = name;
    }

    public Axis(Axis ax) {
        this.startp = ax.startp;
        this.endp = ax.endp;
        this.thickness = ax.thickness;
        this.gridThickness = ax.gridThickness;
        this.gridLineStyle = ax.gridLineStyle;
        this.skipGridOffset = ax.skipGridOffset;
        this.orient = ax.orient;
        this.xorigin = ax.xorigin;
        this.yorigin = ax.yorigin;
        this.axisShift = ax.axisShift;
        this.color = new Color(ax.color.getRGB());
        if (ax.grid != null && ax.grid instanceof Grid2D) {
            this.grid = ax.grid.copy(new Grid2D(ax.grid.orient, ax.grid.bshow));
        }
        if (ax.ticker != null && ax.ticker instanceof Ticker2D) {
            this.ticker = ax.ticker.copy(new Ticker2D(this));
        }
        this.title = ax.title;
        this.bshow = ax.bshow;
        this.is3D = ax.is3D;
        this.arrowType = ax.arrowType;
        this.showTicker = ax.showTicker;
        this.xyzchart = ax.xyzchart;
        this.reversexlabel = ax.reversexlabel;
        this.xAtTop = ax.xAtTop;
        this.font = ax.font;
        this.showTitleTicker = ax.showTitleTicker;
        this.titleoffset = ax.titleoffset;
        this.titlevoffset = ax.titlevoffset;
        this.autoscale = ax.autoscale;
        this.autoOrigin = ax.autoOrigin;
        this.addAxisPadding = ax.addAxisPadding;
        this.autoScaleForValLessThan1 = ax.autoScaleForValLessThan1;
        this.useIntValueForAutoScale = ax.useIntValueForAutoScale;
        this.isLabelOutsidePlotArea = ax.isLabelOutsidePlotArea;
        this.maxScale = ax.maxScale;
        this.minScale = ax.minScale;
        this.stepScale = ax.stepScale;
        this.stepScaleMonth = ax.stepScaleMonth;
        this.stepsize = ax.stepsize;
        this.logScale = ax.logScale;
        this.isShowLogValue = ax.isShowLogValue;
        this.isShowSubTickers = ax.isShowSubTickers;
        this.logBase = ax.logBase;
        if (ax.columnField != null) {
            this.columnField = new ColData();
            this.columnField.copy(ax.columnField);
        }
        this.dynamicAutoScale = ax.dynamicAutoScale;
        this.displayLabelAsDate = ax.displayLabelAsDate;
        this.timeChart = ax.timeChart;
        this.isDateTimeColumn = ax.isDateTimeColumn;
    }

    public abstract Object getFaceList();

    public abstract Object getFaceList(int var1);

    public Axis copy(Axis newAxis, Grid newGrid, Ticker newTicker) {
        newAxis.thickness = this.thickness;
        newAxis.orient = this.orient;
        newAxis.xorigin = this.xorigin;
        newAxis.yorigin = this.yorigin;
        newAxis.color = this.color;
        newAxis.grid = this.grid.copy(newGrid);
        newAxis.ticker = this.ticker.copy(newTicker);
        newAxis.is3D = this.is3D;
        newAxis.font = this.font;
        newAxis.showTicker = this.showTicker;
        newAxis.xyzchart = this.xyzchart;
        newAxis.titleoffset = this.titleoffset;
        newAxis.titlevoffset = this.titlevoffset;
        newAxis.maxScale = this.maxScale;
        newAxis.minScale = this.minScale;
        newAxis.stepScale = this.stepScale;
        newAxis.stepScaleMonth = this.stepScaleMonth;
        newAxis.dynamicAutoScale = this.dynamicAutoScale;
        newAxis.logScale = this.logScale;
        newAxis.isShowLogValue = this.isShowLogValue;
        newAxis.isShowSubTickers = this.isShowSubTickers;
        newAxis.logBase = this.logBase;
        newAxis.autoscale = this.autoscale;
        newAxis.autoOrigin = this.autoOrigin;
        newAxis.addAxisPadding = this.addAxisPadding;
        newAxis.autoScaleForValLessThan1 = this.autoScaleForValLessThan1;
        newAxis.isLabelOutsidePlotArea = this.isLabelOutsidePlotArea;
        newAxis.useIntValueForAutoScale = this.useIntValueForAutoScale;
        newAxis.columnField = this.columnField;
        newAxis.gridThickness = this.gridThickness;
        newAxis.gridLineStyle = this.gridLineStyle;
        newAxis.skipGridOffset = this.skipGridOffset;
        newAxis.axisShift = this.axisShift;
        newAxis.displayLabelAsDate = this.displayLabelAsDate;
        newAxis.timeChart = this.timeChart;
        newAxis.xAtTop = this.xAtTop;
        return newAxis;
    }

    public final boolean isSubTickersOptionEnabled() {
        return this.logScale && this.logBase == 10.0;
    }

    public final boolean isShowLogValue() {
        return this.isShowLogValue;
    }

    public final void setShowLogValue(boolean state) {
        this.isShowLogValue = state;
    }

    public final boolean isShowSubTickers() {
        return this.isShowSubTickers;
    }

    public final void setShowSubTickers(boolean state) {
        this.isShowSubTickers = state;
    }

    public final double getBaseForLog() {
        return this.logBase;
    }

    public final void setBaseForLog(double value) {
        this.logBase = value;
    }

    public final double getMinScale() {
        return this.minScale;
    }

    public final double getMaxScale() {
        return this.maxScale;
    }

    public final double getScaleStep() {
        return this.stepScale;
    }

    public final int getScaleStepMonth() {
        return this.stepScaleMonth;
    }

    public final void setMinScale(double v) {
        this.minScale = v;
    }

    public final void setMaxScale(double v) {
        this.maxScale = v;
    }

    public final void setScaleStep(double v) {
        this.stepScale = v;
    }

    public final void setScaleStepMonth(int v) {
        this.stepScaleMonth = v;
    }

    public final boolean isLabelOutsidePlotArea() {
        return this.isLabelOutsidePlotArea;
    }

    public final void setLabelOutsidePlotArea(boolean b) {
        this.isLabelOutsidePlotArea = b;
    }

    public double getAxisShift() {
        if (this.stepsize != null) {
            if (this.axisShift > this.stepsize.maxvalue) {
                this.stepsize.maxvalue = this.axisShift;
            } else if (this.axisShift < this.stepsize.minvalue) {
                this.stepsize.minvalue = this.axisShift;
            }
        }
        return this.axisShift;
    }

    public void setAxisShift(double shift) {
        if (this.stepsize != null) {
            if (shift > this.stepsize.maxvalue) {
                this.stepsize.maxvalue = shift;
            } else if (shift < this.stepsize.minvalue) {
                this.stepsize.minvalue = shift;
            }
        }
        this.axisShift = shift;
    }

    public Point getStart() {
        return this.startp;
    }

    public Point getEnd() {
        return this.endp;
    }

    public void setY(int y) {
        this.startp.y = y;
        this.endp.y = y;
    }

    public void setGridThickness(int thick) {
        this.gridThickness = thick;
    }

    public int getGridThickness() {
        return this.gridThickness;
    }

    public void setGridLineStyle(int style) {
        this.gridLineStyle = style;
    }

    public int getGridLineStyle() {
        return this.gridLineStyle;
    }

    public void setSkipGridOffset(boolean b) {
        this.skipGridOffset = b;
    }

    public boolean isSkipGridOffset() {
        return this.skipGridOffset;
    }

    public boolean select(CGraphics g, int x, int y) {
        if (!this.bshow) {
            return false;
        }
        y = g.height - y;
        if (this.orient == 0) {
            return y <= this.startp.y + 7 && y >= this.startp.y - 7 && x <= Math.max(this.startp.x, this.endp.x) + 4 && x >= Math.min(this.startp.x, this.endp.x) - 4;
        }
        return x <= this.startp.x + 7 && x >= this.startp.x - 7 && y <= Math.max(this.startp.y, this.endp.y) + 4 && y >= Math.min(this.startp.y, this.endp.y) - 4;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public abstract void setWallColor(Object var1, Color var2);

    public void setorigin(int xorigin, int yorigin) {
        this.xorigin = xorigin;
        this.yorigin = yorigin;
    }

    public void set(int x1, int y1, int x2, int y2, int width, Object[] name, Point3D[] p, boolean reverseSide, ColData colField) {
        this.startp.x = x1;
        this.startp.y = y1;
        this.endp.x = x2;
        this.endp.y = y2;
        this.thickness = width;
        this.is3D = false;
        Color color = this.ticker.color;
        Color l_color = this.ticker.label_color;
        Font tickerFont = this.ticker.font;
        int tickerAngle = this.ticker.angle;
        this.columnField = colField;
        this.ticker.modify(name, p, reverseSide);
        this.ticker.setTickerColor(color);
        this.ticker.setLabelColor(l_color);
        this.ticker.setFont(tickerFont, tickerAngle);
    }

    public abstract void setTicker(Object var1, Object[] var2, Point3D[] var3, boolean var4, ColData var5);

    public abstract void setTicker(Object var1, int var2, int var3);

    public abstract void setVertex(Object var1, Object var2);

    public void setAxisGridY(StepSize sz, int xorigin, int xmin, int xmax, ColData colField, int width) {
        Point3D[] coord = new Point3D[sz.totalstep + 1];
        Object[] svalue = new Object[sz.totalstep + 1];
        this.stepsize = sz;
        this.columnField = colField;
        for (int i = 0; i <= sz.totalstep; ++i) {
            coord[i] = new Point3D(xorigin, i * sz.width / sz.totalstep + sz.newMinPixel);
            this.setNumericLabel(svalue, sz, i);
        }
        if (this.isShowSubTickers && this.logBase == 10.0 && this.logScale) {
            Point3D[] subTickers = new Point3D[sz.totalstep * (int)(this.logBase - 2.0)];
            int ct = 0;
            for (int i = 1; i <= sz.totalstep; ++i) {
                double curVal;
                double step = curVal = this.getNumericValue(sz, i - 1);
                curVal += step;
                int j = 0;
                while ((double)j < this.logBase - 2.0) {
                    subTickers[ct++] = new Point3D(xorigin, sz.interpolatePixel(curVal));
                    curVal += step;
                    ++j;
                }
            }
            this.ticker.setSubTickers(subTickers);
        }
        this.set(xorigin, sz.newMinPixel, xorigin, sz.newMaxPixel, width, svalue, coord, xorigin == xmax, colField);
        this.arrowType = sz.zeroAxis == sz.newMaxPixel ? 1 : (sz.zeroAxis != sz.newMinPixel ? 2 : 0);
        this.grid.set(coord, xmin, xmax);
    }

    public abstract void setAxisGridY(Object var1, StepSize var2, int var3, int var4, int var5, ColData var6);

    public abstract void setAxisGridY(Object var1, StepSize var2, int var3, int var4, int var5, ColData var6, int var7, int var8);

    public abstract void setAxisGridX(Object var1, StepSize var2, int var3, int var4, int var5, ColData var6);

    public abstract void setAxisGridX(Object var1, StepSize var2, int var3, int var4, int var5, ColData var6, int var7, int var8);

    public void setAxisGridX(StepSize sz, int yorigin, int ymin, int ymax, ColData colField, int width) {
        this.stepsize = sz;
        this.columnField = colField;
        Point3D[] coord = new Point3D[sz.totalstep + 1];
        Object[] svalue = new Object[sz.totalstep + 1];
        for (int i = 0; i <= sz.totalstep; ++i) {
            coord[i] = new Point3D(i * sz.width / sz.totalstep + sz.newMinPixel, yorigin);
            this.setNumericLabel(svalue, sz, i);
        }
        if (this.isShowSubTickers && this.logBase == 10.0 && this.logScale) {
            Point3D[] subTickers = new Point3D[sz.totalstep * (int)(this.logBase - 2.0)];
            int ct = 0;
            for (int i = 1; i <= sz.totalstep; ++i) {
                double curVal;
                double step = curVal = this.getNumericValue(sz, i - 1);
                curVal += step;
                int j = 0;
                while ((double)j < this.logBase - 2.0) {
                    subTickers[ct++] = new Point3D(sz.interpolatePixel(curVal), yorigin);
                    curVal += step;
                    ++j;
                }
            }
            this.ticker.setSubTickers(subTickers);
        }
        this.set(sz.newMinPixel, yorigin, sz.newMaxPixel, yorigin, width, svalue, coord, yorigin == ymax, colField);
        this.arrowType = sz.zeroAxis == sz.newMaxPixel ? 1 : (sz.zeroAxis != sz.newMinPixel ? 2 : 0);
        this.grid.set(coord, ymin, ymax);
    }

    public abstract void setAxisGridZ(Object var1, StepSize var2, int var3, int var4, int var5, ColData var6);

    public abstract void setXWall(Object var1, int var2, int var3, int var4, Color var5);

    public abstract void setYWall(Object var1, int var2, int var3, int var4, Color var5);

    public abstract void setSWall(Object var1, int var2, int var3, int var4, Color var5);

    public abstract void setZWall(Object var1, int var2, int var3, int var4, Color var5);

    public abstract void setFaceState();

    public String getTitle() {
        return this.title.getString();
    }

    public void setTitle(String str) {
        this.title.setString(str);
    }

    public void draw(CGraphics g) {
        this.draw(g, true);
    }

    public void drawGrid(CGraphics g) {
        if (this.grid != null) {
            if (this.columnField != null && this.columnField.sepUnit != -1) {
                if (this.columnField.fieldName == null) {
                    this.columnField.retrieveField();
                }
                java.util.Date startPt = null;
                int sepUnit = this.columnField.sepUnit;
                int inc = this.columnField.sepSize;
                if (sepUnit == 7) {
                    sepUnit = DateTime.getAutoScaleUnit(this.columnField.calcStartingDate(), this.columnField.calcEndingDate());
                } else if (this.columnField.dataType == 8) {
                    sepUnit = 3;
                }
                startPt = this.columnField.isAscending ? new java.util.Date(this.columnField.getStartingDate().getTime()) : new java.util.Date(this.columnField.getEndingDate().getTime());
                this.grid.draw(g, this.gridThickness, this.gridLineStyle, inc, sepUnit, this.columnField.isAscending, startPt, this.columnField.dataType, this.ticker.name);
            } else {
                int length = this.ticker.length;
                int inc = this.columnField != null ? this.columnField.tickerSepSize : 1;
                int maxLabelCt = this.columnField != null ? this.columnField.maxNumOfTickerAndLabel : -1;
                inc = Axis.calcMaxInc(maxLabelCt, length, inc);
                this.grid.draw(g, this.gridThickness, this.skipGridOffset, inc, this.gridLineStyle, true);
            }
        }
    }

    static int calcMaxInc(int maxLabelCt, int length, int orgINC) {
        int inc = 0;
        if (maxLabelCt > 0) {
            int i;
            int numOfLabelCt = length;
            if (numOfLabelCt <= maxLabelCt) {
                return orgINC;
            }
            inc = (int)Math.floor((length - 1) / (maxLabelCt - 1));
            numOfLabelCt = 0;
            for (i = 0; i < length; i += inc) {
                ++numOfLabelCt;
            }
            while (numOfLabelCt > maxLabelCt) {
                ++inc;
                numOfLabelCt = 0;
                for (i = 0; i < length; i += inc) {
                    ++numOfLabelCt;
                }
            }
            if (orgINC > 1 && inc > 0) {
                return inc * orgINC;
            }
            return inc;
        }
        return orgINC;
    }

    public abstract void drawTicker(CGraphics var1);

    protected void drawAxisPart(CGraphics g, Point p0, Point p1, boolean isDouble) {
        int[] yp;
        int[] xp;
        boolean isVertical = true;
        int thick = Math.abs(this.thickness);
        int arrh = (int)((double)(thick * 8) / 3.0);
        int arrw = thick * 5;
        int arrd = (int)((double)(thick * 10) / 3.0);
        int thick2 = thick / 2;
        boolean skipLine = false;
        if (p0.y == p1.y) {
            isVertical = false;
        }
        if (!isVertical) {
            int f2;
            int f1;
            if (p0.x < p1.x) {
                f1 = 1;
                f2 = isDouble ? -1 : 1;
            } else {
                f1 = -1;
                f2 = 1;
                if (isDouble) {
                    skipLine = true;
                }
            }
            if (!skipLine) {
                g.fillArea(p0.x - f2 * thick2, p0.y - thick2, p1.x - f1 * thick2, p0.y + thick2, 1);
            }
            if (thick2 <= 0) {
                thick2 = 1;
            }
            int x = p1.x + f1 * thick2;
            xp = new int[]{x, x - f1 * arrw, x - f1 * arrd, x - f1 * arrw};
            yp = new int[]{p1.y, p1.y + arrh, p1.y, p1.y - arrh};
        } else {
            int f2;
            int f1;
            if (p0.y < p1.y) {
                f1 = 1;
                f2 = isDouble ? -1 : 1;
            } else {
                f1 = -1;
                f2 = 1;
                if (isDouble) {
                    skipLine = true;
                }
            }
            if (!skipLine) {
                g.fillArea(p1.x - thick2, p1.y - f1 * thick2, p1.x + thick2, p0.y - f2 * thick2, 1);
            }
            if (thick2 <= 0) {
                thick2 = 1;
            }
            int y = p1.y + f1 * thick2;
            yp = new int[]{y, y - f1 * arrw, y - f1 * arrd, y - f1 * arrw};
            xp = new int[]{p1.x, p1.x + arrh, p1.x, p1.x - arrh};
        }
        g.fillPolygon(new Polygon(xp, yp, 4));
    }

    public abstract void drawAxis(CGraphics var1);

    public void draw(CGraphics g, boolean odd) {
        if (this.is3D && this.grid != null) {
            this.grid.draw(g, odd, this.skipGridOffset, this.columnField != null ? this.columnField.tickerSepSize : 1);
        }
        if (!odd) {
            return;
        }
        this.drawAxis(g);
    }

    public void setNumericLabel(Object[] svalue, StepSize sz, int i) {
        this.maxScale = sz.maxvalue;
        this.minScale = sz.minvalue;
        this.stepScale = sz.stepsize;
        this.stepScaleMonth = sz.stepmonth;
        svalue[i] = this.stepScaleMonth > 0 ? (!this.autoscale || this.isSpecificScaleEnabled() ? this.formating2((double)i * sz.stepsize + sz.minvalue, i * sz.stepmonth) : this.formating2((double)(i - sz.stepBelow) * sz.stepsize, i * sz.stepmonth)) : (sz.maxvalue > 0.0 ? (sz.minvalue < 0.0 ? (!this.autoscale ? this.formating2((double)i * sz.stepsize + sz.minvalue, i * sz.stepmonth) : this.formating2((double)(i - sz.stepBelow) * sz.stepsize, i * sz.stepmonth)) : this.formating2((double)i * sz.stepsize + sz.minvalue, i * sz.stepmonth)) : (!this.autoscale ? this.formating2((double)i * sz.stepsize + sz.minvalue, i * sz.stepmonth) : this.formating2((double)(i - sz.stepBelow) * sz.stepsize + sz.maxvalue, i * sz.stepmonth)));
    }

    public double getNumericValue(StepSize sz, int i) {
        this.maxScale = sz.maxvalue;
        this.minScale = sz.minvalue;
        this.stepScale = sz.stepsize;
        double value = 0.0;
        value = sz.maxvalue > 0.0 ? (sz.minvalue < 0.0 ? (!this.autoscale ? (double)i * sz.stepsize + sz.minvalue : (double)(i - sz.stepBelow) * sz.stepsize) : (double)i * sz.stepsize + sz.minvalue) : (double)(i - sz.stepBelow) * sz.stepsize + sz.maxvalue;
        if (this.logScale) {
            value = this.exp(value);
        }
        return value;
    }

    public boolean isDateTimeColumn() {
        return this.isDateTimeColumn;
    }

    public final String formating(double value) {
        return this.formating2(value, 0).toString();
    }

    private Object formating2(double value, int month) {
        if (month > 0) {
            java.util.Date date = null;
            if (this.columnField.axisType == 8) {
                date = new Date(Double.valueOf(value).longValue());
            } else if (this.columnField.axisType == 10) {
                date = new Timestamp(Double.valueOf(value).longValue());
            }
            if (date != null) {
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(date);
                cal.add(2, month);
                value = cal.getTime().getTime();
            }
        }
        if (this.logScale && !this.isShowLogValue()) {
            value = this.exp(value);
        }
        if (value == Double.NEGATIVE_INFINITY) {
            return value + "";
        }
        if (this.columnField != null && (this.columnField.axisType == 99 || DataType.isDateTime(this.columnField.axisType))) {
            if (this.displayLabelAsDate || !this.timeChart && DataType.isTime(this.columnField.axisType)) {
                this.isDateTimeColumn = true;
                if (this.columnField.axisType == 9) {
                    int offset = TimeZone.getDefault().getOffset(0L);
                    return new Time(Double.valueOf(value).longValue() - (long)offset);
                }
                if (this.columnField.axisType == 8) {
                    return new Date(Double.valueOf(value).longValue());
                }
                return new Timestamp(Double.valueOf(value).longValue());
            }
            this.isDateTimeColumn = false;
            boolean histogram = false;
            if (this.columnField.getName().startsWith("count_") || this.columnField.getName().startsWith("probability_")) {
                histogram = true;
            }
            if (value < 1.0 && value > 0.0 && histogram) {
                return Double.valueOf(new BigDecimal(value).setScale(this.getScaleValue(value), RoundingMode.HALF_UP).doubleValue()).toString();
            }
            return this.columnField.dataFormat.format(value);
        }
        this.isDateTimeColumn = false;
        return value + "";
    }

    private int getScaleValue(double num) {
        int zeros = 0;
        while (num < 1.0) {
            num *= 10.0;
            ++zeros;
        }
        return zeros + 2;
    }

    public abstract void drawAxisTitle(CGraphics var1);

    public abstract void drawFrameWall(CGraphics var1);

    public double log(double value) {
        if (this.logBase == Math.E) {
            return Math.log(value);
        }
        return Math.log(value) / Math.log(this.logBase);
    }

    public double exp(double value) {
        if (this.logBase == Math.E) {
            return Math.exp(value);
        }
        return Math.pow(this.logBase, value);
    }

    public boolean isDynamicAutoScale() {
        return this.dynamicAutoScale;
    }

    public void setDynamicAutoScale(boolean dynamicAutoScale) {
        this.dynamicAutoScale = dynamicAutoScale;
    }

    public boolean isSpecificScaleEnabled() {
        return this.getScaleStepMonth() == 1 || this.getScaleStepMonth() == 12 || this.getScaleStep() == 8.64E7 || this.isDynamicAutoScale();
    }

    public boolean isTimeChart() {
        return this.timeChart;
    }

    public void setTimeChart(boolean timeChart) {
        this.timeChart = timeChart;
    }
}

