/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.awt.geom.GeneralPath;
import quadbase.chart.CGraphics;
import quadbase.chart.StepSize;
import quadbase.chart.TrendLine;
import quadbase.chart.chart2d.TrendLine2D;

public class BSpline {
    double[] knot;
    double[] xcontrol;
    double[] ycontrol;
    int n;
    public final double MINDOUBLE = 1.0E-8;
    int chartMaxX;
    int chartMaxY;
    public int endX;
    public int endY;

    public BSpline(Double[] x, Double[] y) {
        double t;
        int i;
        x = TrendLine2D.getArrayWithoutNullValues(x);
        y = TrendLine2D.getArrayWithoutNullValues(y);
        this.n = x.length;
        this.knot = new double[this.n + 6];
        double[] xinterpolate = new double[this.n + 1];
        double[] yinterpolate = new double[this.n + 1];
        for (i = 0; i < this.n - 1; ++i) {
            xinterpolate[i + 1] = x[i];
            yinterpolate[i + 1] = y[i];
            this.knot[i + 4] = i + 4;
        }
        xinterpolate[i + 1] = x[i];
        yinterpolate[i + 1] = y[i];
        double d = this.knot[i + 3];
        this.knot[i + 6] = d;
        this.knot[i + 5] = d;
        this.knot[i + 4] = d;
        double[] a = new double[this.n + 1];
        double[] b = new double[this.n + 1];
        double[] c = new double[this.n + 1];
        for (i = 1; i <= this.n; ++i) {
            t = this.knot[i + 3] - this.knot[i + 1];
            double t1 = this.knot[i + 3] - this.knot[i + 2];
            if (t != 0.0) {
                double t2 = this.knot[i + 2] - this.knot[i + 1];
                double s1 = this.knot[i + 3] - this.knot[i];
                double s2 = this.knot[i + 4] - this.knot[i + 1];
                a[i] = s1 != 0.0 ? t1 * t1 / (s1 * t) : 0.0;
                c[i] = s2 != 0.0 ? t2 * t2 / (s2 * t) : 0.0;
            } else {
                c[i] = 0.0;
                a[i] = 0.0;
            }
            b[i] = 1.0 - a[i] - c[i];
        }
        b[1] = b[1] + a[1];
        if (b[1] == 0.0) {
            b[1] = 1.0E-8;
        }
        int n = this.n;
        b[n] = b[n] + c[this.n];
        if (b[this.n] == 0.0) {
            b[this.n] = 1.0E-8;
        }
        for (i = 2; i <= this.n; ++i) {
            t = a[i] / b[i - 1];
            int n2 = i;
            b[n2] = b[n2] - c[i - 1] * t;
            if (b[i] == 0.0) {
                b[i] = 1.0E-8;
            }
            int n3 = i;
            xinterpolate[n3] = xinterpolate[n3] - xinterpolate[i - 1] * t;
            int n4 = i;
            yinterpolate[n4] = yinterpolate[n4] - yinterpolate[i - 1] * t;
        }
        this.xcontrol = new double[this.n + 2];
        this.ycontrol = new double[this.n + 2];
        double d2 = xinterpolate[this.n] / b[this.n];
        this.xcontrol[this.n + 1] = d2;
        this.xcontrol[this.n] = d2;
        double d3 = yinterpolate[this.n] / b[this.n];
        this.ycontrol[this.n + 1] = d3;
        this.ycontrol[this.n] = d3;
        for (i = this.n - 1; i >= 1; --i) {
            this.xcontrol[i] = (xinterpolate[i] - c[i] * this.xcontrol[i + 1]) / b[i];
            this.ycontrol[i] = (yinterpolate[i] - c[i] * this.ycontrol[i + 1]) / b[i];
        }
        this.xcontrol[0] = this.xcontrol[1];
        this.ycontrol[0] = this.ycontrol[1];
    }

    private void computeParam(int i, double t, double[] param) {
        int m;
        int j = m = i - 3;
        int k = 0;
        while (k < 6) {
            param[k++] = t >= this.knot[j] && t < this.knot[j + 1] ? 1 : 0;
            ++j;
        }
        for (int l = 0; l < 3; ++l) {
            j = m;
            for (k = 0; k < 5 - l; ++k) {
                double t3 = this.knot[j + 2 + l];
                double t2 = t3 - this.knot[j + 1];
                double t1 = this.knot[j + l + 1] - this.knot[j];
                param[k] = t1 != 0.0 ? (t2 != 0.0 ? (t - this.knot[j]) / t1 * param[k] + (t3 - t) / t2 * param[k + 1] : (t - this.knot[j]) / t1 * param[k]) : (t2 != 0.0 ? (t3 - t) / t2 * param[k + 1] : 0.0);
                ++j;
            }
        }
        param[3] = 1.0 - param[0] - param[1] - param[2];
    }

    public void draw(TrendLine tr, CGraphics g, StepSize xscale, StepSize yscale) {
        boolean calculatemode = tr.calculatemode;
        double[] param = new double[6];
        int lastx = xscale.interpolatePixel2(this.xcontrol[0]);
        int lasty = yscale.interpolatePixel2(this.ycontrol[1]);
        GeneralPath path = null;
        for (int i = 3; i < this.n + 2; ++i) {
            for (double t = this.knot[i]; t < this.knot[i + 1]; t += 0.025) {
                this.computeParam(i, t, param);
                int x = xscale.interpolatePixel2(param[0] * this.xcontrol[i - 3] + param[1] * this.xcontrol[i - 2] + param[2] * this.xcontrol[i - 1] + param[3] * this.xcontrol[i]);
                int y = yscale.interpolatePixel2(param[0] * this.ycontrol[i - 3] + param[1] * this.ycontrol[i - 2] + param[2] * this.ycontrol[i - 1] + param[3] * this.ycontrol[i]);
                if (calculatemode) {
                    this.setEndPoint(x, y);
                } else {
                    path = tr.drawLimitPath(g, Integer.MIN_VALUE, Integer.MAX_VALUE, x, y, lastx, lasty, path);
                }
                lastx = x;
                lasty = y;
            }
        }
        if (path != null) {
            g.drawLine(path, tr.thickness);
        }
    }

    public void setChartBound(int maxX, int maxY) {
        this.chartMaxX = maxX;
        this.chartMaxY = maxY;
    }

    public void setEndPoint(int x, int y) {
        if (x <= this.chartMaxX && y <= this.chartMaxY) {
            this.endX = x;
            this.endY = y;
        }
    }
}

