/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.awt.RotateText;
import quadbase.chart.Area;
import quadbase.chart.CGraphics;
import quadbase.chart.CString;
import quadbase.chart.Chart;
import quadbase.chart.IOUtil2;
import quadbase.chart.Point3D;
import quadbase.common.util.internal.IFlashGraphics;
import quadbase.common.util.internal.QbUtil;
import quadbase.common.util.internal.VersioningDataOutput;
import quadbase.util.IAnnotation;
import quadbase.util.IReferenceObj;
import quadbase.util.Point_2D;
import quadbase.util.Position;
import quadbase.util.internal.IOUtil;

public class CAnnotation
implements IAnnotation {
    private static final Logger LOGGER = Logger.getLogger(CAnnotation.class.getName());
    IReferenceObj refObj;
    public boolean visible = true;
    public Point_2D relativePos;
    public Point_2D pos;
    public Font font;
    public int fontangle;
    public Color fontcolor;
    public int height;
    public int width;
    Chart chart;
    public Area area;
    public Area framearea;
    private int startx;
    private double starty;
    private int w;
    private double t;
    private int len;
    private boolean init = false;
    String[] originalText;
    String[] text;
    int[] shape;
    Color[] color;
    Point3D[] symbol;
    public CString[] textCString;
    private int delta;
    private int ypos;
    private int xpos;
    private int xShift = 0;
    private int yShift = 0;
    private int maxwidth;
    private int maxheight;
    public Object selectedObj;
    private boolean skipMargin = false;
    private static boolean oldVersion = false;
    FontMetrics fm;

    public static void setAddLeftMargin() {
        oldVersion = true;
    }

    public CAnnotation(Chart chart, IReferenceObj refObj, String text) {
        this(chart, refObj, (String[])null);
        this.setValue(text);
    }

    public CAnnotation(Chart chart, IReferenceObj refObj, String[] text) {
        this(chart, refObj, text, null, null);
    }

    public CAnnotation(Chart chart, IReferenceObj refObj, String[] text, int[] shape, Color[] color) {
        this.chart = chart;
        this.refObj = refObj;
        this.shape = shape;
        this.color = color;
        this.setValues(text);
        Font oldDefaultFont = new Font("TimesRoman", 0, 10);
        Font newDefaultFont = new Font("Dialog", 0, 8);
        this.font = QbUtil.getDefaultFont(oldDefaultFont, newDefaultFont);
        this.fontangle = 0;
        this.fontcolor = Color.black;
        this.area = chart.newArea();
        this.area.drawArea = false;
        this.area.areaColor = Color.lightGray;
        this.framearea = chart.newArea();
        this.framearea.drawArea = false;
        this.framearea.drawBorder = false;
        this.relativePos = new Point_2D(0.0f, 0.0f);
        this.pos = new Point_2D();
    }

    public synchronized Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            LOGGER.log(Level.SEVERE, "Clone not supported", e);
            throw new InternalError();
        }
    }

    CAnnotation copy(Chart newChart) {
        CAnnotation newAnno = (CAnnotation)this.clone();
        newAnno.area = newChart.copyArea(this.area);
        newAnno.framearea = newChart.copyArea(this.framearea);
        return newAnno;
    }

    private String[] getRunTimeValue(String[] target) {
        String[] temp = new String[target.length];
        for (int i = 0; i < target.length; ++i) {
            temp[i] = this.chart.valueTable.getRunTimeValue(target[i]);
        }
        return temp;
    }

    private String[] setText(String[] value) {
        Vector<String> textBuffer = new Vector<String>();
        Vector<Color> colorBuffer = new Vector<Color>();
        Vector<Integer> shapeBuffer = new Vector<Integer>();
        if (!oldVersion && this.shape != null) {
            boolean removeGap = true;
            for (int element : this.shape) {
                if (element == -1 || element == 7) continue;
                removeGap = false;
                break;
            }
            if (removeGap) {
                this.skipMargin = true;
            }
        }
        for (int i = 0; i < value.length; ++i) {
            String[] list = CString.tokenizer(value[i], true);
            for (int j = 0; j < list.length; ++j) {
                textBuffer.addElement(list[j]);
                if (this.shape == null) {
                    if (oldVersion) {
                        this.shape = new int[value.length];
                        for (int k = 0; k < this.shape.length; ++k) {
                            this.shape[k] = -1;
                        }
                    } else {
                        this.skipMargin = true;
                    }
                    shapeBuffer.addElement(7);
                    colorBuffer.addElement(this.color == null ? Color.black : this.color[i]);
                    continue;
                }
                if (j == 0) {
                    shapeBuffer.addElement(this.shape[i]);
                } else {
                    shapeBuffer.addElement(7);
                }
                colorBuffer.addElement(this.color == null ? Color.black : this.color[i]);
            }
        }
        String[] textList = new String[textBuffer.size()];
        if (this.shape != null) {
            this.shape = new int[shapeBuffer.size()];
            this.color = new Color[colorBuffer.size()];
        }
        for (int i = 0; i < textBuffer.size(); ++i) {
            textList[i] = (String)textBuffer.elementAt(i);
            if (this.shape == null) continue;
            this.shape[i] = (Integer)shapeBuffer.elementAt(i);
            this.color[i] = (Color)colorBuffer.elementAt(i);
        }
        return textList;
    }

    void invalidate() {
        this.init = false;
    }

    void setChart(Chart chart) {
        if (this.refObj == this.chart) {
            this.refObj = chart;
        }
        this.chart = chart;
        this.init = false;
    }

    private void setShapeList(int[] shapeList) {
        if (shapeList == null) {
            this.shape = null;
            return;
        }
        this.shape = new int[shapeList.length];
        for (int i = 0; i < shapeList.length; ++i) {
            this.shape[i] = shapeList[i];
        }
    }

    private void setColorList(Color[] colorList) {
        if (colorList == null) {
            this.color = null;
            return;
        }
        this.color = new Color[colorList.length];
        for (int i = 0; i < colorList.length; ++i) {
            this.color[i] = colorList[i];
        }
    }

    public String getOriginalValue() {
        int size;
        int n = size = this.originalText == null ? 0 : this.originalText.length;
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return this.originalText[0];
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < size - 1; ++i) {
            sb.append(this.originalText[i]);
            sb.append('\n');
        }
        sb.append(this.originalText[size - 1]);
        return sb.toString();
    }

    @Override
    public String getValue() {
        int size;
        int n = size = this.text == null ? 0 : this.text.length;
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return this.text[0];
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < size - 1; ++i) {
            sb.append(this.text[i]);
            sb.append('\n');
        }
        sb.append(this.text[size - 1]);
        return sb.toString();
    }

    @Override
    public void setValue(String value) {
        if (value == null) {
            this.originalText = new String[]{""};
            return;
        }
        this.originalText = new String[]{value};
        this.init = false;
    }

    @Override
    public String[] getValues() {
        return this.originalText;
    }

    @Override
    public void setValues(String[] value) {
        if (value == null) {
            this.originalText = new String[]{""};
            return;
        }
        this.originalText = value;
        this.init = false;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public boolean isVisible() {
        boolean value;
        boolean bl = value = this.visible && this.originalText != null;
        if (this.refObj == null) {
            return value;
        }
        return this.chart.doDrawAnnotation && value && this.refObj.isVisible();
    }

    @Override
    public IReferenceObj getReferenceObject() {
        return this.refObj;
    }

    @Override
    public void setReferenceObject(IReferenceObj refObj) {
        this.refObj = refObj;
    }

    @Override
    public void setRelativePosition(Point_2D relativePos) {
        this.relativePos = relativePos;
        if (this.textCString == null) {
            this.init = false;
        } else {
            this.setAbsPosition(null);
        }
    }

    @Override
    public Point_2D getRelativePosition() {
        return new Point_2D(this.relativePos.x, this.relativePos.y);
    }

    @Override
    public float getRelativeWidth() {
        this.initialize();
        return (float)this.width / (float)this.chart.winWidth;
    }

    @Override
    public void setRelativeWidth(float width) {
        throw new NoSuchMethodError();
    }

    @Override
    public float getRelativeHeight() {
        this.initialize();
        return (float)this.height / (float)this.chart.winHeight;
    }

    @Override
    public void setRelativeHeight(float height) {
        throw new NoSuchMethodError();
    }

    @Override
    public Position getPosition() {
        Point_2D pos = this.getXY();
        return new Position(pos.x / (float)this.chart.winWidth, pos.y / (float)this.chart.winHeight);
    }

    @Override
    public void setPosition(Position newPos) {
        if (this.refObj == null) {
            Point_2D relativePos = new Point_2D(newPos.getX(), newPos.getY());
            this.setRelativePosition(relativePos);
        } else {
            Position refPos = this.refObj.getReferencePosition();
            Point_2D relativePos = new Point_2D(newPos.getX() - refPos.getX(), newPos.getY() - refPos.getY());
            this.setRelativePosition(relativePos);
        }
    }

    @Override
    public boolean isBorderVisible() {
        return this.framearea.drawBorder;
    }

    @Override
    public void setBorderVisible(boolean b) {
        this.framearea.drawBorder = b;
    }

    @Override
    public Color getBorderColor() {
        return this.framearea.areaColor;
    }

    @Override
    public void setBorderColor(Color c) {
        this.framearea.areaColor = c;
    }

    @Override
    public int getBorderThickness() {
        return this.framearea.depth;
    }

    @Override
    public void setBorderThickness(int x) {
        this.framearea.depth = x;
    }

    @Override
    public boolean isBackgroundVisible() {
        return this.area.drawArea;
    }

    @Override
    public void setBackgroundVisible(boolean b) {
        this.area.drawArea = b;
    }

    @Override
    public Color getBackgroundColor() {
        return this.area.areaColor;
    }

    @Override
    public void setBackgroundColor(Color c) {
        this.area.areaColor = c;
    }

    @Override
    public int getAppearance() {
        return this.area.appearance;
    }

    @Override
    public void setAppearance(int x) {
        this.area.appearance = x;
        if (x == 4 || this.framearea.appearance == 4) {
            this.framearea.appearance = x;
        }
    }

    @Override
    public int getCutCornerWidth() {
        return this.area.getCutCornerWidth();
    }

    @Override
    public void setCutCornerWidth(int x) {
        this.area.setCutCornerWidth(x);
        this.framearea.setCutCornerWidth(x);
    }

    @Override
    public int getDepth() {
        return this.area.depth;
    }

    @Override
    public void setDepth(int x) {
        this.area.depth = x;
    }

    private void setAbsPosition(Graphics g) {
        if (!this.isVisible()) {
            return;
        }
        boolean skipMargin = this.skipMargin;
        if (skipMargin && (g == null || !(g instanceof IFlashGraphics)) && this.area.drawArea) {
            skipMargin = false;
        }
        this.pos = this.getXY();
        int x = (int)this.pos.x;
        int y = (int)this.pos.y;
        if ((this.fontangle + 90) % 180 == 0) {
            if (!this.chart.isReferenceAtTop()) {
                this.xpos = x - this.width / 2;
                this.ypos = y;
                this.startx = skipMargin ? this.xpos : this.xpos + (int)((double)this.w / 4.0);
                this.starty = y + this.height / 2;
            } else {
                this.xpos = x;
                this.ypos = this.chart.winHeight - y - this.height;
                this.startx = skipMargin ? this.xpos : this.xpos + (int)((double)this.w / 4.0);
                this.starty = this.ypos + this.height / 2;
            }
            this.t = this.maxwidth;
            for (int i = 0; i < this.len; ++i) {
                this.textCString[i].setpos(new Point3D(this.startx, (int)this.starty));
                this.startx = (int)((double)this.startx + this.t);
            }
        } else {
            if (!this.chart.isReferenceAtTop()) {
                this.xpos = x;
                this.ypos = y - this.height / 2;
                this.startx = skipMargin ? this.xpos : this.xpos + (int)((double)(this.width - (2 * this.w + this.maxwidth)) / 2.0 + (double)this.w);
                this.starty = y + this.height / 2 - this.maxheight / 2;
            } else {
                this.xpos = x;
                this.ypos = this.chart.winHeight - y - this.height;
                this.startx = skipMargin ? this.xpos : this.xpos + (int)((double)(this.width - (2 * this.w + this.maxwidth)) / 2.0 + (double)this.w);
                this.starty = this.ypos + this.height - this.maxheight / 2;
            }
            this.t = this.maxheight;
            int ptSize = (int)((double)this.w / 2.0 - 3.0);
            if (ptSize < 0) {
                ptSize = 0;
            }
            if (!skipMargin && this.shape != null) {
                this.symbol = new Point3D[this.len];
                for (int i = 0; i < this.len; ++i) {
                    this.symbol[i] = this.shape[i] != -1 ? new Point3D(this.startx + this.w / 2, (int)this.starty, this.color[i], this.shape[i], ptSize) : null;
                    this.textCString[i].setpos(new Point3D(this.startx + 2 * this.w, (int)this.starty));
                    this.starty -= this.t;
                }
            } else {
                for (int i = 0; i < this.len; ++i) {
                    this.textCString[i].setpos(new Point3D(this.startx, (int)this.starty));
                    this.starty -= this.t;
                }
            }
        }
    }

    private Point_2D getXY() {
        int y;
        int x;
        if (this.refObj == null) {
            x = (int)((float)this.chart.winWidth * this.relativePos.x);
            y = (int)((float)this.chart.winHeight * this.relativePos.y);
        } else {
            Position refPos = this.refObj.getReferencePosition();
            x = (int)Math.rint((float)this.chart.winWidth * (refPos.getX() + this.relativePos.x));
            y = (int)Math.rint((float)this.chart.winHeight * (refPos.getY() + this.relativePos.y));
        }
        if (x <= 0) {
            x = 2;
        } else if (x >= this.chart.winWidth) {
            x = this.chart.winWidth - 2;
        }
        if (y <= 0) {
            y = 2;
        } else if (y >= this.chart.winHeight) {
            y = this.chart.winHeight - 2;
        }
        return new Point_2D(x, y);
    }

    private void initialize() {
        CGraphics tempGraphics = new CGraphics(null, this.chart.component, 500, 500, null);
        this.initialize(tempGraphics);
    }

    public void initialize(CGraphics g) {
        if (!this.isVisible() || this.init) {
            return;
        }
        this.text = this.setText(this.getRunTimeValue(this.originalText));
        this.len = this.text.length;
        if (this.len == 0) {
            return;
        }
        this.fm = g.component.getFontMetrics(QbUtil.resizeViewerFont(this.font, this.chart.isAdjustFont()));
        this.w = this.fm.charWidth('A');
        this.textCString = new CString[this.len];
        for (int i = 0; i < this.len; ++i) {
            this.textCString[i] = new CString(this.text[i], this.font, null, this.fontcolor, 2, this.fontangle, true);
        }
        this.setMaxWidth(g);
        this.setMaxHeight(g);
        this.setDelta(g);
        this.setAnnotationSize();
        this.init = true;
    }

    public void draw(CGraphics g) {
        if (!this.isVisible()) {
            return;
        }
        if (!this.init) {
            this.initialize(g);
        }
        this.setAbsPosition(g.g);
        int h = this.ypos + this.height + this.delta;
        this.area.setpos(this.xpos - this.xShift, this.ypos - this.delta + this.yShift, this.xpos + this.width - this.xShift, h + this.yShift);
        this.framearea.setpos(this.xpos - this.xShift, this.ypos - this.delta + this.yShift, this.xpos + this.width - this.xShift, h + this.yShift);
        this.area.draw(g, this.area, null, true, this.area);
        this.framearea.draw(g);
        if (this.symbol != null) {
            for (Point3D element : this.symbol) {
                if (element == null) continue;
                element.drawPt(g);
            }
        }
        CString.setTokenizerEnabled(false);
        CString.drawCStrings(g, this.textCString);
        CString.setTokenizerEnabled(true);
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public int getAngle() {
        return this.fontangle;
    }

    @Override
    public void setColor(Color color) {
        this.setfontColor(color);
    }

    public void setfontColor(Color color) {
        this.fontcolor = color;
        if (this.textCString != null) {
            int size = this.textCString.length;
            for (int i = 0; i < size; ++i) {
                this.textCString[i].setColor(color);
            }
        }
    }

    @Override
    public Color getColor() {
        return this.getfontColor();
    }

    public Color getfontColor() {
        return this.fontcolor;
    }

    @Override
    public void setFont(Font font) {
        this.font = font;
        this.init = false;
    }

    public void setFont(Font font, int angle) {
        this.font = font;
        this.fontangle = angle;
        this.init = false;
    }

    @Override
    public void setAngle(int angle) {
        this.fontangle = angle;
        this.init = false;
    }

    public void setBackground(Area area) {
        this.area = area;
    }

    public Area getBackground() {
        return this.area;
    }

    public void setBorder(Area area) {
        this.framearea = area;
    }

    public Area getBorder() {
        return this.framearea;
    }

    private void setMaxWidth(CGraphics g) {
        this.maxwidth = 0;
        if (this.fontangle % 180 != 0) {
            for (int i = 0; i < this.len; ++i) {
                String runTimeValue = this.textCString[i].str;
                boolean isJ2DRotate = false;
                boolean isAdjustFont = false;
                if (g.chart != null) {
                    isJ2DRotate = g.chart.isJ2DRotateEnabled();
                    isAdjustFont = g.chart.isAdjustFont();
                } else {
                    isJ2DRotate = this.chart.isJ2DRotateEnabled();
                    isAdjustFont = this.chart.isAdjustFont();
                }
                RotateText rText = this.textCString[i].rText = new RotateText(runTimeValue, g.component, 0, 0, this.fontangle, isJ2DRotate, isAdjustFont);
                rText.setFont(this.font);
                rText.setColor(this.fontcolor);
                rText.prepareImage(g.g);
                int temp = rText.getWidth();
                if (temp <= this.maxwidth) continue;
                this.maxwidth = temp;
            }
        } else {
            for (int i = 0; i < this.len; ++i) {
                int temp = this.fm.stringWidth(this.text[i]);
                if (temp <= this.maxwidth) continue;
                this.maxwidth = temp;
            }
        }
        if (this.shape != null && (this.fontangle + 90) % 180 != 0) {
            this.maxwidth += 2 * this.w;
        }
    }

    private void setMaxHeight(CGraphics g) {
        this.maxheight = 0;
        if (this.fontangle % 180 != 0) {
            for (int i = 0; i < this.len; ++i) {
                String runTimeValue = this.textCString[i].str;
                boolean isJ2DRotate = false;
                boolean isAdjustFont = false;
                if (g.chart != null) {
                    isJ2DRotate = g.chart.isJ2DRotateEnabled();
                    isAdjustFont = g.chart.isAdjustFont();
                } else {
                    isJ2DRotate = this.chart.isJ2DRotateEnabled();
                    isAdjustFont = this.chart.isAdjustFont();
                }
                RotateText rText = this.textCString[i].rText = new RotateText(runTimeValue, g.component, 0, 0, this.fontangle, isJ2DRotate, isAdjustFont);
                rText.setFont(this.font);
                rText.setColor(this.fontcolor);
                rText.prepareImage(g.g);
                int temp = rText.getHeight();
                if (temp <= this.maxheight) continue;
                this.maxheight = temp;
            }
        } else {
            this.maxheight = this.fm.getHeight();
        }
    }

    private void setDelta(CGraphics g) {
        if (this.fontangle % 180 != 0) {
            boolean isJ2DRotate = false;
            boolean isAdjustFont = false;
            if (g.chart != null) {
                isJ2DRotate = g.chart.isJ2DRotateEnabled();
                isAdjustFont = g.chart.isAdjustFont();
            } else {
                isJ2DRotate = this.chart.isJ2DRotateEnabled();
                isAdjustFont = this.chart.isAdjustFont();
            }
            RotateText rText = new RotateText("H", g.component, 0, 0, this.fontangle, isJ2DRotate, isAdjustFont);
            rText.setFont(this.font);
            rText.prepareImage(g.g);
            this.delta = (rText.getHeight() - g.getFontMetrics(QbUtil.resizeViewerFont(this.font, this.chart.isAdjustFont())).charWidth('A')) / 2;
        } else {
            this.delta = 0;
        }
    }

    private void setAnnotationSize() {
        if ((this.fontangle + 90) % 180 == 0) {
            this.height = this.maxheight + 2 * this.w;
            this.width = this.len * this.maxwidth;
        } else {
            this.height = (int)((double)(this.len * this.maxheight) + 0.25 * (double)this.maxheight);
            this.width = this.maxwidth + 2 * this.w;
        }
    }

    public static CAnnotation select(CGraphics g, int x, int y) {
        Chart chart = g.chart;
        CAnnotation target = null;
        target = chart.annotationSet.select(g, x, y);
        if (target != null) {
            return target;
        }
        target = chart.dataLineSet.selectAnnotation(g, x, y);
        if (target != null) {
            return target;
        }
        return target;
    }

    Object selectPart(CGraphics g, int x, int y) {
        if (this.isVisible()) {
            this.selectedObj = null;
            this.selectedObj = this.selectText(g, x, y);
            if (this.selectedObj != null) {
                this.chart.targetName = "annotation text";
                return this.selectedObj;
            }
            this.selectedObj = this.selectBackground(g, x, y);
            if (this.selectedObj != null) {
                this.chart.targetName = "annotation background";
                return this.selectedObj;
            }
            this.selectedObj = this.selectBorder(g, x, y);
            if (this.selectedObj != null) {
                this.chart.targetName = "annotation border";
                return this.selectedObj;
            }
        }
        return null;
    }

    private Area selectBorder(CGraphics g, int x, int y) {
        return this.framearea.borderSelect(g, x, y) ? this.framearea : null;
    }

    private CString selectText(CGraphics g, int x, int y) {
        return CString.selectStrings(g, x, y, this.textCString);
    }

    private Area selectBackground(CGraphics g, int x, int y) {
        return this.area.select(g, x, y) ? this.area : null;
    }

    void write(DataOutput dout) throws IOException {
        dout.writeInt(0);
        dout.writeBoolean(this.refObj != null);
        int nText = this.originalText == null ? 0 : this.originalText.length;
        dout.writeInt(nText);
        for (int i = 0; i < nText; ++i) {
            IOUtil.writeString(dout, this.originalText[i]);
        }
        dout.writeBoolean(this.visible);
        dout.writeFloat(this.relativePos.x);
        dout.writeFloat(this.relativePos.y);
        IOUtil.writeFont(dout, this.font);
        dout.writeInt(this.fontangle);
        IOUtil.writeColor(dout, this.fontcolor);
        IOUtil2.writeArea(dout, this.area);
        dout.writeInt(this.area.appearance);
        dout.writeInt(this.area.depth);
        if (this.shape != null) {
            dout.writeInt(this.shape.length);
            IOUtil.writeInts(dout, this.shape, this.shape.length);
        } else {
            dout.writeInt(-1);
        }
        IOUtil.writeColorList(dout, this.color);
        IOUtil2.writeArea(dout, this.framearea);
        ((VersioningDataOutput)dout).writeInt(this.xShift, (short)6611);
        ((VersioningDataOutput)dout).writeInt(this.yShift, (short)6611);
    }

    static IAnnotation read(DataInput din, int version, Chart chart, IReferenceObj refObj) throws IOException {
        int magicNo;
        if (version > 70 && (magicNo = din.readInt()) == 0) {
            return CAnnotation.readCAnnotation(din, version, chart, refObj);
        }
        return null;
    }

    private static CAnnotation readCAnnotation(DataInput din, int version, Chart chart, IReferenceObj refObj) throws IOException {
        boolean hasRefObj = true;
        if (version > 71) {
            hasRefObj = din.readBoolean();
        }
        int nText = din.readInt();
        String[] text = null;
        if (nText > 0) {
            text = new String[nText];
            for (int i = 0; i < nText; ++i) {
                text[i] = IOUtil.readString(din, true);
            }
        }
        CAnnotation cAnno = new CAnnotation(chart, hasRefObj ? refObj : null, text);
        cAnno.setVisible(din.readBoolean());
        cAnno.setRelativePosition(new Point_2D(din.readFloat(), din.readFloat()));
        cAnno.setFont(IOUtil.readFont(din, true));
        cAnno.setAngle(din.readInt());
        cAnno.setColor(IOUtil.readColor(din));
        cAnno.area = IOUtil2.readArea(din, version, chart);
        if (version > 76) {
            cAnno.area.appearance = din.readInt();
            cAnno.area.depth = din.readInt();
        }
        if (version >= 190 || version >= 174 && version <= 185) {
            int arrLength = din.readInt();
            if (arrLength == -1) {
                cAnno.setShapeList(null);
            } else {
                cAnno.setShapeList(IOUtil.readInts(din, arrLength));
            }
            cAnno.setColorList(IOUtil.readColorList(din));
        }
        cAnno.framearea = IOUtil2.readArea(din, version, chart);
        if (version >= 6611) {
            cAnno.setxShift(din.readInt());
            cAnno.setyShift(din.readInt());
        }
        return cAnno;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<< CAnnotation >>\n");
        int nText = this.text == null ? 0 : this.text.length;
        for (int i = 0; i < nText; ++i) {
            sb.append("line ").append(i).append(": ").append(this.text[i]).append("\n");
        }
        sb.append("visible\t= ").append(this.visible).append("\n");
        sb.append("font\t\t= ").append(this.font).append("\n");
        sb.append("fontColor\t= ").append(this.fontcolor).append("\n");
        sb.append("background\t= ").append(this.area);
        sb.append("border\t\t= ").append(this.framearea);
        return sb.toString();
    }

    @Override
    public final void setDialBGState(boolean state) {
    }

    @Override
    public final void setDialBGImage(URL url, String relativeURL, int option) {
    }

    @Override
    public final void setDialBGRatio(double ratio) {
    }

    @Override
    public final void setDialBGImage(URL url, int option) {
    }

    @Override
    public final boolean getDialBGState() {
        return false;
    }

    @Override
    public final URL getDialBGImageURL() {
        return null;
    }

    @Override
    public final String getDialBGImageRelativeURL() {
        return null;
    }

    @Override
    public final double getDialBGRatio() {
        return 0.0;
    }

    @Override
    public final void setDialFGState(boolean state) {
    }

    @Override
    public final void setDialFGImage(URL url, String relativeURL, int option) {
    }

    @Override
    public final void setDialFGRatio(double ratio) {
    }

    @Override
    public final void setDialFGImage(URL url, int option) {
    }

    @Override
    public final boolean getDialFGState() {
        return false;
    }

    @Override
    public final URL getDialFGImageURL() {
        return null;
    }

    @Override
    public final String getDialFGImageRelativeURL() {
        return null;
    }

    @Override
    public final double getDialFGRatio() {
        return 0.0;
    }

    @Override
    public void setGradientEnabled(boolean b) {
        this.area.setGradientEnabled(b);
    }

    @Override
    public boolean isGradientEnabled() {
        return this.area.isGradientEnabled();
    }

    @Override
    public void set3DShadingEnabled(boolean b) {
        this.area.set3DShadingEnabled(b);
    }

    @Override
    public boolean is3DShadingEnabled() {
        return this.area.is3DShadingEnabled();
    }

    @Override
    public double getGradientStartX() {
        return this.area.getGradientStartX();
    }

    @Override
    public double getGradientStartY() {
        return this.area.getGradientStartY();
    }

    @Override
    public double getGradientEndX() {
        return this.area.getGradientEndX();
    }

    @Override
    public double getGradientEndY() {
        return this.area.getGradientEndY();
    }

    @Override
    public Color getGradientDesColor() {
        return this.area.getGradientDesColor();
    }

    @Override
    public int getGradientShade() {
        return this.area.getGradientShade();
    }

    @Override
    public boolean isGradientCyclic() {
        return this.area.isGradientCyclic();
    }

    @Override
    public void setGradientStartX(double x) {
        this.area.setGradientStartX(x);
    }

    @Override
    public void setGradientStartY(double y) {
        this.area.setGradientStartY(y);
    }

    @Override
    public void setGradientEndX(double x) {
        this.area.setGradientEndX(x);
    }

    @Override
    public void setGradientEndY(double y) {
        this.area.setGradientEndY(y);
    }

    @Override
    public void setGradientDesColor(Color c) {
        this.area.setGradientDesColor(c);
    }

    @Override
    public void setGradientShade(int s) {
        this.area.setGradientShade(s);
    }

    @Override
    public void setGradientCyclic(boolean c) {
        this.area.setGradientCyclic(c);
    }

    @Override
    public int getxShift() {
        return this.xShift;
    }

    @Override
    public void setxShift(int xShift) {
        this.xShift = xShift;
    }

    @Override
    public int getyShift() {
        return this.yShift;
    }

    @Override
    public void setyShift(int yShift) {
        this.yShift = yShift;
    }
}

