/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import quadbase.awt.RotateText;
import quadbase.chart.Area;
import quadbase.chart.CGraphics;
import quadbase.chart.Point3D;
import quadbase.common.util.internal.IFlashGraphics;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.QbUtil;
import quadbase.util.internal.IWMFGraphics;

public class CString {
    private static final Logger LOGGER = Logger.getLogger(CString.class.getName());
    public Font font;
    public Color color = Color.black;
    public String str;
    transient String runTimeValue;
    public int width = -1;
    public int height = -1;
    public int ascent;
    public int descent;
    public Point3D pos;
    public boolean initFont = true;
    public boolean bshow = true;
    public boolean invalid = true;
    public int placement = 0;
    public int direction = 0;
    public RotateText rText;
    public double angle = 0.0;
    public int minx;
    public int maxx;
    public int miny;
    public int maxy;
    public static final Font defaultfont = QbUtil.getDefaultFont(new Font("TimesRoman", 0, 10), new Font("Dialog", 0, 9));
    public static final Font defaultFontForViewer = QbUtil.getDefaultFont(new Font("TimesRoman", 0, 10), new Font("Dialog", 0, 9));
    public static final int HORZ = 0;
    public static final int ROTATE = 2;
    public static final int C = 0;
    public static final int N = 1;
    public static final int E = 2;
    public static final int S = 3;
    public static final int W = 4;
    public static final int NE = 5;
    public static final int SE = 6;
    public static final int SW = 7;
    public static final int NW = 8;
    private static boolean enableTokenizer = true;
    private static boolean outsidePlotAreaText = false;
    public boolean automatic = true;
    public int boundX1 = -1;
    public int boundX2 = -1;
    public boolean showLabelInFlash = true;
    private boolean isFinalText = false;
    private boolean allowCutOff = true;
    public static int shiftUP = 0;
    public static int shiftLEFT = 0;

    public CString(String s, int direct) {
        this(s, defaultfont, new Point3D(), Color.black, direct);
    }

    public CString(String s) {
        this(s, defaultfont, new Point3D(), Color.black, 0);
    }

    public CString() {
        this("", defaultfont, new Point3D(), Color.black, 0);
    }

    public CString(String s, Font f, int direct) {
        this(s, f, new Point3D(), Color.black, direct);
    }

    public CString(String s, Font f) {
        this(s, f, new Point3D(), Color.black, 0);
    }

    public CString(String s, Font f, Point3D p, int direct) {
        this(s, f, p, Color.black, direct);
    }

    public CString(String s, Point3D p) {
        this(s, defaultfont, p, Color.black, 0);
    }

    public CString(String s, Font f, Point3D p, Color c, int direct) {
        this.str = s.trim();
        this.font = f;
        this.pos = p;
        this.color = c;
        this.placement = direct;
    }

    public CString(String s, Font f, Point3D p, Color c, int direct, double angle) {
        this(s, f, p, c, direct);
        this.setAngle(angle);
    }

    public CString(String s, Font f, Point3D p, Color c, int direct, double angle, boolean isFinalText) {
        this(s, f, p, c, direct);
        this.isFinalText = isFinalText;
        this.setAngle(angle);
    }

    public final void setText(String s) {
        this.str = s;
        this.invalid = true;
        this.initFont = true;
        this.bshow = true;
        if (s.equals("")) {
            this.bshow = false;
        }
    }

    void setTextBound(int boundx1, int boundx2) {
        this.boundX1 = boundx1;
        this.boundX2 = boundx2;
    }

    public final void setAngle(double angle) {
        this.setAngle((int)angle);
    }

    public void setpos(Point3D p) {
        this.pos = p;
        if (this.rText != null) {
            this.rText.setPos(this.pos.x, this.pos.y);
        }
    }

    public final void setpos(Point3D p, int direct) {
        this.invalid = true;
        this.pos = p;
        this.placement = direct;
    }

    public final void setPlacement(int _placement) {
        if (_placement == this.placement) {
            return;
        }
        this.invalid = true;
        this.placement = _placement;
    }

    public final int getPlacement() {
        return this.placement;
    }

    public final void setDirection(int _direction) {
        if (this.direction == _direction) {
            return;
        }
        this.direction = _direction;
        this.angle = this.direction == 2 ? 90.0 : 0.0;
        this.invalid = true;
    }

    public final void setFont(Font font, double angle) {
        if (this.font.equals(font) && this.angle != 0.0 && this.angle == angle) {
            return;
        }
        if (this.angle != angle) {
            this.automatic = false;
        }
        this.angle = angle;
        this.font = font;
        this.direction = angle == 0.0 ? 0 : 2;
        this.invalid = true;
        this.initFont = true;
    }

    public final void setAutomatic(boolean automatic) {
        this.automatic = automatic;
    }

    public final void setFont(Font font, int angle) {
        this.setFont(font, (double)angle);
    }

    public final void setFont(Font font, int angle, boolean auto) {
        this.setFont(font, (double)angle);
        this.setAutomatic(auto);
    }

    public void draw(CGraphics g) {
        this.draw(g, true);
    }

    public void draw(CGraphics g, boolean isCentered) {
        if (!this.bshow || this.str == null || this.str.trim().equals("")) {
            return;
        }
        if (!this.showLabelInFlash && g.g instanceof IFlashGraphics && ((IFlashGraphics)((Object)g.g)).isDrawingTopLabels()) {
            return;
        }
        boolean isAdjustFont = g.chart != null ? g.chart.isAdjustFont() : false;
        g.setFont(QbUtil.resizeViewerFont(this.font, isAdjustFont), IOUtil.containsUnicode(this.str));
        g.setColor(this.color);
        if (this.direction == 1) {
            LOGGER.finest("Draw Vertical Font");
        }
        if (this.direction == 0 && !g.chart.isDisableJava2DForStraightText()) {
            this.drawHorizontalFont(g, isCentered);
        } else {
            this.drawRotateFont(g);
        }
        g.setX(this.minx);
        g.setX(this.maxx);
        g.setY(this.miny);
        g.setY(this.maxy);
        if (!CString.isOutsidePlotAreaText()) {
            if (this.minx < shiftLEFT) {
                shiftLEFT = this.minx;
            }
            if (this.miny < shiftUP) {
                shiftUP = this.miny;
            }
        }
    }

    public static void resetShiftValue() {
        shiftLEFT = 0;
        shiftUP = 0;
    }

    public String getRunTimeValue(CGraphics g) {
        if (this.isFinalText) {
            return this.str;
        }
        if (g.chart == null) {
            return this.str;
        }
        return g.chart.valueTable.getRunTimeValue(this.str);
    }

    private String getRunTimeValue(CGraphics g, String str) {
        if (g.chart == null || str == null || str.startsWith("Evaluation copy by Quadbase Systems Inc.")) {
            return str;
        }
        if (this.isFinalText) {
            return this.cutOffThreshold(g, str);
        }
        return this.cutOffThreshold(g, g.chart.valueTable.getRunTimeValue(str));
    }

    private String cutOffThreshold(CGraphics g, String str) {
        if (g.chart == null || g.chart.getCutOffThresholdForText() < 0 || str == null || str.length() <= g.chart.getCutOffThresholdForText() || !this.isAllowCutOff()) {
            return str;
        }
        return str.substring(0, g.chart.getCutOffThresholdForText()) + "...";
    }

    int getFontHeight(CGraphics g) {
        if (this.initFont) {
            this.initFont = false;
            return this.getFontWidthHeight(g);
        }
        return this.ascent + this.descent;
    }

    public int getWidth(CGraphics g) {
        if (this.initFont) {
            this.initFont = false;
            this.getFontWidthHeight(g);
        }
        return this.width;
    }

    public int getFontWidthHeight(CGraphics g) {
        FontMetrics fm = g.getFontMetrics(QbUtil.resizeViewerFont(this.font, g.chart != null ? g.chart.isAdjustFont() : false));
        this.runTimeValue = this.getRunTimeValue(g, this.str);
        this.width = CString.getStringWidth(this.runTimeValue, fm);
        this.ascent = fm.getMaxAscent();
        this.descent = fm.getMaxDescent();
        this.height = this.ascent + this.descent;
        return this.height;
    }

    private void drawHorizontalFont(CGraphics g, boolean isCentered) {
        int y;
        int x;
        if (this.initFont) {
            this.initFont = false;
            this.getFontWidthHeight(g);
        }
        switch (this.placement) {
            case 1: {
                x = this.pos.x - this.width / 2;
                y = this.pos.y + (this.ascent + this.descent) / 2;
                break;
            }
            case 2: {
                x = this.pos.x;
                y = this.pos.y - (this.ascent - this.descent) / 2;
                break;
            }
            case 3: {
                x = isCentered ? this.pos.x - this.width / 2 : this.pos.x;
                y = this.pos.y - (this.ascent + this.descent);
                break;
            }
            case 4: {
                x = this.pos.x - this.width;
                y = this.pos.y - (this.ascent - this.descent) / 2;
                break;
            }
            case 6: {
                x = this.pos.x;
                y = this.pos.y - (this.ascent + this.descent) / 2;
                break;
            }
            case 7: {
                x = this.pos.x - this.width;
                y = this.pos.y - (this.ascent + this.descent) / 2;
                break;
            }
            case 5: {
                x = this.pos.x;
                y = this.pos.y + (this.ascent + this.descent) / 2;
                break;
            }
            case 8: {
                x = this.pos.x - this.width;
                y = this.pos.y + (this.ascent + this.descent) / 2;
                break;
            }
            default: {
                x = this.pos.x - this.width / 2;
                y = this.pos.y - (this.ascent - this.descent) / 2;
            }
        }
        this.runTimeValue = this.getRunTimeValue(g, this.str);
        String[] strList = CString.tokenizer(this.runTimeValue, true);
        FontMetrics fm = g.getFontMetrics(QbUtil.resizeViewerFont(this.font, g.chart != null ? g.chart.isAdjustFont() : false));
        for (int i = 0; i < strList.length; ++i) {
            if (this.boundX1 != -1 && this.boundX2 != -1) {
                if (x < this.boundX1) {
                    x = this.boundX1;
                }
                if (x + this.width > this.boundX2) {
                    strList[i] = this.shortenText(strList[i], fm, this.boundX2 - x);
                }
            }
            g.drawString(strList[i], x, y);
            y -= this.ascent + this.descent;
        }
        this.minx = x;
        this.miny = (y += this.ascent + this.descent) - this.descent;
        this.maxx = this.minx + this.width;
        this.maxy = this.miny + this.height * strList.length;
    }

    private String shortenText(String val, FontMetrics fm, int width) {
        for (int i = val.length() - 2; i > 0; --i) {
            String tmp = val.substring(0, i);
            int w = fm.stringWidth(tmp);
            if (width < w) continue;
            return tmp + "..";
        }
        return "";
    }

    private void drawRotateFont(CGraphics g) {
        boolean isAdjustFont;
        boolean isJ2DRotate;
        String temp = this.getRunTimeValue(g, this.str);
        if (this.runTimeValue == null || !temp.equals(this.runTimeValue)) {
            this.invalid = true;
            this.runTimeValue = temp;
        }
        if (g.chart != null && g.chart.getStringCustomizer() != null) {
            this.runTimeValue = g.chart.getStringCustomizer().encodeString(this.runTimeValue);
        }
        boolean bl = isJ2DRotate = g.chart == null ? false : g.chart.isJ2DRotateEnabled();
        if (g.chart.isDisableJava2DForStraightText() && isJ2DRotate && this.angle % 90.0 == 0.0) {
            isJ2DRotate = false;
        }
        boolean bl2 = isAdjustFont = g.chart == null ? true : g.chart.isAdjustFont();
        if (this.rText == null || this.rText.getImage() == null || this.invalid || this.rText.isJava2DRotateTextEnabled() != isJ2DRotate || this.rText.isAdjustFont() != isAdjustFont) {
            this.rText = new RotateText(this.runTimeValue, g.component, 0, 0, this.angle, isJ2DRotate, isAdjustFont);
            this.rText.setFont(this.font);
            this.rText.setColor(this.color);
            this.rText.prepareImage(g.g);
            this.width = this.rText.getWidth();
            this.height = this.rText.getHeight();
            this.invalid = false;
        }
        this.setRotateFontPos(g);
        this.rText.draw(g.g);
    }

    private void setRotateFontPos(CGraphics g) {
        int y;
        int x;
        if (this.rText == null) {
            return;
        }
        int width = this.rText.getWidth();
        int height = this.rText.getHeight();
        switch (this.placement) {
            case 1: {
                x = this.pos.x - width / 2;
                y = this.pos.y + height;
                break;
            }
            case 2: {
                x = this.pos.x;
                y = this.pos.y + height / 2;
                break;
            }
            case 3: {
                x = this.pos.x - width / 2;
                y = this.pos.y;
                break;
            }
            case 4: {
                x = this.pos.x - width;
                y = this.pos.y + height / 2;
                break;
            }
            case 6: {
                x = this.pos.x;
                y = this.pos.y;
                break;
            }
            case 7: {
                x = this.pos.x - width;
                y = this.pos.y;
                break;
            }
            case 5: {
                x = this.pos.x;
                y = this.pos.y + height;
                break;
            }
            case 8: {
                x = this.pos.x - width;
                y = this.pos.y + height;
                break;
            }
            default: {
                x = this.pos.x - width / 2;
                y = this.pos.y + height / 2;
            }
        }
        this.minx = x;
        this.miny = y - height;
        this.maxx = x + width;
        this.maxy = y;
        if (g.g instanceof IWMFGraphics) {
            if (this.angle < 45.0 || this.angle > 315.0) {
                this.rText.setPos(x - width, g.height - y);
            } else if (this.angle >= 45.0 && this.angle < 135.0) {
                this.rText.setPos(x + width / 2, g.height - y + height);
            } else if (this.angle >= 135.0 && this.angle < 225.0) {
                this.rText.setPos(x + width, g.height - y + height);
            } else if (this.angle >= 225.0 && this.angle < 315.0) {
                this.rText.setPos(x + width / 2, g.height - y);
            }
        } else {
            this.rText.setPos(x, g.height - y);
        }
    }

    private static int getStringWidth(String str, FontMetrics fm) {
        String[] list = CString.tokenizer(str, true);
        int max = 0;
        for (String element : list) {
            int width = fm.stringWidth(element);
            if (width <= max) continue;
            max = width;
        }
        return max;
    }

    public static String[] tokenizer(String str) {
        return CString.tokenizer(str, false);
    }

    public static String[] tokenizer(String str, boolean skipTokenizerEnabledCheck) {
        if (!CString.isTokenizerEnabled() && !skipTokenizerEnabledCheck) {
            return new String[]{str};
        }
        String str2 = "";
        int len = str.length();
        boolean isSlash = false;
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c == '\\' && !isSlash) {
                isSlash = true;
                continue;
            }
            if ((c == 'n' || c == 'r') && isSlash) {
                c = '\n';
            } else if (c != '\\' && isSlash) {
                str2 = str2 + '\\';
            }
            isSlash = false;
            str2 = str2 + c;
        }
        StringTokenizer st = new StringTokenizer(str2, "\r\n");
        if (st.countTokens() <= 0) {
            return new String[]{str};
        }
        int i = 0;
        String[] list = new String[st.countTokens()];
        while (st.hasMoreTokens()) {
            list[i++] = st.nextToken();
        }
        return list;
    }

    static boolean isTokenizerEnabled() {
        return enableTokenizer;
    }

    static void setTokenizerEnabled(boolean state) {
        enableTokenizer = state;
    }

    public static boolean isOutsidePlotAreaText() {
        return outsidePlotAreaText;
    }

    public static void setOutsidePlotAreaText(boolean state) {
        outsidePlotAreaText = state;
    }

    public CString copy() {
        CString newString = new CString(this.str, this.font, this.pos.copy(), this.color, this.placement);
        newString.initFont = true;
        newString.bshow = true;
        newString.invalid = true;
        newString.placement = this.placement;
        newString.direction = this.direction;
        newString.angle = this.angle;
        newString.automatic = this.automatic;
        return newString;
    }

    public boolean select(CGraphics g, int x, int y) {
        return Area.inside(this.maxx, this.maxy, this.minx, this.miny, x, g.height - y);
    }

    public static final void drawCStrings(CGraphics g, CString[] sarray) {
        if (sarray == null) {
            return;
        }
        for (CString element : sarray) {
            element.draw(g);
        }
    }

    public static final void drawCStrings(CGraphics g, Vector svec) {
        if (svec == null) {
            return;
        }
        for (int i = 0; i < svec.size(); ++i) {
            if (g.g instanceof IFlashGraphics) {
                ((CString)svec.elementAt((int)i)).initFont = true;
            }
            ((CString)svec.elementAt(i)).draw(g);
        }
    }

    public static final CString selectStrings(CGraphics g, int x, int y, CString[] sarray) {
        if (sarray == null) {
            return null;
        }
        for (CString element : sarray) {
            if (!element.select(g, x, y)) continue;
            return element;
        }
        return null;
    }

    public static final CString selectStrings(CGraphics g, int x, int y, CString[][] sarray) {
        if (sarray == null) {
            return null;
        }
        CString[][] cStringArray = sarray;
        int n = cStringArray.length;
        for (int i = 0; i < n; ++i) {
            CString[] element;
            for (CString element2 : element = cStringArray[i]) {
                if (!element2.select(g, x, y)) continue;
                return element2;
            }
        }
        return null;
    }

    public static final CString selectStrings(CGraphics g, int x, int y, Vector svec) {
        if (svec == null) {
            return null;
        }
        for (int i = 0; i < svec.size(); ++i) {
            if (!((CString)svec.elementAt(i)).select(g, x, y)) continue;
            return (CString)svec.elementAt(i);
        }
        return null;
    }

    public static final int selectStringIndex(CGraphics g, int x, int y, CString[] sarray) {
        if (sarray == null) {
            return -1;
        }
        for (int i = 0; i < sarray.length; ++i) {
            if (!sarray[i].select(g, x, y)) continue;
            return i;
        }
        return -1;
    }

    public static final void setStringsColor(CString[][] array, Color color) {
        if (array != null) {
            CString[][] cStringArray = array;
            int n = cStringArray.length;
            for (int i = 0; i < n; ++i) {
                CString[] element;
                for (CString element2 : element = cStringArray[i]) {
                    element2.setColor(color);
                }
            }
        }
    }

    public static final void setStringsColor(CString[] array, Color color) {
        if (array != null) {
            for (CString element : array) {
                element.setColor(color);
            }
        }
    }

    public static final void setStringsColor(Vector svec, Color color) {
        if (svec != null) {
            for (int i = 0; i < svec.size(); ++i) {
                ((CString)svec.elementAt(i)).setColor(color);
            }
        }
    }

    public static final void setStringsFont(Vector svec, Font font, int angle) {
        if (svec != null) {
            for (int i = 0; i < svec.size(); ++i) {
                ((CString)svec.elementAt(i)).setFont(font, angle);
            }
        }
    }

    public static final void setStringsFont(CString[][] array, Font font, int angle) {
        if (array != null) {
            CString[][] cStringArray = array;
            int n = cStringArray.length;
            for (int i = 0; i < n; ++i) {
                CString[] element;
                for (CString element2 : element = cStringArray[i]) {
                    element2.setFont(font, angle);
                }
            }
        }
    }

    public static final void setStringsFont(CString[] array, Font font, int angle) {
        if (array != null) {
            for (CString element : array) {
                element.setFont(font, angle);
            }
        }
    }

    public static final void setStringsFont(CString[] array, Font font, int angle, boolean auto) {
        if (array != null) {
            for (CString element : array) {
                element.setFont(font, angle);
                if (Math.round(element.getAngle()) == angle) continue;
                element.setAutomatic(auto);
            }
        }
    }

    public static final void setStringsFont(CString[][] array, Font font, int angle, boolean auto) {
        if (array != null) {
            CString[][] cStringArray = array;
            int n = cStringArray.length;
            for (int i = 0; i < n; ++i) {
                CString[] element;
                for (CString element2 : element = cStringArray[i]) {
                    element2.setFont(font, angle);
                    if (Math.round(element2.getAngle()) == angle) continue;
                    element2.setAutomatic(auto);
                }
            }
        }
    }

    public final void setString(String _str) {
        if (this.str.equals(_str)) {
            return;
        }
        this.str = _str;
        this.initFont = true;
        this.invalid = true;
        this.bshow = true;
        if (_str.equals("")) {
            this.bshow = false;
        }
    }

    public final String getString() {
        return this.str;
    }

    public String getValue() {
        return this.getString();
    }

    public void setValue(String value) {
        this.setString(value);
    }

    public final Color getColor() {
        return this.color;
    }

    public final void setColor(Color _color) {
        if (this.color.equals(_color)) {
            return;
        }
        this.color = _color;
        this.invalid = true;
    }

    public final Font getFont() {
        return this.font;
    }

    public final void setFont(Font f) {
        this.font = f;
        this.invalid = true;
        this.initFont = true;
    }

    public final int getAngle() {
        return (int)this.angle;
    }

    public final void setAngle(int angle) {
        if (this.angle == (double)(angle %= 360)) {
            return;
        }
        this.angle = angle;
        this.direction = angle == 0 ? 0 : 2;
        this.invalid = true;
    }

    public boolean isAllowCutOff() {
        return this.allowCutOff;
    }

    public void setAllowCutOff(boolean allowCutOff) {
        this.allowCutOff = allowCutOff;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<< CString >>\n");
        sb.append("font\t\t= " + this.font + "\n");
        sb.append("color\t\t= " + this.color + "\n");
        sb.append("str\t\t= " + this.str + "\n");
        sb.append("width\t\t= " + this.width + "\n");
        sb.append("height\t\t= " + this.height + "\n");
        sb.append("ascent\t\t= " + this.ascent + "\n");
        sb.append("descent\t\t= " + this.descent + "\n");
        sb.append("pos\t\t= " + this.pos.toString() + "\n");
        sb.append("initFont\t= " + this.initFont + "\n");
        sb.append("bshow\t\t= " + this.bshow + "\n");
        sb.append("invalid\t\t= " + this.invalid + "\n");
        sb.append("placement\t= " + this.placement + "\n");
        sb.append("direction\t= " + this.direction + "\n");
        sb.append(this.rText == null ? "rText\t\t= null\n" : this.rText.toString());
        sb.append("angle\t\t= " + this.angle + "\n");
        sb.append("minx\t\t= " + this.minx + "\n");
        sb.append("maxx\t\t= " + this.maxx + "\n");
        sb.append("miny\t\t= " + this.miny + "\n");
        sb.append("maxy\t\t= " + this.maxy + "\n");
        sb.append("automatic\t= " + this.automatic + "\n");
        return sb.toString();
    }
}

