/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.awt.Color;
import quadbase.chart.QbPattern;

public class ChartColorSet {
    private int colorIndex;
    private int colorSetIndex;
    private Color[] chartDataPointsColors = new Color[0];
    private boolean isDataPointsColorsMapped = false;
    private static final int DEFAULT_COLOR_SET_INDEX = 0;
    private static final int DEFAULT_SECOND_VALUE_COLOR_SET_INDEX = 6;
    private static final int COLOR_COMPARISON_THRESHOLD = 10;
    public static final Color[][] colorSetArr = new Color[][]{{new Color(43, 182, 235), new Color(137, 194, 61), new Color(251, 218, 94), new Color(226, 62, 68), new Color(241, 163, 67), new Color(24, 134, 212), new Color(0, 149, 71), new Color(167, 90, 166), new Color(149, 219, 245), new Color(196, 225, 158), new Color(253, 237, 174), new Color(241, 158, 161), new Color(247, 233, 215), new Color(139, 195, 233), new Color(128, 202, 163), new Color(211, 172, 211)}, {new Color(87, 91, 239), new Color(254, 190, 22), new Color(102, 185, 18), new Color(232, 62, 127), new Color(25, 29, 175), new Color(254, 128, 26), new Color(188, 230, 51), new Color(196, 198, 254), new Color(141, 0, 255), new Color(254, 189, 220), new Color(45, 100, 22), new Color(254, 226, 111), new Color(255, 44, 0), new Color(170, 170, 170), new Color(255, 255, 255), new Color(248, 0, 255)}, {new Color(255, 83, 23), new Color(0, 87, 150), new Color(255, 218, 46), new Color(105, 171, 41), new Color(142, 0, 47), new Color(147, 210, 255), new Color(65, 81, 8), new Color(186, 215, 0), new Color(93, 45, 128), new Color(255, 164, 23), new Color(206, 0, 19), new Color(0, 148, 216), new Color(156, 231, 0), new Color(0, 204, 102), new Color(49, 198, 1), new Color(252, 228, 174)}, {new Color(75, 150, 174), new Color(254, 143, 28), new Color(154, 174, 75), new Color(174, 75, 111), new Color(0, 91, 115), new Color(254, 211, 172), new Color(207, 101, 0), new Color(209, 218, 177), new Color(177, 208, 218), new Color(125, 0, 52), new Color(218, 177, 190), new Color(96, 117, 0), new Color(85, 85, 85), new Color(213, 213, 213), new Color(150, 150, 150), new Color(102, 0, 10)}, {new Color(251, 230, 90), new Color(215, 45, 50), new Color(163, 254, 122), new Color(254, 143, 196), new Color(183, 198, 250), new Color(0, 152, 169), new Color(243, 171, 51), new Color(118, 108, 241), new Color(145, 236, 244), new Color(206, 0, 107), new Color(38, 197, 119), new Color(254, 112, 71), new Color(128, 255, 179), new Color(252, 119, 210), new Color(255, 255, 255), new Color(195, 174, 174)}, {new Color(103, 61, 127), new Color(240, 220, 62), new Color(135, 159, 85), new Color(231, 83, 94), new Color(217, 203, 245), new Color(240, 170, 64), new Color(100, 100, 77), new Color(244, 242, 159), new Color(188, 44, 56), new Color(186, 206, 77), new Color(158, 127, 190), new Color(250, 190, 200), new Color(252, 247, 218), new Color(255, 174, 131), new Color(200, 200, 255), new Color(227, 212, 178)}, {new Color(0, 87, 150), new Color(255, 191, 23), new Color(70, 181, 53), new Color(233, 63, 128), new Color(187, 227, 255), new Color(255, 129, 27), new Color(0, 115, 51), new Color(255, 227, 112), new Color(166, 0, 79), new Color(189, 231, 52), new Color(0, 148, 216), new Color(255, 190, 221), new Color(241, 163, 67), new Color(24, 134, 212), new Color(0, 149, 71), new Color(167, 90, 166)}, {new Color(118, 42, 131), new Color(153, 112, 171), new Color(194, 165, 207), new Color(231, 212, 232), new Color(217, 240, 211), new Color(166, 219, 160), new Color(90, 174, 97), new Color(27, 120, 55)}, {new Color(69, 117, 180), new Color(116, 173, 209), new Color(171, 217, 233), new Color(224, 243, 248), new Color(254, 224, 144), new Color(253, 174, 97), new Color(244, 109, 67), new Color(215, 48, 39)}, {new Color(140, 81, 10), new Color(191, 129, 45), new Color(223, 129, 125), new Color(246, 232, 195), new Color(199, 234, 229), new Color(128, 205, 193), new Color(53, 151, 143), new Color(1, 102, 94)}, {new Color(197, 27, 125), new Color(222, 119, 174), new Color(241, 182, 218), new Color(253, 224, 239), new Color(230, 245, 208), new Color(184, 225, 134), new Color(127, 188, 65), new Color(77, 146, 33)}, {new Color(179, 88, 6), new Color(224, 130, 20), new Color(253, 184, 99), new Color(254, 224, 182), new Color(216, 218, 235), new Color(178, 171, 210), new Color(128, 115, 172), new Color(84, 39, 136)}, {new Color(77, 77, 77), new Color(135, 135, 135), new Color(186, 186, 186), new Color(224, 224, 224), new Color(253, 219, 199), new Color(244, 165, 130), new Color(214, 96, 77), new Color(178, 24, 33)}, {new Color(12, 44, 132), new Color(34, 94, 168), new Color(29, 145, 192), new Color(65, 182, 196), new Color(127, 205, 187), new Color(199, 233, 180), new Color(237, 248, 177), new Color(255, 255, 217)}, {new Color(0, 90, 50), new Color(35, 139, 69), new Color(65, 171, 93), new Color(116, 196, 118), new Color(161, 217, 155), new Color(199, 233, 192), new Color(229, 245, 224), new Color(247, 252, 245)}, {new Color(74, 20, 134), new Color(106, 81, 163), new Color(128, 125, 186), new Color(158, 154, 200), new Color(188, 189, 220), new Color(218, 218, 235), new Color(237, 235, 243), new Color(250, 249, 251)}, {new Color(177, 0, 38), new Color(227, 26, 28), new Color(252, 78, 42), new Color(253, 141, 60), new Color(254, 178, 76), new Color(254, 217, 118), new Color(255, 237, 160), new Color(255, 255, 204)}, {new Color(37, 37, 37), new Color(82, 82, 82), new Color(115, 115, 115), new Color(150, 150, 150), new Color(189, 189, 189), new Color(217, 217, 217), new Color(240, 240, 240), new Color(255, 255, 255)}, {new Color(1, 100, 80), new Color(2, 129, 138), new Color(54, 144, 192), new Color(103, 169, 207), new Color(166, 189, 219), new Color(208, 209, 230), new Color(236, 226, 240), new Color(255, 247, 251)}};
    public static final int TOTAL_NUMBER_OF_AVAILABLE_COLORS = ChartColorSet.getTotalNumberOfAvailableColors();

    private static int getTotalNumberOfAvailableColors() {
        int total = 0;
        for (Color[] element : colorSetArr) {
            total += element.length;
        }
        return total;
    }

    public ChartColorSet(boolean isSecondValueColorSet) {
        this.colorSetIndex = isSecondValueColorSet ? 6 : 0;
        this.colorIndex = 0;
    }

    public ChartColorSet cloneAndResetColorIndex() {
        ChartColorSet cSet = new ChartColorSet(false);
        cSet.colorSetIndex = this.colorSetIndex;
        cSet.isDataPointsColorsMapped = this.isDataPointsColorsMapped;
        cSet.chartDataPointsColors = (Color[])this.chartDataPointsColors.clone();
        cSet.colorIndex = 0;
        return cSet;
    }

    public void setRandomColorSet(boolean resetColorIndex) {
        int curColorSet = this.colorSetIndex;
        for (int i = 0; curColorSet == this.colorSetIndex || colorSetArr.length < 2 || i == 10000; ++i) {
            this.colorSetIndex = (int)(Math.random() * (double)colorSetArr.length);
        }
        if (resetColorIndex) {
            this.colorIndex = 0;
        }
    }

    public Color getNextColor() {
        Color color = this.getXthColor(this.colorIndex, this.colorSetIndex, true);
        if (this.colorIndex >= TOTAL_NUMBER_OF_AVAILABLE_COLORS) {
            return color;
        }
        if (this.isDataPointsColorsMapped() && this.chartDataPointsColors.length > 0) {
            int j = 0;
            boolean newColorOK = false;
            while (!newColorOK || j == 100) {
                boolean generateNewColor = false;
                for (Color chartDataPointsColor : this.chartDataPointsColors) {
                    if (!this.checkColorsSimilarity(color, chartDataPointsColor)) continue;
                    generateNewColor = true;
                    break;
                }
                if (generateNewColor) {
                    ++this.colorIndex;
                    color = this.getXthColor(this.colorIndex, this.colorSetIndex, true);
                    ++j;
                    continue;
                }
                newColorOK = true;
            }
        }
        ++this.colorIndex;
        return color;
    }

    public Color getNextColor(Color c) {
        Color tmpColor = this.getNextColor();
        if (c instanceof QbPattern) {
            QbPattern newColor = new QbPattern(tmpColor, ((QbPattern)c).getPatternTypeID());
            if (newColor.getPatternTypeID() == QbPattern.CUSTOMPATTERN) {
                newColor.setPatternImage(((QbPattern)c).getPatternImage());
            }
            return newColor;
        }
        return tmpColor;
    }

    public void resetColorIndex() {
        this.colorIndex = 0;
    }

    public void setColorSetIndex(int i) {
        if (i >= colorSetArr.length) {
            i = 0;
        }
        this.colorSetIndex = i;
    }

    public void setDataPointsColorsMapped(boolean isDataPointsColorsMapped) {
        this.isDataPointsColorsMapped = isDataPointsColorsMapped;
    }

    public int getColorSetIndex() {
        return this.colorSetIndex;
    }

    public boolean isDataPointsColorsMapped() {
        return this.isDataPointsColorsMapped;
    }

    public static Color getRandomColor() {
        int rand1 = (int)(Math.random() * (double)(colorSetArr.length - 1));
        return colorSetArr[rand1][(int)(Math.random() * (double)(colorSetArr[rand1].length - 1))];
    }

    public Color getRandomGrayScale() {
        float val = (float)this.colorIndex / (float)colorSetArr[0].length;
        if (this.colorIndex % 2 == 1) {
            val = 1.0f - val;
        }
        Color tmpColor = Color.getHSBColor(1.0f, 0.0f, val);
        ++this.colorIndex;
        this.colorIndex %= colorSetArr[0].length;
        return tmpColor;
    }

    public Color[] getChartDataPointsColors() {
        return this.chartDataPointsColors;
    }

    public void setChartDataPointsColors(Color[] colors) {
        this.chartDataPointsColors = colors == null ? new Color[0] : colors;
    }

    private Color getXthColor(int colorIndex, int colSetIndex, boolean useChartDataPointsColors) {
        if (colorIndex < 0) {
            colorIndex = 0;
        }
        if (colorIndex >= TOTAL_NUMBER_OF_AVAILABLE_COLORS) {
            return ChartColorSet.getRandomColor();
        }
        if (colSetIndex >= colorSetArr.length || colSetIndex < 0) {
            colSetIndex = 0;
        }
        if (useChartDataPointsColors && this.chartDataPointsColors != null && colorIndex < this.chartDataPointsColors.length && !this.isDataPointsColorsMapped()) {
            return this.chartDataPointsColors[colorIndex];
        }
        if (colorIndex >= colorSetArr[colSetIndex].length) {
            return this.getXthColor(colorIndex - colorSetArr[colSetIndex].length, colSetIndex + 1, false);
        }
        return colorSetArr[colSetIndex][colorIndex];
    }

    private boolean checkColorsSimilarity(Color cA, Color cB) {
        int differences = Math.abs(cA.getRed() - cB.getRed()) + Math.abs(cA.getGreen() - cB.getGreen()) + Math.abs(cA.getBlue() - cB.getBlue());
        return differences <= 10;
    }
}

