/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.chart.Axis;
import quadbase.chart.ColDataResultSet;
import quadbase.chart.DBAccess;
import quadbase.chart.DataFileInput;
import quadbase.chart.EJBAccess;
import quadbase.chart.IOUtil2;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.DataSet;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.EJBInfo;
import quadbase.common.util.internal.IDataSet;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;
import quadbase.common.util.internal.XMLFileQueryInfo;
import quadbase.common.util.internal.XMLUtil;
import quadbase.util.IFormat;
import quadbase.util.IRSMetaData;
import quadbase.util.IResultSet;
import quadbase.util.ISpreadSheetModel;
import quadbase.util.LocaleDateTimeFormat;
import quadbase.util.LocaleNumericFormat;
import quadbase.util.LogicalFormat;
import quadbase.util.QueryResultSet;
import quadbase.util.internal.BooleanCompare;
import quadbase.util.internal.DateCompare;
import quadbase.util.internal.ICompareObject;
import quadbase.util.internal.NumberCompare;
import quadbase.util.internal.SortObject;
import quadbase.util.internal.StringCompare;
import quadbase.util.internal.TransposeRS;

public class ColData {
    private static final Logger LOGGER = Logger.getLogger(ColData.class.getName());
    public static final int DATA_ORDER_NONE = 0;
    public static final int DATA_ORDER_ASC = 1;
    public static final int DATA_ORDER_DES = 2;
    public static final int DATA_ORDER_CUST = 3;
    public static String[] DATA_ORDER_STR = new String[]{LanguageEncoder.getText("DataSource Order"), LanguageEncoder.getText("Ascending"), LanguageEncoder.getText("Descending"), LanguageEncoder.getText("Customize")};
    public int dataType;
    public int originalType;
    private IDataSet vec;
    private IDataSet scriptedVec;
    public String colName;
    public String tableName;
    public boolean bNumeric;
    public boolean bGenUniqueName;
    public int noUniqueField;
    public Object[] originalFieldName;
    public Object[] fieldName;
    private Object[] scriptedFieldName;
    public boolean[] hideLegend;
    public boolean[] hideData = null;
    public int[] fieldType;
    public int[] org_fieldType;
    public int[] showAxis;
    public int[] org_showAxis;
    public Axis[] org_colDataAxis;
    public double[] handLength;
    private Hashtable<Object, Integer> hashtbl;
    private Hashtable<Object, Integer> scriptedHashtbl;
    public int sepSize = 1;
    public int sepUnit = -1;
    public boolean isAscending = true;
    public int dataOrder = 0;
    public Date startingDate = null;
    public Date endingDate = null;
    public int tickerSepSize = 1;
    public int maxNumOfTickerAndLabel = -1;
    public IFormat dataFormat;
    public int axisType;
    public static final int SPACE = 0;
    public static final int COMMA = 1;
    public static final int SEMICOLON = 2;
    public static final int TXTFORMAT = 0;
    public static final int XMLFORMAT = 1;
    private String pieOthersSectorName = "Others";
    private boolean isPieWithOthers = false;
    private int uniqueNumber = QbUtil.nextNumber();
    private String address = null;
    private int stringDisplaySize = -1;
    private boolean drawNullColumn = false;
    private String nullColumnName = "NULL";
    public static final String SCRIPTED_VALUE_SET_TO_NULL = "Q#B#S#V#S#T#N";

    protected ColData() {
    }

    public ColData(String colName, int dtype, int noOfCol) {
        this(colName, "", dtype, -1, noOfCol);
    }

    public ColData(String colName, String tableName, int dtype, int noOfCol) {
        this(colName, tableName, dtype, -1, noOfCol);
    }

    public ColData(String colName, int dtype, int initialCapacity, int noOfCol) {
        this(colName, "", dtype, initialCapacity, noOfCol);
    }

    public ColData(String colName, String tableName, int dtype, int initialCapacity, int noOfCol) {
        this(colName, tableName, dtype, initialCapacity, -1, noOfCol);
    }

    public ColData(String colName, String tableName, int dtype, int initialCapacity, int strMaxChar, int noOfCol) {
        this.colName = colName;
        this.tableName = tableName;
        this.colName = colName;
        this.originalType = dtype;
        this.stringDisplaySize = strMaxChar;
        this.dataType = DataType.mapType(dtype);
        this.bNumeric = DataType.isNumeric(this.dataType);
        this.vec = initialCapacity > 0 ? new DataSet(initialCapacity, this.getAddress(), this.getMaxCharForRecordFile(), noOfCol, this.dataType) : new DataSet(this.getAddress(), this.getMaxCharForRecordFile(), noOfCol, this.dataType);
        this.bGenUniqueName = false;
        switch (this.dataType) {
            case 9: {
                this.dataFormat = LocaleDateTimeFormat.getTimeInstance();
                this.axisType = this.dataType;
                break;
            }
            case 8: {
                this.dataFormat = LocaleDateTimeFormat.getDateInstance();
                this.axisType = this.dataType;
                break;
            }
            case 10: {
                this.dataFormat = LocaleDateTimeFormat.getDateTimeInstance();
                this.axisType = this.dataType;
                break;
            }
            case 0: {
                this.dataFormat = new LogicalFormat(1);
                this.axisType = this.dataType;
                break;
            }
            case 1: 
            case 2: 
            case 11: 
            case 12: {
                this.axisType = 99;
                this.dataFormat = LocaleNumericFormat.getNumberInstance();
                ((LocaleNumericFormat)this.dataFormat).getNumberFormat().setMaximumFractionDigits(0);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 13: {
                this.axisType = 99;
                this.dataFormat = LocaleNumericFormat.getNumberInstance();
                break;
            }
            default: {
                this.axisType = 7;
            }
        }
    }

    public void setStringDisplaySize(int disSize) {
        this.stringDisplaySize = disSize;
    }

    public int getStringDisplaySize() {
        return this.stringDisplaySize;
    }

    private int getMaxCharForRecordFile() {
        if ((this.dataType == 6 || this.dataType == 7) && this.stringDisplaySize > 0) {
            return this.stringDisplaySize;
        }
        return ServerMessage.getMaxFieldSize();
    }

    public final int getDataType() {
        return this.dataType;
    }

    public final int getOriginalDataType() {
        return this.originalType;
    }

    public final boolean isNumeric() {
        return this.bNumeric;
    }

    public final boolean isDateTime() {
        return DataType.isDateTime(this.dataType);
    }

    public final String getName() {
        return this.colName;
    }

    public final String getTableName() {
        return this.tableName;
    }

    public final int getSize() {
        return this.vec.size();
    }

    public IDataSet getDataSet() {
        return this.vec;
    }

    public final int getNumField() {
        return this.noUniqueField;
    }

    public final void add(Object elem) {
        if (!DataType.match(this.originalType, elem)) {
            try {
                elem = DataType.createObject(elem.toString(), this.dataType);
            }
            catch (Exception ex) {
                if (!elem.toString().equals("")) {
                    LOGGER.log(Level.FINE, "Warning: NumberFormatException: Record=" + (this.vec.size() + 1) + ", Type=" + this.originalType + ", Value=" + elem.toString(), ex);
                    elem = null;
                }
                LOGGER.log(Level.FINEST, "Empty element will be added into IDataset", ex);
            }
        }
        this.vec.addElement(elem);
    }

    public final Object getData(int i) {
        return this.getData(i, false);
    }

    public final Object getData(int i, boolean forceRawValues) {
        if (!forceRawValues && this.scriptedVec != null && i < this.scriptedVec.size() && this.getScriptedData(i) != null) {
            if (this.getScriptedData(i).equals(SCRIPTED_VALUE_SET_TO_NULL)) {
                return null;
            }
            return this.getScriptedData(i);
        }
        return this.vec.elementAt(i);
    }

    public void removeData(int i) {
        this.vec.removeElementAt(i);
    }

    public final double getValue(int i) {
        return IOUtil2.getValue(this.vec.elementAt(i));
    }

    public Date getStartingDate() {
        if (this.dataType != 9 && this.dataType != 10 && this.dataType != 8) {
            return null;
        }
        if (this.startingDate != null) {
            return this.startingDate;
        }
        return this.calcStartingDate();
    }

    public Date calcStartingDate() {
        Date min = null;
        if (this.fieldName != null) {
            for (Object element : this.fieldName) {
                if (element == null || min != null && !min.after((Date)element)) continue;
                min = (Date)element;
            }
        }
        return min;
    }

    public void setStartingDate(Date date) {
        this.startingDate = date;
    }

    public Date getEndingDate() {
        if (this.dataType != 9 && this.dataType != 10 && this.dataType != 8) {
            return null;
        }
        if (this.endingDate != null) {
            return this.endingDate;
        }
        return this.calcEndingDate();
    }

    public Date calcEndingDate() {
        Date max = null;
        if (this.fieldName != null) {
            for (Object element : this.fieldName) {
                if (element == null || max != null && !max.before((Date)element)) continue;
                max = (Date)element;
            }
        }
        return max;
    }

    public void setEndingDate(Date date) {
        this.endingDate = date;
    }

    void save(DataOutputStream out) throws IOException {
        this.save(out, this.vec.size());
    }

    void save(DataOutputStream out, int nRow) throws IOException {
        IOUtil.writeString(out, this.colName);
        out.writeInt(this.originalType);
        for (int i = 0; i < nRow; ++i) {
            Object obj = this.vec.elementAt(i);
            DataType.write(out, obj);
        }
    }

    public void saveXML(Writer out) throws IOException {
        this.saveXML(out, this.vec.size());
    }

    public void saveXML(Writer out, int nRow) throws IOException {
        out.write("<COLUMN Name=\"" + XMLUtil.encodeXML(this.colName) + "\" Type=\"" + DataType.getTypeName(this.originalType) + "\">\n");
        if (nRow > this.vec.size()) {
            nRow = this.vec.size();
        }
        for (int i = 0; i < nRow; ++i) {
            Object obj = this.vec.elementAt(i);
            out.write("<DATA>" + XMLUtil.encodeXML(DataType.write(obj)) + "</DATA>\n");
        }
        out.write("</COLUMN>\n");
    }

    boolean isPieWithOthers() {
        return this.isPieWithOthers;
    }

    void setPieWithOthers(boolean b) {
        this.isPieWithOthers = b;
    }

    public final void retrieveField() {
        int i;
        if (this.bGenUniqueName) {
            return;
        }
        Vector<Object> set = new Vector<Object>();
        Vector<Object> scriptedSet = new Vector<Object>();
        for (i = 0; i < this.getSize(); ++i) {
            if (this.getData(i, true) == null && this.drawNullColumn && !set.contains(this.nullColumnName)) {
                set.addElement(this.nullColumnName);
            } else if (this.getData(i, true) != null && !set.contains(this.getData(i))) {
                set.addElement(this.getData(i, true));
            }
            if (this.scriptedVec == null) continue;
            scriptedSet.addElement(this.getData(i));
        }
        if (set.size() == 0) {
            set.addElement("");
        }
        if (this.isPieWithOthers) {
            set.addElement(this.pieOthersSectorName);
        }
        this.noUniqueField = set.size();
        this.fieldName = new Object[this.noUniqueField];
        this.originalFieldName = new Object[this.noUniqueField];
        this.scriptedFieldName = scriptedSet.size() > 0 ? new Object[this.noUniqueField] : null;
        this.hideLegend = new boolean[this.noUniqueField];
        if (this.hideData == null || this.hideData.length != this.noUniqueField) {
            this.hideData = new boolean[this.noUniqueField];
        }
        for (i = 0; i < this.noUniqueField; ++i) {
            this.fieldName[i] = set.elementAt(i);
            this.originalFieldName[i] = set.elementAt(i);
            if (scriptedSet.size() <= 0) continue;
            this.scriptedFieldName[i] = scriptedSet.elementAt(i);
        }
        set.removeAllElements();
        set.trimToSize();
        scriptedSet.clear();
        scriptedSet.trimToSize();
        this.bGenUniqueName = true;
    }

    public void setDataOrder(int order) {
        this.dataOrder = order;
    }

    public int getDataOrder() {
        return this.dataOrder;
    }

    public Object[] getSortOrder(boolean asc) {
        int i;
        int nField = this.fieldName.length;
        Object[] sarray = new Object[this.fieldName.length];
        ICompareObject[] obj = new ICompareObject[nField];
        if (this.dataType == 0) {
            for (i = 0; i < nField; ++i) {
                obj[i] = this.fieldName[i] == null || this.fieldName[i].equals("") || !(this.fieldName[i] instanceof Boolean) ? new BooleanCompare(null) : new BooleanCompare((Boolean)this.fieldName[i]);
            }
            sarray = SortObject.sort(obj, asc);
        } else if (DataType.isNumeric(this.dataType)) {
            for (i = 0; i < nField; ++i) {
                obj[i] = this.fieldName[i] == null || this.fieldName[i].equals("") || !(this.fieldName[i] instanceof Number) ? new NumberCompare(null) : new NumberCompare((Number)this.fieldName[i]);
            }
            sarray = SortObject.sort(obj, asc);
        } else if (DataType.isDateTime(this.dataType)) {
            for (i = 0; i < nField; ++i) {
                obj[i] = this.fieldName[i] == null || this.fieldName[i].equals("") || !(this.fieldName[i] instanceof Date) ? new DateCompare(null) : new DateCompare((Date)this.fieldName[i]);
            }
            sarray = SortObject.sort(obj, asc);
        } else if (this.dataType == 7) {
            for (i = 0; i < nField; ++i) {
                obj[i] = new StringCompare((String)this.fieldName[i]);
            }
            sarray = SortObject.sort(obj, asc);
        }
        for (i = 0; i < sarray.length; ++i) {
            if (sarray[i] != null || !this.isDrawNullColumn()) continue;
            sarray[i] = this.getNullColumnName();
        }
        return sarray;
    }

    public int[] setSortOrder(boolean asc) {
        Object[] sarray = this.getSortOrder(asc);
        int[] order = null;
        if (sarray != null) {
            order = this.getNewOrder(sarray);
            if (order == null) {
                return null;
            }
            this.fieldName = sarray;
            this.replaceOrder(order, false);
        }
        return order;
    }

    private int[] getNewStrOrder(Object[] fname) {
        int i;
        if (this.fieldName.length != (fname = this.reconstructOrderList(this.fieldName, fname)).length) {
            return null;
        }
        int nField = fname.length;
        String[] fname_keys = new String[nField];
        String[] cname_keys = new String[nField];
        for (i = 0; i < nField; ++i) {
            fname_keys[i] = fname[i].toString();
        }
        for (i = 0; i < nField; ++i) {
            cname_keys[i] = this.fieldName[i].toString();
        }
        int[] order = new int[nField];
        for (int i2 = 0; i2 < nField; ++i2) {
            boolean found = false;
            for (int j = 0; j < nField; ++j) {
                if (!fname_keys[i2].equals(cname_keys[j])) continue;
                order[i2] = j;
                found = true;
                break;
            }
            if (found) continue;
            return null;
        }
        return order;
    }

    public int[] getNewOrder(Object[] fname) {
        if (fname instanceof String[]) {
            return this.getNewStrOrder(fname);
        }
        Object[] cname = this.fieldName;
        fname = this.reconstructOrderList(this.fieldName, fname);
        int[] order = new int[fname.length];
        for (int i = 0; i < fname.length; ++i) {
            boolean found = false;
            for (int j = 0; j < cname.length; ++j) {
                if (fname[i] == null || cname[j] == null || !fname[i].equals(cname[j])) continue;
                order[i] = j;
                found = true;
                break;
            }
            if (found) continue;
            return null;
        }
        return order;
    }

    private Object[] reconstructOrderList(Object[] fieldList, Object[] orderList) {
        Vector<Object> vec = new Vector<Object>();
        for (Object element : orderList) {
            for (Object element2 : fieldList) {
                if (element == null || element2 == null || !this.equals(element, element2)) continue;
                vec.add(element);
            }
        }
        for (Object element : fieldList) {
            boolean foundIt = false;
            for (Object element2 : orderList) {
                if (element2 == null || element == null || !this.equals(element2, element)) continue;
                foundIt = true;
                break;
            }
            if (foundIt) continue;
            vec.add(element);
        }
        Object[] tmp = new Object[vec.size()];
        for (int i = 0; i < vec.size(); ++i) {
            tmp[i] = vec.elementAt(i);
        }
        return tmp;
    }

    private boolean equals(Object obj1, Object obj2) {
        if (obj1.getClass() == obj2.getClass()) {
            return obj1.equals(obj2);
        }
        return obj1.toString().equals(obj2.toString());
    }

    public void setFieldOrder(int[] order) {
        this.replaceOrder(order, true);
    }

    private void replaceOrder(int[] order, boolean replaceFieldName) {
        int i;
        if (replaceFieldName) {
            this.creatHashTable();
        }
        Object[] obj = new Object[this.fieldName.length];
        boolean[] tmpLegend = new boolean[this.fieldName.length];
        boolean[] tmpData = new boolean[this.fieldName.length];
        int[] tmpType = new int[this.fieldName.length];
        int[] tmpAxis = new int[this.fieldName.length];
        double[] tmpHand = new double[this.fieldName.length];
        boolean setLegend = false;
        if (this.hideLegend != null && this.hideLegend.length == this.fieldName.length) {
            setLegend = true;
        }
        boolean setData = false;
        if (this.hideData != null && this.hideData.length == this.fieldName.length) {
            setData = true;
        }
        boolean setType = false;
        if (this.fieldType != null && this.fieldType.length == this.fieldName.length) {
            setType = true;
        }
        boolean setAxis = false;
        if (this.showAxis != null && this.showAxis.length == this.fieldName.length) {
            setAxis = true;
        }
        boolean setHand = false;
        if (this.handLength != null && this.handLength.length == this.fieldName.length) {
            setHand = true;
        }
        for (int i2 = 0; i2 < this.fieldName.length; ++i2) {
            if (replaceFieldName) {
                obj[i2] = this.fieldName[i2];
            }
            if (setLegend) {
                tmpLegend[i2] = this.hideLegend[i2];
            }
            if (setData) {
                tmpData[i2] = this.hideData[i2];
            }
            if (setType) {
                tmpType[i2] = this.fieldType[i2];
            }
            if (setAxis) {
                tmpAxis[i2] = this.showAxis[i2];
            }
            if (!setHand) continue;
            tmpHand[i2] = this.handLength[i2];
        }
        int[] inv_order = new int[order.length];
        for (i = 0; i < order.length; ++i) {
            inv_order[order[i]] = i;
        }
        for (i = 0; i < this.fieldName.length; ++i) {
            if (replaceFieldName) {
                this.fieldName[i] = obj[order[i]];
            }
            if (setLegend) {
                this.hideLegend[i] = tmpLegend[order[i]];
            }
            if (setData) {
                this.hideData[i] = tmpData[order[i]];
            }
            if (setType) {
                this.fieldType[i] = tmpType[order[i]];
            }
            if (setAxis) {
                this.showAxis[i] = tmpAxis[order[i]];
                if (this.showAxis[i] >= 0 && inv_order.length > this.showAxis[i]) {
                    this.showAxis[i] = inv_order[this.showAxis[i]];
                }
            }
            if (setHand) {
                this.handLength[i] = tmpHand[order[i]];
            }
            if (!replaceFieldName) continue;
            this.hashtbl.put(this.fieldName[i], i);
            if (this.scriptedFieldName == null) continue;
            this.scriptedHashtbl.put(this.scriptedFieldName[i], i);
        }
    }

    final void creatHashTable() {
        this.hashtbl = this.createHashTable(this.hashtbl, this.fieldName);
        if (this.scriptedFieldName != null) {
            this.scriptedHashtbl = this.createHashTable(this.scriptedHashtbl, this.scriptedFieldName);
        }
    }

    final Hashtable<Object, Integer> createHashTable(Hashtable<Object, Integer> hashtbl, Object[] fieldName) {
        if (hashtbl != null) {
            return hashtbl;
        }
        hashtbl = new Hashtable(4 * this.noUniqueField);
        for (int i = 0; i < this.noUniqueField; ++i) {
            hashtbl.put(fieldName[i], i);
        }
        return hashtbl;
    }

    final int mapHashTable(int i) {
        Object obj = this.getData(i);
        Hashtable<Object, Integer> useHashtbl = this.hashtbl;
        if (this.scriptedHashtbl != null) {
            useHashtbl = this.scriptedHashtbl;
        }
        if (obj == null && this.isDrawNullColumn()) {
            return useHashtbl.get(this.getNullColumnName());
        }
        return obj != null && useHashtbl.get(obj) != null ? useHashtbl.get(obj) : -999;
    }

    final void clearHashTable() {
        if (this.hashtbl != null) {
            this.hashtbl.clear();
            this.hashtbl = null;
        }
        if (this.scriptedHashtbl != null) {
            this.scriptedHashtbl.clear();
            this.scriptedHashtbl = null;
        }
    }

    public Object[] getFieldName() {
        return this.getFieldName(true);
    }

    public Object[] getFieldName(boolean includeScripted) {
        if (this.fieldName == null) {
            this.retrieveField();
        }
        if (includeScripted && this.scriptedFieldName != null) {
            return this.scriptedFieldName;
        }
        return this.fieldName;
    }

    public Object[] getOriginalFieldName() {
        if (this.originalFieldName == null) {
            this.retrieveField();
        }
        return this.originalFieldName;
    }

    public boolean[] getHideLegend() {
        return this.hideLegend;
    }

    public void setHideLegend(boolean[] hideLegend) {
        this.hideLegend = hideLegend;
    }

    public boolean[] getHideData() {
        return this.hideData;
    }

    public void setHideData(boolean[] hideData) {
        this.hideData = hideData;
    }

    public int[] getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(int[] fieldType) {
        this.fieldType = fieldType;
    }

    public int[] getAxisPosition() {
        return this.showAxis;
    }

    public void setAxisPosition(int[] showAxis) {
        this.showAxis = showAxis;
    }

    public double[] getHandLength() {
        return this.handLength;
    }

    public void setHandLength(double[] handLength) {
        if (handLength != null) {
            for (int i = 0; i < handLength.length; ++i) {
                if (handLength[i] < 0.0) {
                    handLength[i] = 0.0;
                    continue;
                }
                if (!(handLength[i] > 1.0)) continue;
                handLength[i] = 1.0;
            }
        }
        this.handLength = handLength;
    }

    public boolean showLegend(int i, boolean b) {
        return !this.hideLegend[i] && (!b || !this.hideData[i]);
    }

    void setPieOthersSectorName(String pieOthersSectorName) {
        if (this.isPieWithOthers) {
            if (this.fieldName == null || this.fieldName.length < 1 || !this.fieldName[this.fieldName.length - 1].toString().equals(this.pieOthersSectorName)) {
                return;
            }
            this.fieldName[this.fieldName.length - 1] = pieOthersSectorName;
        }
        this.pieOthersSectorName = pieOthersSectorName;
    }

    public Object[] getLegendNames(boolean b) {
        int i;
        if (this.hideLegend == null || this.hideLegend.length != this.noUniqueField) {
            this.hideLegend = new boolean[this.noUniqueField];
        }
        if (this.hideData == null || this.hideData.length != this.noUniqueField) {
            this.hideData = new boolean[this.noUniqueField];
        }
        int j = 0;
        for (i = 0; i < this.hideLegend.length; ++i) {
            if (!this.showLegend(i, b)) continue;
            ++j;
        }
        Object[] names = new Object[j];
        j = 0;
        for (i = 0; i < this.hideLegend.length; ++i) {
            if (!this.showLegend(i, b)) continue;
            names[j++] = this.fieldName[i];
        }
        return names;
    }

    static ColData[] copyColData(ColData[] cdata) {
        if (cdata == null) {
            return null;
        }
        ColData[] newData = new ColData[cdata.length];
        for (int i = 0; i < newData.length; ++i) {
            newData[i] = new ColData(cdata[i].colName, cdata[i].originalType, 1);
            newData[i].copy(cdata[i]);
        }
        return newData;
    }

    void copyDataFormat(ColData cdata) {
        if (cdata == null) {
            return;
        }
        this.axisType = cdata.axisType;
        this.dataFormat = cdata.dataFormat;
    }

    public void copyAttributes(ColData cdata) {
        if (cdata == null) {
            return;
        }
        this.copyDataFormat(cdata);
        this.sepSize = cdata.sepSize;
        this.sepUnit = cdata.sepUnit;
        this.isAscending = cdata.isAscending;
        this.startingDate = cdata.startingDate;
        this.endingDate = cdata.endingDate;
        this.tickerSepSize = cdata.tickerSepSize;
        this.setDrawNullColumn(cdata.drawNullColumn);
        this.setNullColumnName(cdata.nullColumnName);
        this.nullColumnName = cdata.nullColumnName;
        this.maxNumOfTickerAndLabel = cdata.maxNumOfTickerAndLabel;
        this.pieOthersSectorName = cdata.pieOthersSectorName;
        this.isPieWithOthers = cdata.isPieWithOthers;
        this.dataOrder = cdata.dataOrder;
        this.org_showAxis = cdata.org_showAxis;
        this.org_colDataAxis = cdata.org_colDataAxis;
        this.org_fieldType = cdata.org_fieldType;
        if (this.fieldName != null) {
            this.hideLegend = new boolean[this.fieldName.length];
            this.hideData = new boolean[this.fieldName.length];
            this.fieldType = new int[this.fieldName.length];
            this.showAxis = new int[this.fieldName.length];
            if (cdata.fieldName != null) {
                for (int i = 0; i < this.fieldName.length; ++i) {
                    boolean foundColDataWithTheSameName = false;
                    int ind = -1;
                    for (int j = 0; j < cdata.fieldName.length; ++j) {
                        if (!this.fieldName[i].equals(cdata.fieldName[j])) continue;
                        foundColDataWithTheSameName = true;
                        if (cdata.hideLegend != null) {
                            this.hideLegend[i] = cdata.hideLegend[j];
                        }
                        if (cdata.hideData != null) {
                            this.hideData[i] = cdata.hideData[j];
                        }
                        ind = j;
                        break;
                    }
                    if (!foundColDataWithTheSameName) {
                        ind = i;
                    }
                    this.showAxis[i] = cdata.showAxis != null ? (ind < cdata.showAxis.length ? cdata.showAxis[ind] : -1) : -1;
                    this.fieldType[i] = cdata.fieldType != null ? (ind < cdata.fieldType.length ? cdata.fieldType[ind] : (i == 0 ? 7 : (i == 1 ? 0 : 3))) : (i == 0 ? 7 : (i == 1 ? 0 : 3));
                    if (cdata.handLength == null) continue;
                    if (this.handLength == null) {
                        this.handLength = new double[this.fieldName.length];
                    }
                    this.handLength[i] = ind < cdata.handLength.length ? cdata.handLength[ind] : (double)(this.fieldName.length - i) * (0.9 / (double)this.fieldName.length);
                }
            }
        }
    }

    protected void copy(ColData cdata) {
        int i;
        this.dataType = cdata.dataType;
        this.originalType = cdata.originalType;
        this.vec = cdata.vec;
        this.scriptedVec = cdata.scriptedVec;
        this.colName = cdata.colName;
        this.tableName = cdata.tableName;
        this.bNumeric = cdata.bNumeric;
        this.bGenUniqueName = cdata.bGenUniqueName;
        this.noUniqueField = cdata.noUniqueField;
        this.setDrawNullColumn(cdata.drawNullColumn);
        this.setNullColumnName(cdata.nullColumnName);
        if (cdata.originalFieldName != null) {
            this.originalFieldName = new Object[cdata.originalFieldName.length];
            for (i = 0; i < this.originalFieldName.length; ++i) {
                this.originalFieldName[i] = cdata.originalFieldName[i];
            }
        } else {
            this.fieldName = cdata.fieldName;
        }
        if (cdata.fieldName != null) {
            this.fieldName = new Object[cdata.fieldName.length];
            for (i = 0; i < this.fieldName.length; ++i) {
                this.fieldName[i] = cdata.fieldName[i];
            }
        } else {
            this.fieldName = cdata.fieldName;
        }
        if (cdata.scriptedFieldName != null) {
            this.scriptedFieldName = new Object[cdata.scriptedFieldName.length];
            for (i = 0; i < this.scriptedFieldName.length; ++i) {
                this.scriptedFieldName[i] = cdata.scriptedFieldName[i];
            }
        }
        if (cdata.hideLegend != null) {
            this.hideLegend = new boolean[cdata.hideLegend.length];
            for (i = 0; i < this.hideLegend.length; ++i) {
                this.hideLegend[i] = cdata.hideLegend[i];
            }
        } else {
            this.hideLegend = cdata.hideLegend;
        }
        if (cdata.hideData != null) {
            this.hideData = new boolean[cdata.hideData.length];
            for (i = 0; i < this.hideData.length; ++i) {
                this.hideData[i] = cdata.hideData[i];
            }
        } else {
            this.hideData = cdata.hideData;
        }
        if (cdata.fieldType != null) {
            this.fieldType = new int[cdata.fieldType.length];
            for (i = 0; i < this.fieldType.length; ++i) {
                this.fieldType[i] = cdata.fieldType[i];
            }
        } else {
            this.fieldType = cdata.fieldType;
        }
        if (cdata.showAxis != null) {
            this.showAxis = new int[cdata.showAxis.length];
            for (i = 0; i < this.showAxis.length; ++i) {
                this.showAxis[i] = cdata.showAxis[i];
            }
        } else {
            this.showAxis = cdata.showAxis;
        }
        if (cdata.showAxis != null) {
            this.showAxis = new int[cdata.showAxis.length];
            for (i = 0; i < this.showAxis.length; ++i) {
                this.showAxis[i] = cdata.showAxis[i];
            }
        } else {
            this.showAxis = cdata.showAxis;
        }
        if (cdata.handLength != null) {
            this.handLength = new double[cdata.handLength.length];
            for (i = 0; i < this.handLength.length; ++i) {
                this.handLength[i] = cdata.handLength[i];
            }
        } else {
            this.handLength = cdata.handLength;
        }
        this.hashtbl = cdata.hashtbl;
        this.scriptedHashtbl = cdata.scriptedHashtbl;
        this.org_showAxis = cdata.org_showAxis;
        this.org_colDataAxis = cdata.org_colDataAxis;
        this.org_fieldType = cdata.org_fieldType;
        this.sepSize = cdata.sepSize;
        this.sepUnit = cdata.sepUnit;
        this.isAscending = cdata.isAscending;
        this.startingDate = cdata.startingDate;
        this.endingDate = cdata.endingDate;
        this.tickerSepSize = cdata.tickerSepSize;
        this.maxNumOfTickerAndLabel = cdata.maxNumOfTickerAndLabel;
        this.dataFormat = cdata.dataFormat;
        this.dataOrder = cdata.dataOrder;
        this.axisType = cdata.axisType;
        this.pieOthersSectorName = cdata.pieOthersSectorName;
        this.isPieWithOthers = cdata.isPieWithOthers;
        this.uniqueNumber = cdata.uniqueNumber;
        this.address = cdata.address;
        this.stringDisplaySize = cdata.stringDisplaySize;
    }

    public final boolean isDrawNullColumn() {
        return this.drawNullColumn;
    }

    public final void setDrawNullColumn(boolean b) {
        if (b == this.drawNullColumn) {
            return;
        }
        this.drawNullColumn = b;
    }

    public final String getNullColumnName() {
        return this.nullColumnName;
    }

    public final void setNullColumnName(String str) {
        if (this.nullColumnName.equals(str)) {
            return;
        }
        this.nullColumnName = str;
    }

    public static final ColData[] getColData(IResultSet rs) throws Exception {
        IRSMetaData md = rs.getMetaData();
        int rowLength = md.getColumnCount();
        ColData[] colData = new ColData[rowLength + 1];
        for (int i = 0; i < rowLength; ++i) {
            colData[i] = new ColData(md.getColumnName(i + 1), "", md.getColumnType(i + 1), -1, ColData.getColumnDisplaySize(md, i + 1), colData.length);
        }
        colData[rowLength] = new ColData("qbCount", 4, colData.length);
        int recNo = 0;
        while (rs.next()) {
            for (int i = 0; i < rowLength; ++i) {
                colData[i].add(rs.getObject(i + 1));
            }
            colData[rowLength].add(recNo++);
        }
        try {
            rs.close();
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to close ResultSet", ex);
        }
        return colData;
    }

    private static int getColumnDisplaySize(IRSMetaData mData, int col) throws Exception {
        if (mData instanceof QueryResultSet) {
            return ((QueryResultSet)mData).getColumnDisplaySize(col);
        }
        if (mData instanceof ColDataResultSet) {
            return ((ColDataResultSet)mData).getColumnDisplaySize(col);
        }
        return -1;
    }

    public static IResultSet getResultSet(ColData[] dataSet) {
        return new ColDataResultSet(dataSet);
    }

    public static final ColData[] getColData(ISpreadSheetModel ss) {
        ColData[] colData = new ColData[4];
        int rowCount = ss.getRowCount();
        int columnCount = ss.getColumnCount();
        int vectorSize = rowCount * columnCount;
        colData[0] = new ColData("RowLabel", ss.getRowLabelType(), vectorSize, colData.length);
        colData[1] = new ColData("ColumnLabel", ss.getColumnLabelType(), vectorSize, colData.length);
        colData[2] = new ColData("Value", ss.getValueType(), vectorSize, colData.length);
        colData[3] = new ColData("qbCount", 4, vectorSize, colData.length);
        int recNo = 0;
        for (int i = 1; i <= rowCount; ++i) {
            Object rowValue = ss.getRowLabel(i);
            for (int j = 1; j <= columnCount; ++j) {
                colData[0].add(rowValue);
                Object columnValue = ss.getColumnLabel(j);
                colData[1].add(columnValue);
                Object value = ss.getValueAt(i, j);
                colData[2].add(value);
                colData[3].add(recNo++);
            }
        }
        return colData;
    }

    public static ColData[] getColData(Object[] sourceList, int[] sourceType, boolean[] doTranspose, Object[] transposeColList, boolean isMergedDataTransposed, boolean[] transposeCol, boolean useDBbuffer) throws Exception {
        IResultSet rs;
        Vector<ColData[]> colDataList = new Vector<ColData[]>();
        if (transposeColList == null) {
            transposeColList = new Object[sourceList.length];
        }
        for (int i = 0; i < sourceList.length; ++i) {
            Object temp = sourceList[i];
            if (temp instanceof DBInfoBasic) {
                colDataList.addElement(DBAccess.retrieveResult(null, (DBInfoBasic)temp, useDBbuffer, doTranspose[i], (boolean[])transposeColList[i], null, null));
                continue;
            }
            if (temp instanceof XMLFileQueryInfo) {
                XMLFileQueryInfo xmlInfo = (XMLFileQueryInfo)temp;
                colDataList.addElement(new DataFileInput().readProcessedData(xmlInfo.getFileName(), doTranspose[i], (boolean[])transposeColList[i], null, null, xmlInfo, 7));
                continue;
            }
            if (temp instanceof EJBInfo) {
                EJBInfo info = (EJBInfo)temp;
                colDataList.addElement(EJBAccess.retrieveResult(info.getJNDIName(), info.getHomeName(), info.getRemoteName(), info.getSelectedMethodName(), info.getSelectedMethodParamVal(), info.getEnvironment(), doTranspose[i], (boolean[])transposeColList[i], null, null));
                continue;
            }
            colDataList.addElement(new DataFileInput().readProcessedData((String)temp, doTranspose[i], (boolean[])transposeColList[i], null, sourceType[i]));
        }
        ColData[] colData = ColData.merge(colDataList, true);
        if (isMergedDataTransposed && (rs = TransposeRS.doTranspose(colData, transposeCol)) != null) {
            colData = ColData.getColData(rs);
        }
        return colData;
    }

    public static void print(PrintStream out, ColData[] colData, int separator, int format) {
        if (colData == null || colData.length <= 0) {
            return;
        }
        if (format == 1) {
            ColData.printToXML(out, colData);
        } else {
            ColData.printToTXT(out, colData, separator);
        }
    }

    private static void printToTXT(PrintStream out, ColData[] colData, int separator) {
        int nCol = colData.length - 1;
        String dataType = "";
        String fieldName = "";
        String sep = " ";
        if (separator == 1) {
            sep = ", ";
        } else if (separator == 2) {
            sep = "; ";
        }
        for (int i = 0; i < nCol; ++i) {
            if (i == 0) {
                dataType = DataType.getTypeName(colData[i].getOriginalDataType());
                fieldName = "\"" + colData[i].getName() + "\"";
                continue;
            }
            dataType = dataType + sep + DataType.getTypeName(colData[i].getOriginalDataType());
            fieldName = fieldName + sep + "\"" + colData[i].getName() + "\"";
        }
        out.println(dataType);
        out.println(fieldName);
        int nRow = colData[0].getSize();
        for (int i = 0; i < nRow; ++i) {
            String row = "";
            for (int j = 0; j < nCol; ++j) {
                Object obj = colData[j].getData(i);
                if (obj != null) {
                    obj = obj.toString().replace("\r", "\\r");
                    obj = obj.toString().replace("\t", "\\t");
                    obj = obj.toString().replace("\f", "\\f");
                    obj = obj.toString().replace("\n", " \\n");
                }
                row = j == 0 ? ColData.toString(obj, true) : row + sep + ColData.toString(obj, true);
            }
            out.println(row);
        }
    }

    private static void printToXML(PrintStream ps, ColData[] colData) {
        int i;
        PrintStream out;
        try {
            out = new PrintStream((OutputStream)ps, false, ServerMessage.xmlEncoding);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.log(Level.WARNING, "Unsupported encoding", e);
            throw new IllegalArgumentException("Unsupported encoding " + ServerMessage.xmlEncoding);
        }
        out.println("<?xml version=\"1.0\" encoding=\"" + ServerMessage.xmlEncoding + "\"?>\n");
        out.println("<EspressData>");
        int nCol = colData.length - 1;
        for (i = 0; i < nCol; ++i) {
            out.println("  <DataType>" + DataType.getTypeName(colData[i].getOriginalDataType()) + "</DataType>");
        }
        out.println();
        for (i = 0; i < nCol; ++i) {
            out.println("  <FieldName><![CDATA[" + colData[i].getName() + "]]></FieldName>");
        }
        out.println();
        int nRow = colData[0].getSize();
        for (int i2 = 0; i2 < nRow; ++i2) {
            out.println("  <Row>");
            for (int j = 0; j < nCol; ++j) {
                out.println("    <Data><![CDATA[" + ColData.toString(colData[j].getData(i2), false) + "]]></Data>");
            }
            out.println("  </Row>");
        }
        out.println("</EspressData>");
    }

    private static String toString(Object obj, boolean quote) {
        if (obj == null) {
            return "\"\"";
        }
        if (!quote) {
            return obj.toString();
        }
        if (obj instanceof Number) {
            return obj.toString();
        }
        return "\"" + obj.toString() + "\"";
    }

    public static ColData[] merge(Vector colList, boolean fillInNullData) throws Exception {
        int i;
        if (colList.size() == 1) {
            return (ColData[])colList.elementAt(0);
        }
        int nRow = ColData.getRowCount(colList, 0);
        int nCol = ColData.getColumnCount(colList, 0);
        for (int i2 = 1; i2 < colList.size(); ++i2) {
            if (!fillInNullData && nRow != ColData.getRowCount(colList, i2)) {
                throw new Exception("Cannot merge: All data must have same number of rows!");
            }
            nRow = nRow > ColData.getRowCount(colList, i2) ? nRow : ColData.getRowCount(colList, i2);
            nCol += ColData.getColumnCount(colList, i2);
        }
        ColData[] mergeCol = new ColData[nCol + 1];
        int idx = 0;
        for (i = 0; i < colList.size(); ++i) {
            int nSheetCol = ColData.getColumnCount(colList, i);
            int nSheetRow = ColData.getRowCount(colList, i);
            for (int j = 0; j < nSheetCol; ++j) {
                ColData tmpCol = ((ColData[])colList.elementAt(i))[j];
                String colName = ColData.getColumnName(tmpCol.getName(), mergeCol);
                mergeCol[idx] = new ColData(colName, "", tmpCol.getOriginalDataType(), -1, tmpCol.getStringDisplaySize(), mergeCol.length);
                mergeCol[idx].vec = (IDataSet)tmpCol.vec.clone();
                for (int k = nSheetRow; k < nRow; ++k) {
                    mergeCol[idx].add(null);
                    mergeCol[idx].bGenUniqueName = false;
                }
                ++idx;
            }
        }
        mergeCol[idx] = new ColData("qbCount", 4, mergeCol.length);
        for (i = 0; i < nRow; ++i) {
            mergeCol[idx].add(i);
        }
        return mergeCol;
    }

    private static String getColumnName(String name, ColData[] mergeCol) {
        int idx = 2;
        if (!ColData.isColumnNameExisted(name, mergeCol)) {
            return name;
        }
        while (ColData.isColumnNameExisted(name + "_" + idx, mergeCol)) {
            ++idx;
        }
        return name + "_" + idx;
    }

    private static boolean isColumnNameExisted(String name, ColData[] mergeCol) {
        for (ColData element : mergeCol) {
            if (element == null || !element.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private static int getRowCount(Vector colList, int i) {
        if (colList == null || colList.isEmpty()) {
            return 0;
        }
        return ((ColData[])colList.elementAt(i))[0].getSize();
    }

    private static int getColumnCount(Vector colList, int i) {
        if (colList == null || colList.isEmpty()) {
            return 0;
        }
        return ((ColData[])colList.elementAt(i)).length - 1;
    }

    protected void finalize() throws Throwable {
        try {
            this.vec.cleanup();
            if (this.scriptedVec != null) {
                this.scriptedVec.cleanup();
            }
        }
        finally {
            super.finalize();
        }
    }

    public Vector getDistinctValue() {
        Vector<Object> value = new Vector<Object>();
        for (int i = 0; i < this.getSize(); ++i) {
            boolean duplicate = false;
            for (int j = 0; j < value.size(); ++j) {
                if (this.getData(i) == null || !this.getData(i).equals(value.elementAt(j))) continue;
                duplicate = true;
                break;
            }
            if (duplicate || this.getData(i) == null) continue;
            value.addElement(this.getData(i));
        }
        return value;
    }

    private String getAddress() {
        if (this.address == null) {
            this.address = String.valueOf(this.uniqueNumber);
        }
        return this.address;
    }

    public IDataSet getScriptedVec() {
        return this.scriptedVec;
    }

    public final void setScriptedValAt(Object elem, int index) {
        if (this.scriptedVec.size() < index) {
            for (int i = this.scriptedVec.size(); i < index; ++i) {
                this.scriptedVec.insertElementAt(null, i);
            }
        } else if (this.scriptedVec.size() > index) {
            this.scriptedVec.removeElementAt(index);
        }
        this.scriptedVec.insertElementAt(elem, index);
    }

    public final Object getScriptedData(int i) {
        return this.scriptedVec.elementAt(i);
    }

    public void removeScriptedData(int i) {
        if (i < this.scriptedVec.size()) {
            this.scriptedVec.removeElementAt(i);
        }
    }

    public void initializeScriptedData() {
        if (this.vec != null) {
            this.scriptedVec = (IDataSet)this.vec.cloneStructure();
        }
    }

    public static boolean isColDataCompatible(ColData[] oldColData, ColData[] newColData) {
        if (oldColData != null && newColData != null) {
            if (oldColData.length != newColData.length) {
                return false;
            }
            for (int i = 0; i < oldColData.length; ++i) {
                if (oldColData[i].getOriginalDataType() == newColData[i].getOriginalDataType()) continue;
                return false;
            }
            return true;
        }
        return oldColData == null && newColData == null;
    }

    public static boolean isTransposed(ColData[] colData) {
        if (colData == null) {
            return false;
        }
        boolean columnLabelFound = false;
        boolean valueFound = false;
        for (ColData data : colData) {
            if ("ColumnLabel".equals(data.getName())) {
                columnLabelFound = true;
                continue;
            }
            if (!"Value".equals(data.getName())) continue;
            valueFound = true;
        }
        return columnLabelFound && valueFound;
    }
}

