/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.chart.ColData;
import quadbase.chart.DataFileInput;
import quadbase.chart.FilterInfo;
import quadbase.chart.IOUtil2;
import quadbase.chart.PreprocInfo;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.QbCallableStatement;
import quadbase.common.util.internal.QbConnection;
import quadbase.queryproc.IQueryProc;
import quadbase.queryproc.IQueryProcFactory;
import quadbase.queryproc.filter.EqFilter;
import quadbase.queryproc.filter.FilterResultSet;
import quadbase.queryproc.filter.RunSimpleFilter;
import quadbase.util.IResultSet;
import quadbase.util.QueryResultSet;
import quadbase.util.internal.IOUtil;
import quadbase.util.internal.TransposeRS;

public class DBAccess {
    private static final Logger LOGGER = Logger.getLogger(DBAccess.class.getName());

    public static ColData[] retrieveResult(Vector parameters, DBInfoBasic dbInfo, boolean useDBbuffer, boolean transposeData, boolean[] transposeCol, FilterInfo filtInfo, PreprocInfo procInfo) throws Exception {
        return DBAccess.retrieveResult(parameters, dbInfo, useDBbuffer, transposeData, transposeCol, filtInfo, procInfo, 0, -1);
    }

    public static ColData[] retrieveResult(Vector parameters, DBInfoBasic dbInfo, boolean useDBbuffer, boolean transposeData, boolean[] transposeCol, FilterInfo filtInfo, PreprocInfo procInfo, int startIndex, int displayRow) throws Exception {
        return DBAccess.retrieveResult(parameters, dbInfo, useDBbuffer, transposeData, transposeCol, filtInfo, procInfo, startIndex, displayRow, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ColData[] retrieveResult(Vector parameters, DBInfoBasic dbInfo, boolean useDBbuffer, boolean transposeData, boolean[] transposeCol, FilterInfo filtInfo, PreprocInfo procInfo, int startIndex, int displayRow, boolean isDrawNullColumn, String nullColumnName) throws Exception {
        ColData[] colData;
        if (ServerMessage.useServer) {
            ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
            DataOutputStream dout = new DataOutputStream(bstream);
            int messageType = -1;
            if (filtInfo != null || procInfo != null) {
                dout.writeShort(27587);
                messageType = 27587;
            } else {
                dout.writeShort(24097);
                messageType = 24097;
            }
            dbInfo.write(dout);
            boolean hasParameter = QueryFileInfo.hasParameter(parameters);
            dout.writeBoolean(hasParameter);
            if (hasParameter) {
                DBAccess.findInParam(parameters).write(dout);
            }
            dout.writeBoolean(useDBbuffer);
            dout.writeBoolean(transposeData);
            IOUtil.writeBooleans(dout, transposeCol);
            dout.writeInt(startIndex);
            dout.writeInt(displayRow);
            dout.writeBoolean(isDrawNullColumn);
            IOUtil.writeStr(dout, nullColumnName);
            if (messageType == 27587) {
                dout.writeBoolean(filtInfo != null);
                if (filtInfo != null) {
                    filtInfo.writeAsStream(dout);
                }
                dout.writeBoolean(procInfo != null);
                if (procInfo != null) {
                    procInfo.writeAsStream(dout);
                }
            }
            IConnection socket = null;
            try {
                socket = ServerMessage.createConnection();
                byte[] array = bstream.toByteArray();
                socket.setContentLength(array.length);
                socket.getOutputStream().write(array);
                socket.getOutputStream().flush();
            }
            catch (Exception ex) {
                if (socket != null) {
                    socket.close();
                }
                LOGGER.log(Level.SEVERE, "Failed to contact EspressManager at " + ServerMessage.getServerInfo(), ex);
                throw new IOException("Failed to contact EspressManager at " + ServerMessage.getServerInfo() + " " + ex.getMessage());
            }
            byte[] indata = null;
            try {
                DataInputStream instream = new DataInputStream(socket.getInputStream());
                int code = instream.readInt();
                if (code != 0) {
                    throw new SQLException(IOUtil2.getErrorString(code) + "\n" + IOUtil.readString(instream, true));
                }
                indata = new byte[instream.readInt()];
                instream.readFully(indata, 0, indata.length);
                instream.close();
                socket.close();
            }
            catch (Exception ex) {
                try {
                    socket.close();
                }
                catch (Exception ex2) {
                    LOGGER.log(Level.FINEST, "Failed to close socket", ex2);
                }
                LOGGER.log(Level.FINE, "Failed to read data from remote server", ex);
                throw ex;
            }
            catch (Error err) {
                try {
                    socket.close();
                }
                catch (Exception ex2) {
                    LOGGER.log(Level.FINEST, "Failed to close socket", ex2);
                }
                LOGGER.log(Level.FINE, "Failed to read data from remote server", err);
                throw new SQLException(err.toString());
            }
            DataInputStream binput = new DataInputStream(new ByteArrayInputStream(indata));
            return DataFileInput.getColDataFromStream(binput);
        }
        Connection conn = dbInfo.openConnection();
        try {
            IResultSet rs = DBAccess.getResultSetFromLocal(parameters, conn, dbInfo.getQuery(), transposeData, transposeCol, filtInfo, procInfo, isDrawNullColumn, nullColumnName);
            colData = ColData.getColData(rs);
        }
        finally {
            if (dbInfo.isCloseConnectionEnabled()) {
                conn.close();
            }
        }
        return colData;
    }

    private static IResultSet getResultSetFromLocal(Vector parameters, Connection conn, String query, boolean transposeData, boolean[] transposeCol, FilterInfo filtInfo, PreprocInfo procInfo, boolean isDrawNullColumn, String nullColumnName) throws Exception {
        Statement stmt;
        boolean isResult;
        query = query.trim();
        boolean hasParameter = QueryFileInfo.hasParameter(parameters);
        String productName = "";
        try {
            productName = conn.getMetaData().getDatabaseProductName();
        }
        catch (Exception ex) {
            LOGGER.fine("Failed to read meta data from Connection");
        }
        if (QueryParser.isCallableStmt(query)) {
            if (hasParameter) {
                query = DBAccess.findInParam(parameters).convertToJDBCquery(query);
            }
            CallableStatement callstmt = conn instanceof QbConnection ? conn.prepareCall(query) : new QbCallableStatement(conn, query);
            if (hasParameter) {
                DBAccess.findInParam(parameters).setStmtValue(callstmt);
            }
            isResult = callstmt.execute();
            stmt = callstmt;
        } else if (QueryParser.isPreparedStmt(query)) {
            if (hasParameter) {
                query = DBAccess.findInParam(parameters).convertToJDBCquery(query);
            }
            PreparedStatement pStmt = conn.prepareStatement(query);
            if (hasParameter) {
                DBAccess.findInParam(parameters).setStmtValue(pStmt);
            }
            isResult = pStmt.execute();
            stmt = pStmt;
        } else {
            stmt = conn.createStatement();
            isResult = stmt.execute(query);
        }
        while (!isResult) {
            if (stmt.getUpdateCount() == -1) {
                stmt.close();
                throw new SQLException("No result set return !");
            }
            isResult = stmt.getMoreResults();
        }
        QueryResultSet rs = new QueryResultSet(stmt, productName);
        return DBAccess.processResultSet(rs, true, transposeData, transposeCol, filtInfo, procInfo, isDrawNullColumn, nullColumnName);
    }

    public static IResultSet processResultSet(IResultSet rs, boolean isFromDatabase, boolean transposeData, boolean[] transposeCol, FilterInfo filtInfo, PreprocInfo procInfo) throws Exception {
        return DBAccess.processResultSet(rs, isFromDatabase, transposeData, transposeCol, filtInfo, procInfo, false, null);
    }

    public static IResultSet processResultSet(IResultSet rs, boolean isFromDatabase, boolean transposeData, boolean[] transposeCol, FilterInfo filtInfo, PreprocInfo procInfo, boolean drawNullColumn, String nullHandleName) throws Exception {
        if (transposeData) {
            rs = TransposeRS.doTranspose(rs, transposeCol);
        }
        if (filtInfo != null) {
            RunSimpleFilter rsf = new RunSimpleFilter();
            int[] compareOp = filtInfo.getCompareOp();
            int[] colIndex = filtInfo.getColIndex();
            Object[] value = filtInfo.getValue();
            for (int i = 0; i < filtInfo.getSize(); ++i) {
                if (compareOp[i] != 0) continue;
                rsf.andCondition(new EqFilter(colIndex[i], value[i]));
            }
            rs = rsf.run(rs);
        }
        if (procInfo != null) {
            Class<?> factoryClass = Class.forName("quadbase.queryproc.ChartDelegate");
            IQueryProcFactory factory = (IQueryProcFactory)factoryClass.newInstance();
            IQueryProc q = factory.createQueryProc(procInfo.getSelectionColType(), isFromDatabase);
            q.setDrawNullColumn(drawNullColumn, nullHandleName);
            if (isFromDatabase && filtInfo != null) {
                ((FilterResultSet)rs).setIQueryProc(q);
            }
            q.setInputResultSet(rs);
            q.setInputInfo(procInfo);
            q.run();
            rs = q.getOutputRows();
        }
        return rs;
    }

    private static QueryInParamSet findInParam(Vector parameter) {
        for (int i = 0; i < parameter.size(); ++i) {
            Object target = parameter.elementAt(i);
            if (!(target instanceof QueryInParamSet)) continue;
            return (QueryInParamSet)target;
        }
        return null;
    }
}

