/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.awt.Color;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.chart.Chart;
import quadbase.chart.ChartColorSet;
import quadbase.chart.ColData;
import quadbase.chart.DataPointAttribute;
import quadbase.chart.MultiDimData;
import quadbase.chart.QbPattern;
import quadbase.util.internal.IOUtil;

public class DataAttribute
implements Cloneable {
    private static final Logger LOGGER = Logger.getLogger(DataAttribute.class.getName());
    public int dim;
    public Color[] dataColor;
    public int[] dataShape;
    public int[] dataSize;
    public int[] lineThickness;
    public boolean[] slice;
    public int chartType;
    public boolean is2DChart;
    public Color rootPointColor;
    public int rootPointShape;
    public int rootPointSize;
    public int rootLineThickness = 2;
    public String[] name = null;
    public DataAttribute unusedDataAttribute = null;

    public DataAttribute(MultiDimData mData, boolean isMData2, boolean is2DChart, int chartType) {
        this(mData, isMData2, is2DChart, chartType, false, false);
    }

    public DataAttribute(MultiDimData mData, boolean isMData2, boolean is2DChart, int chartType, boolean genName) {
        this(mData, isMData2, is2DChart, chartType, genName, false);
    }

    public DataAttribute() {
    }

    public DataAttribute(MultiDimData mData, boolean isMData2, boolean is2DChart, int chartType, boolean genName, boolean uniqueColorForCol) {
        int i;
        this.chartType = chartType;
        this.is2DChart = is2DChart;
        MultiDimData data = mData;
        this.dim = 0;
        this.rootPointColor = data.point.color;
        this.rootPointShape = data.point.shape;
        this.rootPointSize = data.point.size;
        this.rootLineThickness = data.getLineThickness();
        this.unusedDataAttribute = isMData2 ? data.chart.unusedDataAttribute2 : data.chart.unusedDataAttribute;
        while (data.multiData != null) {
            data = data.multiData[0];
            ++this.dim;
        }
        ColData cd = null;
        if ((Chart.isCoordinateType(chartType) || chartType == 7 || chartType == 8 && is2DChart || Chart.isHiLowChart(chartType) || chartType == 14 || chartType == 3 && data.chart.isSyncPointColorForLine() || isMData2) && this.dim == 1 || (chartType == 0 || chartType == 1) && data.chart.isSingleColorForCategories()) {
            this.dataColor = new Color[1];
            this.dataShape = new int[1];
            this.dataSize = new int[1];
            this.lineThickness = new int[1];
            if (genName) {
                cd = mData.chart.colData[mData.chart.mDataMap[0]];
                this.name = new String[1];
                this.name[0] = !Chart.isCoordinateType(mData.chart.chartType) ? cd.getName() : "Default";
            }
            this.dataColor[0] = mData.area.areaColor;
            this.dataShape[0] = mData.point.shape;
            this.dataSize[0] = mData.point.size;
            this.lineThickness[0] = mData.getLineThickness();
            return;
        }
        if (Chart.stackType(chartType) && this.dim == 2) {
            MultiDimData md = mData.multiData[0];
            int len = md.multiData.length;
            this.dataColor = new Color[len];
            this.dataShape = new int[len];
            this.dataSize = new int[len];
            this.lineThickness = new int[len];
            if (genName) {
                this.name = new String[len];
                cd = mData.chart.colData[mData.chart.mDataMap[1]];
            }
            for (int i2 = 0; i2 < len; ++i2) {
                this.dataColor[i2] = md.multiData[i2].area.areaColor;
                this.dataShape[i2] = md.multiData[i2].point.shape;
                this.dataSize[i2] = md.multiData[i2].point.size;
                this.lineThickness[i2] = md.multiData[i2].getLineThickness();
                if (!genName || i2 >= cd.getFieldName().length) continue;
                this.name[i2] = cd.getFieldName()[i2].toString().trim();
            }
            return;
        }
        if (Chart.stackType(chartType) && this.dim == 3) {
            int len1 = mData.multiData.length;
            int len2 = mData.multiData[0].multiData[0].multiData.length;
            int len = len1 * len2;
            this.dataColor = new Color[len];
            this.dataShape = new int[len];
            this.dataSize = new int[len];
            this.lineThickness = new int[len];
            ColData cd2 = null;
            if (genName) {
                cd = mData.chart.colData[mData.chart.mDataMap[0]];
                cd2 = mData.chart.colData[mData.chart.mDataMap[2]];
                this.name = new String[len];
            }
            int k = 0;
            String s = null;
            for (int i3 = 0; i3 < len1; ++i3) {
                MultiDimData data2 = mData.multiData[i3].multiData[0];
                if (genName) {
                    s = cd.getFieldName()[i3].toString().trim() + ", ";
                }
                for (int j = 0; j < len2; ++j) {
                    MultiDimData data3 = data2.multiData[j];
                    if (genName) {
                        this.name[k] = s + cd2.getFieldName()[j].toString().trim();
                    }
                    this.dataColor[k] = data3.area.areaColor;
                    this.dataShape[k] = data3.point.shape;
                    this.dataSize[k] = data3.point.size;
                    this.lineThickness[k] = data3.getLineThickness();
                    ++k;
                }
            }
            return;
        }
        if (uniqueColorForCol && mData.multiData[0].multiData != null) {
            int len = mData.multiData.length;
            int len2 = mData.multiData[0].multiData.length;
            this.dataColor = new Color[len * len2];
            this.dataShape = new int[len * len2];
            this.dataSize = new int[len * len2];
            this.lineThickness = new int[len * len2];
            ColData cd2 = null;
            if (genName) {
                cd = mData.chart.colData[mData.chart.mDataMap[0]];
                cd2 = mData.chart.colData[mData.chart.mDataMap[1]];
                this.name = new String[len * len2];
            }
            int k = 0;
            String s = null;
            for (int i4 = 0; i4 < len2; ++i4) {
                if (genName) {
                    s = cd2.getFieldName()[i4].toString().trim() + ", ";
                }
                for (int j = 0; j < len; ++j) {
                    this.dataColor[k] = mData.multiData[j].multiData[i4].area.areaColor;
                    this.dataShape[k] = mData.multiData[j].point.shape;
                    this.dataSize[k] = mData.multiData[j].point.size;
                    this.lineThickness[k] = mData.multiData[j].getLineThickness();
                    if (genName) {
                        this.name[k] = s + cd.getFieldName()[j].toString().trim();
                    }
                    ++k;
                }
            }
            return;
        }
        int len = mData.multiData.length;
        this.dataColor = new Color[len];
        this.dataShape = new int[len];
        this.dataSize = new int[len];
        this.lineThickness = new int[len];
        if (genName) {
            cd = mData.chart.colData[mData.chart.mDataMap[0]];
            this.name = new String[len];
        }
        if (Chart.isCircularChart(chartType)) {
            this.slice = new boolean[len];
        }
        int k = 0;
        for (i = 0; i < len; ++i) {
            if (Chart.isCircularChart(chartType) && mData.multiData[i].plotData != null && mData.multiData[i].plotData.isPieOthersSector()) {
                this.dataColor[len - 1] = mData.multiData[i].area.areaColor;
                this.dataShape[len - 1] = mData.multiData[i].point.shape;
                this.dataSize[len - 1] = mData.multiData[i].point.size;
                this.lineThickness[len - 1] = mData.multiData[i].getLineThickness();
                if (!genName || i >= cd.getFieldName().length) continue;
                this.name[len - 1] = cd.getFieldName()[i].toString().trim();
                continue;
            }
            this.dataColor[k] = mData.multiData[i].area.areaColor;
            this.dataShape[k] = mData.multiData[i].point.shape;
            this.dataSize[k] = mData.multiData[i].point.size;
            this.lineThickness[k] = mData.multiData[i].getLineThickness();
            if (genName && cd.getFieldName() != null && i < cd.getFieldName().length) {
                this.name[k] = cd.getFieldName()[i].toString().trim();
            }
            ++k;
        }
        for (i = 0; i < len; ++i) {
            if (!Chart.isCircularChart(chartType)) continue;
            if (mData.chart.dataDim == 2) {
                if (mData.multiData[i].multiData == null) continue;
                this.slice[i] = mData.multiData[i].multiData[0].plotData.bSlice;
                continue;
            }
            if (mData.multiData[i].plotData == null) continue;
            this.slice[i] = mData.multiData[i].plotData.bSlice;
        }
        if ((chartType == 1 || chartType == 0) && this.dim == 1) {
            if (genName) {
                this.name = new String[this.dataShape.length];
            }
            for (i = 0; i < this.dataShape.length; ++i) {
                this.dataShape[i] = this.rootPointShape;
                this.dataSize[i] = this.rootPointSize;
                this.lineThickness[i] = this.rootLineThickness;
                if (this.name == null || i >= cd.getFieldName().length) continue;
                this.name[i] = cd.getFieldName()[i].toString().trim();
            }
        }
    }

    public DataAttribute(MultiDimData mData, boolean isMData2, boolean is2DChart, int chartType, boolean genName, boolean uniqueColorForCol, MultiDimData newData, DataAttribute unusedAttr, ChartColorSet chartColorSet) {
        this(mData, isMData2, is2DChart, chartType, genName || mData.chart.dataDim == newData.chart.dataDim && chartType == newData.chart.getChartType() && is2DChart == newData.chart.is2DimChart(), uniqueColorForCol);
        this.matchData(mData.chart.dataDim, isMData2, is2DChart, chartType, uniqueColorForCol, newData, unusedAttr, chartColorSet);
    }

    public DataAttribute(HashMap<String, DataPointAttribute> dataPointAttributes) {
        if (dataPointAttributes != null) {
            int length = dataPointAttributes.keySet().size();
            this.name = new String[length];
            this.dataColor = new Color[length];
            this.dataShape = new int[length];
            this.dataSize = new int[length];
            this.lineThickness = new int[length];
            this.slice = new boolean[length];
            int i = 0;
            Iterator<String> iterator = dataPointAttributes.keySet().iterator();
            while (iterator.hasNext()) {
                String category;
                this.name[i] = category = iterator.next();
                DataPointAttribute dpa = dataPointAttributes.get(category);
                this.dataColor[i] = dpa.getPointColor();
                this.dataShape[i] = dpa.getPointShape();
                this.dataSize[i] = dpa.getPointSize();
                this.lineThickness[i] = dpa.getLineThickness();
                this.dataShape[i] = dpa.getPointShape();
                this.slice[i] = dpa.isSlice();
                ++i;
            }
        }
    }

    public void matchData(int dim, boolean isMData2, boolean is2DChart, int chartType, boolean uniqueColorForCol, MultiDimData newData, DataAttribute unusedDataAttr, ChartColorSet chartColorSet) {
        int i;
        int i2;
        boolean matchAttr;
        boolean bl = matchAttr = dim == newData.chart.dataDim && chartType == newData.chart.getChartType() && is2DChart == newData.chart.is2DimChart();
        if (!matchAttr) {
            return;
        }
        if (this.name == null) {
            return;
        }
        DataAttribute newDataAttr = new DataAttribute(newData, isMData2, is2DChart, chartType, true, uniqueColorForCol);
        int maxLen = this.dataColor.length > newDataAttr.dataColor.length ? this.dataColor.length : newDataAttr.dataColor.length;
        Color[] newDataColor = new Color[maxLen];
        int[] newDataShape = new int[maxLen];
        int[] newDataSize = new int[maxLen];
        int[] newLineThickness = new int[maxLen];
        String[] newName = new String[maxLen];
        boolean[] newSlice = new boolean[maxLen];
        boolean dataMatch = false;
        if (chartColorSet != null) {
            boolean containsQbPattern = false;
            for (i2 = 0; i2 < this.dataColor.length; ++i2) {
                if (!(this.dataColor[i2] instanceof QbPattern)) continue;
                containsQbPattern = true;
                break;
            }
            if (containsQbPattern) {
                if (chartColorSet.getChartDataPointsColors().length == this.dataColor.length) {
                    Color[] chartDataPointsColors = chartColorSet.getChartDataPointsColors();
                    for (int i3 = 0; i3 < this.dataColor.length; ++i3) {
                        if (this.dataColor[i3] == null || chartDataPointsColors[i3] == null || !(this.dataColor[i3] instanceof QbPattern) || chartDataPointsColors[i3] instanceof QbPattern || this.dataColor[i3].getRGB() != chartDataPointsColors[i3].getRGB()) continue;
                        chartDataPointsColors[i3] = this.dataColor[i3];
                    }
                } else if (chartColorSet.getChartDataPointsColors().length == 0) {
                    chartColorSet.setChartDataPointsColors(this.dataColor);
                }
            }
        }
        if (chartColorSet != null && chartColorSet.isDataPointsColorsMapped()) {
            block2: for (i = 0; i < newDataAttr.name.length; ++i) {
                if (unusedDataAttr == null) continue;
                for (int j = 0; j < unusedDataAttr.name.length; ++j) {
                    if (unusedDataAttr.name[j] == null || newDataAttr.name[i] == null || !unusedDataAttr.name[j].equals(newDataAttr.name[i])) continue;
                    dataMatch = true;
                    newDataColor[i] = unusedDataAttr.dataColor[j];
                    newDataShape[i] = unusedDataAttr.dataShape[j];
                    newDataSize[i] = unusedDataAttr.dataSize[j];
                    newLineThickness[i] = unusedDataAttr.lineThickness[j];
                    newName[i] = unusedDataAttr.name[j];
                    if (this.slice == null) continue block2;
                    newSlice[i] = unusedDataAttr.slice[j];
                    continue block2;
                }
            }
        } else {
            for (i = 0; i < Math.min(newDataAttr.dataColor.length, this.dataColor.length); ++i) {
                newDataAttr.dataColor[i] = this.dataColor[i];
                newDataAttr.dataShape[i] = this.dataShape[i];
                newDataAttr.lineThickness[i] = this.lineThickness[i];
                newDataAttr.dataSize[i] = this.dataSize[i];
                if (newDataAttr.slice == null || this.slice == null) continue;
                newDataAttr.slice[i] = this.slice[i];
            }
        }
        int k = 0;
        if (!dataMatch && chartColorSet == null) {
            for (i2 = 0; i2 < newDataColor.length; ++i2) {
                if (newDataColor[i2] != null) continue;
                while (k < this.name.length && this.name[k] == null) {
                    ++k;
                }
                if (k >= this.name.length) break;
                newDataColor[i2] = this.dataColor[k];
                newDataShape[i2] = this.dataShape[k];
                newDataSize[i2] = this.dataSize[k];
                newLineThickness[i2] = this.lineThickness[k];
                newName[i2] = this.name[k];
                if (this.slice != null) {
                    newSlice[i2] = this.slice[k];
                }
                ++k;
            }
        }
        k = 0;
        if (chartColorSet != null) {
            chartColorSet.resetColorIndex();
        }
        while (i2 < newDataColor.length) {
            if (newDataColor[i2] == null) {
                while (k < newDataAttr.name.length && newDataAttr.name[k] == null) {
                    ++k;
                }
                if (k >= newDataAttr.name.length) break;
                newDataColor[i2] = !newData.chart.colDataHasChangedBecauseOfAggrHistZoom && !uniqueColorForCol ? (chartColorSet != null ? chartColorSet.getNextColor(newDataAttr.dataColor[k]) : ChartColorSet.getRandomColor()) : (this.dataColor.length == newDataColor.length ? this.dataColor[i2] : newDataAttr.dataColor[k]);
                newDataShape[i2] = newDataAttr.dataShape[k];
                newDataSize[i2] = newDataAttr.dataSize[k];
                newLineThickness[i2] = newDataAttr.lineThickness[k];
                newName[i2] = newDataAttr.name[k];
                if (newDataAttr.slice != null) {
                    newSlice[i2] = newDataAttr.slice[k];
                }
                ++k;
            }
            ++i2;
        }
        newData.chart.colDataHasChangedBecauseOfAggrHistZoom = false;
        this.dataColor = newDataColor;
        this.dataShape = newDataShape;
        this.dataSize = newDataSize;
        this.lineThickness = newLineThickness;
        this.name = newName;
        this.slice = newSlice;
        this.unusedDataAttribute = unusedDataAttr;
    }

    public DataAttribute(DataInput in, boolean is2DChart, int chartType, int dim, int version, int oldThickness, boolean readPattern) throws IOException {
        this.chartType = chartType;
        this.is2DChart = is2DChart;
        this.dim = dim;
        this.rootPointColor = version >= 18 ? IOUtil.readColor(in) : Color.black;
        int patternID = 0;
        if (version >= 390) {
            patternID = in.readInt();
        }
        if (patternID > 0) {
            Color c = this.rootPointColor;
            this.rootPointColor = new QbPattern(c, patternID);
        }
        if (version >= 25) {
            this.rootPointShape = in.readInt();
        }
        if (version >= 58) {
            this.rootPointSize = in.readInt();
        }
        if (version >= 173) {
            this.rootLineThickness = in.readInt();
        }
        int len = in.readInt();
        boolean pie = in.readBoolean();
        this.dataColor = new Color[len];
        this.dataShape = new int[len];
        this.dataSize = new int[len];
        this.lineThickness = new int[len];
        if (version >= 393) {
            this.name = new String[len];
        }
        if (pie) {
            this.slice = new boolean[len];
        }
        for (int i = 0; i < len; ++i) {
            this.dataColor[i] = IOUtil.readColor(in);
            patternID = 0;
            if (readPattern && version >= 366) {
                patternID = in.readInt();
            }
            if (patternID > 0) {
                Color c = this.dataColor[i];
                this.dataColor[i] = new QbPattern(c, patternID);
            }
            this.dataShape[i] = version >= 35 ? in.readInt() : (int)in.readByte();
            this.dataSize[i] = version >= 58 ? in.readInt() : 0;
            int n = this.lineThickness[i] = version >= 173 ? in.readInt() : oldThickness;
            if (version >= 393) {
                this.name[i] = in.readUTF();
            }
            if (!pie) continue;
            this.slice[i] = in.readBoolean();
        }
    }

    public DataAttribute(DataInput in, boolean isMData2, boolean is2DChart, int chartType, int dim, int version, int oldThickness, boolean readPattern, boolean isUniqueColorForCol, MultiDimData newData, ChartColorSet chartColorSet) throws IOException {
        this(in, is2DChart, chartType, dim, version, oldThickness, readPattern);
        this.matchData(dim, isMData2, is2DChart, chartType, isUniqueColorForCol, newData, null, chartColorSet);
    }

    public DataAttribute(boolean is2DChart, int chartType, int dim, Color rootColor, int rootShape, int rootSize, int rootLineThickness, Color[] dataColor, int[] dataShape, int[] dataSize, int[] lineThickness, boolean[] dataSlice, String[] name) {
        this.chartType = chartType;
        this.is2DChart = is2DChart;
        this.dim = dim;
        this.rootPointColor = rootColor;
        this.rootPointShape = rootShape;
        this.rootPointSize = rootSize;
        this.rootLineThickness = rootLineThickness;
        this.dataColor = dataColor;
        this.dataShape = dataShape;
        this.dataSize = dataSize;
        this.lineThickness = lineThickness;
        this.slice = dataSlice;
        this.name = name;
    }

    public void loadAttribute(MultiDimData data, boolean dest2D, int destType) {
        this.loadAttribute(data, dest2D, destType, false);
    }

    public void loadAttribute(MultiDimData data, boolean dest2D, int destType, boolean uniqueColorForCol) {
        int i;
        MultiDimData data2 = data;
        int dim2 = 0;
        if (this.name != null) {
            this.rootPointShape = this.dataShape[0];
            this.rootPointSize = this.dataSize[0];
            this.rootLineThickness = this.lineThickness[0];
        }
        if (data == data.chart.mData2) {
            data.chart.unusedDataAttribute2 = this.unusedDataAttribute;
        } else {
            data.chart.unusedDataAttribute = this.unusedDataAttribute;
        }
        data.area.areaColor = this.rootPointColor;
        data.point.color = this.rootPointColor;
        data.point.shape = this.rootPointShape;
        data.point.size = this.rootPointSize;
        data.lineThickness = this.rootLineThickness;
        while (data2.multiData != null) {
            data2 = data2.multiData[0];
            ++dim2;
        }
        if (!Chart.isCircularChart(this.chartType) && dim2 != this.dim) {
            if (dim2 == 1 && this.dim == 2) {
                this.copy(data);
            } else if (this.dim == 1 && dim2 == 2 && this.chartType != 13 && this.chartType != 2 && this.chartType != 19) {
                this.copy(data.multiData[0]);
            }
            return;
        }
        if (!Chart.stackType(this.chartType) && Chart.stackType(destType) && this.dim == 2 && dim2 == 2) {
            this.copy(data.multiData[0]);
            return;
        }
        if (Chart.stackType(this.chartType) && !Chart.stackType(destType) && this.dim == 2 && dim2 == 2) {
            if (Chart.isCircularChart(destType)) {
                this.copy(data, true);
            } else {
                this.copy(data, false);
            }
            return;
        }
        if (Chart.stackType(this.chartType) && !Chart.stackType(destType) || !Chart.stackType(this.chartType) && Chart.stackType(destType)) {
            return;
        }
        if ((Chart.isCoordinateType(this.chartType) || this.chartType == 7 || Chart.isHiLowChart(this.chartType) || this.chartType == 14 || this.chartType == 3 && data.chart.isSyncPointColorForLine()) && this.dim == 1 && (!Chart.isCoordinateType(destType) && destType != 7 && !Chart.isHiLowChart(destType) && destType != 14 && (this.chartType != 3 || !data.chart.isSyncPointColorForLine()) || dim2 != 1)) {
            return;
        }
        if ((Chart.isCoordinateType(this.chartType) || this.chartType == 7 || Chart.isHiLowChart(this.chartType) || this.chartType == 14 || this.chartType == 8 && this.is2DChart || this.chartType == 3 && data.chart.isSyncPointColorForLine()) && this.dim == 1 || (this.chartType == 0 || this.chartType == 1) && data.chart.isSingleColorForCategories()) {
            data.setColor(this.dataColor[0]);
            data.setShape(this.dataShape[0]);
            data.setSize(this.dataSize[0]);
            data.setLineThickness(this.lineThickness[0]);
            return;
        }
        if (Chart.stackType(this.chartType) && this.dim == 2) {
            this.copy(data.multiData[0]);
            return;
        }
        if (Chart.stackType(this.chartType) && this.dim == 3) {
            int len1 = data.multiData.length;
            int len2 = data.multiData[0].multiData[0].multiData.length;
            int k = 0;
            for (int i2 = 0; i2 < len1; ++i2) {
                MultiDimData data4 = data.multiData[i2].multiData[0];
                for (int j = 0; j < len2; ++j) {
                    MultiDimData data3 = data4.multiData[j];
                    if (k < this.dataColor.length) {
                        data3.setColor(this.dataColor[k]);
                    }
                    if (k < this.dataShape.length) {
                        data3.setShape(this.dataShape[k]);
                        data3.setSize(this.dataSize[k]);
                        data3.setLineThickness(this.lineThickness[k]);
                    }
                    ++k;
                }
            }
            return;
        }
        int len = data.multiData.length;
        for (i = 0; i < Math.min(Math.min(len, this.dataShape.length), this.dataSize.length); ++i) {
            data.multiData[i].setShape(this.dataShape[i]);
            data.multiData[i].setSize(this.dataSize[i]);
            if (i >= this.lineThickness.length) {
                data.multiData[i].setLineThickness(this.lineThickness[0]);
                continue;
            }
            data.multiData[i].setLineThickness(this.lineThickness[i]);
        }
        if (this.slice != null) {
            for (i = 0; i < Math.min(len, this.slice.length); ++i) {
                if (!Chart.isCircularChart(this.chartType) || !Chart.isCircularChart(destType) || this.slice.length <= i) continue;
                if (data.chart.dataDim == 1) {
                    data.multiData[i].plotData.bSlice = this.slice[i];
                    continue;
                }
                for (int l = 0; l < data.multiData[i].multiData.length; ++l) {
                    data.multiData[i].multiData[l].plotData.bSlice = this.slice[i];
                }
            }
        }
        int len5 = this.dataColor.length;
        if (Chart.isCircularChart(this.chartType) && data.chart.pieOthersLimit > 0.0) {
            --len5;
        }
        for (int i3 = 0; i3 < Math.min(len, len5); ++i3) {
            data.multiData[i3].setColor(this.dataColor[i3]);
        }
        if (Chart.isCircularChart(this.chartType) && data.chart.pieOthersLimit > 0.0 && data.multiData.length == this.dataColor.length) {
            data.multiData[data.multiData.length - 1].setColor(this.dataColor[this.dataColor.length - 1]);
        }
        if (uniqueColorForCol && data.multiData[0].multiData != null) {
            int len2 = data.multiData[0].multiData.length;
            int k = 0;
            for (int i4 = 0; i4 < len2; ++i4) {
                for (int j = 0; j < len; ++j) {
                    if (k >= this.dataColor.length) {
                        return;
                    }
                    if (this.dataColor[k] != null) {
                        data.multiData[j].multiData[i4].setColor(this.dataColor[k]);
                    }
                    ++k;
                }
            }
        }
    }

    private void copy(MultiDimData d) {
        this.copy(d, false);
    }

    private void copy(MultiDimData d, boolean isPieChart) {
        for (int i = 0; i < d.multiData.length; ++i) {
            if (i < this.dataColor.length) {
                d.multiData[i].setColor(this.dataColor[i]);
            }
            if (i < this.dataShape.length) {
                d.multiData[i].setShape(this.dataShape[i]);
            }
            if (i < this.dataSize.length) {
                d.multiData[i].setSize(this.dataSize[i]);
            }
            if (i >= this.lineThickness.length) continue;
            d.multiData[i].setLineThickness(this.lineThickness[i]);
        }
        if (!isPieChart) {
            d.chart.syncColor();
        }
    }

    public void save(DataOutput out) throws IOException {
        IOUtil.writeColor(out, this.rootPointColor);
        if (this.rootPointColor instanceof QbPattern) {
            int patternID = ((QbPattern)this.rootPointColor).getPatternTypeID();
            out.writeInt(patternID);
        } else {
            out.writeInt(0);
        }
        out.writeInt(this.rootPointShape);
        out.writeInt(this.rootPointSize);
        out.writeInt(this.rootLineThickness);
        out.writeInt(this.dataColor.length);
        out.writeBoolean(this.slice != null);
        for (int i = 0; i < this.dataColor.length; ++i) {
            IOUtil.writeColor(out, this.dataColor[i]);
            if (this.dataColor[i] instanceof QbPattern) {
                int patternID = ((QbPattern)this.dataColor[i]).getPatternTypeID();
                out.writeInt(patternID);
            } else {
                out.writeInt(0);
            }
            out.writeInt(this.dataShape[i]);
            out.writeInt(this.dataSize[i]);
            out.writeInt(this.lineThickness[i]);
            out.writeUTF(this.name[i]);
            if (this.slice == null) continue;
            out.writeBoolean(this.slice[i]);
        }
    }

    public DataAttribute join(DataAttribute dat2) {
        DataAttribute da = null;
        try {
            if (dat2 == null) {
                return (DataAttribute)this.clone();
            }
            da = (DataAttribute)this.clone();
        }
        catch (CloneNotSupportedException e) {
            LOGGER.log(Level.WARNING, "Can't join DataAttributes - CloneNotSupported", e);
            return this;
        }
        if (dat2.dataColor != null) {
            Color[] datColor2 = (Color[])dat2.dataColor.clone();
            Color[] newDatColor = new Color[datColor2.length + da.dataColor.length];
            System.arraycopy(datColor2, 0, newDatColor, 0, datColor2.length);
            System.arraycopy(da.dataColor, 0, newDatColor, datColor2.length, da.dataColor.length);
            da.dataColor = newDatColor;
        }
        if (dat2.name != null) {
            String[] nam2 = (String[])dat2.name.clone();
            String[] newNam = new String[nam2.length + da.name.length];
            System.arraycopy(nam2, 0, newNam, 0, nam2.length);
            System.arraycopy(da.name, 0, newNam, nam2.length, da.name.length);
            da.name = newNam;
        }
        if (dat2.dataShape != null) {
            int[] dataShap = new int[da.dataShape.length + dat2.dataShape.length];
            System.arraycopy(dat2.dataShape, 0, dataShap, 0, dat2.dataShape.length);
            System.arraycopy(da.dataShape, 0, dataShap, dat2.dataShape.length, da.dataShape.length);
            da.dataShape = dataShap;
        }
        if (dat2.dataSize != null) {
            int[] dataSiz = new int[da.dataSize.length + dat2.dataSize.length];
            System.arraycopy(dat2.dataSize, 0, dataSiz, 0, dat2.dataSize.length);
            System.arraycopy(da.dataSize, 0, dataSiz, dat2.dataSize.length, da.dataSize.length);
            da.dataSize = dataSiz;
        }
        if (dat2.lineThickness != null) {
            int[] lineThicknes = new int[da.lineThickness.length + dat2.lineThickness.length];
            System.arraycopy(dat2.lineThickness, 0, lineThicknes, 0, dat2.lineThickness.length);
            System.arraycopy(da.lineThickness, 0, lineThicknes, dat2.lineThickness.length, da.lineThickness.length);
            da.lineThickness = lineThicknes;
        }
        if (da.slice != null && dat2.slice != null) {
            boolean[] slic = new boolean[da.slice.length + dat2.slice.length];
            System.arraycopy(dat2.slice, 0, slic, 0, dat2.slice.length);
            System.arraycopy(da.slice, 0, slic, dat2.slice.length, da.slice.length);
            da.slice = slic;
        }
        return da;
    }

    public Object clone() throws CloneNotSupportedException {
        DataAttribute clonedDA = new DataAttribute();
        clonedDA.dim = this.dim;
        if (this.dataColor != null) {
            clonedDA.dataColor = (Color[])this.dataColor.clone();
        }
        if (this.dataShape != null) {
            clonedDA.dataShape = (int[])this.dataShape.clone();
        }
        if (this.dataSize != null) {
            clonedDA.dataSize = (int[])this.dataSize.clone();
        }
        if (this.lineThickness != null) {
            clonedDA.lineThickness = (int[])this.lineThickness.clone();
        }
        if (this.slice != null) {
            clonedDA.slice = (boolean[])this.slice.clone();
        }
        clonedDA.chartType = this.chartType;
        clonedDA.is2DChart = this.is2DChart;
        Color rpc = this.rootPointColor;
        if (rpc != null) {
            clonedDA.rootPointColor = new Color(rpc.getRed(), rpc.getGreen(), rpc.getBlue());
        }
        clonedDA.rootPointShape = this.rootPointShape;
        clonedDA.rootPointSize = this.rootPointSize;
        clonedDA.rootLineThickness = this.rootLineThickness;
        if (this.name != null) {
            clonedDA.name = (String[])this.name.clone();
        }
        if (this.unusedDataAttribute != null) {
            clonedDA.unusedDataAttribute = (DataAttribute)this.unusedDataAttribute.clone();
        }
        return clonedDA;
    }
}

