/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.io.DataInput;
import java.io.DataInputStream;
import quadbase.chart.ColData;
import quadbase.chart.DBAccess;
import quadbase.chart.FilterInfo;
import quadbase.chart.PreprocInfo;
import quadbase.chart.ReadDataFile;
import quadbase.common.client.ServerMessage;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.util.internal.ClassFileUtil;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.XMLFileQueryInfo;
import quadbase.util.IResultSet;
import quadbase.util.StreamResultSet;
import quadbase.util.internal.IOUtil;

public class DataFileInput {
    public static final int TEXTFILE = 2;
    public static final int XMLFILE = 4;
    public static final int XMLFILEQUERY = 7;
    public static final int CLASSFILE = 6;

    public ColData[] readProcessedData(String filename, boolean isTransposed, boolean[] transposeCol, PreprocInfo procInfo, String encoding) throws Exception {
        return this.readProcessedData(filename, isTransposed, transposeCol, null, procInfo, null, 0, false, null, encoding);
    }

    public ColData[] readProcessedData(String filename, boolean isTransposed, boolean[] transposeCol, PreprocInfo procInfo, int dataType) throws Exception {
        return this.readProcessedData(filename, isTransposed, transposeCol, null, procInfo, null, dataType);
    }

    public synchronized ColData[] readProcessedData(String filename, boolean isTransposed, boolean[] transposeCol, FilterInfo filterInfo, PreprocInfo procInfo, XMLFileQueryInfo xmlInfo, int dataType) throws Exception {
        return this.readProcessedData(filename, isTransposed, transposeCol, filterInfo, procInfo, xmlInfo, dataType, false, null, null);
    }

    public synchronized ColData[] readProcessedData(String filename, boolean isTransposed, boolean[] transposeCol, FilterInfo filterInfo, PreprocInfo procInfo, XMLFileQueryInfo xmlInfo, int dataType, boolean drawNullColumn, String nullHandleName, String encoding) throws Exception {
        if ((ServerMessage.useServer || !ServerMessage.isLoadBalancer) && filename != null) {
            int message = xmlInfo != null ? 24327 : (filterInfo != null ? 28816 : 32415);
            DataInputStream din = ReadDataFile.getFromServer(filename, isTransposed, transposeCol, filterInfo, procInfo, null, message, xmlInfo, dataType, drawNullColumn, nullHandleName, encoding);
            return DataFileInput.getColDataFromStream(din);
        }
        ReadDataFile readfile = new ReadDataFile();
        IResultSet rs = dataType == 7 ? readfile.createXMLQueryResultSet(xmlInfo) : (IOUtil.isXMLFormat(filename) || dataType == 4 ? readfile.createXMLResultSet(filename) : (dataType == 6 ? readfile.getClassResultSet(filename) : new StreamResultSet(readfile.getInputStream(filename), encoding)));
        rs = DBAccess.processResultSet(rs, false, isTransposed, transposeCol, filterInfo, procInfo, drawNullColumn, nullHandleName);
        return ColData.getColData(rs);
    }

    public static ColData[] getColDataFromStream(DataInput din) throws Exception {
        int i;
        int nRow = din.readInt();
        int nCol = din.readInt();
        ColData[] colData = new ColData[nCol + 1];
        for (i = 0; i < nCol; ++i) {
            String colName = IOUtil.readString(din, true);
            String tblName = IOUtil.readString(din, true);
            int dtype = din.readInt();
            colData[i] = new ColData(colName, tblName, dtype, nRow, nCol);
        }
        colData[nCol] = new ColData("qbCount", 4, nRow, colData.length);
        for (i = 0; i < nRow; ++i) {
            for (int j = 0; j < nCol; ++j) {
                Object x = DataType.read(din, colData[j].getOriginalDataType(), 6612, true);
                colData[j].add(x);
            }
            colData[nCol].add(i);
        }
        return colData;
    }

    public synchronized ColData[] readProcessedData(String filename, boolean isTransposed, boolean[] transposeCol, FilterInfo filterInfo, PreprocInfo procInfo, QueryInParamSet paramSet) throws Exception {
        if (ServerMessage.useServer || !ServerMessage.isLoadBalancer) {
            DataInput din = ReadDataFile.getFromServer(filename, isTransposed, transposeCol, filterInfo, procInfo, paramSet);
            return DataFileInput.getColDataFromStream(din);
        }
        IResultSet rs = (IResultSet)ClassFileUtil.getResultSet(filename, paramSet);
        rs = DBAccess.processResultSet(rs, false, isTransposed, transposeCol, filterInfo, procInfo);
        return ColData.getColData(rs);
    }

    public static IResultSet getClassResultSet(String filename, QueryInParamSet paramSet) throws Exception {
        if (ServerMessage.useServer || !ServerMessage.isLoadBalancer) {
            DataInput din = ReadDataFile.getFromServer(filename, false, null, null, null, paramSet);
            return ColData.getResultSet(DataFileInput.getColDataFromStream(din));
        }
        return (IResultSet)ClassFileUtil.getResultSet(filename, paramSet);
    }
}

