/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.awt.Color;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Vector;
import quadbase.chart.BSpline;
import quadbase.chart.CAnnotation;
import quadbase.chart.CGraphics;
import quadbase.chart.Chart;
import quadbase.chart.Coordinate;
import quadbase.chart.HiLowData;
import quadbase.chart.Line;
import quadbase.chart.MultiDimData;
import quadbase.chart.PlotData;
import quadbase.chart.Point3D;
import quadbase.chart.chart2d.TrendLine2D;
import quadbase.util.IAnnotation;
import quadbase.util.IDataLine;

public abstract class DataLine
implements IDataLine {
    protected Vector<IAnnotation> annoVector;
    protected Chart chart;
    protected String series = "";
    protected int linetype;
    protected int level = -1;
    protected double[] c;
    protected int coeff;
    protected String title = "";
    protected int hlco_value = 2;
    protected Color color = Color.black;
    protected boolean positive_line = true;
    protected Double[] x = null;
    protected Double[] y = null;
    protected int j = 0;
    protected boolean error_data;
    protected int thickness = 1;
    protected boolean selectmode;
    protected boolean isObjSelect;
    protected String valueHint = "";
    protected boolean showValue = false;
    protected int xpick;
    protected int ypick;
    protected boolean hideTitle;
    protected boolean useSubvalue = false;
    protected int useAxis = -3;
    protected double line_value;
    protected BSpline bspline;
    protected int lineStyle = 0;
    public static final double CURRENTDATE = -1.7976931348623157E308;

    public abstract Object clone();

    public boolean equals(DataLine target) {
        return target != null && target.linetype == this.linetype && target.coeff == this.coeff && target.series.equals(this.series) && target.hlco_value == this.hlco_value && target.positive_line == this.positive_line && target.line_value == this.line_value && target.useSubvalue == this.useSubvalue && target.thickness == this.thickness && target.useAxis == this.useAxis && target.level == this.level;
    }

    public void setChart(Chart chart) {
        this.chart = chart;
        if (this.annoVector != null) {
            int nAnno = this.annoVector.size();
            for (int i = 0; i < nAnno; ++i) {
                if (this.annoVector.elementAt(i) instanceof DataLine) {
                    ((DataLine)((Object)this.annoVector.elementAt(i))).setChart(chart);
                    continue;
                }
                if (!(this.annoVector.elementAt(i) instanceof CAnnotation)) continue;
                ((CAnnotation)this.annoVector.elementAt(i)).setChart(chart);
            }
        }
    }

    @Override
    public abstract void setCoeff(int var1);

    @Override
    public final int getCoeff() {
        return this.coeff;
    }

    @Override
    public final void setTitle(String title) {
        this.title = title;
    }

    @Override
    public final String getTitle() {
        return this.title;
    }

    @Override
    public void useSecondaryValue(boolean state) {
        this.useSubvalue = state;
        if (state) {
            this.useAxis = -2;
        }
    }

    @Override
    public final boolean isSecondaryValueUsed() {
        return this.useSubvalue;
    }

    @Override
    public final void setValueColumn(int hlco_value) {
        this.hlco_value = hlco_value;
    }

    @Override
    public final int getValueColumn() {
        return this.hlco_value;
    }

    @Override
    public final void setSeries(String series) {
        this.series = series;
    }

    @Override
    public final String getSeries() {
        return this.series;
    }

    @Override
    public final void setShowHintValue(boolean bshow) {
        this.showValue = bshow;
    }

    @Override
    public final boolean getShowHintValue() {
        return this.showValue;
    }

    @Override
    public final String getValueHint() {
        return this.valueHint;
    }

    @Override
    public final void setValueHint(String hint) {
        this.valueHint = hint;
    }

    @Override
    public abstract void setLineType(int var1);

    @Override
    public final int getLineType() {
        return this.linetype;
    }

    @Override
    public final Color getColor() {
        return this.color;
    }

    @Override
    public final void setLineValue(double line_value) {
        this.line_value = line_value;
    }

    @Override
    public final double getLineValue() {
        if (this.line_value == -1.7976931348623157E308) {
            return System.currentTimeMillis();
        }
        return this.line_value;
    }

    public final double getActualLineValue() {
        return this.line_value;
    }

    @Override
    public final void setTitleVisibleInLegend(boolean b) {
        this.hideTitle = !b;
    }

    @Override
    public final boolean isTitleVisibleInLegend() {
        return !this.hideTitle;
    }

    public final void setStackChartLine(boolean positive) {
        this.positive_line = positive;
    }

    public final boolean getStackChartLine() {
        return this.positive_line;
    }

    @Override
    public final int getThickness() {
        return this.thickness;
    }

    @Override
    public final void setThickness(int thickness) {
        this.thickness = thickness;
        if (!this.chart.is2DChart) {
            this.chart.newSurface();
        }
    }

    @Override
    public int getLineStyle() {
        return this.lineStyle;
    }

    @Override
    public void setLineStyle(int lineStyle) {
        this.lineStyle = lineStyle;
    }

    @Override
    public Vector<IAnnotation> getAnnotations() {
        return this.annoVector;
    }

    @Override
    public void addAnnotation(IAnnotation annoObj) {
        if (this.annoVector == null) {
            this.annoVector = new Vector();
        }
        this.annoVector.addElement(annoObj);
    }

    @Override
    public boolean removeAnnotation(IAnnotation annoObj) {
        if (this.annoVector == null) {
            return false;
        }
        return this.annoVector.removeElement(annoObj);
    }

    public double[] getInterpolateCoeffs() {
        return this.c;
    }

    protected final void getArray(boolean xlogscale, double xbase, boolean ylogscale, double ybase, MultiDimData data, boolean isStackChart, int level) {
        this.getArray(xlogscale, xbase, ylogscale, ybase, data, isStackChart, level, true);
    }

    protected final void getArray(boolean xlogscale, double xbase, boolean ylogscale, double ybase, MultiDimData data, boolean isStackChart, int level, boolean useSum) {
        if (isStackChart) {
            int l = data.multiData.length;
            int sl = data.multiData[0].multiData.length;
            this.x = new Double[l * sl];
            this.y = new Double[this.x.length];
            this.j = 0;
            Double[] xx = new Double[l];
            Double[] yy = new Double[xx.length];
            int numStack = sl;
            if (level > 0 && level < sl) {
                numStack = level;
            }
            for (int i = 0; i < l; ++i) {
                int n;
                this.getArray4ControlLine(xlogscale, xbase, ylogscale, ybase, data.multiData[i]);
                if (!useSum) continue;
                if (!DataLine.isBarChartType(this.chart)) {
                    xx[i] = 1.0;
                    yy[i] = 0.0;
                    for (n = 0; n < numStack; ++n) {
                        if (this.y[i * sl + n] == null) continue;
                        yy[i] = yy[i] + this.y[i * sl + n];
                    }
                    continue;
                }
                yy[i] = 1.0;
                xx[i] = 0.0;
                for (n = 0; n < numStack; ++n) {
                    if (this.x[i * sl + n] == null) continue;
                    xx[i] = xx[i] + this.x[i * sl + n];
                }
            }
            if (useSum) {
                this.x = xx;
                this.y = yy;
            }
        } else {
            this.x = new Double[data.multiData.length];
            this.y = new Double[this.x.length];
            this.j = 0;
            this.getArray4ControlLine(xlogscale, xbase, ylogscale, ybase, data);
        }
    }

    private final void getArray4ControlLine(boolean xlogscale, double xbase, boolean ylogscale, double ybase, MultiDimData data) {
        if (this.x == null) {
            this.x = new Double[data.multiData.length];
            this.y = new Double[this.x.length];
            this.j = 0;
        }
        int i = 0;
        int cat = 0;
        while (i < data.order.length) {
            PlotData pd = data.multiData[data.order[i++]].plotData;
            if (!pd.isEmpty()) {
                double xvalue;
                double yvalue;
                if (pd.element instanceof Coordinate) {
                    yvalue = ((Coordinate)pd.element).y;
                    xvalue = ((Coordinate)pd.element).x;
                    if (xlogscale) {
                        if (xvalue <= 0.0) {
                            this.y = null;
                            this.x = null;
                            return;
                        }
                        this.x[this.j] = Math.log(xvalue) / Math.log(xbase);
                    } else {
                        this.x[this.j] = xvalue;
                    }
                    if (ylogscale) {
                        if (yvalue <= 0.0) {
                            this.y = null;
                            this.x = null;
                            return;
                        }
                        this.y[this.j++] = Math.log(yvalue) / Math.log(ybase);
                        continue;
                    }
                    this.y[this.j++] = yvalue;
                    continue;
                }
                if (!DataLine.isBarChartType(this.chart)) {
                    this.x[this.j] = ++cat;
                    if (pd.element instanceof HiLowData) {
                        HiLowData hldata = (HiLowData)pd.element;
                        switch (this.hlco_value) {
                            case 0: {
                                yvalue = hldata.vhi;
                                break;
                            }
                            case 1: {
                                yvalue = hldata.vlow;
                                break;
                            }
                            case 2: {
                                yvalue = hldata.vclose;
                                break;
                            }
                            default: {
                                yvalue = hldata.vopen;
                                break;
                            }
                        }
                    } else {
                        yvalue = pd.getValue();
                    }
                    if (ylogscale) {
                        if (yvalue <= 0.0) {
                            this.y = null;
                            this.x = null;
                            return;
                        }
                        this.y[this.j++] = Math.log(yvalue) / Math.log(ybase);
                        continue;
                    }
                    this.y[this.j++] = yvalue;
                    continue;
                }
                this.y[this.j] = ++cat;
                xvalue = pd.getValue();
                if (xlogscale) {
                    if (xvalue <= 0.0) {
                        this.y = null;
                        this.x = null;
                        return;
                    }
                    this.x[this.j++] = Math.log(xvalue) / Math.log(xbase);
                    continue;
                }
                this.x[this.j++] = xvalue;
                continue;
            }
            ++cat;
            ++this.j;
        }
        if (i != this.j && this.j == this.y.length) {
            this.copyArray(this.j);
        }
    }

    protected final void getArray(boolean xlogscale, double xbase, boolean ylogscale, double ybase, MultiDimData data) {
        this.x = new Double[data.multiData.length];
        this.y = new Double[this.x.length];
        int i = 0;
        int j = 0;
        int cat = 0;
        while (i < this.x.length) {
            PlotData pd = data.multiData[data.order[i++]].plotData;
            if (!pd.isEmpty()) {
                double xvalue;
                double yvalue;
                if (pd.element instanceof Coordinate) {
                    yvalue = ((Coordinate)pd.element).y;
                    xvalue = ((Coordinate)pd.element).x;
                    if (xlogscale) {
                        if (xvalue <= 0.0) {
                            this.y = null;
                            this.x = null;
                            return;
                        }
                        this.x[j] = Math.log(xvalue) / Math.log(xbase);
                    } else {
                        this.x[j] = xvalue;
                    }
                    if (ylogscale) {
                        if (yvalue <= 0.0) {
                            this.y = null;
                            this.x = null;
                            return;
                        }
                        this.y[j++] = Math.log(yvalue) / Math.log(ybase);
                        continue;
                    }
                    this.y[j++] = yvalue;
                    continue;
                }
                if (!DataLine.isBarChartType(this.chart)) {
                    this.x[j] = ++cat;
                    if (pd.element instanceof HiLowData) {
                        HiLowData hldata = (HiLowData)pd.element;
                        switch (this.hlco_value) {
                            case 0: {
                                yvalue = hldata.vhi;
                                break;
                            }
                            case 1: {
                                yvalue = hldata.vlow;
                                break;
                            }
                            case 2: {
                                yvalue = hldata.vclose;
                                break;
                            }
                            default: {
                                yvalue = hldata.vopen;
                                break;
                            }
                        }
                    } else {
                        yvalue = pd.getValue();
                    }
                    if (ylogscale) {
                        if (yvalue <= 0.0) {
                            this.y = null;
                            this.x = null;
                            return;
                        }
                        this.y[j++] = Math.log(yvalue) / Math.log(ybase);
                        continue;
                    }
                    this.y[j++] = yvalue;
                    continue;
                }
                this.y[j] = ++cat;
                xvalue = pd.getValue();
                if (xlogscale) {
                    if (xvalue <= 0.0) {
                        this.y = null;
                        this.x = null;
                        return;
                    }
                    this.x[j++] = Math.log(xvalue) / Math.log(xbase);
                    continue;
                }
                this.x[j++] = xvalue;
                continue;
            }
            ++cat;
            ++j;
        }
        if (i != j) {
            this.copyArray(j);
        }
    }

    private void copyArray(int j) {
        Double[] x2 = new Double[j];
        System.arraycopy(this.x, 0, x2, 0, j);
        this.x = x2;
        x2 = new Double[j];
        System.arraycopy(this.y, 0, x2, 0, j);
        this.y = x2;
    }

    protected final void getSumArray(MultiDimData data) {
        this.y = new Double[data.multiData.length];
        this.x = new Double[this.y.length];
        int i = 0;
        int j = 0;
        while (i < this.x.length) {
            boolean empty = true;
            double sum = 0.0;
            MultiDimData md = data.multiData[i++];
            for (MultiDimData element : md.multiData) {
                PlotData pd = element.plotData;
                if (pd.isEmpty()) continue;
                empty = false;
                double value = pd.getValue();
                if (this.positive_line) {
                    if (!(value > 0.0)) continue;
                    sum += value;
                    continue;
                }
                if (!(value < 0.0)) continue;
                sum += value;
            }
            if (empty) continue;
            this.x[j] = j + 1;
            this.y[j++] = sum;
        }
        if (DataLine.isBarChartType(this.chart)) {
            Double[] temp = this.x;
            this.x = this.y;
            this.y = temp;
        }
        if (i == j) {
            this.copyArray(j);
        }
    }

    protected final int findSeriesNo(String s) {
        if (s != null) {
            Object[] obj = this.chart.colData[this.chart.mDataMap[0]].getFieldName();
            for (int i = 0; i < obj.length; ++i) {
                if (!obj[i].toString().equals(s)) continue;
                return i;
            }
        }
        return 0;
    }

    public abstract void compute();

    public abstract void prepare3DLine();

    protected static final Double[] compute_tri_avg(Double[] a, int coeff) {
        int period = (int)Math.round((double)(1 + coeff) / 2.0);
        return DataLine.compute_avg(DataLine.compute_avg(a, period), period);
    }

    protected static final void compute_exp_avg(Double[] a, int coeff) {
        double percent = 2.0 / (double)(coeff + 1);
        double percent_minus = 1.0 - percent;
        for (int i = 1; i < a.length; ++i) {
            int index;
            if (a[i] == null || a[index = TrendLine2D.findPrevNotNull(i - 1, a)] == null) continue;
            a[i] = a[i] * percent + a[index] * percent_minus;
        }
    }

    protected static final Double[] compute_avg(Double[] a, int coeff) {
        int actualPos;
        double sum = 0.0;
        int notNullIndex = 0;
        for (actualPos = 0; notNullIndex != coeff && actualPos < a.length; ++actualPos) {
            if (a[actualPos] == null) continue;
            ++notNullIndex;
            sum += a[actualPos].doubleValue();
        }
        Double[] b = new Double[a.length];
        if (notNullIndex != coeff) {
            return b;
        }
        b[actualPos - 1] = sum / (double)coeff;
        int movPos = 0;
        while (a[movPos] == null) {
            ++movPos;
        }
        while (actualPos < a.length) {
            if (a[actualPos] != null) {
                b[actualPos] = (sum += a[actualPos] - a[movPos]) / (double)coeff;
                ++movPos;
                while (a[movPos] == null) {
                    ++movPos;
                }
            }
            ++actualPos;
        }
        return b;
    }

    protected final boolean logTransform(Double[] a) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] <= 0.0) {
                this.error_data = true;
                return false;
            }
            a[i] = Math.log(a[i]);
        }
        return true;
    }

    final boolean pick(CGraphics g, int x, int y) {
        this.selectmode = true;
        this.xpick = x;
        this.ypick = g.height - y;
        this.isObjSelect = false;
        if (!this.chart.dataDrawnOnTop) {
            this.draw(g);
        }
        this.selectmode = false;
        return this.isObjSelect;
    }

    void draw(CGraphics g) {
        if (this.isVisible()) {
            this.drawLine(g);
        }
    }

    protected abstract void drawLine(CGraphics var1);

    protected int getHortLineYPixel() {
        if (this.chart.chartType == 14 && this.useAxis >= -3 && this.chart.getAxis((int)(this.useAxis + 4)).stepsize != null) {
            return this.chart.getAxis((int)(this.useAxis + 4)).stepsize.interpolatePixel2(this.line_value);
        }
        return this.useSubvalue ? this.chart.a_s.stepsize.interpolatePixel2(this.line_value) : this.chart.a_y.stepsize.interpolatePixel2(this.line_value);
    }

    protected int getVertLineXPixel() {
        if (this.chart.chartType == 14 && this.useAxis >= -3) {
            return this.chart.getAxis((int)(this.useAxis + 4)).stepsize.interpolatePixel2(this.getLineValue());
        }
        return this.useSubvalue ? this.chart.a_s.stepsize.interpolatePixel2(this.getLineValue()) : this.chart.a_x.stepsize.interpolatePixel2(this.getLineValue());
    }

    protected int getHortLineYPixel2() {
        Point3D[] p = this.chart.a_y.ticker.point;
        int len = p.length;
        return (int)Math.round((double)p[0].y + (this.line_value - 0.5) * (double)(p[len - 1].y - p[0].y) / (double)(len - 1));
    }

    protected int getVertLineXPixel2() {
        Point3D[] p = this.chart.a_x.ticker.point;
        int len = p.length;
        return (int)Math.round((double)p[0].x + (this.getLineValue() - 0.5) * (double)(p[len - 1].x - p[0].x) / (double)(len - 1));
    }

    private int cut(int x1, int y1, int x2, int y2, int cuty) {
        return x1 + (cuty - y1) * (x2 - x1) / (y2 - y1);
    }

    private int cutX(int x1, int y1, int x2, int y2, int cutx) {
        return y1 + (cutx - x1) * (y2 - y1) / (x2 - x1);
    }

    abstract void fillLine(CGraphics var1, int var2, int var3, int var4, int var5, int var6);

    protected GeneralPath createLimitPath(CGraphics g, int miny, int maxy, int x1, int y1, int x2, int y2, GeneralPath path) {
        return this.drawLimitPath(g, miny, maxy, x1, y1, x2, y2, path, false);
    }

    protected GeneralPath drawLimitPath(CGraphics g, int miny, int maxy, int x1, int y1, int x2, int y2, GeneralPath path) {
        return this.drawLimitPath(g, miny, maxy, x1, y1, x2, y2, path, true);
    }

    private GeneralPath drawLimitPath(CGraphics g, int miny, int maxy, int x1, int y1, int x2, int y2, GeneralPath path, boolean drawPath) {
        boolean startNewPath;
        int t;
        boolean swap = false;
        if (y1 > y2) {
            t = y1;
            y1 = y2;
            y2 = t;
            t = x1;
            x1 = x2;
            x2 = t;
            swap = true;
        }
        if (y1 <= miny) {
            if (y2 <= miny) {
                return path;
            }
            if (y2 > maxy) {
                x2 = this.cut(x1, y1, x2, y2, maxy);
                y2 = maxy;
            }
            x1 = this.cut(x1, y1, x2, y2, miny);
            y1 = miny;
        } else {
            if (y1 >= maxy) {
                return path;
            }
            if (y2 > maxy) {
                x2 = this.cut(x1, y1, x2, y2, maxy);
                y2 = maxy;
            }
        }
        if (swap) {
            t = y1;
            y1 = y2;
            y2 = t;
            t = x1;
            x1 = x2;
            x2 = t;
            swap = true;
        }
        if (drawPath) {
            this.fillLine(g, x1, y1, x2, y2, this.thickness);
        }
        boolean bl = startNewPath = path == null;
        if (path != null && this.linetype != 9) {
            Point2D point = path.getCurrentPoint();
            if (point.getX() != (double)x1) {
                startNewPath = true;
            }
            if (point.getY() != (double)(g.height - y1)) {
                startNewPath = true;
            }
        }
        if (startNewPath) {
            if (path != null && drawPath) {
                g.drawLine(path, this.thickness);
            }
            path = new GeneralPath();
            path.moveTo(x1, g.height - y1);
        }
        if (this.linetype == 14 || this.linetype == 15 || this.linetype == 16) {
            path.lineTo(x2, g.height - y2);
        }
        if (!this.isObjSelect && Line.pickLine(x1, y1, x2, y2, this.xpick, this.ypick)) {
            this.isObjSelect = true;
        }
        return path;
    }

    protected GeneralPath drawLimitPathForBar(CGraphics g, int minx, int maxx, int x1, int y1, int x2, int y2, GeneralPath path) {
        boolean startNewPath;
        int t;
        boolean swap = false;
        if (x1 > x2) {
            t = x1;
            x1 = x2;
            x2 = t;
            t = y1;
            y1 = y2;
            y2 = t;
            swap = true;
        }
        if (x1 <= minx) {
            if (x2 <= minx) {
                return path;
            }
            if (x2 > maxx) {
                y2 = this.cutX(x1, y1, x2, y2, maxx);
                x2 = maxx;
            }
            y1 = this.cutX(x1, y1, x2, y2, minx);
            x1 = minx;
        } else {
            if (x1 >= maxx) {
                return path;
            }
            if (x2 > maxx) {
                y2 = this.cutX(x1, y1, x2, y2, maxx);
                x2 = maxx;
            }
        }
        if (swap) {
            t = x1;
            x1 = x2;
            x2 = t;
            t = y1;
            y1 = y2;
            y2 = t;
        }
        this.fillLine(g, x1, y1, x2, y2, this.thickness);
        boolean bl = startNewPath = path == null;
        if (path != null) {
            Point2D point = path.getCurrentPoint();
            if (point.getX() != (double)x1) {
                startNewPath = true;
            }
            if (point.getY() != (double)(g.height - y1)) {
                startNewPath = true;
            }
        }
        if (startNewPath) {
            if (path != null) {
                g.drawLine(path, this.thickness);
            }
            path = new GeneralPath();
            path.moveTo(x1, g.height - y1);
        }
        path.lineTo(x2, g.height - y2);
        if (!this.isObjSelect && Line.pickLine(x1, y1, x2, y2, this.xpick, this.ypick)) {
            this.isObjSelect = true;
        }
        return path;
    }

    @Override
    public boolean isVisible() {
        if (this.chart.chartType == 18 && this.getActualLineValue() == -1.7976931348623157E308 && (this.getLineValue() > this.chart.getAxis((int)0).maxScale || this.getLineValue() < this.chart.getAxis((int)0).minScale)) {
            return false;
        }
        return !this.invalidchart();
    }

    public abstract boolean invalidchart();

    public static final boolean isBarChartType(Chart c) {
        return c.chartType == 1 || c.chartType == 5 || c.chartType == 15 && c.getLayout() == 0 || c.is2DChart && c.chartType == 3 && c.getLayout() == 1 || c.chartType == 18;
    }

    protected abstract String getShortName(int var1);

    protected final void makeTitle() {
        if (this.title == null || this.title.equals("")) {
            this.title = (!this.series.equals("") ? this.series : this.chart.colData[this.chart.chartType != 2 ? this.chart.valueCol : this.chart.coordCol[0]].getName()) + " (" + this.getShortName(this.linetype) + ")";
        }
    }

    abstract void write(DataOutput var1) throws IOException;

    abstract void read(DataInput var1, int var2) throws IOException;

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<< DataLine >>\n");
        sb.append("linetype\t= " + this.linetype + "\n");
        sb.append("coeff\t\t= " + this.coeff + "\n");
        sb.append("title\t\t= " + this.title + "\n");
        sb.append("thickness\t= " + this.thickness + "\n");
        sb.append("hlco_value\t= " + this.hlco_value + "\n");
        sb.append("positive_line\t= " + this.positive_line + "\n");
        sb.append("series\t\t= " + this.series + "\n");
        sb.append("color\t\t= " + this.color + "\n");
        sb.append("hideTitle\t= " + this.hideTitle + "\n");
        sb.append("useSubvalue\t= " + this.useSubvalue + "\n");
        sb.append("useAxis\t= " + this.useAxis + "\n");
        sb.append("line_value\t= " + this.getLineValue() + "\n");
        sb.append("showValue\t= " + this.showValue + "\n");
        sb.append("valueHint\t= " + this.valueHint + "\n");
        int nAnno = this.annoVector == null ? 0 : this.annoVector.size();
        for (int i = 0; i < nAnno; ++i) {
            IAnnotation target = this.annoVector.elementAt(i);
            if (!(target instanceof CAnnotation)) continue;
            sb.append(target);
        }
        return sb.toString();
    }
}

