/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.chart.Chart;

public class DrillDownInfo {
    private static final Logger LOGGER = Logger.getLogger(DrillDownInfo.class.getName());
    int chartType;
    int[] mDataMap;
    int datadim;
    boolean isDrill2D;

    public DrillDownInfo(int cType, int[] dataMap, int dim, boolean is2D) {
        this.chartType = cType;
        this.mDataMap = new int[dataMap.length];
        this.datadim = dim;
        this.isDrill2D = is2D;
        for (int i = 0; i < dataMap.length; ++i) {
            this.mDataMap[i] = dataMap[i];
        }
    }

    public static void write(DataOutput out, Vector drillDownVector) {
        if (drillDownVector.size() == 0) {
            return;
        }
        try {
            out.writeInt(drillDownVector.size());
            for (int i = 0; i < drillDownVector.size(); ++i) {
                DrillDownInfo dInfo = (DrillDownInfo)drillDownVector.elementAt(i);
                out.writeInt(dInfo.datadim);
                out.writeInt(dInfo.chartType);
                out.writeBoolean(dInfo.isDrill2D);
                for (int x = 0; x < dInfo.datadim; ++x) {
                    out.writeInt(dInfo.mDataMap[x]);
                }
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to write drill-down vector to the chart", e);
        }
    }

    public static Vector read(DataInput din, int version) {
        boolean dType = true;
        Vector<DrillDownInfo> drillVector = null;
        try {
            int count = din.readInt();
            if (count == 0) {
                return null;
            }
            drillVector = new Vector<DrillDownInfo>(count + 1);
            for (int i = 0; i < count; ++i) {
                int dim = din.readInt();
                int cType = din.readInt();
                if (version >= 76) {
                    dType = din.readBoolean();
                }
                int[] map = new int[dim];
                for (int x = 0; x < dim; ++x) {
                    map[x] = din.readInt();
                }
                drillVector.addElement(new DrillDownInfo(cType, map, dim, dType));
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to read drill-down information from the chart", e);
            return null;
        }
        return drillVector;
    }

    public static boolean checkDrillDownType(int chartType) {
        return chartType != 11 && chartType != 8 && chartType != 10 && chartType != 9 && chartType != 15 && !Chart.isCoordinateType(chartType) && chartType != 18;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<< DrillDownInfo >>\n");
        sb.append("chartType\t= ").append(this.chartType).append("\n");
        sb.append("mDataMap[]\t= ");
        for (int element : this.mDataMap) {
            sb.append(element).append(" ");
        }
        sb.append("\n");
        sb.append("datadim\t\t= ").append(this.datadim).append("\n");
        return sb.toString();
    }
}

