/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Vector;
import quadbase.chart.CGraphics;
import quadbase.chart.ImageMapNode;
import quadbase.common.awt.Arc;
import quadbase.common.util.internal.QbUtil;
import quadbase.util.PickData;

public class DrillDownMap {
    protected Vector vec;
    protected String name;

    public DrillDownMap(String name, Vector vec) {
        int i = name.lastIndexOf(System.getProperty("file.separator"));
        this.name = i >= 0 ? name.substring(i + 1) : name;
        this.vec = vec;
    }

    public void write(OutputStream out, String chartFile, String servletLoc, PickData[] pickData, String[] argv) {
        PrintWriter writer = new PrintWriter(out, true);
        this.exportMap(chartFile, servletLoc, pickData, argv, writer);
        writer.close();
    }

    private void exportMap(String chartFile, String servletLoc, PickData[] pickData, String[] argv, PrintWriter out) {
        if (this.vec != null) {
            int level = 1;
            if (pickData != null) {
                level = pickData.length + 1;
            }
            String prev = level + "$_$";
            if (pickData != null) {
                for (PickData element : pickData) {
                    prev = prev + CGraphics.getDrillDownLink((PickData)element).link;
                }
            }
            if (servletLoc.indexOf(63) < 0) {
                servletLoc = servletLoc + "?";
            }
            if (!servletLoc.endsWith("?")) {
                servletLoc = servletLoc + "&";
            }
            out.println("<MAP NAME=\"" + this.name + "\">");
            for (int i = this.vec.size() - 1; i >= 0; --i) {
                ImageMapNode node = (ImageMapNode)this.vec.elementAt(i);
                String nodeLink = prev + node.link;
                String optionParam = "";
                if (argv != null) {
                    for (String element : argv) {
                        optionParam = optionParam + "&ARGV=" + QbUtil.encodeURIComponent(element);
                    }
                }
                nodeLink = QbUtil.encodeURIComponent(nodeLink);
                if (!node.link.equals("")) {
                    nodeLink = servletLoc + "FILENAME=" + chartFile + "&PARAM=" + nodeLink + optionParam;
                    nodeLink = QbUtil.tokenizeAndEscapeGETParameters(nodeLink);
                    nodeLink = "href=\"" + nodeLink + "\" title=\"" + QbUtil.removeUnsafeChars(node.hint) + "\" alt=\"" + QbUtil.removeUnsafeChars(node.hint) + "\" onclick=\"if(typeof allowOnBeforeUnload != 'undefined') {allowOnBeforeUnload=false;}\"";
                    if (node.target != null && !node.target.equals("")) {
                        nodeLink = nodeLink + " target=\"" + node.target + "\"";
                    }
                } else {
                    nodeLink = "title=\"" + QbUtil.removeUnsafeChars(node.hint) + "\" alt=\"" + QbUtil.removeUnsafeChars(node.hint) + "\"";
                }
                if (this.isInstanceofFace(node, nodeLink, out)) continue;
                if (node.obj instanceof Rectangle) {
                    Rectangle r = (Rectangle)node.obj;
                    out.println("<area " + nodeLink + " shape=\"rect\" coords=\"" + r.x + "," + r.y + "," + (r.x + r.width) + "," + (r.y + r.height) + "\"/>\n");
                    continue;
                }
                if (node.obj instanceof Polygon) {
                    int j;
                    Polygon p = (Polygon)node.obj;
                    out.println("<area " + nodeLink + " shape=\"poly\" coords=\"");
                    for (j = 0; j < p.npoints - 1; ++j) {
                        out.println(p.xpoints[j] + "," + p.ypoints[j] + ",");
                    }
                    out.println(p.xpoints[j] + "," + p.ypoints[j] + "\"/>\n");
                    continue;
                }
                if (!(node.obj instanceof Arc)) continue;
                Arc ar = (Arc)node.obj;
                if (ar.angle < 360) {
                    this.outputArc(node, nodeLink, ar.x, ar.y, ar.w / 2, ar.h / 2, (double)ar.startangle * Math.PI / 180.0, (double)(ar.startangle + ar.angle) * Math.PI / 180.0, ar.arcLen, out);
                    continue;
                }
                out.println("<area " + nodeLink + " shape=\"circle\" coords=\"" + ar.x + "," + ar.y + "," + Math.max(ar.w, ar.h) / 2 + "\"/>");
            }
        }
        out.println("</MAP>");
    }

    protected boolean isInstanceofFace(ImageMapNode node, String nodeLink, PrintWriter out) {
        return false;
    }

    private void outputArc(ImageMapNode node, String nodeLink, int x, int y, int w, int h, double angle1, double angle2, int arcLen, PrintWriter out) {
        int x1 = x + (int)((double)w * Math.cos(angle1));
        int y1 = y - (int)((double)h * Math.sin(angle1));
        int x2 = x + (int)((double)w * Math.cos(angle2));
        int y2 = y - (int)((double)h * Math.sin(angle2));
        if ((y1 - y2) * (y1 - y2) + (x1 - x2) * (x1 - x2) < 400) {
            if (arcLen == 100) {
                out.println("<area " + nodeLink + " shape=poly coords=\"" + x + "," + y + "," + x2 + "," + y2 + "," + x1 + "," + y1 + "\">");
            } else {
                int x3 = x + (int)((double)(w * (100 - arcLen) / 100) * Math.cos(angle2));
                int y3 = y - (int)((double)(h * (100 - arcLen) / 100) * Math.sin(angle2));
                int x4 = x + (int)((double)(w * (100 - arcLen) / 100) * Math.cos(angle1));
                int y4 = y - (int)((double)(h * (100 - arcLen) / 100) * Math.sin(angle1));
                out.println("<area " + nodeLink + " shape=poly coords=\"" + x4 + "," + y4 + "," + x3 + "," + y3 + "," + x2 + "," + y2 + "," + x1 + "," + y1 + "\">");
            }
        } else {
            double half = (angle1 + angle2) / 2.0;
            this.outputArc(node, nodeLink, x, y, w, h, angle1, half, arcLen, out);
            this.outputArc(node, nodeLink, x, y, w, h, half, angle2, arcLen, out);
        }
    }
}

