/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.io.IOException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.ColMetaData;
import quadbase.chart.DBAccess;
import quadbase.chart.DataFileInput;
import quadbase.chart.EJBAccess;
import quadbase.chart.ExcelAccess;
import quadbase.chart.FilterInfo;
import quadbase.chart.PreprocInfo;
import quadbase.chart.SOAPAccess;
import quadbase.chart.SalesForceAccess;
import quadbase.util.IResultSet;
import quadbase.util.PickData;

public class DrillHistory {
    private static final Logger LOGGER = Logger.getLogger(DrillHistory.class.getName());
    Chart parentChart = null;
    Vector originalMetaData = null;
    Vector drillVector = null;
    int numElements = 0;

    public DrillHistory(Chart parentChart, Vector originalMetaData) {
        this.parentChart = parentChart;
        this.originalMetaData = originalMetaData;
        this.drillVector = new Vector(10);
        this.numElements = 0;
    }

    public int getCategoryIndex(int[] mDataMap, int dataDim, int chartType, boolean is2DChart) {
        int index = Chart.stackType(chartType) ? (dataDim == 2 ? mDataMap[0] : mDataMap[1]) : (dataDim == 1 ? mDataMap[0] : mDataMap[1]);
        return index;
    }

    public int getSeriesIndex(int[] mDataMap, int dataDim, int chartType, boolean is2DChart) {
        int index = Chart.stackType(chartType) ? (dataDim == 2 ? -1 : mDataMap[0]) : (dataDim == 1 ? -1 : mDataMap[0]);
        return index;
    }

    public int getSumByIndex(int[] mDataMap, int dataDim, int chartType, boolean is2DChart) {
        int index = Chart.stackType(chartType) ? (dataDim == 2 ? mDataMap[1] : mDataMap[2]) : -1;
        return index;
    }

    public PreprocInfo createPreprocInfo(int[] map, int dim, int valCol, int subvalCol, int cType, boolean is2DChart, int primaryAggregate, int secondaryAggregate) {
        int primaryIndex = -1;
        int secondaryIndex = -1;
        int categoryIndex = -1;
        int seriesIndex = -1;
        int sumByIndex = -1;
        if (valCol >= 0) {
            primaryIndex = valCol + 1;
        }
        if (subvalCol >= 0) {
            secondaryIndex = subvalCol + 1;
        }
        categoryIndex = this.getCategoryIndex(map, dim, cType, is2DChart);
        int categoryType = ((ColMetaData)this.originalMetaData.elementAt(categoryIndex)).getSQLType();
        PreprocInfo tsInfo = new PreprocInfo(categoryType);
        tsInfo.selectColIndex = categoryIndex + 1;
        tsInfo.aggrColIndex[0] = primaryIndex;
        tsInfo.aggrColIndex[1] = secondaryIndex;
        seriesIndex = this.getSeriesIndex(map, dim, cType, is2DChart);
        if (seriesIndex >= 0) {
            // empty if block
        }
        tsInfo.groupColIndex[0] = ++seriesIndex;
        sumByIndex = this.getSumByIndex(map, dim, cType, is2DChart);
        if (sumByIndex >= 0) {
            // empty if block
        }
        tsInfo.groupColIndex[1] = ++sumByIndex;
        tsInfo.aggrOp[0] = primaryAggregate;
        tsInfo.aggrOp[1] = secondaryAggregate;
        return tsInfo;
    }

    public void setChartType(Chart chart, PreprocInfo tsInfo) {
        boolean seriesExists = false;
        boolean sumByExists = false;
        int dim = 1;
        int valueCol = 0;
        int subvalueCol = -1;
        if (tsInfo.groupColIndex[0] >= 0) {
            seriesExists = true;
            ++dim;
        }
        if (tsInfo.groupColIndex[1] >= 0) {
            sumByExists = true;
            ++dim;
        }
        int[] datamap = new int[dim];
        if (seriesExists) {
            datamap[0] = 1;
            datamap[1] = 0;
            if (dim == 2) {
                valueCol = 2;
                if (tsInfo.aggrColIndex[1] >= 1) {
                    subvalueCol = 3;
                }
            } else {
                datamap[2] = 2;
                valueCol = 3;
                if (tsInfo.aggrColIndex[1] >= 1) {
                    subvalueCol = 4;
                }
            }
        } else if (sumByExists) {
            datamap[0] = 0;
            datamap[1] = 1;
            valueCol = 2;
            if (tsInfo.aggrColIndex[1] >= 1) {
                subvalueCol = 3;
            }
        } else {
            datamap[0] = 0;
            valueCol = 1;
            if (tsInfo.aggrColIndex[1] >= 1) {
                subvalueCol = 2;
            }
        }
        chart.setChartType(datamap, dim, valueCol, subvalueCol);
    }

    public ColData[] nextDrill(PickData pickdata, PreprocInfo tsInfo) {
        OneDrill oDrill = new OneDrill(pickdata);
        this.drillVector.addElement(oDrill);
        this.numElements += oDrill.dim;
        return this.getNewData(tsInfo);
    }

    public ColData[] previousDrill(PreprocInfo tsInfo) {
        OneDrill oDrill = (OneDrill)this.drillVector.lastElement();
        this.drillVector.removeElement(oDrill);
        this.numElements -= oDrill.dim;
        return this.getNewData(tsInfo);
    }

    public ColData[] currentDrill(PreprocInfo tsInfo) {
        return this.getNewData(tsInfo);
    }

    public void removeLastDrill() {
        OneDrill oDrill = (OneDrill)this.drillVector.lastElement();
        this.drillVector.removeElement(oDrill);
        this.numElements -= oDrill.dim;
    }

    private ColData[] getNewData(PreprocInfo tsInfo) {
        ColData[] coldata = null;
        FilterInfo filterInfo = this.createFilterInfo();
        try {
            boolean doFilter = false;
            if (this.parentChart.sourceData == 2 || this.parentChart.sourceData == 6 || this.parentChart.sourceData == 4 || this.parentChart.sourceData == 7) {
                try {
                    coldata = new DataFileInput().readProcessedData(this.parentChart.sourceFile, this.parentChart.isTransposed(), this.parentChart.getTransposeColumn(), filterInfo, tsInfo, this.parentChart.xmlFileQueryInfo, this.parentChart.sourceData, this.parentChart.isDrawNullColumn(), this.parentChart.getNullColumnName(), this.parentChart.sourceFileEncoding);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, "Failed to load data from file", ex);
                    throw new IOException("Failed to load data " + ex.getMessage());
                }
            } else if (this.parentChart.sourceData == 5) {
                try {
                    coldata = EJBAccess.retrieveResult(this.parentChart.jndiName, this.parentChart.homeName, this.parentChart.remoteName, this.parentChart.selectedMethodName, this.parentChart.selectedMethodParamVal, this.parentChart.environment, this.parentChart.isTransposed(), this.parentChart.getTransposeColumn(), filterInfo, tsInfo);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, "Failed to load data from EJB", ex);
                    throw new IOException("Failed to load data " + ex.getMessage());
                }
            } else if (this.parentChart.sourceData == 1) {
                coldata = DBAccess.retrieveResult(this.parentChart.getQueryFileInfo() == null ? null : this.parentChart.getQueryFileInfo().makeVector(), this.parentChart.dbInfo, true, this.parentChart.isTransposed(), this.parentChart.getTransposeColumn(), filterInfo, tsInfo, 0, -1, this.parentChart.isDrawNullColumn(), this.parentChart.getNullColumnName());
            } else if (this.parentChart.sourceData == 12) {
                coldata = SOAPAccess.retrieveResult(this.parentChart.soapInfo);
                doFilter = true;
            } else if (this.parentChart.sourceData == 11) {
                coldata = SalesForceAccess.getColData(this.parentChart.sfQueryInfo);
                doFilter = true;
            } else if (this.parentChart.sourceData == 13) {
                coldata = ExcelAccess.getColData(this.parentChart.excelInfo);
                doFilter = true;
            } else if (this.parentChart.sourceData == 3) {
                coldata = ColData.getColData(this.parentChart.sourceList, this.parentChart.sourceType, null, null, false, null, false);
                doFilter = true;
            } else {
                coldata = this.parentChart.originalColDataFromMemSource;
                doFilter = true;
            }
            if (doFilter) {
                IResultSet rs = ColData.getResultSet(coldata);
                rs = DBAccess.processResultSet(rs, false, this.parentChart.isTransposed(), this.parentChart.getTransposeColumn(), filterInfo, tsInfo, this.parentChart.isDrawNullColumn(), this.parentChart.getNullColumnName());
                coldata = ColData.getColData(rs);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to load DrillDown data", e);
            return null;
        }
        if (coldata != null) {
            for (ColData element : coldata) {
                element.setDrawNullColumn(this.parentChart.isDrawNullColumn());
                element.setNullColumnName(this.parentChart.getNullColumnName());
            }
        }
        return coldata;
    }

    private FilterInfo createFilterInfo() {
        OneDrill drillObject = null;
        int count = 0;
        int[] dataType = new int[this.numElements];
        int[] compareOp = new int[this.numElements];
        int[] colIndex = new int[this.numElements];
        Object[] value = new Object[this.numElements];
        for (int x = 0; x < this.numElements; ++x) {
            compareOp[x] = 0;
        }
        for (int i = 0; i < this.drillVector.size(); ++i) {
            drillObject = (OneDrill)this.drillVector.elementAt(i);
            if (drillObject.categoryIndex > 0) {
                dataType[count] = drillObject.categoryType;
                colIndex[count] = drillObject.categoryIndex;
                value[count] = this.parentChart.isDrawNullColumn() && drillObject.categoryValue.equals(this.parentChart.getNullColumnName()) ? null : drillObject.categoryValue;
                ++count;
            }
            if (drillObject.seriesIndex > 0) {
                dataType[count] = drillObject.seriesType;
                colIndex[count] = drillObject.seriesIndex;
                value[count] = drillObject.seriesValue;
                ++count;
            }
            if (drillObject.sumByIndex <= 0) continue;
            dataType[count] = drillObject.sumByType;
            colIndex[count] = drillObject.sumByIndex;
            value[count] = drillObject.sumByValue;
            ++count;
        }
        return new FilterInfo(dataType, compareOp, colIndex, value);
    }

    public String getCategoryColumnName(int level) {
        OneDrill tempDrill = (OneDrill)this.drillVector.elementAt(level);
        if (tempDrill.categoryIndex == -1) {
            return null;
        }
        return ((ColMetaData)this.originalMetaData.elementAt((int)(tempDrill.categoryIndex - 1))).columnName;
    }

    public Object getCategoryValue(int level) {
        OneDrill tempDrill = (OneDrill)this.drillVector.elementAt(level);
        if (tempDrill.categoryIndex == -1) {
            return null;
        }
        return tempDrill.categoryValue;
    }

    public String getSeriesColumnName(int level) {
        OneDrill tempDrill = (OneDrill)this.drillVector.elementAt(level);
        if (tempDrill.seriesIndex == -1) {
            return null;
        }
        return ((ColMetaData)this.originalMetaData.elementAt((int)(tempDrill.seriesIndex - 1))).columnName;
    }

    public Object getSeriesValue(int level) {
        OneDrill tempDrill = (OneDrill)this.drillVector.elementAt(level);
        if (tempDrill.seriesIndex == -1) {
            return null;
        }
        return tempDrill.seriesValue;
    }

    public String getSumByColumnName(int level) {
        OneDrill tempDrill = (OneDrill)this.drillVector.elementAt(level);
        if (tempDrill.sumByIndex == -1) {
            return null;
        }
        return ((ColMetaData)this.originalMetaData.elementAt((int)(tempDrill.sumByIndex - 1))).columnName;
    }

    public Object getSumByValue(int level) {
        OneDrill tempDrill = (OneDrill)this.drillVector.elementAt(level);
        if (tempDrill.sumByIndex == -1) {
            return null;
        }
        return tempDrill.sumByValue;
    }

    private class OneDrill {
        int categoryIndex = -1;
        int seriesIndex = -1;
        int sumByIndex = -1;
        int categoryType;
        int seriesType;
        int sumByType;
        Object categoryValue;
        Object seriesValue;
        Object sumByValue;
        int dim;

        OneDrill(PickData pickdata) {
            if (pickdata.category != null) {
                this.categoryIndex = this.findIndex(pickdata.categoryName);
                this.categoryType = ((ColMetaData)DrillHistory.this.originalMetaData.elementAt(this.categoryIndex - 1)).getSQLType();
                this.categoryValue = this.convertString(pickdata.category, this.categoryType);
                ++this.dim;
            }
            if (pickdata.series != null) {
                this.seriesIndex = this.findIndex(pickdata.seriesName);
                this.seriesType = ((ColMetaData)DrillHistory.this.originalMetaData.elementAt(this.seriesIndex - 1)).getSQLType();
                this.seriesValue = this.convertString(pickdata.series, this.seriesType);
                ++this.dim;
            }
            if (pickdata.sumBy != null) {
                this.sumByIndex = this.findIndex(pickdata.sumByName);
                this.sumByType = ((ColMetaData)DrillHistory.this.originalMetaData.elementAt(this.sumByIndex - 1)).getSQLType();
                this.sumByValue = this.convertString(pickdata.sumBy, this.sumByType);
                ++this.dim;
            }
        }

        int findIndex(String colName) {
            int index = 0;
            ColMetaData cmData = null;
            for (int i = 0; i < DrillHistory.this.originalMetaData.size(); ++i) {
                cmData = (ColMetaData)DrillHistory.this.originalMetaData.elementAt(i);
                if (!colName.equals(cmData.getColumnName())) continue;
                index = i + 1;
                break;
            }
            return index;
        }

        Object convertString(String value, int type) {
            if (DrillHistory.this.parentChart.isDrawNullColumn() && DrillHistory.this.parentChart.getNullColumnName().equals(value)) {
                return value;
            }
            switch (type) {
                case -1: 
                case 1: 
                case 12: {
                    return value;
                }
                case 6: 
                case 7: {
                    return Float.valueOf(value);
                }
                case 2: 
                case 3: 
                case 8: {
                    return Double.valueOf(value);
                }
                case -5: {
                    return Long.valueOf(value);
                }
                case -6: 
                case 4: 
                case 5: {
                    return Integer.valueOf(value);
                }
                case -7: {
                    return Boolean.valueOf(value);
                }
                case 91: {
                    return Date.valueOf(value);
                }
                case 92: {
                    return Time.valueOf(value);
                }
                case 93: {
                    return Timestamp.valueOf(value);
                }
            }
            return null;
        }
    }
}

