/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import quadbase.chart.Chart;
import quadbase.chart.Coordinate;

public class FaceData {
    private Coordinate upperLeft;
    private Coordinate upperRight;
    private Coordinate lowerLeft;
    private Coordinate lowerRight;
    private Chart chart;
    private String hyperLink = null;
    private String hint = null;
    private String target = null;

    public FaceData(Coordinate ll, Coordinate lr, Coordinate ur, Coordinate ul, Chart chart) {
        this.upperLeft = ul;
        this.upperRight = ur;
        this.lowerLeft = ll;
        this.lowerRight = lr;
        this.chart = chart;
    }

    public Coordinate getUpperLeftCoord() {
        return this.upperLeft;
    }

    public Coordinate getUpperRightCoord() {
        return this.upperRight;
    }

    public Coordinate getLowerLeftCoord() {
        return this.lowerLeft;
    }

    public Coordinate getLowerRightCoord() {
        return this.lowerRight;
    }

    public boolean isxWithinFaceData(double x) {
        return this.upperLeft.getx() == x || this.upperRight.getx() == x || this.lowerLeft.getx() == x || this.upperRight.getx() == x;
    }

    public boolean iszWithinFaceData(double z) {
        return this.upperLeft.getz() == z || this.upperRight.getz() == z || this.lowerLeft.getz() == z || this.upperRight.getz() == z;
    }

    public boolean isSurfaceChart() {
        return this.chart.chartType == 12;
    }

    public String getHyperLink() {
        return this.hyperLink;
    }

    public String getHint() {
        return this.hint;
    }

    public String getTarget() {
        return this.target;
    }

    public void setHyperLink(String hyperLink, String hint, String target) {
        this.hyperLink = hyperLink;
        this.target = target;
        this.hint = hint;
    }
}

