/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.awt.Color;
import quadbase.util.IGradientPropertySet;
import quadbase.util.internal.IOUtil;

public class GradientSupport
implements IGradientPropertySet {
    private boolean isGradientOn = false;
    private boolean is3DShadingOn = false;
    private double gradientStartX = 0.0;
    private double gradientStartY = 0.0;
    private double gradientEndX = 1.0;
    private double gradientEndY = 1.0;
    private Color gradientDesColor = null;
    private int gradientShade = -2;
    private boolean gradientCyclic = true;
    private boolean applyGradientToChartDataOnly = true;

    @Override
    public boolean isGradientEnabled() {
        return this.isGradientOn && IOUtil.isJava2D();
    }

    @Override
    public void setGradientEnabled(boolean b) {
        this.isGradientOn = b;
    }

    @Override
    public boolean is3DShadingEnabled() {
        return this.is3DShadingOn && IOUtil.isJava2D();
    }

    @Override
    public void set3DShadingEnabled(boolean b) {
        this.is3DShadingOn = b;
    }

    public boolean isApplyGradientToChartDataOnly() {
        return this.applyGradientToChartDataOnly;
    }

    public void setApplyGradientToChartDataOnly(boolean b) {
        this.applyGradientToChartDataOnly = b;
    }

    @Override
    public double getGradientStartX() {
        return this.gradientStartX;
    }

    @Override
    public double getGradientStartY() {
        return this.gradientStartY;
    }

    @Override
    public double getGradientEndX() {
        return this.gradientEndX;
    }

    @Override
    public double getGradientEndY() {
        return this.gradientEndY;
    }

    @Override
    public Color getGradientDesColor() {
        return this.gradientDesColor;
    }

    @Override
    public int getGradientShade() {
        return this.gradientShade;
    }

    @Override
    public boolean isGradientCyclic() {
        return this.gradientCyclic;
    }

    @Override
    public void setGradientStartX(double x) {
        this.gradientStartX = x;
    }

    @Override
    public void setGradientStartY(double y) {
        this.gradientStartY = y;
    }

    @Override
    public void setGradientEndX(double x) {
        this.gradientEndX = x;
    }

    @Override
    public void setGradientEndY(double y) {
        this.gradientEndY = y;
    }

    @Override
    public void setGradientDesColor(Color c) {
        this.gradientDesColor = c;
    }

    @Override
    public void setGradientShade(int s) {
        this.gradientShade = s;
    }

    @Override
    public void setGradientCyclic(boolean c) {
        this.gradientCyclic = c;
    }

    public void copy(GradientSupport _grad) {
        this.isGradientOn = _grad.isGradientOn;
        this.is3DShadingOn = _grad.is3DShadingOn;
        this.applyGradientToChartDataOnly = _grad.applyGradientToChartDataOnly;
        this.gradientStartX = _grad.gradientStartX;
        this.gradientStartY = _grad.gradientStartY;
        this.gradientEndX = _grad.gradientEndX;
        this.gradientEndY = _grad.gradientEndY;
        this.gradientDesColor = _grad.gradientDesColor;
        this.gradientShade = _grad.gradientShade;
        this.gradientCyclic = _grad.gradientCyclic;
    }

    public static void copy(IGradientPropertySet src, IGradientPropertySet des) {
        des.setGradientEnabled(src.isGradientEnabled());
        des.set3DShadingEnabled(src.is3DShadingEnabled());
        des.setGradientStartX(src.getGradientStartX());
        des.setGradientStartY(src.getGradientStartY());
        des.setGradientEndX(src.getGradientEndX());
        des.setGradientEndY(src.getGradientEndY());
        des.setGradientDesColor(src.getGradientDesColor());
        des.setGradientShade(src.getGradientShade());
        des.setGradientCyclic(src.isGradientCyclic());
    }
}

