/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.chart.Area;
import quadbase.chart.CAnnotation;
import quadbase.chart.CGraphics;
import quadbase.chart.CString;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.DataLine;
import quadbase.chart.HiLowData;
import quadbase.chart.HiLowMap;
import quadbase.chart.IOUtil2;
import quadbase.chart.IPieChart;
import quadbase.chart.Legend;
import quadbase.chart.MultiDimData;
import quadbase.chart.PlotData;
import quadbase.chart.Point3D;
import quadbase.chart.PropCString;
import quadbase.chart.chart2d.Area2D;
import quadbase.chart.chart3d.Area3D;
import quadbase.common.util.internal.IQbGraphics;
import quadbase.common.util.internal.QbUtil;
import quadbase.common.util.internal.VersioningDataOutput;
import quadbase.util.IAnnotation;
import quadbase.util.internal.IOUtil;

public class GraphicsTable {
    private static final Logger LOGGER = Logger.getLogger(GraphicsTable.class.getName());
    private static final String DEFAULT_FONT = "Dialog";
    private static final short COLOR_SYMBOL_SIZE = 8;
    public boolean dragged = false;
    public boolean draw = true;
    public boolean keepPosition = true;
    public int tableWidth = 0;
    public int tableHeight = 0;
    public boolean shift = true;
    int maxColumn = 31;
    int maxRow = 31;
    public Graphics g;
    public int x = -1;
    public int y = -1;
    public float relX = -1.0f;
    public float relY = -1.0f;
    public int ox;
    public int oy;
    public int width;
    public int height;
    public int widthPerCell = 80;
    public int heightPerCell = 20;
    static final String headstr = "HEADING";
    MultiDimData rootData;
    Chart chart;
    public int column;
    public int row;
    public int rcolumn;
    public int rrow;
    public int maxChar = 13;
    public int cellWidthOffset = 5;
    public int cellHeightOffset = 4;
    public int tab_width = 10;
    public int tab_height = 25;
    public int select_tab = 0;
    public int axisTabWidth = 95;
    int[] shown;
    int[] rowShown;
    static final String[] axisName = new String[]{"X", "Y", "Z"};
    public int tInterval = 40;
    int heightOffset = 0;
    public int direction = 2;
    int rowOffset = -1;
    public Color headColor;
    public Color cellColor;
    public Font headFont = null;
    public Font cellFont = null;
    public Color headTextColor;
    public Color cellTextColor;
    public int select;
    boolean isShownHead = true;
    public boolean isCenter = true;
    public boolean tabPanel = false;
    public static final int HEAD = 0;
    public static final int CELL = 1;
    public static final int HEADTEXT = 2;
    public static final int CELLTEXT = 3;
    public int[] cBorder = null;
    public int[] eWidth = null;
    public int[] tBorder = null;
    public int[][] cellMatrix = null;
    public int totalLength;
    public int tab_num = 0;
    public boolean isHorizontal = true;
    private boolean showColorSymbols = true;
    public Area area;
    public Area framearea;
    public int tmplen;
    public boolean clear = true;
    public boolean firstShown = true;
    public CGraphics cg;
    public boolean rect = false;
    public int select_axis = 0;
    public int change = 0;
    private FontMetrics fm = null;
    public static final short ALIGN_LEFT = 0;
    public static final short ALIGN_CENTER = 1;
    public static final short ALIGN_RIGHT = 2;
    public short alignCatTitle = 0;
    public short alignCatValue = 0;
    public short alignSeriesTitle = 0;
    public short alignSeriesValue = 0;
    public short alignPrimTitle = 0;
    public short alignSecTitle = 0;
    public short alignPrimValue = (short)2;
    public short alignSecValue = (short)2;
    boolean calculateRelativePos = true;
    int omitNumber;
    int omitInterval;
    int omitRowNumber;
    int omitRowInterval;

    public GraphicsTable() {
        this.headColor = new Color(200, 200, 200);
        this.cellColor = new Color(255, 255, 255);
        this.headTextColor = Color.black;
        this.cellTextColor = Color.black;
    }

    public GraphicsTable(Chart chart, MultiDimData root, int x, int y, int width, int height, int direction, boolean isHorizontal, Area area) {
        this();
        this.rootData = root;
        this.chart = chart;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.direction = direction;
        this.isHorizontal = isHorizontal;
        this.isCenter = false;
        this.framearea = area;
        this.ox = x;
        this.oy = y;
        this.relX = (float)((double)x / chart.getSize().getWidth());
        this.relY = (float)((chart.getSize().getHeight() - (double)y) / chart.getSize().getHeight());
        this.init();
    }

    public void setGraphics(CGraphics cgraphics) {
        this.cg = cgraphics;
    }

    private void setProperty() {
        if (this.width < 700 || this.height < 600) {
            this.widthPerCell = 80;
            this.maxChar = 13;
            this.cellWidthOffset = 5;
            this.cellHeightOffset = 4;
            this.tInterval = 40;
            if (this.headFont == null) {
                this.headFont = new Font(DEFAULT_FONT, 0, 9);
            }
            if (this.cellFont == null) {
                this.cellFont = new Font(DEFAULT_FONT, 0, 9);
            }
        } else {
            this.widthPerCell = 80;
            this.maxChar = 11;
            this.cellWidthOffset = 5;
            this.cellHeightOffset = 4;
            this.tInterval = 40;
            if (this.headFont == null) {
                this.headFont = new Font(DEFAULT_FONT, 0, 13);
            }
            if (this.cellFont == null) {
                this.cellFont = new Font(DEFAULT_FONT, 0, 13);
            }
        }
    }

    public void setData(Chart chart, MultiDimData root) {
        this.chart = chart;
        this.rootData = root;
    }

    public int getHeight() {
        if (this.clear) {
            return 0;
        }
        this.heightOffset = this.heightPerCell * this.rrow + this.tInterval;
        if (this.tabPanel) {
            return this.heightOffset + this.tab_height;
        }
        return this.heightOffset;
    }

    public int getWidth() {
        if (this.clear) {
            return 0;
        }
        return this.totalLength + this.tInterval;
    }

    public boolean isShowColorSymbols() {
        return this.showColorSymbols;
    }

    public void setShowColorSymbols(boolean showColorSymbols) {
        this.showColorSymbols = showColorSymbols;
    }

    public void paint() {
        this.paint(this.x, this.y, this.width, this.height, this.g);
    }

    public void resizeTable(int newWidth, int newHeight) {
        if (this.chart.gt.direction == 2) {
            if (newHeight != this.height) {
                this.y = (int)((double)newHeight / (double)this.height * (double)this.y);
            }
        } else if (newWidth != this.width) {
            this.x = (int)((double)newWidth / (double)this.width * (double)this.x);
            this.x = newWidth / this.width * this.x;
        }
    }

    public void paint(Chart chart, MultiDimData root, Graphics g, int x, int y, int width, int height, int direction, boolean isHorizontal, Area area, CGraphics cgraphics) {
        this.g = g;
        this.x = x;
        this.y = y;
        this.direction = direction;
        this.isHorizontal = isHorizontal;
        this.width = width;
        this.height = height;
        this.chart = chart;
        this.rootData = root;
        this.isCenter = !this.keepPosition;
        this.framearea = area;
        this.cg = cgraphics;
        this.paint(x, y, width, height, g);
    }

    public void clear() {
        this.tableWidth = this.direction == 2 ? 0 : this.getWidth();
        this.tableHeight = this.direction == 2 ? this.getHeight() : 0;
        this.firstShown = true;
        this.tabPanel = false;
        this.heightOffset = 0;
        this.select_tab = 0;
        this.dragged = false;
        this.clear = true;
    }

    public void clearNoSave() {
        this.clear();
        this.tableWidth = 0;
        this.tableHeight = 0;
    }

    private void paint(int x, int y, int width, int height, Graphics g) {
        this.paint(x, y, width, height, g, true);
    }

    private void paint(int x, int y, int width, int height, Graphics g, boolean firstTry) {
        try {
            if (g == null) {
                quadbase.common.util.internal.IOUtil.getOffScreenGraphics();
            }
            this.tab_num = 0;
            if (this.select_axis == 0 && this.chart.mData != this.rootData) {
                this.rootData = this.chart.mData;
                this.cBorder = null;
            }
            if (this.select_axis == 1 && this.chart.mData2 != this.rootData) {
                this.rootData = this.chart.mData2;
                this.cBorder = null;
            }
            if (this.rootData == null) {
                this.select_axis = 0;
                this.rootData = this.chart.mData;
                this.cBorder = null;
            }
            if (this.clear) {
                this.cBorder = null;
                this.tBorder = null;
                this.tabPanel = false;
                this.eWidth = null;
                this.cellMatrix = null;
            }
            this.x = x;
            this.y = y;
            if (!this.rect) {
                this.ox = x;
                this.oy = y;
            }
            this.width = width;
            this.height = height;
            this.g = g;
            this.heightOffset = 0;
            this.setProperty();
            this.draw = !this.firstShown || !this.draw;
            if (Chart.isCoordinateType(this.chart.chartType)) {
                this.clear();
                return;
            }
            if (this.chart.isHiLow() && this.rootData == this.chart.mData) {
                if (this.chart.dataDim == 1) {
                    this.show_hilow(this.chart);
                } else {
                    this.show_series_hilow(this.chart);
                }
            } else if (this.chart.getChartType() == 15 && this.rootData == this.chart.mData) {
                this.show_boxData(this.chart);
            } else {
                switch (this.rootData.chart.dataDim) {
                    case 1: {
                        this.show_category(this.rootData.chart);
                        break;
                    }
                    case 2: {
                        if (this.chart.isStackType()) {
                            this.show_series_category2(this.rootData.chart);
                            break;
                        }
                        this.show_series_category(this.rootData.chart);
                        break;
                    }
                    case 3: {
                        this.show_sum_series_category(this.rootData.chart);
                        break;
                    }
                }
            }
            this.clear = false;
            if (this.change != 0) {
                this.paint();
            }
            if (this.firstShown) {
                this.autoAdjust();
                this.firstShown = false;
                this.paint();
            }
        }
        catch (Exception ex) {
            if (firstTry) {
                this.clear();
                this.paint(x, y, width, height, g, false);
            }
            LOGGER.log(Level.WARNING, "Painting failed", ex);
        }
    }

    void calculatePosition(Chart chart, CGraphics cgraphics) {
        this.draw = false;
        if (this.clear) {
            int tmpy;
            int tmpx;
            MultiDimData root = null;
            if (chart.dataDim == 1 && chart.isSecondaryDataShownInPrimaryTab()) {
                root = chart.mData;
            }
            root = chart.showLegend2() ? (this.select_axis == 0 ? chart.mData : chart.mData2) : chart.mData;
            if (this.keepPosition) {
                tmpx = this.x;
                tmpy = this.y;
            } else {
                tmpx = chart.winWidth - this.tableWidth;
                tmpy = chart.winHeight - this.tableHeight;
            }
            this.paint(chart, root, cgraphics.g, tmpx, tmpy, chart.winWidth, chart.winHeight, this.direction, this.isHorizontal, chart.farea, cgraphics);
        }
        GraphicsTable.shiftWithTable(chart);
        this.draw = true;
    }

    public void calculateRelativePos(boolean b) {
        if (this.chart == null) {
            return;
        }
        this.calculateRelativePos = b;
        int winWidth = this.chart.winWidth;
        int winHeight = this.chart.winHeight;
        if (b) {
            if (this.x != 0) {
                this.relX = (float)this.x / (float)winWidth;
            }
            this.relY = (float)(winHeight - this.y) / (float)winHeight;
        } else {
            this.relY = -1.0f;
            this.relX = -1.0f;
        }
    }

    void draw(Chart chart, CGraphics cgraphics) {
        int winWidth = chart.winWidth;
        int winHeight = chart.winHeight;
        if (this.calculateRelativePos) {
            if (this.relX >= 0.0f) {
                this.x = (int)((float)winWidth * this.relX);
            } else if (this.x != 0) {
                this.relX = (float)this.x / (float)winWidth;
            }
            if (this.relY >= 0.0f) {
                this.y = (int)((float)winHeight - (float)winHeight * this.relY);
            } else {
                this.relY = (float)(winHeight - this.y) / (float)winHeight;
            }
        }
        if (cgraphics.g instanceof IQbGraphics) {
            ((IQbGraphics)((Object)cgraphics.g)).setTableTab();
        }
        if (this.clear && this.direction == 2) {
            if (chart.showLegend2()) {
                int dy = winHeight + this.heightPerCell;
                if (chart.dataDim == 1 && chart.isSecondaryDataShownInPrimaryTab() || this.select_axis == 0) {
                    this.paint(chart, chart.mData, cgraphics.g, 0, dy, winWidth, winHeight, this.direction, this.isHorizontal, chart.farea, cgraphics);
                } else {
                    this.paint(chart, chart.mData2, cgraphics.g, 0, dy, winWidth, winHeight, this.direction, this.isHorizontal, chart.farea, cgraphics);
                }
                this.show_Ctab();
            } else {
                this.paint(chart, chart.mData, cgraphics.g, 0, winHeight, winWidth, winHeight, this.direction, this.isHorizontal, chart.farea, cgraphics);
            }
        } else if (this.clear && this.direction == 3) {
            if (chart.showLegend2()) {
                int dy = this.heightPerCell;
                if (chart.dataDim == 1 && chart.isSecondaryDataShownInPrimaryTab() || this.select_axis == 0) {
                    this.paint(chart, chart.mData, cgraphics.g, winWidth, dy, winWidth, winHeight, this.direction, this.isHorizontal, chart.farea, cgraphics);
                } else {
                    this.paint(chart, chart.mData2, cgraphics.g, winWidth, dy, winWidth, winHeight, this.direction, this.isHorizontal, chart.farea, cgraphics);
                }
                this.show_Ctab();
            } else {
                this.paint(chart, chart.mData, cgraphics.g, winWidth, 0, winWidth, winHeight, this.direction, this.isHorizontal, chart.farea, cgraphics);
            }
        } else if (this.direction == 2) {
            int tx = this.x;
            int ty = this.y;
            chart.aTCX = this.x - (int)((float)winWidth * chart.chart_XProp);
            chart.aTCY = this.y - (int)((float)winHeight * (chart.chart_YProp + chart.chart_heightProp));
            this.setGraphics(cgraphics);
            this.paint(tx, ty, winWidth, winHeight, cgraphics.g);
            if (chart.showLegend2()) {
                this.show_Ctab();
            }
        } else if (this.direction == 3) {
            int tx = this.x;
            int ty = this.y;
            chart.aTCX = this.x - (int)((float)winWidth * (chart.chart_XProp + chart.chart_widthProp));
            chart.aTCY = this.y - (int)((float)winHeight * chart.chart_YProp);
            this.setGraphics(cgraphics);
            this.paint(tx, ty, winWidth, winHeight, cgraphics.g);
            if (chart.showLegend2()) {
                this.show_Ctab();
            }
        }
        if (cgraphics.g instanceof IQbGraphics) {
            ((IQbGraphics)((Object)cgraphics.g)).setEndTab();
        }
    }

    private void drawArea(int x1, int y1, int x2, int y2) {
        if (!this.draw) {
            return;
        }
        this.framearea.areaColor = this.headColor;
        int dy1 = this.height - y1;
        int dy2 = this.height - y2;
        this.framearea.setpos(x1, dy1, x2, dy2);
        this.framearea.draw(this.cg);
    }

    private int containE(String str) {
        for (int i = 1; i < str.length(); ++i) {
            String sub = str.substring(i);
            if (!sub.startsWith("E")) continue;
            try {
                Double.parseDouble(str.substring(0, i));
                Double.parseDouble(str.substring(i + 1));
                return i;
            }
            catch (Exception ex) {
                return -1;
            }
        }
        return -1;
    }

    private String fitSize(String str, int col) {
        return this.fitSize(str, col, this.cellFont);
    }

    private String fitSize(String text, int col, Font f) {
        String str = CString.tokenizer(this.chart.valueTable.getRunTimeValue(text))[0];
        Font font = f;
        if (col > this.column) {
            col = this.column;
        }
        int w = this.cBorder[col] == 0 ? this.widthPerCell : this.cBorder[col];
        int maxChar = Math.max(1, (w - this.cellWidthOffset) * 2 / font.getSize());
        if (str.length() < maxChar) {
            return str;
        }
        int pos = this.containE(str);
        if (pos == -1) {
            return str.substring(0, maxChar - 1);
        }
        int last = str.length() - pos;
        if ((last = maxChar - last - 1) < 1) {
            last = 1;
        }
        return str.substring(0, last) + str.substring(pos);
    }

    private void drawTable(int x, int y, int row, int column, boolean sum) {
        int i;
        int i2;
        int no;
        int i3;
        if (this.cBorder == null) {
            this.cBorder = new int[column + 1];
            this.eWidth = new int[column + 1];
            if (this.chart.isSecondaryDataShownInPrimaryTab()) {
                ++row;
            }
            this.cellMatrix = new int[column + 1][row + 1];
            for (i3 = 0; i3 < this.eWidth.length; ++i3) {
                this.cBorder[i3] = 0;
                this.eWidth[i3] = 0;
                for (int j = 0; j < row + 1; ++j) {
                    this.cellMatrix[i3][j] = 0;
                }
            }
            this.rcolumn = this.direction == 2 ? Math.min(column + 1, this.width / this.widthPerCell) : Math.min(this.maxColumn, column + 1);
            this.shown = new int[this.rcolumn - 1];
            for (i3 = 0; i3 < this.rcolumn - 1; ++i3) {
                this.shown[i3] = 0;
            }
            this.omitNumber = Math.max(0, column - this.rcolumn + 1);
            this.omitInterval = this.rcolumn > 1 ? (this.omitNumber % (this.rcolumn - 1) == 0 ? this.omitNumber / (this.rcolumn - 1) : this.omitNumber / (this.rcolumn - 1) + 1) : 10000;
            no = 0;
            if (this.rcolumn > 1) {
                for (i2 = 0; i2 < column; ++i2) {
                    this.shown[no] = i2;
                    if (this.omitNumber > 0) {
                        i2 += this.omitInterval;
                    }
                    this.omitNumber -= this.omitInterval;
                    ++no;
                }
            }
            if (this.isHorizontal && sum) {
                this.shown[this.rcolumn - 2] = column - 1;
            }
            int tp = this.widthPerCell;
            this.cBorder[0] = this.widthPerCell;
            for (i = 0; i < column; ++i) {
                if (this.isShown(i)) {
                    this.cBorder[i + 1] = this.widthPerCell;
                    tp += this.widthPerCell;
                    continue;
                }
                this.cBorder[i + 1] = 0;
            }
            this.totalLength = tp;
        } else {
            int tmpRcolumn;
            this.change = this.width > this.totalLength ? (this.width - this.totalLength) / this.widthPerCell : (this.width - this.totalLength) / this.widthPerCell - 1;
            if (this.change < 0) {
                this.change = 0;
            }
            if ((tmpRcolumn = Math.min(column + 1, this.rcolumn + this.change)) == this.rcolumn) {
                this.change = 0;
            } else {
                this.rcolumn = tmpRcolumn;
            }
            this.isCenter = (this.firstShown || this.change != 0) && !this.keepPosition;
            if (this.change != 0) {
                this.shown = new int[this.rcolumn - 1];
            }
            this.omitNumber = Math.max(0, column - this.rcolumn + 1);
            this.omitInterval = this.rcolumn > 1 ? (this.omitNumber % (this.rcolumn - 1) == 0 ? this.omitNumber / (this.rcolumn - 1) : this.omitNumber / (this.rcolumn - 1) + 1) : 10000;
            int no2 = 0;
            if (this.rcolumn > 1) {
                for (i = 0; i < column; ++i) {
                    this.shown[no2] = i;
                    if (this.omitNumber > 0) {
                        i += this.omitInterval;
                    }
                    this.omitNumber -= this.omitInterval;
                    ++no2;
                }
                int k = no2;
                if (k <= this.rcolumn - 2 && this.omitInterval > 0) {
                    for (int j = 0; j < this.rcolumn - 1 - k; ++j) {
                        this.shown[no2++] = this.shown[k - 1] - j * this.omitInterval - 1;
                    }
                }
            }
            if (this.isHorizontal && sum) {
                this.shown[this.rcolumn - 2] = column - 1;
            }
            int tp = this.cBorder[0];
            for (int i4 = 0; i4 < column; ++i4) {
                if (this.isShown(i4)) {
                    if (this.cBorder[i4 + 1] == 0) {
                        this.cBorder[i4 + 1] = this.eWidth[i4 + 1];
                    }
                    tp += this.cBorder[i4 + 1];
                    continue;
                }
                this.cBorder[i4 + 1] = 0;
            }
            this.totalLength = tp;
        }
        this.rrow = this.direction == 3 ? Math.min(row + 1, this.height / this.heightPerCell) : Math.min(this.maxRow, row + 1);
        this.rowShown = new int[Math.max(0, this.rrow - 1)];
        for (i3 = 0; i3 < this.rrow - 1; ++i3) {
            this.rowShown[i3] = 0;
        }
        this.omitRowNumber = Math.max(0, row - this.rrow + 1);
        this.omitRowInterval = this.rrow > 1 ? (this.omitRowNumber % (this.rrow - 1) == 0 ? this.omitRowNumber / (this.rrow - 1) : this.omitRowNumber / (this.rrow - 1) + 1) : 10000;
        no = 0;
        if (this.rrow > 1) {
            for (i2 = 0; i2 < row; ++i2) {
                this.rowShown[no] = i2;
                if (this.omitRowNumber > 0) {
                    i2 += this.omitRowInterval;
                }
                this.omitRowNumber -= this.omitRowInterval;
                ++no;
            }
        }
        if (no < this.rrow - 1) {
            int k = no;
            for (i = 0; i < this.rrow - k - 1; ++i) {
                this.rowShown[no++] = this.rowShown[i] + (this.omitRowInterval / 2 + 1);
            }
        }
        if (!this.isHorizontal && sum) {
            this.rowShown[this.rrow - 2] = row - 1;
        }
        if (no >= this.rrow - 1) {
            no = this.rrow - 2;
        }
        if (!this.isHorizontal && sum) {
            this.rowShown[no] = row - 1;
        }
        if (this.isCenter && (this.direction == 2 || this.direction == 1)) {
            this.x = x = this.keepPosition ? this.x : (this.width - this.totalLength) / 2;
            this.ox = x;
            this.y = y = this.keepPosition ? this.y : this.height;
            this.oy = y;
        } else if (this.isCenter && this.direction == 3) {
            y = !this.tabPanel ? (this.keepPosition ? this.y : (this.height - this.rrow * this.heightPerCell) / 2) : (this.keepPosition ? this.y : (this.height - this.rrow * this.heightPerCell - this.tab_height) / 2);
            this.y = y;
            this.oy = y;
            this.x = x = this.keepPosition ? this.x : this.width;
            this.ox = x;
        }
        if (this.tabPanel) {
            y += this.tab_height;
        }
        if (this.g == null) {
            return;
        }
        if (this.change == 0 && this.draw) {
            this.drawArea(x, y, x + this.totalLength, y + this.rrow * this.heightPerCell);
            this.g.setColor(this.headColor);
            this.g.fillRect(x, y, this.totalLength, this.heightPerCell);
            this.g.fillRect(x, y + this.heightPerCell, this.cBorder[0], (this.rrow - 1) * this.heightPerCell);
            this.g.setColor(this.cellColor);
            this.g.fillRect(x + this.cBorder[0], y + this.heightPerCell, this.totalLength - this.cBorder[0], (this.rrow - 1) * this.heightPerCell);
            this.g.setColor(this.headColor);
            this.g.setColor(Color.black);
            this.g.drawRect(x, y, this.totalLength, this.rrow * this.heightPerCell);
            int currentX = this.cBorder[0];
            for (i = 0; i < column; ++i) {
                this.g.drawLine(x + currentX, y, x + currentX, y + this.heightPerCell * this.rrow);
                currentX += this.cBorder[i + 1];
            }
            for (i = 1; i < this.rrow + 1; ++i) {
                this.g.drawLine(x, y + this.heightPerCell * i, x + this.totalLength, y + this.heightPerCell * i);
            }
        }
    }

    private void init() {
        int i;
        if (this.column < 1) {
            return;
        }
        this.cBorder = new int[this.column + 1];
        this.eWidth = new int[this.column + 1];
        if (this.chart.isSecondaryDataShownInPrimaryTab()) {
            ++this.row;
        }
        this.cellMatrix = new int[this.column + 1][this.row + 1];
        for (i = 0; i < this.eWidth.length; ++i) {
            this.eWidth[i] = 0;
        }
        this.rcolumn = this.direction == 2 ? Math.min(this.column + 1, this.width / this.widthPerCell) : Math.min(this.maxColumn, this.column + 1);
        this.shown = new int[this.rcolumn - 1];
        for (i = 0; i < this.rcolumn - 1; ++i) {
            this.shown[i] = 0;
        }
        this.totalLength = this.widthPerCell * this.rcolumn;
        this.omitNumber = Math.max(0, this.column - this.rcolumn + 1);
        this.omitInterval = this.rcolumn > 1 ? (this.omitNumber % (this.rcolumn - 1) == 0 ? this.omitNumber / (this.rcolumn - 1) : this.omitNumber / (this.rcolumn - 1) + 1) : 10000;
        int no = 0;
        if (this.rcolumn > 1) {
            for (int i2 = 0; i2 < this.column; ++i2) {
                this.shown[no] = i2;
                if (this.omitNumber > 0) {
                    i2 += this.omitInterval;
                }
                this.omitNumber -= this.omitInterval;
                ++no;
            }
        }
        int tp = this.widthPerCell;
        this.cBorder[0] = this.widthPerCell;
        for (int i3 = 0; i3 < this.column; ++i3) {
            if (this.isShown(i3)) {
                this.cBorder[i3 + 1] = this.widthPerCell;
                tp += this.widthPerCell;
                continue;
            }
            this.cBorder[i3 + 1] = 0;
        }
        this.totalLength = tp;
        this.clear = false;
        this.rrow = this.direction == 3 ? Math.min(this.row + 1, this.height / this.heightPerCell) : Math.min(this.maxRow, this.row + 1);
    }

    private void drawGrid() {
        int i;
        if (this.change != 0 || !this.draw) {
            return;
        }
        int y = this.y;
        if (this.tabPanel) {
            y += this.tab_height;
        }
        this.g.setColor(Color.black);
        this.g.drawRect(this.x, y, this.totalLength, this.rrow * this.heightPerCell);
        int currentX = this.cBorder[0];
        for (i = 0; i < this.column; ++i) {
            this.g.drawLine(this.x + currentX, y, this.x + currentX, y + this.heightPerCell * this.rrow);
            currentX += this.cBorder[i + 1];
        }
        for (i = 0; i < this.rrow; ++i) {
            this.g.drawLine(this.x, y + this.heightPerCell * i, this.x + this.totalLength, y + this.heightPerCell * i);
        }
    }

    private boolean isRowShown(int no) {
        if (this.rrow < 2) {
            return false;
        }
        for (int element : this.rowShown) {
            if (element != no) continue;
            return true;
        }
        return false;
    }

    private int getDisplayRow(int rowno) {
        if (this.rrow < 2) {
            return -1;
        }
        for (int i = 0; i < this.rowShown.length; ++i) {
            if (this.rowShown[i] != rowno) continue;
            return i;
        }
        return -1;
    }

    private boolean isShown(int no) {
        if (this.rcolumn < 2) {
            return false;
        }
        for (int element : this.shown) {
            if (element != no) continue;
            return true;
        }
        return false;
    }

    private String fitHeader(String text, int cn, FontMetrics fm) {
        int i;
        String str = CString.tokenizer(this.chart.valueTable.getRunTimeValue(text))[0];
        int w = 0;
        int d = this.isHorizontal ? cn : 0;
        for (i = 0; i < str.length() && this.cBorder[d] >= (w += fm.charWidth(str.charAt(i))) + 2 * this.cellWidthOffset; ++i) {
        }
        return str.substring(0, i);
    }

    private void setHeading(int x, int y, String heading1, Object[] heading2, boolean sum) {
        this.setHeading(x, y, heading1, heading2, sum, false, null);
    }

    private void setHeading(int x, int y, String heading1, Object[] heading2, boolean sum, boolean hideLastColumn, MultiDimData[] mdData) {
        boolean drawColorSymbolsForSpecificCharts;
        this.g.setFont(QbUtil.resizeViewerFont(this.headFont, this.chart.isAdjustFont()));
        this.fm = this.g.getFontMetrics(QbUtil.resizeViewerFont(this.headFont, this.chart.isAdjustFont()));
        y += 10;
        if (this.tabPanel) {
            y += this.tab_height;
        }
        if (heading1 != null) {
            heading1 = this.fitHeader(heading1, 0, this.fm);
            if (this.change == 0 && this.draw) {
                this.g.setColor(this.headColor);
                this.g.fillRect(x + 1, y - 10 + 1, this.cBorder[0] - 2, this.heightPerCell - 2);
                this.g.setColor(this.headTextColor);
                this.drawString(this.g, heading1, x + 1, y - 10 + 1, this.cBorder[0] - 2, this.heightPerCell - 2, this.alignCatTitle);
            }
            this.autoAdjustPrepare(heading1, 0, 0, 0);
        } else if (this.change == 0 && this.draw) {
            this.g.setColor(this.headColor);
            this.g.fillRect(x + 1, y - 10 + 1, this.cBorder[0] - 2, this.heightPerCell - 2);
            this.g.setColor(this.headTextColor);
            this.drawString(this.g, this.fitHeader("null", 0, this.fm), x + 1, y - 10 + 1, this.cBorder[0] - 2, this.heightPerCell - 2, this.alignCatTitle);
        }
        int c = heading2.length + 1;
        if (hideLastColumn) {
            --c;
        }
        boolean bl = drawColorSymbolsForSpecificCharts = this.chart.getChartType() == 6 || this.chart.isStackType();
        if (this.isHorizontal) {
            int count = sum ? this.rcolumn - 2 : this.rcolumn - 1;
            int currentX = this.cBorder[0] + x;
            for (int i = 1; i < c; ++i) {
                if (heading2[i - 1] == null) continue;
                String rec = heading2[i - 1].toString().trim();
                this.autoAdjustPrepare(rec, i, 0, 0);
                if (!this.isShown(i - 1) || count <= 0) continue;
                rec = this.fitHeader(rec, i, this.fm);
                if (this.change == 0 && this.draw) {
                    this.g.setColor(this.headColor);
                    this.g.fillRect(currentX + 1, y - 10 + 1, this.cBorder[i] - 2, this.heightPerCell - 2);
                    this.g.setColor(Color.black);
                    this.g.setColor(this.headTextColor);
                    MultiDimData mDat = null;
                    if (mdData != null) {
                        mDat = drawColorSymbolsForSpecificCharts && i - 1 < mdData.length ? mdData[i - 1] : mdData[0];
                    }
                    this.drawString(this.g, rec, currentX + 1, y - 10 + 1, this.cBorder[i] - 2, this.heightPerCell - 2, this.alignCatValue, drawColorSymbolsForSpecificCharts, mDat, i - 1);
                }
                currentX += this.cBorder[i];
                --count;
            }
            if (sum) {
                this.autoAdjustPrepare("Sum", this.column, 0, 0);
                if (this.change == 0 && this.draw) {
                    this.g.setColor(this.headColor);
                    this.g.fillRect(currentX + 1, y - 10 + 1, this.cBorder[this.column] - 2, this.heightPerCell - 2);
                    this.g.setColor(this.headTextColor);
                    this.drawString(this.g, this.fitHeader("Sum", this.cBorder.length - 1, this.fm), currentX + 1, y - 10 + 1, this.cBorder[this.column] - 2, this.heightPerCell - 2, this.alignCatValue);
                }
            }
        } else if (!this.isHorizontal) {
            int count = sum ? this.rrow - 2 : this.rrow - 1;
            int offset = 1;
            for (int i = 1; i < c; ++i) {
                if (heading2[i - 1] == null) continue;
                String rec = heading2[i - 1].toString().trim();
                this.autoAdjustPrepare(rec, 0, i, 0);
                rec = this.fitHeader(rec, i, this.fm);
                if (!this.isRowShown(i - 1) || count <= 0) continue;
                if (this.change == 0 && this.draw) {
                    this.g.setColor(this.headColor);
                    this.g.fillRect(x + 1, y - 10 + 1 + offset * this.heightPerCell, this.cBorder[0] - 2, this.heightPerCell - 2);
                    this.g.setColor(this.headTextColor);
                    MultiDimData mDat = null;
                    if (mdData != null) {
                        mDat = drawColorSymbolsForSpecificCharts && i - 1 < mdData.length ? mdData[i - 1] : mdData[0];
                    }
                    this.drawString(this.g, rec, x + 1, y - 10 + 1 + offset * this.heightPerCell, this.cBorder[0] - 2, this.heightPerCell - 2, this.alignCatValue, drawColorSymbolsForSpecificCharts, mDat, i - 1);
                }
                --count;
                ++offset;
            }
            if (sum) {
                this.autoAdjustPrepare("Sum", 0, this.row, 0);
                if (this.change == 0 && this.draw) {
                    this.g.setColor(this.headColor);
                    this.g.fillRect(x + 1, y - 10 + this.heightPerCell * offset + 1, this.cBorder[0] - 2, this.heightPerCell - 2);
                    this.g.setColor(this.headTextColor);
                    this.drawString(this.g, this.fitHeader("Sum", this.row, this.fm), x + this.cellWidthOffset, y - 10 + this.heightPerCell * offset + 1, this.cBorder[0] - 2, this.heightPerCell - 2, this.alignCatValue);
                }
            }
        }
    }

    private boolean isPrimary(MultiDimData[] data) {
        if (data == null || data.length <= 0) {
            return true;
        }
        return data[0].isPrimary();
    }

    private boolean isSecondary(MultiDimData[] data) {
        return !this.isPrimary(data);
    }

    private short getAlignContentTitle(MultiDimData[] data) {
        if (this.isPrimary(data)) {
            return this.alignPrimTitle;
        }
        if (this.isSecondary(data)) {
            return this.alignSecTitle;
        }
        return this.alignPrimTitle;
    }

    private short getAlignContentValue(MultiDimData[] data) {
        if (this.isPrimary(data)) {
            return this.alignPrimValue;
        }
        if (this.isSecondary(data)) {
            return this.alignSecValue;
        }
        return this.alignPrimValue;
    }

    private void setContent(int x, int y, String firstname, MultiDimData[] data, int rowno, boolean sum) {
        this.setContent(x, y, firstname, data, rowno, sum, 0);
    }

    private void setContent(int x, int y, String firstname, MultiDimData[] data, int rowno, boolean sum, int valueType) {
        this.setContent(x, y, firstname, data, rowno, sum, valueType, -1);
    }

    private void setContent(int x, int y, String firstname, MultiDimData[] data, int rowno, boolean sum, int valueType, int axisPos) {
        int i;
        int c;
        if (this.g == null) {
            return;
        }
        int drowno = this.getDisplayRow(rowno);
        String rec = "";
        int d = 0;
        y += 10;
        if (this.tabPanel) {
            y += this.tab_height;
        }
        this.g.setFont(QbUtil.resizeViewerFont(this.headFont, this.chart.isAdjustFont()));
        if (firstname != null) {
            int height;
            int width;
            boolean doNotDrawColorSymbolsForSpecificChartTypes;
            firstname = firstname.trim();
            if (this.isHorizontal) {
                firstname = this.fitSize(firstname, 0, this.headFont);
                this.autoAdjustPrepare(firstname, 0, rowno + 1, 0);
            } else {
                firstname = this.fitSize(firstname, rowno + 1, this.headFont);
                this.autoAdjustPrepare(firstname, rowno + 1, 0, 0);
            }
            short contentTitleAlign = this.getAlignContentTitle(data);
            boolean bl = doNotDrawColorSymbolsForSpecificChartTypes = this.chart.isCircularChart() && this.chart.getSeriesIndex() == -1 || this.chart.isStackType();
            if (this.isHorizontal && this.isRowShown(rowno)) {
                int yStart;
                int xStart = x + 1;
                width = this.cBorder[0] - 2;
                height = this.heightPerCell - 2;
                if (this.direction == 3) {
                    ++this.rowOffset;
                    if (this.change == 0 && this.draw) {
                        this.g.setColor(this.headColor);
                        yStart = y - 10 + this.heightPerCell + this.heightPerCell * this.rowOffset + 1;
                        this.g.fillRect(xStart, yStart, width, height);
                        this.g.setColor(this.headTextColor);
                        this.drawString(this.g, firstname, xStart, yStart, width, height, contentTitleAlign, !doNotDrawColorSymbolsForSpecificChartTypes, data != null ? data[0] : null, drowno);
                    }
                } else if (this.change == 0 && this.draw) {
                    if (drowno < 0) {
                        return;
                    }
                    this.g.setColor(this.headColor);
                    yStart = y - 10 + this.heightPerCell + this.heightPerCell * drowno + 1;
                    this.g.fillRect(xStart, yStart, width, height);
                    this.g.setColor(this.headTextColor);
                    this.drawString(this.g, firstname, xStart, yStart, width, height, contentTitleAlign, !doNotDrawColorSymbolsForSpecificChartTypes, data != null ? data[0] : null, drowno);
                }
            } else if (!this.isHorizontal && this.isShown(rowno)) {
                int yStart = y - 10 + 1;
                width = this.cBorder[rowno + 1] - 2;
                height = this.heightPerCell - 2;
                if (this.direction == 3 || this.direction == 2) {
                    d = 0;
                    for (int k = 0; k < rowno + 1; ++k) {
                        d += this.cBorder[k];
                    }
                    int xStart = x + d + 1;
                    if (this.change == 0 && this.draw) {
                        this.g.setColor(this.headColor);
                        this.g.fillRect(xStart, yStart, width, height);
                        this.g.setColor(this.headTextColor);
                        this.drawString(this.g, firstname, xStart, yStart, width, height, contentTitleAlign, !doNotDrawColorSymbolsForSpecificChartTypes, data != null ? data[0] : null, drowno);
                    }
                }
            }
        }
        this.g.setFont(QbUtil.resizeViewerFont(this.cellFont, this.chart.isAdjustFont()));
        this.g.setColor(this.cellTextColor);
        double sumValue = 0.0;
        int n = c = sum ? this.rcolumn - 2 : this.rcolumn - 1;
        if (!this.isHorizontal) {
            c = sum ? this.rrow - 2 : this.rrow - 1;
        }
        int count = 0;
        boolean pieWithOthers = this.chart.isCircularChart() && this.chart.getPieGroupOthersLimit() > 0.0 && this.chart.dataDim == 1;
        int currentX = x + this.cBorder[0];
        for (i = 0; i < data.length; ++i) {
            if (pieWithOthers && i == data.length - 1) continue;
            PlotData pd = data[i].plotData;
            if (pd.isEmpty() && count < c) {
                if (this.isHorizontal) {
                    this.autoAdjustPrepare("null", i + 1, rowno + 1, 1);
                    if (!this.isShown(i) || !this.isRowShown(rowno)) continue;
                    if (this.change == 0 && this.draw) {
                        if (drowno < 0) {
                            return;
                        }
                        this.g.setColor(this.cellColor);
                        this.g.fillRect(currentX + 1, y - 10 + this.heightPerCell + this.heightPerCell * drowno + 1, this.cBorder[i + 1] - 2, this.heightPerCell - 2);
                        this.g.setColor(this.cellTextColor);
                        this.drawString(this.g, "null", currentX + 1, y - 10 + this.heightPerCell + this.heightPerCell * drowno + 1, this.cBorder[i + 1] - 2, this.heightPerCell - 2, this.getAlignContentValue(data));
                    }
                    currentX += this.cBorder[i + 1];
                    ++count;
                    continue;
                }
                this.autoAdjustPrepare("null", rowno + 1, i + 1, 1);
                if (!this.isShown(rowno) || !this.isRowShown(i)) continue;
                if (this.change == 0 && this.draw) {
                    this.g.setColor(this.cellColor);
                    this.g.fillRect(x + d + 1, y - 10 + this.heightPerCell + this.heightPerCell * count + 1, this.cBorder[rowno + 1] - 2, this.heightPerCell - 2);
                    this.g.setColor(this.cellTextColor);
                    this.drawString(this.g, "null", x + d + 1, y - 10 + this.heightPerCell + this.heightPerCell * count + 1, this.cBorder[rowno + 1] - 2, this.heightPerCell - 2, this.getAlignContentValue(data));
                }
                ++count;
                continue;
            }
            double val = pd.getValue(valueType);
            sumValue += val;
            if (this.chart.isCircularChart()) {
                rec = ((IPieChart)((Object)this.chart)).getPieChart().formatingValue(val);
            } else if (this.chart.getChartType() == 14) {
                if (axisPos == -1) {
                    rec = this.chart.a_y.formating(val);
                } else if (axisPos == -2) {
                    rec = this.chart.a_s.formating(val);
                } else if (this.chart.colDataAxis != null && axisPos < this.chart.colDataAxis.length) {
                    rec = this.chart.colDataAxis[axisPos].formating(val);
                }
            } else {
                rec = DataLine.isBarChartType(this.chart) ? this.chart.a_x.formating(val) : this.chart.a_y.formating(val);
            }
            rec = this.isHorizontal ? this.fitSize(rec, i + 1) : this.fitSize(rec, rowno + 1);
            if (this.isHorizontal) {
                this.autoAdjustPrepare(rec, i + 1, rowno + 1, 1);
                if (count >= c || !this.isShown(i) || !this.isRowShown(rowno)) continue;
                if (this.direction == 3) {
                    if (this.change == 0 && this.draw) {
                        this.g.setColor(this.cellColor);
                        this.g.fillRect(currentX + 1, y - 10 + this.heightPerCell + this.heightPerCell * this.rowOffset + 1, this.cBorder[i + 1] - 2, this.heightPerCell - 2);
                        this.g.setColor(this.cellTextColor);
                        this.drawString(this.g, rec, currentX + 1, y - 10 + this.heightPerCell + this.heightPerCell * this.rowOffset + 1, this.cBorder[i + 1] - 2, this.heightPerCell - 2, this.getAlignContentValue(data));
                    }
                    currentX += this.cBorder[i + 1];
                    ++count;
                    continue;
                }
                if (this.change == 0 && this.draw) {
                    if (drowno < 0) {
                        return;
                    }
                    this.g.setColor(this.cellColor);
                    this.g.fillRect(currentX + 1, y - 10 + this.heightPerCell + this.heightPerCell * drowno + 1, this.cBorder[i + 1] - 2, this.heightPerCell - 2);
                    this.g.setColor(this.cellTextColor);
                    this.drawString(this.g, rec, currentX + 1, y - 10 + this.heightPerCell + this.heightPerCell * drowno + 1, this.cBorder[i + 1] - 2, this.heightPerCell - 2, this.getAlignContentValue(data));
                }
                currentX += this.cBorder[i + 1];
                ++count;
                continue;
            }
            if (this.isHorizontal) continue;
            this.autoAdjustPrepare(rec, rowno + 1, i + 1, 1);
            if (count >= c || !this.isShown(rowno) || !this.isRowShown(i)) continue;
            if (this.change == 0 && this.draw) {
                this.g.setColor(this.cellColor);
                if (this.direction == 2) {
                    this.g.fillRect(x + d + 1, y - 10 + this.heightPerCell + this.heightPerCell * count + 1, this.cBorder[rowno + 1] - 2, this.heightPerCell - 2);
                } else {
                    this.g.fillRect(x + d + 1, y - 10 + this.heightPerCell + this.heightPerCell * count + 1, this.cBorder[rowno + 1] - 2, this.heightPerCell - 2);
                }
                this.g.setColor(this.cellTextColor);
                this.drawString(this.g, rec, x + d + 1, y - 10 + this.heightPerCell + this.heightPerCell * count + 1, this.cBorder[rowno + 1] - 2, this.heightPerCell - 2, this.getAlignContentValue(data));
            }
            ++count;
        }
        if (sum) {
            String sumValueStr = "";
            sumValueStr = DataLine.isBarChartType(this.chart) ? this.chart.a_x.formating(sumValue) : this.chart.a_y.formating(sumValue);
            if (this.isHorizontal) {
                if (this.change == 0 && this.draw) {
                    if (drowno < 0) {
                        return;
                    }
                    this.g.setColor(this.cellColor);
                    this.g.fillRect(currentX + 1, y - 10 + this.heightPerCell + this.heightPerCell * drowno + 1, this.cBorder[i + 1] - 2, this.heightPerCell - 2);
                    this.g.setColor(this.cellTextColor);
                }
                String st = this.fitSize(sumValueStr, this.column);
                this.autoAdjustPrepare(st, this.column, rowno + 1, 1);
                if (this.change == 0 && this.draw) {
                    this.drawString(this.g, st, currentX + 1, y - 10 + this.heightPerCell + this.heightPerCell * drowno + 1, this.cBorder[i + 1] - 2, this.heightPerCell - 2, this.getAlignContentValue(data));
                }
            } else if (this.isShown(rowno)) {
                if (this.change == 0 && this.draw) {
                    this.g.setColor(this.cellColor);
                    this.g.fillRect(x + d + 1, y - 10 + this.heightPerCell + this.heightPerCell * count + 1, this.cBorder[rowno + 1] - 2, this.heightPerCell - 2);
                    this.g.setColor(this.cellTextColor);
                }
                String st = this.fitSize(sumValueStr, rowno + 1);
                this.autoAdjustPrepare(st, rowno + 1, this.row, 1);
                if (this.change == 0 && this.draw) {
                    this.drawString(this.g, this.fitSize(sumValueStr, rowno + 1), x + d + 1, y - 10 + this.heightPerCell + this.heightPerCell * count + 1, this.cBorder[rowno + 1] - 2, this.heightPerCell - 2, this.getAlignContentValue(data));
                }
            }
        }
        this.drawGrid();
    }

    private void drawColorSymbol(MultiDimData mdData, int xStart, int yStart, int height, int mdDataIndex) {
        if (mdData != null && mdData.area != null) {
            Color backupColor = this.g.getColor();
            Color rowColor = mdData.area.areaColor;
            Color symbolColor = new Color(rowColor.getRed(), rowColor.getGreen(), rowColor.getBlue());
            this.g.setColor(symbolColor);
            Area2D dataPointArea = new Area2D(symbolColor);
            int dpaX = xStart + 4;
            int dpaY = (int)(-((double)yStart - this.chart.getSize().getHeight()) - (double)height / 2.0 + 4.0);
            if (this.chart.legend != null) {
                Legend legend = this.chart.legend;
                if ((legend.drawSymbols || this.chart.getChartType() == 3) && mdDataIndex != -1 && legend.legendShape != null && mdDataIndex < legend.legendShape.length) {
                    int[] legendShapes = legend.legendShape;
                    if (!legend.reverse) {
                        legendShapes = new int[legend.legendShape.length];
                        int left = 0;
                        for (int right = legend.legendShape.length - 1; left < right; ++left, --right) {
                            int temp = legend.legendShape[left];
                            legendShapes[left] = legend.legendShape[right];
                            legendShapes[right] = temp;
                        }
                    }
                    new Point3D(dpaX + 4, dpaY - 4, symbolColor, this.chart.getChartType() == 3 && !legend.drawSymbols ? 6 : legendShapes[mdDataIndex], 1, legend.getDrawPointBorderColor()).drawPt(this.cg, legend.isDrawPointBorder(), legend.isDrawSymbolWithLine(), this.cg.chart.getPrimaryDataGradientSupport());
                } else {
                    dataPointArea.copy(mdData.area);
                    dataPointArea.p1.x = dpaX;
                    dataPointArea.p1.y = dpaY;
                    dataPointArea.p2.x = dpaX + 8;
                    dataPointArea.p2.y = dpaY - 8;
                    dataPointArea.draw(this.cg);
                }
            }
            this.g.setColor(backupColor);
        }
    }

    private void show_category(Chart chart) {
        this.tabPanel = false;
        this.rowOffset = -1;
        ColData cdata = chart.colData[chart.mDataMap[0]];
        String valName = chart.colData[chart.valueCol].getName();
        if (this.rootData == chart.mData2) {
            valName = chart.colData[chart.subvalueCol].getName();
        }
        boolean pieWithOthers = false;
        boolean bl = pieWithOthers = chart.isCircularChart() && chart.getPieGroupOthersLimit() > 0.0;
        if (this.isHorizontal) {
            this.row = chart.isSecondaryDataShownInPrimaryTab() ? 2 : 1;
            this.column = chart.mDataLen[0];
            if (pieWithOthers) {
                --this.column;
            }
            this.drawTable(this.x, this.y, this.row, this.column, false);
            String heading1 = cdata.getName();
            this.setHeading(this.x, this.y, heading1, cdata.fieldName, false, pieWithOthers, chart.mData.multiData);
            if (chart.isSecondaryDataShownInPrimaryTab()) {
                this.setContent(this.x, this.y, chart.colData[chart.valueCol].getName(), chart.mData.multiData, 0, false);
                this.setContent(this.x, this.y, chart.colData[chart.subvalueCol].getName(), chart.mData2.multiData, 1, false);
            } else {
                this.setContent(this.x, this.y, valName, this.rootData.multiData, 0, false);
            }
        } else {
            this.column = chart.isSecondaryDataShownInPrimaryTab() ? 2 : 1;
            this.row = chart.mDataLen[0];
            if (pieWithOthers) {
                --this.row;
            }
            this.drawTable(this.x, this.y, this.row, this.column, false);
            String heading1 = cdata.getName();
            this.setHeading(this.x, this.y, heading1, cdata.fieldName, false, pieWithOthers, chart.mData.multiData);
            this.setContent(this.x, this.y, valName, this.rootData.multiData, 0, false);
            if (chart.isSecondaryDataShownInPrimaryTab()) {
                this.setContent(this.x, this.y, chart.colData[chart.valueCol].getName(), chart.mData.multiData, 0, false);
                this.setContent(this.x, this.y, chart.colData[chart.subvalueCol].getName(), chart.mData2.multiData, 1, false);
            } else {
                this.setContent(this.x, this.y, valName, this.rootData.multiData, 0, false);
            }
        }
        this.heightOffset = this.heightPerCell * this.rrow + this.tInterval;
    }

    private void show_series_category2(Chart chart) {
        this.tabPanel = false;
        this.rowOffset = -1;
        ColData cdata = chart.colData[chart.mDataMap[1]];
        ColData cdata2 = chart.colData[chart.mDataMap[0]];
        this.row = chart.mDataLen[0];
        this.column = chart.mDataLen[1] + 1;
        if (!this.isHorizontal) {
            this.column = chart.mDataLen[0];
            this.row = chart.mDataLen[1] + 1;
        }
        String heading1 = cdata2.getName() + "\\" + cdata.getName();
        if (!this.isHorizontal) {
            heading1 = cdata.getName() + "\\" + cdata2.getName();
        }
        this.drawTable(this.x, this.y, this.row, this.column, true);
        this.setHeading(this.x, this.y, heading1, cdata.fieldName, true, false, this.rootData.multiData[0].multiData);
        int d = this.isHorizontal ? this.row : this.column;
        for (int i = 0; i < d; ++i) {
            this.setContent(this.x, this.y, cdata2.fieldName[i].toString(), this.rootData.multiData[i].multiData, i, true);
        }
        this.heightOffset = this.heightPerCell * this.rrow + this.tInterval;
    }

    private void show_series_category(Chart chart) {
        this.tabPanel = false;
        this.rowOffset = -1;
        boolean pieWithOthers = false;
        pieWithOthers = chart.isCircularChart() && chart.getPieGroupOthersLimit() > 0.0;
        int mDataLen0 = chart.mDataLen[0];
        int mDataLen1 = chart.mDataLen[1];
        if (pieWithOthers) {
            --mDataLen0;
        }
        if (this.isHorizontal) {
            this.row = mDataLen0;
            this.column = mDataLen1;
        } else {
            this.row = mDataLen1;
            this.column = mDataLen0;
        }
        ColData cdata = chart.colData[chart.mDataMap[1]];
        ColData cdata2 = chart.colData[chart.mDataMap[0]];
        String heading1 = cdata2.getName() + "\\" + cdata.getName();
        if (!this.isHorizontal) {
            heading1 = cdata.getName() + "\\" + cdata2.getName();
        }
        this.drawTable(this.x, this.y, this.row, this.column, false);
        this.setHeading(this.x, this.y, heading1, cdata.fieldName, false);
        if (chart.getChartType() == 14) {
            int[] axisPos = chart.getAxisPosition();
            for (int i = 0; i < mDataLen0; ++i) {
                this.setContent(this.x, this.y, cdata2.fieldName[i].toString(), this.rootData.multiData[i].multiData, i, false, 0, axisPos[i]);
            }
        } else {
            for (int i = 0; i < mDataLen0; ++i) {
                this.setContent(this.x, this.y, cdata2.fieldName[i].toString(), this.rootData.multiData[i].multiData, i, false);
            }
        }
    }

    private void show_boxData(Chart chart) {
        this.tabPanel = false;
        this.rowOffset = -1;
        ColData cdata = chart.colData[chart.mDataMap[0]];
        if (this.isHorizontal) {
            this.row = 5;
            this.column = chart.mDataLen[0];
            this.drawTable(this.x, this.y, this.row, this.column, false);
            String heading1 = cdata.getName();
            this.setHeading(this.x, this.y, heading1, cdata.fieldName, false);
        } else {
            this.column = 5;
            this.row = chart.mDataLen[0];
            this.drawTable(this.x, this.y, this.row, this.column, false);
            String heading1 = cdata.getName();
            this.setHeading(this.x, this.y, heading1, cdata.fieldName, false);
        }
        this.setContent(this.x, this.y, "MIN", this.rootData.multiData, 0, false, 2);
        this.setContent(this.x, this.y, "25%", this.rootData.multiData, 1, false, 3);
        this.setContent(this.x, this.y, "50%", this.rootData.multiData, 2, false, 4);
        this.setContent(this.x, this.y, "75%", this.rootData.multiData, 3, false, 5);
        this.setContent(this.x, this.y, "MAX", this.rootData.multiData, 4, false, 1);
        this.heightOffset = this.heightPerCell * this.rrow + this.tInterval;
    }

    private void autoAdjustPrepare(String str, int col, int row, int head) {
        FontMetrics fm = this.g.getFontMetrics(QbUtil.resizeViewerFont(head == 0 ? this.headFont : this.cellFont, this.chart.isAdjustFont()));
        int width = fm.stringWidth(this.chart.valueTable.getRunTimeValue(str));
        this.cellMatrix[col][row] = Math.max(this.widthPerCell - 3 * this.cellWidthOffset, width);
        if (this.eWidth[col] < this.cellMatrix[col][row] + 3 * this.cellWidthOffset) {
            this.eWidth[col] = Math.max(this.widthPerCell, this.cellMatrix[col][row] + 3 * this.cellWidthOffset);
        }
    }

    private int calcStringWidth(String str, Font font) {
        FontMetrics fm = this.g.getFontMetrics(QbUtil.resizeViewerFont(font, this.chart.isAdjustFont()));
        return fm.stringWidth(this.chart.valueTable.getRunTimeValue(str));
    }

    private void bestFitCellHeight() {
        FontMetrics fm2;
        int fm2_H;
        FontMetrics fm1 = this.g.getFontMetrics(QbUtil.resizeViewerFont(this.headFont, this.chart.isAdjustFont()));
        int fm1_H = fm1.getMaxAscent() + fm1.getMaxDescent();
        this.tab_height = this.heightPerCell = fm1_H > (fm2_H = (fm2 = this.g.getFontMetrics(QbUtil.resizeViewerFont(this.cellFont, this.chart.isAdjustFont()))).getMaxAscent() + fm2.getMaxDescent()) ? fm1_H : fm2_H;
    }

    public void resizeTableByFontSize() {
        if (this.chart != null && this.chart.tableInPanel) {
            this.paint();
            this.bestFitCellHeight();
        }
    }

    private void autoAdjust() {
        this.cBorder[0] = this.eWidth[0];
        for (int i = 1; i < this.cBorder.length; ++i) {
            this.cBorder[i] = this.isShown(i - 1) ? this.eWidth[i] : 0;
        }
    }

    private void show_Ctab() {
        if (this.rootData.chart.dataDim == 1 && this.chart.isSecondaryDataShownInPrimaryTab()) {
            return;
        }
        int x = this.x;
        int y = this.y;
        if (this.change != 0) {
            return;
        }
        Color c = this.headColor;
        Color unselect = new Color(Math.min(255, c.getRed() + 20), Math.min(255, c.getGreen() + 20), Math.min(255, c.getBlue() + 20));
        Font tmpFont = QbUtil.resizeViewerFont(this.headFont, this.chart.isAdjustFont());
        this.axisTabWidth = this.calcStringWidth("Secondary Axis", tmpFont);
        if (this.axisTabWidth > this.totalLength / 2) {
            this.axisTabWidth = this.totalLength / 2;
        }
        this.drawArea(x, y - this.heightPerCell, x + this.axisTabWidth * 2, y - Math.min(this.framearea.depth, 8));
        this.g.setFont(tmpFont);
        if (this.select_axis == 0) {
            this.g.setColor(this.headColor);
            this.g.fillRect(x, y - this.heightPerCell, this.axisTabWidth, this.heightPerCell);
            this.g.setColor(this.headTextColor);
            this.drawString(this.g, "Primary Axis", x, y - this.heightPerCell, this.axisTabWidth, this.heightPerCell, (short)1);
            this.g.setColor(unselect);
            this.g.fillRect(x + this.axisTabWidth, y - this.heightPerCell, this.axisTabWidth, this.heightPerCell - Math.min(this.framearea.depth, 8));
            this.g.setColor(Color.black);
            this.drawString(this.g, "Secondary Axis", x + this.axisTabWidth, y - this.heightPerCell, this.axisTabWidth, this.heightPerCell - Math.min(this.framearea.depth, 8), (short)1);
            this.g.setColor(Color.black);
            this.g.drawRect(x, y - this.heightPerCell, this.axisTabWidth, this.heightPerCell);
            this.g.drawRect(x + this.axisTabWidth, y - this.heightPerCell, this.axisTabWidth, this.heightPerCell - Math.min(this.framearea.depth, 8));
        } else {
            this.g.setColor(unselect);
            this.g.fillRect(x, y - this.heightPerCell, this.axisTabWidth, this.heightPerCell - Math.min(this.framearea.depth, 8));
            this.g.setColor(Color.black);
            this.drawString(this.g, "Primary Axis", x, y - this.heightPerCell, this.axisTabWidth, this.heightPerCell - Math.min(this.framearea.depth, 8), (short)1);
            this.g.setColor(this.headColor);
            this.g.fillRect(x + this.axisTabWidth, y - this.heightPerCell, this.axisTabWidth, this.heightPerCell);
            this.g.setColor(this.headTextColor);
            this.drawString(this.g, "Secondary Axis", x + this.axisTabWidth, y - this.heightPerCell, this.axisTabWidth, this.heightPerCell, (short)1);
            this.g.setColor(Color.black);
            this.g.drawRect(x, y - this.heightPerCell, this.axisTabWidth, this.heightPerCell - Math.min(this.framearea.depth, 8));
            this.g.drawRect(x + this.axisTabWidth, y - this.heightPerCell, this.axisTabWidth, this.heightPerCell);
        }
    }

    private void show_tab(int len, ColData seriesCol) {
        Color tmpColor = this.g.getColor();
        this.tab_num = len;
        if (this.change != 0) {
            return;
        }
        if (this.tBorder == null || this.tBorder.length != len) {
            this.tBorder = new int[len];
            for (int i = 0; i < len; ++i) {
                this.tBorder[i] = this.tab_width;
            }
        }
        if (!this.dragged) {
            int tabwidth = (int)((float)this.totalLength / (float)len);
            if (tabwidth == 0) {
                boolean tmpdraw = this.draw;
                this.draw = false;
                this.paint();
                this.draw = tmpdraw;
            }
            for (int i = 0; i < len - 1; ++i) {
                this.tBorder[i] = tabwidth;
            }
            this.tBorder[len - 1] = this.totalLength - tabwidth * (len - 1);
        }
        FontMetrics fm = this.g.getFontMetrics(QbUtil.resizeViewerFont(this.headFont, this.chart.isAdjustFont()));
        int tab_length = 0;
        for (int i = 0; i < len; ++i) {
            tab_length += this.tBorder[i];
        }
        this.drawArea(this.x, this.y, tab_length + this.x, this.y + this.tab_height - Math.min(8, this.framearea.depth));
        int currentX = this.x;
        for (int i = 0; i < len; ++i) {
            int j;
            if (i == this.select_tab) {
                this.g.setColor(this.headColor);
                this.g.fillRect(currentX, this.y, this.tBorder[i], this.tab_height);
            } else {
                this.g.setColor(new Color(Math.min(255, this.headColor.getRed() + 20), Math.min(255, this.headColor.getGreen() + 20), Math.min(255, this.headColor.getBlue() + 20)));
                this.g.fillRect(currentX, this.y, this.tBorder[i], this.tab_height - Math.min(8, this.framearea.depth));
            }
            this.g.setColor(Color.black);
            if (i == this.select_tab) {
                this.g.drawRect(currentX, this.y, this.tBorder[i], this.tab_height);
            } else {
                this.g.drawRect(currentX, this.y, this.tBorder[i], this.tab_height - Math.min(8, this.framearea.depth));
            }
            String tab = seriesCol.fieldName[i].toString();
            int w = 0;
            for (j = 0; j < tab.length() && (w += fm.charWidth(tab.charAt(j))) < this.tBorder[i] - this.cellWidthOffset; ++j) {
            }
            tab = tab.substring(0, j);
            this.g.setColor(this.headTextColor);
            this.g.setFont(QbUtil.resizeViewerFont(this.headFont, this.chart.isAdjustFont()));
            if (i == this.select_tab) {
                this.drawString(this.g, tab, currentX, this.y, this.tBorder[i], this.tab_height, this.alignSeriesTitle);
            } else {
                this.drawString(this.g, tab, currentX, this.y, this.tBorder[i], this.tab_height - Math.min(8, this.framearea.depth), this.alignSeriesTitle);
            }
            currentX += this.tBorder[i];
        }
        this.g.setColor(tmpColor);
    }

    private void show_sum_series_category(Chart chart) {
        this.tabPanel = true;
        this.rowOffset = -1;
        this.heightOffset = 0;
        ColData seriesCol = chart.colData[chart.mDataMap[0]];
        int len = this.rootData.multiData.length;
        if (this.isHorizontal) {
            this.row = chart.mDataLen[1];
            this.column = chart.mDataLen[2] + 1;
        } else {
            this.column = chart.mDataLen[1];
            this.row = chart.mDataLen[2] + 1;
        }
        ColData cdata = chart.colData[chart.mDataMap[2]];
        ColData cdata2 = chart.colData[chart.mDataMap[1]];
        this.drawTable(this.x, this.y + this.heightOffset, this.row, this.column, true);
        this.drawArea(this.x, this.y + this.tab_height, this.x + this.totalLength, this.y + this.rrow * this.heightPerCell + this.tab_height);
        this.show_tab(len, seriesCol);
        this.drawGrid();
        String heading1 = cdata2.getName() + "\\" + cdata.getName();
        if (!this.isHorizontal) {
            heading1 = cdata.getName() + "\\" + cdata2.getName();
        }
        Object[] heading2 = cdata.fieldName;
        if (this.isHorizontal) {
            this.setHeading(this.x, this.y + this.heightOffset, heading1, heading2, true, false, this.rootData.multiData[this.select_tab].multiData[0].multiData);
        } else {
            this.setHeading(this.x, this.y, heading1, heading2, true, false, this.rootData.multiData[this.select_tab].multiData[0].multiData);
        }
        if (this.select_tab >= this.rootData.multiData.length) {
            this.select_tab = 0;
        }
        for (int j = 0; j < chart.mDataLen[1]; ++j) {
            this.setContent(this.x, this.y + this.heightOffset, cdata2.fieldName[j].toString(), this.rootData.multiData[this.select_tab].multiData[j].multiData, j, true);
        }
        this.heightOffset = this.rrow * this.heightPerCell + this.tInterval;
    }

    private void show_hilow(Chart chart) {
        this.tabPanel = false;
        this.rowOffset = -1;
        int len = this.rootData.multiData.length;
        int col = 2;
        HiLowMap hilow = chart.hilowCol;
        if (hilow.close >= 0) {
            ++col;
        }
        if (hilow.open >= 0) {
            ++col;
        }
        if (this.isHorizontal) {
            this.column = col;
            this.row = len;
            this.drawTable(this.x, this.y, len, col, false);
        } else {
            this.column = len;
            this.row = col;
            this.drawTable(this.x, this.y, col, len, false);
        }
        Object[] name = new String[col];
        name[0] = chart.colData[hilow.low].getName() + (chart.chartType == 18 ? " (Start)" : " (Low)");
        name[1] = chart.colData[hilow.hi].getName() + (chart.chartType == 18 ? " (End)" : " (High)");
        if (hilow.close >= 0) {
            name[2] = chart.colData[hilow.close].getName() + " (Close)";
        }
        if (hilow.open >= 0) {
            name[3] = chart.colData[hilow.open].getName() + " (Open)";
        }
        this.setHeading(this.x, this.y, "No. / Value", name, false);
        for (int i = 0; i < len; ++i) {
            this.setHiLowRow(this.x, this.y, i, this.rootData.multiData[i].plotData, col);
        }
        this.drawGrid();
    }

    private void setHiLowRow(int x, int y, int row, PlotData pd, int col) {
        int d = 0;
        y += 10;
        if (this.tabPanel) {
            y += this.tab_height;
        }
        String rec = row + 1 + "";
        this.g.setColor(this.headTextColor);
        if (this.isHorizontal) {
            if (this.direction == 2) {
                if (this.change == 0 && this.draw) {
                    this.g.setColor(this.headColor);
                    this.g.fillRect(x + 1, y - 10 + row * this.heightPerCell + this.heightPerCell + 1, this.cBorder[0] - 2, this.heightPerCell - 2);
                    this.g.setColor(this.headTextColor);
                }
                this.autoAdjustPrepare(rec, 0, row + 1, 0);
                if (this.change == 0 && this.draw) {
                    this.g.setFont(QbUtil.resizeViewerFont(this.headFont, this.chart.isAdjustFont()));
                    this.drawString(this.g, rec, x + 1, y - 10 + row * this.heightPerCell + this.heightPerCell + 1, this.cBorder[0] - 2, this.heightPerCell - 2, this.alignPrimTitle);
                }
            } else {
                if (this.change == 0 && this.draw) {
                    this.g.setColor(this.headColor);
                    this.g.fillRect(x + 1, y - 10 + (this.rowOffset + 1) * this.heightPerCell + this.heightPerCell + 1, this.cBorder[0] - 2, this.heightPerCell - 2);
                    this.g.setColor(this.headTextColor);
                }
                this.autoAdjustPrepare(rec, 0, row + 1, 0);
                if (this.change == 0 && this.draw && this.isRowShown(row)) {
                    this.g.setFont(QbUtil.resizeViewerFont(this.headFont, this.chart.isAdjustFont()));
                    this.drawString(this.g, rec, x + 1, y - 10 + (this.rowOffset + 1) * this.heightPerCell + this.heightPerCell + 1, this.cBorder[0] - 2, this.heightPerCell - 2, this.alignPrimTitle);
                }
            }
        } else {
            this.autoAdjustPrepare(rec, row + 1, 0, 0);
            if (this.change == 0 && this.draw) {
                int k;
                if (this.direction == 2 && this.isShown(row)) {
                    d = 0;
                    for (k = 0; k < row + 1; ++k) {
                        d += this.cBorder[k];
                    }
                    this.g.setColor(this.headColor);
                    this.g.fillRect(x + d + 1, y - 10 + 1, this.cBorder[row + 1] - 2, this.heightPerCell - 2);
                    this.g.setColor(this.headTextColor);
                    this.g.setFont(QbUtil.resizeViewerFont(this.headFont, this.chart.isAdjustFont()));
                    this.drawString(this.g, rec, x + d + 1, y - 10 + 1, this.cBorder[row + 1] - 2, this.heightPerCell - 2, this.alignPrimTitle);
                } else if (this.direction == 3) {
                    d = 0;
                    for (k = 0; k < row + 1; ++k) {
                        d += this.cBorder[k];
                    }
                    this.g.setColor(this.headColor);
                    this.g.fillRect(x + d + 1, y - 10 + 1, this.cBorder[row + 1] - 2, this.heightPerCell - 2);
                    this.g.setColor(this.headTextColor);
                    this.g.setFont(QbUtil.resizeViewerFont(this.headFont, this.chart.isAdjustFont()));
                    this.drawString(this.g, rec, x + d + 1, y - 10 + 1, this.cBorder[row + 1] - 2, this.heightPerCell - 2, this.alignPrimTitle);
                }
            }
        }
        int currentX = this.cBorder[0];
        if (pd.isEmpty()) {
            int count = 0;
            for (int i = 0; i < col; ++i) {
                if (this.isHorizontal) {
                    this.autoAdjustPrepare("null", i + 1, row + 1, 1);
                } else {
                    this.autoAdjustPrepare("null", row + 1, i + 1, 1);
                }
                if (this.change == 0 && this.draw && this.direction == 2) {
                    if (this.isHorizontal && this.isShown(i) && this.isRowShown(row)) {
                        this.g.setColor(this.cellColor);
                        this.g.fillRect(x + currentX + 1, y - 10 + row * this.heightPerCell + this.heightPerCell + 1, this.cBorder[i + 1] - 2, this.heightPerCell - 2);
                        this.g.setColor(this.cellTextColor);
                        this.g.setFont(QbUtil.resizeViewerFont(this.cellFont, this.chart.isAdjustFont()));
                        this.drawString(this.g, this.fitSize("null", i + 1), x + currentX + 1, y - 10 + row * this.heightPerCell + this.heightPerCell + 1, this.cBorder[i + 1] - 2, this.heightPerCell - 2, this.alignPrimValue);
                        currentX += this.cBorder[i + 1];
                        continue;
                    }
                    if (this.isHorizontal || !this.isShown(row) || !this.isRowShown(i)) continue;
                    this.g.setColor(this.cellColor);
                    this.g.fillRect(x + d + 1, y - 10 + i * this.heightPerCell + this.heightPerCell + 1, this.cBorder[row + 1] - 2, this.heightPerCell - 2);
                    this.g.setColor(this.cellTextColor);
                    this.g.setFont(QbUtil.resizeViewerFont(this.cellFont, this.chart.isAdjustFont()));
                    this.drawString(this.g, this.fitSize("null", row + 1), x + d + 1, y + i * this.heightPerCell + this.heightPerCell + 1, this.cBorder[row + 1] - 2, this.heightPerCell - 2, this.alignPrimValue);
                    currentX += this.cBorder[row + 1];
                    continue;
                }
                if (this.change != 0 || !this.draw || this.direction != 3) continue;
                if (this.isHorizontal && this.isRowShown(row) && this.isShown(i)) {
                    this.g.setColor(this.cellColor);
                    this.g.fillRect(x + currentX + 1, y - 10 + (this.rowOffset + 1) * this.heightPerCell + this.heightPerCell + 1, this.cBorder[i + 1] - 2, this.heightPerCell - 2);
                    this.g.setColor(this.cellTextColor);
                    this.g.setFont(QbUtil.resizeViewerFont(this.cellFont, this.chart.isAdjustFont()));
                    this.drawString(this.g, this.fitSize("null", i + 1), x + currentX + 1, y - 10 + (this.rowOffset + 1) * this.heightPerCell + this.heightPerCell + 1, this.cBorder[i + 1] - 2, this.heightPerCell - 2, this.alignPrimValue);
                    currentX += this.cBorder[i + 1];
                    continue;
                }
                if (this.isHorizontal || !this.isRowShown(i) || !this.isRowShown(row)) continue;
                this.g.setColor(this.cellColor);
                this.g.fillRect(x + d + 1, y - 10 + count * this.heightPerCell + this.heightPerCell + 1, this.cBorder[row + 1] - 2, this.heightPerCell - 2);
                this.g.setColor(this.cellTextColor);
                this.g.setFont(QbUtil.resizeViewerFont(this.cellFont, this.chart.isAdjustFont()));
                this.drawString(this.g, this.fitSize("null", row + 1), x + d + 1, y - 10 + count * this.heightPerCell + this.heightPerCell + 1, this.cBorder[row + 1] - 2, this.heightPerCell - 2, this.alignPrimValue);
                currentX += this.cBorder[row + 1];
            }
        } else if (pd.element instanceof HiLowData) {
            HiLowData hilow = (HiLowData)pd.element;
            rec = this.chart.chartType != 18 ? this.chart.a_y.formating(hilow.vlow) : this.chart.a_x.formating(hilow.vlow);
            if (this.isHorizontal) {
                this.autoAdjustPrepare(rec, 1, row + 1, 1);
            } else {
                this.autoAdjustPrepare(rec, row + 1, 1, 1);
            }
            if (this.change == 0 && this.draw && this.direction == 2) {
                if (this.isHorizontal && this.isShown(0) && this.isRowShown(row)) {
                    this.g.setColor(this.cellColor);
                    this.g.fillRect(x + currentX + 1, y - 10 + row * this.heightPerCell + this.heightPerCell + 1, this.cBorder[1] - 2, this.heightPerCell - 2);
                    this.g.setColor(this.cellTextColor);
                    this.g.setFont(QbUtil.resizeViewerFont(this.cellFont, this.chart.isAdjustFont()));
                    this.drawString(this.g, this.fitSize(rec, 1), x + currentX + 1, y - 10 + row * this.heightPerCell + this.heightPerCell + 1, this.cBorder[1] - 2, this.heightPerCell - 2, this.alignPrimValue);
                    currentX += this.cBorder[1];
                } else if (!this.isHorizontal && this.isShown(row) && this.isRowShown(0)) {
                    this.g.setColor(this.cellColor);
                    this.g.fillRect(x + d + 1, y - 10 + this.heightPerCell + 1, this.cBorder[row + 1] - 2, this.heightPerCell - 2);
                    this.g.setColor(this.cellTextColor);
                    this.g.setFont(QbUtil.resizeViewerFont(this.cellFont, this.chart.isAdjustFont()));
                    this.drawString(this.g, this.fitSize(rec, row + 1), x + d + 1, y - 10 + this.heightPerCell + 1, this.cBorder[row + 1] - 2, this.heightPerCell - 2, this.alignPrimValue);
                }
            } else if (this.change == 0 && this.draw && this.direction == 3) {
                if (this.isHorizontal && this.isRowShown(row) && this.isShown(0)) {
                    this.g.setColor(this.cellColor);
                    this.g.fillRect(x + currentX + 1, y - 10 + (this.rowOffset + 1) * this.heightPerCell + this.heightPerCell + 1, this.cBorder[1] - 2, this.heightPerCell - 2);
                    this.g.setColor(this.cellTextColor);
                    this.g.setFont(QbUtil.resizeViewerFont(this.cellFont, this.chart.isAdjustFont()));
                    this.drawString(this.g, this.fitSize(rec, 1), x + currentX + 1, y - 10 + (this.rowOffset + 1) * this.heightPerCell + this.heightPerCell + 1, this.cBorder[1] - 2, this.heightPerCell - 2, this.alignPrimValue);
                    currentX += this.cBorder[1];
                } else if (!this.isHorizontal && this.isRowShown(0) && this.isShown(row)) {
                    this.g.setColor(this.cellColor);
                    this.g.fillRect(x + d + 1, y - 10 + this.heightPerCell + 1, this.cBorder[row + 1] - 2, this.heightPerCell - 2);
                    this.g.setColor(this.cellTextColor);
                    this.g.setFont(QbUtil.resizeViewerFont(this.cellFont, this.chart.isAdjustFont()));
                    this.drawString(this.g, this.fitSize(rec, row + 1), x + d + 1, y - 10 + this.heightPerCell + 1, this.cBorder[row + 1] - 2, this.heightPerCell - 2, this.alignPrimValue);
                }
            }
            rec = this.chart.chartType != 18 ? this.chart.a_y.formating(hilow.vhi) : this.chart.a_x.formating(hilow.vhi);
            if (this.isHorizontal) {
                this.autoAdjustPrepare(rec, 2, row + 1, 1);
            } else {
                this.autoAdjustPrepare(rec, row + 1, 2, 1);
            }
            if (this.change == 0 && this.draw && this.direction == 2) {
                if (this.isHorizontal && this.isShown(1) && this.isRowShown(row)) {
                    this.g.setColor(this.cellColor);
                    this.g.fillRect(x + currentX + 1, y - 10 + row * this.heightPerCell + this.heightPerCell + 1, this.cBorder[2] - 2, this.heightPerCell - 2);
                    this.g.setColor(this.cellTextColor);
                    this.g.setFont(QbUtil.resizeViewerFont(this.cellFont, this.chart.isAdjustFont()));
                    this.drawString(this.g, this.fitSize(rec, 2), x + currentX + 1, y - 10 + row * this.heightPerCell + this.heightPerCell + 1, this.cBorder[2] - 2, this.heightPerCell - 2, this.alignPrimValue);
                    currentX += this.cBorder[2];
                } else if (!this.isHorizontal && this.isShown(row) && this.isRowShown(1)) {
                    this.g.setColor(this.cellColor);
                    this.g.fillRect(x + d + 1, y - 10 + 2 * this.heightPerCell + 1, this.cBorder[row + 1] - 2, this.heightPerCell - 2);
                    this.g.setColor(this.cellTextColor);
                    this.g.setFont(QbUtil.resizeViewerFont(this.cellFont, this.chart.isAdjustFont()));
                    this.drawString(this.g, this.fitSize(rec, row + 1), x + d + 1, y - 10 + this.heightPerCell * 2 + 1, this.cBorder[row + 1] - 2, this.heightPerCell - 2, this.alignPrimValue);
                }
            } else if (this.change == 0 && this.draw && this.direction == 3) {
                if (this.isHorizontal && this.isRowShown(row) && this.isShown(1)) {
                    this.g.setColor(this.cellColor);
                    this.g.fillRect(x + currentX + 1, y - 10 + (this.rowOffset + 1) * this.heightPerCell + this.heightPerCell + 1, this.cBorder[2] - 2, this.heightPerCell - 2);
                    this.g.setColor(this.cellTextColor);
                    this.g.setFont(QbUtil.resizeViewerFont(this.cellFont, this.chart.isAdjustFont()));
                    this.drawString(this.g, this.fitSize(rec, 2), x + currentX + 1, y - 10 + (this.rowOffset + 1) * this.heightPerCell + this.heightPerCell + 1, this.cBorder[2] - 2, this.heightPerCell - 2, this.alignPrimValue);
                    currentX += this.cBorder[2];
                } else if (!this.isHorizontal && this.isRowShown(1) && this.isShown(row)) {
                    this.g.setColor(this.cellColor);
                    this.g.fillRect(x + d + 1, y - 10 + this.heightPerCell * 2 + 1, this.cBorder[row + 1] - 2, this.heightPerCell - 2);
                    this.g.setColor(this.cellTextColor);
                    this.g.setFont(QbUtil.resizeViewerFont(this.cellFont, this.chart.isAdjustFont()));
                    this.drawString(this.g, this.fitSize(rec, row + 1), x + d + 1, y - 10 + this.heightPerCell * 2 + 1, this.cBorder[row + 1] - 2, this.heightPerCell - 2, this.alignPrimValue);
                }
            }
            if (col >= 3) {
                rec = this.chart.a_y.formating(hilow.vclose);
                if (this.isHorizontal) {
                    this.autoAdjustPrepare(rec, 3, row + 1, 1);
                } else {
                    this.autoAdjustPrepare(rec, row + 1, 3, 1);
                }
                if (this.change == 0 && this.draw && this.direction == 2) {
                    if (this.isHorizontal && this.isShown(2) && this.isRowShown(row)) {
                        this.g.setColor(this.cellColor);
                        this.g.fillRect(x + currentX + 1, y - 10 + row * this.heightPerCell + this.heightPerCell + 1, this.cBorder[3] - 2, this.heightPerCell - 2);
                        this.g.setColor(this.cellTextColor);
                        this.g.setFont(QbUtil.resizeViewerFont(this.cellFont, this.chart.isAdjustFont()));
                        this.drawString(this.g, this.fitSize(rec, 3), x + currentX + 1, y - 10 + row * this.heightPerCell + this.heightPerCell + 1, this.cBorder[3] - 2, this.heightPerCell - 2, this.alignPrimValue);
                        currentX += this.cBorder[3];
                    } else if (!this.isHorizontal && this.isShown(row) && this.isRowShown(2)) {
                        this.g.setColor(this.cellColor);
                        this.g.fillRect(x + d + 1, y - 10 + 3 * this.heightPerCell + 1, this.cBorder[row + 1] - 2, this.heightPerCell - 2);
                        this.g.setColor(this.cellTextColor);
                        this.g.setFont(QbUtil.resizeViewerFont(this.cellFont, this.chart.isAdjustFont()));
                        this.drawString(this.g, this.fitSize(rec, row + 1), x + d + 1, y - 10 + this.heightPerCell * 3 + 1, this.cBorder[row + 1] - 2, this.heightPerCell - 2, this.alignPrimValue);
                    }
                } else if (this.change == 0 && this.draw && this.direction == 3) {
                    if (this.isHorizontal && this.isRowShown(row) && this.isShown(2)) {
                        this.g.setColor(this.cellColor);
                        this.g.fillRect(x + currentX + 1, y - 10 + (this.rowOffset + 1) * this.heightPerCell + this.heightPerCell + 1, this.cBorder[3] - 2, this.heightPerCell - 2);
                        this.g.setColor(this.cellTextColor);
                        this.g.setFont(QbUtil.resizeViewerFont(this.cellFont, this.chart.isAdjustFont()));
                        this.drawString(this.g, this.fitSize(rec, 3), x + currentX + 1, y - 10 + (this.rowOffset + 1) * this.heightPerCell + this.heightPerCell + 1, this.cBorder[3] - 2, this.heightPerCell - 2, this.alignPrimValue);
                        currentX += this.cBorder[3];
                    } else if (!this.isHorizontal && this.isRowShown(2) && this.isShown(row)) {
                        this.g.setColor(this.cellColor);
                        this.g.fillRect(x + d + 1, y - 10 + this.heightPerCell * 3 + 1, this.cBorder[row + 1] - 2, this.heightPerCell - 2);
                        this.g.setColor(this.cellTextColor);
                        this.g.setFont(QbUtil.resizeViewerFont(this.cellFont, this.chart.isAdjustFont()));
                        this.drawString(this.g, this.fitSize(rec, row + 1), x + d + 1, y - 10 + this.heightPerCell * 3 + 1, this.cBorder[row + 1] - 2, this.heightPerCell - 2, this.alignPrimValue);
                    }
                }
                if (col >= 4) {
                    rec = this.chart.a_y.formating(hilow.vopen);
                    if (this.isHorizontal) {
                        this.autoAdjustPrepare(rec, 4, row + 1, 1);
                    } else {
                        this.autoAdjustPrepare(rec, row + 1, 4, 1);
                    }
                    if (this.change == 0 && this.draw && this.direction == 2) {
                        if (this.isHorizontal && this.isShown(3) && this.isRowShown(row)) {
                            this.g.setColor(this.cellColor);
                            this.g.fillRect(x + currentX + 1, y - 10 + row * this.heightPerCell + this.heightPerCell + 1, this.cBorder[4] - 2, this.heightPerCell - 2);
                            this.g.setColor(this.cellTextColor);
                            this.g.setFont(QbUtil.resizeViewerFont(this.cellFont, this.chart.isAdjustFont()));
                            this.drawString(this.g, this.fitSize(rec, 4), x + currentX + 1, y - 10 + row * this.heightPerCell + this.heightPerCell + 1, this.cBorder[4] - 2, this.heightPerCell - 2, this.alignPrimValue);
                        } else if (!this.isHorizontal && this.isShown(row) && this.isRowShown(3)) {
                            this.g.setColor(this.cellColor);
                            this.g.fillRect(x + d + 1, y - 10 + 4 * this.heightPerCell + 1, this.cBorder[row + 1] - 2, this.heightPerCell - 2);
                            this.g.setColor(this.cellTextColor);
                            this.g.setFont(QbUtil.resizeViewerFont(this.cellFont, this.chart.isAdjustFont()));
                            this.drawString(this.g, this.fitSize(rec, row + 1), x + d + 1, y - 10 + 4 * this.heightPerCell + 1, this.cBorder[row + 1] - 2, this.heightPerCell - 2, this.alignPrimValue);
                        }
                    } else if (this.change == 0 && this.draw && this.direction == 3) {
                        if (this.isHorizontal && this.isRowShown(row) && this.isShown(3)) {
                            this.g.setColor(this.cellColor);
                            this.g.fillRect(x + currentX + 1, y - 10 + (this.rowOffset + 1) * this.heightPerCell + this.heightPerCell + 1, this.cBorder[4] - 2, this.heightPerCell - 2);
                            this.g.setColor(this.cellTextColor);
                            this.g.setFont(QbUtil.resizeViewerFont(this.cellFont, this.chart.isAdjustFont()));
                            this.drawString(this.g, this.fitSize(rec, 4), x + currentX + 1, y - 10 + (this.rowOffset + 1) * this.heightPerCell + this.heightPerCell + 1, this.cBorder[4] - 2, this.heightPerCell - 2, this.alignPrimValue);
                        } else if (!this.isHorizontal && this.isRowShown(3) && this.isShown(row)) {
                            this.g.setColor(this.cellColor);
                            this.g.fillRect(x + d + 1, y - 10 + this.heightPerCell * 4 + 1, this.cBorder[row + 1] - 2, this.heightPerCell - 2);
                            this.g.setColor(this.cellTextColor);
                            this.g.setFont(QbUtil.resizeViewerFont(this.cellFont, this.chart.isAdjustFont()));
                            this.drawString(this.g, this.fitSize(rec, row + 1), x + d + 1, y - 10 + this.heightPerCell * 4 + 1, this.cBorder[row + 1] - 2, this.heightPerCell - 2, this.alignPrimValue);
                        }
                    }
                }
            }
        }
        if (this.direction == 2 && !this.isHorizontal && this.isShown(row)) {
            ++this.rowOffset;
        }
        if (this.direction == 3 && this.isHorizontal && this.isRowShown(row)) {
            ++this.rowOffset;
        }
    }

    private void show_series_hilow(Chart chart) {
        this.tabPanel = true;
        this.rowOffset = -1;
        int len = this.rootData.multiData.length;
        int col = 2;
        HiLowMap hilow = chart.hilowCol;
        if (hilow.close >= 0) {
            ++col;
        }
        if (hilow.open >= 0) {
            ++col;
        }
        ColData seriesCol = chart.colData[chart.mDataMap[0]];
        Object[] name = new String[col];
        name[0] = chart.colData[hilow.low].getName() + (chart.chartType == 18 ? " (Start)" : " (Low)");
        name[1] = chart.colData[hilow.hi].getName() + (chart.chartType == 18 ? " (End)" : " (High)");
        int k = 2;
        if (hilow.close >= 0) {
            name[k++] = chart.colData[hilow.close].getName() + " (Close)";
        }
        if (hilow.open >= 0) {
            name[k] = chart.colData[hilow.open].getName() + " (Open)";
        }
        int len2 = this.rootData.multiData[this.select_tab].multiData.length;
        int tmpLen2 = chart.axis[1].ticker.getOriginalTickerLabels(true).length;
        if (tmpLen2 < len2) {
            len2 = tmpLen2;
        }
        if (this.isHorizontal) {
            this.column = col;
            this.row = len2;
        } else {
            this.row = col;
            this.column = len2;
        }
        if (this.isHorizontal) {
            this.drawTable(this.x, this.y, len2, col, false);
        } else {
            this.drawTable(this.x, this.y, col, len2, false);
        }
        this.drawArea(this.x, this.y + this.tab_height, this.x + this.totalLength, this.y + this.rrow * this.heightPerCell + this.tab_height);
        this.show_tab(len, seriesCol);
        if (this.isHorizontal) {
            this.setHeading(this.x, this.y, "No. / Values", name, false);
        } else {
            this.setHeading(this.x, this.y, "Values / No.", name, false);
        }
        for (int j = 0; j < len2; ++j) {
            this.setHiLowRow(this.x, this.y, j, this.rootData.multiData[this.select_tab].multiData[j].plotData, col);
        }
        this.drawGrid();
    }

    public int atCBorder(int mx, int my) {
        if (this.cBorder == null) {
            return -1;
        }
        int x = this.x;
        int y = this.y;
        if (this.tabPanel) {
            y += this.tab_height;
        }
        for (int i = 0; i < this.column + 1; ++i) {
            if (Math.abs((x += this.cBorder[i]) - mx) >= 2 || my <= y + this.heightPerCell || my >= y + this.getHeight() - this.tInterval) continue;
            return i;
        }
        return -1;
    }

    public int atTBorder(int mx, int my) {
        if (!this.tabPanel || this.tBorder == null) {
            return -1;
        }
        int x = this.x;
        int y = this.y;
        for (int i = 0; i < this.tab_num; ++i) {
            if (Math.abs((x += this.tBorder[i]) - mx) >= 2 || y >= my || my >= y + this.tab_height) continue;
            return i;
        }
        return -1;
    }

    public boolean atHead(int mx, int my) {
        int x = this.x;
        int y = this.y;
        if (this.tabPanel) {
            y += this.tab_height;
        }
        return mx > x && mx < x + this.getWidth() && my > y && my < y + this.heightPerCell || mx > x && mx < x + this.cBorder[0] && my > y && my < y + this.rrow * this.heightPerCell;
    }

    public int atAxisTab(int mx, int my) {
        if (this.chart.dataDim == 1 && this.chart.isSecondaryDataShownInPrimaryTab()) {
            return -1;
        }
        int x = this.x;
        int y = this.y;
        if (mx > x && mx < x + this.axisTabWidth && my < y && my > y - this.heightPerCell) {
            return 0;
        }
        if (mx > x + this.axisTabWidth && mx < x + this.axisTabWidth * 2 && my < y && my > y - this.heightPerCell) {
            return 1;
        }
        return -1;
    }

    public int atSeriesTab(int mx, int my) {
        if (this.tBorder == null) {
            return -1;
        }
        int x = this.x;
        int y = this.y;
        int currentX = x;
        for (int i = 0; i < this.tab_num; ++i) {
            if (mx > currentX && mx < currentX + this.tBorder[i] && my > y && my < y + this.tab_height) {
                return i;
            }
            currentX += this.tBorder[i];
        }
        return -1;
    }

    public void selectItem(int mx, int my) {
        int dy = this.y;
        if (this.tabPanel) {
            dy += this.tab_height;
        }
        if (mx > this.x + this.cBorder[0] && my > dy + this.heightPerCell) {
            int i;
            int currentX = this.cBorder[0] + this.x;
            for (i = 0; i < this.column; ++i) {
                if (mx >= (currentX += this.cBorder[i + 1])) continue;
                currentX -= this.cBorder[i + 1];
                break;
            }
            int row = (my - dy) / this.heightPerCell;
            if ((row = Math.min(row, this.maxRow - 1)) >= this.cellMatrix[i + 1].length) {
                return;
            }
            int charWidth = this.cellMatrix[i + 1][row];
            this.select = this.withinText(mx, charWidth + this.cellWidthOffset, currentX, this.cBorder[i + 1], i + 1, row) ? 3 : 1;
        } else if (my < dy + this.heightPerCell) {
            int charWidth;
            int i;
            int currentX = this.x;
            for (i = 0; i < this.column + 1; ++i) {
                if (mx >= (currentX += this.cBorder[i])) continue;
                currentX -= this.cBorder[i];
                break;
            }
            this.select = this.withinText(mx, (charWidth = this.cellMatrix[i][0]) + this.cellWidthOffset, currentX, this.cBorder[i], i, 0) ? 2 : 0;
        } else {
            int row = (my - dy) / this.heightPerCell;
            if (row >= this.cellMatrix[0].length) {
                return;
            }
            int charWidth = this.cellMatrix[0][row];
            this.select = this.withinText(mx, charWidth + this.cellWidthOffset, this.x, this.cBorder[0], 0, row) ? 2 : 0;
        }
    }

    public static void saveTable(Chart chart, DataOutput out) throws IOException {
        int ry;
        int rx;
        if (!chart.showTable()) {
            return;
        }
        out.writeInt(chart.gt.direction);
        out.writeBoolean(chart.gt.isHorizontal);
        IOUtil2.writeArea(out, chart.gt.framearea);
        out.writeInt(chart.gt.framearea.appearance);
        out.writeInt(chart.gt.framearea.depth);
        out.writeShort(chart.gt.alignCatTitle);
        out.writeShort(chart.gt.alignCatValue);
        out.writeShort(chart.gt.alignSeriesTitle);
        out.writeShort(chart.gt.alignSeriesValue);
        out.writeShort(chart.gt.alignPrimTitle);
        out.writeShort(chart.gt.alignPrimValue);
        out.writeShort(chart.gt.alignSecTitle);
        out.writeShort(chart.gt.alignSecValue);
        if (chart.gt.direction == 3) {
            rx = chart.gt.x - (int)((float)chart.winWidth * (chart.chart_XProp + chart.chart_widthProp));
            ry = chart.gt.y - (int)((float)chart.winHeight * chart.chart_YProp);
        } else {
            rx = chart.gt.x - (int)((float)chart.winWidth * chart.chart_XProp);
            ry = chart.gt.y - (int)((float)chart.winHeight * (chart.chart_YProp + chart.chart_heightProp));
        }
        out.writeInt(rx);
        out.writeInt(ry);
        out.writeInt(chart.gt.select_axis);
        out.writeInt(chart.gt.totalLength);
        out.writeInt(chart.gt.rrow * chart.gt.heightPerCell);
        out.writeInt(chart.gt.widthPerCell);
        out.writeInt(chart.gt.heightPerCell);
        out.writeInt(chart.gt.cellWidthOffset);
        out.writeInt(chart.gt.cellHeightOffset);
        out.writeInt(chart.gt.tab_width);
        out.writeInt(chart.gt.tab_height);
        out.writeInt(chart.gt.select_tab);
        out.writeInt(chart.gt.tInterval);
        out.writeInt(chart.gt.tab_num);
        out.writeInt(chart.gt.tmplen);
        IOUtil.writeColor(out, chart.gt.headColor);
        IOUtil.writeColor(out, chart.gt.cellColor);
        IOUtil.writeColor(out, chart.gt.headTextColor);
        IOUtil.writeColor(out, chart.gt.cellTextColor);
        IOUtil.writeFont(out, chart.gt.headFont);
        IOUtil.writeFont(out, chart.gt.cellFont);
        out.writeInt(chart.gt.cBorder == null ? 0 : chart.gt.cBorder.length);
        out.writeInt(chart.gt.row);
        out.writeInt(chart.gt.rrow);
        out.writeInt(chart.aTCX);
        out.writeInt(chart.aTCY);
        if (chart.gt.cBorder != null) {
            for (int element : chart.gt.cBorder) {
                out.writeInt(element);
            }
        }
        boolean tp = chart.gt.tabPanel;
        out.writeBoolean(tp);
        if (tp) {
            out.writeInt(chart.gt.tBorder.length);
            for (int element : chart.gt.tBorder) {
                out.writeInt(element);
            }
        }
        for (int i = 0; i < chart.gt.column + 1; ++i) {
            for (int j = 0; j < chart.gt.row + 1; ++j) {
                out.writeInt(chart.gt.cellMatrix[i][j]);
            }
        }
        ((VersioningDataOutput)out).writeBoolean(chart.gt.isShowColorSymbols(), (short)6602);
    }

    public static void loadTable(DataInput in, int version, Chart chart, boolean isUTFString, boolean istemplate) throws IOException {
        chart.gt.direction = in.readInt();
        chart.gt.isHorizontal = in.readBoolean();
        chart.farea = IOUtil2.readArea(in, version, chart);
        chart.farea.appearance = in.readInt();
        chart.farea.depth = in.readInt();
        short alignCatTitle = chart.gt.alignCatTitle;
        short alignCatValue = chart.gt.alignCatValue;
        short alignSeriesTitle = chart.gt.alignSeriesTitle;
        short alignSeriesValue = chart.gt.alignSeriesValue;
        short alignPrimTitle = chart.gt.alignPrimTitle;
        short alignPrimValue = chart.gt.alignPrimValue;
        short alignSecTitle = chart.gt.alignSecTitle;
        short alignSecValue = chart.gt.alignSecValue;
        if (version >= 311 || version >= 287 && version <= 300) {
            alignCatTitle = in.readShort();
            alignCatValue = in.readShort();
            alignSeriesTitle = in.readShort();
            alignSeriesValue = in.readShort();
            alignPrimTitle = in.readShort();
            alignPrimValue = in.readShort();
            alignSecTitle = in.readShort();
            alignSecValue = in.readShort();
        }
        int rx = in.readInt();
        int ry = in.readInt();
        if (chart.gt.direction == 2) {
            rx += (int)((float)chart.winWidth * chart.chart_XProp);
            ry += (int)((float)chart.winHeight * (chart.chart_YProp + chart.chart_heightProp));
        } else {
            rx += (int)((float)chart.winWidth * (chart.chart_XProp + chart.chart_widthProp));
            ry += (int)((float)chart.winHeight * chart.chart_YProp);
        }
        int select_axis = in.readInt();
        chart.gt.totalLength = in.readInt();
        chart.gt.tableWidth = chart.gt.totalLength + chart.gt.tInterval;
        chart.gt.tableHeight = in.readInt() + chart.gt.tInterval;
        int tw = chart.gt.tableWidth;
        int th = chart.gt.tableHeight;
        MultiDimData mData = chart.showLegend2() && select_axis != 0 ? chart.mData2 : chart.mData;
        chart.gt = new GraphicsTable(chart, mData, rx, ry, chart.winWidth, chart.winHeight, chart.gt.direction, chart.gt.isHorizontal, chart.farea);
        chart.gt.alignCatTitle = alignCatTitle;
        chart.gt.alignCatValue = alignCatValue;
        chart.gt.alignSeriesTitle = alignSeriesTitle;
        chart.gt.alignSeriesValue = alignSeriesValue;
        chart.gt.alignPrimTitle = alignPrimTitle;
        chart.gt.alignPrimValue = alignPrimValue;
        chart.gt.alignSecTitle = alignSecTitle;
        chart.gt.alignSecValue = alignSecValue;
        chart.gt.select_axis = select_axis;
        chart.gt.widthPerCell = in.readInt();
        chart.gt.heightPerCell = in.readInt();
        chart.gt.cellWidthOffset = in.readInt();
        chart.gt.cellHeightOffset = in.readInt();
        chart.gt.tab_width = in.readInt();
        chart.gt.tab_height = in.readInt();
        chart.gt.select_tab = in.readInt();
        chart.gt.tInterval = in.readInt();
        chart.gt.tab_num = in.readInt();
        chart.gt.tmplen = in.readInt();
        if (version < 115) {
            in.readInt();
            in.readInt();
            in.readInt();
            in.readBoolean();
        }
        chart.gt.headColor = IOUtil.readColor(in);
        chart.gt.cellColor = IOUtil.readColor(in);
        chart.gt.headTextColor = IOUtil.readColor(in);
        chart.gt.cellTextColor = IOUtil.readColor(in);
        chart.gt.headFont = IOUtil.readFont(in, isUTFString);
        chart.gt.cellFont = IOUtil.readFont(in, isUTFString);
        int size = in.readInt();
        chart.gt.column = size - 1;
        chart.gt.row = in.readInt();
        chart.gt.rrow = in.readInt();
        if (!istemplate) {
            int i;
            chart.aTCX = in.readInt();
            chart.aTCY = in.readInt();
            chart.gt.cBorder = new int[size];
            chart.gt.eWidth = new int[size];
            chart.gt.cellMatrix = new int[size][chart.gt.row + 1];
            for (i = 0; i < size; ++i) {
                chart.gt.cBorder[i] = in.readInt();
            }
            chart.gt.tabPanel = in.readBoolean();
            if (chart.gt.tabPanel) {
                size = in.readInt();
                chart.gt.tBorder = new int[size];
                for (i = 0; i < size; ++i) {
                    chart.gt.tBorder[i] = in.readInt();
                }
            }
            for (i = 0; i < chart.gt.column + 1; ++i) {
                for (int j = 0; j < chart.gt.row + 1; ++j) {
                    chart.gt.cellMatrix[i][j] = in.readInt();
                }
            }
        } else {
            int i;
            in.readInt();
            in.readInt();
            for (int i2 = 0; i2 < size; ++i2) {
                in.readInt();
            }
            boolean readTab = in.readBoolean();
            if (readTab) {
                size = in.readInt();
                for (i = 0; i < size; ++i) {
                    in.readInt();
                }
            }
            for (i = 0; i < chart.gt.column + 1; ++i) {
                for (int j = 0; j < chart.gt.row + 1; ++j) {
                    in.readInt();
                }
            }
            chart.gt.cBorder = null;
        }
        if (istemplate) {
            chart.gt.clear();
            if (chart.gt.direction == 2) {
                chart.gt.tableHeight = th;
            } else {
                chart.gt.tableWidth = tw;
            }
        }
        chart.gt.firstShown = false;
        chart.gt.clear = false;
        if (version >= 6602) {
            chart.gt.setShowColorSymbols(in.readBoolean());
        } else {
            chart.gt.setShowColorSymbols(false);
        }
    }

    public static void loadDummyTable(DataInput in, int version, Chart chart, boolean isUTFString) throws IOException {
        int i;
        int c;
        in.readInt();
        in.readBoolean();
        IOUtil2.readArea(in, version, chart);
        in.readInt();
        in.readInt();
        if (version >= 311 || version >= 287 && version <= 300) {
            for (c = 0; c < 8; ++c) {
                in.readShort();
            }
        }
        for (c = 0; c < 15; ++c) {
            in.readInt();
        }
        if (version < 115) {
            in.readInt();
            in.readInt();
            in.readInt();
            in.readBoolean();
        }
        IOUtil.readColor(in);
        IOUtil.readColor(in);
        IOUtil.readColor(in);
        IOUtil.readColor(in);
        IOUtil.readFont(in, isUTFString);
        IOUtil.readFont(in, isUTFString);
        int size = in.readInt();
        int row = in.readInt();
        in.readInt();
        in.readInt();
        in.readInt();
        for (int i2 = 0; i2 < size; ++i2) {
            in.readInt();
        }
        boolean readTab = in.readBoolean();
        if (readTab) {
            size = in.readInt();
            for (i = 0; i < size; ++i) {
                in.readInt();
            }
        }
        for (i = 0; i < size; ++i) {
            for (int j = 0; j < row + 1; ++j) {
                in.readInt();
            }
        }
    }

    public void setVisible(Chart chart, boolean state) {
        if (state) {
            this.addTable(chart);
        } else {
            this.removeTable();
        }
    }

    private void addTable(Chart chart) {
        this.chart = chart;
        if (chart.showTable()) {
            return;
        }
        if (this.clear) {
            MultiDimData root = chart.showLegend2() && this.select_axis != 0 ? chart.mData2 : chart.mData;
            this.draw = false;
            if (this.x == -1 && this.y == -1) {
                this.keepPosition = false;
            }
            if (chart.winWidth == 0 && chart.winHeight == 0) {
                chart.winWidth = chart.component.getSize().width;
                chart.winHeight = chart.component.getSize().height;
            }
            this.paint(chart, root, chart.g, this.x, this.y, chart.winWidth, chart.winHeight, this.direction, this.isHorizontal, chart.farea, chart.cgraphics);
            this.draw = true;
        }
        chart.tableInPanel = true;
        GraphicsTable.shiftWithTable(chart);
    }

    private void removeTable() {
        if (this.chart.showTable()) {
            GraphicsTable.shiftWithoutTable(this.chart);
            this.chart.tableInPanel = false;
            this.tableHeight = 0;
            this.tableWidth = 0;
        }
    }

    private static void shiftWithTable(Chart chart) {
        int dy;
        chart.gt.draw = false;
        chart.gt.firstShown = true;
        chart.gt.paint();
        chart.gt.draw = true;
        int dx = chart.gt.direction == 2 ? 0 : chart.gt.getWidth();
        int n = dy = chart.gt.direction == 3 ? 0 : chart.gt.getHeight();
        if (!chart.showTable()) {
            dy = 0;
            dx = 0;
        }
        int oldx = chart.gt.tableWidth;
        int oldy = chart.gt.tableHeight;
        chart.chart_XProp = (float)chart.winWidth * chart.chart_XProp / (float)(chart.winWidth - oldx + dx);
        chart.chart_YProp = (float)chart.winHeight * chart.chart_YProp / (float)(chart.winHeight - oldy + dy);
        chart.chart_widthProp = (float)chart.winWidth * chart.chart_widthProp / (float)(chart.winWidth - oldx + dx);
        chart.chart_heightProp = (float)chart.winHeight * chart.chart_heightProp / (float)(chart.winHeight - oldy + dy);
        chart.legend_XProp = (float)chart.winWidth * chart.legend_XProp / (float)(chart.winWidth - oldx + dx);
        chart.legend_YProp = 1.0f - (float)chart.winHeight * (1.0f - chart.legend_YProp) / (float)(chart.winHeight - oldy + dy);
        chart.legend2_XProp = (float)chart.winWidth * chart.legend2_XProp / (float)(chart.winWidth - oldx + dx);
        chart.legend2_YProp = 1.0f - (float)chart.winHeight * (1.0f - chart.legend2_YProp) / (float)(chart.winHeight - oldy + dy);
        for (int i = 0; i < chart.stringList.size(); ++i) {
            PropCString pcs = (PropCString)chart.stringList.elementAt(i);
            pcs.xprop = (float)chart.winWidth * pcs.xprop / (float)(chart.winWidth - oldx + dx);
            pcs.yprop = (float)chart.winHeight * pcs.yprop / (float)(chart.winHeight - oldy + dy);
            chart.stringList.removeElementAt(i);
            chart.stringList.insertElementAt(pcs, i);
        }
        Vector<IAnnotation> annV = chart.getAnnotations();
        if (annV != null) {
            for (int i = 0; i < annV.size(); ++i) {
                CAnnotation ca = (CAnnotation)annV.elementAt(i);
                ca.relativePos.x *= (float)chart.winWidth / (float)(chart.winWidth - oldx + dx);
                ca.relativePos.y *= (float)chart.winHeight / (float)(chart.winHeight - oldy + dy);
                ca.pos.x *= (float)chart.winWidth / (float)(chart.winWidth - oldx + dx);
                ca.pos.y *= (float)chart.winHeight / (float)(chart.winHeight - oldy + dy);
            }
        }
        chart.title_XProp *= (float)chart.winWidth / (float)(chart.winWidth - oldx + dx);
        if (dx - oldx > 0) {
            chart.winWidth += dx - oldx;
        }
        if (dy - oldy > 0) {
            chart.winHeight += dy - oldy;
        }
        if (chart.component instanceof Panel) {
            ((Panel)chart.component).setSize(chart.winWidth, chart.winHeight);
        }
        chart.gt.width = chart.winWidth;
        chart.gt.height = chart.winHeight;
        chart.gt.shift = true;
    }

    public static void shiftWithoutTable(Chart chart) {
        if (chart.showTable()) {
            chart.gt.draw = false;
            chart.gt.firstShown = true;
            chart.gt.paint();
            chart.gt.draw = true;
            GraphicsTable.recoverTableSize(chart);
        }
        int origWinWidth = chart.winWidth;
        int origWinHeight = chart.winHeight;
        float chartWidth = chart.chart_widthProp * (float)chart.winWidth;
        float chartHeight = chart.chart_heightProp * (float)chart.winHeight;
        chart.chart_heightProp = 0.7f;
        chart.chart_widthProp = 0.7f;
        chart.chart_XProp = 0.05f;
        chart.chart_YProp = 0.1f;
        chart.winWidth = (int)(chartWidth / chart.chart_widthProp);
        chart.winHeight = (int)(chartHeight / chart.chart_heightProp);
        chart.legend_XProp = (float)origWinWidth * chart.legend_XProp / (float)chart.winWidth;
        chart.legend_YProp = 1.0f - (float)origWinHeight * (1.0f - chart.legend_YProp) / (float)chart.winHeight;
        chart.legend2_XProp = (float)origWinWidth * chart.legend2_XProp / (float)chart.winWidth;
        chart.legend2_YProp = 1.0f - (float)origWinHeight * (1.0f - chart.legend2_YProp) / (float)chart.winHeight;
        for (int i = 0; i < chart.stringList.size(); ++i) {
            PropCString pcs = (PropCString)chart.stringList.elementAt(i);
            pcs.xprop = (float)origWinWidth * pcs.xprop / (float)chart.winWidth;
            pcs.yprop = (float)origWinHeight * pcs.yprop / (float)chart.winHeight;
            chart.stringList.removeElementAt(i);
            chart.stringList.insertElementAt(pcs, i);
        }
        Vector<IAnnotation> annV = chart.getAnnotations();
        if (annV != null) {
            for (int i = 0; i < annV.size(); ++i) {
                CAnnotation ca = (CAnnotation)annV.elementAt(i);
                ca.relativePos.x *= (float)origWinWidth / (float)chart.winWidth;
                ca.relativePos.y *= (float)origWinHeight / (float)chart.winHeight;
                ca.pos.x *= (float)origWinWidth / (float)chart.winWidth;
                ca.pos.y *= (float)origWinHeight / (float)chart.winHeight;
            }
        }
        chart.title_XProp *= (float)origWinWidth / (float)chart.winWidth;
        if (chart.component instanceof Panel) {
            ((Panel)chart.component).setSize(chart.winWidth, chart.winHeight);
        }
        chart.gt.width = chart.winWidth;
        chart.gt.height = chart.winHeight;
        chart.gt.shift = true;
    }

    public static void recoverTableSize(Chart pChart) {
        if (!pChart.showTable()) {
            return;
        }
        if (pChart.gt.direction == 2) {
            pChart.gt.tableHeight = pChart.gt.rrow * pChart.gt.heightPerCell + pChart.gt.tInterval;
            pChart.gt.tableWidth = 0;
        } else {
            pChart.gt.tableWidth = pChart.gt.totalLength + pChart.gt.tInterval;
            pChart.gt.tableHeight = 0;
        }
    }

    private void drawString(Graphics g, String str, int x, int y, int w, int h, short align) {
        this.drawString(g, str, x, y, w, h, align, false, null, -1);
    }

    private void drawString(Graphics g, String str, int x, int y, int w, int h, short align, boolean drawColorSymbol, MultiDimData mdData, int mdDataIndex) {
        CString.setOutsidePlotAreaText(true);
        this.drawText(g, str, g.getFont(), x, y, w, h, align, drawColorSymbol, mdData, mdDataIndex);
        CString.setOutsidePlotAreaText(false);
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDefaultCellWidth(int wpc) {
        this.widthPerCell = wpc;
    }

    public int getDefaultCellWidth() {
        return this.widthPerCell;
    }

    public void setDefaultCellHeight(int hpc) {
        this.heightPerCell = hpc;
    }

    public int getDefaultCellHeight() {
        return this.heightPerCell;
    }

    public Point getLocation() {
        return new Point(this.x, this.y);
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public void setShownHead(boolean isShown) {
        this.isShownHead = isShown;
    }

    public boolean getShownHead() {
        return this.isShownHead;
    }

    public void setHeadBackgroundColor(Color color) {
        this.headColor = color;
    }

    public Color getHeadBackgroundColor() {
        return this.headColor;
    }

    public void setCellBackgroundColor(Color color) {
        this.cellColor = color;
    }

    public Color getCellBackgroundColor() {
        return this.cellColor;
    }

    public void setHeadTextColor(Color color) {
        this.headTextColor = color;
    }

    public Color getHeadTextColor() {
        return this.headTextColor;
    }

    public void setCellTextColor(Color color) {
        this.cellTextColor = color;
    }

    public Color getCellTextColor() {
        return this.cellTextColor;
    }

    public void setHeadFont(Font font) {
        this.headFont = font;
    }

    public Font getHeadFont() {
        return this.headFont;
    }

    public void setCellFont(Font font) {
        this.cellFont = font;
    }

    public Font getCellFont() {
        return this.cellFont;
    }

    public int getColumnNumber() {
        return this.column;
    }

    public int getRowNumber() {
        return this.row;
    }

    public int getShownColumnNumber() {
        return this.rcolumn;
    }

    public int getShownRowNumber() {
        return this.rrow;
    }

    public int getDefaultWidthInterval() {
        return this.cellWidthOffset;
    }

    public void setDefaultWidthInterval(int wc) {
        this.cellWidthOffset = wc;
    }

    public int getDefaultHeightInterval() {
        return this.cellHeightOffset;
    }

    public void setDefaultHeightInterval(int hc) {
        this.cellHeightOffset = hc;
    }

    public int[] getShownColumn() {
        return this.shown;
    }

    public int[] getShownRow() {
        return this.rowShown;
    }

    public boolean isTransposed() {
        return !this.isHorizontal;
    }

    public void setTransposed(boolean t) {
        this.isHorizontal = t;
    }

    private boolean withinText(int mx, int strLen, int x, int w, int col, int row) {
        short align = this.alignPrimValue;
        if (col == 0 && row == 0) {
            align = this.alignCatTitle;
        } else if (col == 0 && !this.isTransposed()) {
            align = this.alignPrimTitle;
        } else if (col == 0) {
            align = this.alignCatValue;
        } else if (row == 0 && !this.isTransposed()) {
            align = this.alignCatValue;
        } else if (row == 0) {
            align = this.alignPrimTitle;
        }
        int stX = this.getStringX(strLen, x, w, align);
        return mx >= stX && mx <= stX + strLen;
    }

    private void drawText(Graphics g, String text, Font font, int x, int y, int w, int h, short align, boolean drawColorSymbol, MultiDimData mdData, int mdDataIndex) {
        FontMetrics fm = g.getFontMetrics(font);
        int offset = fm.charWidth('b') / 2;
        if (align == 0) {
            x += offset;
            w -= offset;
        } else if (align == 2) {
            w -= offset;
        }
        if (w < 1) {
            w = 1;
        }
        int textLeftMargin = 0;
        if (drawColorSymbol && this.showColorSymbols && mdData != null) {
            textLeftMargin = 16;
        }
        int strWidth = fm.stringWidth(text) + (align != 2 ? textLeftMargin : 0);
        int strBaseX = this.getStringX(strWidth, x, w, align);
        if (drawColorSymbol && this.showColorSymbols && mdData != null) {
            if (align == 0) {
                strBaseX -= offset;
            } else if (align == 2) {
                strBaseX -= textLeftMargin;
            }
            this.drawColorSymbol(mdData, strBaseX, y, h, mdDataIndex);
        }
        int charH = fm.getMaxAscent() + fm.getMaxDescent();
        int strBaseY = this.getStringY(y, h, charH, fm.getMaxDescent());
        g.drawString(text, strBaseX + textLeftMargin, strBaseY);
    }

    private int getStringX(int strLen, int x, int w, short align) {
        switch (align) {
            case 2: {
                return x + w - strLen;
            }
            case 1: {
                return x + (int)Math.rint((double)(w - strLen) / 2.0);
            }
        }
        return x;
    }

    private int getStringY(int y, int h, int charH, int descent) {
        int r = 0;
        r = (int)Math.rint((double)(h - charH) / 2.0);
        if (r < 0) {
            r = 0;
        }
        return y + r + charH - descent;
    }

    public void copy(GraphicsTable _gt, Chart _chart) {
        if (_gt == null) {
            return;
        }
        this.clear = _gt.clear;
        this.shift = _gt.shift;
        this.firstShown = _gt.firstShown;
        this.keepPosition = _gt.keepPosition;
        this.setData(_chart, _chart.mData);
        this.x = _gt.x;
        this.y = _gt.y;
        this.relX = _gt.relX;
        this.relY = _gt.relY;
        this.width = _gt.width;
        this.height = _gt.height;
        this.cellColor = _gt.cellColor;
        this.headColor = _gt.headColor;
        this.cellTextColor = _gt.cellTextColor;
        this.headTextColor = _gt.headTextColor;
        this.headFont = _gt.headFont;
        this.cellFont = _gt.cellFont;
        this.widthPerCell = _gt.widthPerCell;
        this.heightPerCell = _gt.heightPerCell;
        this.tab_width = _gt.tab_width;
        this.tab_height = _gt.tab_height;
        this.tab_num = _gt.tab_num;
        this.axisTabWidth = _gt.axisTabWidth;
        this.totalLength = _gt.totalLength;
        this.direction = _gt.direction;
        this.select_axis = _gt.select_axis;
        this.isHorizontal = _gt.isHorizontal;
        this.alignCatTitle = _gt.alignCatTitle;
        this.alignCatValue = _gt.alignCatValue;
        this.alignSeriesTitle = _gt.alignSeriesTitle;
        this.alignSeriesValue = _gt.alignSeriesValue;
        this.alignPrimTitle = _gt.alignPrimTitle;
        this.alignPrimValue = _gt.alignPrimValue;
        this.alignSecTitle = _gt.alignSecTitle;
        this.alignSecValue = _gt.alignSecValue;
        this.g = _gt.g;
        this.cg = _gt.cg;
        this.calculateRelativePos = _gt.calculateRelativePos;
        if (_gt.cBorder != null) {
            this.cBorder = (int[])_gt.cBorder.clone();
        }
        if (_gt.eWidth != null) {
            this.eWidth = (int[])_gt.eWidth.clone();
        }
        if (_gt.tBorder != null) {
            this.tBorder = (int[])_gt.tBorder.clone();
        }
        if (_gt.cellMatrix != null) {
            this.cellMatrix = (int[][])_gt.cellMatrix.clone();
        }
        if (_gt.framearea != null) {
            this.framearea = null;
            this.framearea = _gt.framearea instanceof Area3D ? new Area3D() : new Area2D();
            _gt.framearea.copyArea(this.framearea);
        }
        if (_gt.area != null) {
            this.area = null;
            this.area = _gt.area instanceof Area3D ? new Area3D() : new Area2D();
            _gt.area.copyArea(this.area);
        }
    }
}

