/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import quadbase.common.util.internal.VersioningDataOutput;

public class HiLowMap {
    public int hi = -1;
    public int low = -1;
    public int close = -1;
    public int open = -1;

    public HiLowMap() {
    }

    public HiLowMap(int hi, int low, int open, int close) {
        this.hi = hi;
        this.low = low;
        this.open = open;
        this.close = close;
    }

    public void copy(HiLowMap data) {
        this.hi = data.hi;
        this.low = data.low;
        this.open = data.open;
        this.close = data.close;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.hi);
        out.writeInt(this.low);
        out.writeInt(this.open);
        out.writeInt(this.close);
    }

    public void write(DataOutput out, short version) throws IOException {
        VersioningDataOutput vdo = (VersioningDataOutput)out;
        vdo.writeInt(this.hi, version);
        vdo.writeInt(this.low, version);
        vdo.writeInt(this.open, version);
        vdo.writeInt(this.close, version);
    }

    public static HiLowMap read(DataInput in, int version) throws IOException {
        HiLowMap map = new HiLowMap(in.readInt(), in.readInt(), in.readInt(), in.readInt());
        if (version < 48) {
            in.readInt();
        }
        return map;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<< HiLowMap >>\n");
        sb.append("hi\t= ").append(this.hi);
        sb.append("low\t= ").append(this.low);
        sb.append("open\t= ").append(this.open);
        sb.append("close\t= ").append(this.close);
        return sb.toString();
    }
}

