/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.chart.Chart;
import quadbase.chart.ImportFontMappingHelper;
import quadbase.chart.designer.ChartMain;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.util.internal.Coder;
import quadbase.common.util.internal.IOUtil;

public class ImportFontMapping {
    private static final Logger LOGGER = Logger.getLogger(ImportFontMapping.class.getName());
    private Chart chart = null;
    private ChartMain chartmain;

    public ImportFontMapping(ChartMain chartmain) {
        this.chartmain = chartmain;
        if (chartmain != null) {
            this.chart = chartmain.getChart();
        }
    }

    public Hashtable importXML(String path) throws IOException {
        if (path == null || path.trim().equals("")) {
            throw new IOException("No file name selected !");
        }
        try (DataInputStream istream = null;){
            istream = ServerMessage.useServer || !ServerMessage.isLoadBalancer ? ImportFontMapping.getInputStreamFromServer(path) : new DataInputStream(new ByteArrayInputStream(new ImportFontMappingHelper().getInputStream(path)));
            Hashtable hashtable = this.importXMLDocument(istream);
            return hashtable;
        }
    }

    private Hashtable importXMLDocument(DataInputStream in) throws Exception {
        Hashtable<String, String> fontMapping = null;
        if (this.chart != null && in != null && this.chartmain != null) {
            int fontMappingSize;
            fontMapping = new Hashtable<String, String>();
            int version = in.readInt();
            if (version >= 130 && (fontMappingSize = in.readInt()) > 0) {
                for (int i = 0; i < fontMappingSize; ++i) {
                    String key = Coder.decode(IOUtil.readString(in, true));
                    String val = Coder.decode(IOUtil.readString(in, true));
                    fontMapping.put(key, val);
                }
            }
        }
        return fontMapping;
    }

    private static DataInputStream getInputStreamFromServer(String file) throws Exception {
        byte[] indata;
        file = file.replace('\\', '/');
        IConnection socket = ServerMessage.createConnection();
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeShort(25588);
        IOUtil.writeString(dout, file);
        try {
            byte[] array = bstream.toByteArray();
            socket.setContentLength(array.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().flush();
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Failed to send data to server", ex);
            socket.close();
            throw ex;
        }
        try {
            DataInputStream dstream = new DataInputStream(socket.getInputStream());
            int code = dstream.readInt();
            if (code != 0) {
                throw new IOException(IOUtil.getErrorString(code) + IOUtil.readString(dstream, true));
            }
            int len = dstream.readInt();
            indata = new byte[len];
            dstream.readFully(indata, 0, len);
            dstream.close();
            socket.close();
        }
        catch (Exception ex) {
            try {
                socket.close();
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINE, "Failed to close socket", ex2);
            }
            LOGGER.log(Level.WARNING, "Failed to read data from server", ex);
            throw ex;
        }
        catch (Error err) {
            try {
                socket.close();
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINE, "Failed to close socket", ex2);
            }
            LOGGER.log(Level.WARNING, "Failed to read data from server", err);
            throw new Exception(err.getMessage());
        }
        return new DataInputStream(new ByteArrayInputStream(indata));
    }
}

