/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.util.Vector;
import quadbase.awt.RotateText;
import quadbase.chart.Area;
import quadbase.chart.CGraphics;
import quadbase.chart.CString;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.DataLine;
import quadbase.chart.GradientSupport;
import quadbase.chart.IPieChart;
import quadbase.chart.ImageMapNode;
import quadbase.chart.MultiDimData;
import quadbase.chart.PieChart;
import quadbase.chart.Point3D;
import quadbase.common.util.internal.IQbGraphics;
import quadbase.common.util.internal.QbUtil;
import quadbase.util.ControlRange;
import quadbase.util.HyperLink;
import quadbase.util.internal.IWMFGraphics;

public class Legend {
    public static final int HORZ = 0;
    public static final int VERT = 1;
    public boolean showLegend = true;
    public MultiDimData mData;
    public Point3D pos;
    public Font font;
    public int fontangle;
    public boolean fontchanged = false;
    public Color fontcolor;
    public int orient = 1;
    public int height;
    public int[] heightArr;
    public int[] numberOfItemPerCol;
    public int maxNumberOfItemPerCol;
    public int width;
    public Chart chart;
    public Area area;
    public Area framearea;
    private int startx;
    private double starty;
    private int charWidth;
    private double distGap;
    private int len;
    private int len2;
    public boolean init = false;
    public CString[] legendstr;
    public Color[] legendColor;
    public MultiDimData[] legendData;
    public Rectangle[] dataRec;
    public int[] legendShape;
    private boolean legend2d;
    private int delta;
    private int ypos;
    private int xpos;
    private int maxwidth;
    private int maxwidth2;
    public static final int HORIZONTAL_LAYOUT = 0;
    public static final int VERTICAL_LAYOUT = 1;
    public static final int SQUARE_LAYOUT = 2;
    public static final int FIXED_COLUMN_LAYOUT = 3;
    private int legendLayout = 1;
    private int fixedColumnCount = 1;
    private int numberOfColumn = 1;
    public boolean reverse = false;
    public String lgName1;
    public String lgName2;
    public Object[] fname;
    public Object[] fname2;
    public ColData cd = null;
    public ColData cd2 = null;
    public CString titleStr;
    public CString[] dataLineStr = null;
    public Color[] dataLineColor = null;
    boolean secondAxis;
    private boolean overlayCombo = false;
    boolean hidedata;
    FontMetrics fm;
    public int pointSizeRatio = 100;
    private int maxCharWidth;
    private int offsetH = 0;
    private int symWidth;
    int titlewidth;
    int titleheight;
    int dataLineheight;
    int dataLinewidth;
    public int[] dataLineHeightArr;
    public int[] numberOfLinePerCol;
    public int maxNumberOfLinePerCol;
    boolean drawSymbols = false;
    boolean drawSymbolWithLine = false;
    char sepSymbol = (char)44;
    public boolean useOneLegendSet = false;
    private int xIndex;
    private int[] colWidth;

    public Legend(MultiDimData data, Chart ch) {
        this.mData = data;
        Font oldDefaultFont = new Font("TimesRoman", 0, 10);
        Font newDefaultFont = new Font("Dialog", 0, 8);
        this.font = QbUtil.getDefaultFont(oldDefaultFont, newDefaultFont);
        this.fontangle = 0;
        this.fontcolor = Color.black;
        this.area = ch.newArea();
        this.area.areaColor = Color.lightGray;
        this.framearea = ch.newArea();
        this.framearea.areaColor = Color.black;
        this.framearea.drawArea = false;
        if (QbUtil.usePatch) {
            this.area.drawArea = true;
            this.framearea.drawBorder = false;
        } else {
            this.area.drawArea = false;
            this.framearea.drawBorder = true;
        }
        this.pos = new Point3D();
        if (this.mData != null) {
            this.chart = this.mData.chart;
            this.secondAxis = this.chart.mData != this.mData;
            this.overlayCombo = ch.mData != this.mData && this.chart.getChartType() == 14 && ch.getComboType() == 3;
            this.legend2d = this.chart.isStackType() && this.chart.dataDim == 3;
        }
    }

    private String getRunTimeValue(String target) {
        return this.cutOffThreshold(this.chart.valueTable.getRunTimeValue(target));
    }

    private String cutOffThreshold(String str) {
        return this.cutOffThreshold(str, 0);
    }

    private String cutOffThreshold(String str, int buffer) {
        if (this.chart == null || this.chart.getCutOffThresholdForText() < 0 || str == null || str.length() + buffer <= this.chart.getCutOffThresholdForText()) {
            return str;
        }
        if (this.chart.getCutOffThresholdForText() - buffer < 1) {
            buffer = this.chart.getCutOffThresholdForText() - 1;
        }
        StringBuffer sb = new StringBuffer();
        int cutoff = str.length() + buffer - this.chart.getCutOffThresholdForText();
        sb.append(str.substring(0, this.chart.getCutOffThresholdForText() - buffer));
        for (int i = 0; i < cutoff && i < 3; ++i) {
            sb.append(".");
        }
        return sb.toString();
    }

    public void invalidate() {
        this.init = false;
    }

    public boolean isVertical() {
        return this.legendLayout == 1;
    }

    public boolean isHorizontal() {
        return this.legendLayout == 0;
    }

    public boolean isSquare() {
        return this.legendLayout == 2;
    }

    public boolean isFixedColumn() {
        return this.legendLayout == 3;
    }

    public int getFixedColumnCount() {
        return this.fixedColumnCount;
    }

    public void setFixedColumnCount(int ct) {
        if (ct > 0) {
            this.fixedColumnCount = ct;
        }
    }

    public void setpos(Point3D p) {
        this.pos = p;
        if (this.legendstr == null) {
            this.init = false;
        } else {
            this.checkpos();
        }
    }

    public void setpos(int x, int y) {
        this.setpos(new Point3D(x, y));
    }

    private void checkpos() {
        block35: {
            int k;
            int start2x;
            block34: {
                if (this.cannotDraw()) {
                    return;
                }
                if ((this.isSquare() || this.isFixedColumn()) && this.useOneLegendSet && this.dataLineStr != null && this.dataLineStr.length > 0) {
                    this.getRunTimeMaxColWidth(this.fm, this.cd, this.getLayout(), this.numberOfColumn);
                } else {
                    this.xIndex = 0;
                }
                if (this.pos.x <= 0) {
                    this.pos.x = 2;
                } else if (this.pos.x >= this.chart.winWidth) {
                    this.pos.x = this.chart.winWidth - 2;
                }
                if (!this.chart.isReferenceAtTop()) {
                    if (this.pos.y <= 0) {
                        this.pos.y = 2;
                    } else if (this.pos.y >= this.chart.winHeight) {
                        this.pos.y = this.chart.winHeight - 2;
                    }
                    this.ypos = this.pos.y - this.height / 2;
                    this.xpos = this.pos.x - this.width / 2;
                } else {
                    if (this.pos.y <= 0) {
                        this.pos.y = 2;
                    } else if (this.pos.y >= this.chart.winHeight - this.height) {
                        this.pos.y = this.chart.winHeight - this.height - 2;
                    }
                    this.ypos = this.chart.winHeight - this.pos.y - this.height;
                    this.xpos = this.pos.x;
                }
                this.startx = (int)((double)(this.width - (2 * this.symWidth + this.maxwidth)) / 2.0);
                start2x = this.startx + 2 * this.symWidth;
                if (this.startx < 0) {
                    this.startx = 0;
                    start2x = this.charWidth;
                }
                double d = this.distGap = this.legend2d ? ((double)this.height / (double)(this.len * this.len2 + this.len) - (double)this.maxCharWidth) / 2.0 : ((double)this.height / (double)this.len - (double)this.maxCharWidth) / 2.0;
                if (this.distGap < 0.0) {
                    this.distGap = 0.0;
                }
                this.starty = this.distGap + (double)(this.charWidth / 5);
                k = 0;
                if (!this.isVertical()) break block34;
                if (!this.legend2d) {
                    for (int i = this.len - 1; i >= 0; --i) {
                        this.legendstr[k++].setpos(new Point3D(start2x + this.xpos, (int)this.starty + this.ypos + this.maxCharWidth / 2));
                        this.starty += (double)this.maxCharWidth + 2.0 * this.distGap;
                    }
                } else {
                    for (int i = this.len - 1; i >= 0; --i) {
                        for (int j = this.len2 - 1; j >= 0; --j) {
                            this.legendstr[k++].setpos(new Point3D(start2x + this.xpos, (int)this.starty + this.ypos + this.maxCharWidth / 2));
                            this.starty += (double)this.maxCharWidth + 2.0 * this.distGap;
                        }
                        this.legendstr[k++].setpos(new Point3D(this.startx + this.xpos, (int)this.starty + this.ypos + this.maxCharWidth / 2));
                        this.starty += (double)this.maxCharWidth + 2.0 * this.distGap;
                    }
                }
                break block35;
            }
            if (!this.isSquare() && !this.isFixedColumn()) break block35;
            this.maxNumberOfItemPerCol = !(this.dataLineStr == null || this.dataLineStr.length <= 0 || this.chart.isStackType() && this.chart.dataDim != 2) ? (this.useOneLegendSet && this.numberOfColumn > 1 ? (int)Math.ceil((double)(this.len + this.dataLineStr.length) / (double)this.numberOfColumn) : (int)Math.ceil((double)Math.max(this.len, this.dataLineStr.length) / (double)this.numberOfColumn)) : (int)Math.ceil((double)this.len / (double)this.numberOfColumn);
            double d = this.distGap = this.legend2d ? ((double)this.height / (double)(this.maxNumberOfItemPerCol * this.len2 + this.maxNumberOfItemPerCol) - (double)this.maxCharWidth) / 2.0 : ((double)this.height / (double)this.maxNumberOfItemPerCol - (double)this.maxCharWidth) / 2.0;
            if (this.distGap < 0.0) {
                this.distGap = 0.0;
            }
            this.starty = this.distGap + (double)(this.charWidth / 5);
            if (!this.legend2d) {
                k = this.len - 1;
                this.starty += ((double)this.maxCharWidth + 2.0 * this.distGap) * (double)(this.maxNumberOfItemPerCol - 1);
                int curXPos = this.xpos;
                if (this.xIndex > 0 && this.dataLineStr != null) {
                    this.starty = this.dataLineStr.length > this.numberOfColumn ? (this.starty += (double)this.maxCharWidth * 1.5 + 2.0 * this.distGap) : (this.starty += (double)this.maxCharWidth + this.distGap * 1.2);
                    for (int n = 0; n < this.xIndex; ++n) {
                        curXPos += this.colWidth[n];
                    }
                }
                for (int i = this.xIndex; i < this.len + this.xIndex; ++i) {
                    if (i != 0 && i % this.numberOfColumn == 0) {
                        curXPos = this.xpos;
                        this.starty = this.useOneLegendSet && this.dataLineStr != null && this.dataLineStr.length > 0 && this.numberOfColumn > 1 ? (this.starty -= (double)this.maxCharWidth * 1.5) : (this.starty -= (double)this.maxCharWidth + 2.0 * this.distGap);
                    }
                    this.legendstr[k--].setpos(new Point3D(start2x + curXPos, (int)this.starty + this.ypos + this.maxCharWidth / 2));
                    if (this.useOneLegendSet && this.dataLineStr != null && this.dataLineStr.length > 0 && this.numberOfColumn > 1) {
                        curXPos += this.colWidth[(i + this.numberOfColumn) % this.numberOfColumn];
                        continue;
                    }
                    curXPos += this.width;
                }
            } else {
                k = (this.len2 + 1) * this.len - 1;
                this.starty += ((double)this.maxCharWidth + 2.0 * this.distGap) * (double)((this.len2 + 1) * this.maxNumberOfItemPerCol - 1);
                int curXPos = this.xpos;
                if (this.xIndex > 0 && this.dataLineStr != null && this.legendstr != null) {
                    this.starty = this.numberOfColumn < this.dataLineStr.length + this.legendstr.length ? (this.starty += (double)this.maxCharWidth + 2.0 * this.distGap) : (this.starty += (double)this.maxCharWidth + this.distGap * 1.2);
                    for (int n = 0; n < this.xIndex; ++n) {
                        curXPos += this.colWidth[n];
                    }
                }
                for (int i = this.xIndex; i < this.len + this.xIndex; ++i) {
                    double startYPos = this.starty;
                    if (i != 0 && i % this.numberOfColumn == 0) {
                        curXPos = this.xpos;
                        this.starty = this.useOneLegendSet && this.dataLineStr != null && this.dataLineStr.length > 0 && this.numberOfColumn > 1 ? (this.starty -= (double)this.maxCharWidth * 1.5) : (this.starty -= ((double)this.maxCharWidth + 2.0 * this.distGap) * (double)(this.len2 + 1));
                        startYPos = this.starty;
                    }
                    this.legendstr[k--].setpos(new Point3D(this.startx + curXPos, (int)this.starty + this.ypos + this.maxCharWidth / 2));
                    this.starty -= (double)this.maxCharWidth + 2.0 * this.distGap;
                    for (int j = 0; j < this.len2; ++j) {
                        this.legendstr[k--].setpos(new Point3D(start2x + curXPos, (int)this.starty + this.ypos + this.maxCharWidth / 2));
                        this.starty -= (double)this.maxCharWidth + 2.0 * this.distGap;
                    }
                    curXPos = this.useOneLegendSet && this.dataLineStr != null && this.dataLineStr.length > 0 && this.numberOfColumn > 1 ? (curXPos += this.colWidth[(i + this.numberOfColumn) % this.numberOfColumn]) : (curXPos += this.width);
                    this.starty = startYPos;
                }
            }
        }
    }

    public void setLayout(int layout) {
        if (this.legendLayout != layout) {
            this.legendLayout = layout;
            this.init = false;
        }
    }

    public final int getNumberOfFixedColumn() {
        return this.fixedColumnCount;
    }

    public final void setNumberOfFixedColumn(int val) {
        if (val <= 0) {
            this.fixedColumnCount = 1;
        }
        this.fixedColumnCount = val;
    }

    public void initialize() {
        int idx;
        int k;
        int nCol;
        int i;
        int j;
        MultiDimData[] fdata;
        int[] fshape;
        Color[] fcolor;
        if (this.cannotDraw()) {
            return;
        }
        if (!this.chart.isComputed()) {
            this.chart.validatePosition();
        }
        this.hidedata = this.chart.is2DChart && (!this.secondAxis && this.chart.chartType == 8 || this.secondAxis && this.chart.comboType == 1 && this.chart.chartType == 4);
        this.getDataLineName();
        if (this.chart.cgraphics == null) {
            return;
        }
        this.fm = this.chart.cgraphics.component.getFontMetrics(QbUtil.resizeViewerFont(this.font, this.chart.isAdjustFont()));
        this.charWidth = this.fm.charWidth('A');
        this.symWidth = (int)Math.rint(this.charWidth * this.pointSizeRatio / 100);
        int n = this.maxCharWidth = this.symWidth > this.charWidth ? this.symWidth : this.charWidth;
        if (this.isHorizontal()) {
            this.offsetH = this.symWidth - this.charWidth;
        } else if (this.symWidth > this.charWidth) {
            this.offsetH = this.symWidth - this.charWidth;
        }
        if (this.chart.subvalueCol >= 0 && !Chart.isCoordinateType(this.chart.chartType) && !this.chart.isCircularChart() && (!this.chart.isHiLow() || this.secondAxis) && this.chart.dataDim != 1 || this.overlayCombo) {
            this.titleStr = new CString(this.chart.colData[this.secondAxis ? this.chart.subvalueCol : this.chart.valueCol].getName(), this.font, new Point3D(), this.fontcolor, 2, this.fontangle);
            this.titlewidth = this.fm.stringWidth(this.getRunTimeValue(this.titleStr.str) + "A  ");
            this.titleheight = 2 * this.maxCharWidth;
        } else {
            this.titleStr = null;
            this.titleheight = 0;
            this.titlewidth = 0;
        }
        this.maxwidth = 0;
        this.len = 0;
        this.len2 = 1;
        this.cd2 = null;
        this.cd = null;
        if (this.isFixedColumn()) {
            this.numberOfColumn = this.fixedColumnCount;
        } else if (!this.isSquare()) {
            this.numberOfColumn = 1;
        }
        boolean isLegendStrFixed = false;
        if (this.chart.isStackType()) {
            if (this.chart.dataDim == 2) {
                this.cd = this.chart.colData[this.chart.mDataMap[1]];
                this.fname = this.getLegendNames(this.cd, this.hidedata);
                fcolor = new Color[this.fname.length];
                fshape = new int[this.fname.length];
                fdata = new MultiDimData[this.fname.length];
                MultiDimData mdd = this.mData.multiData[0];
                j = 0;
                for (i = 0; i < mdd.multiData.length; ++i) {
                    if (!this.cd.showLegend(i, this.hidedata)) continue;
                    fcolor[j] = this.secondAxis ? mdd.multiData[i].point.color : mdd.multiData[i].area.areaColor;
                    fdata[j] = mdd.multiData[i];
                    fshape[j++] = mdd.multiData[i].point.shape;
                }
                this.len = this.fname.length;
                this.lgName2 = this.cd.getName();
                if (this.isSquare()) {
                    if (this.useOneLegendSet) {
                        this.numberOfColumn = this.dataLineStr != null && this.dataLineStr.length > 0 ? (this.len + this.dataLineStr.length == 2 ? 1 : (int)Math.ceil(Math.sqrt(this.len + this.dataLineStr.length))) : (int)Math.ceil(Math.sqrt(this.len));
                    } else {
                        this.numberOfColumn = (int)Math.ceil(Math.sqrt(this.len));
                        if (this.dataLineStr != null && this.dataLineStr.length > 0 && (nCol = (int)Math.ceil(Math.sqrt(this.dataLineStr.length))) > this.numberOfColumn) {
                            this.numberOfColumn = nCol;
                        }
                    }
                }
                this.maxwidth = this.getRunTimeMaxWidth(this.fm, this.fname, this.cd, this.legendLayout, this.numberOfColumn);
            } else {
                this.cd = this.chart.colData[this.chart.mDataMap[0]];
                this.cd2 = this.chart.colData[this.chart.mDataMap[2]];
                this.fname = this.getLegendNames(this.cd, this.hidedata);
                this.len = this.fname.length;
                this.lgName1 = this.getRunTimeValue(this.cd.colName);
                this.lgName2 = this.getRunTimeValue(this.cd2.colName);
                this.maxwidth2 = 0;
                this.maxwidth = 0;
                this.fname2 = this.getLegendNames(this.cd2, this.hidedata);
                this.len2 = this.fname2.length;
                fcolor = new Color[this.len * (this.len2 + 1)];
                fdata = new MultiDimData[fcolor.length];
                fshape = new int[fcolor.length];
                k = 0;
                for (i = 0; i < this.mData.multiData.length; ++i) {
                    if (!this.cd.showLegend(i, this.hidedata)) continue;
                    MultiDimData mdd2 = this.mData.multiData[i].multiData[0];
                    for (j = 0; j < mdd2.multiData.length; ++j) {
                        if (!this.cd2.showLegend(j, this.hidedata)) continue;
                        fcolor[k] = this.secondAxis ? mdd2.multiData[j].point.color : mdd2.multiData[j].area.areaColor;
                        fdata[k] = mdd2.multiData[j];
                        fshape[k++] = mdd2.multiData[j].point.shape;
                    }
                }
                this.useOneLegendSet = false;
                if (this.isSquare()) {
                    this.numberOfColumn = (int)Math.ceil(Math.sqrt(this.len));
                    if (this.dataLineStr != null && this.dataLineStr.length > 0 && (nCol = (int)Math.ceil(Math.sqrt(this.dataLineStr.length))) > this.numberOfColumn) {
                        this.numberOfColumn = nCol;
                    }
                }
                this.maxwidth = this.getRunTimeMaxWidth(this.fm, this.fname, this.cd, 1, 1);
                this.maxwidth2 = this.getRunTimeMaxWidth(this.fm, this.fname2, this.cd2, this.legendLayout, this.numberOfColumn);
            }
        } else if (this.chart.dataDim == 1 && !this.chart.isCircularChart() && (this.chart.chartType != 0 && this.chart.chartType != 15 && this.chart.chartType != 1 && this.chart.chartType != 17 || this.secondAxis || (this.chart.chartType == 0 || this.chart.chartType == 1) && this.chart.isSingleColorForCategories())) {
            this.cd = null;
            if (!this.secondAxis && (this.chart.isHiLow() || Chart.isCoordinateType(this.chart.chartType))) {
                this.fname = null;
                fcolor = null;
                fdata = null;
                fshape = null;
                this.len = 0;
            } else {
                this.fname = new String[1];
                fcolor = new Color[]{this.mData.point.color};
                fdata = new MultiDimData[]{this.mData.getAnyLeafNode()};
                fshape = new int[]{this.mData.point.shape};
                this.fname[0] = this.chart.colData[this.secondAxis ? this.chart.subvalueCol : this.chart.valueCol].getName();
                this.len = this.fname.length;
                this.maxwidth = this.getRunTimeMaxWidth(this.fm, this.fname, null, this.legendLayout, 1);
            }
            if (this.dataLineStr == null || this.dataLineStr.length == 0) {
                this.numberOfColumn = 1;
            }
            if (this.isSquare()) {
                if (this.useOneLegendSet) {
                    this.numberOfColumn = this.dataLineStr != null && this.dataLineStr.length > 0 ? (this.len + this.dataLineStr.length == 2 ? 1 : (int)Math.ceil(Math.sqrt(this.len + this.dataLineStr.length))) : (int)Math.ceil(Math.sqrt(this.len));
                } else {
                    int nCol2;
                    this.numberOfColumn = (int)Math.ceil(Math.sqrt(this.len));
                    if (this.dataLineStr != null && this.dataLineStr.length > 0 && (nCol2 = (int)Math.ceil(Math.sqrt(this.dataLineStr.length))) > this.numberOfColumn) {
                        this.numberOfColumn = nCol2;
                    }
                }
            }
        } else {
            this.cd = this.chart.colData[this.chart.mDataMap[0]];
            this.fname = this.getLegendNames(this.cd, this.hidedata);
            this.len = this.fname.length;
            if (this.chart.isCircularChart()) {
                this.fname = this.getPieFname(this.fname, this.cd);
                isLegendStrFixed = true;
            }
            fcolor = new Color[this.len];
            fdata = new MultiDimData[this.len];
            fshape = new int[this.len];
            int ct = this.mData.multiData.length;
            j = 0;
            for (i = 0; i < ct && j < this.len; ++i) {
                if (!this.cd.showLegend(i, this.hidedata)) continue;
                if (this.chart.chartType == 13) {
                    fcolor[j] = this.mData.multiData[i].point.color;
                    fdata[j] = this.mData.multiData[i].getAnyLeafNode();
                    fshape[j++] = 1;
                    continue;
                }
                if (this.secondAxis || (Chart.isCoordinateType(this.chart.chartType) || this.chart.chartType == 3) && this.chart.is2DChart) {
                    fcolor[j] = this.mData.multiData[i].point.color;
                    fdata[j] = this.mData.multiData[i].getAnyLeafNode();
                    fshape[j++] = this.mData.multiData[i].point.shape;
                    continue;
                }
                fcolor[j] = this.mData.multiData[i].area.areaColor;
                fdata[j] = this.mData.multiData[i].getAnyLeafNode();
                fshape[j++] = this.chart.dataDim == 1 ? this.mData.point.shape : this.mData.multiData[i].point.shape;
            }
            this.lgName1 = this.cd.getName();
            if (this.isSquare()) {
                if (this.useOneLegendSet) {
                    this.numberOfColumn = this.dataLineStr != null && this.dataLineStr.length > 0 ? (this.len + this.dataLineStr.length == 2 ? 1 : (int)Math.ceil(Math.sqrt(this.len + this.dataLineStr.length))) : (int)Math.ceil(Math.sqrt(this.len));
                } else {
                    this.numberOfColumn = (int)Math.ceil(Math.sqrt(this.len));
                    if (this.dataLineStr != null && this.dataLineStr.length > 0 && (nCol = (int)Math.ceil(Math.sqrt(this.dataLineStr.length))) > this.numberOfColumn) {
                        this.numberOfColumn = nCol;
                    }
                }
            }
            this.maxwidth = this.getRunTimeMaxWidth(this.fm, this.fname, this.cd, this.legendLayout, this.numberOfColumn, !isLegendStrFixed);
        }
        if (this.dataLineStr != null && this.dataLineStr.length > 0) {
            if (this.len + this.dataLineStr.length < this.numberOfColumn) {
                this.numberOfColumn = this.useOneLegendSet ? this.len + this.dataLineStr.length : Math.max(this.len, this.dataLineStr.length);
            }
        } else if (this.len < this.numberOfColumn) {
            this.numberOfColumn = this.len;
        }
        this.dataLineheight = this.dataLineStr == null ? 0 : 2 * this.maxCharWidth * this.dataLineStr.length;
        int n2 = this.dataLinewidth = this.dataLineStr == null ? 0 : this.getRunTimeMaxWidth(this.fm, this.dataLineStr, null, 0, 1) + this.dataLineStr.length * 3 * this.symWidth;
        if (this.isVertical()) {
            if (this.maxwidth2 > this.maxwidth) {
                this.maxwidth = this.maxwidth2;
            }
            this.height = (this.legend2d ? (int)((double)this.charWidth + 1.5 * (double)this.charWidth * (double)(1 + this.len * (this.len2 + 1))) + this.len * (this.len2 + 1) * this.offsetH : (int)((double)this.charWidth + 1.5 * (double)this.charWidth * (double)(1 + this.len))) + this.offsetH * this.len;
            if (this.fname == null) {
                this.height -= 2 * this.charWidth;
            }
            if (this.dataLineStr != null) {
                this.maxwidth = Math.max(this.maxwidth, this.getRunTimeMaxWidth(this.fm, this.dataLineStr, null, 1, 1));
            }
            if (this.len == 0 && this.titleStr != null) {
                this.height -= 2 * this.charWidth;
            }
            this.width = this.maxwidth + 4 * this.symWidth;
            if (this.titleStr != null) {
                this.width = Math.max(this.width, this.titlewidth);
            }
        } else if (this.isHorizontal()) {
            this.height = this.offsetH > 0 ? (this.legend2d ? (int)((double)(1 + this.len) * 1.5 * (double)this.charWidth) + this.offsetH : 3 * this.charWidth + this.offsetH) : (this.legend2d ? (int)((double)(1 + this.len) * 1.5 * (double)this.charWidth) : 3 * this.charWidth);
            this.width = (this.legend2d ? 3 * this.charWidth * this.len2 + this.maxwidth + 4 * this.charWidth + this.maxwidth2 + this.offsetH * this.len2 : 3 * this.charWidth * this.len + this.charWidth + this.maxwidth) + this.offsetH * this.len;
        } else if (this.isFixedColumn() || this.isSquare()) {
            int ii;
            if (this.numberOfColumn < 1) {
                this.numberOfColumn = 1;
            }
            if (this.maxwidth2 > this.maxwidth) {
                this.maxwidth = this.maxwidth2;
            }
            this.heightArr = new int[this.numberOfColumn];
            this.numberOfItemPerCol = new int[this.numberOfColumn];
            this.maxNumberOfItemPerCol = (int)Math.ceil((double)this.len / (double)this.numberOfColumn);
            for (ii = 0; ii < this.numberOfColumn; ++ii) {
                this.numberOfItemPerCol[ii] = this.maxNumberOfItemPerCol;
                if (this.len - (ii + 1) * this.maxNumberOfItemPerCol < 0) {
                    this.numberOfItemPerCol[ii] = this.len - this.maxNumberOfItemPerCol * ii;
                }
                this.heightArr[ii] = (this.legend2d ? (int)((double)this.charWidth + 1.5 * (double)this.charWidth * (double)(1 + this.numberOfItemPerCol[ii] * (this.len2 + 1))) + this.numberOfItemPerCol[ii] * (this.len2 + 1) * this.offsetH : (int)((double)this.charWidth + 1.5 * (double)this.charWidth * (double)(1 + this.numberOfItemPerCol[ii]))) + this.offsetH * this.numberOfItemPerCol[ii];
            }
            this.height = this.heightArr[0];
            if (this.fname == null) {
                this.height -= 2 * this.charWidth;
            }
            if (this.dataLineStr != null) {
                if (this.dataLineStr.length > 0) {
                    this.dataLineHeightArr = new int[this.numberOfColumn];
                    this.numberOfLinePerCol = new int[this.numberOfColumn];
                    this.maxNumberOfLinePerCol = (int)Math.ceil((double)this.dataLineStr.length / (double)this.numberOfColumn);
                    if (this.maxNumberOfLinePerCol <= 0) {
                        this.maxNumberOfLinePerCol = 1;
                    }
                    for (ii = 0; ii < this.numberOfColumn; ++ii) {
                        this.numberOfLinePerCol[ii] = this.maxNumberOfLinePerCol;
                        if (this.dataLineStr.length - (ii + 1) * this.maxNumberOfLinePerCol < 0) {
                            this.numberOfLinePerCol[ii] = this.dataLineStr.length - this.maxNumberOfLinePerCol * ii;
                        }
                        this.heightArr[ii] = (this.legend2d ? (int)((double)this.charWidth + 1.5 * (double)this.charWidth * (double)(1 + this.numberOfLinePerCol[ii] * (this.len2 + 1))) + this.numberOfLinePerCol[ii] * (this.len2 + 1) * this.offsetH : (int)((double)this.charWidth + 1.5 * (double)this.charWidth * (double)(1 + this.numberOfLinePerCol[ii]))) + this.offsetH * this.numberOfLinePerCol[ii];
                        this.dataLineHeightArr[ii] = 2 * this.maxCharWidth * this.numberOfLinePerCol[ii];
                    }
                    this.dataLineheight = this.dataLineHeightArr[0];
                }
                this.maxwidth = Math.max(this.maxwidth, this.getRunTimeMaxWidth(this.fm, this.dataLineStr, null, this.legendLayout, this.numberOfColumn));
            }
            if (this.len == 0 && this.titleStr != null) {
                this.height -= 2 * this.charWidth;
            }
            this.width = this.maxwidth + 4 * this.symWidth;
            if (this.titleStr != null) {
                this.width = Math.max(this.width, this.titlewidth);
            }
        }
        if (!this.chart.isReferenceAtTop()) {
            this.ypos = this.pos.y - this.height / 2;
            this.xpos = this.pos.x - this.width / 2;
        } else {
            this.ypos = this.chart.winHeight - this.pos.y - this.height;
            this.xpos = this.pos.x;
        }
        this.legendstr = new CString[this.legend2d ? this.len * (this.len2 + 1) : this.len];
        this.legendColor = new Color[this.legendstr.length];
        this.legendData = new MultiDimData[this.legendstr.length];
        this.legendShape = new int[this.legendstr.length];
        this.startx = (int)((double)(this.width - (2 * this.charWidth + this.maxwidth)) / 2.0);
        int start2x = this.startx + 2 * this.charWidth;
        if (this.startx < 0) {
            this.startx = 0;
            start2x = this.charWidth;
        }
        double d = this.distGap = this.legend2d ? ((double)this.height / (double)(this.len * this.len2 + this.len) - (double)this.charWidth) / 2.0 : ((double)this.height / (double)this.len - (double)this.charWidth) / 2.0;
        if (this.distGap < 0.0) {
            this.distGap = 0.0;
        }
        this.starty = this.distGap + (double)(this.charWidth / 5);
        k = 0;
        if (!this.legend2d) {
            for (i = this.len - 1; i >= 0; --i) {
                idx = this.reverse ? this.len - i - 1 : i;
                this.legendstr[k] = new CString(Legend.formatLabel(this.fname[idx], this.cd), this.font, new Point3D(start2x + this.xpos, (int)this.starty + this.ypos + this.charWidth / 2), this.fontcolor, 2, this.fontangle);
                this.legendstr[k].setAllowCutOff(!isLegendStrFixed);
                this.legendColor[k] = fcolor[idx];
                this.legendData[k] = fdata[idx];
                this.legendShape[k++] = fshape[idx];
                this.starty += (double)this.charWidth + 2.0 * this.distGap;
            }
        } else {
            for (i = this.len - 1; i >= 0; --i) {
                for (j = this.len2 - 1; j >= 0; --j) {
                    idx = this.reverse ? this.len2 - j - 1 : j;
                    this.legendstr[k] = new CString(Legend.formatLabel(this.fname2[idx], this.cd2), this.font, new Point3D(start2x + this.xpos, (int)this.starty + this.ypos + this.charWidth / 2), this.fontcolor, 2, this.fontangle);
                    this.legendColor[k] = fcolor[i * this.len2 + idx];
                    this.legendData[k] = fdata[i * this.len2 + idx];
                    this.legendShape[k++] = fshape[i * this.len2 + idx];
                    this.starty += (double)this.charWidth + 2.0 * this.distGap;
                }
                this.legendstr[k] = new CString(Legend.formatLabel(this.fname[i], this.cd), this.font, new Point3D(this.startx + this.xpos, (int)this.starty + this.ypos + this.charWidth / 2), this.fontcolor, 2, this.fontangle);
                this.legendColor[k++] = Color.black;
                this.starty += (double)this.charWidth + 2.0 * this.distGap;
            }
        }
        this.checkpos();
    }

    public boolean cannotDraw() {
        if (this.chart == null || !this.showLegend) {
            return true;
        }
        if (this.secondAxis) {
            return this.chart.subvalueCol < 0 || Chart.isCoordinateType(this.chart.chartType) || this.chart.isCircularChart();
        }
        return this.chart.dataDim == 1 && (this.chart.isHiLow() || Chart.isCoordinateType(this.chart.chartType)) && this.getDataLineSize() == 0;
    }

    public void draw(CGraphics g) {
        if (this.cannotDraw()) {
            return;
        }
        if (g.g instanceof IQbGraphics) {
            ((IQbGraphics)((Object)g.g)).setLegendTab();
        }
        if (!this.init) {
            this.initialize();
        }
        CString.setOutsidePlotAreaText(true);
        if (this.fontangle != 0 && !this.init || this.fontchanged) {
            String tmpStr;
            String txt;
            String string = this.legendstr == null || this.legendstr.length == 0 ? (this.titleStr != null ? this.getRunTimeValue(this.titleStr.str) : (this.dataLineStr != null && this.dataLineStr.length != 0 ? this.getRunTimeValue(this.dataLineStr[0].str) : "H")) : (txt = this.chart.valueTable.getRunTimeValue(this.legendstr[0].str));
            if (this.dataLineStr != null && txt.equals(this.dataLineStr[0].str)) {
                for (CString element : this.dataLineStr) {
                    tmpStr = this.chart.valueTable.findUniqueKeyValue(element.str);
                    if (txt.length() >= tmpStr.length()) continue;
                    txt = tmpStr;
                }
            } else if (this.legendstr != null && this.legendstr.length != 0 && txt.equals(this.legendstr[0].str)) {
                for (CString element : this.legendstr) {
                    tmpStr = this.chart.valueTable.findUniqueKeyValue(element.str);
                    if (txt.length() >= tmpStr.length()) continue;
                    txt = tmpStr;
                }
            }
            boolean isJ2DRotate = g.chart.isJ2DRotateEnabled();
            boolean isAdjustFont = g.chart.isAdjustFont();
            RotateText rText = new RotateText(txt, g.component, 0, 0, this.fontangle, isJ2DRotate, isAdjustFont);
            rText.setFont(this.font);
            rText.prepareImage(g.g);
            this.delta = (rText.getHeight() - g.getFontMetrics(QbUtil.resizeViewerFont(this.font, this.chart.isAdjustFont())).charWidth('A')) / 2;
            if (g.g instanceof IWMFGraphics) {
                this.delta = Math.abs(this.delta);
            }
        }
        this.init = true;
        if (this.isVertical()) {
            int h = this.ypos + this.height + this.delta + this.titleheight + this.dataLineheight;
            this.area.setpos(this.xpos, this.ypos - this.delta, this.xpos + this.width, h);
            this.framearea.setpos(this.xpos, this.ypos - this.delta, this.xpos + this.width, h);
            this.area.setCutCornerWidth(this.charWidth);
            this.area.draw(g, this.area, null, true, this.area);
            this.framearea.setAppearance(this.area.appearance);
            this.framearea.setCutCornerWidth(this.charWidth);
            this.framearea.draw(g);
            if (this.titleStr != null) {
                this.titleStr.setpos(new Point3D(this.xpos + this.charWidth, this.ypos + this.dataLineheight + this.height + this.charWidth - this.delta / 2));
                this.titleStr.draw(g);
            }
            if (this.dataLineStr != null) {
                for (int i = 0; i < this.dataLineStr.length; ++i) {
                    h = this.ypos + this.height + i * this.charWidth * 2 + this.charWidth;
                    Legend.fillSetLine(g, this.dataLineColor[i], this.xpos + this.charWidth, h, this.xpos + 2 * this.charWidth, h, 2, i >= this.chart.dataLineSet.getSize() ? 0 : this.chart.dataLineSet.elementAt(i).getLineStyle());
                    this.dataLineStr[i].setpos(new Point3D(this.xpos + 3 * this.charWidth, h));
                    this.dataLineStr[i].draw(g);
                }
            }
            this.drawVertical(g);
        } else if (this.isHorizontal()) {
            int h = this.xpos + this.width + this.titlewidth + this.dataLinewidth;
            this.area.setpos(this.xpos, this.ypos - this.delta, h, this.ypos + this.height + this.delta);
            this.framearea.setpos(this.xpos, this.ypos - this.delta, h, this.ypos + this.height + this.delta);
            this.area.setCutCornerWidth(this.charWidth);
            this.area.draw(g);
            this.framearea.setAppearance(this.area.appearance);
            this.framearea.setCutCornerWidth(this.charWidth);
            this.framearea.draw(g);
            h = this.ypos + this.height - 3 * this.charWidth / 2;
            if (this.titleStr != null) {
                this.titleStr.setpos(new Point3D(this.xpos + this.charWidth / 2, h));
                this.titleStr.draw(g);
            }
            if (this.dataLineStr != null) {
                int lx = this.xpos + this.titlewidth + this.charWidth / 2;
                for (int i = 0; i < this.dataLineStr.length; ++i) {
                    Legend.fillSetLine(g, this.dataLineColor[i], lx, h, lx + this.charWidth, h, 2, i >= this.chart.dataLineSet.getSize() ? 0 : this.chart.dataLineSet.elementAt(i).getLineStyle());
                    this.dataLineStr[i].setpos(new Point3D(lx + 2 * this.charWidth, h));
                    this.dataLineStr[i].draw(g);
                    lx += this.fm.stringWidth(this.getRunTimeValue(this.dataLineStr[i].str)) + 3 * this.charWidth;
                }
            }
            this.drawHorizontal(g);
        } else if (this.isSquare() || this.isFixedColumn()) {
            int h = this.ypos + this.height + this.delta + this.titleheight + this.dataLineheight;
            int w = this.width * this.numberOfColumn;
            int y1 = this.ypos - this.delta;
            if (this.useOneLegendSet && this.legendstr != null && this.legendstr.length != 0 && this.dataLineStr != null && this.dataLineStr.length != 0 && this.numberOfColumn > 1) {
                w = 0;
                for (int n = 0; n < this.numberOfColumn; ++n) {
                    w += this.colWidth[n];
                }
                y1 += this.charWidth * 2;
            }
            this.area.setpos(this.xpos, y1, this.xpos + w, h);
            this.framearea.setpos(this.xpos, y1, this.xpos + w, h);
            this.area.setCutCornerWidth(this.charWidth);
            this.area.draw(g, this.area, null, true, this.area);
            this.framearea.setAppearance(this.area.appearance);
            this.framearea.setCutCornerWidth(this.charWidth);
            this.framearea.draw(g);
            if (this.titleStr != null) {
                this.titleStr.setpos(new Point3D(this.xpos + this.charWidth, this.ypos + this.dataLineheight + this.height + this.charWidth - this.delta / 2));
                this.titleStr.draw(g);
            }
            if (this.dataLineStr != null) {
                int curXPos = this.xpos;
                h = this.ypos + this.height + (this.maxNumberOfLinePerCol - 1) * this.charWidth * 2 + this.charWidth;
                for (int i = 0; i < this.dataLineStr.length; ++i) {
                    if (i != 0 && i % this.numberOfColumn == 0) {
                        h = (int)((double)h - (double)this.charWidth * 1.6);
                        curXPos = this.xpos;
                    }
                    Legend.fillSetLine(g, this.dataLineColor[i], curXPos + this.charWidth, h, curXPos + 2 * this.charWidth, h, 2, i >= this.chart.dataLineSet.getSize() ? 0 : this.chart.dataLineSet.elementAt(i).getLineStyle());
                    this.dataLineStr[i].setpos(new Point3D(curXPos + 3 * this.charWidth, h));
                    this.dataLineStr[i].draw(g);
                    if (this.useOneLegendSet && this.dataLineStr != null && this.dataLineStr.length > 0 && this.numberOfColumn > 1) {
                        curXPos += this.colWidth[(i + this.numberOfColumn) % this.numberOfColumn];
                        continue;
                    }
                    curXPos += this.width;
                }
                this.xIndex = this.useOneLegendSet && this.dataLineStr != null && this.dataLineStr.length > 0 && this.numberOfColumn > 1 ? this.dataLineStr.length % this.numberOfColumn : 0;
            }
            if (this.useOneLegendSet) {
                this.checkpos();
            }
            this.drawFixedColumn(g);
        }
        CString.setOutsidePlotAreaText(false);
        if (g.g instanceof IQbGraphics) {
            ((IQbGraphics)((Object)g.g)).setEndTab();
        }
    }

    public void drawSymbols(boolean drawSym) {
        this.drawSymbols = drawSym;
    }

    public boolean areSymbolsDrawn() {
        return this.drawSymbols;
    }

    public void setDrawSymbolWithLine(boolean drawSymWithLine) {
        this.drawSymbolWithLine = drawSymWithLine;
    }

    public boolean isDrawSymbolWithLine() {
        return this.drawSymbolWithLine;
    }

    private synchronized void drawVertical(CGraphics g) {
        CString.drawCStrings(g, this.legendstr);
        this.starty = this.distGap + (double)(this.charWidth / 5);
        GradientSupport gradientSupport = g.chart.legend == this ? g.chart.getPrimaryDataGradientSupport() : g.chart.getSecondaryDataGradientSupport();
        int cx = (int)((double)(this.xpos + this.startx) + (double)this.symWidth / 2.0);
        int ptSize = (int)((double)this.symWidth / 2.0 - 3.0);
        if (ptSize < 0) {
            ptSize = 0;
        }
        int idx = 0;
        float segment = (float)this.height / (float)this.legendstr.length;
        this.dataRec = new Rectangle[this.legendData.length];
        if (this.chart.isStackType()) {
            if (this.chart.dataDim == 2) {
                for (int i = this.len - 1; i >= 0; --i) {
                    int cy;
                    HyperLink lnk = CGraphics.getLink(this.legendData[idx], true);
                    this.dataRec[idx] = new Rectangle(this.xpos, (int)((double)(this.chart.winHeight - this.ypos) - this.starty - (double)segment), this.width, (int)segment);
                    if (lnk != null) {
                        this.chart.cgraphics.enableImageMap();
                        this.chart.cgraphics.maplist.addElement(new ImageMapNode(this.dataRec[idx], lnk.link, lnk.target, lnk.hint));
                    }
                    if (this.drawSymbols && this.chart.is2DChart && this.legendShape[idx] != 7) {
                        cy = (int)((double)this.ypos + this.starty + (double)this.symWidth / 2.0);
                        new Point3D(cx, cy, this.legendColor[idx], this.legendShape[idx], ptSize, this.getDrawPointBorderColor()).drawPt(g, this.isDrawPointBorder(), this.drawSymbolWithLine, gradientSupport);
                    } else if (this.secondAxis && this.chart.comboType == 0) {
                        cy = (int)((double)this.ypos + this.starty + (double)this.maxCharWidth / 2.0);
                        Legend.fillSetLine(g, this.legendColor[idx], cx - this.symWidth / 4, cy, (int)((double)cx + 1.25 * (double)this.symWidth), cy, 2, this.legendShape[idx]);
                    } else {
                        Legend.fillSetArea(g, this.legendColor[idx], this.xpos + this.startx, (int)((double)this.ypos + this.starty), this.symWidth + this.xpos + this.startx, (int)((double)(this.symWidth + this.ypos) + this.starty), this == g.chart.legend);
                    }
                    this.starty += (double)this.maxCharWidth + 2.0 * this.distGap;
                    ++idx;
                }
            } else {
                for (int i = this.len - 1; i >= 0; --i) {
                    for (int j = this.len2 - 1; j >= 0; --j) {
                        int cy;
                        HyperLink lnk = CGraphics.getLink(this.legendData[idx], true);
                        this.dataRec[idx] = new Rectangle(this.xpos, (int)((double)(this.chart.winHeight - this.ypos) - this.starty - (double)segment), this.width, (int)segment);
                        if (lnk != null) {
                            this.chart.cgraphics.enableImageMap();
                            this.chart.cgraphics.maplist.addElement(new ImageMapNode(this.dataRec[idx], lnk.link, lnk.target, lnk.hint));
                        }
                        if (this.drawSymbols && this.chart.is2DChart && this.legendShape[idx] != 7) {
                            cy = (int)((double)this.ypos + this.starty + (double)this.symWidth / 2.0);
                            new Point3D(cx, cy, this.legendColor[idx], this.legendShape[idx], ptSize, this.getDrawPointBorderColor()).drawPt(g, this.isDrawPointBorder(), this.drawSymbolWithLine, gradientSupport);
                        } else if (this.secondAxis) {
                            cy = (int)((double)this.ypos + this.starty + (double)this.symWidth / 2.0);
                            Legend.fillSetLine(g, this.legendColor[idx], cx - this.symWidth / 4, cy, (int)((double)cx + 1.25 * (double)this.symWidth), cy, 2, this.legendShape[idx]);
                        } else {
                            Legend.fillSetArea(g, this.legendColor[idx], this.xpos + this.startx, (int)((double)this.ypos + this.starty), this.symWidth + this.xpos + this.startx, (int)((double)(this.symWidth + this.ypos) + this.starty), this == g.chart.legend);
                        }
                        this.starty += (double)this.maxCharWidth + 2.0 * this.distGap;
                        ++idx;
                    }
                    this.starty += (double)this.maxCharWidth + 2.0 * this.distGap;
                    ++idx;
                }
            }
        } else {
            for (int i = this.len - 1; i >= 0; --i) {
                int cy;
                HyperLink lnk = CGraphics.getLink(this.legendData[idx], true);
                this.dataRec[idx] = new Rectangle(this.xpos, (int)((double)(this.chart.winHeight - this.ypos) - this.starty - (double)segment), this.width, (int)segment);
                if (lnk != null) {
                    this.chart.cgraphics.enableImageMap();
                    this.chart.cgraphics.maplist.addElement(new ImageMapNode(this.dataRec[idx], lnk.link, lnk.target, lnk.hint));
                }
                if (this.drawSymbols && this.chart.is2DChart && this.legendShape[idx] != 7) {
                    cy = (int)((double)this.ypos + this.starty + (double)this.symWidth / 2.0);
                    new Point3D(cx, cy, this.legendColor[idx], this.legendShape[idx], ptSize, this.getDrawPointBorderColor()).drawPt(g, this.isDrawPointBorder(), this.drawSymbolWithLine, gradientSupport);
                } else if (this.secondAxis || (Chart.isCoordinateType(this.chart.chartType) || this.chart.chartType == 3) && this.chart.is2DChart) {
                    cy = (int)((double)this.ypos + this.starty + (double)this.symWidth / 2.0);
                    if (Chart.isCoordinateType(this.chart.chartType)) {
                        new Point3D(cx, cy, this.legendColor[idx], this.legendShape[idx], ptSize, this.getDrawPointBorderColor()).drawPt(g, this.isDrawPointBorder(), this.drawSymbolWithLine, gradientSupport);
                    } else if (this.chart.comboType == 2) {
                        Legend.fillSetArea(g, this.legendColor[idx], this.xpos + this.startx, (int)((double)this.ypos + this.starty), this.symWidth + this.xpos + this.startx, (int)((double)(this.symWidth + this.ypos) + this.starty), this == g.chart.legend);
                    } else {
                        Legend.fillSetLine(g, this.legendColor[idx], cx - this.symWidth / 4, cy, (int)((double)cx + 1.25 * (double)this.symWidth), cy, 2, this.legendShape[idx]);
                    }
                } else {
                    Legend.fillSetArea(g, this.legendColor[idx], this.xpos + this.startx, (int)((double)this.ypos + this.starty), this.symWidth + this.xpos + this.startx, (int)((double)(this.symWidth + this.ypos) + this.starty), this == g.chart.legend);
                }
                this.starty += (double)this.maxCharWidth + 2.0 * this.distGap;
                ++idx;
            }
        }
    }

    private synchronized void drawHorizontal(CGraphics g) {
        GradientSupport gradientSupport = g.chart.legend == this ? g.chart.getPrimaryDataGradientSupport() : g.chart.getSecondaryDataGradientSupport();
        int ptSize = (int)((double)this.symWidth / 2.0 - 3.0);
        if (ptSize < 0) {
            ptSize = 0;
        }
        if (this.fname == null) {
            return;
        }
        float segment = (float)this.height / (float)this.fname.length;
        this.dataRec = new Rectangle[this.legendData.length];
        if (this.chart.isStackType()) {
            if (this.chart.dataDim == 2) {
                int index;
                int i;
                int x = this.xpos + this.charWidth + this.titlewidth + this.dataLinewidth;
                int h = this.ypos + this.height - 3 * this.charWidth / 2;
                int y = h - this.symWidth / 2;
                int w2 = 2 * this.symWidth;
                int y2 = y + this.symWidth;
                int xOffset = 0;
                for (i = 0; i < this.len; ++i) {
                    index = this.len - i - 1;
                    if (index < this.len - 1) {
                        xOffset += this.legendstr[index].pos.x - this.legendstr[index + 1].pos.x;
                    }
                    if (this.drawSymbols && this.chart.is2DChart && this.legendShape[index] != 7) {
                        new Point3D(x + this.symWidth / 2, y + this.symWidth / 2, this.legendColor[index], this.legendShape[index], ptSize, this.getDrawPointBorderColor()).drawPt(g, this.isDrawPointBorder(), this.drawSymbolWithLine, gradientSupport);
                    } else if (this.secondAxis && this.chart.comboType == 0) {
                        Legend.fillSetLine(g, this.legendColor[index], x - this.symWidth / 4, h, (int)((double)x + 1.25 * (double)this.symWidth), h, 2, this.legendShape[index]);
                    } else {
                        Legend.fillSetArea(g, this.legendColor[index], x, y, x + this.symWidth, y2, this == g.chart.legend);
                    }
                    this.legendstr[index].setpos(new Point3D(x += w2, h));
                    x = (int)((double)x + (this.fm.getStringBounds(this.getRunTimeValue(this.legendstr[index].str), g.g).getWidth() + (double)this.charWidth));
                }
                for (i = 0; i < this.len; ++i) {
                    index = this.len - i - 1;
                    HyperLink lnk = CGraphics.getLink(this.legendData[index], true);
                    int segmentX = 0;
                    segmentX = index == 0 ? this.width - (this.legendstr[0].pos.x - this.legendstr[this.len - 1].pos.x) : this.legendstr[index - 1].pos.x - this.legendstr[index].pos.x;
                    this.dataRec[index] = new Rectangle(this.xpos + xOffset, this.chart.winHeight - this.ypos - this.height, segmentX, this.height);
                    if (lnk != null) {
                        this.chart.cgraphics.enableImageMap();
                        this.chart.cgraphics.maplist.addElement(new ImageMapNode(this.dataRec[index], lnk.link, lnk.target, lnk.hint));
                    }
                    this.legendstr[index].draw(g);
                }
            } else {
                int y = this.ypos + this.charWidth;
                for (int i = this.len - 1; i >= 0; --i) {
                    int x = this.xpos + this.charWidth + this.titlewidth + this.dataLinewidth;
                    int k = (this.len - i - 1) * (this.len2 + 1) + this.len2;
                    this.legendstr[k].setpos(new Point3D(x, y + this.charWidth / 2 + 2));
                    this.legendstr[k--].draw(g);
                    new CString(":", this.legendstr[0].font, new Point3D(x += this.maxwidth + this.charWidth, y + this.charWidth / 2 + 2), this.legendstr[0].color, 2).draw(g);
                    x += this.charWidth;
                    for (int j = 0; j < this.len2; ++j) {
                        int index = this.len2 - j - 1;
                        HyperLink lnk = CGraphics.getLink(this.legendData[k], true);
                        int segmentX = 0;
                        segmentX = index == 0 ? this.width - (this.legendstr[0].pos.x - this.legendstr[this.len2 - 1].pos.x) - (this.legendstr[this.len2 - 1].pos.x - this.legendstr[this.len2].pos.x) : this.legendstr[index - 1].pos.x - this.legendstr[index].pos.x;
                        this.dataRec[index] = new Rectangle(this.legendstr[index].pos.x - segmentX / 2, this.chart.winHeight - this.ypos - (int)(segment * (float)(this.len - i)), segmentX, (int)segment);
                        if (lnk != null) {
                            this.chart.cgraphics.enableImageMap();
                            this.chart.cgraphics.maplist.addElement(new ImageMapNode(this.dataRec[index], lnk.link, lnk.target, lnk.hint));
                        }
                        if (this.drawSymbols && this.chart.is2DChart && this.legendShape[k] != 7) {
                            new Point3D(x + this.charWidth / 2, y + this.charWidth / 2, this.legendColor[k], this.legendShape[k], ptSize, this.getDrawPointBorderColor()).drawPt(g, this.isDrawPointBorder(), this.drawSymbolWithLine, gradientSupport);
                        } else if (this.secondAxis) {
                            Legend.fillSetLine(g, this.legendColor[k], x - this.charWidth / 4, y + this.charWidth / 2, (int)((double)x + 1.25 * (double)this.charWidth), y + this.charWidth / 2, 2, this.legendShape[k]);
                        } else {
                            Legend.fillSetArea(g, this.legendColor[k], x, y, x + this.charWidth, y + this.charWidth, this == g.chart.legend);
                        }
                        this.legendstr[k].setpos(new Point3D(x += 2 * this.charWidth, y + this.charWidth / 2 + 2));
                        this.legendstr[k].draw(g);
                        x += this.fm.stringWidth(this.getRunTimeValue(this.legendstr[k--].str)) + this.charWidth;
                    }
                    y += this.charWidth + this.charWidth / 2;
                }
            }
        } else {
            int index;
            int i;
            int x = this.xpos + this.charWidth + this.titlewidth + this.dataLinewidth;
            int h = this.ypos + this.height - 3 * this.charWidth / 2;
            int y = h - this.symWidth / 2;
            int w2 = this.charWidth + this.symWidth;
            int y2 = y + this.symWidth;
            for (i = 0; i < this.len; ++i) {
                index = this.len - i - 1;
                if (this.drawSymbols && this.chart.is2DChart && this.legendShape[index] != 7) {
                    new Point3D(x + this.symWidth / 2, y + this.symWidth / 2, this.legendColor[index], this.legendShape[index], ptSize, this.getDrawPointBorderColor()).drawPt(g, this.isDrawPointBorder(), this.drawSymbolWithLine, gradientSupport);
                } else if (this.secondAxis || (Chart.isCoordinateType(this.chart.chartType) || this.chart.chartType == 3) && this.chart.is2DChart) {
                    if (Chart.isCoordinateType(this.chart.chartType)) {
                        new Point3D(x + this.symWidth / 2, y + this.symWidth / 2, this.legendColor[index], this.legendShape[index], ptSize, this.getDrawPointBorderColor()).drawPt(g, this.isDrawPointBorder(), this.drawSymbolWithLine, gradientSupport);
                    } else if (this.chart.comboType == 2) {
                        Legend.fillSetArea(g, this.legendColor[index], x, y, x + this.symWidth, y2, this == g.chart.legend);
                    } else {
                        Legend.fillSetLine(g, this.legendColor[index], x - this.symWidth / 4, h, (int)((double)x + 1.25 * (double)this.symWidth), h, 2, this.legendShape[index]);
                    }
                } else {
                    Legend.fillSetArea(g, this.legendColor[index], x, y, x + this.symWidth, y2, this == g.chart.legend);
                }
                this.legendstr[index].setpos(new Point3D(x += w2, h));
                x = (int)((double)x + (this.fm.getStringBounds(this.getRunTimeValue(this.legendstr[index].str), g.g).getWidth() + (double)this.charWidth));
            }
            for (i = 0; i < this.len; ++i) {
                index = this.len - i - 1;
                int lgdIndex = this.len - i - 1;
                HyperLink lnk = CGraphics.getLink(this.legendData[index], true);
                int segmentX = 0;
                segmentX = lgdIndex == 0 ? this.width - (this.legendstr[0].pos.x - this.legendstr[this.len - 1].pos.x) : this.legendstr[lgdIndex - 1].pos.x - this.legendstr[lgdIndex].pos.x;
                this.dataRec[index] = new Rectangle(this.xpos + (this.width - (this.legendstr[0].pos.x - this.legendstr[lgdIndex].pos.x)) - segmentX, this.chart.winHeight - this.ypos - this.height, segmentX, this.height);
                if (lnk != null) {
                    this.chart.cgraphics.enableImageMap();
                    this.chart.cgraphics.maplist.addElement(new ImageMapNode(this.dataRec[index], lnk.link, lnk.target, lnk.hint));
                }
                this.legendstr[index].draw(g);
            }
        }
    }

    private synchronized void drawFixedColumn(CGraphics g) {
        CString.drawCStrings(g, this.legendstr);
        GradientSupport gradientSupport = g.chart.legend == this ? g.chart.getPrimaryDataGradientSupport() : g.chart.getSecondaryDataGradientSupport();
        this.starty = this.distGap + (double)(this.charWidth / 5);
        int ptSize = (int)((double)this.symWidth / 2.0 - 3.0);
        if (ptSize < 0) {
            ptSize = 0;
        }
        int idx = 0;
        float segment = (float)this.height / (float)this.legendstr.length;
        this.dataRec = new Rectangle[this.legendData.length];
        if (this.chart.isStackType()) {
            if (this.chart.dataDim == 2) {
                this.starty += ((double)this.maxCharWidth + 2.0 * this.distGap) * (double)(this.maxNumberOfItemPerCol - 1);
                idx = this.len - 1;
                int curXPos = this.xpos;
                if (this.xIndex > 0 && this.dataLineStr != null) {
                    this.starty = this.dataLineStr.length > this.numberOfColumn ? (this.starty += (double)this.maxCharWidth * 1.5 + 2.0 * this.distGap) : (this.starty += (double)this.maxCharWidth + this.distGap * 1.2);
                    for (int n = 0; n < this.xIndex; ++n) {
                        curXPos += this.colWidth[n];
                    }
                }
                for (int i = this.xIndex; i < this.len + this.xIndex; ++i) {
                    int cy;
                    if (i != 0 && i % this.numberOfColumn == 0) {
                        this.starty = this.useOneLegendSet && this.dataLineStr != null && this.dataLineStr.length > 0 && this.numberOfColumn > 1 ? (this.starty -= (double)this.maxCharWidth * 1.5) : (this.starty -= (double)this.maxCharWidth + 2.0 * this.distGap);
                        curXPos = this.xpos;
                    }
                    HyperLink lnk = CGraphics.getLink(this.legendData[idx], true);
                    this.dataRec[idx] = new Rectangle(curXPos, (int)((double)(this.chart.winHeight - this.ypos) - this.starty - (double)segment), this.width, (int)segment);
                    if (lnk != null) {
                        this.chart.cgraphics.enableImageMap();
                        this.chart.cgraphics.maplist.addElement(new ImageMapNode(this.dataRec[idx], lnk.link, lnk.target, lnk.hint));
                    }
                    int cx = (int)((double)(curXPos + this.startx) + (double)this.symWidth / 2.0);
                    if (this.drawSymbols && this.chart.is2DChart && this.legendShape[idx] != 7) {
                        cy = (int)((double)this.ypos + this.starty + (double)this.symWidth / 2.0);
                        new Point3D(cx, cy, this.legendColor[idx], this.legendShape[idx], ptSize, this.getDrawPointBorderColor()).drawPt(g, this.isDrawPointBorder(), this.drawSymbolWithLine, gradientSupport);
                    } else if (this.secondAxis && this.chart.comboType == 0) {
                        cy = (int)((double)this.ypos + this.starty + (double)this.maxCharWidth / 2.0);
                        Legend.fillSetLine(g, this.legendColor[idx], cx - this.symWidth / 4, cy, (int)((double)cx + 1.25 * (double)this.symWidth), cy, 2, this.legendShape[idx]);
                    } else {
                        Legend.fillSetArea(g, this.legendColor[idx], curXPos + this.startx, (int)((double)this.ypos + this.starty), this.symWidth + curXPos + this.startx, (int)((double)(this.symWidth + this.ypos) + this.starty), this == g.chart.legend);
                    }
                    curXPos = this.useOneLegendSet && this.dataLineStr != null && this.dataLineStr.length > 0 && this.numberOfColumn > 1 ? (curXPos += this.colWidth[(i + this.numberOfColumn) % this.numberOfColumn]) : (curXPos += this.width);
                    --idx;
                }
            } else {
                idx = (this.len2 + 1) * this.len - 1;
                this.starty += ((double)this.maxCharWidth + 2.0 * this.distGap) * (double)((this.len2 + 1) * this.maxNumberOfItemPerCol - 1);
                double curYPos = this.starty;
                int curXPos = this.xpos;
                for (int i = 0; i < this.len; ++i) {
                    if (i != 0 && i % this.numberOfColumn == 0) {
                        this.starty -= ((double)this.maxCharWidth + 2.0 * this.distGap) * (double)(this.len2 + 1);
                        curYPos = this.starty;
                        curXPos = this.xpos;
                    }
                    this.starty -= (double)this.maxCharWidth + 2.0 * this.distGap;
                    --idx;
                    for (int j = 0; j < this.len2; ++j) {
                        int cy;
                        HyperLink lnk = CGraphics.getLink(this.legendData[idx], true);
                        this.dataRec[idx] = new Rectangle(curXPos, (int)((double)(this.chart.winHeight - this.ypos) - this.starty - (double)segment), this.width, (int)segment);
                        if (lnk != null) {
                            this.chart.cgraphics.enableImageMap();
                            this.chart.cgraphics.maplist.addElement(new ImageMapNode(this.dataRec[idx], lnk.link, lnk.target, lnk.hint));
                        }
                        int cx = (int)((double)(curXPos + this.startx) + (double)this.symWidth / 2.0);
                        if (this.drawSymbols && this.chart.is2DChart && this.legendShape[idx] != 7) {
                            cy = (int)((double)this.ypos + this.starty + (double)this.symWidth / 2.0);
                            new Point3D(cx, cy, this.legendColor[idx], this.legendShape[idx], ptSize, this.getDrawPointBorderColor()).drawPt(g, this.isDrawPointBorder(), this.drawSymbolWithLine, gradientSupport);
                        } else if (this.secondAxis) {
                            cy = (int)((double)this.ypos + this.starty + (double)this.symWidth / 2.0);
                            Legend.fillSetLine(g, this.legendColor[idx], cx - this.symWidth / 4, cy, (int)((double)cx + 1.25 * (double)this.symWidth), cy, 2, this.legendShape[idx]);
                        } else {
                            Legend.fillSetArea(g, this.legendColor[idx], curXPos + this.startx, (int)((double)this.ypos + this.starty), this.symWidth + curXPos + this.startx, (int)((double)(this.symWidth + this.ypos) + this.starty), this == g.chart.legend);
                        }
                        this.starty -= (double)this.maxCharWidth + 2.0 * this.distGap;
                        --idx;
                    }
                    curXPos += this.width;
                    this.starty = curYPos;
                }
            }
        } else {
            this.starty += ((double)this.maxCharWidth + 2.0 * this.distGap) * (double)(this.maxNumberOfItemPerCol - 1);
            idx = this.len - 1;
            int curXPos = this.xpos;
            if (this.xIndex > 0 && this.dataLineStr != null) {
                this.starty = this.dataLineStr.length > this.numberOfColumn ? (this.starty += (double)this.maxCharWidth * 1.5 + 2.0 * this.distGap) : (this.starty += (double)this.maxCharWidth + this.distGap * 1.2);
                for (int n = 0; n < this.xIndex; ++n) {
                    curXPos += this.colWidth[n];
                }
            }
            if (this.useOneLegendSet && this.dataLineStr != null && this.dataLineStr.length > 0) {
                if (this.chart.chartType == 3) {
                    curXPos = (int)((double)curXPos * 0.99);
                }
            }
            for (int i = this.xIndex; i < this.len + this.xIndex; ++i) {
                int cy;
                if (i != 0 && i % this.numberOfColumn == 0) {
                    if (this.useOneLegendSet && this.dataLineStr != null && this.dataLineStr.length > 0 && this.numberOfColumn > 1) {
                        this.starty -= (double)this.maxCharWidth * 1.5;
                        curXPos = this.xpos;
                        if (this.chart.chartType == 3) {
                            curXPos = (int)((double)this.xpos * 0.99);
                        }
                    } else {
                        this.starty -= (double)this.maxCharWidth + 2.0 * this.distGap;
                        curXPos = this.xpos;
                    }
                }
                HyperLink lnk = CGraphics.getLink(this.legendData[idx], true);
                this.dataRec[idx] = new Rectangle(curXPos, (int)((double)(this.chart.winHeight - this.ypos) - this.starty - (double)segment), this.width, (int)segment);
                if (lnk != null) {
                    this.chart.cgraphics.enableImageMap();
                    this.chart.cgraphics.maplist.addElement(new ImageMapNode(this.dataRec[idx], lnk.link, lnk.target, lnk.hint));
                }
                int cx = (int)((double)(curXPos + this.startx) + (double)this.symWidth / 2.0);
                if (this.drawSymbols && this.chart.is2DChart && this.legendShape[idx] != 7) {
                    cy = (int)((double)this.ypos + this.starty + (double)this.symWidth / 2.0);
                    new Point3D(cx, cy, this.legendColor[idx], this.legendShape[idx], ptSize, this.getDrawPointBorderColor()).drawPt(g, this.isDrawPointBorder(), this.drawSymbolWithLine, gradientSupport);
                } else if (this.secondAxis || (Chart.isCoordinateType(this.chart.chartType) || this.chart.chartType == 3) && this.chart.is2DChart) {
                    cy = (int)((double)this.ypos + this.starty + (double)this.symWidth / 2.0);
                    if (Chart.isCoordinateType(this.chart.chartType)) {
                        new Point3D(cx, cy, this.legendColor[idx], this.legendShape[idx], ptSize, this.getDrawPointBorderColor()).drawPt(g, this.isDrawPointBorder(), this.drawSymbolWithLine, gradientSupport);
                    } else if (this.chart.comboType == 2) {
                        Legend.fillSetArea(g, this.legendColor[idx], curXPos + this.startx, (int)((double)this.ypos + this.starty), this.symWidth + curXPos + this.startx, (int)((double)(this.symWidth + this.ypos) + this.starty), this == g.chart.legend);
                    } else {
                        Legend.fillSetLine(g, this.legendColor[idx], cx - this.symWidth / 4, cy, (int)((double)cx + 1.25 * (double)this.symWidth), cy, 2, this.legendShape[idx]);
                    }
                } else {
                    Legend.fillSetArea(g, this.legendColor[idx], curXPos + this.startx, (int)((double)this.ypos + this.starty), this.symWidth + curXPos + this.startx, (int)((double)(this.symWidth + this.ypos) + this.starty), this == g.chart.legend);
                }
                curXPos = this.useOneLegendSet && this.dataLineStr != null && this.dataLineStr.length > 0 && this.numberOfColumn > 1 ? (curXPos += this.colWidth[(i + this.numberOfColumn) % this.numberOfColumn]) : (curXPos += this.width);
                --idx;
            }
        }
    }

    public MultiDimData getSelectedData(int x, int y) {
        if (this.dataRec == null) {
            return null;
        }
        for (int i = 0; i < this.dataRec.length; ++i) {
            if (!this.dataRec[i].contains(x, y)) continue;
            return this.legendData[i];
        }
        return null;
    }

    void copyAttrib(Legend lg) {
        if (lg == null) {
            return;
        }
        this.showLegend = lg.showLegend;
        this.area.copy(lg.area);
        this.framearea.copy(lg.framearea);
        this.font = lg.font;
        this.fontangle = lg.fontangle;
        this.fontchanged = lg.fontchanged;
        this.fontcolor = lg.fontcolor;
        this.legendLayout = lg.legendLayout;
        this.fixedColumnCount = lg.fixedColumnCount;
        this.reverse = lg.reverse;
        this.useOneLegendSet = lg.useOneLegendSet;
        this.drawSymbols = lg.drawSymbols;
        this.sepSymbol = lg.sepSymbol;
        this.pointSizeRatio = lg.pointSizeRatio;
    }

    public Object select(CGraphics g, int x, int y) {
        if (!this.cannotDraw()) {
            if (CString.selectStrings(g, x, y, this.legendstr) != null || this.titleStr != null && this.titleStr.select(g, x, y) || this.dataLineStr != null && CString.selectStrings(g, x, y, this.dataLineStr) != null) {
                return this;
            }
            if (this.area.select(g, x, y)) {
                return this.area;
            }
            if (this.framearea.borderSelect(g, x, y)) {
                return this.framearea;
            }
        }
        return null;
    }

    public int getPointSizeRatio() {
        return this.pointSizeRatio;
    }

    public void setPointSizeRatio(int s) {
        this.pointSizeRatio = s;
    }

    public Font getFont() {
        return this.font;
    }

    public int getAngle() {
        return this.fontangle;
    }

    public void setfontColor(Color color) {
        this.fontcolor = color;
        this.init = false;
    }

    public Color getfontColor() {
        return this.fontcolor;
    }

    public void setFont(Font font, int angle) {
        this.font = font;
        this.fontangle = angle;
        this.init = false;
        this.fontchanged = true;
    }

    public void setAngle(int angle) {
        this.fontangle = angle;
        this.init = false;
        this.fontchanged = true;
    }

    public void setBackground(Area area) {
        this.area = area;
    }

    public void setBorder(Area area) {
        this.framearea = area;
    }

    public Area getBackground() {
        return this.area;
    }

    public Area getBorder() {
        return this.framearea;
    }

    private static void fillSetArea(CGraphics g, Color c, int x1, int y1, int x2, int y2, boolean isPrimary) {
        g.setColor(c);
        GradientSupport gradientSupport = g.chart.getPrimaryDataGradientSupport();
        if (!isPrimary) {
            gradientSupport = g.chart.getSecondaryDataGradientSupport();
        }
        g.fillArea(x1, y1, x2, y2, 1, 1, null, false, 0, gradientSupport);
    }

    private static void fillSetLine(CGraphics g, Color c, int x1, int y1, int x2, int y2, int thick, int shape) {
        g.setColor(c);
        g.fillLine(x1, y1, x2, y2, thick, shape);
    }

    private static String formatLabel(Object obj, ColData cd) {
        if (obj instanceof String) {
            return ((String)obj).trim();
        }
        if (obj instanceof CString) {
            return ((CString)obj).str.trim();
        }
        return Chart.formatLabel(obj, cd.dataFormat);
    }

    public void setReverse(boolean state) {
        if (this.reverse != state) {
            this.init = false;
        }
        this.reverse = state;
    }

    public boolean getReverse() {
        return this.reverse;
    }

    public int getLayout() {
        return this.legendLayout;
    }

    private Object[] getPieFname(Object[] fname, ColData cd) {
        PieChart pchart = ((IPieChart)((Object)this.chart)).getPieChart();
        if (this.chart.dataDim == 1 && (pchart.smartlabel || pchart.valInLegend)) {
            int j = 0;
            Object[] fname2 = new Object[fname.length];
            String[] vals = new String[fname.length];
            for (int i = 0; i < this.chart.mDataLen[0]; ++i) {
                if (!cd.showLegend(i, this.hidedata)) continue;
                fname2[j] = Legend.formatLabel(fname[j], cd);
                vals[j] = "";
                if (pchart.smartlabel) {
                    vals[j] = this.getPieSepSymbol() + " " + pchart.formatingPercent(this.mData.multiData[i].plotData.percentage);
                }
                if (pchart.valInLegend) {
                    if (this.mData.multiData[i].plotData.isPieOthersSector()) {
                        int n = j;
                        vals[n] = vals[n] + this.getPieSepSymbol() + " " + pchart.formatingValue(this.mData.multiData[i].plotData.getPieOthersSum());
                    } else {
                        int n = j;
                        vals[n] = vals[n] + this.getPieSepSymbol() + " " + pchart.formatingValue(this.mData.multiData[i].plotData.getValue());
                    }
                }
                fname2[j] = "" + this.cutOffThreshold((String)fname2[j], vals[j].length()) + vals[j];
                ++j;
            }
            return fname2;
        }
        return fname;
    }

    public void setPieSepSymbol(char symbol) {
        this.sepSymbol = symbol;
    }

    public char getPieSepSymbol() {
        return this.sepSymbol;
    }

    private int getDataLineSize() {
        int i;
        int size = 0;
        for (i = 0; i < this.chart.dataLineSet.getSize(); ++i) {
            if (!this.displayDataLineName(this.chart.dataLineSet.elementAt(i))) continue;
            ++size;
        }
        for (i = 0; i < this.chart.getControlRangeList().size(); ++i) {
            if (!this.displayControlRangeName(this.chart.getControlRangeList().elementAt(i))) continue;
            ++size;
        }
        return size;
    }

    private boolean displayDataLineName(DataLine tl) {
        return tl.isTitleVisibleInLegend() && tl.isVisible() && this.secondAxis == tl.isSecondaryValueUsed();
    }

    private boolean displayControlRangeName(ControlRange cc) {
        return this.chart.isControlRangeEnabled() && cc.isShowInLegend();
    }

    private boolean getDataLineName() {
        int i;
        this.dataLineStr = null;
        Vector<Object> list = this.chart.dataLineSet.getDataLineList();
        int size2 = this.getDataLineSize();
        if (size2 == 0) {
            return false;
        }
        this.dataLineStr = new CString[size2];
        this.dataLineColor = new Color[size2];
        int j = 0;
        for (i = 0; i < list.size(); ++i) {
            DataLine dl = list.elementAt(i);
            if (!dl.isVisible() || !this.displayDataLineName(dl)) continue;
            this.dataLineStr[j] = new CString(dl.getTitle(), this.font, new Point3D(), this.fontcolor, 2, this.fontangle);
            this.dataLineColor[j++] = dl.getColor();
        }
        list = this.chart.getControlRangeList();
        for (i = 0; i < list.size(); ++i) {
            ControlRange cc = (ControlRange)list.elementAt(i);
            if (!this.displayControlRangeName(cc)) continue;
            this.dataLineStr[j] = new CString(cc.getTitle(), this.font, new Point3D(), this.fontcolor, 2, this.fontangle);
            this.dataLineColor[j++] = cc.getColor();
        }
        return true;
    }

    private int getRunTimeMaxWidth(FontMetrics fm, Object[] obj, ColData cd, int layout, int numberOfColumn) {
        return this.getRunTimeMaxWidth(fm, obj, cd, layout, numberOfColumn, true);
    }

    int getRunTimeMaxWidth(FontMetrics fm, Object[] obj, ColData cd, int layout, int numberOfColumn, boolean isCutOffAllowed) {
        Object[] str = new String[obj.length];
        for (int i = 0; i < obj.length; ++i) {
            if (obj[i] == null) {
                obj[i] = "";
            }
            str[i] = isCutOffAllowed ? this.getRunTimeValue(Legend.formatLabel(obj[i], cd)) : this.chart.valueTable.getRunTimeValue(Legend.formatLabel(obj[i], cd));
        }
        return this.getMaxWidth(fm, str, cd, layout, numberOfColumn);
    }

    int[] getRunTimeMaxColWidth(FontMetrics fm, ColData cd, int layout, int numberOfColumn) {
        CString[] allStr;
        this.colWidth = new int[numberOfColumn];
        int totalStrNumber = 0;
        if (this.dataLineStr != null && this.dataLineStr.length > 0 && this.legendstr != null && this.legendstr.length > 0) {
            int i;
            totalStrNumber = this.dataLineStr.length + this.legendstr.length;
            allStr = new CString[totalStrNumber];
            for (i = 0; i < this.dataLineStr.length; ++i) {
                allStr[i] = this.dataLineStr[i];
            }
            for (i = 0; i < this.legendstr.length; ++i) {
                allStr[i + this.dataLineStr.length] = this.legendstr[this.legendstr.length - i - 1];
            }
        } else if (this.legendstr != null && this.legendstr.length > 0) {
            totalStrNumber = this.legendstr.length;
            allStr = this.legendstr;
        } else if (this.dataLineStr != null && this.dataLineStr.length > 0) {
            totalStrNumber = this.dataLineStr.length;
            allStr = this.dataLineStr;
        } else {
            totalStrNumber = 0;
            allStr = null;
        }
        if (allStr != null) {
            int maxInCol = totalStrNumber / numberOfColumn + 1;
            Object[][] str = new Object[numberOfColumn][maxInCol];
            for (int i = 0; i < numberOfColumn; ++i) {
                int j = 0;
                for (int k = 0; k < totalStrNumber; ++k) {
                    if (k % numberOfColumn != i) continue;
                    str[i][j] = allStr[k];
                    ++j;
                }
                this.colWidth[i] = this.getRunTimeMaxWidth(fm, str[i], cd, layout, numberOfColumn, true) + 4 * this.symWidth;
            }
        }
        return this.colWidth;
    }

    boolean isDrawPointBorder() {
        if (!this.secondAxis) {
            return this.chart.isDrawPointBorder();
        }
        return this.chart.isDrawPointBorder2();
    }

    Color getDrawPointBorderColor() {
        if (!this.secondAxis) {
            return this.chart.getDrawPointBorderColor();
        }
        return this.chart.getDrawPointBorderColor2();
    }

    private Object[] getLegendNames(ColData cd, boolean b) {
        Object[] names = cd.getLegendNames(b);
        if (this.chart.maxDataLen > 0 && names.length > this.chart.maxDataLen) {
            Object[] newNames = new Object[this.chart.maxDataLen];
            for (int i = 0; i < newNames.length; ++i) {
                newNames[i] = names[i];
            }
            return newNames;
        }
        return names;
    }

    private int getMaxWidth(FontMetrics fm, Object[] obj, ColData cd, int layout, int numberOfColumn) {
        int maxwidth = 0;
        for (int i = 0; i < obj.length; ++i) {
            int wid = fm.stringWidth(Legend.formatLabel(obj[i], cd));
            if (layout == 0) {
                maxwidth += wid;
                continue;
            }
            if (wid <= maxwidth) continue;
            maxwidth = wid;
        }
        return maxwidth;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<< Legend >>\n");
        sb.append("showLegend\t= ").append(this.showLegend).append("\n");
        sb.append("font\t\t= ").append(this.font).append("\n");
        sb.append("fontColor\t= ").append(this.fontcolor).append("\n");
        sb.append("background\t= ").append(this.area);
        sb.append("border\t\t= ").append(this.framearea);
        sb.append("legend layout\t= ").append(this.legendLayout).append("\n");
        sb.append("reverse\t\t= ").append(this.reverse).append("\n");
        return sb.toString();
    }

    public int getWidth() {
        if (!this.init) {
            this.initialize();
        }
        return this.width;
    }

    public int getHeight() {
        if (!this.init) {
            this.initialize();
        }
        return this.height;
    }

    public int getxIndex() {
        return this.xIndex;
    }

    public void setxIndex(int xIndex) {
        this.xIndex = xIndex;
    }
}

