/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import quadbase.chart.CGraphics;
import quadbase.chart.GradientSupport;
import quadbase.chart.ImageMapNode;
import quadbase.chart.MultiDimData;
import quadbase.chart.QbPattern;
import quadbase.common.util.internal.IFlashGraphics;
import quadbase.util.HyperLink;
import quadbase.util.internal.Graphics2DTool;

public class Line {
    public static final int SOLID = 0;
    public static final int DOTTED = 1;
    public static final int LONGDOTTED = 2;
    public static final int DOTLINE = 657921;

    public static boolean pickLine(int x1, int y1, int x2, int y2, int x, int y) {
        int dx = x1 - x2;
        int dy = y1 - y2;
        int r = dx * dx + dy * dy;
        if (r == 0) {
            return (x - x1) * (x - x1) + (y - y1) * (y - y1) < 50;
        }
        double t = (double)(-((x2 - x) * dx + (y2 - y) * dy)) / (double)r;
        if (t < 0.0 || t > 1.0) {
            return false;
        }
        double dx2 = (double)dx * t + (double)x2 - (double)x;
        double dy2 = (double)dy * t + (double)y2 - (double)y;
        return dx2 * dx2 + dy2 * dy2 < 50.0;
    }

    public static final boolean rightside(int x1, int y1, int x2, int y2, int x, int y) {
        return (x2 - x1) * (y - y1) >= (y2 - y1) * (x - x1);
    }

    public static final void drawLine(CGraphics g, int x1, int y1, int x2, int y2, int thick, Color color) {
        Line.drawLine(g, x1, y1, x2, y2, thick, color, null);
    }

    public static final void drawLine(CGraphics g, int x1, int y1, int x2, int y2, int thick, Color color, MultiDimData data, int style, Color borderColor) {
        Line.drawLine(g, x1, y1, x2, y2, thick, color, data, style, borderColor, false);
    }

    public static final void drawLine(CGraphics g, int x1, int y1, int x2, int y2, int thick, Color color, MultiDimData data, int style, Color borderColor, Boolean useLineSyle) {
        double r;
        int dot2;
        int dot1;
        if (style == 0 && useLineSyle.booleanValue()) {
            dot1 = 1;
            dot2 = 0;
        } else if (style == 1 && useLineSyle.booleanValue()) {
            dot1 = 1;
            dot2 = 5;
        } else if (style == 2 && useLineSyle.booleanValue()) {
            dot1 = 20;
            dot2 = 5;
        } else {
            dot1 = (style /= 256) / 256;
            dot2 = style % 256;
        }
        if (dot1 == 0 || dot2 == 0) {
            Line.drawLine(g, x1, y1, x2, y2, thick, color, data);
            return;
        }
        if (dot1 == 255 && dot2 == 255) {
            return;
        }
        int dx = x2 - x1;
        int dy = y2 - y1;
        double dist = Math.sqrt(dx * dx + dy * dy);
        int lastpx = x1;
        int lastpy = y1;
        int cum = 0;
        do {
            double d;
            r = (double)(cum += dot1) / dist;
            if (d >= 1.0) {
                r = 1.0;
            }
            Line.drawLine(g, lastpx, lastpy, (int)Math.round((double)x1 + r * (double)dx), (int)Math.round((double)y1 + r * (double)dy), thick, color, data, false, true, borderColor, true);
            r = (double)(cum += dot2) / dist;
            lastpx = (int)Math.round((double)x1 + r * (double)dx);
            lastpy = (int)Math.round((double)y1 + r * (double)dy);
        } while (r < 1.0);
    }

    public static final void drawLine(CGraphics g, int x1, int y1, int x2, int y2, int thick, Color color, MultiDimData data) {
        Line.drawLine(g, x1, y1, x2, y2, thick, color, data, false);
    }

    public static final void drawLine(CGraphics g, int x1, int y1, int x2, int y2, int thick, Color color, MultiDimData data, boolean drawBorder) {
        Line.drawLine(g, x1, y1, x2, y2, thick, color, data, drawBorder, true);
    }

    public static final void drawLine(CGraphics g, int x1, int y1, int x2, int y2, int thick, Color color, MultiDimData data, boolean drawBorder, boolean draw3DRect) {
        Line.drawLine(g, x1, y1, x2, y2, thick, color, data, drawBorder, draw3DRect, Color.black);
    }

    public static final void drawLine(CGraphics g, int x1, int y1, int x2, int y2, int thick, Color color, MultiDimData data, boolean drawBorder, boolean draw3DRect, Color borderColor) {
        Line.drawLine(g, x1, y1, x2, y2, thick, color, data, drawBorder, draw3DRect, borderColor, true);
    }

    public static final void drawLine(CGraphics g, int x1, int y1, int x2, int y2, int thick, Color color, MultiDimData data, boolean drawBorder, boolean draw3DRect, Color borderColor, boolean isSolid) {
        Graphics2D g2D;
        boolean useOldDraw;
        if (thick <= 0) {
            return;
        }
        HyperLink lnk = null;
        if (data != null && g.imagemap) {
            lnk = CGraphics.getLink(data);
        }
        g.setColor(color);
        if (thick == 1) {
            boolean setToolTipsForFlash = false;
            if (g.g instanceof IFlashGraphics && data != null) {
                setToolTipsForFlash = true;
                ((IFlashGraphics)((Object)g.g)).setToolTipsAndLink(data);
            }
            g.g.drawLine(x1, y1, x2, y2);
            if (lnk != null) {
                int[] xcoord2 = new int[4];
                int[] ycoord2 = new int[4];
                xcoord2[0] = x1;
                xcoord2[1] = x1;
                xcoord2[2] = x2;
                xcoord2[3] = x2;
                ycoord2[0] = y1;
                ycoord2[1] = y1;
                ycoord2[2] = y2;
                ycoord2[3] = y2;
                g.maplist.addElement(new ImageMapNode(new Polygon(xcoord2, ycoord2, 4), lnk.link, lnk.target, lnk.hint));
            }
            if (setToolTipsForFlash) {
                ((IFlashGraphics)((Object)g.g)).resetToolTipsAndLink();
            }
            return;
        }
        double slope = x1 - x2;
        int halfThickness = thick / 2;
        int[] xcoord = new int[4];
        int[] ycoord = new int[4];
        boolean isPatternDrawing = color instanceof QbPattern && (((QbPattern)color).getPatternTypeID() != 0 || ((QbPattern)color).getPatternImage() != null);
        boolean bl = useOldDraw = !(g.g instanceof Graphics2D) || isPatternDrawing;
        if (slope == 0.0) {
            if (y2 > y1) {
                int tmpY = y1;
                y1 = y2;
                y2 = tmpY;
            }
            if (useOldDraw) {
                if (!drawBorder) {
                    if (g.chart.isShowShadowOnLine() && draw3DRect) {
                        g.fillRect(x2 - halfThickness, y2, 2 * halfThickness, y1 - y2, 1);
                    } else {
                        g.fillRect(x2 - halfThickness, y2, 2 * halfThickness, y1 - y2, 0);
                    }
                } else {
                    g.fillRect(x2 - halfThickness, y2, 2 * halfThickness, y1 - y2, 0);
                    g.g.setColor(borderColor);
                    g.g.drawRect(x2 - halfThickness, y2, 2 * halfThickness, y1 - y2);
                    g.g.setColor(color);
                }
            }
            if (lnk != null) {
                g.maplist.addElement(new ImageMapNode(new Rectangle(x2 - halfThickness, y2, 2 * halfThickness, y1 - y2), lnk.link, lnk.target, lnk.hint));
            }
            if (!isPatternDrawing && useOldDraw) {
                return;
            }
        } else if ((slope = (double)(y1 - y2) / slope) == 0.0) {
            if (x1 > x2) {
                int tmpX = x1;
                x1 = x2;
                x2 = tmpX;
            }
            if (useOldDraw) {
                if (!drawBorder) {
                    if (g.chart.isShowShadowOnLine() && draw3DRect) {
                        g.fillRect(x1, y1 - halfThickness, x2 - x1, 2 * halfThickness, 1);
                    } else {
                        g.fillRect(x1, y1 - halfThickness, x2 - x1, 2 * halfThickness, 0);
                    }
                } else {
                    g.fillRect(x1, y1 - halfThickness, x2 - x1, 2 * halfThickness, 0);
                    g.g.setColor(borderColor);
                    g.g.drawRect(x1, y1 - halfThickness, x2 - x1, 2 * halfThickness);
                    g.g.setColor(color);
                }
            }
            if (lnk != null) {
                g.maplist.addElement(new ImageMapNode(new Rectangle(x1, y1 - halfThickness, x2 - x1, 2 * halfThickness), lnk.link, lnk.target, lnk.hint));
            }
            if (useOldDraw) {
                return;
            }
        } else {
            slope = -1.0 / slope;
            double s = (double)halfThickness / Math.sqrt(1.0 + slope * slope);
            double s1 = slope * s;
            if (slope > 0.0) {
                xcoord[0] = (int)Math.round((double)x1 - s);
                ycoord[0] = (int)Math.round((double)y1 - s1);
                xcoord[1] = (int)Math.round((double)x1 + s);
                ycoord[1] = (int)Math.round((double)y1 + s1);
                xcoord[3] = (int)Math.round((double)x2 - s);
                ycoord[3] = (int)Math.round((double)y2 - s1);
                xcoord[2] = (int)Math.round((double)x2 + s);
                ycoord[2] = (int)Math.round((double)y2 + s1);
            } else {
                xcoord[1] = (int)Math.round((double)x1 - s);
                ycoord[1] = (int)Math.round((double)y1 - s1);
                xcoord[0] = (int)Math.round((double)x1 + s);
                ycoord[0] = (int)Math.round((double)y1 + s1);
                xcoord[2] = (int)Math.round((double)x2 - s);
                ycoord[2] = (int)Math.round((double)y2 - s1);
                xcoord[3] = (int)Math.round((double)x2 + s);
                ycoord[3] = (int)Math.round((double)y2 + s1);
            }
            if (lnk != null) {
                g.maplist.addElement(new ImageMapNode(new Polygon(xcoord, ycoord, 4), lnk.link, lnk.target, lnk.hint));
            }
        }
        g.setColor(color);
        int[] r_ycoord = new int[ycoord.length];
        for (int i = 0; i < ycoord.length; ++i) {
            r_ycoord[i] = g.height - ycoord[i];
        }
        Paint originalPaint = null;
        if (g.g instanceof Graphics2D && !isPatternDrawing) {
            g2D = (Graphics2D)g.g;
            Stroke origStroke = g2D.getStroke();
            if (isSolid) {
                g2D.setStroke(new BasicStroke(thick, 1, 0));
            } else {
                g2D.setStroke(new BasicStroke(thick, 0, 2));
            }
            if (g.chart.isShowShadowOnLine() && draw3DRect || drawBorder) {
                Color origColor = g2D.getColor();
                g2D.setColor(drawBorder ? borderColor : color.brighter());
                g2D.drawLine(x1 - 1, y1 - 1, x2 - 1, y2 - 1);
                if (!drawBorder) {
                    g2D.setColor(color.darker());
                }
                g2D.drawLine(x1 + 1, y1 + 1, x2 + 1, y2 + 1);
                g2D.setColor(origColor);
            }
            GradientSupport gradientSupport = null;
            if (data != null) {
                gradientSupport = data.isPrimary() ? g.chart.getPrimaryDataGradientSupport() : g.chart.getSecondaryDataGradientSupport();
            }
            if (gradientSupport != null && gradientSupport.isGradientEnabled()) {
                int gradientShade = gradientSupport.getGradientShade();
                originalPaint = g2D.getPaint();
                Color gradientDesColor = gradientSupport.getGradientDesColor();
                Color color2 = gradientDesColor == null ? (gradientShade > 0 ? Graphics2DTool.getDarker(g2D.getColor(), gradientShade) : Graphics2DTool.getBrighter(g2D.getColor(), Math.abs(gradientShade))) : gradientDesColor;
                GradientPaint gp = new GradientPaint(x1 + (int)((double)x2 * gradientSupport.getGradientStartX()), y1 + (int)((double)y2 * gradientSupport.getGradientStartY()), g2D.getColor(), (int)((double)x2 * gradientSupport.getGradientEndX()), (int)((double)y2 * gradientSupport.getGradientEndY()), color2, gradientSupport.isGradientCyclic());
                g2D.setPaint(gp);
            }
            g2D.drawLine(x1, y1, x2, y2);
            g2D.setStroke(origStroke);
        } else {
            Polygon poly = new Polygon(xcoord, r_ycoord, 4);
            g.fillPolygon(poly, data);
        }
        if (useOldDraw) {
            if (drawBorder) {
                g.g.setColor(borderColor);
                g.g.drawLine(xcoord[0], ycoord[0], xcoord[3], ycoord[3]);
                g.g.drawLine(xcoord[1], ycoord[1], xcoord[2], ycoord[2]);
                g.g.drawLine(xcoord[2], ycoord[2], xcoord[3], ycoord[3]);
                g.g.drawLine(xcoord[0], ycoord[0], xcoord[1], ycoord[1]);
                g.g.setColor(color);
            } else if (g.chart.isShowShadowOnLine() && draw3DRect) {
                g.g.setColor(color.brighter());
                g.g.drawLine(xcoord[0], ycoord[0], xcoord[3], ycoord[3]);
                g.g.drawLine(xcoord[0], ycoord[0], xcoord[1], ycoord[1]);
                g.g.setColor(color.darker());
                g.g.drawLine(xcoord[1], ycoord[1], xcoord[2], ycoord[2]);
                g.g.drawLine(xcoord[2], ycoord[2], xcoord[3], ycoord[3]);
                g.g.setColor(color);
            }
        }
        if (g.g instanceof Graphics2D && originalPaint != null) {
            g2D = (Graphics2D)g.g;
            g2D.setPaint(originalPaint);
        }
    }

    public static final void drawPointedBlade(CGraphics g, int x1, int y1, int x2, int y2, int thick, Color color, MultiDimData data, boolean drawBorder, boolean draw3DRect) {
        int x3 = x1 + (int)((double)(x2 - x1) * 0.95);
        int y3 = y1 + (int)((double)(y2 - y1) * 0.95);
        HyperLink lnk = null;
        if (data != null && g.imagemap) {
            lnk = CGraphics.getLink(data);
        }
        g.g.setColor(color);
        if (thick == 1) {
            g.g.drawLine(x1, y1, x2, y2);
            if (lnk != null) {
                int[] xcoord2 = new int[4];
                int[] ycoord2 = new int[4];
                xcoord2[0] = x1;
                xcoord2[1] = x1;
                xcoord2[2] = x2;
                xcoord2[3] = x2;
                ycoord2[0] = y1;
                ycoord2[1] = y1;
                ycoord2[2] = y2;
                ycoord2[3] = y2;
                g.maplist.addElement(new ImageMapNode(new Polygon(xcoord2, ycoord2, 4), lnk.link, lnk.target, lnk.hint));
            }
            return;
        }
        double slope = x1 - x2;
        int hthick = thick * 3 / 4;
        int[] xcoord = new int[5];
        int[] ycoord = new int[5];
        if (slope == 0.0) {
            xcoord[0] = Math.round(x1 - thick);
            ycoord[0] = Math.round(y1);
            xcoord[1] = Math.round(x1 + thick);
            ycoord[1] = Math.round(y1);
            xcoord[4] = Math.round(x3 - hthick);
            ycoord[4] = Math.round(y3);
            xcoord[2] = Math.round(x3 + hthick);
            ycoord[2] = Math.round(y3);
            xcoord[3] = Math.round(x2);
            ycoord[3] = Math.round(y2);
        } else if ((slope = (double)(y1 - y2) / slope) == 0.0) {
            xcoord[0] = Math.round(x1);
            ycoord[0] = Math.round(y1 - thick);
            xcoord[1] = Math.round(x1);
            ycoord[1] = Math.round(y1 + thick);
            xcoord[4] = Math.round(x3);
            ycoord[4] = Math.round(y3 - hthick);
            xcoord[2] = Math.round(x3);
            ycoord[2] = Math.round(y3 + hthick);
            xcoord[3] = Math.round(x2);
            ycoord[3] = Math.round(y2);
        } else {
            slope = -1.0 / slope;
            double s = (double)thick / Math.sqrt(1.0 + slope * slope);
            double s1 = slope * s;
            double h = (double)hthick / Math.sqrt(1.0 + slope * slope);
            double h1 = slope * h;
            if (slope > 0.0) {
                xcoord[0] = (int)Math.round((double)x1 - s);
                ycoord[0] = (int)Math.round((double)y1 - s1);
                xcoord[1] = (int)Math.round((double)x1 + s);
                ycoord[1] = (int)Math.round((double)y1 + s1);
                xcoord[4] = (int)Math.round((double)x3 - h);
                ycoord[4] = (int)Math.round((double)y3 - h1);
                xcoord[2] = (int)Math.round((double)x3 + h);
                ycoord[2] = (int)Math.round((double)y3 + h1);
                xcoord[3] = Math.round(x2);
                ycoord[3] = Math.round(y2);
            } else {
                xcoord[1] = (int)Math.round((double)x1 - s);
                ycoord[1] = (int)Math.round((double)y1 - s1);
                xcoord[0] = (int)Math.round((double)x1 + s);
                ycoord[0] = (int)Math.round((double)y1 + s1);
                xcoord[2] = (int)Math.round((double)x3 - h);
                ycoord[2] = (int)Math.round((double)y3 - h1);
                xcoord[4] = (int)Math.round((double)x3 + h);
                ycoord[4] = (int)Math.round((double)y3 + h1);
                xcoord[3] = Math.round(x2);
                ycoord[3] = Math.round(y2);
            }
        }
        g.setColor(color);
        int[] r_ycoord = new int[ycoord.length];
        for (int i = 0; i < ycoord.length; ++i) {
            r_ycoord[i] = g.height - ycoord[i];
        }
        Polygon poly = new Polygon(xcoord, r_ycoord, 5);
        g.fillPolygon(poly, data);
        if (lnk != null) {
            g.maplist.addElement(new ImageMapNode(new Polygon(xcoord, ycoord, 5), lnk.link, lnk.target, lnk.hint));
        }
        if (drawBorder) {
            g.g.setColor(Color.black);
            g.g.drawLine(xcoord[0], ycoord[0], xcoord[4], ycoord[4]);
            g.g.drawLine(xcoord[1], ycoord[1], xcoord[2], ycoord[2]);
            g.g.drawLine(xcoord[2], ycoord[2], xcoord[3], ycoord[3]);
            g.g.drawLine(xcoord[0], ycoord[0], xcoord[1], ycoord[1]);
            g.g.drawLine(xcoord[3], ycoord[3], xcoord[4], ycoord[4]);
            g.g.setColor(color);
        } else if (g.chart.isShowShadowOnLine() && draw3DRect) {
            g.g.setColor(color.brighter());
            g.g.drawLine(xcoord[0], ycoord[0], xcoord[4], ycoord[4]);
            g.g.drawLine(xcoord[3], ycoord[3], xcoord[4], ycoord[4]);
            g.g.setColor(color.darker());
            g.g.drawLine(xcoord[1], ycoord[1], xcoord[2], ycoord[2]);
            g.g.drawLine(xcoord[2], ycoord[2], xcoord[3], ycoord[3]);
            g.g.setColor(color);
        }
    }

    public static final void drawTriangularPointer(CGraphics g, int x1, int y1, int x2, int y2, int thick, Color color, MultiDimData data, boolean drawBorder, boolean draw3DRect) {
        HyperLink lnk = null;
        if (data != null && g.imagemap) {
            lnk = CGraphics.getLink(data);
        }
        g.g.setColor(color);
        if (thick == 1) {
            g.g.drawLine(x1, y1, x2, y2);
            if (lnk != null) {
                int[] xcoord2 = new int[4];
                int[] ycoord2 = new int[4];
                xcoord2[0] = x1;
                xcoord2[1] = x1;
                xcoord2[2] = x2;
                xcoord2[3] = x2;
                ycoord2[0] = y1;
                ycoord2[1] = y1;
                ycoord2[2] = y2;
                ycoord2[3] = y2;
                g.maplist.addElement(new ImageMapNode(new Polygon(xcoord2, ycoord2, 4), lnk.link, lnk.target, lnk.hint));
            }
            return;
        }
        double slope = x1 - x2;
        int hthick = thick * 3 / 4;
        int[] xcoord = new int[3];
        int[] ycoord = new int[3];
        if (slope == 0.0) {
            xcoord[0] = Math.round(x1 - thick);
            ycoord[0] = Math.round(y1);
            xcoord[1] = Math.round(x1 + thick);
            ycoord[1] = Math.round(y1);
            xcoord[2] = Math.round(x2);
            ycoord[2] = Math.round(y2);
        } else if ((slope = (double)(y1 - y2) / slope) == 0.0) {
            xcoord[0] = Math.round(x1);
            ycoord[0] = Math.round(y1 - thick);
            xcoord[1] = Math.round(x1);
            ycoord[1] = Math.round(y1 + thick);
            xcoord[2] = Math.round(x2);
            ycoord[2] = Math.round(y2);
        } else {
            slope = -1.0 / slope;
            double s = (double)thick / Math.sqrt(1.0 + slope * slope);
            double s1 = slope * s;
            double h = (double)hthick / Math.sqrt(1.0 + slope * slope);
            if (slope > 0.0) {
                xcoord[0] = (int)Math.round((double)x1 - s);
                ycoord[0] = (int)Math.round((double)y1 - s1);
                xcoord[1] = (int)Math.round((double)x1 + s);
                ycoord[1] = (int)Math.round((double)y1 + s1);
                xcoord[2] = Math.round(x2);
                ycoord[2] = Math.round(y2);
            } else {
                xcoord[1] = (int)Math.round((double)x1 - s);
                ycoord[1] = (int)Math.round((double)y1 - s1);
                xcoord[0] = (int)Math.round((double)x1 + s);
                ycoord[0] = (int)Math.round((double)y1 + s1);
                xcoord[2] = Math.round(x2);
                ycoord[2] = Math.round(y2);
            }
        }
        g.setColor(color);
        int[] r_ycoord = new int[ycoord.length];
        for (int i = 0; i < ycoord.length; ++i) {
            r_ycoord[i] = g.height - ycoord[i];
        }
        Polygon poly = new Polygon(xcoord, r_ycoord, 3);
        g.fillPolygon(poly, data);
        if (lnk != null) {
            g.maplist.addElement(new ImageMapNode(new Polygon(xcoord, ycoord, 3), lnk.link, lnk.target, lnk.hint));
        }
        if (drawBorder) {
            g.g.setColor(Color.black);
            g.g.drawLine(xcoord[0], ycoord[0], xcoord[2], ycoord[2]);
            g.g.drawLine(xcoord[1], ycoord[1], xcoord[2], ycoord[2]);
            g.g.drawLine(xcoord[0], ycoord[0], xcoord[1], ycoord[1]);
            g.g.setColor(color);
        } else if (g.chart.isShowShadowOnLine() && draw3DRect) {
            g.g.setColor(color.brighter());
            g.g.drawLine(xcoord[0], ycoord[0], xcoord[2], ycoord[2]);
            g.g.setColor(color.darker());
            g.g.drawLine(xcoord[1], ycoord[1], xcoord[2], ycoord[2]);
            g.g.setColor(color);
        }
    }

    public static final void drawRoundBlade(CGraphics g, int x1, int y1, int x2, int y2, int thick, Color color, MultiDimData data, boolean draw3DRect) {
        int x3 = x1 + (int)((double)(x2 - x1) * 0.98);
        int y3 = y1 + (int)((double)(y2 - y1) * 0.98);
        HyperLink lnk = null;
        if (data != null && g.imagemap) {
            lnk = CGraphics.getLink(data);
        }
        g.g.setColor(color);
        if (thick == 1) {
            g.g.drawLine(x1, y1, x2, y2);
            if (lnk != null) {
                int[] xcoord2 = new int[4];
                int[] ycoord2 = new int[4];
                xcoord2[0] = x1;
                xcoord2[1] = x1;
                xcoord2[2] = x2;
                xcoord2[3] = x2;
                ycoord2[0] = y1;
                ycoord2[1] = y1;
                ycoord2[2] = y2;
                ycoord2[3] = y2;
                g.maplist.addElement(new ImageMapNode(new Polygon(xcoord2, ycoord2, 4), lnk.link, lnk.target, lnk.hint));
            }
            return;
        }
        double slope = x1 - x2;
        int hthick = thick * 3 / 4;
        int[] xcoord = new int[4];
        int[] ycoord = new int[4];
        if (slope == 0.0) {
            xcoord[0] = Math.round(x1 - thick);
            ycoord[0] = Math.round(y1);
            xcoord[1] = Math.round(x1 + thick);
            ycoord[1] = Math.round(y1);
            xcoord[3] = Math.round(x3 - hthick);
            ycoord[3] = Math.round(y3);
            xcoord[2] = Math.round(x3 + hthick);
            ycoord[2] = Math.round(y3);
        } else if ((slope = (double)(y1 - y2) / slope) == 0.0) {
            xcoord[0] = Math.round(x1);
            ycoord[0] = Math.round(y1 - thick);
            xcoord[1] = Math.round(x1);
            ycoord[1] = Math.round(y1 + thick);
            xcoord[3] = Math.round(x3);
            ycoord[3] = Math.round(y3 - hthick);
            xcoord[2] = Math.round(x3);
            ycoord[2] = Math.round(y3 + hthick);
        } else {
            slope = -1.0 / slope;
            double s = (double)thick / Math.sqrt(1.0 + slope * slope);
            double s1 = slope * s;
            double h = (double)hthick / Math.sqrt(1.0 + slope * slope);
            double h1 = slope * h;
            if (slope > 0.0) {
                xcoord[0] = (int)Math.round((double)x1 - s);
                ycoord[0] = (int)Math.round((double)y1 - s1);
                xcoord[1] = (int)Math.round((double)x1 + s);
                ycoord[1] = (int)Math.round((double)y1 + s1);
                xcoord[3] = (int)Math.round((double)x3 - h);
                ycoord[3] = (int)Math.round((double)y3 - h1);
                xcoord[2] = (int)Math.round((double)x3 + h);
                ycoord[2] = (int)Math.round((double)y3 + h1);
            } else {
                xcoord[1] = (int)Math.round((double)x1 - s);
                ycoord[1] = (int)Math.round((double)y1 - s1);
                xcoord[0] = (int)Math.round((double)x1 + s);
                ycoord[0] = (int)Math.round((double)y1 + s1);
                xcoord[2] = (int)Math.round((double)x3 - h);
                ycoord[2] = (int)Math.round((double)y3 - h1);
                xcoord[3] = (int)Math.round((double)x3 + h);
                ycoord[3] = (int)Math.round((double)y3 + h1);
            }
        }
        g.setColor(color);
        g.fillArc(x3, g.height - y3, hthick * 2, hthick * 2, 0, 360, data, draw3DRect && g.chart.isShowShadowOnLine(), true, color);
        int[] r_ycoord = new int[ycoord.length];
        for (int i = 0; i < ycoord.length; ++i) {
            r_ycoord[i] = g.height - ycoord[i];
        }
        Polygon poly = new Polygon(xcoord, r_ycoord, 4);
        g.setColor(color);
        g.fillPolygon(poly, data);
        if (lnk != null) {
            g.maplist.addElement(new ImageMapNode(new Polygon(xcoord, ycoord, 4), lnk.link, lnk.target, lnk.hint));
        }
        if (g.chart.isShowShadowOnLine() && draw3DRect) {
            g.g.setColor(color.brighter());
            g.g.drawLine(xcoord[0], ycoord[0], xcoord[3], ycoord[3]);
            g.g.setColor(color.darker());
            g.g.drawLine(xcoord[1], ycoord[1], xcoord[2], ycoord[2]);
            g.g.setColor(color);
        }
    }

    static final int stylefn(int s1, int s2) {
        return s2 * 256 + s1 % 256;
    }
}

