/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.chart.Area;
import quadbase.chart.Axis;
import quadbase.chart.CString;
import quadbase.chart.Chart;
import quadbase.chart.ChartColorSet;
import quadbase.chart.ColData;
import quadbase.chart.DBAccess;
import quadbase.chart.DataAttribute;
import quadbase.chart.DataFileInput;
import quadbase.chart.DrillDownInfo;
import quadbase.chart.DrillDownNode;
import quadbase.chart.EJBAccess;
import quadbase.chart.ExcelAccess;
import quadbase.chart.GradientSupport;
import quadbase.chart.GraphicsTable;
import quadbase.chart.HiLowMap;
import quadbase.chart.IOUtil2;
import quadbase.chart.IPieChart;
import quadbase.chart.Legend;
import quadbase.chart.OLAPAccess;
import quadbase.chart.PieChart;
import quadbase.chart.PreprocInfo;
import quadbase.chart.PropCString;
import quadbase.chart.ReadDataFile;
import quadbase.chart.SOAPAccess;
import quadbase.chart.SalesForceAccess;
import quadbase.chart.chart2d.Axis2D;
import quadbase.common.client.FileInfo;
import quadbase.common.client.ServerMessage;
import quadbase.common.paramquery.QueryClassFileInfo;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryMultiValueInParam;
import quadbase.common.paramquery.QueryXMLFileInfo;
import quadbase.common.paramquery.SOAPQueryFileInfo;
import quadbase.common.paramquery.SalesForceQueryFileInfo;
import quadbase.common.paramquery.UseDefaultParam;
import quadbase.common.util.internal.Coder;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.EJBInfo;
import quadbase.common.util.internal.EJBUtil;
import quadbase.common.util.internal.ExcelFileInfo;
import quadbase.common.util.internal.FileInMemTable;
import quadbase.common.util.internal.QbUtil;
import quadbase.common.util.internal.VersioningDataInput;
import quadbase.common.util.internal.XMLFileQueryInfo;
import quadbase.util.ControlRange;
import quadbase.util.HyperLink;
import quadbase.util.IAnnotation;
import quadbase.util.IFormat;
import quadbase.util.LogicalFormat;
import quadbase.util.PolyLine;
import quadbase.util.internal.IOUtil;
import quadbase.util.internal.TransposeRS;

public class LoadChart {
    private static final Logger LOGGER = Logger.getLogger(LoadChart.class.getName());
    protected DBInfoBasic dbInfo;
    Connection connection;
    String filename = null;
    protected int version;
    Vector parameters;
    protected int sourceData;
    protected int originalSourceData = -1;
    protected String sourceFile;
    protected XMLFileQueryInfo xmlFileQueryInfo;
    protected SOAPQueryFileInfo soapInfo;
    protected SalesForceQueryFileInfo sfQueryInfo;
    protected ExcelFileInfo excelInfo;
    protected String jndiName;
    protected String homeName;
    protected String remoteName;
    protected String selectedMethodName;
    protected Object[] selectedMethodParamVal;
    protected Hashtable<String, String> environment;
    protected String mondrianConnectionString;
    protected String MDXQuery;
    protected String xmlaURI;
    protected String xmlaDataSource;
    protected String xmlaCatalog;
    protected int inputMethod;
    protected ColData[] originalColDataFromMemSource;
    protected ColData[] backupColData;
    protected Object[] sourceList;
    protected int[] sourceType;
    protected boolean[] doTranspose;
    protected Object[] transposeColList;
    boolean hasQueryFilename;
    protected String queryFilename;
    protected QueryFileInfo queryFileInfo;
    protected boolean istemplate = false;
    boolean isUTFString;
    protected boolean isTransposed;
    protected boolean[] transposeCol;
    boolean drillDownPresent = false;
    boolean isDynamicDrillDown = false;
    int primaryAggregate = -1;
    int secondaryAggregate = -1;
    String drillTemplateName = null;
    Vector drillVector = null;
    protected Boolean modTranspose;
    protected boolean[] modTransposeCol;
    protected boolean[] modTransposeArr;
    protected String[] modDataSourceArr;
    protected Object[] modTransposeColArr;
    boolean retrieveColInfoOnly = false;
    private boolean forReport = false;
    Hashtable<String, String> fontMapping = null;
    protected DrillDownNode drillDownNode = null;
    protected Vector<DrillDownNode> childDrillDownNodes = null;
    protected Vector preSetParams = null;
    protected boolean useDefaults = false;
    protected Color axisColor = null;
    protected FileInMemTable subFilesTable = null;
    protected boolean pack = false;
    protected String errorMessage = null;
    protected boolean usingBackupData = false;
    private boolean dontExpandSubFilesForPac = false;

    public Chart loadTemplate(Chart chart, DataInput in) throws IOException {
        if (in.readInt() != 22071) {
            throw new IOException("Not a valid chart file format !\n");
        }
        this.istemplate = true;
        return this.loadData(chart.component, in, chart.colData, chart, false, true);
    }

    public Chart load(Component component, DataInput in) throws IOException {
        return this.load(component, in, false, null);
    }

    public Chart loadChartFromReport(DataInput in, ColData[] colData) throws IOException {
        if (colData != null) {
            this.forReport = true;
        }
        Component comp = ServerMessage.getComponent();
        Chart tmpChart = this.load(comp, in, colData != null, colData, true);
        tmpChart.sourceData = 0;
        return tmpChart;
    }

    public Chart loadChartFromReport(DataInput in, ColData[] colData, boolean isTemplate) throws IOException {
        if (colData != null) {
            this.forReport = true;
        }
        Component comp = ServerMessage.getComponent();
        Chart tmpChart = this.load(comp, in, isTemplate, colData, true);
        tmpChart.sourceData = 0;
        return tmpChart;
    }

    public Chart load(Component component, DataInput in, boolean template, ColData[] colData) throws IOException {
        return this.load(component, in, template, colData, false);
    }

    public Chart load(Component component, DataInput in, boolean template, ColData[] colData, boolean forEntpServer) throws IOException {
        int magicNo = in.readInt();
        if (magicNo != 22071) {
            throw new IOException("Not a valid chart file!");
        }
        if (!template) {
            this.version = in.readInt();
            if (this.version >= 302) {
                String registryID = IOUtil.readString(in, true);
                String dataSourceID = IOUtil.readString(in, true);
                String string = IOUtil.readString(in, true);
            }
            if (this.version < 79) {
                throw new IOException("Load: EspressChart 1.4 file is not suppoted!");
            }
            this.hasQueryFilename = false;
            this.hasQueryFilename = in.readBoolean();
            if (!this.hasQueryFilename) {
                this.isUTFString = true;
                colData = this.createColData(in, this.version);
            }
            return this.loadData(component, in, colData, null, false, forEntpServer);
        }
        return this.loadData(component, in, colData, null, true, forEntpServer);
    }

    public Chart loadChartFromFile(Component comp, String urlName, Vector params) throws Exception {
        return this.loadChartFromFile(comp, urlName, params, false);
    }

    public void setSubFilesTable(FileInMemTable subTbl) {
        this.subFilesTable = subTbl;
    }

    public void setDontExpandSubFilesForPac(boolean b) {
        this.dontExpandSubFilesForPac = b;
    }

    public void setParameterField(Vector<QueryInParamSet> params) {
        this.preSetParams = params;
    }

    public void setUsingBackupData(boolean b) {
        this.usingBackupData = b;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Chart loadChartFromFile(Component component, String urlName, Vector<QueryInParamSet> params, boolean isEntpServer) throws Exception {
        ReadDataFile readFile = new ReadDataFile();
        DataInputStream in = readFile.getInputStream(this.subFilesTable, urlName);
        this.preSetParams = params;
        Chart tmp = this.load(component, in, urlName.toUpperCase().endsWith(".TPL"), null, isEntpServer);
        tmp.mergeSubFilesTable(this.subFilesTable);
        in.close();
        readFile.close();
        return tmp;
    }

    public void modifyDataSource(Boolean transpose, boolean[] transposeCol, boolean[] doTranspose, Object[] transposeColList, String[] dataSource) {
        this.modTranspose = transpose;
        this.modTransposeCol = transposeCol;
        this.modTransposeArr = doTranspose;
        this.modDataSourceArr = dataSource;
        this.modTransposeColArr = transposeColList;
    }

    public void loadDataHeaderOnly(String urlname) throws Exception {
        ReadDataFile readfile = new ReadDataFile();
        DataInputStream in = readfile.getInputStream(this.subFilesTable, urlname);
        if (in.readInt() != 22071) {
            throw new IOException("Not a valid chart file!");
        }
        this.version = in.readInt();
        if (this.version >= 302) {
            String registryID = IOUtil.readString(in, true);
            String dataSourceID = IOUtil.readString(in, true);
            String string = IOUtil.readString(in, true);
        }
        if (this.version >= 230) {
            this.loadTree(in);
        }
        this.loadDataHeader(in);
        readfile.close();
    }

    public static String[] loadDataSourceID(String filename) throws Exception {
        ReadDataFile readfile = new ReadDataFile();
        String[] result = LoadChart.loadDataSourceID(readfile.getInputStream(filename));
        readfile.close();
        return result;
    }

    public static String[] loadDataSourceID(DataInput in) throws Exception {
        String[] result = null;
        in.readInt();
        int version = in.readInt();
        if (version >= 302) {
            result = new String[]{IOUtil.readString(in, true), IOUtil.readString(in, true), IOUtil.readString(in, true)};
        }
        return result;
    }

    void loadDataHeader(DataInput in) throws IOException {
        this.sourceData = in.readInt();
        this.backupColData = null;
        if (this.version >= 280 && this.sourceData != 0 && this.sourceData != 14) {
            this.backupColData = this.createColData(in, this.version);
        }
        if (this.sourceData == 1) {
            String urlText = null;
            String driverText = null;
            String nameText = null;
            String query = null;
            String pwdText = null;
            if (this.version > 91) {
                this.dbInfo = DBInfoBasic.read(in, this.version);
                if (this.modDataSourceArr != null) {
                    this.dbInfo.setQuery(this.modDataSourceArr[0]);
                }
            } else {
                urlText = Coder.decode(IOUtil.readString(in, this.isUTFString), this.version);
                driverText = Coder.decode(IOUtil.readString(in, this.isUTFString), this.version);
                nameText = Coder.decode(IOUtil.readString(in, this.isUTFString), this.version);
                query = Coder.decode(IOUtil.readString(in, this.isUTFString), this.version);
                pwdText = Coder.decode(IOUtil.readString(in, this.isUTFString), this.version);
                if (this.modDataSourceArr != null) {
                    query = this.modDataSourceArr[0];
                }
                this.dbInfo = new DBInfoBasic(urlText, driverText, nameText, pwdText, query);
            }
            if (this.hasQueryFilename) {
                this.queryFilename = Coder.decode(IOUtil.readString(in, this.isUTFString), this.version);
            } else if (this.version > 207) {
                int n = in.readInt();
                QueryInParam[] params = new QueryInParam[n];
                if (n > 0) {
                    for (int i = 0; i < n; ++i) {
                        params[i] = QueryInParam.read(in, 0);
                    }
                    this.dbInfo = Chart.isForExportOnly() ? new QueryFileInfo("", 0, this.dbInfo, new QueryInParamSet(params)) : new QueryFileInfo("", 0, this.dbInfo, new QueryInParamSet(params));
                }
                this.queryFileInfo = null;
                this.queryFilename = null;
            }
            if (this.queryFilename != null && !this.queryFilename.equals("")) {
                if (Chart.isForExportOnly()) {
                    this.dbInfo = QueryFileInfo.readFile(this.queryFilename);
                } else {
                    this.queryFileInfo = QueryFileInfo.readFile(this.queryFilename);
                    this.dbInfo = this.queryFileInfo;
                }
            }
        } else if (this.sourceData == 2 || this.sourceData == 6 || this.sourceData == 4) {
            boolean isParamClass;
            this.sourceFile = Coder.decode(IOUtil.readString(in, this.isUTFString), this.version);
            if (this.modDataSourceArr != null) {
                this.sourceFile = this.modDataSourceArr[0];
            }
            this.dbInfo = null;
            if (this.version >= 233 && (isParamClass = in.readBoolean())) {
                this.dbInfo = new QueryClassFileInfo(this.sourceFile);
            }
        } else if (this.sourceData == 7) {
            boolean isParamQuery;
            boolean soap;
            if (this.version >= 381 && (soap = in.readBoolean())) {
                Coder.decode(IOUtil.readString(in, true));
                Coder.decode(IOUtil.readString(in, true));
                Coder.decode(IOUtil.readString(in, true));
                if (this.version >= 392 && this.version <= 420 || this.version >= 426) {
                    Coder.decode(IOUtil.readString(in, true));
                    boolean hasTemplateBytes = in.readBoolean();
                    if (hasTemplateBytes) {
                        int byteLength = in.readInt();
                        byte[] soapTemplateBytes = new byte[byteLength];
                        in.readFully(soapTemplateBytes, 0, byteLength);
                    }
                    int propCount = in.readInt();
                    for (int i = 0; i < propCount; ++i) {
                        Coder.decode(IOUtil.readString(in, true));
                        Coder.decode(IOUtil.readString(in, true));
                    }
                }
                this.sourceData = 9;
            }
            this.xmlFileQueryInfo = XMLFileQueryInfo.read(in);
            this.sourceFile = this.xmlFileQueryInfo.getFileName();
            if (this.version >= 318 && (isParamQuery = in.readBoolean())) {
                this.dbInfo = new QueryXMLFileInfo(this.xmlFileQueryInfo);
            }
        } else if (this.sourceData == 9) {
            Coder.decode(IOUtil.readString(in, true));
            Coder.decode(IOUtil.readString(in, true));
            Coder.decode(IOUtil.readString(in, true));
        } else if (this.sourceData == 12) {
            this.soapInfo = SOAPQueryFileInfo.readSOAPQueryFileInfo(new VersioningDataInput(in, 6612));
            if (this.soapInfo.isParameterized()) {
                this.dbInfo = this.soapInfo;
            }
        } else if (this.sourceData == 11) {
            this.sfQueryInfo = SalesForceQueryFileInfo.readSalesForceQueryInfo(in, this.version);
            if (this.sfQueryInfo.isParameterized()) {
                this.dbInfo = this.sfQueryInfo;
            }
        } else if (this.sourceData == 13) {
            this.excelInfo = ExcelFileInfo.read(in, this.version);
        } else if (this.sourceData == 10) {
            this.mondrianConnectionString = Coder.decode(IOUtil.readString(in, true));
            this.MDXQuery = Coder.decode(IOUtil.readString(in, true));
            this.xmlaURI = Coder.decode(IOUtil.readString(in, true));
            this.xmlaDataSource = Coder.decode(IOUtil.readString(in, true));
            this.xmlaCatalog = Coder.decode(IOUtil.readString(in, true));
            this.inputMethod = in.readInt();
        } else if (this.sourceData == 5) {
            int envsize;
            int ejbversion = in.readInt();
            this.jndiName = Coder.decode(IOUtil.readString(in, this.isUTFString), this.version);
            this.homeName = Coder.decode(IOUtil.readString(in, this.isUTFString), this.version);
            this.remoteName = Coder.decode(IOUtil.readString(in, this.isUTFString), this.version);
            this.selectedMethodName = Coder.decode(IOUtil.readString(in, this.isUTFString), this.version);
            int count = in.readInt();
            this.selectedMethodParamVal = new Object[count];
            for (int i = 0; i < count; ++i) {
                String paramType = Coder.decode(IOUtil.readString(in, this.isUTFString), this.version);
                this.selectedMethodParamVal[i] = EJBUtil.getRuntimeInputValue(paramType, Coder.decode(IOUtil.readString(in, this.isUTFString), this.version));
            }
            if (ejbversion >= 2 && (envsize = in.readInt()) > 0) {
                if (this.environment == null) {
                    this.environment = new Hashtable();
                }
                for (int i = 0; i < envsize; ++i) {
                    String key = Coder.decode(IOUtil.readString(in, this.isUTFString), this.version);
                    String val = Coder.decode(IOUtil.readString(in, this.isUTFString), this.version);
                    this.environment.put(key, val);
                }
            }
        } else if (this.sourceData == 3 && this.version >= 146) {
            int count = in.readInt();
            this.sourceList = new Object[count];
            this.sourceType = new int[count];
            this.doTranspose = new boolean[count];
            this.transposeColList = new Object[count];
            for (int i = 0; i < count; ++i) {
                int type;
                this.sourceType[i] = type = in.readInt();
                if (type == 1) {
                    this.sourceList[i] = DBInfoBasic.read(in, this.version);
                    if (this.modDataSourceArr != null) {
                        ((DBInfoBasic)this.sourceList[i]).setQuery(this.modDataSourceArr[i]);
                    }
                } else if (type == 2 || type == 6 || type == 4) {
                    this.sourceList[i] = Coder.decode(IOUtil.readString(in, this.isUTFString), this.version);
                    if (this.modDataSourceArr != null) {
                        this.sourceList[i] = this.modDataSourceArr[i];
                    }
                } else if (type == 7) {
                    this.sourceList[i] = XMLFileQueryInfo.read(in);
                } else if (type == 5) {
                    int envsize;
                    int ejbversion = in.readInt();
                    String thisJNDIName = Coder.decode(IOUtil.readString(in, this.isUTFString), this.version);
                    String thisHomeName = Coder.decode(IOUtil.readString(in, this.isUTFString), this.version);
                    String thisRemoteName = Coder.decode(IOUtil.readString(in, this.isUTFString), this.version);
                    String thisSelectedMethodName = Coder.decode(IOUtil.readString(in, this.isUTFString), this.version);
                    int paramCount = in.readInt();
                    Object[] thisSelectedMethodParamVal = new Object[paramCount];
                    for (int k = 0; k < paramCount; ++k) {
                        String paramType = Coder.decode(IOUtil.readString(in, this.isUTFString), this.version);
                        thisSelectedMethodParamVal[k] = EJBUtil.getRuntimeInputValue(paramType, Coder.decode(IOUtil.readString(in, this.isUTFString), this.version));
                    }
                    Hashtable<String, String> thisEnvironment = null;
                    if (ejbversion >= 2 && (envsize = in.readInt()) > 0) {
                        thisEnvironment = new Hashtable<String, String>();
                        for (int k = 0; k < envsize; ++k) {
                            String key = Coder.decode(IOUtil.readString(in, this.isUTFString), this.version);
                            String val = Coder.decode(IOUtil.readString(in, this.isUTFString), this.version);
                            thisEnvironment.put(key, val);
                        }
                    }
                    this.sourceList[i] = new EJBInfo(thisJNDIName, thisHomeName, thisRemoteName, thisSelectedMethodName, thisSelectedMethodParamVal, thisEnvironment);
                }
                this.doTranspose[i] = in.readBoolean();
                if (this.version >= 186) {
                    this.transposeColList[i] = IOUtil.readBooleans(in);
                }
                if (this.modTransposeArr != null) {
                    this.doTranspose[i] = this.modTransposeArr[i];
                }
                if (this.modTransposeColArr == null) continue;
                this.transposeColList[i] = this.modTransposeColArr[i];
            }
        } else if ((this.sourceData == 0 || this.sourceData == 14) && this.version >= 144 && in.readBoolean()) {
            this.originalColDataFromMemSource = this.createColData(in, this.version);
        }
        this.isTransposed = in.readBoolean();
        if (this.modTranspose != null) {
            this.isTransposed = this.modTranspose;
        }
        if (this.version >= 186) {
            this.transposeCol = IOUtil.readBooleans(in);
        }
        if (this.modTransposeCol != null) {
            this.transposeCol = this.modTransposeCol;
        }
        this.drillDownPresent = in.readBoolean();
        if (this.drillDownPresent) {
            if (this.version >= 89) {
                this.isDynamicDrillDown = in.readBoolean();
            }
            this.primaryAggregate = in.readInt();
            this.secondaryAggregate = in.readInt();
            this.drillTemplateName = Coder.decode(IOUtil.readString(in, this.isUTFString), this.version);
            if (this.version < 89 || !this.isDynamicDrillDown) {
                this.drillVector = DrillDownInfo.read(in, this.version);
            }
        }
    }

    public static Chart getColInfo(Component comp, String urlname) throws Exception {
        if (urlname == null) {
            return null;
        }
        LoadChart loadCHT = new LoadChart();
        loadCHT.retrieveColInfoOnly = true;
        return loadCHT.loadChartFromFile(comp, urlname, null);
    }

    private Chart loadData(Component component, DataInput orgIn, ColData[] colData, Chart chart, boolean template, boolean forEntpServer) throws IOException {
        this.version = orgIn.readInt();
        if (this.version == 7001) {
            this.version = 6611;
        }
        if (this.version != 366) {
            return this.loadData(component, orgIn, colData, chart, template, forEntpServer, true);
        }
        ByteArrayOutputStream aout = new ByteArrayOutputStream(2048);
        try {
            while (true) {
                aout.write(orgIn.readByte());
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to write data to ByteArrayOutputStream", ex);
            byte[] data = aout.toByteArray();
            try {
                DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
                return this.loadData(component, in, colData, chart, template, forEntpServer, true);
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINEST, "Failed to load data", ex2);
                DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
                return this.loadData(component, in, colData, chart, template, forEntpServer, false);
            }
        }
    }

    private Chart loadData(Component component, DataInput orgIn, ColData[] colData, Chart chart, boolean template, boolean forEntpServer, boolean readPattern) throws IOException {
        int option;
        int fontMappingSize;
        PreprocInfo tsInfo = null;
        boolean isTSChart = false;
        boolean histogram = false;
        boolean showPercentage = false;
        int binNumber = 0;
        boolean isAggregatedChart = false;
        boolean isPrevParamPrompt = true;
        DataInput in = orgIn;
        if (this.version >= 394 && !(orgIn instanceof VersioningDataInput)) {
            in = new VersioningDataInput(orgIn, 6612);
        }
        this.isUTFString = true;
        String registryID = null;
        String dataSourceID = null;
        String dataSourceLoc = null;
        if (this.version >= 302) {
            registryID = IOUtil.readString(in, true);
            dataSourceID = IOUtil.readString(in, true);
            dataSourceLoc = IOUtil.readString(in, true);
        }
        if (this.version >= 230) {
            this.loadTree(in);
        } else {
            this.drillDownNode = new DrillDownNode("ROOT");
        }
        this.loadDataHeader(in);
        isTSChart = in.readBoolean();
        histogram = in.readBoolean();
        if (this.version >= 6606) {
            showPercentage = in.readBoolean();
        }
        if (this.version >= 6607) {
            binNumber = in.readInt();
        }
        if (this.version >= 410) {
            isAggregatedChart = in.readBoolean();
        }
        if (isTSChart || histogram || this.drillDownPresent || isAggregatedChart) {
            tsInfo = new PreprocInfo(0);
            tsInfo.readAsStream(in, this.version, true);
        }
        if (isAggregatedChart && tsInfo != null && tsInfo.getAggrOps().length > 0) {
            this.primaryAggregate = tsInfo.getAggrOps()[0];
        }
        if (this.version >= 383) {
            isPrevParamPrompt = in.readBoolean();
        }
        Vector<QueryInParamSet> parameter = null;
        colData = this.processColData(colData, template, forEntpServer, isTSChart, histogram, showPercentage, binNumber, isAggregatedChart, tsInfo, parameter, isPrevParamPrompt);
        int chartType = in.readInt();
        int comboType = 0;
        boolean is2DChart = in.readBoolean();
        if (this.version >= 411) {
            boolean drawNullColumn = in.readBoolean();
            String nullColumnName = IOUtil.readString(in, true);
            if (colData != null) {
                for (ColData element : colData) {
                    element.setDrawNullColumn(drawNullColumn);
                    element.setNullColumnName(nullColumnName);
                }
            }
        }
        if (chart == null) {
            chart = this.processChart(colData, component, chartType, is2DChart, isTSChart, histogram, isAggregatedChart, tsInfo, parameter);
        }
        if (!this.istemplate) {
            chart.currentNode = this.drillDownNode;
            chart.isSubFieldDrillDownChart = this.drillDownNode == null;
            chart.setQueryFileInfo(this.queryFileInfo);
            if (this.queryFileInfo != null) {
                chart.getQueryFileInfo().setParameter(parameter);
            }
        }
        chart.setPrevParamPrompt(isPrevParamPrompt);
        if (!this.istemplate) {
            chart.summaryChart = this.drillDownPresent;
            chart.isDynamicDrillDown = this.isDynamicDrillDown;
            chart.primaryAggregate = this.primaryAggregate;
            chart.secondaryAggregate = this.secondaryAggregate;
            chart.drillTemplateName = this.drillTemplateName;
            chart.drillDownVector = this.drillVector;
        }
        if (this.version >= 65 && (!this.istemplate || this.forReport)) {
            chart.setTransposed(this.isTransposed, this.transposeCol);
        }
        if (this.version >= 60) {
            int width = in.readInt();
            int height = in.readInt();
            chart.setSize(width, height);
        }
        LOGGER.finer("VERSION = " + this.version);
        if (this.version <= 7099 && this.version >= 503 || this.version <= 4999 && this.version >= 4000) {
            LOGGER.finest("Read pack check");
            this.pack = in.readBoolean();
            LOGGER.finest("READ PACK = " + this.pack);
        }
        if (this.version >= 81) {
            chart.setScrollBarOption(in.readInt());
        }
        if (this.version >= 94) {
            chart.setAutoRotate(in.readBoolean());
        }
        chart.setAdjustFont(false);
        if (this.version >= 282) {
            chart.setAdjustFont(in.readBoolean());
        }
        if (this.version >= 87) {
            chart.setPopupMenuEnabled(in.readBoolean());
            if (chart.isPopupMenuEnabled()) {
                chart.setDimMenuEnabled(in.readBoolean());
                chart.setTypeMenuEnabled(in.readBoolean());
            }
        }
        if (!Chart.isCircularChart(chartType)) {
            this.axisColor = IOUtil.readColor(in);
            int axisNo = this.version >= 31 ? 4 : 3;
            for (int i = 0; i < axisNo; ++i) {
                this.readAxis(chart.axis[i], this.version, in);
            }
            chart.setAxisColor(this.axisColor);
            if (this.version > 77) {
                boolean isSwapAxis = in.readBoolean();
                chart.setSwapAxis(isSwapAxis);
            }
            if (this.version > 112) {
                boolean isJoinAxis = in.readBoolean();
                chart.setJoinAxis(isJoinAxis);
            }
            if (this.version >= 301) {
                boolean isSynRadarAxis = in.readBoolean();
                chart.setSynchronizeRadarAxis(isSynRadarAxis);
            }
            if (this.version >= 362) {
                boolean isDrawCircularGrid = in.readBoolean();
                chart.setDrawCircularGrid(isDrawCircularGrid);
            }
            if (this.version >= 363) {
                boolean isAreaCutOffEnabled = in.readBoolean();
                if (isAreaCutOffEnabled) {
                    double cutOffPt = in.readDouble();
                    chart.setAreaCutOffPoint(cutOffPt);
                } else {
                    chart.setAreaCutOffPoint(null);
                }
            }
            if (this.version >= 166) {
                chart.setGridAlignedWithTicker(in.readBoolean());
                chart.setGridInFront(in.readBoolean());
            }
        }
        switch (chartType) {
            case 6: 
            case 20: {
                IPieChart ipchart = chart instanceof IPieChart ? (IPieChart)((Object)chart) : (chartType == 6 ? (IPieChart)((Object)Chart.createChart(component, 6, true, null, chart.colData)) : (IPieChart)((Object)Chart.createChart(component, 20, true, null, chart.colData)));
                PieChart pieChart = ipchart.getPieChart();
                if (this.version >= 57) {
                    pieChart.pieSectors = in.readInt();
                }
                if ((this.version <= 7099 && this.version >= 501 || this.version <= 4999 && this.version >= 4000) && in instanceof VersioningDataInput) {
                    if (pieChart != null && pieChart.pieThickness != null) {
                        pieChart.pieThickness[0] = ((VersioningDataInput)in).readInt((short)501);
                    } else {
                        ((VersioningDataInput)in).readInt((short)501);
                    }
                }
                if (this.version >= 6609) {
                    pieChart.concentricDoughnut = ((VersioningDataInput)in).readBoolean((short)6609);
                }
                pieChart.fontdistance = in.readDouble();
                pieChart.sliceDistance = in.readDouble();
                pieChart.initangle = in.readInt();
                pieChart.pieLabelFont = IOUtil.readFont(in, this.isUTFString);
                pieChart.pieValueFont = IOUtil.readFont(in, this.isUTFString);
                pieChart.piePercentFont = IOUtil.readFont(in, this.isUTFString);
                pieChart.pieLabelColor = IOUtil.readColor(in);
                pieChart.pieValueColor = IOUtil.readColor(in);
                pieChart.piePercentColor = IOUtil.readColor(in);
                pieChart.pieLabelAngle = in.readDouble();
                pieChart.pieValueAngle = in.readDouble();
                pieChart.piePercentAngle = in.readDouble();
                pieChart.showLabel = in.readBoolean();
                pieChart.showPercent = in.readBoolean();
                pieChart.showValue = in.readBoolean();
                if (this.version >= 36) {
                    pieChart.smartlabel = in.readBoolean();
                }
                if (this.version >= 366 || this.version >= 319 && this.version <= 350) {
                    pieChart.valInLegend = in.readBoolean();
                }
                if (this.version >= 161) {
                    pieChart.setSectorGapEnabled(in.readBoolean());
                }
                if (this.version >= 198 && this.version < 205 || this.version >= 209) {
                    pieChart.pieExtendLine = in.readBoolean();
                }
                if (this.version >= 315) {
                    pieChart.labelAtTheSide = in.readBoolean();
                }
                boolean pieInSeries = false;
                if (this.version >= 231) {
                    pieInSeries = in.readBoolean();
                    pieChart.catLabelDistance = in.readDouble();
                    pieChart.catLabelFont = IOUtil.readFont(in, this.isUTFString);
                    pieChart.catLabelColor = IOUtil.readColor(in);
                    pieChart.catLabelAngle = in.readDouble();
                    pieChart.showCategory = in.readBoolean();
                    pieChart.setBestFit(in.readBoolean());
                    pieChart.setDrawLinearly(in.readBoolean());
                    pieChart.piePerRow = in.readInt();
                    pieChart.setGapRatioBetweenPies(in.readDouble());
                }
                if (this.version < 8) break;
                int pieCt = 1;
                if (this.version >= 231) {
                    pieCt = in.readInt();
                }
                int len = in.readInt();
                pieChart.allocateLabel(pieCt, len);
                for (int h = 0; h < pieCt; ++h) {
                    for (int i = 0; i < len; ++i) {
                        pieChart.pieLabel[h][i].xoffset = in.readFloat();
                        pieChart.pieLabel[h][i].yoffset = in.readFloat();
                        pieChart.pieValue[h][i].xoffset = in.readFloat();
                        pieChart.pieValue[h][i].yoffset = in.readFloat();
                        pieChart.piePercent[h][i].xoffset = in.readFloat();
                        pieChart.piePercent[h][i].yoffset = in.readFloat();
                    }
                    if (!pieInSeries) continue;
                    pieChart.catLabel[h].xoffset = in.readFloat();
                    pieChart.catLabel[h].yoffset = in.readFloat();
                }
                break;
            }
            case 12: {
                if (this.version < 103) break;
                Color surfaceColor = IOUtil.readColor(in);
                chart.set3DSurfaceColor(surfaceColor);
                chart.readSurfaceHyperLinkList(in, this.isUTFString);
                break;
            }
            case 13: {
                if (this.version >= 103) {
                    chart.bubbleDrawMode = in.readInt();
                    chart.axisUnitToRadiusRatio = in.readDouble();
                }
                if (this.version < 192) break;
                chart.bubble3D = in.readBoolean();
                chart.bubble3DLight = in.readInt();
                break;
            }
            case 3: {
                boolean[] tempArray;
                if (this.version >= 191 && (tempArray = IOUtil.readBooleans(in)) != null) {
                    chart.setSelectiveStepLineState(tempArray, true);
                }
                if (this.version >= 187) {
                    chart.setStepLineState(in.readBoolean());
                    chart.setStepLineRatio(in.readDouble());
                }
                if (this.version >= 114) {
                    chart.setShowDoubleValueForLine(in.readBoolean());
                }
                if (this.version >= 171) {
                    chart.setSyncPointColorForLine(in.readBoolean());
                }
                if (this.version >= 164) {
                    boolean showDropBar = in.readBoolean();
                    chart.setShowDropBarForLine(showDropBar);
                    if (showDropBar) {
                        chart.setDropBarBorderState(in.readBoolean());
                        chart.setDropBarColor(IOUtil.readColor(in));
                        if (this.version >= 167) {
                            chart.setDropBarColor2(IOUtil.readColor(in));
                        }
                        chart.setDropBarSeries1(in.readInt());
                        chart.setDropBarSeries2(in.readInt());
                    }
                }
                if (this.version < 188) break;
                chart.setLayout(in.readInt());
                break;
            }
            case 14: {
                if (this.version >= 143 || this.version < 128) break;
                chart.setTranslucent(in.readBoolean());
                break;
            }
            case 16: {
                if (this.version < 145) break;
                this.readLabelOffset(in, chart);
                break;
            }
            case 19: {
                if (this.version < 304) break;
                chart.setNoSectionForPolar(in.readInt());
                chart.setStartAngleForPolar(in.readDouble());
                chart.setRadianForPolar(in.readBoolean());
                chart.setClockWiseForPolar(in.readBoolean());
                this.readLabelOffset(in, chart);
                break;
            }
            case 17: {
                if (this.version < 142) break;
                if (this.version >= 145) {
                    this.readLabelOffset(in, chart);
                }
                chart.setStartAngleForDial(in.readDouble());
                chart.setEndAngleForDial(in.readDouble());
                if (this.version >= 162) {
                    chart.setRadiusForInternalDial(in.readDouble());
                    chart.setCenterColorForDial(IOUtil.readColor(in));
                }
                if (this.version >= 351) {
                    chart.setDrawFullCircleForDial(in.readBoolean());
                }
                if (this.version >= 386) {
                    chart.setSubTickerLength(in.readInt());
                    chart.setTickerLength(in.readInt());
                    chart.set3DShadowForTickerOn(in.readBoolean());
                    chart.setSubTickerCount(in.readInt());
                    chart.setSubTickerThickness(in.readInt());
                    chart.setPointerUsed(in.readBoolean());
                }
                if (this.version >= 410) {
                    chart.setNeedleOption(in.readInt());
                    break;
                }
                if (chart.isPointerUsed()) break;
                chart.setNeedleOption(0);
                break;
            }
            case 15: {
                if (this.version < 168) break;
                chart.setLayout(in.readInt(), true);
                break;
            }
            case 18: {
                if (this.version >= 193) {
                    chart.setLabelDateTimeDisplay(0, in.readBoolean());
                    chart.displayByWeek[0] = in.readBoolean();
                }
                if (this.version < 234) break;
                chart.setGanttArrowsDrawn(in.readBoolean());
                break;
            }
            case 2: {
                if (this.version >= 278) {
                    for (int i = 0; i < 3; ++i) {
                        chart.setLabelDateTimeDisplay(i, in.readBoolean());
                        chart.setDisplayByWeek(i, in.readBoolean());
                    }
                }
                if (this.version < 6604) break;
                chart.setLineInOriginalOrder(in.readBoolean());
                chart.setDrawConnectLineArrows(in.readBoolean());
            }
        }
        chart.mainTitle = IOUtil2.readCString(in, this.isUTFString);
        if (this.version >= 210) {
            chart.setFontResizeRatio(in.readFloat());
        }
        this.loadLegend(in, chart.legend, this.version, chart);
        if (this.version >= 31) {
            this.loadLegend(in, chart.legend2, this.version, chart);
        }
        if ((this.version >= 312 || this.version >= 288 && this.version <= 300) && (fontMappingSize = in.readInt()) > 0) {
            if (this.fontMapping == null) {
                this.fontMapping = new Hashtable();
            }
            for (int i = 0; i < fontMappingSize; ++i) {
                String key = IOUtil.readString(in, true);
                String val = IOUtil.readString(in, true);
                this.fontMapping.put(key, val);
            }
        }
        chart.fontMapping = this.fontMapping;
        if (this.version >= 7) {
            boolean valueState = in.readBoolean();
            chart.setTopValueState(valueState);
            if (this.version >= 195) {
                valueState = in.readBoolean();
                chart.setStackLabelState(valueState);
            }
            if (this.version >= 314) {
                chart.setStackTotalLabelState(in.readBoolean());
            }
            if (chart.getTopValueState()) {
                boolean tmpB;
                if (this.version >= 313) {
                    chart.topLabel_Alignment = in.readInt();
                }
                if (this.version >= 314) {
                    chart.stackLabel_Alignment = in.readInt();
                }
                chart.topvalueLabel_font = IOUtil.readFont(in, this.isUTFString);
                chart.topvalueLabel_color = IOUtil.readColor(in);
                if (this.version >= 388 && (tmpB = in.readBoolean())) {
                    chart.topvalueNegativeLabel_color = IOUtil.readColor(in);
                }
                chart.topvalueLabel_angle = in.readInt();
                if (is2DChart) {
                    chart.toplabel_offset_up = in.readInt();
                    chart.toplabel_offset_side = in.readInt();
                } else {
                    chart.toplabel_offset3D_up = in.readInt();
                    chart.toplabel_offset3D_side = in.readInt();
                }
            }
            if ((this.version >= 365 || chart.getTopValueState()) && this.version >= 117) {
                boolean valueState2 = in.readBoolean();
                chart.setTopValueState2(valueState2);
                if (chart.getTopValueState2()) {
                    chart.topvalueLabel2_font = IOUtil.readFont(in, this.isUTFString);
                    chart.topvalueLabel2_color = IOUtil.readColor(in);
                    chart.topvalueLabel2_angle = in.readInt();
                    if (is2DChart) {
                        chart.toplabel2_offset_up = in.readInt();
                        chart.toplabel2_offset_side = in.readInt();
                    } else {
                        chart.toplabel2_offset3D_up = in.readInt();
                        chart.toplabel2_offset3D_side = in.readInt();
                    }
                }
            }
            if (this.version >= 365 || chart.getTopValueState()) {
                if (this.version >= 93 || this.version >= 83 && this.version <= 86) {
                    chart.setLabelOnPositiveSide(in.readBoolean());
                } else {
                    chart.setLabelOnPositiveSide(!is2DChart);
                }
                if (this.version >= 130) {
                    chart.setLabelOnNegativeSide(in.readBoolean());
                }
                if (this.version >= 110) {
                    chart.showSeriesInTopLabel(in.readBoolean());
                }
            }
        }
        if (this.version >= 66 && !this.istemplate) {
            chart.setHistogram(histogram);
            chart.setShowPercentage(showPercentage);
            chart.setBinNumber(binNumber);
        }
        if (this.version >= 410 && !this.istemplate) {
            chart.setAggregationChart(isAggregatedChart);
        }
        int[] processedMap = null;
        int processedDim = 0;
        int subvalueCol = -1;
        int valueCol = -1;
        HiLowMap hiLowMap = new HiLowMap();
        if (this.version >= 62) {
            boolean bol = false;
            bol = !this.istemplate ? (chart.processedChart = in.readBoolean()) : in.readBoolean();
            if (bol) {
                processedDim = in.readInt();
                processedMap = IOUtil.readInts(in, processedDim);
                subvalueCol = in.readInt();
                valueCol = in.readInt();
                chart.originalMap = IOUtil.readInts(in, 5);
                if (this.version <= 7099 && this.version >= 4100) {
                    hiLowMap = HiLowMap.read(in, this.version);
                    chart.originalHiLowMap = HiLowMap.read(in, this.version);
                }
            }
        }
        int dataDim = in.readInt();
        int[] map = IOUtil.readInts(in, dataDim);
        int oldSubValueCol = -1;
        if (this.version >= 31) {
            if (!this.istemplate) {
                oldSubValueCol = in.readInt();
                chart.mData2 = chart.setMultiDimData(0, chart, null);
            } else {
                oldSubValueCol = in.readInt();
            }
        }
        if (this.version >= 149) {
            chart.setComboSeries(in.readInt());
        }
        if (Chart.isCoordinateType(chartType)) {
            int[] val = IOUtil.readInts(in, 3);
            if (!this.istemplate) {
                chart.setChartType(map, dataDim, val);
            }
        } else if (chartType == 10 || chartType == 9 || chartType == 18) {
            HiLowMap oldHiLowMap = HiLowMap.read(in, this.version);
            if (!this.istemplate) {
                if (!chart.processedChart) {
                    chart.setChartType(map, dataDim, oldHiLowMap, oldSubValueCol);
                } else {
                    chart.setChartType(processedMap, processedDim, hiLowMap, subvalueCol);
                }
            }
        } else if (!this.istemplate) {
            if (this.version >= 62) {
                int oldValueCol = in.readInt();
                if (!chart.processedChart) {
                    chart.setChartType(map, dataDim, oldValueCol, oldSubValueCol);
                } else {
                    chart.setChartType(processedMap, processedDim, valueCol, subvalueCol);
                }
            }
        } else {
            in.readInt();
        }
        if (!this.istemplate) {
            chart.computeCoord(chart.cgraphics, chart.chartxorigin, chart.chartxorigin + chart.chartwidth, chart.chartyorigin, chart.chartheight + chart.chartyorigin);
        }
        if (this.retrieveColInfoOnly) {
            return chart;
        }
        chart.legend_XProp = in.readFloat();
        chart.legend_YProp = in.readFloat();
        if (this.version >= 31) {
            chart.legend2_XProp = in.readFloat();
            chart.legend2_YProp = in.readFloat();
        }
        chart.title_XProp = in.readFloat();
        chart.title_YProp = in.readFloat();
        chart.chart_XProp = in.readFloat();
        chart.chart_YProp = in.readFloat();
        chart.chart_widthProp = in.readFloat();
        chart.chart_heightProp = in.readFloat();
        if (this.version >= 279) {
            chart.setDBSourceType(in.readInt());
            boolean hasBytes = in.readBoolean();
            if (!hasBytes) {
                chart.setQueryFileBytes(null);
            } else {
                int count = in.readInt();
                byte[][] bytes = new byte[count][];
                for (int i = 0; i < bytes.length; ++i) {
                    hasBytes = in.readBoolean();
                    if (!hasBytes) {
                        bytes[i] = null;
                        continue;
                    }
                    count = in.readInt();
                    bytes[i] = new byte[count];
                    in.readFully(bytes[i], 0, count);
                }
                chart.setQueryFileBytes(bytes);
            }
        }
        int lineThickness = 2;
        Area ar = IOUtil2.readArea(in, this.version, chart);
        if (this.version >= 25) {
            ar.appearance = in.readInt();
            ar.depth = in.readInt();
            if (this.version < 173) {
                lineThickness = in.readInt();
            }
            chart.axisThickness = in.readInt();
        }
        chart.setBackground(ar);
        Area chartBorder = IOUtil2.readArea(in, this.version, chart);
        chart.setBorder(chartBorder);
        if (this.version >= 26) {
            int borderThickness = in.readInt();
            chart.setBorderThickness(borderThickness);
        }
        if (this.version >= 147) {
            chart.setAreaState(in.readBoolean());
        }
        boolean pointState = in.readBoolean();
        if (!this.istemplate || chart.chartType != 13) {
            if (chart.chartType == 12 && chart.getPointState() != pointState) {
                chart.newSurface();
            }
            chart.setPointState(pointState);
        }
        if (this.version >= 163) {
            chart.setDrawPointBorder(in.readBoolean());
        }
        if (this.version <= 7099 && this.version >= 413 || this.version <= 2999 && this.version >= 2002 || this.version <= 4999 && this.version >= 4002) {
            chart.setDrawPointBorderColor(IOUtil.readColor(in));
        }
        boolean lineState = in.readBoolean();
        if (!this.istemplate || chart.chartType != 3) {
            chart.setLineState(lineState);
        }
        if (this.version >= 32) {
            boolean pointState2 = in.readBoolean();
            chart.setPointState2(pointState2);
            if (this.version >= 163) {
                chart.setDrawPointBorder2(in.readBoolean());
            }
            if (this.version <= 7099 && this.version >= 413 || this.version <= 2999 && this.version >= 2002 || this.version <= 4999 && this.version >= 4002) {
                chart.setDrawPointBorderColor2(IOUtil.readColor(in));
            }
            boolean lineState2 = in.readBoolean();
            chart.setLineState2(lineState2);
            boolean arrowState = in.readBoolean();
            chart.setArrowState(arrowState);
        }
        if (this.version >= 194) {
            boolean xTopState = in.readBoolean();
            chart.setXAxisAtTop(xTopState);
        }
        if (this.version >= 196 && this.version != 206) {
            boolean antiAliased = in.readBoolean();
            chart.setAntiAliasEnabled(antiAliased);
        }
        if (this.version >= 387) {
            chart.setAntiAliasForChartOnly = in.readBoolean();
        }
        if (this.version >= 116) {
            boolean showShadow = in.readBoolean();
            chart.setShowShadowOnLine(showShadow);
        }
        if (this.version >= 6605) {
            chart.setShowShadowOnPoint(in.readBoolean());
        }
        if (this.version >= 191) {
            boolean[] tempArray = IOUtil.readBooleans(in);
            if (tempArray != null) {
                chart.setSelectiveStepLineState2(tempArray, true);
            }
            chart.setStepLineState2(in.readBoolean());
            chart.setStepLineRatio2(in.readDouble());
        }
        chart.setTopValueState(in.readBoolean());
        if (this.version >= 2) {
            boolean wallFrame = in.readBoolean();
            chart.setWallFrame(wallFrame);
            double animateSpeed = in.readDouble();
            chart.setAnimateSpeed(animateSpeed);
        }
        Area desktopArea = IOUtil2.readArea(in, this.version, chart);
        chart.setDesktopArea(desktopArea);
        if (this.version >= 111) {
            boolean isBackgroundTransparent = in.readBoolean();
            chart.setBackgroundTransparent(isBackgroundTransparent);
        }
        if (this.version >= 143) {
            chart.setTranslucent(in.readBoolean());
        }
        if (this.version >= 410) {
            chart.setTranslucentValue(in.readFloat());
        }
        if (this.version >= 189) {
            chart.setJ2DRotateEnabled(in.readBoolean());
        }
        if (this.version >= 309) {
            chart.setDisableJava2DForStraightText(in.readBoolean());
        }
        if (this.version >= 310) {
            chart.setCutOffThresholdForText(in.readInt());
        }
        short[] res = null;
        if (in instanceof VersioningDataInput) {
            res = ((VersioningDataInput)in).getFeatureVersionAndType();
        }
        if (res != null && res[1] != 6 && (this.version <= 7099 && this.version >= 412 || this.version > 7099 && this.version >= 2000)) {
            chart.setNoDataToPlotMessage(IOUtil.readString((VersioningDataInput)in, res[0], res[1]));
            chart.setNoDataToPlotMessageAngle(in.readInt());
            chart.setNoDataToPlotMessageColor(IOUtil.readColor(in));
            chart.setNoDataToPlotMessageFont(IOUtil.readFont(in, true));
            chart.setNoDataToPlotMessageVisible(in.readBoolean());
            res = null;
        }
        if (this.version >= 38) {
            int xshift = res != null ? ((VersioningDataInput)in).readInt(res[0], res[1]) : in.readInt();
            chart.set_xshift(xshift);
            if (this.version >= 39) {
                boolean dataBorder = in.readBoolean();
                chart.setDataBorder(dataBorder);
                if (this.version >= 364) {
                    boolean dataBorder2 = in.readBoolean();
                    chart.setDrawBorderForWhiteArea(dataBorder2);
                }
                if (this.version >= 308) {
                    chart.setDataBorderColor(IOUtil.readColor(in));
                    chart.setDataBorderThickness(in.readInt());
                } else if (chart.is2DimChart() && !chart.isCircularChart()) {
                    chart.setDataBorder(false);
                }
                if (this.version >= 44) {
                    double barWidthRatio = in.readDouble();
                    chart.setBarwidthRatio(barWidthRatio);
                    if (this.version >= 104) {
                        boolean offsetTicker = in.readBoolean();
                        chart.setOffsetTicker(offsetTicker);
                    }
                    if (this.version >= 45) {
                        int xlabelrow = in.readInt();
                        chart.set_xlabelrow(xlabelrow);
                        if (this.version >= 49) {
                            boolean nullDataLine = in.readBoolean();
                            chart.setNullDataLine(nullDataLine);
                            if (this.version >= 132) {
                                boolean applyLineStyleToNull = in.readBoolean();
                                chart.applyLineStyleToNullData(applyLineStyleToNull);
                            }
                            if (this.version >= 285) {
                                boolean showNullInScatter = in.readBoolean();
                                if (chart.getChartType() == 2) {
                                    chart.setShowNullInScatter(showNullInScatter);
                                } else {
                                    chart.setNullDataAsZero(!showNullInScatter);
                                }
                                if (this.version >= 6612) {
                                    chart.setZeroAsNullData(in.readBoolean());
                                }
                                if (this.version >= 411) {
                                    chart.setDrawNullColumn(in.readBoolean());
                                    chart.setNullColumnName(IOUtil.readString(in, true));
                                }
                            }
                            if (this.version >= 53) {
                                boolean formatHint = in.readBoolean();
                                chart.setFormatHint(formatHint);
                                if (this.version >= 55) {
                                    comboType = in.readInt();
                                    if (chartType == chart.chartType) {
                                        chart.setComboType(comboType);
                                    }
                                    if (this.version >= 56) {
                                        boolean candleStick = in.readBoolean();
                                        chart.setCandleStick(candleStick);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (!is2DChart) {
            double thickRatio = in.readDouble();
            chart.setThickRatio(thickRatio);
            Area wallBackground = IOUtil2.readArea(in, this.version, chart);
            chart.setWallBackground(wallBackground);
            int ThreeDDrawType = in.readInt();
            float[] viewPoint = IOUtil.readFloats(in, 6);
            float[] viewTranslate = IOUtil.readFloats(in, 3);
            float[] light = IOUtil.readFloats(in, 3);
            float[] ambient = IOUtil.readFloats(in, 3);
            float[] intensity = IOUtil.readFloats(in, 3);
            float zoomfactor = in.readFloat();
            if (!chart.is2DChart) {
                chart.set3DDrawType(ThreeDDrawType);
                chart.setViewPoint(viewPoint);
                chart.setViewTranslate(viewTranslate);
                chart.setLightPos(light);
                chart.setAmbient(ambient);
                chart.setIntensity(intensity);
                chart.setZoomfactor(zoomfactor);
            }
            if (this.version >= 6) {
                float XScaleSpace = in.readFloat();
                float YScaleSpace = in.readFloat();
                float ZScaleSpace = in.readFloat();
                if (!chart.is2DChart) {
                    chart.scaleSpace(XScaleSpace, YScaleSpace, ZScaleSpace);
                }
            }
            if (this.version >= 19) {
                chart.thickRatio = in.readFloat();
            }
        }
        int size = in.readInt();
        chart.stringList.removeAllElements();
        for (int i = 0; i < size; ++i) {
            PropCString pstring = IOUtil2.readPropCString(in, this.isUTFString);
            pstring.setPlacement(6);
            chart.stringList.addElement(pstring);
        }
        if (this.version >= 307) {
            String name = IOUtil.readString(in, true);
            double limit = in.readDouble();
            double threshold = -500.0;
            Color[] colors = null;
            if (this.version >= 389) {
                threshold = in.readDouble();
                colors = IOUtil.readColorList(in);
            }
            if (name.endsWith("#CANDLE_STICK#")) {
                chart.setPieGroupOthersName(name.substring(0, name.length() - 14));
                chart.setPieGroupOthersLimit(limit);
                if (this.version >= 389) {
                    chart.setColorThresholdForPie(threshold);
                    if (colors != null) {
                        if (colors.length == 2) {
                            chart.setCandleColors(colors[0], colors[1]);
                        } else {
                            Color[] newColor = new Color[colors.length - 2];
                            for (int i = 0; i < newColor.length; ++i) {
                                newColor[i] = colors[i];
                            }
                            chart.setCandleColors(colors[colors.length - 2], colors[colors.length - 1]);
                        }
                    }
                }
            } else {
                chart.setPieGroupOthersName(name);
                chart.setPieGroupOthersLimit(limit);
                if (this.version >= 389) {
                    chart.setColorThresholdForPie(threshold);
                    chart.setColorArrayForPieThreshold(colors);
                }
            }
            if (chart.remakeTable) {
                chart.reCreateTable();
            }
        }
        if (this.version >= 316) {
            chart.setUniqueColorForCol(in.readBoolean());
        }
        if (this.version <= 7099 && this.version >= 4102) {
            chart.setMaxNumberOfCategories(in.readInt());
        }
        if (this.version >= 3) {
            DataInput newin;
            if (this.version >= 30) {
                byte[] encrypb = new byte[in.readInt()];
                in.readFully(encrypb, 0, encrypb.length);
                newin = new DataInputStream(new ByteArrayInputStream(IOUtil.decode(encrypb, this.version)));
            } else {
                newin = in;
            }
            for (int i = 0; i < dataDim; ++i) {
                int len = newin.readInt();
                Object[] name = new String[len];
                for (int j = 0; j < len; ++j) {
                    name[j] = IOUtil.readString(newin, this.isUTFString);
                }
                if (this.istemplate) continue;
                chart.setFieldOrder(i, name);
            }
        }
        DataAttribute dat = new DataAttribute(in, false, is2DChart, chartType, dataDim, this.version, lineThickness, readPattern, chart.isUniqueColorForCol(), chart.mData, null);
        if (chart.getDataPtShapes() == null) {
            chart.setDataPtShapes(dat.dataShape);
        }
        if (chart.getDataPtSizes() == null) {
            chart.setDataPtSizes(dat.dataSize);
        }
        DataAttribute dat2 = null;
        if (this.version >= 31 && in.readBoolean()) {
            int secChartType = chartType;
            int secDim = dataDim;
            if (comboType == 3) {
                secChartType = 14;
                secDim = 2;
            }
            dat2 = new DataAttribute(in, is2DChart, secChartType, secDim, this.version, lineThickness, readPattern);
        }
        chart.refreshInterval = in.readLong();
        chart.disableSchedule = in.readBoolean();
        if (this.version >= 10) {
            boolean hasImage = in.readBoolean();
            if (hasImage) {
                boolean imgpack;
                String url = IOUtil.readString(in, this.isUTFString);
                String relativeURL = null;
                if (this.version >= 395) {
                    relativeURL = IOUtil.readString(in, this.isUTFString);
                }
                option = in.readInt();
                if (relativeURL != null && relativeURL.equals("")) {
                    relativeURL = null;
                }
                try {
                    chart.setBackgroundImage(new URL(url), relativeURL, option);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, "Failed to set background image", ex);
                }
                if (this.version >= 281 && (imgpack = in.readBoolean())) {
                    int count = in.readInt();
                    byte[] bytes = new byte[count];
                    in.readFully(bytes, 0, count);
                    chart.setBackgroundImageByteArray(bytes);
                }
            } else {
                chart.setBackgroundImage(null, 3);
            }
        }
        if (this.version >= 406) {
            boolean hasImage = in.readBoolean();
            if (hasImage) {
                String url = IOUtil.readString(in, this.isUTFString);
                String relativeURL = IOUtil.readString(in, this.isUTFString);
                option = in.readInt();
                chart.setDialPlotFGRatio(in.readDouble());
                if (relativeURL != null && relativeURL.equals("")) {
                    relativeURL = null;
                }
                try {
                    chart.setDialPlotFGImage(new URL(url), relativeURL, option);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, "Failed to set dial image", ex);
                }
                boolean pack = in.readBoolean();
                if (pack) {
                    int count = in.readInt();
                    byte[] bytes = new byte[count];
                    in.readFully(bytes, 0, count);
                    chart.setDialPlotFGImageByteArray(bytes);
                }
            } else {
                chart.setDialPlotFGImage(null, null, 3);
            }
        }
        if (this.version >= 406) {
            boolean hasImage = in.readBoolean();
            if (hasImage) {
                String url = IOUtil.readString(in, this.isUTFString);
                String relativeURL = IOUtil.readString(in, this.isUTFString);
                option = in.readInt();
                chart.setDialPlotBGRatio(in.readDouble());
                if (relativeURL != null && relativeURL.equals("")) {
                    relativeURL = null;
                }
                try {
                    chart.setDialPlotBGImage(new URL(url), relativeURL, option);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, "Failed to set background image", ex);
                }
                boolean pack = in.readBoolean();
                if (pack) {
                    int count = in.readInt();
                    byte[] bytes = new byte[count];
                    in.readFully(bytes, 0, count);
                    chart.setDialPlotBGImageByteArray(bytes);
                }
            } else {
                chart.setDialPlotBGImage(null, null, 3);
            }
        }
        if (this.version >= 11) {
            chart.lineList.removeAllElements();
            size = in.readInt();
            for (int i = 0; i < size; ++i) {
                chart.addLine(PolyLine.read(in, this.version));
            }
        }
        if (this.version >= 23) {
            int i;
            int len = in.readInt();
            int[][] buffer = new int[len][];
            long[][] time = new long[len][];
            boolean[] isAsc = new boolean[len];
            IFormat[] dataFormat = new IFormat[len];
            boolean[][] b = new boolean[len][];
            boolean[][] b2 = new boolean[len][];
            int[][] fieldType = new int[len][];
            int[][] axisPosition = new int[len][];
            int[][] org_fieldType = new int[len][];
            int[][] org_axisPosition = new int[len][];
            double[][] handLength = new double[len][];
            boolean[] drawNullColumn = new boolean[len];
            String[] nullColumnName = new String[len];
            int[] dataOrdering = new int[len];
            for (i = 0; i < len; ++i) {
                int j;
                int newLength;
                if (this.version > 104) {
                    buffer[i] = new int[5];
                    time[i] = new long[2];
                } else {
                    buffer[i] = new int[3];
                }
                buffer[i][0] = in.readInt();
                if (this.version >= 41) {
                    buffer[i][1] = in.readInt();
                }
                if (this.version >= 409) {
                    buffer[i][4] = in.readInt();
                }
                buffer[i][2] = in.readInt();
                if (this.version > 104) {
                    buffer[i][3] = in.readInt();
                    time[i][0] = in.readBoolean() ? in.readLong() : -1L;
                    time[i][1] = in.readBoolean() ? in.readLong() : -1L;
                    isAsc[i] = in.readBoolean();
                }
                if (this.version >= 411) {
                    drawNullColumn[i] = in.readBoolean();
                    nullColumnName[i] = IOUtil.readString(in, true);
                }
                dataOrdering[i] = this.version >= 504 ? in.readInt() : 3;
                if (this.version > 87 || this.version >= 82 && this.version <= 86) {
                    dataFormat[i] = this.readDataFormat(in, this.version);
                } else {
                    switch (buffer[i][2]) {
                        case 99: {
                            dataFormat[i] = IOUtil.readNumericFormat(in);
                            break;
                        }
                        case 8: 
                        case 9: 
                        case 10: {
                            dataFormat[i] = IOUtil.readDateTimeFormat(in, this.version);
                            break;
                        }
                        case 0: {
                            dataFormat[i] = new LogicalFormat(in.readInt());
                            break;
                        }
                    }
                }
                if (this.version >= 52) {
                    int len2 = in.readInt();
                    int newLength2 = i < colData.length ? (colData[i].getHideLegend() == null ? 0 : colData[i].getHideLegend().length) : 0;
                    if (len2 > 0) {
                        if (newLength2 > 0) {
                            b[i] = new boolean[newLength2];
                            b2[i] = new boolean[newLength2];
                        }
                        for (int j2 = 0; j2 < len2; ++j2) {
                            boolean temp = in.readBoolean();
                            if (j2 < newLength2) {
                                b[i][j2] = temp;
                            }
                            if (this.version < 55) continue;
                            temp = in.readBoolean();
                            if (j2 >= newLength2) continue;
                            b2[i][j2] = temp;
                        }
                    }
                }
                if (this.version >= 107) {
                    int typeLen;
                    int temp3 = -1;
                    newLength = i < colData.length ? (colData[i].getFieldType() == null ? 0 : colData[i].getFieldType().length) : 0;
                    if (newLength < (typeLen = in.readInt())) {
                        newLength = typeLen;
                    }
                    org_fieldType[i] = new int[typeLen];
                    org_axisPosition[i] = new int[typeLen];
                    if (newLength > 0) {
                        fieldType[i] = this.initFieldType(new int[newLength]);
                        axisPosition[i] = new int[newLength];
                        for (int w = 0; w < newLength; ++w) {
                            axisPosition[i][w] = -1;
                        }
                    }
                    for (j = 0; j < typeLen; ++j) {
                        int temp2 = in.readInt();
                        if (this.version >= 141 && this.version < 232) {
                            temp3 = in.readBoolean() ? -2 : -1;
                        } else if (this.version >= 232) {
                            temp3 = in.readInt();
                        }
                        org_fieldType[i][j] = temp2;
                        org_axisPosition[i][j] = temp3;
                        fieldType[i][j] = temp2;
                        axisPosition[i][j] = temp3;
                    }
                }
                if (this.version < 142) continue;
                double temp4 = 0.9;
                newLength = i < colData.length ? (colData[i].getHandLength() == null ? 0 : colData[i].getHandLength().length) : 0;
                int handLen = in.readInt();
                if (newLength > 0) {
                    handLength[i] = this.initHandLength(new double[newLength]);
                }
                for (j = 0; j < handLen; ++j) {
                    temp4 = in.readDouble();
                    if (j >= newLength) continue;
                    handLength[i][j] = temp4;
                }
            }
            for (i = 0; i < colData.length && i < len; ++i) {
                colData[i].sepSize = buffer[i][0];
                if (this.version >= 41) {
                    colData[i].tickerSepSize = buffer[i][1];
                }
                if (colData[i].axisType == buffer[i][2]) {
                    colData[i].dataFormat = dataFormat[i];
                }
                if (this.version > 104) {
                    colData[i].sepUnit = buffer[i][3];
                    colData[i].isAscending = isAsc[i];
                    if (time[i][0] != -1L) {
                        colData[i].setStartingDate(new Date(time[i][0]));
                    }
                    if (time[i][1] != -1L) {
                        colData[i].setEndingDate(new Date(time[i][1]));
                    }
                }
                if (this.version >= 411) {
                    colData[i].setDrawNullColumn(drawNullColumn[i]);
                    colData[i].setNullColumnName(nullColumnName[i]);
                }
                colData[i].setDataOrder(dataOrdering[i]);
                if (this.version >= 409) {
                    colData[i].maxNumOfTickerAndLabel = buffer[i][4];
                }
                if (this.version >= 52) {
                    colData[i].setHideLegend(b[i]);
                }
                if (this.version >= 55) {
                    colData[i].setHideData(b2[i]);
                }
                if (this.version >= 107) {
                    colData[i].setFieldType(fieldType[i]);
                }
                if (this.version >= 141) {
                    colData[i].setAxisPosition(axisPosition[i]);
                }
                if (this.version >= 142) {
                    colData[i].setHandLength(handLength[i]);
                }
                if (this.version >= 411) {
                    colData[i].setDrawNullColumn(drawNullColumn[i]);
                }
                colData[i].org_fieldType = org_fieldType[i];
                colData[i].org_showAxis = org_axisPosition[i];
            }
        }
        if (this.version >= 133 && in.readBoolean()) {
            chart.secData = new ColData(colData[chart.valueCol].getName(), colData[chart.valueCol].getOriginalDataType(), colData.length);
            chart.secData.copyAttributes(colData[chart.valueCol]);
            chart.secData.sepSize = in.readInt();
            chart.secData.tickerSepSize = in.readInt();
            if (this.version >= 409) {
                chart.secData.maxNumOfTickerAndLabel = in.readInt();
            }
            IFormat dataFormat = this.readDataFormat(in, this.version);
            if (chart.secData.dataFormat.getFormatType() < 3) {
                chart.secData.dataFormat = dataFormat;
            }
        }
        if (this.version >= 232) {
            if (in.readBoolean()) {
                int i;
                int ct = in.readInt();
                ColData[] tmpAxisData = new ColData[ct];
                Font f = new Font("Courier", 1, 12);
                Axis[] tmpColDataAxis = new Axis[ct];
                for (i = 0; i < ct; ++i) {
                    if (!in.readBoolean()) continue;
                    tmpAxisData[i] = new ColData(colData[chart.valueCol].getName(), colData[chart.valueCol].getOriginalDataType(), tmpAxisData.length);
                    tmpAxisData[i].copyAttributes(colData[chart.valueCol]);
                    tmpAxisData[i].sepSize = in.readInt();
                    tmpAxisData[i].tickerSepSize = in.readInt();
                    if (this.version >= 409) {
                        tmpAxisData[i].maxNumOfTickerAndLabel = in.readInt();
                    }
                    IFormat dataFormat = this.readDataFormat(in, this.version);
                    if (tmpAxisData[i].dataFormat == null || tmpAxisData[i].dataFormat.getFormatType() < 3) {
                        tmpAxisData[i].dataFormat = dataFormat;
                    }
                    tmpColDataAxis[i] = chart.setAxis(1, new CString("", f, 4), false);
                    this.readAxis(tmpColDataAxis[i], this.version, in);
                }
                if (!this.istemplate) {
                    chart.axisData = tmpAxisData;
                    chart.colDataAxis = tmpColDataAxis;
                } else if (chart.colDataAxis != null) {
                    for (i = 0; i < chart.colDataAxis.length && i < tmpColDataAxis.length; ++i) {
                        chart.colDataAxis[i] = tmpColDataAxis[i];
                    }
                }
                if (chart.mDataMap != null && chart.mDataMap.length > 0 && chart.mDataMap[0] < colData.length && colData[chart.mDataMap[0]] != null) {
                    colData[chart.mDataMap[0]].org_colDataAxis = new Axis[chart.colDataAxis.length];
                    for (i = 0; i < chart.colDataAxis.length; ++i) {
                        if (chart.colDataAxis == null || chart.colDataAxis[i] == null) continue;
                        colData[chart.mDataMap[0]].org_colDataAxis[i] = new Axis2D((Axis2D)chart.colDataAxis[i]);
                    }
                }
            }
            chart.setAutoAxisPosition(in.readBoolean());
            chart.setAxisGapOffset(in.readInt());
        }
        if (this.version >= 505) {
            try {
                int index = in.readInt();
                if (index >= 0 && index < ChartColorSet.colorSetArr.length) {
                    Color[] colorArr = IOUtil.readColorList(in);
                    chart.chartColorSet.setColorSetIndex(index);
                    chart.chartColorSet.setChartDataPointsColors(colorArr);
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Failed to set color set for the value axis", ex);
            }
        }
        if (this.version >= 506) {
            try {
                boolean saveColors = in.readBoolean();
                chart.setSaveColorsForCategories(saveColors);
                chart.chartColorSet.setDataPointsColorsMapped(saveColors);
                if (saveColors || chart.getChartType() == 14) {
                    chart.unusedDataAttribute = dat.join(chart.unusedDataAttribute);
                }
                if (dat2 != null) {
                    int index2 = in.readInt();
                    Color[] colorArr2 = null;
                    if (index2 >= 0 && index2 < ChartColorSet.colorSetArr.length) {
                        colorArr2 = IOUtil.readColorList(in);
                    }
                    if (chart.mData2 != null && chart.getSubValueMap() >= 0) {
                        chart.chartColorSet2.setDataPointsColorsMapped(chart.isSaveColorsForCategories());
                        chart.chartColorSet2.setColorSetIndex(index2);
                        chart.chartColorSet2.setChartDataPointsColors(colorArr2);
                        if (saveColors) {
                            chart.unusedDataAttribute2 = dat2.join(chart.unusedDataAttribute2);
                        }
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Failed to load chart colors", ex);
            }
        }
        if (this.version >= 507) {
            chart.setSingleColorForCategories(in.readBoolean());
        } else {
            chart.setSingleColorForCategories(false);
        }
        if (this.version >= 27) {
            int hsize = in.readInt();
            for (int i = 0; i < hsize; ++i) {
                HyperLink hl = HyperLink.read(in, this.version >= 34, this.isUTFString);
                if (this.version >= 64 && hl != null) {
                    hl.readHint(in, this.isUTFString);
                }
                chart.updateHyperLink(hl);
            }
        }
        if (this.version >= 190 || this.version >= 174 && this.version <= 185) {
            chart.setShowDataState(in.readBoolean());
        }
        if (this.version <= 7099 && this.version >= 502 || this.version <= 4999 && this.version >= 4005) {
            chart.flashEnableHintBox = in.readBoolean();
        }
        if (this.version <= 7099 && this.version >= 500 || this.version <= 4999 && this.version >= 4004) {
            chart.flashHintFont = IOUtil.readFont(in, this.isUTFString);
            chart.flashHintFontColor = IOUtil.readColor(in);
            chart.flashHintBgColor = IOUtil.readColor(in);
            chart.flashHintBorderColor = IOUtil.readColor(in);
        }
        if (this.version >= 147) {
            if (this.version < 162) {
                chart.setControlRangeThickness(in.readInt());
            }
            int ct = in.readInt();
            Vector<ControlRange> colorCodeList = new Vector<ControlRange>();
            for (int i = 0; i < ct; ++i) {
                ControlRange code = ControlRange.read(in, this.version);
                if (code == null) continue;
                colorCodeList.addElement(code);
            }
            chart.setControlRangeList(colorCodeList);
        }
        chart.dataLineSet.read(in, this.version);
        chart.annotationSet.read(in, this.version);
        chart.valueTable.read(in, this.version);
        if (this.version > 86) {
            if (!Chart.isCoordinateType(chart.chartType)) {
                chart.tableInPanel = in.readBoolean();
                if (this.version >= 305 || this.version >= 286 && this.version <= 300) {
                    chart.setSecondaryDataShownInPrimaryTab(in.readBoolean());
                }
                if (chart.showTable()) {
                    GraphicsTable.loadTable(in, this.version, chart, this.isUTFString, this.istemplate);
                }
            } else {
                boolean showTable = in.readBoolean();
                if (this.version >= 305 || this.version >= 286 && this.version <= 300) {
                    chart.setSecondaryDataShownInPrimaryTab(in.readBoolean());
                }
                if (showTable) {
                    GraphicsTable.loadDummyTable(in, this.version, chart, this.isUTFString);
                }
            }
        }
        if (this.version < 103 && chartType == 12) {
            if (this.version >= 90) {
                Color surfaceColor = IOUtil.readColor(in);
                chart.set3DSurfaceColor(surfaceColor);
            }
            if (this.version >= 96) {
                chart.readSurfaceHyperLinkList(in, this.isUTFString);
            }
        }
        chart.colorSpectrum = IOUtil.readColorSpectrum(in, this.version);
        if (this.version >= 108) {
            chart.is3DApproximationUsed = in.readBoolean();
            if (this.version > 108) {
                chart.approximationThreshold = in.readInt();
            }
        }
        if (this.version >= 382) {
            chart.getPrimaryDataGradientSupport().setGradientEnabled(in.readBoolean());
        }
        if (this.version >= 384) {
            chart.getPrimaryDataGradientSupport().set3DShadingEnabled(in.readBoolean());
        }
        if (this.version <= 7099 && this.version >= 414 || this.version <= 2999 && this.version >= 2003 || this.version <= 4999 && this.version >= 4003) {
            chart.getPrimaryDataGradientSupport().setApplyGradientToChartDataOnly(in.readBoolean());
        }
        if (this.version >= 410) {
            chart.getPrimaryDataGradientSupport().setGradientStartX(in.readDouble());
            chart.getPrimaryDataGradientSupport().setGradientStartY(in.readDouble());
            chart.getPrimaryDataGradientSupport().setGradientEndX(in.readDouble());
            chart.getPrimaryDataGradientSupport().setGradientEndY(in.readDouble());
            if (in.readBoolean()) {
                chart.getPrimaryDataGradientSupport().setGradientDesColor(IOUtil.readColor(in));
            }
            chart.getPrimaryDataGradientSupport().setGradientShade(in.readInt());
            chart.getPrimaryDataGradientSupport().setGradientCyclic(in.readBoolean());
        }
        if (this.version <= 7099 && this.version >= 4103) {
            chart.getSecondaryDataGradientSupport().setGradientEnabled(in.readBoolean());
            chart.getSecondaryDataGradientSupport().set3DShadingEnabled(in.readBoolean());
            chart.getSecondaryDataGradientSupport().setGradientStartX(in.readDouble());
            chart.getSecondaryDataGradientSupport().setGradientStartY(in.readDouble());
            chart.getSecondaryDataGradientSupport().setGradientEndX(in.readDouble());
            chart.getSecondaryDataGradientSupport().setGradientEndY(in.readDouble());
            if (in.readBoolean()) {
                chart.getSecondaryDataGradientSupport().setGradientDesColor(IOUtil.readColor(in));
            }
            chart.getSecondaryDataGradientSupport().setGradientShade(in.readInt());
            chart.getSecondaryDataGradientSupport().setGradientCyclic(in.readBoolean());
        }
        if (this.version < 4103 && chart.getPrimaryDataGradientSupport().isGradientEnabled()) {
            boolean applyToChartDataOnly = chart.getPrimaryDataGradientSupport().isApplyGradientToChartDataOnly();
            chart.getPrimaryDataGradientSupport().setApplyGradientToChartDataOnly(true);
            chart.getSecondaryDataGradientSupport().copy(chart.getPrimaryDataGradientSupport());
            if (!applyToChartDataOnly) {
                Vector<IAnnotation> annotationList;
                Vector<ControlRange> controlList;
                if (chart.desktopArea != null) {
                    GradientSupport.copy(chart.getPrimaryDataGradientSupport(), chart.desktopArea);
                }
                if (chart.background != null) {
                    GradientSupport.copy(chart.getPrimaryDataGradientSupport(), chart.background);
                }
                if (chart.legend != null) {
                    GradientSupport.copy(chart.getPrimaryDataGradientSupport(), chart.legend.area);
                }
                if (chart.legend2 != null) {
                    GradientSupport.copy(chart.getPrimaryDataGradientSupport(), chart.legend2.area);
                }
                if ((controlList = chart.getControlRangeList()) != null) {
                    for (ControlRange element : controlList) {
                        GradientSupport.copy(chart.getPrimaryDataGradientSupport(), element);
                    }
                }
                if ((annotationList = chart.getAnnotations()) != null) {
                    for (IAnnotation element : annotationList) {
                        GradientSupport.copy(chart.getPrimaryDataGradientSupport(), element);
                    }
                }
            }
        }
        if (this.version >= 129) {
            chart.setDrawSeriesOnCategoryAxis(in.readBoolean());
        }
        if (this.version >= 148) {
            chart.setXMLChartLocation(IOUtil.readString(in, this.isUTFString));
        }
        chart.performColDataSort();
        if (this.version >= 306) {
            chart.setSortValue(in.readInt());
            chart.performValueSort();
        }
        if (chart.colDataHasChangedBecauseOfAggrHistZoom) {
            chart.colDataHasChangedBecauseOfAggrHistZoom = false;
        }
        if (this.version >= 506) {
            try {
                dat.matchData(chart.mData.chart.dataDim, false, is2DChart, chartType, chart.isUniqueColorForCol(), chart.mData, chart.unusedDataAttribute, chart.chartColorSet);
                dat.loadAttribute(chart.mData, chart.is2DChart, chart.chartType, chart.isUniqueColorForCol());
                if (dat2 != null && chart.mData2 != null && chart.getSubValueMap() >= 0) {
                    dat2.matchData(chart.mData2.chart.dataDim, true, chart.mData2.chart.is2DChart, chart.mData2.chart.chartType, chart.isUniqueColorForCol(), chart.mData2, chart.unusedDataAttribute2, chart.chartColorSet2);
                    dat2.loadAttribute(chart.mData2, chart.mData2.chart.is2DChart, chart.mData2.chart.chartType);
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Failed to load chart colors", ex);
            }
        } else {
            DataAttribute mergedDA;
            chart.chartColorSet = new ChartColorSet(false);
            chart.chartColorSet.setDataPointsColorsMapped(true);
            chart.unusedDataAttribute = mergedDA = dat.join(chart.unusedDataAttribute);
            chart.chartColorSet.setChartDataPointsColors((Color[])mergedDA.dataColor.clone());
            if (dat.name != null) {
                dat.matchData(chart.mData.chart.dataDim, false, chart.mData.chart.is2DChart, chart.mData.chart.chartType, chart.isUniqueColorForCol(), chart.mData, chart.unusedDataAttribute, chart.chartColorSet);
            } else {
                chart.chartColorSet.setDataPointsColorsMapped(false);
            }
            dat.loadAttribute(chart.mData, chart.is2DChart, chart.chartType, chart.isUniqueColorForCol());
            if (chart.mData2 != null) {
                chart.chartColorSet2 = new ChartColorSet(true);
                chart.chartColorSet2.setDataPointsColorsMapped(true);
                if (dat2 != null && chart.getSubValueMap() >= 0) {
                    DataAttribute mergedDA2;
                    chart.unusedDataAttribute2 = mergedDA2 = dat2.join(chart.unusedDataAttribute2);
                    chart.chartColorSet2.setChartDataPointsColors((Color[])mergedDA2.dataColor.clone());
                    if (dat2.name != null) {
                        dat2.matchData(chart.mData2.chart.dataDim, true, chart.mData2.chart.is2DChart, chart.mData2.chart.chartType, chart.isUniqueColorForCol(), chart.mData2, chart.unusedDataAttribute2, chart.chartColorSet2);
                    } else {
                        chart.chartColorSet2.setDataPointsColorsMapped(false);
                    }
                    dat2.loadAttribute(chart.mData2, chart.mData2.chart.is2DChart, chart.mData2.chart.chartType);
                }
            }
        }
        if (this.version >= 230) {
            this.readDrillDownNodes(in);
            if (chart.currentNode == null) {
                try {
                    DrillDownNode root = new DrillDownNode("ROOT");
                    if (this.childDrillDownNodes != null) {
                        for (int i = 0; i < this.childDrillDownNodes.size(); ++i) {
                            root.add(this.childDrillDownNodes.elementAt(i));
                        }
                    }
                    chart.currentNode = root;
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINER, "Failed to add child drilldown nodes to drilldown tree", ex);
                }
            }
        }
        chart.registryID = registryID;
        chart.dataSourceID = dataSourceID;
        chart.dataSourceLoc = dataSourceLoc;
        chart.setTickerOrder();
        if (this.pack && (this.version <= 7099 && this.version >= 503 || this.version <= 4999 && this.version >= 4000)) {
            int subFilesCt = in.readInt();
            for (int i = 0; i < subFilesCt; ++i) {
                String subFileName = IOUtil.readString(in, true);
                int count = in.readInt();
                byte[] bytes = new byte[count];
                in.readFully(bytes, 0, count);
                if (this.dontExpandSubFilesForPac) continue;
                chart.putChartFileIntoMemoryTable(subFileName, bytes);
            }
        }
        return chart;
    }

    private void loadLegend(DataInput in, Legend legend, int version, Chart ch) throws IOException {
        legend.setFont(IOUtil.readFont(in, this.isUTFString), in.readInt());
        if (version >= 391) {
            legend.setPointSizeRatio(in.readInt());
        }
        legend.setfontColor(IOUtil.readColor(in));
        legend.setBackground(IOUtil2.readArea(in, version, ch));
        legend.setBorder(IOUtil2.readArea(in, version, ch));
        if (version >= 7) {
            legend.area.appearance = in.readInt();
        }
        if (version >= 25) {
            legend.area.depth = in.readInt();
        }
        legend.setLayout(in.readBoolean() ? 1 : 0);
        if (version <= 7099 && version >= 4101) {
            legend.setLayout(in.readInt());
            legend.setFixedColumnCount(in.readInt());
        }
        legend.showLegend = in.readBoolean();
        if (version >= 6610) {
            legend.useOneLegendSet = ((VersioningDataInput)in).readBoolean();
        }
        if (version >= 9) {
            legend.reverse = in.readBoolean();
        }
        if (version >= 74) {
            legend.drawSymbols = in.readBoolean();
        }
    }

    private ColData[] createColData(DataInput in, int version) throws IOException {
        return LoadChart.createColData(in, version, true);
    }

    static ColData[] createColData(DataInput in, int version, boolean isUTFString) throws IOException {
        DataInput newin;
        if (version >= 30) {
            byte[] encrypb = new byte[in.readInt()];
            in.readFully(encrypb, 0, encrypb.length);
            newin = new DataInputStream(new ByteArrayInputStream(IOUtil.decode(encrypb, version)));
        } else {
            newin = in;
        }
        int nCol = newin.readInt();
        int nRow = newin.readInt();
        ArrayList<ColData> colData = new ArrayList<ColData>();
        for (int i = 0; i < nCol; ++i) {
            int dtype = newin.readInt();
            ColData column = new ColData(IOUtil.readString(newin, isUTFString), dtype, nRow, nCol);
            for (int j = 0; j < nRow; ++j) {
                column.add(DataType.read(newin, dtype, version, isUTFString));
            }
            colData.add(column);
        }
        if (!"qbCount".equals(((ColData)colData.get(colData.size() - 1)).getName())) {
            ColData column = new ColData("qbCount", 4, nCol);
            for (int i = 0; i < nRow; ++i) {
                column.add(i);
            }
            colData.add(column);
        }
        return colData.toArray(new ColData[colData.size()]);
    }

    private IFormat readDataFormat(DataInput in, int version) throws IOException {
        IFormat dataFormat = null;
        int formatType = in.readInt();
        switch (formatType) {
            case 0: {
                dataFormat = new LogicalFormat(in.readInt());
                break;
            }
            case 1: {
                dataFormat = IOUtil.readNumericFormat(in);
                break;
            }
            case 2: {
                dataFormat = IOUtil.readLocaleNumericFormat(in, version);
                break;
            }
            case 3: {
                dataFormat = IOUtil.readDateTimeFormat(in, version);
                break;
            }
            case 4: {
                dataFormat = IOUtil.readLocaleDateTimeFormat(in, version);
                break;
            }
        }
        return dataFormat;
    }

    private int[] initFieldType(int[] fieldType) {
        if (fieldType == null || fieldType.length <= 1) {
            return fieldType;
        }
        for (int i = 0; i < fieldType.length; ++i) {
            fieldType[i] = i == 0 ? 7 : (i == 1 ? 0 : 3);
        }
        return fieldType;
    }

    private double[] initHandLength(double[] handLength) {
        if (handLength == null || handLength.length <= 0) {
            return handLength;
        }
        double sector = 0.9 / (double)handLength.length;
        for (int i = 0; i < handLength.length; ++i) {
            handLength[i] = sector * (double)(handLength.length - i);
        }
        return handLength;
    }

    private void readLabelOffset(DataInput in, Chart chart) throws IOException {
        int labelCount = in.readInt();
        Dimension[] dim = new Dimension[labelCount];
        for (int i = 0; i < labelCount; ++i) {
            dim[i] = new Dimension(in.readInt(), in.readInt());
        }
        chart.setLabelOffset(dim);
    }

    public int getSourceDataType() {
        return this.sourceData;
    }

    public DBInfoBasic getDBInfo() {
        return this.dbInfo;
    }

    public static String generateFullName(String file) {
        String fullname = null;
        if (!(file.toLowerCase().endsWith(".cht") || file.toLowerCase().endsWith(".tpl") || file.toLowerCase().endsWith(".qch") || file.toLowerCase().endsWith("pac") || file.toLowerCase().endsWith(".xml"))) {
            FileInfo fInfo = new FileInfo(file + ".xml");
            try {
                if (fInfo.exists()) {
                    fullname = file + ".xml";
                    return fullname;
                }
                fInfo = new FileInfo(file + ".tpl");
                if (fInfo.exists()) {
                    fullname = file + ".tpl";
                    return fullname;
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to check if file exists", ex);
            }
            fullname = file + ".cht";
            return fullname;
        }
        return file;
    }

    protected void loadTree(DataInput in) throws IOException {
        boolean existed = in.readBoolean();
        if (!existed) {
            this.drillDownNode = null;
            return;
        }
        this.drillDownNode = this.loadTreeNode(in, true);
    }

    private DrillDownNode loadTreeNode(DataInput in, boolean loadChildren) throws IOException {
        int i;
        String nodeName = IOUtil.readString(in, true);
        DrillDownNode node = new DrillDownNode(nodeName);
        String nodeFileName = IOUtil.readString(in, true);
        node.setFileName(nodeFileName);
        int count = in.readInt();
        int[] mapping = new int[count];
        for (i = 0; i < count; ++i) {
            mapping[i] = in.readInt();
        }
        node.setColumnMapping(mapping);
        if (loadChildren) {
            count = in.readInt();
            for (i = 0; i < count; ++i) {
                node.add(this.loadTreeNode(in, true));
            }
        }
        return node;
    }

    private void readDrillDownNodes(DataInput in) throws IOException {
        boolean existed = in.readBoolean();
        if (!existed) {
            this.childDrillDownNodes = null;
        } else {
            this.childDrillDownNodes = new Vector();
            int count = in.readInt();
            for (int i = 0; i < count; ++i) {
                this.childDrillDownNodes.addElement(this.loadTreeNode(in, false));
            }
        }
    }

    public Vector<DrillDownNode> getChildNodes() {
        return this.childDrillDownNodes;
    }

    public DrillDownNode getDrillDownNode() {
        return this.drillDownNode;
    }

    private void readAxis(Axis ax, int version, DataInput in) throws IOException {
        boolean readTicker;
        ax.bshow = in.readBoolean();
        ax.title = IOUtil2.readCString(in, this.isUTFString);
        ax.titleoffset = in.readInt();
        if (version >= 5) {
            ax.titlevoffset = in.readInt();
        }
        if (version >= 232) {
            ax.color = IOUtil.readColor(in);
        }
        ax.grid.color = IOUtil.readColor(in);
        ax.grid.bshow = in.readBoolean();
        if (version >= 25) {
            ax.gridThickness = in.readInt();
        }
        if (version >= 6608) {
            ax.gridLineStyle = in.readInt();
        }
        ax.logScale = in.readBoolean();
        if (version >= 131) {
            ax.setShowLogValue(in.readBoolean());
            ax.setBaseForLog(in.readDouble());
        }
        if (version >= 277) {
            ax.setShowSubTickers(in.readBoolean());
        }
        ax.autoscale = in.readBoolean();
        if (version >= 80) {
            ax.autoOrigin = in.readBoolean();
        }
        if (version >= 303) {
            ax.addAxisPadding = in.readBoolean();
        }
        if (version >= 112) {
            ax.setLabelOutsidePlotArea(in.readBoolean());
        }
        if (!ax.autoscale || version >= 12) {
            ax.maxScale = in.readDouble();
            ax.minScale = in.readDouble();
            ax.stepScale = in.readDouble();
            if (version >= 278) {
                ax.stepScaleMonth = in.readInt();
            }
            if (ax.stepScale == -99.0) {
                ax.setDynamicAutoScale(true);
            }
        }
        if (version >= 59) {
            double axisShift = in.readDouble();
            ax.setAxisShift(axisShift);
        }
        if (readTicker = in.readBoolean()) {
            int count;
            Color tickerColor;
            ax.showTicker = in.readBoolean();
            ax.ticker.color = tickerColor = IOUtil.readColor(in);
            ax.ticker.label_color = version >= 75 ? IOUtil.readColor(in) : tickerColor;
            ax.ticker.setFont(IOUtil.readFont(in, this.isUTFString));
            ax.ticker.angle = in.readInt();
            ax.ticker.automatic = false;
            ax.ticker.twidth = in.readInt();
            if (version >= 5) {
                ax.ticker.displacement = in.readInt();
            }
            if (version >= 46) {
                ax.ticker.showline = in.readBoolean();
            }
            if (version >= 276) {
                ax.ticker.tickerInward = in.readBoolean();
            }
            if (version >= 170 && (count = in.readInt()) > 0) {
                ax.ticker.tickerLabel = new String[count];
                for (int q = 0; q < count; ++q) {
                    ax.ticker.tickerLabel[q] = IOUtil.readString(in, this.isUTFString);
                }
            }
            if (version >= 317) {
                ax.ticker.radarXOffset = in.readInt();
                ax.ticker.radarYOffset = in.readInt();
            }
        }
    }

    protected ColData[] processColData(ColData[] colData, boolean template, boolean forEntpServer, boolean isTSChart, boolean histogram, boolean isAggregatedChart, PreprocInfo tsInfo, Vector<QueryInParamSet> parameter, boolean isPrevParamPrompt) throws IOException {
        return this.processColData(colData, template, forEntpServer, isTSChart, histogram, false, 0, isAggregatedChart, tsInfo, parameter, isPrevParamPrompt);
    }

    protected ColData[] processColData(ColData[] colData, boolean template, boolean forEntpServer, boolean isTSChart, boolean histogram, boolean showPercentage, int binNumber, boolean isAggregatedChart, PreprocInfo tsInfo, Vector<QueryInParamSet> parameter, boolean isPrevParamPrompt) throws IOException {
        block54: {
            if (this.usingBackupData && this.backupColData != null) {
                colData = this.backupColData;
                this.originalColDataFromMemSource = colData;
                this.originalSourceData = this.sourceData;
                this.sourceData = 14;
                return colData;
            }
            try {
                if (this.queryFileInfo != null) {
                    parameter = QueryFileInfo.getParameter(this.queryFileInfo, false, forEntpServer, true, false, true);
                } else if (this.dbInfo instanceof QueryFileInfo) {
                    if (this.preSetParams == null || this.preSetParams.size() < 1) {
                        if (this.drillDownNode == null && !isPrevParamPrompt || this.useDefaults) {
                            try {
                                QueryInParam[] pArray;
                                for (QueryInParam element : pArray = ((QueryFileInfo)this.dbInfo).getInSet().getParameter()) {
                                    element.setValue(element.getDefaultValue((QueryFileInfo)this.dbInfo));
                                }
                                parameter = new Vector();
                                parameter.addElement(((QueryFileInfo)this.dbInfo).getInSet());
                            }
                            catch (Exception ex) {
                                LOGGER.log(Level.FINE, "Failed to use default parameter values", ex);
                            }
                        }
                        if (parameter == null) {
                            parameter = QueryFileInfo.getParameter((QueryFileInfo)this.dbInfo, false, forEntpServer, true, false, true);
                        }
                    } else if (this.preSetParams.elementAt(0) instanceof QueryInParamSet) {
                        if (this.preSetParams.size() > 0) {
                            ((QueryFileInfo)this.dbInfo).setInSet((QueryInParamSet)this.preSetParams.elementAt(0));
                        }
                        parameter = this.preSetParams;
                    } else {
                        QueryInParam[] ps = ((QueryFileInfo)this.dbInfo).getInSet().getParameter();
                        Object[] values = (Object[])this.preSetParams.elementAt(0);
                        int unMappedCt = 0;
                        for (Object value : values) {
                            if (value == null || !value.equals("UnMapped")) continue;
                            ++unMappedCt;
                        }
                        if (unMappedCt > 0) {
                            if (isPrevParamPrompt) {
                                QueryInParam[] unMappedParam = new QueryInParam[unMappedCt];
                                unMappedCt = 0;
                                for (int i = 0; i < values.length; ++i) {
                                    if (values[i] == null || !values[i].equals("UnMapped")) continue;
                                    unMappedParam[unMappedCt++] = ps[i];
                                }
                                DBInfoBasic newDBInfo = this.dbInfo.isUseJNDIDataSource() ? new DBInfoBasic(this.dbInfo.getJNDIName(), this.dbInfo.getQuery(), this.dbInfo.getEnvProperties()) : new DBInfoBasic(this.dbInfo.getURLString(), this.dbInfo.getDriverName(), this.dbInfo.getUserID(), this.dbInfo.getPassword(), this.dbInfo.getQuery(), this.dbInfo.getAdditionalDb());
                                QueryFileInfo qfi = new QueryFileInfo(((QueryFileInfo)this.dbInfo).getProductName(), ((QueryFileInfo)this.dbInfo).getVersion(), newDBInfo, new QueryInParamSet(unMappedParam));
                                parameter = QueryFileInfo.getParameter(qfi, false, forEntpServer, true, false, true);
                                unMappedCt = 0;
                                QueryInParam[] params = parameter.elementAt(0).getParameter();
                                for (int i = 0; i < values.length; ++i) {
                                    if (values[i] != null && values[i].equals("UnMapped")) {
                                        ps[i].setValue(params[unMappedCt++].getValue());
                                        continue;
                                    }
                                    ps[i].setValue(values[i]);
                                }
                            } else {
                                for (int i = 0; i < values.length; ++i) {
                                    if (values[i] != null && values[i].equals("UnMapped")) {
                                        if (ps[i].getValue() != null && !ps[i].equals("UnMapped")) continue;
                                        ps[i].setValue(ps[i].getDefaultValue((QueryFileInfo)this.dbInfo));
                                        continue;
                                    }
                                    ps[i].setValue(values[i]);
                                }
                            }
                        } else {
                            for (int i = 0; i < ps.length; ++i) {
                                if (ps[i] instanceof QueryMultiValueInParam && values[i] instanceof Vector) {
                                    ((QueryMultiValueInParam)ps[i]).setValues((Vector)values[i]);
                                    continue;
                                }
                                if (values[i] != null && values[i] instanceof UseDefaultParam) {
                                    ps[i].setValue(ps[i].getDefaultValue((QueryFileInfo)this.dbInfo));
                                    continue;
                                }
                                ps[i].setValue(values[i]);
                            }
                        }
                        parameter = new Vector();
                        parameter.addElement(((QueryFileInfo)this.dbInfo).getInSet());
                    }
                    this.queryFileInfo = (QueryFileInfo)this.dbInfo;
                }
                if (this.forReport && this.isTransposed) {
                    this.originalColDataFromMemSource = colData;
                    int len = colData.length;
                    if (colData[len - 2].colName.equals("Value")) {
                        colData[len - 2].colName = "reportValue";
                    }
                    if (colData[len - 3].colName.equals("ColumnLabel")) {
                        colData[len - 3].colName = "reportColumnLabel";
                    }
                    colData = ColData.getColData(TransposeRS.doTranspose(colData, this.transposeCol));
                    break block54;
                }
                if (this.queryFileInfo == null && !(this.dbInfo instanceof QueryFileInfo) && (!template || colData != null)) break block54;
                if (this.sourceData == 1) {
                    boolean hasNull = false;
                    if (!hasNull) {
                        colData = DBAccess.retrieveResult(parameter, this.dbInfo, true, this.isTransposed, this.transposeCol, null, tsInfo);
                    }
                    break block54;
                }
                if (this.sourceData == 2 || this.sourceData == 4 || this.sourceData == 6 || this.sourceData == 7) {
                    PreprocInfo procInfo = null;
                    if (isTSChart || histogram || this.drillDownPresent || isAggregatedChart) {
                        procInfo = tsInfo;
                    }
                    colData = this.sourceData == 6 && this.dbInfo != null && this.dbInfo instanceof QueryClassFileInfo ? new DataFileInput().readProcessedData(this.sourceFile, this.isTransposed, this.transposeCol, null, procInfo, ((QueryClassFileInfo)this.dbInfo).getInSet()) : new DataFileInput().readProcessedData(this.sourceFile, this.isTransposed, this.transposeCol, null, procInfo, this.xmlFileQueryInfo, this.sourceData);
                    break block54;
                }
                if (this.sourceData == 9) {
                    colData = this.backupColData;
                    break block54;
                }
                if (this.sourceData == 12) {
                    colData = SOAPAccess.retrieveResult(this.soapInfo, this.isTransposed, this.transposeCol);
                    break block54;
                }
                if (this.sourceData == 11) {
                    colData = SalesForceAccess.getColData(this.sfQueryInfo, this.isTransposed, this.transposeCol, tsInfo);
                    break block54;
                }
                if (this.sourceData == 13) {
                    colData = ExcelAccess.getColData(this.excelInfo, this.isTransposed, this.transposeCol, tsInfo, 0, -1);
                    break block54;
                }
                if (this.sourceData == 10) {
                    OLAPAccess olapAccess = new OLAPAccess(null, this.mondrianConnectionString, this.MDXQuery, this.xmlaURI, this.xmlaDataSource, this.xmlaCatalog);
                    colData = olapAccess.retrieveResult(this.inputMethod);
                    break block54;
                }
                if (this.sourceData == 5) {
                    colData = isTSChart || histogram || this.drillDownPresent || isAggregatedChart ? EJBAccess.retrieveResult(this.jndiName, this.homeName, this.remoteName, this.selectedMethodName, this.selectedMethodParamVal, this.environment, this.isTransposed, this.transposeCol, null, tsInfo) : EJBAccess.retrieveResult(this.jndiName, this.homeName, this.remoteName, this.selectedMethodName, this.selectedMethodParamVal, this.environment, this.isTransposed, this.transposeCol, null, null);
                    break block54;
                }
                if (this.sourceData == 3) {
                    if (isTSChart || histogram || this.drillDownPresent || isAggregatedChart) {
                        colData = ColData.getColData(this.sourceList, this.sourceType, this.doTranspose, this.transposeColList, false, null, false);
                        colData = ColData.getColData(DBAccess.processResultSet(ColData.getResultSet(colData), false, this.isTransposed, this.transposeCol, null, tsInfo));
                    } else {
                        colData = ColData.getColData(this.sourceList, this.sourceType, this.doTranspose, this.transposeColList, this.isTransposed, this.transposeCol, false);
                    }
                    break block54;
                }
                if (this.sourceData == 0 || this.sourceData == 14) {
                    if (this.originalColDataFromMemSource != null) {
                        if (isTSChart || histogram || this.drillDownPresent || isAggregatedChart) {
                            colData = ColData.getColData(DBAccess.processResultSet(ColData.getResultSet(this.originalColDataFromMemSource), false, this.isTransposed, this.transposeCol, null, tsInfo));
                        } else if (ColData.isTransposed(this.originalColDataFromMemSource)) {
                            LOGGER.finer("Original data are already transposed. Use them without processing");
                            colData = this.originalColDataFromMemSource;
                        } else {
                            colData = ColData.getColData(DBAccess.processResultSet(ColData.getResultSet(this.originalColDataFromMemSource), false, this.isTransposed, this.transposeCol, null, null));
                        }
                    }
                    break block54;
                }
                throw new IOException("No plotting data and no data source available !");
            }
            catch (Exception ex) {
                if (this.backupColData != null) {
                    colData = this.backupColData;
                    this.originalColDataFromMemSource = colData;
                    this.originalSourceData = this.sourceData;
                    this.sourceData = 0;
                    this.errorMessage = IOUtil.getStackTrace(ex);
                    LOGGER.log(Level.WARNING, "Failed to load chart data, using backup data.", ex);
                }
                LOGGER.log(Level.SEVERE, "Failed to get data", ex);
                throw new IOException("Failed to get data :" + ex.toString());
            }
        }
        if (colData == null) {
            colData = this.backupColData;
            this.originalColDataFromMemSource = colData;
            this.originalSourceData = this.sourceData;
            this.sourceData = 0;
        }
        if (histogram && showPercentage && !colData[1].getName().startsWith("probability")) {
            colData = QbUtil.probabilityHistogram(colData);
        }
        return colData;
    }

    protected Chart processChart(ColData[] colData, Component component, int chartType, boolean is2DChart, boolean isTSChart, boolean histogram, boolean isAggregatedChart, PreprocInfo tsInfo, Vector parameter) {
        Chart chart = null;
        chart = Chart.createChart(component, chartType, is2DChart, null, colData);
        if (this.subFilesTable != null) {
            chart.setSubFilesTable(this.subFilesTable);
        }
        chart.setChanging3DChartType(false);
        chart.isTSChart = isTSChart;
        if (isTSChart || histogram || isAggregatedChart) {
            chart.tsInfo = tsInfo;
        }
        chart.sourceData = this.sourceData;
        chart.originalSourceData = this.originalSourceData;
        chart.dbInfo = this.dbInfo;
        chart.sourceFile = this.sourceFile;
        chart.xmlFileQueryInfo = this.xmlFileQueryInfo;
        chart.sfQueryInfo = this.sfQueryInfo;
        chart.excelInfo = this.excelInfo;
        chart.soapInfo = this.soapInfo;
        chart.excelInfo = this.excelInfo;
        chart.jndiName = this.jndiName;
        chart.homeName = this.homeName;
        chart.remoteName = this.remoteName;
        chart.selectedMethodName = this.selectedMethodName;
        chart.selectedMethodParamVal = this.selectedMethodParamVal;
        chart.environment = this.environment;
        chart.mondrianConnectionString = this.mondrianConnectionString;
        chart.MDXQuery = this.MDXQuery;
        chart.xmlaURI = this.xmlaURI;
        chart.xmlaDataSource = this.xmlaDataSource;
        chart.xmlaCatalog = this.xmlaCatalog;
        chart.inputMethod = this.inputMethod;
        chart.originalColDataFromMemSource = this.originalColDataFromMemSource;
        chart.sourceList = this.sourceList;
        chart.sourceType = this.sourceType;
        chart.doTranspose = this.doTranspose;
        chart.transposeColList = this.transposeColList;
        chart.queryFilename = this.queryFilename;
        chart.parameters = this.parameters;
        return chart;
    }
}

