/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.chart.ArcAngle;
import quadbase.chart.CGraphics;
import quadbase.chart.CString;
import quadbase.chart.Chart;
import quadbase.chart.IPieChart;
import quadbase.chart.MultiDimData;
import quadbase.chart.OffsetCString;
import quadbase.chart.Point3D;
import quadbase.chart.Point3DCompare;
import quadbase.common.util.internal.QbUtil;
import quadbase.util.IFormat;
import quadbase.util.LocaleNumericFormat;
import quadbase.util.internal.ICompareObject;
import quadbase.util.internal.SortObject;

public class PieChart {
    private static final Logger LOGGER = Logger.getLogger(PieChart.class.getName());
    private Chart chart;
    private IPieChart iPieChart;
    public static final int barThickness = 200;
    public static final int MIN_PIE_SECTORS = 24;
    public static final int DEFAULT_PIE_SECTORS = 40;
    public static final int MAX_PIE_SECTORS = 500;
    public boolean concentricDoughnut = false;
    public Point3D[] center;
    public int[] piewidth;
    public int[] pieheight;
    public double[] sum;
    public double[] othersSum;
    public OffsetCString[] catLabel;
    public OffsetCString[][] pieLabel;
    public OffsetCString[][] pieValue;
    public OffsetCString[][] piePercent;
    public Color catLabelColor = Color.black;
    public Color pieLabelColor = Color.black;
    public Color pieValueColor = Color.black;
    public Color piePercentColor = Color.black;
    public Font catLabelFont = CString.defaultfont;
    public Font pieLabelFont = CString.defaultfont;
    public Font pieValueFont = CString.defaultfont;
    public Font piePercentFont = CString.defaultfont;
    public double catLabelAngle = 0.0;
    public double pieLabelAngle = 0.0;
    public double pieValueAngle = 0.0;
    public double piePercentAngle = 0.0;
    public boolean showLabel = false;
    public boolean showPercent = true;
    public boolean showValue = false;
    public boolean showCategory = true;
    public boolean doSectorGap = false;
    public int initangle = 0;
    public double fontdistance = 1.1;
    public double catLabelDistance = 1.25;
    public double sliceDistance = 0.4;
    public double gapRatioBetweenPies = 0.5;
    public boolean smartlabel = false;
    public boolean valInLegend = false;
    public boolean radialBorder = true;
    public boolean zeroLabelsVisible = true;
    public Color pieBorderColor = Color.black;
    public boolean pieExtendLine = false;
    public boolean labelAtTheSide = false;
    public int pieSectors = 40;
    public int[] pieThickness;
    public int piePerRow = 0;
    public boolean drawLinearly = false;
    public boolean bestFit = true;
    public static boolean DEFAULTNEWLABELPLACEMENT = true;
    public boolean pieLabelWithDirection = DEFAULTNEWLABELPLACEMENT;
    private int pieDrawingBoundsDifference = -1;

    public PieChart(Chart chart) {
        this.chart = chart;
        this.iPieChart = (IPieChart)((Object)chart);
        if (chart.nstring == 0) {
            if (chart.nint + chart.nreal == 0) {
                throw Chart.nocategoryError;
            }
            if (chart.nint + chart.nreal < 2) {
                throw Chart.nonumericError;
            }
            int rindex = 0;
            int iindex = 0;
            chart.mDataMap[0] = chart.nint > 0 ? chart.nintcol[iindex++] : chart.nrealcol[rindex++];
            chart.valueCol = chart.nreal > 0 ? chart.nrealcol[rindex++] : chart.nintcol[iindex++];
            chart.addNewColumnFromDataMapping = true;
            chart.dataDim = 1;
            this.center = new Point3D[1];
            this.allocateLabel(1, chart.mDataLen[0]);
        } else {
            chart.mDataMap[0] = chart.nstringcol[0];
            if (chart.nstring == 1) {
                chart.dataDim = 1;
            } else {
                chart.mDataMap[1] = chart.nstringcol[1];
                chart.dataDim = 2;
            }
            if (chart.nint + chart.nreal < 1) {
                throw Chart.nonumericError;
            }
            chart.valueCol = chart.nreal > 0 ? chart.nrealcol[0] : chart.nintcol[0];
            chart.addNewColumnFromDataMapping = true;
        }
        chart.bvalueCol = true;
        chart.makeTable();
        if (chart.dataDim == 1) {
            this.allocateLabel(1, chart.mDataLen[0]);
        } else {
            this.allocateLabel(chart.mDataLen[1], chart.mDataLen[0]);
        }
    }

    public PieChart(Chart chart, Chart _chart) {
        this.chart = chart;
        this.iPieChart = (IPieChart)((Object)chart);
        if (!chart.bvalueCol) {
            chart.valueCol = _chart.coordCol[0];
            chart.bvalueCol = true;
        }
        if (_chart.dataDim == 2 && _chart.isStackType()) {
            chart.mDataMap[0] = _chart.mDataMap[1];
            chart.mDataMap[1] = _chart.mDataMap[0];
            chart.dataDim = 2;
        } else {
            chart.dataDim = _chart.dataDim >= 2 || chart.bmDataMap[1] ? 2 : 1;
        }
        chart.checkSpecialColumn(1);
        chart.copyTable(_chart);
        chart.mainTitle.bshow = true;
        if (_chart.isCircularChart()) {
            this.copyAttributes(((IPieChart)((Object)_chart)).getPieChart());
        }
        if (_chart.dataDim != chart.dataDim || _chart.mDataLen[0] != chart.mDataLen[0] || _chart.dataDim != 1 && chart.mDataLen[1] != chart.mDataLen[1]) {
            if (chart.dataDim == 1) {
                this.allocateLabel(1, chart.mDataLen[0]);
            } else {
                this.allocateLabel(chart.mDataLen[1], chart.mDataLen[0]);
            }
        }
    }

    public void allocateLabel(int pie, int len) {
        this.center = new Point3D[pie];
        this.reAllocateLabel(pie, len);
        for (int j = 0; j < pie; ++j) {
            this.center[j] = new Point3D();
        }
    }

    private void reAllocateLabel(int pie, int len) {
        this.catLabel = new OffsetCString[pie];
        this.pieLabel = new OffsetCString[pie][len];
        this.pieValue = new OffsetCString[pie][len];
        this.piePercent = new OffsetCString[pie][len];
        for (int j = 0; j < pie; ++j) {
            this.catLabel[j] = new OffsetCString("");
            for (int i = 0; i < len; ++i) {
                this.pieLabel[j][i] = new OffsetCString("");
                this.pieValue[j][i] = new OffsetCString("");
                this.piePercent[j][i] = new OffsetCString("");
            }
        }
    }

    private boolean reAllocateLabel() {
        if (this.pieLabel == null) {
            return true;
        }
        if (this.chart.dataDim == 1) {
            if (this.pieLabel[0].length != this.chart.mDataLen[0]) {
                return true;
            }
        } else if (this.chart.dataDim == 2) {
            if (this.pieLabel.length != this.chart.mDataLen[1]) {
                return true;
            }
            if (this.pieLabel.length >= 1 && this.pieLabel[0].length != this.chart.mDataLen[0]) {
                return true;
            }
        }
        return false;
    }

    public void assignCoordinates() {
        block29: {
            double lastangle;
            double max_displayAngle;
            double init_angle;
            MultiDimData data;
            Object[] fname;
            Object[] cname;
            block28: {
                block30: {
                    block27: {
                        double val;
                        boolean addOthersSector;
                        int[] loc;
                        block26: {
                            if (this.reAllocateLabel()) {
                                if (this.chart.dataDim == 1) {
                                    this.reAllocateLabel(1, this.chart.mDataLen[0]);
                                } else {
                                    this.reAllocateLabel(this.chart.mDataLen[1], this.chart.mDataLen[0]);
                                }
                            }
                            cname = null;
                            loc = new int[this.chart.dataDim];
                            if (this.chart.dataDim != 1) break block26;
                            this.sum = new double[1];
                            this.othersSum = new double[1];
                            fname = this.chart.colData[this.chart.mDataMap[0]].getFieldName();
                            this.sum[0] = 0.0;
                            this.othersSum[0] = 0.0;
                            int i = 0;
                            while (i < this.chart.mDataLen[0]) {
                                loc[0] = i++;
                                this.sum[0] = this.sum[0] + Math.abs(this.chart.mData.getValue(loc));
                            }
                            if (!(this.chart.pieOthersLimit >= 0.0)) break block27;
                            boolean[] hideLegend = new boolean[this.chart.mDataLen[0]];
                            hideLegend[this.chart.mDataLen[0] - 1] = true;
                            addOthersSector = false;
                            for (int i2 = 0; i2 < this.chart.mDataLen[0] - 1; ++i2) {
                                loc[0] = i2;
                                val = Math.abs(this.chart.mData.getValue(loc));
                                if (!(this.chart.pieOthersLimit >= val / this.sum[0] * 100.0)) continue;
                                this.othersSum[0] = val + this.othersSum[0];
                                hideLegend[i2] = true;
                                addOthersSector = true;
                                hideLegend[this.chart.mDataLen[0] - 1] = false;
                            }
                            loc[0] = this.chart.mDataLen[0] - 1;
                            if (!addOthersSector) {
                                hideLegend[this.chart.mDataLen[0] - 1] = this.chart.pieOthersLimit != 0.0;
                                this.chart.mData.getPlotData(loc).setPieOthersSum(-1.0);
                            } else {
                                this.chart.mData.getPlotData(loc).setPieOthersSum(this.othersSum[0]);
                            }
                            if (!(this.chart.pieOthersLimit > 0.0)) break block27;
                            this.chart.setLegendItems(this.chart.mDataMap[0], hideLegend);
                            break block27;
                        }
                        this.sum = new double[this.chart.mDataLen[1]];
                        this.othersSum = new double[this.chart.mDataLen[1]];
                        fname = this.chart.colData[this.chart.mDataMap[0]].getFieldName();
                        cname = this.chart.colData[this.chart.mDataMap[1]].getFieldName();
                        for (int i = 0; i < this.chart.mDataLen[1]; ++i) {
                            loc[1] = i;
                            this.sum[i] = 0.0;
                            this.othersSum[i] = 0.0;
                            int j = 0;
                            while (j < this.chart.mDataLen[0]) {
                                loc[0] = j++;
                                int n = i;
                                this.sum[n] = this.sum[n] + Math.abs(this.chart.mData.getValue(loc));
                            }
                            if (!(this.chart.pieOthersLimit > 0.0)) continue;
                            addOthersSector = false;
                            for (int j2 = 0; j2 < this.chart.mDataLen[0] - 1; ++j2) {
                                loc[0] = j2;
                                val = Math.abs(this.chart.mData.getValue(loc));
                                if (!(this.chart.pieOthersLimit >= val / this.sum[i] * 100.0)) continue;
                                this.othersSum[i] = val + this.othersSum[i];
                                addOthersSector = true;
                            }
                            loc[0] = this.chart.mDataLen[0] - 1;
                            if (addOthersSector) {
                                this.chart.mData.getPlotData(loc).setPieOthersSum(this.othersSum[i]);
                                continue;
                            }
                            this.chart.mData.getPlotData(loc).setPieOthersSum(-1.0);
                        }
                    }
                    data = null;
                    init_angle = this.initangle;
                    max_displayAngle = 360.0;
                    if (this.chart.flashIsFirstLoopForPie) {
                        max_displayAngle = this.chart.flashRatio * 360.0 + init_angle;
                    } else {
                        init_angle += this.chart.flashRatio * 360.0;
                    }
                    lastangle = init_angle;
                    if (this.chart.dataDim != 1) break block28;
                    for (int i = 0; i < this.chart.mDataLen[0]; ++i) {
                        data = this.chart.mData.multiData[i];
                        lastangle = this.setDataAngleAndAttr(data, 0, i, lastangle, fname);
                        if (!this.chart.flashIsFirstLoopForPie) continue;
                        data.arcAngle.start %= 360.0;
                        if (data.arcAngle.start > max_displayAngle) {
                            data.arcAngle.angle = 0.0;
                            continue;
                        }
                        if (!(data.arcAngle.start + data.arcAngle.angle > max_displayAngle)) continue;
                        data.arcAngle.angle = max_displayAngle - data.arcAngle.start;
                    }
                    if (data == null) break block29;
                    if (data.arcAngle.angle < 360.0) {
                        data.arcAngle.angle = init_angle - data.arcAngle.start;
                        if (data.arcAngle.angle < 0.0) {
                            data.arcAngle.angle += 360.0;
                        }
                    } else {
                        data.arcAngle.angle = 360.0;
                    }
                    if (!this.chart.flashIsFirstLoopForPie) break block29;
                    data.arcAngle.start %= 360.0;
                    if (!(data.arcAngle.start > max_displayAngle)) break block30;
                    data.arcAngle.angle = 0.0;
                    break block29;
                }
                if (!(data.arcAngle.start + data.arcAngle.angle > max_displayAngle)) break block29;
                data.arcAngle.angle = max_displayAngle - data.arcAngle.start;
                break block29;
            }
            for (int i = 0; i < this.chart.mDataLen[1]; ++i) {
                lastangle = init_angle;
                for (int j = 0; j < this.chart.mDataLen[0]; ++j) {
                    data = this.chart.mData.multiData[j].multiData[i];
                    lastangle = this.setDataAngleAndAttr(data, i, j, lastangle, fname, cname);
                    if (!this.chart.flashIsFirstLoopForPie) continue;
                    data.arcAngle.start %= 360.0;
                    if (data.arcAngle.start > max_displayAngle) {
                        data.arcAngle.angle = 0.0;
                        continue;
                    }
                    if (!(data.arcAngle.start + data.arcAngle.angle > max_displayAngle)) continue;
                    data.arcAngle.angle = max_displayAngle - data.arcAngle.start;
                }
                if (data == null) continue;
                if (data.arcAngle.angle < 360.0) {
                    data.arcAngle.angle = init_angle - data.arcAngle.start;
                    if (data.arcAngle.angle < 0.0) {
                        data.arcAngle.angle += 360.0;
                    }
                } else {
                    data.arcAngle.angle = 360.0;
                }
                if (!this.chart.flashIsFirstLoopForPie) continue;
                data.arcAngle.start %= 360.0;
                if (data.arcAngle.start > max_displayAngle) {
                    data.arcAngle.angle = 0.0;
                    continue;
                }
                if (!(data.arcAngle.start + data.arcAngle.angle > max_displayAngle)) continue;
                data.arcAngle.angle = max_displayAngle - data.arcAngle.start;
            }
        }
        if (this.chart.dataDim == 2) {
            this.chart.setAutomatic(false);
        }
    }

    private double setDataAngleAndAttr(MultiDimData data, int pie, int sec, double lastangle, Object[] fname) {
        return this.setDataAngleAndAttr(data, pie, sec, lastangle, fname, null);
    }

    private double setDataAngleAndAttr(MultiDimData data, int pie, int sec, double lastangle, Object[] fname, Object[] cname) {
        double dvalue;
        boolean skipSector = false;
        if (data.plotData != null) {
            double percent;
            dvalue = data.plotData.getValue();
            double d = percent = this.sum[pie] != 0.0 ? Math.abs(data.plotData.getValue()) / this.sum[pie] : 0.0;
            if (this.chart.pieOthersLimit > 0.0) {
                if (data.plotData.isPieOthersSector()) {
                    dvalue = this.othersSum[pie];
                    percent = this.sum[pie] != 0.0 ? Math.abs(this.othersSum[pie]) / this.sum[pie] : 0.0;
                } else if (percent * 100.0 <= this.chart.pieOthersLimit) {
                    skipSector = true;
                    dvalue = 0.0;
                    percent = 0.0;
                }
            }
            data.arcAngle = new ArcAngle(lastangle, 360.0 * percent);
            data.plotData.setPercentage((float)(100.0 * percent));
        } else {
            data.arcAngle = new ArcAngle(lastangle, 0.0);
            dvalue = 0.0;
        }
        data.area.automatic = false;
        lastangle = data.arcAngle.start + data.arcAngle.angle;
        if (cname != null) {
            this.catLabel[pie].setString(this.formatingCatLabel(cname[pie]));
            this.catLabel[pie].setColor(this.catLabelColor);
            this.catLabel[pie].setFont(this.catLabelFont, this.catLabelAngle);
        }
        this.pieLabel[pie][sec].setString(this.formatingLabel(fname[sec]));
        this.pieValue[pie][sec].setString(this.formatingValue(dvalue));
        this.piePercent[pie][sec].setString(this.formatingPercent(this.sum[pie] != 0.0 ? Math.abs(dvalue) * 100.0 / this.sum[pie] : 0.0));
        if (skipSector || (data.plotData.isEmpty() || data.plotData.getValue() == 0.0) && !data.plotData.isPieOthersSector()) {
            this.pieLabel[pie][sec].setString("");
            this.pieValue[pie][sec].setString("");
            this.piePercent[pie][sec].setString("");
        }
        this.pieLabel[pie][sec].setColor(this.pieLabelColor);
        this.pieLabel[pie][sec].setFont(this.pieLabelFont, this.pieLabelAngle);
        this.pieValue[pie][sec].setColor(this.pieValueColor);
        this.pieValue[pie][sec].setFont(this.pieValueFont, this.pieValueAngle);
        this.piePercent[pie][sec].setColor(this.piePercentColor);
        this.piePercent[pie][sec].setFont(this.piePercentFont, this.piePercentAngle);
        return lastangle;
    }

    String formatingValue(double value) {
        IFormat dataFormat = this.chart.colData[this.chart.valueCol].dataFormat;
        return dataFormat != null ? dataFormat.format(value) : value + "";
    }

    String formatingPercent(double value) {
        IFormat dataFormat = this.chart.colData[this.chart.colData.length - 1].dataFormat;
        if (dataFormat instanceof LocaleNumericFormat) {
            LocaleNumericFormat temp = this.chart.getLocale() == null ? LocaleNumericFormat.getPercentInstance() : LocaleNumericFormat.getPercentInstance(this.chart.getLocale());
            temp.setFormat((LocaleNumericFormat)dataFormat);
            return temp.format(value);
        }
        return dataFormat.format(value);
    }

    private String formatingLabel(Object obj) {
        return Chart.formatLabel(obj, this.chart.colData[this.chart.mDataMap[0]].dataFormat);
    }

    private String formatingCatLabel(Object obj) {
        return Chart.formatLabel(obj, this.chart.colData[this.chart.mDataMap[1]].dataFormat);
    }

    public void drawLabel(CGraphics g) {
        this.pieDrawingBoundsDifference = -1;
        for (int i = 0; i < this.piePercent.length; ++i) {
            this.drawLabel(g, i);
        }
    }

    private void drawLabel(CGraphics g, int s) {
        this.drawLabel(g, s, -1, null);
    }

    private void drawLabel(CGraphics g, int s, int sliceIdx, String hint) {
        int yoffset;
        int ph;
        int pw;
        boolean assignCoordinates = true;
        for (int i = 0; i < this.piePercent[s].length; ++i) {
            if (this.piePercent[s][i].getString() == null || this.piePercent[s][i].getString().trim().equals("")) continue;
            assignCoordinates = false;
            break;
        }
        if (assignCoordinates) {
            this.assignCoordinates();
        }
        this.pieLabelFont = this.pieLabel[s][0].font;
        this.pieValueFont = this.pieValue[s][0].font;
        this.piePercentFont = this.piePercent[s][0].font;
        this.catLabelAngle = this.catLabel[s].angle;
        this.pieLabelAngle = this.pieLabel[s][0].angle;
        this.pieValueAngle = this.pieValue[s][0].angle;
        this.piePercentAngle = this.piePercent[s][0].angle;
        this.catLabelColor = this.catLabel[s].color;
        this.pieLabelColor = this.pieLabel[s][0].color;
        this.pieValueColor = this.pieValue[s][0].color;
        this.piePercentColor = this.piePercent[s][0].color;
        if (this.chart.dataDim == 2) {
            this.catLabelFont = this.catLabel[s].font;
            this.catLabelAngle = this.catLabel[s].angle;
        }
        FontMetrics fmL = g.getFontMetrics(QbUtil.resizeViewerFont(this.pieLabelFont, this.chart.isAdjustFont()));
        FontMetrics fmV = g.getFontMetrics(QbUtil.resizeViewerFont(this.pieValueFont, this.chart.isAdjustFont()));
        FontMetrics fmP = g.getFontMetrics(QbUtil.resizeViewerFont(this.piePercentFont, this.chart.isAdjustFont()));
        int numSlices = this.chart.mDataLen[0];
        int[] fontheightL = new int[numSlices];
        int[] height = new int[numSlices];
        for (int i = 0; i < numSlices; ++i) {
            fontheightL[i] = fmL.getMaxAscent() + fmL.getMaxDescent();
            height[i] = 0;
        }
        int fontheightV = fmV.getMaxAscent() + fmV.getMaxDescent();
        int fontheightP = fmP.getMaxAscent() + fmP.getMaxDescent();
        int newLineCount = 0;
        int maxHeight = 0;
        for (int i = 0; i < numSlices; ++i) {
            newLineCount = this.getNewLineCount(this.pieLabel[s][i].str, 0);
            int count = 0;
            int n = i;
            fontheightL[n] = fontheightL[n] * (1 + newLineCount);
            if (this.showLabel) {
                ++count;
                height[i] = fontheightL[i];
            }
            if (this.showValue) {
                ++count;
                int n2 = i;
                height[n2] = height[n2] + fontheightV;
            }
            if (this.showPercent) {
                ++count;
                int n3 = i;
                height[n3] = height[n3] + fontheightP;
            }
            if (height[i] > maxHeight) {
                maxHeight = height[i];
            }
            if (count == 0) {
                return;
            }
            if (count == 1) {
                height[i] = 0;
            }
            if (this.pieLabelWithDirection) {
                if (count == 2) {
                    int n4 = i;
                    height[n4] = height[n4] / 4;
                }
                if (count == 3) {
                    int n5 = i;
                    height[n5] = height[n5] / 3;
                }
            } else if (count == 2) {
                int n6 = i;
                height[n6] = height[n6] / 2;
            }
            newLineCount = 0;
        }
        Point3D p = null;
        if (this.chart.is2DChart) {
            pw = this.piewidth[s];
            ph = this.pieheight[s];
        } else {
            pw = this.piewidth[s] * 2;
            ph = this.pieheight[s] * 2;
        }
        Point3D[] savepos = new Point3D[numSlices];
        for (int i = 0; i < numSlices; ++i) {
            savepos[i] = this.computePos(s, i, 0.0, pw, ph, this.fontdistance, this.labelAtTheSide);
        }
        if (this.labelAtTheSide) {
            this.computePos(savepos, maxHeight, s);
        }
        int[] xPtLimit = null;
        if (!this.labelAtTheSide && this.pieLabelWithDirection) {
            xPtLimit = this.calcPieDrawingArea(s);
        }
        Point3D realCenter = this.center[s].copy();
        if (!this.chart.is2DChart) {
            this.iPieChart.transformPoint(realCenter);
        }
        for (int i = 0; i < numSlices; ++i) {
            int tmpW;
            if (this.pieValue[s][i].getString().equals("") && this.piePercent[s][i].getString().equals("")) continue;
            String orgLabel = null;
            if (sliceIdx >= 0) {
                orgLabel = this.pieLabel[s][i].str;
                this.pieLabel[s][i].str = hint != null ? hint : this.pieLabel[s][i].str + "," + this.pieValue[s][i].str + "," + this.piePercent[s][i].str;
            }
            MultiDimData ddata = this.chart.dataDim == 1 ? this.chart.mData.multiData[i] : this.chart.mData.multiData[i].multiData[s];
            yoffset = this.pieLabelWithDirection ? height[i] : height[i] / 2;
            int maxWidth = 0;
            Point3D firstP = null;
            if (this.showLabel && (this.zeroLabelsVisible || ddata.arcAngle.angle != 0.0)) {
                p = new Point3D((int)((float)savepos[i].x + (float)pw * this.pieLabel[s][i].xoffset), (int)((float)savepos[i].y + (float)ph * this.pieLabel[s][i].yoffset), savepos[i].z);
                if (!this.chart.is2DChart) {
                    this.iPieChart.transformPoint(p);
                    p.y = g.height - p.y;
                }
                this.pieLabel[s][i].setpos(new Point3D(p.x, p.y + yoffset));
                if (this.pieLabelWithDirection) {
                    if (this.labelAtTheSide) {
                        if (this.isLeftPos(p.x, realCenter.x)) {
                            this.pieLabel[s][i].setPlacement(4);
                        } else {
                            this.pieLabel[s][i].setPlacement(2);
                        }
                    } else {
                        this.pieLabel[s][i].setPlacement(this.calcLabelPlacementDirection(p.x, p.y, realCenter.x, realCenter.y));
                    }
                }
                if (xPtLimit != null) {
                    this.pieLabel[s][i].setTextBound(xPtLimit[0], xPtLimit[1]);
                }
                if (sliceIdx < 0 || i == sliceIdx) {
                    this.pieLabel[s][i].draw(g);
                }
                yoffset -= fontheightL[i];
                maxWidth = fmL.stringWidth(this.chart.valueTable.getRunTimeValue(this.pieLabel[s][i].getString()));
                firstP = p;
            }
            if (this.showValue && (this.zeroLabelsVisible || ddata.arcAngle.angle != 0.0)) {
                p = new Point3D((int)((float)savepos[i].x + (float)pw * this.pieValue[s][i].xoffset), (int)((float)savepos[i].y + (float)ph * this.pieValue[s][i].yoffset), savepos[i].z);
                if (!this.chart.is2DChart) {
                    this.iPieChart.transformPoint(p);
                    p.y = g.height - p.y;
                }
                this.pieValue[s][i].setpos(new Point3D(p.x, p.y + yoffset));
                if (this.pieLabelWithDirection) {
                    if (this.labelAtTheSide) {
                        if (this.isLeftPos(p.x, realCenter.x)) {
                            this.pieValue[s][i].setPlacement(4);
                        } else {
                            this.pieValue[s][i].setPlacement(2);
                        }
                    } else {
                        this.pieValue[s][i].setPlacement(this.calcLabelPlacementDirection(p.x, p.y, realCenter.x, realCenter.y));
                    }
                }
                if (xPtLimit != null) {
                    this.pieValue[s][i].setTextBound(xPtLimit[0], xPtLimit[1]);
                }
                if (sliceIdx < 0 || i == sliceIdx) {
                    this.pieValue[s][i].draw(g);
                }
                yoffset -= fontheightV;
                tmpW = fmV.stringWidth(this.chart.valueTable.getRunTimeValue(this.pieValue[s][i].getString()));
                if (tmpW > maxWidth) {
                    maxWidth = tmpW;
                }
                if (firstP == null) {
                    firstP = p;
                }
            }
            if (this.showPercent && (this.zeroLabelsVisible || ddata.arcAngle.angle != 0.0)) {
                p = new Point3D((int)((float)savepos[i].x + (float)pw * this.piePercent[s][i].xoffset), (int)((float)savepos[i].y + (float)ph * this.piePercent[s][i].yoffset), savepos[i].z);
                if (!this.chart.is2DChart) {
                    this.iPieChart.transformPoint(p);
                    p.y = g.height - p.y;
                }
                this.piePercent[s][i].setpos(new Point3D(p.x, p.y + yoffset));
                if (this.pieLabelWithDirection) {
                    if (this.labelAtTheSide) {
                        if (this.isLeftPos(p.x, realCenter.x)) {
                            this.piePercent[s][i].setPlacement(4);
                        } else {
                            this.piePercent[s][i].setPlacement(2);
                        }
                    } else {
                        this.piePercent[s][i].setPlacement(this.calcLabelPlacementDirection(p.x, p.y, realCenter.x, realCenter.y));
                    }
                }
                if (xPtLimit != null) {
                    this.piePercent[s][i].setTextBound(xPtLimit[0], xPtLimit[1]);
                }
                if (sliceIdx < 0 || i == sliceIdx) {
                    this.piePercent[s][i].draw(g);
                }
                if ((tmpW = fmP.stringWidth(this.chart.valueTable.getRunTimeValue(this.piePercent[s][i].getString()))) > maxWidth) {
                    maxWidth = tmpW;
                }
                if (firstP == null) {
                    firstP = p;
                }
            }
            if (this.pieExtendLine && p != null) {
                Point3D p2 = this.computePos(s, i, 0.0, pw, ph, 1.0);
                if (!this.chart.is2DChart) {
                    this.iPieChart.transformPoint(p2);
                    p2.y = g.height - p2.y;
                }
                int xLinePt = firstP.x;
                if (this.pieLabelWithDirection) {
                    if (this.labelAtTheSide) {
                        xLinePt = firstP.x;
                    }
                    this.drawConnectLine(g, p2.x, p2.y, xLinePt, firstP.y, Color.black);
                } else {
                    if (Math.abs(firstP.x - p2.x) < 15) {
                        xLinePt = firstP.x;
                    } else if (firstP.x < p2.x) {
                        xLinePt = firstP.x + maxWidth / 2;
                    } else if (firstP.x > p2.x) {
                        xLinePt = firstP.x - maxWidth / 2;
                    }
                    this.drawConnectLine(g, p2.x, p2.y, xLinePt, firstP.y + height[i] / 2, Color.black);
                }
            }
            if (orgLabel == null) continue;
            this.pieLabel[s][i].str = orgLabel;
        }
        if (this.showCategory && this.chart.dataDim == 2) {
            yoffset = 0;
            double angle = 4.71238898038469;
            Point3D catpos = new Point3D((int)((double)this.center[s].x + (double)pw * this.catLabelDistance * Math.cos(angle) / 2.0), (int)((double)this.center[s].y + (double)ph * this.catLabelDistance * Math.sin(angle) / 2.0), 200);
            p = new Point3D((int)((float)catpos.x + (float)pw * this.catLabel[s].xoffset), (int)((float)catpos.y + (float)ph * this.catLabel[s].yoffset), catpos.z);
            if (!this.chart.is2DChart) {
                this.iPieChart.transformPoint(p);
                p.y = g.height - p.y;
            }
            if (this.pieLabelWithDirection) {
                this.catLabel[s].setPlacement(3);
            }
            this.catLabel[s].setpos(new Point3D(p.x, p.y + yoffset));
            if (sliceIdx < 0) {
                this.catLabel[s].draw(g);
            }
        }
    }

    private int calcLabelPlacementDirection(int x, int y, int centerX, int centerY) {
        double diffx = x - centerX;
        double diffy = y - centerY;
        if (diffx == 0.0) {
            if (y > centerY) {
                return 1;
            }
            return 3;
        }
        if (diffy == 0.0) {
            if (x > centerX) {
                return 2;
            }
            return 4;
        }
        double angle = Math.atan(diffy / diffx);
        if (diffx < 0.0 && diffy > 0.0) {
            angle += Math.PI;
        } else if (diffx < 0.0 && diffy < 0.0) {
            angle += Math.PI;
        } else if (diffx > 0.0 && diffy < 0.0) {
            angle += Math.PI * 2;
        }
        angle = angle * 180.0 / Math.PI;
        if (angle >= 22.5 && angle <= 67.5) {
            return 2;
        }
        if (angle >= 67.5 && angle <= 112.5) {
            return 0;
        }
        if (angle >= 112.5 && angle <= 157.5) {
            return 4;
        }
        if (angle >= 157.5 && angle <= 202.5) {
            return 4;
        }
        if (angle >= 202.5 && angle <= 247.5) {
            return 4;
        }
        if (angle >= 247.5 && angle <= 292.5) {
            return 0;
        }
        if (angle >= 292.5 && angle <= 337.5) {
            return 2;
        }
        return 2;
    }

    private int[] calcPieDrawingArea(int centerIdx) {
        if (this.center.length == 1) {
            return null;
        }
        Point3D realCenter = this.center[centerIdx].copy();
        if (!this.chart.is2DChart) {
            this.iPieChart.transformPoint(realCenter);
        }
        if (this.pieDrawingBoundsDifference != -1) {
            return new int[]{realCenter.x - this.pieDrawingBoundsDifference, realCenter.x + this.pieDrawingBoundsDifference};
        }
        if (centerIdx > 0 && this.center[centerIdx - 1].y == this.center[centerIdx].y) {
            Point3D realCenterPrev = this.center[centerIdx - 1].copy();
            if (!this.chart.is2DChart) {
                this.iPieChart.transformPoint(realCenterPrev);
            }
            this.pieDrawingBoundsDifference = (realCenter.x - realCenterPrev.x) / 2;
            return new int[]{realCenter.x - this.pieDrawingBoundsDifference, realCenter.x + this.pieDrawingBoundsDifference};
        }
        if (centerIdx < this.center.length - 1 && this.center[centerIdx].y == this.center[centerIdx + 1].y) {
            Point3D realCenterNext = this.center[centerIdx + 1].copy();
            if (!this.chart.is2DChart) {
                this.iPieChart.transformPoint(realCenterNext);
            }
            this.pieDrawingBoundsDifference = (realCenterNext.x - realCenter.x) / 2;
            return new int[]{realCenter.x - this.pieDrawingBoundsDifference, realCenter.x + this.pieDrawingBoundsDifference};
        }
        return new int[]{-1, -1};
    }

    private boolean isLeftPos(int x, int centerX) {
        return x < centerX;
    }

    private void drawConnectLine(CGraphics g, int stX, int stY, int endX, int endY, Color color) {
        if ((double)Math.abs(stX - endX) < 15.0) {
            g.drawColorLine(stX, stY, endX, endY, color);
            return;
        }
        if (stX > endX) {
            g.drawColorLine(endX + 3, endY, endX, endY, color);
            g.drawColorLine(endX + 13, stY, endX + 3, endY, color);
            g.drawColorLine(stX, stY, endX + 13, stY, color);
            return;
        }
        if (stX < endX) {
            g.drawColorLine(endX - 3, endY, endX, endY, color);
            g.drawColorLine(endX - 13, stY, endX - 3, endY, color);
            g.drawColorLine(stX, stY, endX - 13, stY, color);
        }
    }

    private Point3D computePos(int s, int i, double r, int pw, int ph, double fontd) {
        return this.computePos(s, i, r, pw, ph, fontd, false);
    }

    private Point3D computePos(int s, int i, double r, int pw, int ph, double fontd, boolean labelAtTheSide) {
        MultiDimData data = this.chart.dataDim == 1 ? this.chart.mData.multiData[i] : this.chart.mData.multiData[i].multiData[s];
        if (data.arcAngle.angle == 0.0 && this.chart.pieOthersLimit > 0.0) {
            return new Point3D(-100, -100, 200);
        }
        double angle = (data.arcAngle.start + data.arcAngle.angle / 2.0) * Math.PI / 180.0;
        double sd = data.plotData.bSlice && !this.doSectorGap ? this.sliceDistance + r : r;
        double xOffset = (fontd + sd) * Math.cos(angle) / 2.0;
        if (labelAtTheSide && !this.pieLabelWithDirection) {
            xOffset = (1.2 + sd) * (xOffset >= 0.0 ? 0.5 : -0.5);
        }
        double yOffset = (fontd + sd) * Math.sin(angle) / 2.0;
        if (labelAtTheSide && !this.pieLabelWithDirection) {
            yOffset = (1.0 + sd) * (Math.sin(angle) / 2.0);
        }
        return new Point3D((int)((double)this.center[s].x + (double)pw * xOffset), (int)((double)this.center[s].y + (double)ph * yOffset), 200);
    }

    private void computePos(Point3D[] orgPos, int height, int s) {
        int i;
        Point3D tmp;
        int i2;
        int lastY;
        int step;
        int i3;
        Vector<Point3DCompare> leftPos = new Vector<Point3DCompare>();
        Vector<Point3DCompare> rightPos = new Vector<Point3DCompare>();
        Vector<Point3DCompare> centerPos = new Vector<Point3DCompare>();
        if (!this.chart.is2DChart) {
            height *= 3;
        }
        for (Point3D orgPo : orgPos) {
            if (orgPo.x == -100 && orgPo.y == -100) continue;
            if (orgPo.x < this.center[s].x) {
                leftPos.addElement(new Point3DCompare(orgPo));
                continue;
            }
            if (orgPo.x > this.center[s].x) {
                rightPos.addElement(new Point3DCompare(orgPo));
                continue;
            }
            centerPos.addElement(new Point3DCompare(orgPo));
        }
        if (this.pieLabelWithDirection) {
            for (int i4 = 0; i4 < centerPos.size(); ++i4) {
                if (leftPos.size() < rightPos.size()) {
                    leftPos.addElement((Point3DCompare)centerPos.get(i4));
                    continue;
                }
                rightPos.addElement((Point3DCompare)centerPos.get(i4));
            }
        }
        if (leftPos.size() > 0) {
            ICompareObject[] leftPosArr = new Point3DCompare[leftPos.size()];
            for (i3 = 0; i3 < leftPos.size(); ++i3) {
                leftPosArr[i3] = (Point3DCompare)leftPos.elementAt(i3);
            }
            Object[] leftP = SortObject.sort(leftPosArr, true);
            if (this.pieLabelWithDirection && this.chart.is2DChart) {
                if (((Point3D)leftP[leftP.length - 1]).y > this.center[s].y + this.piewidth[0] / 2) {
                    ((Point3D)leftP[leftP.length - 1]).y = this.center[s].y + this.piewidth[0] / 2;
                }
                if (((Point3D)leftP[0]).y + height < this.center[s].y - this.piewidth[0] / 2) {
                    ((Point3D)leftP[0]).y = this.center[s].y - this.piewidth[0] / 2 - height;
                }
            }
            if (leftP.length > (step = (int)Math.floor((((Point3D)leftP[leftP.length - 1]).y - ((Point3D)leftP[0]).y + height) / height))) {
                Point3D firstPt = (Point3D)leftP[leftP.length - 1];
                firstPt.y += (leftP.length - step) * height / 2;
                lastY = firstPt.y;
                for (i2 = leftP.length - 2; i2 >= 0; --i2) {
                    tmp = (Point3D)leftP[i2];
                    tmp.y = lastY -= height;
                }
            } else if (leftP.length <= step) {
                int lastY2 = ((Point3D)leftP[leftP.length - 1]).y - height;
                for (i = leftP.length - 2; i >= 0; --i) {
                    Point3D tmp2 = (Point3D)leftP[i];
                    if (tmp2.y > lastY2) {
                        tmp2.y = lastY2;
                    }
                    lastY2 = tmp2.y - height;
                }
            }
            if (this.pieLabelWithDirection) {
                int minX = this.findMinX(leftP);
                if (minX > this.center[s].x - this.piewidth[0] / 2) {
                    minX = this.center[s].x - this.piewidth[0] / 2;
                }
                for (i = 0; i < leftP.length; ++i) {
                    ((Point3D)leftP[i]).x = minX;
                }
            }
        }
        if (rightPos.size() > 0) {
            ICompareObject[] rightPosArr = new Point3DCompare[rightPos.size()];
            for (i3 = 0; i3 < rightPos.size(); ++i3) {
                rightPosArr[i3] = (Point3DCompare)rightPos.elementAt(i3);
            }
            Object[] rightP = SortObject.sort(rightPosArr, true);
            if (rightP.length > (step = (int)Math.floor((((Point3D)rightP[rightP.length - 1]).y - ((Point3D)rightP[0]).y + height) / height))) {
                Point3D firstPt = (Point3D)rightP[rightP.length - 1];
                firstPt.y += (rightP.length - step) * height / 2;
                lastY = firstPt.y;
                for (i2 = rightP.length - 2; i2 >= 0; --i2) {
                    tmp = (Point3D)rightP[i2];
                    tmp.y = lastY -= height;
                }
            } else if (rightP.length <= step) {
                int lastY3 = ((Point3D)rightP[rightP.length - 1]).y - height;
                for (i = rightP.length - 2; i >= 0; --i) {
                    Point3D tmp3 = (Point3D)rightP[i];
                    if (tmp3.y > lastY3) {
                        tmp3.y = lastY3;
                    }
                    lastY3 = tmp3.y - height;
                }
            }
            if (this.pieLabelWithDirection) {
                int maxX = this.findMaxX(rightP);
                if (maxX < this.center[s].x + this.piewidth[0] / 2) {
                    maxX = this.center[s].x + this.piewidth[0] / 2;
                }
                for (i = 0; i < rightP.length; ++i) {
                    ((Point3D)rightP[i]).x = maxX;
                }
            }
        }
    }

    private int findMinX(Object[] pt) {
        int min = 0;
        if (pt.length <= 0) {
            return -1;
        }
        min = ((Point3D)pt[0]).x;
        for (int i = 1; i < pt.length; ++i) {
            Point3D tmp = (Point3D)pt[i];
            if (tmp.x >= min) continue;
            min = tmp.x;
        }
        return min;
    }

    private int findMaxX(Object[] pt) {
        int max = 0;
        if (pt.length <= 0) {
            return -1;
        }
        max = ((Point3D)pt[0]).x;
        for (int i = 1; i < pt.length; ++i) {
            Point3D tmp = (Point3D)pt[i];
            if (tmp.x <= max) continue;
            max = tmp.x;
        }
        return max;
    }

    public void setPiePerRow(int nPie) {
        this.piePerRow = nPie;
    }

    public int getPiePerRow() {
        return this.piePerRow;
    }

    public void setDrawLinearly(boolean b) {
        this.drawLinearly = b;
    }

    public boolean isDrawLinearly() {
        return this.drawLinearly;
    }

    public void setBestFit(boolean b) {
        this.bestFit = b;
    }

    public boolean isBestFit() {
        return this.bestFit;
    }

    public void setInitAngle(int angle) {
        this.initangle = angle;
        if (!this.chart.is2DChart) {
            this.iPieChart.resetHiddenSurface();
        }
    }

    public void setSliceDistance(double distance) {
        this.sliceDistance = distance;
        if (!this.chart.is2DChart) {
            this.iPieChart.resetHiddenSurface();
        }
    }

    public void setSliceState(int pos, boolean state) {
        if (this.chart.dataDim == 1) {
            this.setSliceState(0, pos, state);
        } else {
            for (int i = 0; i < this.chart.mDataLen[1]; ++i) {
                this.setSliceState(i, pos, state);
            }
        }
    }

    private void setSliceState(int pie, int pos, boolean state) {
        MultiDimData data = this.chart.dataDim == 1 ? this.chart.mData.multiData[pos] : this.chart.mData.multiData[pos].multiData[pie];
        if (data.plotData.bSlice != state) {
            data.plotData.bSlice = state;
            if (!this.chart.is2DChart) {
                this.iPieChart.resetHiddenSurface();
            }
        }
    }

    public Object selectPieLabel(CGraphics g, int x, int y) {
        if (this.showLabel && (this.chart.targetstr = (OffsetCString)CString.selectStrings(g, x, y, this.pieLabel)) != null) {
            return this.pieLabel;
        }
        if (this.showValue && (this.chart.targetstr = (OffsetCString)CString.selectStrings(g, x, y, this.pieValue)) != null) {
            return this.pieValue;
        }
        if (this.showPercent && (this.chart.targetstr = (OffsetCString)CString.selectStrings(g, x, y, this.piePercent)) != null) {
            return this.piePercent;
        }
        if (this.showCategory && this.chart.dataDim == 2 && (this.chart.targetstr = (OffsetCString)CString.selectStrings(g, x, y, this.catLabel)) != null) {
            return this.catLabel;
        }
        return null;
    }

    public String getSelectedPieLabel(CGraphics g, int x, int y) {
        if (this.showLabel && (this.chart.targetstr = (OffsetCString)CString.selectStrings(g, x, y, this.pieLabel)) != null) {
            return CString.selectStrings((CGraphics)g, (int)x, (int)y, (CString[][])this.pieLabel).str;
        }
        if (this.showValue && (this.chart.targetstr = (OffsetCString)CString.selectStrings(g, x, y, this.pieValue)) != null) {
            return CString.selectStrings((CGraphics)g, (int)x, (int)y, (CString[][])this.pieValue).str;
        }
        if (this.showPercent && (this.chart.targetstr = (OffsetCString)CString.selectStrings(g, x, y, this.piePercent)) != null) {
            return CString.selectStrings((CGraphics)g, (int)x, (int)y, (CString[][])this.piePercent).str;
        }
        if (this.showCategory && this.chart.dataDim == 2 && (this.chart.targetstr = (OffsetCString)CString.selectStrings(g, x, y, this.catLabel)) != null) {
            return CString.selectStrings((CGraphics)g, (int)x, (int)y, (CString[])this.catLabel).str;
        }
        return null;
    }

    public void copyAttributes(PieChart _chart) {
        this.pieLabelColor = _chart.pieLabelColor;
        this.pieValueColor = _chart.pieValueColor;
        this.piePercentColor = _chart.piePercentColor;
        this.pieLabelFont = _chart.pieLabelFont;
        this.pieValueFont = _chart.pieValueFont;
        this.piePercentFont = _chart.piePercentFont;
        this.pieLabelAngle = _chart.pieLabelAngle;
        this.pieValueAngle = _chart.pieValueAngle;
        this.piePercentAngle = _chart.piePercentAngle;
        this.showLabel = _chart.showLabel;
        this.showPercent = _chart.showPercent;
        this.showCategory = _chart.showCategory;
        this.showValue = _chart.showValue;
        this.fontdistance = _chart.fontdistance;
        this.sliceDistance = _chart.sliceDistance;
        this.initangle = _chart.initangle;
        this.pieSectors = _chart.pieSectors;
        this.pieThickness = _chart.pieThickness;
        this.center = _chart.center;
        this.catLabel = this.clone(_chart.catLabel);
        this.pieLabel = this.clone(_chart.pieLabel);
        this.pieValue = this.clone(_chart.pieValue);
        this.piePercent = this.clone(_chart.piePercent);
        this.smartlabel = _chart.smartlabel;
        this.valInLegend = _chart.valInLegend;
        this.radialBorder = _chart.radialBorder;
        this.zeroLabelsVisible = _chart.zeroLabelsVisible;
        this.pieBorderColor = _chart.pieBorderColor;
        this.pieExtendLine = _chart.pieExtendLine;
        this.labelAtTheSide = _chart.labelAtTheSide;
        this.doSectorGap = _chart.doSectorGap;
        this.catLabelDistance = _chart.catLabelDistance;
        this.catLabelFont = _chart.catLabelFont;
        this.catLabelColor = _chart.catLabelColor;
        this.catLabelAngle = _chart.catLabelAngle;
        this.showCategory = _chart.showCategory;
        this.bestFit = _chart.bestFit;
        this.piePerRow = _chart.piePerRow;
        this.drawLinearly = _chart.drawLinearly;
        this.gapRatioBetweenPies = _chart.gapRatioBetweenPies;
        this.pieLabelWithDirection = _chart.pieLabelWithDirection;
        if (_chart.center != null) {
            this.center = (Point3D[])_chart.center.clone();
            this.center = new Point3D[_chart.center.length];
            for (int i = 0; i < _chart.center.length; ++i) {
                this.center[i] = _chart.center[i].copy();
            }
        }
    }

    private OffsetCString[][] clone(OffsetCString[][] input) {
        if (input == null) {
            return null;
        }
        int iCt = input.length;
        int jCt = input[0].length;
        OffsetCString[][] val = new OffsetCString[iCt][jCt];
        for (int i = 0; i < iCt; ++i) {
            for (int j = 0; j < jCt; ++j) {
                val[i][j] = (OffsetCString)input[i][j].copy();
            }
        }
        return val;
    }

    private OffsetCString[] clone(OffsetCString[] input) {
        if (input == null) {
            return null;
        }
        int iCt = input.length;
        OffsetCString[] val = new OffsetCString[iCt];
        for (int i = 0; i < iCt; ++i) {
            val[i] = (OffsetCString)input[i].copy();
        }
        return val;
    }

    public final void setPieSlice(int pos, boolean b) {
        if (this.chart.dataDim == 1) {
            this.setPieSlice(0, pos, b);
        } else {
            for (int i = 0; i < this.chart.mDataLen[1]; ++i) {
                this.setPieSlice(i, pos, b);
            }
        }
    }

    public boolean isExploded() {
        try {
            if (this.chart.dataDim == 1) {
                for (MultiDimData element : this.chart.mData.multiData) {
                    if (!element.plotData.bSlice) continue;
                    return true;
                }
            } else {
                for (MultiDimData element : this.chart.mData.multiData) {
                    if (!element.multiData[0].plotData.bSlice) continue;
                    return true;
                }
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Can't load 'explode chart' settings", ex);
        }
        return false;
    }

    public boolean isExplodedAll() {
        try {
            if (this.chart.dataDim == 1) {
                for (int i = 0; i < this.chart.mData.multiData.length; ++i) {
                    if (this.chart.mData.multiData[i].plotData.bSlice) continue;
                    return false;
                }
            } else {
                for (int i = 0; i < this.chart.mData.multiData.length; ++i) {
                    if (this.chart.mData.multiData[i].multiData[0].plotData.bSlice) continue;
                    return false;
                }
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Can't load 'explode all slices' settings", ex);
        }
        return true;
    }

    public boolean isSectorAlike() {
        try {
            double diff;
            double minValue = Double.MAX_VALUE;
            double maxValue = Double.MIN_VALUE;
            if (this.chart.dataDim == 1) {
                for (MultiDimData element : this.chart.mData.multiData) {
                    if (element.plotData.getValue() > maxValue) {
                        maxValue = element.plotData.getValue();
                    }
                    if (!(element.plotData.getValue() < minValue)) continue;
                    minValue = element.plotData.getValue();
                }
            } else {
                for (MultiDimData element : this.chart.mData.multiData) {
                    if (element.plotData.getValue() > maxValue) {
                        maxValue = element.plotData.getValue();
                    }
                    if (!(element.plotData.getValue() < minValue)) continue;
                    minValue = element.plotData.getValue();
                }
            }
            return (diff = (maxValue - minValue) / minValue) < 3.0;
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Can't load 'is sector alike' settings", ex);
            return false;
        }
    }

    public void drawLabel(CGraphics g, MultiDimData selData, String hint) {
        this.pieDrawingBoundsDifference = -1;
        for (int i = 0; i < this.chart.mData.multiData.length; ++i) {
            if (this.chart.dataDim == 1) {
                if (selData != this.chart.mData.multiData[i]) continue;
                this.drawLabel(g, 0, i, hint);
                continue;
            }
            for (int j = 0; j < this.chart.mData.multiData[i].multiData.length; ++j) {
                if (selData != this.chart.mData.multiData[i].multiData[j]) continue;
                this.drawLabel(g, j, i, hint);
            }
        }
    }

    private void setPieSlice(int pie, int pos, boolean b) {
        try {
            if (this.chart.dataDim == 1) {
                this.chart.mData.multiData[pos].plotData.bSlice = b;
            } else {
                this.chart.mData.multiData[pos].multiData[pie].plotData.bSlice = b;
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Invalid pie slice index:" + pos, ex);
            throw new IllegalArgumentException("Invalid pie slice index :" + pos);
        }
    }

    public final void setPieSlice(Boolean[] slice) {
        if (this.chart.dataDim == 1) {
            this.setPieSlice(0, slice);
        } else {
            for (int i = 0; i < this.chart.mDataLen[1]; ++i) {
                this.setPieSlice(i, slice);
            }
        }
    }

    private void setPieSlice(int pie, Boolean[] slice) {
        for (int i = 0; i < Math.min(this.chart.mData.multiData.length, slice.length); ++i) {
            this.setPieSlice(pie, i, slice[i]);
        }
    }

    public final boolean getPieSlice(int pos) {
        return this.getPieSlice(0, pos);
    }

    private boolean getPieSlice(int pie, int pos) {
        try {
            if (this.chart.dataDim == 1) {
                return this.chart.mData.multiData[pos].plotData.bSlice;
            }
            return this.chart.mData.multiData[pos].multiData[pie].plotData.bSlice;
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Invalid pie slice index:" + pos, ex);
            throw new IllegalArgumentException("Invalid pie slice index :" + pos);
        }
    }

    public int getPieOthersSectorIndex() {
        return this.getPieOthersSectorIndex(0);
    }

    private int getPieOthersSectorIndex(int pie) {
        boolean assignCoordinates = true;
        boolean bl = assignCoordinates = this.othersSum == null;
        if (assignCoordinates) {
            this.assignCoordinates();
        }
        try {
            if (this.chart.dataDim == 1) {
                for (int i = 0; i < this.chart.mData.multiData.length; ++i) {
                    if (!this.chart.mData.multiData[i].plotData.isPieOthersSector()) continue;
                    return i;
                }
            } else {
                for (int i = 0; i < this.chart.mData.multiData.length; ++i) {
                    if (!this.chart.mData.multiData[i].multiData[pie].plotData.isPieOthersSector()) continue;
                    return i;
                }
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Invalid pie index:" + pie, ex);
            throw new IllegalArgumentException("Invalid pie index :" + pie);
        }
        return -1;
    }

    public final Boolean[] getPieSlice() {
        if (this.chart.dataDim == 2 && this.chart.mDataLen[1] <= 0) {
            throw new IllegalArgumentException("Invalid pie slice series");
        }
        return this.getPieSliceSet(0);
    }

    private Boolean[] getPieSliceSet(int pie) {
        Boolean[] slice = new Boolean[this.chart.mDataLen[0]];
        for (int i = 0; i < slice.length; ++i) {
            slice[i] = this.getPieSlice(pie, i);
        }
        return slice;
    }

    public final boolean isSectorGapEnabled() {
        return this.doSectorGap;
    }

    public final void setSectorGapEnabled(boolean state) {
        this.doSectorGap = state;
    }

    public final void setFontDistance(double dist) {
        this.fontdistance = dist;
    }

    public final double getFontDistance() {
        return this.fontdistance;
    }

    public final void setGapRatioBetweenPies(double dist) {
        this.gapRatioBetweenPies = dist;
    }

    public final double getGapRatioBetweenPies() {
        return this.gapRatioBetweenPies;
    }

    public final double getSliceDistance() {
        return this.sliceDistance;
    }

    public final void setRotateAngle(int angle) {
        this.initangle = angle;
    }

    public final int getRotateAngle() {
        return this.initangle;
    }

    public final void setCatLabelFont(Font font) {
        this.catLabelFont = font;
        CString.setStringsFont(this.catLabel, font, (int)this.catLabelAngle);
    }

    public final void setLabelFont(Font font) {
        this.pieLabelFont = font;
        CString.setStringsFont(this.pieLabel, font, (int)this.pieLabelAngle);
    }

    public final void setValueFont(Font font) {
        this.pieValueFont = font;
        CString.setStringsFont(this.pieValue, font, (int)this.pieValueAngle);
    }

    public final void setPercentFont(Font font) {
        this.piePercentFont = font;
        CString.setStringsFont(this.piePercent, font, (int)this.piePercentAngle);
    }

    public final void setCatLabelAngle(int angle) {
        this.catLabelAngle = angle;
        CString.setStringsFont(this.catLabel, this.catLabelFont, angle);
    }

    public final void setLabelAngle(int angle) {
        this.pieLabelAngle = angle;
        CString.setStringsFont(this.pieLabel, this.pieLabelFont, angle);
    }

    public final void setLabelColor(Color color) {
        this.pieLabelColor = color;
        CString.setStringsColor(this.pieLabel, color);
    }

    public final void setCatLabelColor(Color color) {
        this.catLabelColor = color;
        CString.setStringsColor(this.catLabel, color);
    }

    public final void setValueAngle(int angle) {
        this.pieValueAngle = angle;
        CString.setStringsFont(this.pieValue, this.pieValueFont, angle);
    }

    public final void setValueColor(Color color) {
        this.pieValueColor = color;
        CString.setStringsColor(this.pieValue, color);
    }

    public final void setPercentAngle(int angle) {
        this.piePercentAngle = angle;
        CString.setStringsFont(this.piePercent, this.piePercentFont, angle);
    }

    public final void setPercentColor(Color color) {
        this.piePercentColor = color;
        CString.setStringsColor(this.piePercent, color);
    }

    public final Font getLabelFont() {
        return this.pieLabelFont;
    }

    public final Font getCatLabelFont() {
        return this.catLabelFont;
    }

    public final Font getValueFont() {
        return this.pieValueFont;
    }

    public final Font getPercentFont() {
        return this.piePercentFont;
    }

    public final Color getLabelColor() {
        return this.pieLabelColor;
    }

    public final Color getCatLabelColor() {
        return this.catLabelColor;
    }

    public final Color getValueColor() {
        return this.pieValueColor;
    }

    public final Color getPercentColor() {
        return this.piePercentColor;
    }

    public final int getLabelAngle() {
        return (int)this.pieLabelAngle;
    }

    public final int getCatLabelAngle() {
        return (int)this.catLabelAngle;
    }

    public final int getValueAngle() {
        return (int)this.pieValueAngle;
    }

    public final int getPercentAngle() {
        return (int)this.piePercentAngle;
    }

    public void setOffset(int target, boolean horz, float f, int pie, int pos) {
        int len = this.chart.mDataLen[0];
        if (pos >= len) {
            throw new IllegalArgumentException("Invalid slice index :" + pos);
        }
        switch (target) {
            case 0: {
                if (horz) {
                    this.pieLabel[pie][pos].xoffset = f;
                    break;
                }
                this.pieLabel[pie][pos].yoffset = f;
                break;
            }
            case 1: {
                if (horz) {
                    this.pieValue[pie][pos].xoffset = f;
                    break;
                }
                this.pieValue[pie][pos].yoffset = f;
                break;
            }
            case 2: {
                if (horz) {
                    this.piePercent[pie][pos].xoffset = f;
                    break;
                }
                this.piePercent[pie][pos].yoffset = f;
            }
        }
    }

    public float getOffset(int target, boolean horz, int pie, int pos) {
        float offset = 0.0f;
        switch (target) {
            case 0: {
                if (horz) {
                    offset = this.pieLabel[pie][pos].xoffset;
                    break;
                }
                offset = this.pieLabel[pie][pos].yoffset;
                break;
            }
            case 1: {
                if (horz) {
                    offset = this.pieValue[pie][pos].xoffset;
                    break;
                }
                offset = this.pieValue[pie][pos].yoffset;
                break;
            }
            case 2: {
                if (horz) {
                    offset = this.piePercent[pie][pos].xoffset;
                    break;
                }
                offset = this.piePercent[pie][pos].yoffset;
                break;
            }
            case 3: {
                offset = horz ? this.catLabel[pie].xoffset : this.catLabel[pie].yoffset;
            }
        }
        return offset;
    }

    private int getNewLineCount(String str, int ind) {
        int tmpCount = 0;
        int indexFirst = -1;
        int indexLast = -1;
        indexFirst = str.indexOf(10, ind);
        indexLast = str.lastIndexOf(10);
        if (indexFirst != -1) {
            ++tmpCount;
        }
        if (indexFirst != indexLast) {
            tmpCount += this.getNewLineCount(str, indexFirst + 1);
        }
        return tmpCount;
    }
}

