/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.awt.Graphics;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.PrintService;
import javax.print.attribute.PrintRequestAttributeSet;
import quadbase.chart.Chart;
import quadbase.chart.PrintUtil;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.output.Rectangle;
import quadbase.reportdesigner.PageViewer.swing.Report;

public class PrintChartForSwing {
    private static final Logger LOGGER = Logger.getLogger(PrintChartForSwing.class.getName());
    Chart chart;
    boolean printingInit = false;
    static int fileCount = 0;
    Report pageReport;
    long abortTime = 2000L;

    public PrintChartForSwing(Chart chart) {
        this.chart = chart;
    }

    public void print() throws Exception {
        this.print(Boolean.TRUE, null, 1);
    }

    public void print(Boolean showDialog, String preferredPrinter) throws Exception {
        this.print(showDialog, preferredPrinter, 1);
    }

    public void print(Boolean showDialog, String preferredPrinter, Integer numOfCopy) throws Exception {
        if (preferredPrinter != null && IOUtil.isJava14()) {
            this.print(showDialog, PrintUtil.getPrintService(preferredPrinter), null, numOfCopy);
        } else {
            this.print(showDialog, null, null, numOfCopy);
        }
    }

    public void print(Boolean showDialog, Object printService, Object printRequestAttributeSet, Integer numOfCopy) throws Exception {
        int numOfCopy_CT;
        PrintService ps = null;
        if (printService != null && !(printService instanceof PrintService)) {
            throw new IllegalArgumentException("printService is not an instance of javax.print.PrintService");
        }
        ps = (PrintService)printService;
        boolean promptDialog = showDialog;
        PrinterJob job = PrinterJob.getPrinterJob();
        try {
            if (ps != null) {
                job.setPrintService(ps);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to set printer service", e);
        }
        PageFormat pageFormat = job.defaultPage();
        Paper paper = pageFormat.getPaper();
        Rectangle pageSize = ServerMessage.getPageSize();
        paper.setSize(pageSize.right(), pageSize.top());
        pageFormat.setPaper(paper);
        double max = pageFormat.getWidth();
        if (max < pageFormat.getHeight()) {
            max = pageFormat.getHeight();
        }
        paper.setImageableArea(0.0, 0.0, pageFormat.getWidth(), pageFormat.getHeight());
        pageFormat.setPaper(paper);
        if (promptDialog) {
            PageFormat newPageFormat = job.pageDialog(pageFormat);
            if (newPageFormat == pageFormat) {
                return;
            }
            pageFormat = newPageFormat;
        }
        paper = pageFormat.getPaper();
        max = pageFormat.getWidth();
        if (max < pageFormat.getHeight()) {
            max = pageFormat.getHeight();
        }
        paper.setImageableArea(0.0, 0.0, max, max);
        pageFormat.setPaper(paper);
        Book bk = new Book();
        LOGGER.finest("ABORT TIME = " + this.abortTime);
        String baseFile = "PRINT_" + System.currentTimeMillis() + fileCount;
        if (ServerMessage.isServletServer()) {
            baseFile = ServerMessage.getPath(baseFile);
        }
        if (++fileCount > 200) {
            fileCount = 0;
        }
        if ((numOfCopy_CT = numOfCopy.intValue()) <= 0) {
            numOfCopy_CT = 1;
        }
        for (int k = 0; k < numOfCopy_CT; ++k) {
            bk.append(new PrintPage(), pageFormat);
        }
        job.setPageable(bk);
        if (!promptDialog || job.printDialog()) {
            try {
                LOGGER.finest("EXPORTING.... " + baseFile);
                if (printRequestAttributeSet != null && printRequestAttributeSet instanceof PrintRequestAttributeSet) {
                    job.print((PrintRequestAttributeSet)printRequestAttributeSet);
                } else {
                    job.print();
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Failed to print", ex);
            }
        }
        LOGGER.finest("DONE");
    }

    class PrintPage
    implements Printable {
        boolean abort = false;

        PrintPage() {
        }

        @Override
        public int print(Graphics g, PageFormat pf, int pageIndex) throws PrinterException {
            if (this.abort) {
                return 1;
            }
            try {
                PrintChartForSwing.this.chart.draw(g);
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Failed to draw the chart", ex);
            }
            return 0;
        }
    }
}

