/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.ColMetaData;
import quadbase.chart.DBAccess;
import quadbase.chart.DataFileInput;
import quadbase.chart.EJBAccess;
import quadbase.chart.ExcelAccess;
import quadbase.chart.PreprocInfo;
import quadbase.chart.SOAPAccess;
import quadbase.chart.SalesForceAccess;
import quadbase.common.paramquery.QueryClassFileInfo;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.EJBInfo;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;

public class ReloadChart {
    private static final Logger LOGGER = Logger.getLogger(ReloadChart.class.getName());

    public static ColData[] getOriginalColData(Chart chart, boolean useDBbuffer) {
        return ReloadChart.getOriginalColData(chart, useDBbuffer, true);
    }

    public static ColData[] getOriginalColData(Chart chart, boolean useDBbuffer, boolean returnChartColData) {
        boolean returnChartData = returnChartColData ? chart.isTransposed() : false;
        ColData[] colData = null;
        try {
            if (chart.sourceData == 2) {
                colData = new DataFileInput().readProcessedData(chart.sourceFile, returnChartData, chart.getTransposeColumn(), null, chart.sourceFileEncoding);
            } else if (chart.sourceData == 4) {
                colData = new DataFileInput().readProcessedData(chart.sourceFile, returnChartData, chart.getTransposeColumn(), null, 2);
            } else if (chart.sourceData == 7) {
                colData = new DataFileInput().readProcessedData(chart.sourceFile, returnChartData, chart.getTransposeColumn(), null, null, chart.getXMLFileQueryInfo(), 7);
            } else if (chart.sourceData == 6) {
                colData = chart.sourceData == 6 && chart.dbInfo != null && chart.dbInfo instanceof QueryClassFileInfo ? new DataFileInput().readProcessedData(chart.sourceFile, returnChartData, chart.getTransposeColumn(), null, null, ((QueryFileInfo)chart.dbInfo).getInSet()) : new DataFileInput().readProcessedData(chart.sourceFile, returnChartData, chart.getTransposeColumn(), null, 6);
            } else if (chart.sourceData == 5) {
                colData = EJBAccess.retrieveResult(chart.jndiName, chart.homeName, chart.remoteName, chart.selectedMethodName, chart.selectedMethodParamVal, chart.environment, returnChartData, chart.getTransposeColumn(), null, null);
            } else if (chart.sourceData == 1) {
                colData = DBAccess.retrieveResult(chart.getQueryFileInfo() == null ? null : chart.getQueryFileInfo().makeVector(), chart.dbInfo, useDBbuffer, returnChartData, chart.getTransposeColumn(), null, null);
            } else {
                if (chart.sourceData == 9) {
                    throw new Exception(LanguageEncoder.getText("Cannot reload chart with the old SOAP data source. Please update your datasource."));
                }
                colData = chart.sourceData == 12 ? SOAPAccess.retrieveResult(chart.soapInfo, returnChartData, chart.getTransposeColumn()) : (chart.sourceData == 11 ? SalesForceAccess.getColData(chart.sfQueryInfo, returnChartData, chart.getTransposeColumn()) : (chart.sourceData == 13 ? ExcelAccess.getColData(chart.excelInfo, returnChartData, chart.getTransposeColumn()) : (chart.sourceData == 3 ? ColData.getColData(chart.sourceList, chart.sourceType, chart.doTranspose, chart.transposeColList, returnChartData, chart.getTransposeColumn(), useDBbuffer) : chart.originalColDataFromMemSource)));
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to load data", ex);
            throw new IllegalArgumentException("Failed to load data " + ex.getMessage());
        }
        return colData;
    }

    public static Vector<ColMetaData> getMetaDataInfo(Chart chart) {
        try {
            if (chart.sourceData == 2) {
                return ColMetaData.getVector(chart.sourceFile, chart.isTransposed(), chart.getTransposeColumn());
            }
            if (chart.sourceData == 4) {
                return ColMetaData.getVector(chart.sourceFile, chart.isTransposed(), chart.getTransposeColumn(), 2);
            }
            if (chart.sourceData == 7) {
                return ColMetaData.getVector(chart.getXMLFileQueryInfo().getFieldInfo(), chart.isTransposed(), chart.getTransposeColumn());
            }
            if (chart.sourceData == 6) {
                if (chart.dbInfo != null && chart.dbInfo instanceof QueryClassFileInfo) {
                    return ColMetaData.getVector(chart.sourceFile, chart.isTransposed(), chart.getTransposeColumn(), 6, ((QueryFileInfo)chart.dbInfo).getInSet());
                }
                return ColMetaData.getVector(chart.sourceFile, chart.isTransposed(), chart.getTransposeColumn(), 6);
            }
            if (chart.sourceData == 5) {
                return ColMetaData.getEJBVector(chart.remoteName, chart.isTransposed(), chart.getTransposeColumn());
            }
            if (chart.sourceData == 1) {
                return ColMetaData.getVector(chart.getQueryFileInfo() == null ? null : chart.getQueryFileInfo().makeVector(), chart.dbInfo, chart.isTransposed(), chart.getTransposeColumn());
            }
            if (chart.sourceData == 9) {
                return null;
            }
            if (chart.sourceData == 12) {
                return ColMetaData.getVector(chart.soapInfo, chart.isTransposed(), chart.getTransposeColumn());
            }
            if (chart.sourceData == 11) {
                return ColMetaData.getVector(chart.sfQueryInfo, chart.isTransposed(), chart.getTransposeColumn());
            }
            if (chart.sourceData == 13) {
                return ColMetaData.getVector(chart.excelInfo, chart.isTransposed(), chart.getTransposeColumn());
            }
            if (chart.sourceData == 3) {
                Vector<ColMetaData> metaDataList = new Vector<ColMetaData>();
                for (int i = 0; i < chart.sourceList.length; ++i) {
                    Object temp = chart.sourceList[i];
                    Vector<ColMetaData> mData = null;
                    if (temp instanceof DBInfoBasic) {
                        mData = ColMetaData.getVector(null, (DBInfoBasic)temp, chart.doTranspose[i], (boolean[])chart.transposeColList[i]);
                    } else if (temp instanceof EJBInfo) {
                        EJBInfo ejbInfo = (EJBInfo)temp;
                        mData = ColMetaData.getEJBVector(ejbInfo.getRemoteName(), chart.doTranspose[i], (boolean[])chart.transposeColList[i]);
                    } else {
                        mData = ColMetaData.getVector((String)temp, chart.doTranspose[i], (boolean[])chart.transposeColList[i], chart.sourceType[i]);
                    }
                    if (mData == null) continue;
                    for (int j = 0; j < mData.size(); ++j) {
                        metaDataList.addElement(mData.elementAt(j));
                    }
                }
                if (chart.isTransposed()) {
                    metaDataList = ColMetaData.transposeVector(metaDataList, chart.getTransposeColumn());
                }
                return metaDataList;
            }
            if (chart.originalColDataFromMemSource == null) {
                throw new IllegalArgumentException("Internal Error: original coldata is null");
            }
            return ColMetaData.getVector(chart.originalColDataFromMemSource);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to load column meta data", e);
            return null;
        }
    }

    public static Chart reloadData(Chart chart, ColData[] colData) {
        chart.originalColDataFromMemSource = colData;
        return ReloadChart.reloadData(chart, true);
    }

    public static Chart reloadData(Chart chart, boolean useDBbuffer) {
        return ReloadChart.reloadData(chart, useDBbuffer, false);
    }

    private static void verifyHiLowMapIndex(Chart chart, PreprocInfo procInfo) {
        if ((chart.getChartType() == 9 || chart.getChartType() == 10) && procInfo != null && chart.originalHiLowMap != null) {
            procInfo.aggrColIndex[0] = chart.originalHiLowMap.hi + 1;
            procInfo.aggrColIndex[2] = chart.originalHiLowMap.low + 1;
            if (chart.getChartType() == 10) {
                procInfo.aggrColIndex[3] = chart.originalHiLowMap.open + 1;
                procInfo.aggrColIndex[4] = chart.originalHiLowMap.close + 1;
            }
        }
    }

    public static Chart reloadData(Chart chart, boolean useDBbuffer, boolean forceSetColData) {
        return ReloadChart.reloadData(chart, useDBbuffer, forceSetColData, true);
    }

    public static Chart reloadData(Chart chart, boolean useDBbuffer, boolean forceSetColData, boolean calculateHistogramBinWidth) {
        boolean histoColData = chart.colData[1].getName().startsWith("count_") || chart.colData[1].getName().startsWith("probability_");
        boolean numericCategory = DataType.isNumeric(chart.colData[0].dataType);
        boolean checkNumericVal = false;
        int dim = 1;
        Chart newchart = null;
        ColData[] colData = null;
        if (chart.sourceData == 0 && chart.originalColDataFromMemSource == null || chart.sourceData == 14) {
            chart.sourceData = chart.originalSourceData;
        }
        PreprocInfo tsInfo = chart.getPreprocInfo();
        try {
            int x;
            LOGGER.finer("Getting new chart data started");
            long start = System.currentTimeMillis();
            if (chart.isTSChart || chart.isHistogram() || chart.isAggregationChart() || chart.isDynamicDrillDown || chart.drillDownVector != null && chart.drillDownVector.size() > 0) {
                chart.checkPreprocInfo();
                chart.processedChart = true;
            } else if (chart.processedChart) {
                chart.processedChart = false;
                chart.clearPreprocInfo();
                if (chart.seriesExists()) {
                    ++dim;
                }
                if (chart.sumByExists()) {
                    ++dim;
                }
                int[] dataMap = new int[dim];
                int i = 0;
                if (chart.seriesExists()) {
                    dataMap[i] = chart.originalMap[chart.getSeriesIndex()];
                    ++i;
                }
                dataMap[i] = chart.originalMap[chart.getCategoryIndex()];
                ++i;
                if (chart.sumByExists()) {
                    dataMap[i] = chart.originalMap[chart.getSumByIndex()];
                }
                chart.valueCol = chart.originalMap[chart.getPrimaryIndex()];
                checkNumericVal = true;
                if (chart.subvalueCol >= 0) {
                    chart.subvalueCol = chart.originalMap[chart.getSecondaryIndex()];
                }
                chart.hilowCol.copy(chart.originalHiLowMap);
                if (chart.chartType == 9 || chart.chartType == 10) {
                    chart.valueCol = chart.originalHiLowMap.hi;
                }
                chart.dataDim = dim;
                chart.mDataMap = new int[dim];
                for (x = 0; x < dim; ++x) {
                    chart.mDataMap[x] = dataMap[x];
                }
            }
            PreprocInfo procInfo = null;
            if (chart.isTimeChart() || chart.isHistogram() || chart.isAggregationChart() || chart.isDynamicDrillDown || chart.drillDownVector != null && chart.drillDownVector.size() > 0) {
                procInfo = chart.getPreprocInfo();
            }
            ReloadChart.verifyHiLowMapIndex(chart, procInfo);
            if (chart.sourceData == 2 || chart.sourceData == 6 || chart.sourceData == 7 || chart.sourceData == 4) {
                try {
                    if (chart.sourceData == 6 && chart.dbInfo != null && chart.dbInfo instanceof QueryClassFileInfo) {
                        colData = new DataFileInput().readProcessedData(chart.sourceFile, chart.isTransposed(), chart.getTransposeColumn(), null, procInfo, ((QueryFileInfo)chart.dbInfo).getInSet());
                    }
                    colData = new DataFileInput().readProcessedData(chart.sourceFile, chart.isTransposed(), chart.getTransposeColumn(), null, procInfo, chart.getXMLFileQueryInfo(), chart.sourceData, chart.isDrawNullColumn(), chart.getNullColumnName(), chart.sourceFileEncoding);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINE, "Failed to load data", ex);
                    throw new IOException("Failed to load data " + ex.getMessage());
                }
            } else {
                if (chart.sourceData == 5) {
                    try {
                        colData = EJBAccess.retrieveResult(chart.jndiName, chart.homeName, chart.remoteName, chart.selectedMethodName, chart.selectedMethodParamVal, chart.environment, chart.isTransposed(), chart.getTransposeColumn(), null, procInfo);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.FINE, "Failed to load data from EJB component", e);
                        throw new IOException("Failed to load data from EJB component " + e.getMessage());
                    }
                }
                if (chart.sourceData == 1) {
                    colData = DBAccess.retrieveResult(chart.getQueryFileInfo() == null ? null : chart.getQueryFileInfo().makeVector(), chart.dbInfo, useDBbuffer, chart.isTransposed(), chart.getTransposeColumn(), null, procInfo, 0, -1, chart.isDrawNullColumn(), chart.getNullColumnName());
                } else {
                    if (chart.sourceData == 9) {
                        throw new Exception(LanguageEncoder.getText("Cannot reload chart with the old SOAP data source. Please update your datasource."));
                    }
                    if (chart.sourceData == 12) {
                        colData = SOAPAccess.retrieveResult(chart.soapInfo, chart.isTransposed(), chart.getTransposeColumn());
                    } else if (chart.sourceData == 11) {
                        colData = SalesForceAccess.getColData(chart.sfQueryInfo, chart.isTransposed(), chart.getTransposeColumn(), procInfo);
                    } else if (chart.sourceData == 13) {
                        colData = ExcelAccess.getColData(chart.excelInfo, chart.isTransposed(), chart.getTransposeColumn(), procInfo, 0, -1);
                    } else if (chart.sourceData == 3) {
                        try {
                            colData = ColData.getColData(chart.sourceList, chart.sourceType, chart.doTranspose, chart.transposeColList, false, null, useDBbuffer);
                            colData = ColData.getColData(DBAccess.processResultSet(ColData.getResultSet(colData), false, chart.isTransposed(), chart.getTransposeColumn(), null, chart.isTimeChart() || chart.isHistogram() || chart.isAggregationChart() || chart.isDynamicDrillDown || chart.drillDownVector != null && chart.drillDownVector.size() > 0 ? tsInfo : null));
                        }
                        catch (Exception ex5) {
                            LOGGER.log(Level.FINE, "Failed to load column data", ex5);
                            if (chart.originalColDataFromMemSource == null) {
                                chart.originalColDataFromMemSource = chart.colData;
                            }
                            try {
                                colData = ColData.getColData(DBAccess.processResultSet(ColData.getResultSet(chart.originalColDataFromMemSource), false, chart.isTransposed(), chart.getTransposeColumn(), null, chart.isTimeChart() || chart.isHistogram() || chart.isAggregationChart() || chart.isDynamicDrillDown || chart.drillDownVector != null && chart.drillDownVector.size() > 0 ? tsInfo : null));
                            }
                            catch (Exception ex) {
                                LOGGER.log(Level.FINE, "Failed to load column original data", ex5);
                                colData = chart.originalColDataFromMemSource;
                            }
                        }
                    } else {
                        if (chart.originalColDataFromMemSource == null) {
                            chart.originalColDataFromMemSource = chart.colData;
                        }
                        try {
                            colData = ColData.getColData(DBAccess.processResultSet(ColData.getResultSet(chart.originalColDataFromMemSource), false, chart.isTransposed(), chart.getTransposeColumn(), null, chart.isTimeChart() || chart.isHistogram() || chart.isAggregationChart() || chart.isDynamicDrillDown || chart.drillDownVector != null && chart.drillDownVector.size() > 0 ? tsInfo : null, chart.isDrawNullColumn(), chart.getNullColumnName()));
                        }
                        catch (Exception ex) {
                            LOGGER.log(Level.FINE, "Failed to load column original data", ex);
                            colData = chart.originalColDataFromMemSource;
                        }
                    }
                }
            }
            if (chart.isHistogram() && calculateHistogramBinWidth && histoColData && numericCategory) {
                ColData[] cds;
                ColData cData = null;
                String cname = chart.getCategoryName();
                for (ColData cd : cds = ReloadChart.getOriginalColData(chart, false, true)) {
                    if (!cd.colName.equals(cname)) continue;
                    cData = cd;
                    break;
                }
                chart.getPreprocInfo().intervalNum = QbUtil.getScaleValue(chart.getBinNumber(), cData, false, chart.getPreprocInfo().lBound, chart.getPreprocInfo().uBound, true);
                colData = ReloadChart.reloadData(chart, true, false, false).getColData();
            }
            if (chart.isHistogram() && chart.isShowPercentage() && !colData[1].getName().startsWith("probability")) {
                colData = QbUtil.probabilityHistogram(colData);
            }
            if (checkNumericVal && !colData[chart.valueCol].isNumeric()) {
                for (x = 0; x < colData.length; ++x) {
                    if (!colData[x].isNumeric()) continue;
                    chart.valueCol = x;
                    checkNumericVal = false;
                    break;
                }
                if (checkNumericVal) {
                    LOGGER.warning("The data set contains no numeric columns");
                }
            }
            LOGGER.finer("Getting new chart data finished in " + (System.currentTimeMillis() - start) + " ms");
            LOGGER.finer("Rebuilding chart started");
            start = System.currentTimeMillis();
            newchart = ReloadChart.doReload(colData, chart, forceSetColData);
            LOGGER.finer("Rebuilding chart finished in " + (System.currentTimeMillis() - start) + " ms");
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to reload chart data", e);
            return chart;
        }
        return newchart;
    }

    private static Chart doReload(ColData[] colData, Chart chart, boolean forceSetColData) {
        Chart newchart;
        block25: {
            newchart = null;
            int dim = 1;
            boolean seriesExists = false;
            boolean sumByExists = false;
            try {
                if (chart.isTSChart || chart.isHistogram() || chart.isAggregationChart() || chart.isDynamicDrillDown || chart.drillDownVector != null && chart.drillDownVector.size() > 0) {
                    int subColExist;
                    chart.processedChart = true;
                    if (chart.tsInfo.groupColIndex[0] >= 0) {
                        ++dim;
                        seriesExists = true;
                    }
                    if (chart.tsInfo.groupColIndex[1] >= 0) {
                        ++dim;
                        sumByExists = true;
                    }
                    int[] datamap = new int[dim];
                    if (seriesExists) {
                        datamap[0] = 1;
                        datamap[1] = 0;
                        if (dim == 2) {
                            chart.valueCol = 2;
                            if (!chart.isHistogram() && chart.subvalueCol >= 0) {
                                chart.subvalueCol = 3;
                            }
                            if (chart.getChartType() == 9 || chart.getChartType() == 10) {
                                chart.hilowCol.hi = 2;
                                subColExist = 0;
                                if (chart.subvalueCol >= 0) {
                                    subColExist = 1;
                                }
                                chart.hilowCol.low = 3 + subColExist;
                                if (chart.getChartType() == 10) {
                                    chart.hilowCol.open = 4 + subColExist;
                                    chart.hilowCol.close = 5 + subColExist;
                                }
                            }
                        } else {
                            datamap[2] = 2;
                            chart.valueCol = 3;
                            if (!chart.isHistogram() && chart.subvalueCol >= 0) {
                                chart.subvalueCol = 4;
                            }
                        }
                    } else if (sumByExists) {
                        datamap[0] = 0;
                        datamap[1] = 1;
                        chart.valueCol = 2;
                        if (!chart.isHistogram() && chart.subvalueCol >= 0) {
                            chart.subvalueCol = 3;
                        }
                    } else {
                        datamap[0] = 0;
                        chart.valueCol = 1;
                        if (!chart.isHistogram() && chart.subvalueCol >= 0) {
                            chart.subvalueCol = 2;
                        }
                        if (chart.getChartType() == 9 || chart.getChartType() == 10) {
                            chart.hilowCol.hi = 1;
                            subColExist = 0;
                            if (chart.subvalueCol >= 0) {
                                subColExist = 1;
                            }
                            chart.hilowCol.low = 2 + subColExist;
                            if (chart.getChartType() == 10) {
                                chart.hilowCol.open = 3 + subColExist;
                                chart.hilowCol.close = 4 + subColExist;
                            }
                        }
                    }
                    if (chart.isHistogram()) {
                        chart.subvalueCol = -1;
                    }
                    newchart = chart.setNewData(colData, datamap, dim);
                    try {
                        if (chart.tsInfo.isLinearOutput()) {
                            int dataDim = ReloadChart.getCategoryIndex(newchart);
                            newchart.setFieldOrder(dataDim, true);
                        }
                        break block25;
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.FINE, "Failed to set field order", ex);
                    }
                    break block25;
                }
                LOGGER.finest("Do_Reload does not contain TIME");
                newchart = chart.setNewData(colData, forceSetColData);
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Failed to reload column data", ex);
                return newchart;
            }
        }
        return newchart;
    }

    private static int getCategoryIndex(Chart chart) {
        int categoryDim;
        switch (chart.getChartType()) {
            case 2: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 18: {
                if (chart.getDataDimension() == 2) {
                    categoryDim = 1;
                    break;
                }
                categoryDim = 0;
                break;
            }
            default: {
                if (chart.isStackType()) {
                    if (chart.getDataDimension() == 2) {
                        categoryDim = 0;
                        break;
                    }
                    categoryDim = 1;
                    break;
                }
                categoryDim = chart.getDataDimension() == 1 ? 0 : 1;
            }
        }
        return categoryDim;
    }
}

