/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axis.description.ParameterDesc;
import org.apache.axis.wsdl.gen.Parser;
import org.w3c.dom.Document;
import quadbase.chart.ColData;
import quadbase.chart.IOUtil2;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.paramquery.SOAPQueryFileInfo;
import quadbase.common.util.IQueryInParam;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.ReadDataFile;
import quadbase.common.util.internal.SOAPCall;
import quadbase.common.util.internal.SOAPUtil;
import quadbase.util.IResultSet;
import quadbase.util.XMLQueryResultSet;
import quadbase.util.internal.TransposeRS;

public class SOAPAccess {
    private static final Logger LOGGER = Logger.getLogger(SOAPAccess.class.getName());

    public static ColData[] retrieveResult(SOAPQueryFileInfo soapInfo) throws Exception {
        return ColData.getColData(new XMLQueryResultSet(SOAPAccess.getXMLStream(soapInfo), soapInfo.getXMLFieldInfo(), null, null, null));
    }

    public static ColData[] retrieveResult(SOAPQueryFileInfo soapInfo, boolean doTransposeData, boolean[] transposeCol) throws Exception {
        IResultSet rs;
        ColData[] colData = SOAPAccess.retrieveResult(soapInfo);
        if (doTransposeData && (rs = TransposeRS.doTranspose(colData, transposeCol)) != null) {
            colData = ColData.getColData(rs);
        }
        return colData;
    }

    public static InputStream getDTDSchema(SOAPQueryFileInfo soapInfo) throws Exception {
        InputStream xmlStream = SOAPAccess.getXMLStream(soapInfo);
        return SOAPUtil.generateDTD(xmlStream);
    }

    public static InputStream getXMLStream(SOAPQueryFileInfo soapInfo) throws Exception {
        return SOAPUtil.processEncodedXML(SOAPAccess.getRawXMLStream(soapInfo));
    }

    public static InputStream getRawXMLStream(SOAPQueryFileInfo soapInfo) throws Exception {
        if (ServerMessage.useServer) {
            ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
            DataOutputStream dout = new DataOutputStream(bstream);
            IConnection socket = null;
            try {
                int messageType = 25502;
                dout.writeShort(messageType);
                soapInfo.write(dout, (short)6612);
                socket = ServerMessage.createConnection();
                byte[] array = bstream.toByteArray();
                socket.setContentLength(array.length);
                socket.getOutputStream().write(array);
                socket.getOutputStream().flush();
            }
            catch (Exception ex) {
                if (socket != null) {
                    socket.close();
                }
                LOGGER.log(Level.FINE, "Failed to write data to server", ex);
                throw new IOException("Failed to contact EspressReport server at " + ServerMessage.getServerInfo() + " " + ex.getMessage());
            }
            byte[] indata = null;
            try {
                DataInputStream instream = new DataInputStream(socket.getInputStream());
                int code = instream.readInt();
                if (code != 0) {
                    throw new Exception(IOUtil2.getErrorString(code) + "\n" + IOUtil.readString(instream, true));
                }
                indata = new byte[instream.readInt()];
                instream.readFully(indata, 0, indata.length);
                instream.close();
                socket.close();
            }
            catch (Exception ex) {
                try {
                    socket.close();
                }
                catch (Exception ex2) {
                    LOGGER.log(Level.FINEST, "Can't close socket", ex2);
                }
                LOGGER.log(Level.FINE, "Failed to load XML stream from SOAP", ex);
                throw ex;
            }
            catch (Error err) {
                try {
                    socket.close();
                }
                catch (Exception ex2) {
                    LOGGER.log(Level.FINEST, "Can't close socket", ex2);
                }
                LOGGER.log(Level.FINE, "Failed to load XML stream from SOAP", err);
                throw new SQLException(err.toString());
            }
            return new ByteArrayInputStream(indata);
        }
        return SOAPAccess.getXMLStreamFromLocal(soapInfo);
    }

    public static InputStream getXMLStreamFromLocal(SOAPQueryFileInfo soapInfo) throws Exception {
        Parser parser = new Parser();
        parser.run(soapInfo.getWsdlUri());
        SOAPCall call = new SOAPCall(parser, soapInfo.getServiceName(), soapInfo.getPortName(), soapInfo.getOperationName());
        ArrayList paramList = call.getParameters();
        Object[] parameters = new Object[paramList.size()];
        for (int i = 0; i < paramList.size(); ++i) {
            ParameterDesc paramDesc = (ParameterDesc)paramList.get(i);
            IQueryInParam param = soapInfo.getSOAPParameter(paramDesc.getName());
            if (param == null) {
                throw new IllegalArgumentException("Parameter '" + paramDesc.getName() + "' not found");
            }
            parameters[i] = param.getValue();
        }
        String result = call.invoke(parameters);
        return new ByteArrayInputStream(result.getBytes());
    }

    public static Document getWSDLFromServer(String wsdlUri) throws Exception {
        DataInputStream dis = new ReadDataFile().getInputStream(wsdlUri);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(dis);
    }
}

