/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.chart.ColData;
import quadbase.chart.DataFileInput;
import quadbase.chart.IOUtil2;
import quadbase.chart.PreprocInfo;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.paramquery.SalesForceQueryFileInfo;
import quadbase.common.util.internal.IOUtil;
import quadbase.util.SalesForceResultSet;
import quadbase.util.internal.TransposeRS;

public class SalesForceAccess {
    private static final Logger LOGGER = Logger.getLogger(SalesForceAccess.class.getName());

    public static ColData[] getColData(SalesForceQueryFileInfo sfQueryInfo) throws Exception {
        return SalesForceAccess.getColData(sfQueryInfo, false, null, null);
    }

    public static ColData[] getColData(SalesForceQueryFileInfo sfQueryInfo, boolean doTranspose, int[] transposeCol) throws Exception {
        boolean[] transposeColBool = TransposeRS.getTransposeColumn(transposeCol);
        return SalesForceAccess.getColData(sfQueryInfo, doTranspose, transposeColBool, null);
    }

    public static ColData[] getColData(SalesForceQueryFileInfo sfQueryInfo, boolean doTranspose, boolean[] transposeCol) throws Exception {
        return SalesForceAccess.getColData(sfQueryInfo, doTranspose, transposeCol, null);
    }

    public static ColData[] getColData(SalesForceQueryFileInfo sfQueryInfo, boolean doTranspose, boolean[] transposeCol, PreprocInfo procInfo) throws Exception {
        if (ServerMessage.useServer) {
            ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
            DataOutputStream dout = new DataOutputStream(bstream);
            IConnection socket = null;
            try {
                int messageType = 11002;
                dout.writeShort(messageType);
                sfQueryInfo.write(dout);
                IOUtil.writeStr(dout, sfQueryInfo.getServerUrl());
                IOUtil.writeStr(dout, sfQueryInfo.getSessionId());
                dout.writeInt(0);
                dout.writeInt(-1);
                dout.writeBoolean(doTranspose);
                if (doTranspose) {
                    IOUtil.writeBooleans(dout, transposeCol);
                }
                dout.writeBoolean(procInfo != null);
                if (procInfo != null) {
                    procInfo.writeAsStream(dout);
                }
                socket = ServerMessage.createConnection();
                byte[] array = bstream.toByteArray();
                socket.setContentLength(array.length);
                socket.getOutputStream().write(array);
                socket.getOutputStream().flush();
            }
            catch (Exception ex) {
                if (socket != null) {
                    socket.close();
                }
                LOGGER.log(Level.FINE, "Failed to write data to server", ex);
                throw new IOException("Failed to contact EspressReport server at " + ServerMessage.getServerInfo() + " " + ex.getMessage());
            }
            byte[] indata = null;
            try {
                DataInputStream instream = new DataInputStream(socket.getInputStream());
                int code = instream.readInt();
                if (code != 0) {
                    throw new SQLException(IOUtil2.getErrorString(code) + "\n" + IOUtil.readString(instream, true));
                }
                indata = new byte[instream.readInt()];
                instream.readFully(indata, 0, indata.length);
                instream.close();
                socket.close();
            }
            catch (Exception ex) {
                try {
                    socket.close();
                }
                catch (Exception ex2) {
                    LOGGER.log(Level.FINEST, "Can't close socket", ex2);
                }
                LOGGER.log(Level.FINE, "Failed to read data from server", ex);
                throw ex;
            }
            catch (Error err) {
                try {
                    socket.close();
                }
                catch (Exception ex2) {
                    LOGGER.log(Level.FINEST, "Can't close socket", ex2);
                }
                LOGGER.log(Level.FINE, "Failed to read data from server", err);
                throw new SQLException(err.toString());
            }
            DataInputStream binput = new DataInputStream(new ByteArrayInputStream(indata));
            return DataFileInput.getColDataFromStream(binput);
        }
        return new SalesForceResultSet(sfQueryInfo).getColData(doTranspose, transposeCol, procInfo);
    }
}

