/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.chart.Axis;
import quadbase.chart.Chart;
import quadbase.chart.ChartColorSet;
import quadbase.chart.ColData;
import quadbase.chart.DataAttribute;
import quadbase.chart.DrillDownInfo;
import quadbase.chart.DrillDownNode;
import quadbase.chart.GraphicsTable;
import quadbase.chart.HiLowMap;
import quadbase.chart.IOUtil2;
import quadbase.chart.IPieChart;
import quadbase.chart.Legend;
import quadbase.chart.LoadChart;
import quadbase.chart.MultiDimData;
import quadbase.chart.PieChart;
import quadbase.chart.PropCString;
import quadbase.chart.ReadDataFile;
import quadbase.chart.WriteDataFile;
import quadbase.common.client.ServerMessage;
import quadbase.common.paramquery.QueryClassFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryMultiValueInParam;
import quadbase.common.paramquery.QueryXMLFileInfo;
import quadbase.common.util.IQueryFileInfo;
import quadbase.common.util.IQueryMultiValueInParam;
import quadbase.common.util.internal.Coder;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.EJBInfo;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.VersioningDataInput;
import quadbase.common.util.internal.VersioningDataOutput;
import quadbase.common.util.internal.XMLFileQueryInfo;
import quadbase.util.DateTimeFormat;
import quadbase.util.IFormat;
import quadbase.util.IQueryInParam;
import quadbase.util.LocaleDateTimeFormat;
import quadbase.util.LocaleNumericFormat;
import quadbase.util.LogicalFormat;
import quadbase.util.NumericFormat;
import quadbase.util.internal.IOUtil;
import quadbase.util.internal.QbUtil;

public class SaveChart {
    private static final Logger LOGGER = Logger.getLogger(SaveChart.class.getName());
    protected Chart chart;
    DataAttribute dataAttr;
    public static final int VERSION = 6612;
    public static final String VERSIONNAME = "ESPRESSCHART " + ServerMessage.getProductVersion();
    public static final String UPDATE_VERSION = ServerMessage.getUpdateVersion();
    public static final int SOURCENONE = 0;
    public static final int SOURCE_BACKUP_DATA = 14;
    public static final int SOURCEDB = 1;
    public static final int SOURCEFILE = 2;
    public static final int SOURCEMULTI = 3;
    public static final int SOURCEXML = 4;
    public static final int SOURCEXMLFILEQUERY = 7;
    public static final int SOURCEXMLDBQUERY = 8;
    public static final int SOURCEEJB = 5;
    public static final int SOURCECLASS = 6;
    public static final int SOURCESOAP = 12;
    public static final int SOURCEOLAP = 10;
    public static final int SOURCESALESFORCE = 11;
    public static final int SOURCESOAPOLD = 9;
    public static final int SOURCEEXCEL = 13;
    public static final String PAC_EXT = ".pac";
    public boolean createHtml = false;
    public boolean createXML = false;
    public int viewerType = 0;
    public boolean useSwing = false;
    private boolean hasQueryFilename = false;
    protected static final int BACKUPROWCOUNT = 10;
    public boolean pack = false;
    private boolean saveChartWithFixData = false;
    private boolean isTemplateFormat = false;
    protected DrillDownNode drillDownNode = null;
    Vector<String> subFiles = new Vector();

    public SaveChart(Chart chart) {
        this.chart = chart;
    }

    private void setSubFiles(Vector<String> subFiles) {
        this.subFiles = subFiles;
    }

    public void setDrillDownNode(DrillDownNode t) {
        this.drillDownNode = t;
    }

    public void saveChartWithFixData(boolean b) {
        this.saveChartWithFixData = b;
    }

    public void generateHtmlFile(boolean createHtml, int viewerType, boolean useSwing) {
        this.createHtml = createHtml;
        this.viewerType = viewerType;
        this.useSwing = useSwing;
    }

    public void generateXMLFile(boolean createXML) {
        this.createXML = createXML;
    }

    public void saveTemplate(String cname) throws IOException {
        this.saveToFile(cname, true);
    }

    public void saveToFile(String cname) throws IOException {
        this.saveToFile(cname, false);
    }

    public void saveToFile(String cname, boolean template) throws IOException {
        this.saveToFile(cname, template, false);
    }

    public void saveToFile(String cname, boolean template, boolean isReportPakFile) throws IOException {
        if (cname == null || cname.trim().equals("")) {
            throw new IOException("No file name selected !");
        }
        ByteArrayOutputStream fstream = new ByteArrayOutputStream(2048);
        DataOutputStream out = new DataOutputStream(fstream);
        this.saveToDataOutput(out, template);
        try {
            WriteDataFile wdfile = new WriteDataFile();
            wdfile.generateHtmlFile(this.createHtml, this.viewerType, this.useSwing, this.createXML);
            wdfile.output(this.chart, fstream.toByteArray(), cname + (this.pack ? PAC_EXT : (template ? ".tpl" : ".cht")), isReportPakFile);
            if (this.createXML) {
                this.createXMLChartFile(cname, cname + (this.pack ? PAC_EXT : (template ? ".tpl" : ".cht")));
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Can't create file", ex);
            throw new IOException(ex.toString());
        }
        finally {
            out.close();
            fstream.close();
        }
    }

    public String saveToFile(String cname, DataOutputStream out, boolean template) throws Exception {
        if (cname == null || cname.trim().equals("")) {
            throw new IOException("No file name selected !");
        }
        String chartName = cname + (this.pack ? PAC_EXT : (template ? ".tpl" : ".cht"));
        this.saveToDataOutput(out, template);
        return chartName;
    }

    public void createXMLChartFile(String xmlFile, String chartFile) throws Exception {
        if (xmlFile == null || xmlFile.trim().equals("")) {
            throw new IOException("No file name provided!");
        }
        this.createXMLChartFile(fstream, chartFile);
        try (ByteArrayOutputStream fstream = new ByteArrayOutputStream(2048);){
            WriteDataFile wdfile = new WriteDataFile();
            if (!xmlFile.endsWith(".xml")) {
                xmlFile = xmlFile + ".xml";
            }
            wdfile.output(fstream.toByteArray(), xmlFile);
        }
    }

    public void createXMLChartFile(OutputStream out, String chartFile) throws Exception {
        Class[] argsClass = new Class[]{Chart.class};
        Object[] argsValue = new Object[]{this.chart};
        Class[] paramClass0 = new Class[]{DrillDownNode.class};
        Object[] paramDrillDownNode = new Object[]{this.drillDownNode};
        Class[] paramClass = new Class[]{OutputStream.class, String.class};
        Object[] paramValue = new Object[]{out, chartFile};
        Class<?> objClass = Class.forName("quadbase.chart.xml.SaveChartToXML");
        Constructor<?> objCons = objClass.getConstructor(argsClass);
        Object xmlChart = objCons.newInstance(argsValue);
        Method objMethod0 = objClass.getMethod("setDrillDownNode", paramClass0);
        objMethod0.invoke(xmlChart, paramDrillDownNode);
        Method objMethod = objClass.getMethod("saveToOutputStream", paramClass);
        objMethod.invoke(xmlChart, paramValue);
    }

    public void saveToDataOutput(DataOutput out, boolean template) throws IOException {
        out.writeInt(22071);
        if (!template) {
            out.writeInt(6612);
            IOUtil.writeString(out, this.chart.registryID);
            IOUtil.writeString(out, this.chart.dataSourceID);
            IOUtil.writeString(out, this.chart.dataSourceLoc);
            this.hasQueryFilename = this.chart.queryFilename != null && !this.chart.queryFilename.equals("");
            out.writeBoolean(this.hasQueryFilename);
            if (!this.hasQueryFilename) {
                SaveChart.saveColData(out, this.chart.colData, this.chart.nCol, this.chart.nRow);
            }
        }
        this.isTemplateFormat = template;
        this.dataAttr = new DataAttribute(this.chart.mData, false, this.chart.is2DChart, this.chart.chartType, true, this.chart.isUniqueColorForCol());
        this.saveData(out);
    }

    public void save(String cname) throws Exception {
        if (cname == null || cname.trim().equals("")) {
            throw new IllegalArgumentException("No file name selected !");
        }
        this.saveToFile(cname);
    }

    private void saveData(DataOutput orgOut) throws IOException {
        try {
            int i;
            int i2;
            byte[] barray;
            String filename;
            VersioningDataOutput vout;
            boolean isDrillDownPresent;
            int sourceData;
            orgOut.writeInt(6612);
            DataOutput out = orgOut;
            if (!(orgOut instanceof VersioningDataOutput)) {
                out = new VersioningDataOutput(orgOut);
            }
            IOUtil.writeString(out, this.chart.registryID);
            IOUtil.writeString(out, this.chart.dataSourceID);
            IOUtil.writeString(out, this.chart.dataSourceLoc);
            this.saveTree(out, this.drillDownNode);
            int n = sourceData = this.chart.getOriginalSourceData() > 0 && (this.chart.sourceData == 0 || this.chart.sourceData == 14) ? this.chart.getOriginalSourceData() : this.chart.sourceData;
            if (this.saveChartWithFixData) {
                sourceData = 0;
            }
            out.writeInt(sourceData);
            if (sourceData != 0 && sourceData != 14) {
                this.saveColData(out, this.chart.colData, 10);
            }
            if (sourceData == 1) {
                this.chart.dbInfo.write(out);
                if (this.hasQueryFilename) {
                    IOUtil.writeString(out, Coder.encode(this.chart.queryFilename));
                } else {
                    boolean failed = true;
                    ByteArrayOutputStream bytestream = new ByteArrayOutputStream();
                    DataOutput dout = new DataOutputStream(bytestream);
                    dout = new VersioningDataOutput(dout);
                    if (this.chart.dbInfo instanceof IQueryFileInfo) {
                        try {
                            IQueryInParam[] params = QbUtil.getInParam(this.chart.dbInfo);
                            if (params != null) {
                                dout.writeInt(params.length);
                                for (IQueryInParam param : params) {
                                    QueryInParam currP = null;
                                    boolean multiValue = false;
                                    if (param instanceof IQueryMultiValueInParam) {
                                        multiValue = true;
                                        currP = new QueryMultiValueInParam((IQueryMultiValueInParam)((Object)param), this.chart.dbInfo.getQuery());
                                    } else {
                                        currP = new QueryInParam(param, this.chart.dbInfo.getQuery());
                                    }
                                    if (this.drillDownNode == null) {
                                        currP.setDefaultValue(param.getValue());
                                        if (multiValue) {
                                            ((QueryMultiValueInParam)currP).setValues(((IQueryMultiValueInParam)((Object)param)).getValues());
                                        } else {
                                            currP.setValue(param.getValue());
                                        }
                                    }
                                    currP.write(dout);
                                }
                                if (dout instanceof VersioningDataOutput) {
                                    ((VersioningDataOutput)dout).flush();
                                } else if (dout instanceof DataOutputStream) {
                                    ((DataOutputStream)dout).flush();
                                }
                                failed = false;
                            }
                        }
                        catch (Exception ex) {
                            LOGGER.log(Level.FINE, "Failed to get parameter values", ex);
                        }
                    }
                    if (failed) {
                        out.writeInt(0);
                    } else if (out instanceof VersioningDataOutput) {
                        ((VersioningDataOutput)out).getOriginalDataOutput().write(bytestream.toByteArray());
                    } else {
                        out.write(bytestream.toByteArray());
                    }
                }
            } else if (sourceData == 2 || sourceData == 4 || sourceData == 6) {
                IOUtil.writeString(out, Coder.encode(this.chart.sourceFile));
                out.writeBoolean(sourceData == 6 && this.chart.dbInfo != null && this.chart.dbInfo instanceof QueryClassFileInfo);
            } else if (sourceData == 7) {
                XMLFileQueryInfo xmlFileQueryInfo;
                out.writeBoolean(false);
                XMLFileQueryInfo temp = xmlFileQueryInfo = this.chart.xmlFileQueryInfo;
                if (this.chart.dbInfo instanceof QueryXMLFileInfo) {
                    QueryInParam[] params = xmlFileQueryInfo.getInSet().getParameter();
                    QueryInParam[] temp_params = new QueryInParam[params.length];
                    for (int i3 = 0; i3 < params.length; ++i3) {
                        QueryInParam currP = null;
                        currP = params[i3] instanceof IQueryMultiValueInParam ? new QueryMultiValueInParam((IQueryMultiValueInParam)((Object)params[i3]), xmlFileQueryInfo.getCondition()) : new QueryInParam(params[i3], xmlFileQueryInfo.getCondition());
                        temp_params[i3] = currP;
                    }
                    temp = xmlFileQueryInfo.getFileName() != null ? new XMLFileQueryInfo(xmlFileQueryInfo.getFileName(), xmlFileQueryInfo.getFieldInfo(), xmlFileQueryInfo.getCondition(), xmlFileQueryInfo.getConditionInfo(), xmlFileQueryInfo.getDTDName(), xmlFileQueryInfo.isVerify(), new QueryInParamSet(temp_params)) : new XMLFileQueryInfo((InputStream)new ByteArrayInputStream(xmlFileQueryInfo.getData()), xmlFileQueryInfo.getFieldInfo(), xmlFileQueryInfo.getCondition(), xmlFileQueryInfo.getConditionInfo(), new ByteArrayInputStream(xmlFileQueryInfo.getDTD()), xmlFileQueryInfo.isVerify(), new QueryInParamSet(temp_params, xmlFileQueryInfo.getInSet().getParameterInPromptSequence()));
                }
                temp.write(out);
                out.writeBoolean(this.chart.dbInfo instanceof QueryXMLFileInfo);
            } else {
                if (sourceData == 9) {
                    throw new Exception(LanguageEncoder.getText("Cannot save chart with the old SOAP data source. Please update your datasource before saving."));
                }
                if (sourceData == 12) {
                    this.chart.soapInfo.write(out, (short)395);
                } else if (sourceData == 11) {
                    this.chart.sfQueryInfo.write(out);
                } else if (sourceData == 13) {
                    this.chart.excelInfo.write(out);
                } else if (sourceData == 10) {
                    IOUtil.writeString(out, Coder.encode(this.chart.mondrianConnectionString));
                    IOUtil.writeString(out, Coder.encode(this.chart.MDXQuery));
                    IOUtil.writeString(out, Coder.encode(this.chart.xmlaURI));
                    IOUtil.writeString(out, Coder.encode(this.chart.xmlaDataSource));
                    IOUtil.writeString(out, Coder.encode(this.chart.xmlaCatalog));
                    out.writeInt(this.chart.inputMethod);
                } else if (sourceData == 5) {
                    out.writeInt(2);
                    IOUtil.writeString(out, Coder.encode(this.chart.jndiName));
                    IOUtil.writeString(out, Coder.encode(this.chart.homeName));
                    IOUtil.writeString(out, Coder.encode(this.chart.remoteName));
                    IOUtil.writeString(out, Coder.encode(this.chart.selectedMethodName));
                    Object[] vals = this.chart.selectedMethodParamVal;
                    out.writeInt(vals.length);
                    for (Object val : vals) {
                        IOUtil.writeString(out, Coder.encode(val.getClass().getName()));
                        IOUtil.writeString(out, Coder.encode(val.toString()));
                    }
                    int envsize = 0;
                    if (this.chart.environment != null) {
                        envsize = this.chart.environment.size();
                    }
                    out.writeInt(envsize);
                    if (this.chart.environment != null) {
                        Enumeration<String> e = this.chart.environment.keys();
                        while (e.hasMoreElements()) {
                            String key = e.nextElement();
                            IOUtil.writeString(out, Coder.encode(key));
                            IOUtil.writeString(out, Coder.encode(this.chart.environment.get(key)));
                        }
                    }
                } else if (sourceData == 3) {
                    out.writeInt(this.chart.sourceList.length);
                    for (int i4 = 0; i4 < this.chart.sourceList.length; ++i4) {
                        Object temp = this.chart.sourceList[i4];
                        if (temp instanceof DBInfoBasic) {
                            out.writeInt(1);
                            ((DBInfoBasic)temp).write(out);
                        } else if (this.chart.sourceType[i4] == 4) {
                            out.writeInt(4);
                            IOUtil.writeString(out, Coder.encode((String)temp));
                        } else if (this.chart.sourceType[i4] == 7) {
                            out.writeInt(7);
                            XMLFileQueryInfo xmlFileQueryInfo = (XMLFileQueryInfo)temp;
                            xmlFileQueryInfo.write(out);
                        } else if (this.chart.sourceType[i4] == 5) {
                            out.writeInt(5);
                            out.writeInt(2);
                            EJBInfo ejbInfo = (EJBInfo)temp;
                            IOUtil.writeString(out, Coder.encode(ejbInfo.getJNDIName()));
                            IOUtil.writeString(out, Coder.encode(ejbInfo.getHomeName()));
                            IOUtil.writeString(out, Coder.encode(ejbInfo.getRemoteName()));
                            IOUtil.writeString(out, Coder.encode(ejbInfo.getSelectedMethodName()));
                            Object[] vals = ejbInfo.getSelectedMethodParamVal();
                            out.writeInt(vals.length);
                            for (Object val : vals) {
                                IOUtil.writeString(out, Coder.encode(val.getClass().getName()));
                                IOUtil.writeString(out, Coder.encode(val.toString()));
                            }
                            int envsize = 0;
                            Hashtable<String, String> thisEnvironment = ejbInfo.getEnvironment();
                            if (thisEnvironment != null) {
                                envsize = thisEnvironment.size();
                            }
                            out.writeInt(envsize);
                            if (thisEnvironment != null) {
                                Enumeration<String> e = thisEnvironment.keys();
                                while (e.hasMoreElements()) {
                                    String key = e.nextElement();
                                    IOUtil.writeString(out, Coder.encode(key));
                                    IOUtil.writeString(out, Coder.encode(thisEnvironment.get(key)));
                                }
                            }
                        } else if (this.chart.sourceType[i4] == 6) {
                            out.writeInt(6);
                            IOUtil.writeString(out, Coder.encode((String)temp));
                        } else {
                            out.writeInt(2);
                            IOUtil.writeString(out, Coder.encode((String)temp));
                        }
                        out.writeBoolean(this.chart.doTranspose[i4]);
                        IOUtil.writeBooleans(out, (boolean[])this.chart.transposeColList[i4]);
                    }
                } else if (sourceData == 0 || sourceData == 14) {
                    ColData[] memDataSrc = this.chart.originalColDataFromMemSource;
                    if (this.saveChartWithFixData) {
                        memDataSrc = this.chart.colData;
                    }
                    out.writeBoolean(memDataSrc != null);
                    if (memDataSrc != null) {
                        SaveChart.saveColData(out, memDataSrc);
                    }
                }
            }
            out.writeBoolean(this.chart.isTransposed);
            IOUtil.writeBooleans(out, this.chart.transposeCol);
            if (!this.chart.summaryChart || (this.chart.drillDownVector == null || this.chart.drillDownVector.size() <= 0) && !this.chart.isDynamicDrillDown) {
                isDrillDownPresent = false;
                out.writeBoolean(isDrillDownPresent);
            } else {
                isDrillDownPresent = true;
                out.writeBoolean(isDrillDownPresent);
                out.writeBoolean(this.chart.isDynamicDrillDown);
                out.writeInt(this.chart.primaryAggregate);
                out.writeInt(this.chart.secondaryAggregate);
                IOUtil.writeString(out, Coder.encode(this.chart.drillTemplateName));
                if (this.chart.drillDownVector != null) {
                    for (int i5 = 0; i5 < this.chart.drillDownVector.size(); ++i5) {
                        String drillPath = this.chart.drillTemplatePath + this.chart.drillTemplateName + i5 + ".tpl";
                        this.subFiles.add(drillPath);
                    }
                }
                if (!this.chart.isDynamicDrillDown) {
                    DrillDownInfo.write(out, this.chart.drillDownVector);
                }
            }
            this.chart.checkPreprocInfo();
            out.writeBoolean(this.chart.isTSChart);
            out.writeBoolean(this.chart.isHistogram());
            ((VersioningDataOutput)out).writeBoolean(this.chart.isShowPercentage(), (short)6606);
            ((VersioningDataOutput)out).writeInt(this.chart.getBinNumber(), (short)6607);
            ((VersioningDataOutput)out).writeBoolean(this.chart.isAggregationChart(), (short)410);
            if (this.chart.isTSChart || this.chart.isHistogram() || isDrillDownPresent || this.chart.isAggregationChart()) {
                this.chart.tsInfo.writeAsStream(out, true);
            }
            out.writeBoolean(this.chart.isPrevParamPrompt());
            out.writeInt(this.chart.getChartType());
            out.writeBoolean(this.chart.is2DimChart());
            ((VersioningDataOutput)out).writeBoolean(this.chart.isDrawNullColumn(), (short)411);
            IOUtil.writeString(out, this.chart.getNullColumnName(), (short)411);
            Dimension d = this.chart.getSize();
            out.writeInt(d.width);
            out.writeInt(d.height);
            ((VersioningDataOutput)out).writeBoolean(this.pack, (short)503);
            out.writeInt(this.chart.getScrollBarOption());
            out.writeBoolean(this.chart.isAutoRotate());
            out.writeBoolean(this.chart.isAdjustFont());
            out.writeBoolean(this.chart.isPopupMenuEnabled());
            if (this.chart.isPopupMenuEnabled()) {
                out.writeBoolean(this.chart.isDimMenuEnabled());
                out.writeBoolean(this.chart.isTypeMenuEnabled());
            }
            if (!this.chart.isCircularChart()) {
                IOUtil.writeColor(out, this.chart.getAxisColor());
                for (int i6 = 0; i6 < 4; ++i6) {
                    this.writeAxis(this.chart.axis[i6], out);
                }
                out.writeBoolean(this.chart.isSwapAxis());
                out.writeBoolean(this.chart.isJoinAxis());
                out.writeBoolean(this.chart.isSynchronizeRadarAxis());
                out.writeBoolean(this.chart.isDrawCircularGrid());
                out.writeBoolean(this.chart.getAreaCutOffPoint() != null);
                if (this.chart.getAreaCutOffPoint() != null) {
                    out.writeDouble(this.chart.getAreaCutOffPoint());
                }
                out.writeBoolean(this.chart.isGridAlignedWithTicker());
                out.writeBoolean(this.chart.isGridInFront());
            }
            switch (this.chart.chartType) {
                case 6: 
                case 20: {
                    PieChart pieChart = ((IPieChart)((Object)this.chart)).getPieChart();
                    out.writeInt(pieChart.pieSectors);
                    ((VersioningDataOutput)out).writeInt(pieChart.pieThickness[0], (short)501);
                    ((VersioningDataOutput)out).writeBoolean(this.chart.getConcentricDoughnut(), (short)6609);
                    out.writeDouble(pieChart.fontdistance);
                    out.writeDouble(pieChart.sliceDistance);
                    out.writeInt(pieChart.initangle);
                    IOUtil.writeFont(out, pieChart.pieLabelFont);
                    IOUtil.writeFont(out, pieChart.pieValueFont);
                    IOUtil.writeFont(out, pieChart.piePercentFont);
                    IOUtil.writeColor(out, pieChart.pieLabelColor);
                    IOUtil.writeColor(out, pieChart.pieValueColor);
                    IOUtil.writeColor(out, pieChart.piePercentColor);
                    out.writeDouble(pieChart.pieLabelAngle);
                    out.writeDouble(pieChart.pieValueAngle);
                    out.writeDouble(pieChart.piePercentAngle);
                    out.writeBoolean(this.chart.getLabelState());
                    out.writeBoolean(this.chart.getPercentState());
                    out.writeBoolean(this.chart.getValueState());
                    out.writeBoolean(pieChart.smartlabel);
                    out.writeBoolean(pieChart.valInLegend);
                    out.writeBoolean(pieChart.isSectorGapEnabled());
                    out.writeBoolean(pieChart.pieExtendLine);
                    out.writeBoolean(pieChart.labelAtTheSide);
                    out.writeBoolean(this.chart.dataDim == 2);
                    out.writeDouble(pieChart.catLabelDistance);
                    IOUtil.writeFont(out, pieChart.catLabelFont);
                    IOUtil.writeColor(out, pieChart.catLabelColor);
                    out.writeDouble(pieChart.catLabelAngle);
                    out.writeBoolean(this.chart.getCatLabelState());
                    out.writeBoolean(pieChart.isBestFit());
                    out.writeBoolean(pieChart.isDrawLinearly());
                    out.writeInt(pieChart.piePerRow);
                    out.writeDouble(pieChart.getGapRatioBetweenPies());
                    out.writeInt(pieChart.pieLabel.length);
                    int sector = 0;
                    if (pieChart.pieLabel.length > 0) {
                        sector = pieChart.pieLabel[0].length;
                    }
                    out.writeInt(sector);
                    for (int i7 = 0; i7 < pieChart.pieLabel.length; ++i7) {
                        for (int j = 0; j < sector; ++j) {
                            out.writeFloat(pieChart.pieLabel[i7][j].xoffset);
                            out.writeFloat(pieChart.pieLabel[i7][j].yoffset);
                            out.writeFloat(pieChart.pieValue[i7][j].xoffset);
                            out.writeFloat(pieChart.pieValue[i7][j].yoffset);
                            out.writeFloat(pieChart.piePercent[i7][j].xoffset);
                            out.writeFloat(pieChart.piePercent[i7][j].yoffset);
                        }
                        if (this.chart.dataDim != 2) continue;
                        out.writeFloat(pieChart.catLabel[i7].xoffset);
                        out.writeFloat(pieChart.catLabel[i7].yoffset);
                    }
                    break;
                }
                case 12: {
                    IOUtil.writeColor(out, this.chart.get3DSurfaceColor());
                    this.chart.writeSurfaceHyperLinkList(out);
                    break;
                }
                case 13: {
                    out.writeInt(this.chart.bubbleDrawMode);
                    out.writeDouble(this.chart.axisUnitToRadiusRatio);
                    out.writeBoolean(this.chart.is3DBubblesDrawn());
                    out.writeInt(this.chart.bubble3DLight);
                    break;
                }
                case 3: {
                    if (this.chart.isSelectiveStep || this.chart.showStepLine) {
                        IOUtil.writeBooleans(out, this.chart.selectStep);
                    } else {
                        IOUtil.writeBooleans(out, null);
                    }
                    out.writeBoolean(this.chart.getStepLineState());
                    out.writeDouble(this.chart.getStepLineRatio());
                    out.writeBoolean(this.chart.isShowDoubleValueForLine());
                    out.writeBoolean(this.chart.isSyncPointColorForLine());
                    out.writeBoolean(this.chart.isShowDropBarForLine());
                    if (this.chart.isShowDropBarForLine()) {
                        out.writeBoolean(this.chart.getDropBarBorderState());
                        IOUtil.writeColor(out, this.chart.getDropBarColor());
                        IOUtil.writeColor(out, this.chart.getDropBarColor2());
                        out.writeInt(this.chart.getDropBarSeries1());
                        out.writeInt(this.chart.getDropBarSeries2());
                    }
                    out.writeInt(this.chart.getLayout());
                    break;
                }
                case 16: {
                    this.saveLabelOffset(out, this.chart);
                    break;
                }
                case 19: {
                    out.writeInt(this.chart.getNoSectionForPolar());
                    out.writeDouble(this.chart.getStartAngleForPolar());
                    out.writeBoolean(this.chart.isRadianForPolar());
                    out.writeBoolean(this.chart.isClockWiseForPolar());
                    this.saveLabelOffset(out, this.chart);
                    break;
                }
                case 17: {
                    this.saveLabelOffset(out, this.chart);
                    out.writeDouble(this.chart.getStartAngleForDial());
                    out.writeDouble(this.chart.getEndAngleForDial());
                    out.writeDouble(this.chart.getRadiusForInternalDial());
                    IOUtil.writeColor(out, this.chart.getCenterColorForDial());
                    out.writeBoolean(this.chart.isDrawFullCircleForDial());
                    out.writeInt(this.chart.getSubTickerLength());
                    out.writeInt(this.chart.getTickerLength());
                    out.writeBoolean(this.chart.is3DShadowForTickerOn());
                    out.writeInt(this.chart.getSubTickerCount());
                    out.writeInt(this.chart.getSubTickerThickness());
                    out.writeBoolean(this.chart.isPointerUsed());
                    ((VersioningDataOutput)out).writeInt(this.chart.getNeedleOption(), (short)410);
                    break;
                }
                case 15: {
                    out.writeInt(this.chart.getLayout());
                    break;
                }
                case 18: {
                    out.writeBoolean(this.chart.isLabelDateTimeDisplay(0));
                    out.writeBoolean(this.chart.isDisplayByWeek(0));
                    out.writeBoolean(this.chart.isGanttArrowsDrawn());
                    break;
                }
                case 2: {
                    for (int i8 = 0; i8 < 3; ++i8) {
                        out.writeBoolean(this.chart.isLabelDateTimeDisplay(i8));
                        out.writeBoolean(this.chart.isDisplayByWeek(i8));
                    }
                    ((VersioningDataOutput)out).writeBoolean(this.chart.isLineInOriginalOrder(), (short)6604);
                    ((VersioningDataOutput)out).writeBoolean(this.chart.isDrawConnectLineArrows(), (short)6604);
                }
            }
            IOUtil2.writeCString(out, this.chart.mainTitle);
            out.writeFloat(this.chart.getFontResizeRatio());
            this.saveLegend(out, this.chart.legend);
            this.saveLegend(out, this.chart.legend2);
            int fontMappingSize = 0;
            if (this.chart.fontMapping != null) {
                fontMappingSize = this.chart.fontMapping.size();
            }
            out.writeInt(fontMappingSize);
            if (this.chart.fontMapping != null) {
                Enumeration<String> e = this.chart.fontMapping.keys();
                while (e.hasMoreElements()) {
                    String key = e.nextElement();
                    IOUtil.writeString(out, key);
                    IOUtil.writeString(out, this.chart.fontMapping.get(key));
                }
            }
            out.writeBoolean(this.chart.getTopValueState());
            out.writeBoolean(this.chart.getStackLabelState());
            out.writeBoolean(this.chart.getStackTotalLabelState());
            if (this.chart.getTopValueState()) {
                out.writeInt(this.chart.topLabel_Alignment);
                out.writeInt(this.chart.stackLabel_Alignment);
                IOUtil.writeFont(out, this.chart.topvalueLabel_font);
                IOUtil.writeColor(out, this.chart.topvalueLabel_color);
                out.writeBoolean(this.chart.topvalueNegativeLabel_color != null);
                if (this.chart.topvalueNegativeLabel_color != null) {
                    IOUtil.writeColor(out, this.chart.topvalueNegativeLabel_color);
                }
                out.writeInt(this.chart.topvalueLabel_angle);
                if (this.chart.is2DChart) {
                    out.writeInt(this.chart.toplabel_offset_up);
                    out.writeInt(this.chart.toplabel_offset_side);
                } else {
                    out.writeInt(this.chart.toplabel_offset3D_up);
                    out.writeInt(this.chart.toplabel_offset3D_side);
                }
            }
            out.writeBoolean(this.chart.getTopValueState2());
            if (this.chart.getTopValueState2() && this.chart.getTopValueState2()) {
                IOUtil.writeFont(out, this.chart.topvalueLabel2_font);
                IOUtil.writeColor(out, this.chart.topvalueLabel2_color);
                out.writeInt(this.chart.topvalueLabel2_angle);
                if (this.chart.is2DChart) {
                    out.writeInt(this.chart.toplabel2_offset_up);
                    out.writeInt(this.chart.toplabel2_offset_side);
                } else {
                    out.writeInt(this.chart.toplabel2_offset3D_up);
                    out.writeInt(this.chart.toplabel2_offset3D_side);
                }
            }
            out.writeBoolean(this.chart.isLabelOnPositiveSide());
            out.writeBoolean(this.chart.isLabelOnNegativeSide());
            out.writeBoolean(this.chart.isShowSeriesInTopLabel());
            out.writeBoolean(this.chart.processedChart);
            int newValCol = this.chart.valueCol;
            int newSubValCol = this.chart.getSubValueMap();
            HiLowMap newHiLowMap = this.chart.hilowCol;
            int[] oldMap = null;
            HiLowMap oldHiLowMap = null;
            if (this.chart.processedChart) {
                out.writeInt(this.chart.dataDim);
                IOUtil.writeInts(out, this.chart.mDataMap, this.chart.dataDim);
                out.writeInt(this.chart.getSubValueMap());
                out.writeInt(this.chart.valueCol);
                IOUtil.writeInts(out, this.chart.originalMap, 5);
                this.chart.hilowCol.write(out, (short)4100);
                this.chart.originalHiLowMap.write(out, (short)4100);
                oldMap = this.chart.createOriginalMap();
                oldHiLowMap = new HiLowMap();
                oldHiLowMap.copy(this.chart.originalHiLowMap);
            }
            out.writeInt(this.chart.dataDim);
            if (!this.chart.processedChart) {
                IOUtil.writeInts(out, this.chart.mDataMap, this.chart.dataDim);
            } else {
                IOUtil.writeInts(out, oldMap, this.chart.dataDim);
            }
            out.writeInt(this.chart.getSubValueMap());
            out.writeInt(this.chart.getComboSeries());
            if (Chart.isCoordinateType(this.chart.chartType)) {
                if (this.chart.bcoordCol[2]) {
                    IOUtil.writeInts(out, this.chart.coordCol, 3);
                } else {
                    out.writeInt(this.chart.coordCol[0]);
                    out.writeInt(this.chart.coordCol[1]);
                    out.writeInt(-1);
                }
            } else if (this.chart.isHiLow()) {
                if (!this.chart.processedChart) {
                    this.chart.hilowCol.write(out);
                } else if (oldHiLowMap != null) {
                    oldHiLowMap.write(out);
                }
            } else {
                out.writeInt(this.chart.valueCol);
            }
            if (this.chart.processedChart) {
                this.chart.valueCol = newValCol;
                this.chart.subvalueCol = newSubValCol;
                this.chart.hilowCol = newHiLowMap;
            }
            out.writeFloat(this.chart.legend_XProp);
            out.writeFloat(this.chart.legend_YProp);
            out.writeFloat(this.chart.legend2_XProp);
            out.writeFloat(this.chart.legend2_YProp);
            out.writeFloat(this.chart.title_XProp);
            out.writeFloat(this.chart.title_YProp);
            out.writeFloat(this.chart.chart_XProp);
            out.writeFloat(this.chart.chart_YProp);
            out.writeFloat(this.chart.chart_widthProp);
            out.writeFloat(this.chart.chart_heightProp);
            out.writeInt(this.chart.getDBSourceType());
            byte[][] queryFileBytes = this.chart.getQueryFileBytes();
            if (queryFileBytes == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeInt(queryFileBytes.length);
                for (byte[] queryFileByte : queryFileBytes) {
                    if (queryFileByte == null) {
                        out.writeBoolean(false);
                        continue;
                    }
                    out.writeBoolean(true);
                    int count = queryFileByte.length;
                    out.writeInt(count);
                    out.write(queryFileByte);
                }
            }
            IOUtil2.writeArea(out, this.chart.getBackground());
            out.writeInt(this.chart.getBackground().appearance);
            out.writeInt(this.chart.getBackground().depth);
            out.writeInt(this.chart.axisThickness);
            IOUtil2.writeArea(out, this.chart.getBorder());
            out.writeInt(this.chart.getBorderThickness());
            out.writeBoolean(this.chart.getAreaState());
            out.writeBoolean(this.chart.getPointState());
            out.writeBoolean(this.chart.isDrawPointBorder());
            IOUtil.writeColor(out, this.chart.getDrawPointBorderColor(), (short)413);
            out.writeBoolean(this.chart.getLineState());
            out.writeBoolean(this.chart.getPointState2());
            out.writeBoolean(this.chart.isDrawPointBorder2());
            IOUtil.writeColor(out, this.chart.getDrawPointBorderColor2(), (short)413);
            out.writeBoolean(this.chart.getLineState2());
            out.writeBoolean(this.chart.getArrowState());
            out.writeBoolean(this.chart.isXAxisAtTop());
            out.writeBoolean(this.chart.isAntiAliasEnabled());
            out.writeBoolean(this.chart.setAntiAliasForChartOnly);
            out.writeBoolean(this.chart.isShowShadowOnLine());
            ((VersioningDataOutput)out).writeBoolean(this.chart.isShowShadowOnPoint(), (short)6605);
            if (this.chart.isSelectiveStep || this.chart.showStepLine2) {
                IOUtil.writeBooleans(out, this.chart.selectStep);
            } else {
                IOUtil.writeBooleans(out, null);
            }
            out.writeBoolean(this.chart.getStepLineState2());
            out.writeDouble(this.chart.getStepLineRatio2());
            out.writeBoolean(this.chart.getTopValueState());
            out.writeBoolean(this.chart.getWallFrameState());
            out.writeDouble(this.chart.getAnimateSpeed());
            IOUtil2.writeArea(out, this.chart.getDesktopArea());
            out.writeBoolean(this.chart.isBackgroundTransparent());
            out.writeBoolean(this.chart.isTranslucent());
            ((VersioningDataOutput)out).writeFloat(this.chart.getTranslucentValue(), (short)410);
            out.writeBoolean(this.chart.isJ2DRotateEnabled());
            out.writeBoolean(this.chart.isDisableJava2DForStraightText());
            out.writeInt(this.chart.getCutOffThresholdForText());
            IOUtil.writeString(out, this.chart.getNoDataToPlotMessage(), (short)412);
            ((VersioningDataOutput)out).writeInt(this.chart.getNoDataToPlotMessageAngle(), (short)412);
            IOUtil.writeColor(out, this.chart.getNoDataToPlotMessageColor(), (short)412);
            IOUtil.writeFont(out, this.chart.getNoDataToPlotMessageFont(), (short)412);
            ((VersioningDataOutput)out).writeBoolean(this.chart.isNoDataToPlotMessageVisible(), (short)412);
            out.writeInt(this.chart.get_xshift());
            out.writeBoolean(this.chart.getDataBorder());
            out.writeBoolean(this.chart.isDrawBorderForWhiteArea());
            IOUtil.writeColor(out, this.chart.getDataBorderColor());
            out.writeInt(this.chart.getDataBorderThickness());
            out.writeDouble(this.chart.getBarwidthRatio());
            out.writeBoolean(this.chart.showOffsetTicker());
            out.writeInt(this.chart.get_xlabelrow());
            out.writeBoolean(this.chart.getNullDataLine());
            out.writeBoolean(this.chart.isApplyLineStyleToNullData());
            if (this.chart.getChartType() == 2) {
                out.writeBoolean(this.chart.isShowNullInScatter());
            } else {
                out.writeBoolean(!this.chart.isNullDataAsZero());
            }
            ((VersioningDataOutput)out).writeBoolean(this.chart.isZeroAsNullData(), (short)6612);
            ((VersioningDataOutput)out).writeBoolean(this.chart.isDrawNullColumn(), (short)411);
            IOUtil.writeString(out, this.chart.getNullColumnName(), (short)411);
            out.writeBoolean(this.chart.getFormatHint());
            out.writeInt(this.chart.getComboType());
            out.writeBoolean(this.chart.getCandleStick());
            if (!this.chart.is2DChart) {
                out.writeDouble(this.chart.getThickRatio());
                IOUtil2.writeArea(out, this.chart.getWallBackground());
                out.writeInt(this.chart.get3DDrawType());
                IOUtil.writeFloats(out, this.chart.getViewPoint(), 6);
                IOUtil.writeFloats(out, this.chart.getViewTranslate(), 3);
                IOUtil.writeFloats(out, this.chart.getLightPos(), 3);
                IOUtil.writeFloats(out, this.chart.getAmbient(), 3);
                IOUtil.writeFloats(out, this.chart.getIntensity(), 3);
                out.writeFloat(this.chart.getZoomfactor());
                out.writeFloat(this.chart.getX_scale());
                out.writeFloat(this.chart.getY_scale());
                out.writeFloat(this.chart.getZ_scale());
                out.writeFloat((float)this.chart.thickRatio);
            }
            out.writeInt(this.chart.stringList.size());
            for (int i9 = 0; i9 < this.chart.stringList.size(); ++i9) {
                IOUtil2.writePropCString(out, (PropCString)this.chart.stringList.elementAt(i9));
            }
            String pieGroupOthersName = this.chart.getPieGroupOthersName();
            Color[] colorArrayForPieThreshold = this.chart.getColorArrayForPieThreshold();
            if (this.chart.getCandleStick()) {
                pieGroupOthersName = pieGroupOthersName + "#CANDLE_STICK#";
                if (colorArrayForPieThreshold == null) {
                    colorArrayForPieThreshold = new Color[]{this.chart.getCandleUpColor(), this.chart.getCandleDownColor()};
                } else {
                    Color[] newArr = new Color[colorArrayForPieThreshold.length + 2];
                    int i10 = 0;
                    for (i10 = 0; i10 < colorArrayForPieThreshold.length; ++i10) {
                        newArr[i10] = colorArrayForPieThreshold[i10];
                    }
                    newArr[i10] = this.chart.getCandleUpColor();
                    newArr[i10 + 1] = this.chart.getCandleDownColor();
                    colorArrayForPieThreshold = newArr;
                }
            }
            IOUtil.writeString(out, pieGroupOthersName);
            out.writeDouble(this.chart.getPieGroupOthersLimit());
            out.writeDouble(this.chart.getColorThresholdForPie());
            IOUtil.writeColorList(out, colorArrayForPieThreshold);
            out.writeBoolean(this.chart.isUniqueColorForCol());
            ((VersioningDataOutput)out).writeInt(this.chart.maxDataLen, (short)4102);
            ByteArrayOutputStream enstream = new ByteArrayOutputStream(2048);
            DataOutputStream enout = new DataOutputStream(enstream);
            for (int i11 = 0; i11 < this.chart.dataDim; ++i11) {
                Object[] name = null;
                name = this.chart.customDataOrdering != null && this.chart.dataDim == this.chart.customDataOrdering.length && this.chart.customDataOrdering[i11] != null ? this.chart.customDataOrdering[i11] : this.chart.colData[this.chart.mDataMap[i11]].getFieldName();
                if (name == null) {
                    enout.writeInt(0);
                    continue;
                }
                enout.writeInt(name.length);
                for (Object element : name) {
                    IOUtil.writeString(enout, element.toString());
                }
            }
            byte[] encrypb = IOUtil.encode(enstream.toByteArray());
            out.writeInt(encrypb.length);
            out.write(encrypb, 0, encrypb.length);
            this.dataAttr.save(out);
            if (this.chart.mData2 != null) {
                out.writeBoolean(true);
                new DataAttribute(this.chart.mData2, true, this.chart.mData2.chart.is2DChart, this.chart.mData2.chart.chartType, true, false).save(out);
            } else {
                out.writeBoolean(false);
            }
            out.writeLong(this.chart.refreshInterval);
            out.writeBoolean(this.chart.disableSchedule);
            out.writeBoolean(this.chart.showbackgroundImage);
            if (this.chart.showbackgroundImage) {
                IOUtil.writeString(out, this.chart.getBackgroundImage().getUrl().toString());
                IOUtil.writeString(out, this.chart.getBackgroundImage().getRelativeUrl(), (short)395);
                out.writeInt(this.chart.getBackgroundImage().getOption());
                String filename2 = this.chart.getBackgroundImage().getUrl().toString();
                if (filename2.startsWith("file:")) {
                    filename2 = filename2.substring(6);
                }
                if (!this.pack && this.chart.subFilesTable == null) {
                    out.writeBoolean(false);
                } else {
                    try {
                        ByteArrayOutputStream bytestream = new ByteArrayOutputStream(2048);
                        ReadDataFile readfile = new ReadDataFile();
                        DataInputStream in = readfile.getInputStream(filename2);
                        int c = in.read();
                        while (c != -1) {
                            bytestream.write(c);
                            c = in.read();
                        }
                        in.close();
                        bytestream.close();
                        byte[] barray2 = bytestream.toByteArray();
                        ((VersioningDataOutput)out).writeBoolean(true, (short)503);
                        ((VersioningDataOutput)out).writeInt(barray2.length, (short)503);
                        ((VersioningDataOutput)out).write(barray2, 0, barray2.length, (short)503);
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.FINER, "Failed to save background image", ex);
                        out.writeBoolean(false);
                    }
                }
            }
            if (out instanceof VersioningDataOutput) {
                vout = (VersioningDataOutput)out;
                vout.writeBoolean(this.chart.getDialPlotFGImageState(), (short)406);
                if (this.chart.getDialPlotFGImageState()) {
                    IOUtil.writeString(out, this.chart.getDialPlotFGImage().getUrl().toString(), (short)406);
                    IOUtil.writeString(out, this.chart.getDialPlotFGImage().getRelativeUrl(), (short)406);
                    vout.writeInt(this.chart.getDialPlotFGImage().getOption(), (short)406);
                    vout.writeDouble(this.chart.getDialPlotFGRatio(), (short)406);
                    filename = this.chart.getDialPlotFGImage().getUrl().toString();
                    if (filename.startsWith("file:")) {
                        filename = filename.substring(6);
                    }
                    if (!this.pack) {
                        vout.writeBoolean(false, (short)406);
                    } else {
                        vout.writeBoolean(true, (short)406);
                        ByteArrayOutputStream bytestream = new ByteArrayOutputStream(2048);
                        ReadDataFile readfile = new ReadDataFile();
                        DataInputStream in = readfile.getInputStream(filename);
                        int c = in.read();
                        while (c != -1) {
                            bytestream.write(c);
                            c = in.read();
                        }
                        in.close();
                        bytestream.close();
                        barray = bytestream.toByteArray();
                        vout.writeInt(barray.length, (short)406);
                        vout.write(barray, (short)406);
                    }
                }
            }
            if (out instanceof VersioningDataOutput) {
                vout = (VersioningDataOutput)out;
                vout.writeBoolean(this.chart.getDialPlotBGImageState(), (short)406);
                if (this.chart.getDialPlotBGImageState()) {
                    IOUtil.writeString(out, this.chart.getDialPlotBGImage().getUrl().toString(), (short)406);
                    IOUtil.writeString(out, this.chart.getDialPlotBGImage().getRelativeUrl(), (short)406);
                    vout.writeInt(this.chart.getDialPlotBGImage().getOption(), (short)406);
                    vout.writeDouble(this.chart.getDialPlotBGRatio(), (short)406);
                    if (!this.pack) {
                        vout.writeBoolean(false, (short)406);
                    } else {
                        filename = this.chart.getDialPlotBGImage().getRelativeUrl();
                        if (filename == null) {
                            filename = this.chart.getDialPlotBGImage().getUrl().toString();
                        }
                        vout.writeBoolean(true, (short)406);
                        ByteArrayOutputStream bytestream = new ByteArrayOutputStream(2048);
                        ReadDataFile readfile = new ReadDataFile();
                        DataInputStream in = readfile.getInputStream(filename);
                        int c = in.read();
                        while (c != -1) {
                            bytestream.write(c);
                            c = in.read();
                        }
                        in.close();
                        bytestream.close();
                        barray = bytestream.toByteArray();
                        vout.writeInt(barray.length, (short)406);
                        vout.write(barray, (short)406);
                    }
                }
            }
            out.writeInt(this.chart.lineList.size());
            for (i2 = 0; i2 < this.chart.lineList.size(); ++i2) {
                this.chart.lineList.elementAt(i2).write(out);
            }
            this.saveColDataAttr(out, this.chart.colData);
            out.writeBoolean(this.chart.secData != null);
            if (this.chart.secData != null) {
                out.writeInt(this.chart.secData.sepSize);
                out.writeInt(this.chart.secData.tickerSepSize);
                ((VersioningDataOutput)out).writeInt(this.chart.secData.maxNumOfTickerAndLabel, (short)409);
                this.writeDataFormat(out, this.chart.secData.dataFormat);
            }
            out.writeBoolean(this.chart.axisData != null);
            if (this.chart.axisData != null) {
                out.writeInt(this.chart.axisData.length);
                for (i2 = 0; i2 < this.chart.axisData.length; ++i2) {
                    out.writeBoolean(this.chart.axisData[i2] != null);
                    if (this.chart.axisData[i2] == null) continue;
                    out.writeInt(this.chart.axisData[i2].sepSize);
                    out.writeInt(this.chart.axisData[i2].tickerSepSize);
                    ((VersioningDataOutput)out).writeInt(this.chart.axisData[i2].maxNumOfTickerAndLabel, (short)409);
                    this.writeDataFormat(out, this.chart.axisData[i2].dataFormat);
                    this.writeAxis(this.chart.colDataAxis[i2], out);
                }
            }
            out.writeBoolean(this.chart.isAutoAxisPosition());
            out.writeInt(this.chart.getAxisGapOffset());
            int chartColorIndex = this.chart.chartColorSet.getColorSetIndex();
            if (chartColorIndex >= 0 && chartColorIndex < ChartColorSet.colorSetArr.length) {
                ((VersioningDataOutput)out).writeInt(chartColorIndex, (short)505);
                if (this.chart.isSaveColorsForCategories()) {
                    this.chart.chartColorSet.setChartDataPointsColors(new DataAttribute((MultiDimData)this.chart.mData, (boolean)false, (boolean)this.chart.is2DChart, (int)this.chart.chartType).dataColor);
                }
                IOUtil.writeColorList(out, this.chart.chartColorSet.getChartDataPointsColors(), (short)505);
            } else {
                ((VersioningDataOutput)out).writeInt(-1, (short)505);
            }
            ((VersioningDataOutput)out).writeBoolean(this.chart.isSaveColorsForCategories(), (short)506);
            if (this.chart.mData2 != null && this.chart.chartColorSet2 != null) {
                int chartColorIndex2 = this.chart.chartColorSet2.getColorSetIndex();
                if (chartColorIndex2 >= 0 && chartColorIndex2 < ChartColorSet.colorSetArr.length) {
                    ((VersioningDataOutput)out).writeInt(chartColorIndex2, (short)506);
                    if (this.chart.isSaveColorsForCategories()) {
                        this.chart.chartColorSet2.setChartDataPointsColors(new DataAttribute((MultiDimData)this.chart.mData2, (boolean)true, (boolean)this.chart.is2DChart, (int)this.chart.chartType).dataColor);
                    }
                    IOUtil.writeColorList(out, this.chart.chartColorSet2.getChartDataPointsColors(), (short)506);
                } else {
                    ((VersioningDataOutput)out).writeInt(-1, (short)506);
                }
            }
            ((VersioningDataOutput)out).writeBoolean(this.chart.singleColorForCategories, (short)507);
            int hsize = this.chart.hyperlinkList.size();
            out.writeInt(hsize);
            for (i = 0; i < hsize; ++i) {
                this.chart.hyperlinkList.elementAt(i).write(out);
                this.chart.hyperlinkList.elementAt(i).writeHint(out);
            }
            out.writeBoolean(this.chart.getShowDataState());
            ((VersioningDataOutput)out).writeBoolean(this.chart.flashEnableHintBox, (short)500);
            IOUtil.writeFont(out, this.chart.flashHintFont, (short)500);
            IOUtil.writeColor(out, this.chart.flashHintFontColor, (short)500);
            IOUtil.writeColor(out, this.chart.flashHintBgColor, (short)500);
            IOUtil.writeColor(out, this.chart.flashHintBorderColor, (short)500);
            out.writeInt(this.chart.getControlRangeList().size());
            for (i = 0; i < this.chart.getControlRangeList().size(); ++i) {
                this.chart.getControlRangeList().elementAt(i).write(out);
            }
            this.chart.dataLineSet.write(out);
            this.chart.annotationSet.write(out);
            this.chart.valueTable.write(out);
            out.writeBoolean(this.chart.showTable());
            out.writeBoolean(this.chart.isSecondaryDataShownInPrimaryTab());
            if (this.chart.showTable()) {
                GraphicsTable.saveTable(this.chart, out);
            }
            IOUtil.writeColorSpectrum(out, this.chart.colorSpectrum);
            out.writeBoolean(this.chart.is3DApproximationUsed);
            out.writeInt(this.chart.approximationThreshold);
            out.writeBoolean(this.chart.getPrimaryDataGradientSupport().isGradientEnabled());
            out.writeBoolean(this.chart.getPrimaryDataGradientSupport().is3DShadingEnabled());
            ((VersioningDataOutput)out).writeBoolean(this.chart.getPrimaryDataGradientSupport().isApplyGradientToChartDataOnly(), (short)414);
            ((VersioningDataOutput)out).writeDouble(this.chart.getPrimaryDataGradientSupport().getGradientStartX(), (short)410);
            ((VersioningDataOutput)out).writeDouble(this.chart.getPrimaryDataGradientSupport().getGradientStartY(), (short)410);
            ((VersioningDataOutput)out).writeDouble(this.chart.getPrimaryDataGradientSupport().getGradientEndX(), (short)410);
            ((VersioningDataOutput)out).writeDouble(this.chart.getPrimaryDataGradientSupport().getGradientEndY(), (short)410);
            ((VersioningDataOutput)out).writeBoolean(this.chart.getPrimaryDataGradientSupport().getGradientDesColor() != null, (short)410);
            if (this.chart.getPrimaryDataGradientSupport().getGradientDesColor() != null) {
                IOUtil.writeColor(out, this.chart.getPrimaryDataGradientSupport().getGradientDesColor(), (short)410);
            }
            ((VersioningDataOutput)out).writeInt(this.chart.getPrimaryDataGradientSupport().getGradientShade(), (short)410);
            ((VersioningDataOutput)out).writeBoolean(this.chart.getPrimaryDataGradientSupport().isGradientCyclic(), (short)410);
            VersioningDataOutput vOut = (VersioningDataOutput)out;
            vOut.writeBoolean(this.chart.getSecondaryDataGradientSupport().isGradientEnabled(), (short)4103);
            vOut.writeBoolean(this.chart.getSecondaryDataGradientSupport().is3DShadingEnabled(), (short)4103);
            vOut.writeDouble(this.chart.getSecondaryDataGradientSupport().getGradientStartX(), (short)4103);
            vOut.writeDouble(this.chart.getSecondaryDataGradientSupport().getGradientStartY(), (short)4103);
            vOut.writeDouble(this.chart.getSecondaryDataGradientSupport().getGradientEndX(), (short)4103);
            vOut.writeDouble(this.chart.getSecondaryDataGradientSupport().getGradientEndY(), (short)4103);
            vOut.writeBoolean(this.chart.getSecondaryDataGradientSupport().getGradientDesColor() != null, (short)4103);
            if (this.chart.getSecondaryDataGradientSupport().getGradientDesColor() != null) {
                IOUtil.writeColor(vOut, this.chart.getSecondaryDataGradientSupport().getGradientDesColor(), (short)4103);
            }
            vOut.writeInt(this.chart.getSecondaryDataGradientSupport().getGradientShade(), (short)4103);
            vOut.writeBoolean(this.chart.getSecondaryDataGradientSupport().isGradientCyclic(), (short)4103);
            out.writeBoolean(this.chart.isDrawSeriesOnCategoryAxis());
            IOUtil.writeString(out, this.chart.getXMLChartLocation());
            out.writeInt(this.chart.getSortValue());
            this.writeDrillDownNodes(out, this.chart.currentNode);
            if (!this.isTemplateFormat) {
                if (this.pack || this.chart.isPACFile()) {
                    this.writeSubFiles(out);
                } else if (this.chart.getSubFilesTable().size() > 0) {
                    this.unpackSubFiles();
                }
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to save chart data", ex);
            throw new IOException(ex.toString());
        }
    }

    private void writeSubFiles(DataOutput out) throws Exception {
        Vector<String> fileKey = new Vector<String>();
        Vector<byte[]> fileValue = new Vector<byte[]>();
        if (this.subFiles != null) {
            int i;
            for (i = 0; i < this.subFiles.size(); ++i) {
                byte[] barray = null;
                String filename = this.subFiles.elementAt(i);
                try {
                    barray = this.chart.getSubFilesTable().get(filename);
                    if (barray == null) {
                        ByteArrayOutputStream bytestream = new ByteArrayOutputStream(2048);
                        ReadDataFile readfile = new ReadDataFile();
                        DataInputStream in = readfile.getInputStream(filename);
                        int c = in.read();
                        while (c != -1) {
                            bytestream.write(c);
                            c = in.read();
                        }
                        in.close();
                        bytestream.close();
                        barray = bytestream.toByteArray();
                    }
                    fileKey.add(filename);
                    fileValue.add(barray);
                    if (!filename.toUpperCase().endsWith("TPL")) continue;
                    boolean showBGImage = this.chart.showbackgroundImage;
                    int bgImageType = 3;
                    URL bgImageURL = null;
                    String bgImageRelativeURL = null;
                    if (showBGImage) {
                        bgImageType = this.chart.getBackgroundImage().getOption();
                        bgImageURL = this.chart.getBackgroundImage().getUrl();
                        bgImageRelativeURL = this.chart.getBackgroundImage().getRelativeUrl();
                    }
                    try {
                        Chart tmpCht = Chart.createChart(new Frame(), this.chart.chartType, this.chart.is2DimChart(), this.chart, null);
                        tmpCht = tmpCht.loadTemplate(filename);
                        if (!tmpCht.showbackgroundImage) continue;
                        String bgFile = tmpCht.getBackgroundImage().getUrl().toString();
                        if (bgFile.startsWith("file:")) {
                            bgFile = bgFile.substring(6);
                        }
                        ByteArrayOutputStream bytestream = new ByteArrayOutputStream(2048);
                        ReadDataFile readfile = new ReadDataFile();
                        DataInputStream in = readfile.getInputStream(bgFile);
                        int c = in.read();
                        while (c != -1) {
                            bytestream.write(c);
                            c = in.read();
                        }
                        in.close();
                        bytestream.close();
                        byte[] barray2 = bytestream.toByteArray();
                        fileKey.add(bgFile);
                        fileValue.add(barray2);
                        this.chart.showbackgroundImage = showBGImage;
                        if (!showBGImage) continue;
                        this.chart.setBackgroundImage(bgImageURL, bgImageRelativeURL, bgImageType);
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.WARNING, "Failed to save sub-chart background image", ex);
                    }
                    continue;
                }
                catch (Exception ex2) {
                    LOGGER.log(Level.SEVERE, "Failed to save sub-files", ex2);
                }
            }
            out.writeInt(fileKey.size());
            for (i = 0; i < fileKey.size(); ++i) {
                String filename = (String)fileKey.elementAt(i);
                byte[] barray = (byte[])fileValue.elementAt(i);
                IOUtil.writeString(out, filename);
                out.writeInt(barray.length);
                out.write(barray);
                this.chart.putChartFileIntoMemoryTable(filename, barray);
            }
        }
    }

    private void unpackSubFiles() {
        Enumeration e = this.chart.subFilesTable.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            byte[] value = this.chart.subFilesTable.get(key);
            try {
                new WriteDataFile().output(value, key);
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Failed to unpack sub-files", ex);
            }
        }
    }

    private void saveLegend(DataOutput out, Legend legend) throws IOException {
        IOUtil.writeFont(out, legend.getFont());
        out.writeInt(legend.getAngle());
        out.writeInt(legend.getPointSizeRatio());
        IOUtil.writeColor(out, legend.getfontColor());
        IOUtil2.writeArea(out, legend.getBackground());
        IOUtil2.writeArea(out, legend.getBorder());
        out.writeInt(legend.getBackground().appearance);
        out.writeInt(legend.getBackground().depth);
        out.writeBoolean(legend.isVertical());
        ((VersioningDataOutput)out).writeInt(legend.getLayout(), (short)4101);
        ((VersioningDataOutput)out).writeInt(legend.getFixedColumnCount(), (short)4101);
        out.writeBoolean(legend.showLegend);
        ((VersioningDataOutput)out).writeBoolean(legend.useOneLegendSet, (short)6610);
        out.writeBoolean(legend.reverse);
        out.writeBoolean(legend.drawSymbols);
    }

    private void saveLabelOffset(DataOutput out, Chart chart) throws IOException {
        out.writeInt(chart.countLabelOffset());
        for (int i = 0; i < chart.countLabelOffset(); ++i) {
            Dimension dim = chart.getLabelOffset(i);
            out.writeInt(dim.width);
            out.writeInt(dim.height);
        }
    }

    private static void saveColData(DataOutput out, ColData[] colData) throws IOException {
        if (colData == null || colData.length <= 0) {
            SaveChart.saveColData(out, colData, 0, 0);
        } else {
            SaveChart.saveColData(out, colData, colData.length, colData[0].getDataSet().size());
        }
    }

    private void saveColData(DataOutput out, ColData[] colData, int nRow) throws IOException {
        if (colData == null || colData.length <= 1) {
            SaveChart.saveColData(out, colData, 0, 0);
        } else {
            SaveChart.saveColData(out, colData, colData.length - 1, colData[0].getDataSet().size() >= nRow ? nRow : colData[0].getDataSet().size());
        }
    }

    private static void saveColData(DataOutput out, ColData[] colData, int nCol, int nRow) throws IOException {
        ByteArrayOutputStream enstream = new ByteArrayOutputStream(2048);
        DataOutputStream enout = new DataOutputStream(enstream);
        enout.writeInt(nCol);
        enout.writeInt(nRow);
        for (int i = 0; i < nCol; ++i) {
            colData[i].save(enout, nRow);
        }
        byte[] encrypb = IOUtil.encode(enstream.toByteArray());
        out.writeInt(encrypb.length);
        out.write(encrypb, 0, encrypb.length);
    }

    private void saveColDataAttr(DataOutput out, ColData[] colData) throws IOException {
        out.writeInt(colData.length);
        for (ColData cd : colData) {
            int typeLen;
            out.writeInt(cd.sepSize);
            out.writeInt(cd.tickerSepSize);
            ((VersioningDataOutput)out).writeInt(cd.maxNumOfTickerAndLabel, (short)409);
            out.writeInt(cd.axisType);
            out.writeInt(cd.sepUnit);
            out.writeBoolean(cd.startingDate != null);
            if (cd.startingDate != null) {
                out.writeLong(cd.startingDate.getTime());
            }
            out.writeBoolean(cd.endingDate != null);
            if (cd.endingDate != null) {
                out.writeLong(cd.endingDate.getTime());
            }
            out.writeBoolean(cd.isAscending);
            ((VersioningDataOutput)out).writeBoolean(cd.isDrawNullColumn(), (short)411);
            IOUtil.writeString(out, cd.getNullColumnName(), (short)411);
            ((VersioningDataOutput)out).writeInt(cd.getDataOrder(), (short)504);
            this.writeDataFormat(out, cd.dataFormat);
            int len = cd.hideLegend == null ? 0 : cd.hideLegend.length;
            out.writeInt(len);
            for (int j = 0; j < len; ++j) {
                out.writeBoolean(cd.hideLegend[j]);
                out.writeBoolean(cd.hideData[j]);
            }
            int[] fieldType = cd.getFieldType();
            int[] axisPosition = cd.getAxisPosition();
            int n = typeLen = fieldType == null ? 0 : fieldType.length;
            if (typeLen != 0 && axisPosition != null) {
                typeLen = Math.min(typeLen, axisPosition.length);
            }
            out.writeInt(typeLen);
            for (int j = 0; j < typeLen; ++j) {
                out.writeInt(cd.fieldType[j]);
                out.writeInt(axisPosition[j]);
            }
            double[] handLength = cd.getHandLength();
            int handLen = handLength == null ? 0 : handLength.length;
            out.writeInt(handLen);
            if (handLength == null) continue;
            for (int j = 0; j < handLen; ++j) {
                out.writeDouble(handLength[j]);
            }
        }
    }

    private void writeDataFormat(DataOutput out, IFormat dataFormat) throws IOException {
        if (dataFormat == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(dataFormat.getFormatType());
        }
        if (dataFormat instanceof NumericFormat) {
            IOUtil.writeNumericFormat(out, (NumericFormat)dataFormat);
        } else if (dataFormat instanceof DateTimeFormat) {
            IOUtil.writeDateTimeFormat(out, (DateTimeFormat)dataFormat);
        } else if (dataFormat instanceof LogicalFormat) {
            out.writeInt(((LogicalFormat)dataFormat).getformat());
        } else if (dataFormat instanceof LocaleNumericFormat) {
            IOUtil.writeLocaleNumericFormat(out, (LocaleNumericFormat)dataFormat);
        } else if (dataFormat instanceof LocaleDateTimeFormat) {
            IOUtil.writeLocaleDateTimeFormat(out, (LocaleDateTimeFormat)dataFormat);
        }
    }

    private void saveTree(DataOutput out, DrillDownNode node) throws Exception {
        if (node == null) {
            out.writeBoolean(false);
            return;
        }
        out.writeBoolean(true);
        this.saveTreeNode(out, node, true);
    }

    private void saveTreeNode(DataOutput out, DrillDownNode node, boolean saveChildren) throws Exception {
        IOUtil.writeString(out, node.getName());
        IOUtil.writeString(out, node.getFileName());
        int[] mapping = node.getColumnMapping();
        out.writeInt(mapping.length);
        for (int element : mapping) {
            out.writeInt(element);
        }
        if (saveChildren) {
            out.writeInt(node.getChildCount());
            for (int i = 0; i < node.getChildCount(); ++i) {
                this.saveTreeNode(out, node.getChildAt(i), true);
                String fileName = node.getChildAt(i).getFileName();
                Chart subchart = this.getChart(fileName);
                if (this.pack) {
                    this.packSubLevelCharts(subchart);
                }
                this.subFiles.add(fileName);
            }
        }
    }

    private final void packSubLevelCharts(Chart chart) {
        try {
            SaveChart saveChart = new SaveChart(chart);
            saveChart.setSubFiles(this.subFiles);
            saveChart.pack = true;
            ByteArrayOutputStream fstream = new ByteArrayOutputStream(2048);
            DataOutputStream out = new DataOutputStream(fstream);
            saveChart.saveToDataOutput(out, false);
            out.close();
            fstream.close();
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to pack sub-charts", ex);
        }
    }

    private Chart getChart(String file) {
        ReadDataFile readfile = new ReadDataFile();
        Chart chart = null;
        if (IOUtil.isXMLFormat(file)) {
            try {
                chart = readfile.createXMLChart(file, quadbase.common.util.internal.IOUtil.getOffScreenComponent());
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Can't create chart", ex);
                return null;
            }
        }
        DataInputStream din = null;
        try {
            din = readfile.getInputStream(file);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Can't create chart", ex);
            return null;
        }
        try {
            chart = new LoadChart().load(quadbase.common.util.internal.IOUtil.getOffScreenComponent(), din, file.endsWith(".tpl"), null, true);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Can't create chart", ex);
            try {
                readfile.close();
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINEST, "Can't close readfile", ex2);
            }
        }
        catch (Error err) {
            LOGGER.log(Level.SEVERE, "Can't create chart", err);
        }
        return chart;
    }

    public static void saveTree(Chart chart, String url, DrillDownNode node) throws Exception {
        ByteArrayOutputStream fstream = new ByteArrayOutputStream(2048);
        DataOutputStream out = new DataOutputStream(fstream);
        String filename = LoadChart.generateFullName(url);
        SaveChart.saveTree(filename, node, out);
        out.close();
        fstream.close();
        WriteDataFile wdfile = new WriteDataFile();
        wdfile.output(chart, fstream.toByteArray(), filename);
    }

    public static void saveTree(String url, DrillDownNode node, DataOutputStream out) throws Exception {
        ReadDataFile readfile = new ReadDataFile();
        DataInput in = null;
        DataInputStream orgIn = null;
        int header = -1;
        int version = -1;
        boolean hasQueryFileName = false;
        String registryID = null;
        String dataSourceID = null;
        String dataSourceLoc = null;
        String filename = LoadChart.generateFullName(url);
        ColData[] colData = null;
        if (!IOUtil.isXMLFormat(filename)) {
            in = readfile.getInputStream(filename);
            orgIn = in;
            header = in.readInt();
            if (filename.toUpperCase().endsWith("CHT") || filename.toUpperCase().endsWith("PAC")) {
                version = in.readInt();
                if (version >= 302) {
                    registryID = IOUtil.readString(in, true);
                    dataSourceID = IOUtil.readString(in, true);
                    dataSourceLoc = IOUtil.readString(in, true);
                }
                if (!(hasQueryFileName = in.readBoolean())) {
                    colData = LoadChart.createColData(in, version, true);
                }
            }
            if ((version = in.readInt()) >= 394) {
                in = new VersioningDataInput(in, 6612);
            }
            if (version >= 302) {
                registryID = IOUtil.readString(in, true);
                dataSourceID = IOUtil.readString(in, true);
                dataSourceLoc = IOUtil.readString(in, true);
            }
            new LoadChart().loadTree(in);
        }
        out.writeInt(header);
        if (filename.toUpperCase().endsWith("CHT") || filename.toUpperCase().endsWith("PAC")) {
            out.writeInt(version);
            if (version >= 302) {
                IOUtil.writeString(out, registryID);
                IOUtil.writeString(out, dataSourceID);
                IOUtil.writeString(out, dataSourceLoc);
            }
            out.writeBoolean(hasQueryFileName);
            if (!hasQueryFileName) {
                SaveChart.saveColData(out, colData);
            }
        }
        out.writeInt(version);
        DataOutput vout = out;
        if (version >= 394) {
            vout = new VersioningDataOutput(out);
        }
        if (version >= 302) {
            IOUtil.writeString(vout, registryID);
            IOUtil.writeString(vout, dataSourceID);
            IOUtil.writeString(vout, dataSourceLoc);
        }
        new SaveChart(null).saveTree(vout, node);
        boolean stop = false;
        while (!stop) {
            try {
                in = orgIn;
                vout = out;
                out.writeByte(in.readByte());
            }
            catch (EOFException ex) {
                LOGGER.log(Level.FINEST, "Unexpected end of file", ex);
                stop = true;
            }
        }
        readfile.close();
    }

    private void writeDrillDownNodes(DataOutput out, DrillDownNode node) throws Exception {
        if (node == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeInt(node.getChildCount());
            for (int i = 0; i < node.getChildCount(); ++i) {
                this.saveTreeNode(out, node.getChildAt(i), false);
            }
        }
    }

    private void writeAxis(Axis ax, DataOutput out) throws IOException {
        out.writeBoolean(ax.bshow);
        IOUtil2.writeCString(out, ax.title);
        out.writeInt(ax.titleoffset);
        out.writeInt(ax.titlevoffset);
        IOUtil.writeColor(out, ax.color);
        IOUtil.writeColor(out, ax.grid.color);
        out.writeBoolean(ax.grid.bshow);
        out.writeInt(ax.gridThickness);
        ((VersioningDataOutput)out).writeInt(ax.gridLineStyle, (short)6608);
        out.writeBoolean(ax.logScale);
        out.writeBoolean(ax.isShowLogValue());
        out.writeDouble(ax.getBaseForLog());
        out.writeBoolean(ax.isShowSubTickers());
        out.writeBoolean(ax.autoscale);
        out.writeBoolean(ax.autoOrigin);
        out.writeBoolean(ax.addAxisPadding);
        out.writeBoolean(ax.isLabelOutsidePlotArea());
        out.writeDouble(ax.maxScale);
        out.writeDouble(ax.minScale);
        if (ax.isDynamicAutoScale()) {
            out.writeDouble(-99.0);
        } else {
            out.writeDouble(ax.stepScale);
        }
        out.writeInt(ax.stepScaleMonth);
        out.writeDouble(ax.getAxisShift());
        out.writeBoolean(ax.ticker != null);
        if (ax.ticker != null) {
            out.writeBoolean(ax.showTicker);
            IOUtil.writeColor(out, ax.ticker.color);
            IOUtil.writeColor(out, ax.ticker.label_color);
            IOUtil.writeFont(out, ax.ticker.font);
            out.writeInt(ax.ticker.angle);
            out.writeInt(ax.ticker.twidth);
            out.writeInt(ax.ticker.displacement);
            out.writeBoolean(ax.ticker.showline);
            out.writeBoolean(ax.ticker.tickerInward);
            if (ax.ticker.tickerLabel == null) {
                out.writeInt(0);
            } else {
                out.writeInt(ax.ticker.tickerLabel.length);
                for (String element : ax.ticker.tickerLabel) {
                    IOUtil.writeString(out, element);
                }
            }
            out.writeInt(ax.ticker.radarXOffset);
            out.writeInt(ax.ticker.radarYOffset);
        }
    }

    public static String getUpdateVersion() {
        return ServerMessage.getUpdateVersion();
    }

    public static boolean isPacFile(String filename) {
        return filename != null && filename.toLowerCase().endsWith(PAC_EXT);
    }
}

