/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.util.Calendar;
import quadbase.chart.Axis;
import quadbase.common.util.internal.DataType;

public class StepSize {
    private static double AXISPADDING = 1.05;
    public double stepsize = 1.0;
    public int stepmonth = 0;
    public int newMaxPixel;
    public int newMinPixel;
    public double maxvalue = 0.0;
    public double minvalue = 0.0;
    public int stepAbove;
    public int stepBelow;
    public int totalstep;
    public int zeroAxis;
    public int width;
    public double maxlimit;
    public double minlimit;
    public double width_dvalue;
    public double dvalue;
    public Axis axis;

    public StepSize(Axis axis) {
        this(axis, 0, 0, 0.0, 0.0, 0, 0);
    }

    public StepSize(Axis axis, int maxp, int minp, double maxlimit, double minlimit, int row, int decimalpoint) {
        this(axis, maxp, minp, maxlimit, minlimit, row, decimalpoint, false, false);
    }

    public StepSize(Axis axis, int maxp, int minp, double maxlimit, double minlimit, int row, int decimalpoint, boolean isGantt) {
        this(axis, maxp, minp, maxlimit, minlimit, row, decimalpoint, isGantt, false);
    }

    public StepSize(Axis axis, int maxp, int minp, double maxlimit, double minlimit, int row, int decimalpoint, boolean isGantt, boolean isPercent) {
        this(axis, maxp, minp, maxlimit, minlimit, row, decimalpoint, isGantt, isPercent, false);
    }

    public StepSize(Axis axis, int maxp, int minp, double maxlimit, double minlimit, int row, int decimalpoint, boolean isGantt, boolean isPercent, boolean isIntegerData) {
        this.axis = axis;
        this.newMaxPixel = maxp;
        this.newMinPixel = minp;
        if (minlimit <= 0.0) {
            axis.logScale = false;
        }
        if (axis.logScale) {
            this.maxlimit = axis.log(maxlimit);
            this.minlimit = axis.log(minlimit);
        } else {
            this.maxlimit = maxlimit;
            this.minlimit = minlimit;
        }
        this.width = this.newMaxPixel - this.newMinPixel;
        if (axis.stepScale <= 0.0 && axis.stepScaleMonth <= 0) {
            axis.autoscale = true;
        }
        if (axis.autoscale) {
            this.setSize(axis, this.maxlimit, this.minlimit, row, decimalpoint, isGantt, isPercent, isIntegerData);
        } else {
            this.setSize(axis, isGantt);
        }
        this.zeroAxis = this.interpolatePixel2(axis.getAxisShift());
    }

    private void setSize(Axis axis, boolean isGantt) {
        this.stepsize = axis.stepScale;
        this.stepmonth = axis.stepScaleMonth;
        if (axis.columnField != null && axis.displayLabelAsDate && axis.columnField.axisType == 8) {
            this.stepsize = Math.rint(this.stepsize / 24.0 / 3600.0 / 1000.0) * 8.64E7;
            if (this.stepsize == 0.0 && this.stepmonth == 0) {
                this.stepsize = 8.64E7;
            }
        }
        double tstepsize = this.stepsize;
        if (this.stepmonth > 0) {
            tstepsize = this.stepsize + this.getMonthStepSize(this.stepmonth, axis.minScale, axis.maxScale);
        }
        this.maxvalue = axis.maxScale;
        this.minvalue = axis.minScale;
        double modVal = this.maxvalue - this.minvalue;
        if (this.stepsize > 0.0 && this.stepmonth == 0) {
            int numberOfUnit = (int)Math.floor(modVal / this.stepsize);
            modVal -= (double)numberOfUnit * this.stepsize;
            if ((modVal = Math.rint(modVal * 10000.0) / 10000.0) != 0.0) {
                this.maxvalue += this.stepsize - modVal;
            }
        }
        if (this.stepmonth > 0) {
            this.stepAbove = (int)Math.ceil((this.maxvalue - this.minvalue) / tstepsize);
            this.stepBelow = 0;
            this.zeroAxis = this.newMinPixel;
            this.maxvalue = (double)this.stepAbove * tstepsize + this.minvalue;
            this.totalstep = this.stepAbove;
            if (this.totalstep == 0) {
                this.totalstep = 1;
            }
        } else if (this.maxvalue >= 0.0) {
            if (this.minvalue >= 0.0) {
                double tmpS = Math.floor((this.maxvalue - this.minvalue) / tstepsize * 1000.0);
                this.stepAbove = (int)Math.ceil(tmpS / 1000.0);
                this.stepBelow = 0;
                this.zeroAxis = this.newMinPixel;
                double tmpMax = (double)this.stepAbove * tstepsize + this.minvalue;
                if (tmpMax - this.maxvalue > tstepsize) {
                    this.maxvalue = tmpMax;
                }
                if ((this.totalstep = this.stepAbove) == 0) {
                    this.totalstep = 1;
                }
            } else if (!axis.autoscale) {
                this.totalstep = (int)Math.ceil((this.maxvalue - this.minvalue) / tstepsize);
                double temp = this.minvalue;
                this.stepBelow = 0;
                while (temp <= 0.0) {
                    temp += tstepsize;
                    ++this.stepBelow;
                }
                if (this.totalstep == 0) {
                    this.totalstep = 1;
                }
                this.maxvalue = (double)this.totalstep * tstepsize + this.minvalue;
                if (temp == 0.0) {
                    this.zeroAxis = this.newMinPixel + this.width * this.stepBelow / this.totalstep;
                    this.stepAbove = this.totalstep - this.stepBelow;
                } else {
                    this.zeroAxis = (int)((double)this.newMinPixel + ((double)(this.stepBelow * this.width) - temp * (double)this.width / tstepsize) / (double)this.totalstep);
                    this.stepAbove = this.totalstep + 1 - this.stepBelow;
                }
            } else {
                this.stepAbove = (int)Math.ceil(this.maxvalue / tstepsize);
                this.stepBelow = (int)Math.ceil(-this.minvalue / tstepsize);
                this.totalstep = this.stepAbove + this.stepBelow;
                if (this.totalstep == 0) {
                    this.totalstep = 1;
                }
                this.zeroAxis = this.newMinPixel + this.width * this.stepBelow / this.totalstep;
                this.minvalue = (double)(-this.stepBelow) * tstepsize;
                this.maxvalue = (double)this.stepAbove * tstepsize;
            }
        } else {
            this.stepAbove = 0;
            this.stepBelow = (int)Math.ceil((this.maxvalue - this.minvalue) / tstepsize);
            this.zeroAxis = this.newMaxPixel;
            this.minvalue = (double)(-this.stepBelow) * tstepsize + this.maxvalue;
            this.totalstep = this.stepBelow;
            if (this.totalstep == 0) {
                this.totalstep = 1;
            }
        }
        this.dvalue = this.maxvalue - this.minvalue;
        axis.stepScale = this.stepsize;
        axis.stepScaleMonth = this.stepmonth;
        axis.maxScale = this.maxvalue;
        axis.setMinScale(this.minvalue);
        if (axis.autoOrigin && !axis.isSpecificScaleEnabled()) {
            this.calAutoOrigin(isGantt);
        }
        axis.getAxisShift();
        this.width_dvalue = this.dvalue != 0.0 ? (double)this.width / this.dvalue : 0.0;
    }

    public double getMonthStepSize(int stepmonth, double minScale, double maxScale) {
        if (minScale < 0.0 || maxScale < 0.0 || stepmonth <= 0) {
            return 3.15576E7 * Math.floor(stepmonth / 12) * 1000.0 + 2635200.0 * (double)(stepmonth % 12) * 1000.0;
        }
        Calendar min = Calendar.getInstance();
        min.setTimeInMillis((long)minScale);
        Calendar max = Calendar.getInstance();
        max.setTimeInMillis((long)maxScale);
        long totalStep = 0L;
        int stepCt = 0;
        Calendar tmp = Calendar.getInstance();
        tmp.setTimeInMillis((long)minScale);
        do {
            tmp.add(2, stepmonth);
            ++stepCt;
        } while (tmp.before(max));
        totalStep = tmp.getTimeInMillis() - min.getTimeInMillis();
        return (double)totalStep / (double)stepCt;
    }

    public StepSize(int minpixel, double minvalue, double width_dvalue) {
        this.newMinPixel = minpixel;
        this.minvalue = minvalue;
        this.width_dvalue = width_dvalue;
    }

    private void setSize(Axis axis, double max, double min, int row, int decimalpoint, boolean isGantt, boolean isPercent, boolean isIntData) {
        double mag;
        if (!isGantt && !isPercent && !axis.autoOrigin && axis.addAxisPadding) {
            if (max > 0.0) {
                max *= AXISPADDING;
            }
            if (min < 0.0) {
                min *= AXISPADDING;
            }
        }
        if (isGantt && axis.isSpecificScaleEnabled()) {
            this.stepsize = axis.stepScale;
            this.stepmonth = axis.stepScaleMonth;
        }
        if (!axis.autoOrigin) {
            if (axis.axisShift < min) {
                if (!isGantt) {
                    min = axis.axisShift;
                } else {
                    axis.axisShift = min;
                }
            }
            if (axis.axisShift > max) {
                max = axis.axisShift;
            }
        } else if (max > min) {
            double diff = 1.0;
            if (max - min < 1.0) {
                diff = (max - min) * 0.05;
            }
            if (min > 0.0) {
                if ((min -= diff) < 0.0) {
                    min = 0.0;
                }
            } else if (max < 0.0 && (max += diff) > 0.0) {
                max = 0.0;
            }
        }
        if (max == min) {
            if (min > 0.0) {
                min = 0.0;
            } else if (max < 0.0) {
                max = 0.0;
            }
        }
        boolean auto = true;
        if (isIntData) {
            axis.stepScale = 1.0;
        }
        if (max - min < 1.0 && !axis.autoScaleForValLessThan1) {
            max = 1.0;
            this.stepsize = 1.0;
        } else if (min != max) {
            double x = max - min;
            mag = 1.0;
            double realx = x;
            boolean isIntField = false;
            if (axis.columnField != null && axis.stepScale >= 1.0) {
                isIntField = DataType.isInt(axis.columnField.dataType);
            }
            if (isGantt) {
                if (axis.columnField != null && DataType.isDateTime(axis.columnField.dataType) && (this.isSpecificScaleEnabled() || axis.isDynamicAutoScale())) {
                    Calendar minDate = Calendar.getInstance();
                    minDate.setTimeInMillis((long)min);
                    Calendar maxDate = Calendar.getInstance();
                    maxDate.setTimeInMillis((long)max);
                    boolean sameDay = false;
                    int monthsDiff = (maxDate.get(1) - minDate.get(1)) * 12;
                    monthsDiff += maxDate.get(2) - minDate.get(2);
                    int dayDiff = maxDate.get(5) - minDate.get(5);
                    if (dayDiff < 0) {
                        --monthsDiff;
                    }
                    if (monthsDiff == 0 && dayDiff == 0) {
                        sameDay = true;
                    }
                    if (axis.isDynamicAutoScale()) {
                        if (monthsDiff >= 24) {
                            this.stepmonth = 12;
                            this.stepsize = 0.0;
                        } else if (monthsDiff > 1) {
                            this.stepmonth = 1;
                            this.stepsize = 0.0;
                        } else {
                            this.stepmonth = 0;
                            this.stepsize = 8.64E7;
                        }
                    }
                    if (this.stepmonth == 1) {
                        minDate.set(5, 1);
                        if (maxDate.get(5) < maxDate.getMaximum(5)) {
                            maxDate.set(5, maxDate.getMaximum(5));
                        }
                        this.stepsize = 0.0;
                        auto = false;
                    } else if (this.stepmonth == 12) {
                        minDate.set(5, 1);
                        minDate.set(2, 0);
                        if (maxDate.get(2) != 11 || maxDate.get(5) < 31) {
                            maxDate.set(5, 31);
                            maxDate.set(2, 11);
                        }
                        this.stepsize = 0.0;
                        auto = false;
                    } else if (this.stepsize > 0.0 && !sameDay) {
                        minDate.set(10, 0);
                        minDate.set(12, 0);
                        minDate.set(13, 0);
                        minDate.set(14, 0);
                        if (maxDate.get(10) != 23 || maxDate.get(12) != 59 || maxDate.get(13) != 59 || maxDate.get(14) != 999) {
                            maxDate.set(10, 23);
                            maxDate.set(12, 59);
                            maxDate.set(13, 59);
                            maxDate.set(14, 999);
                        }
                        this.stepmonth = 0;
                        auto = false;
                    }
                    min = minDate.getTimeInMillis();
                    max = maxDate.getTimeInMillis();
                }
                if (auto) {
                    int start = row >= 3 ? 3 : row;
                    long step = 0L;
                    double mindiff = Double.MAX_VALUE;
                    for (int i = row; i >= start; --i) {
                        double d;
                        step = (int)Math.ceil(x / (double)i);
                        double realsize = (double)step * mag;
                        double diff = (double)((int)Math.ceil(realx / realsize)) * realsize - realx;
                        if (!(d < mindiff)) continue;
                        mindiff = diff;
                        this.stepsize = realsize;
                    }
                }
            } else {
                if (!axis.useIntValueForAutoScale && x < 10.0 && !isIntField) {
                    if (x != 0.0) {
                        while (x < 10.0) {
                            x *= 10.0;
                            mag /= 10.0;
                        }
                    }
                } else {
                    while (x > 100.0) {
                        x /= 10.0;
                        mag *= 10.0;
                    }
                }
                if (row == 0) {
                    row = 1;
                }
                int start = row >= 3 ? 3 : row;
                int step = 0;
                double mindiff = Double.MAX_VALUE;
                for (int i = start; i <= row; ++i) {
                    double d;
                    step = (int)Math.ceil(x / (double)i);
                    if (step == 7 || step == 9 || step == 11) {
                        ++step;
                    } else if (step > 12 && step % 5 != 0) {
                        step += 5 - step % 5;
                    }
                    double realsize = (double)step * mag;
                    double diff = (double)((int)Math.ceil(realx / realsize)) * realsize - realx;
                    if (!(d < mindiff)) continue;
                    mindiff = diff;
                    this.stepsize = realsize;
                }
            }
            if (this.stepsize == 0.0 && this.stepmonth == 0) {
                this.stepsize = 1.0;
            }
        } else {
            max = 1.0;
            this.stepsize = 1.0;
        }
        mag = 1.0;
        for (int i = 0; i < decimalpoint; ++i) {
            mag /= 10.0;
        }
        if (this.stepsize < mag && this.stepmonth == 0) {
            this.stepsize = mag;
        }
        axis.stepScale = this.stepsize;
        axis.stepScaleMonth = this.stepmonth;
        if (isGantt) {
            if (!axis.isSpecificScaleEnabled() || auto) {
                double var = 0.0;
                var = 0.02 * (max - min);
                axis.maxScale = max;
                if (min - var < 0.0) {
                    axis.setMinScale(0.0);
                } else {
                    axis.setMinScale(min - var);
                }
            } else {
                axis.maxScale = max;
                axis.setMinScale(min);
            }
        } else {
            axis.maxScale = (double)((int)Math.ceil(max / this.stepsize)) * this.stepsize;
            axis.setMinScale((double)((int)Math.floor(min / this.stepsize)) * this.stepsize);
        }
        this.minvalue = axis.minScale;
        this.maxvalue = axis.maxScale;
        if (isGantt) {
            axis.axisShift = this.minvalue;
        }
        if (axis.autoOrigin && !axis.isSpecificScaleEnabled()) {
            this.calAutoOrigin(isGantt);
        }
        axis.getAxisShift();
        this.setSize(axis, isGantt);
    }

    public boolean isSpecificScaleEnabled() {
        return this.stepmonth == 1 || this.stepmonth == 12 || this.stepsize == 8.64E7;
    }

    private void calAutoOrigin(boolean isGantt) {
        if (this.axis.minScale <= 0.0 && this.axis.maxScale > 0.0) {
            this.axis.axisShift = 0.0;
        } else if (this.axis.maxScale < 0.0) {
            this.axis.axisShift = this.axis.maxScale;
        } else if (this.axis.minScale > 0.0) {
            this.axis.axisShift = this.axis.minScale;
        }
    }

    public final int interpolatePixel(double val) {
        return (int)((double)this.newMinPixel + this.width_dvalue * ((this.axis.logScale ? this.axis.log(val) : val) - this.minvalue));
    }

    public final int interpolatePixel2(double val) {
        return (int)((double)this.newMinPixel + this.width_dvalue * (val - this.minvalue));
    }
}

