/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import quadbase.chart.Chart;
import quadbase.chart.DrillHistory;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryMultiValueInParam;
import quadbase.util.LocaleDateTimeFormat;
import quadbase.util.internal.IOUtil;

public class ValueTable {
    static final String PREFIX = "&";
    Chart chart;
    DrillHistory drillHistory;
    QueryFileInfo queryFileInfo;
    Hashtable<String, String> uniqueKey;
    Vector<String> key;

    public ValueTable(Chart chart) {
        this.chart = chart;
        this.uniqueKey = null;
        this.addBasicKeys();
    }

    public ValueTable(Chart chart, ValueTable target) {
        this.chart = chart;
        this.drillHistory = target.drillHistory;
        this.queryFileInfo = target.queryFileInfo;
        this.key = target.key != null ? (Vector)target.key.clone() : null;
        this.uniqueKey = target.uniqueKey != null ? (Hashtable)target.uniqueKey.clone() : null;
    }

    private void addBasicKeys() {
        this.addKey("date");
        this.addKey("time");
        this.addKey("category");
        this.addKey("series");
        this.addKey("sumby");
        this.addKey("value");
        this.addKey("subvalue");
        this.addKey("xaxis");
        this.addKey("yaxis");
        this.addKey("zaxis");
        this.addKey("2ndaxis");
    }

    private void addKey(String newKey) {
        if (this.key == null) {
            this.key = new Vector();
        }
        this.key.removeElement(newKey);
        this.key.addElement(newKey);
    }

    private void removeKey(String oldKey) {
        if (this.key == null) {
            return;
        }
        this.key.removeElement(oldKey);
    }

    public String[] getAllVariables() {
        if (this.key == null) {
            return null;
        }
        int nKey = this.key.size();
        if (nKey == 0) {
            return null;
        }
        String[] result = new String[nKey];
        for (int i = 0; i < nKey; ++i) {
            result[i] = this.key.elementAt(i);
        }
        return result;
    }

    public void setDrillHistory(DrillHistory drillHistory) {
        this.removeKey("drillInfo");
        if (drillHistory != null) {
            this.addKey("drillInfo");
            this.drillHistory = drillHistory;
        }
    }

    public void setQueryFileInfo(QueryFileInfo queryFileInfo) {
        this.removeKey("paramInfo");
        if (queryFileInfo != null) {
            this.addKey("paramInfo");
            QueryInParam[] param = queryFileInfo.getInSet().getParameter();
            int nParam = param.length;
            for (int i = 0; i < nParam; ++i) {
                this.addKey(param[i].getParamName().trim());
                this.addKey("paramInfoName" + i);
                this.addKey("paramInfoValue" + i);
            }
            this.queryFileInfo = queryFileInfo;
        }
    }

    private String findValue(String target) {
        if (target == null || this.key == null) {
            return null;
        }
        String endTarget = "";
        if ((target.endsWith(",") || target.endsWith(":") || target.endsWith(".") || target.endsWith("-") || target.endsWith("!") || target.endsWith("?")) && target.length() > 1) {
            endTarget = target.substring(target.length() - 1);
            target = target.substring(0, target.length() - 1);
        }
        boolean find = false;
        int nKey = this.key.size();
        for (int i = 0; i < nKey; ++i) {
            if (!target.equalsIgnoreCase(this.key.elementAt(i))) continue;
            find = true;
            break;
        }
        if (!find) {
            return null;
        }
        if (target.equalsIgnoreCase("drillInfo")) {
            return this.getDrillInfoString() + endTarget;
        }
        if (target.equalsIgnoreCase("paramInfo")) {
            return this.getParamInfoString() + endTarget;
        }
        if (target.startsWith("paramInfoName")) {
            return this.getParamInfoName(Integer.valueOf(target.substring(13))) + endTarget;
        }
        if (target.startsWith("paramInfoValue")) {
            return this.getParamInfoValue(Integer.valueOf(target.substring(14))) + endTarget;
        }
        if (target.equalsIgnoreCase("date")) {
            return this.getDate() + endTarget;
        }
        if (target.equalsIgnoreCase("time")) {
            return this.getTime() + endTarget;
        }
        if (target.equalsIgnoreCase("category")) {
            return this.getCategory() + endTarget;
        }
        if (target.equalsIgnoreCase("series")) {
            return this.getSeries() + endTarget;
        }
        if (target.equalsIgnoreCase("sumby")) {
            return this.getSumBy() + endTarget;
        }
        if (target.equalsIgnoreCase("value")) {
            return this.getValue() + endTarget;
        }
        if (target.equalsIgnoreCase("subvalue")) {
            return this.getSubValue() + endTarget;
        }
        if (target.equalsIgnoreCase("xaxis")) {
            return this.getXAxis() + endTarget;
        }
        if (target.equalsIgnoreCase("yaxis")) {
            return this.getYAxis() + endTarget;
        }
        if (target.equalsIgnoreCase("zaxis")) {
            return this.getZAxis() + endTarget;
        }
        if (target.equalsIgnoreCase("2ndaxis")) {
            return this.get2ndAxis() + endTarget;
        }
        String paramInfoValue = this.getParamInfoValue(target);
        if (paramInfoValue != null) {
            return paramInfoValue + endTarget;
        }
        return null;
    }

    private String getDrillInfoString() {
        if (this.drillHistory == null) {
            return "None";
        }
        Vector drillVector = this.drillHistory.drillVector;
        int nDrillLevel = drillVector.size();
        if (nDrillLevel == 0) {
            return "None";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < nDrillLevel; ++i) {
            this.drillHelper(sb, i);
        }
        String result = sb.toString();
        if (result.endsWith(", ")) {
            return result.substring(0, result.length() - 2);
        }
        return result;
    }

    private void drillHelper(StringBuffer sb, int level) {
        Object value = null;
        String columnName = null;
        value = this.drillHistory.getCategoryValue(level);
        if (value != null && (columnName = this.drillHistory.getCategoryColumnName(level)) != null) {
            sb.append(columnName.trim());
            sb.append(" = ");
            sb.append(value.toString().trim());
            sb.append(", ");
        }
        if ((value = this.drillHistory.getSeriesValue(level)) != null && (columnName = this.drillHistory.getSeriesColumnName(level)) != null) {
            sb.append(columnName.trim());
            sb.append(" = ");
            sb.append(value.toString().trim());
            sb.append(", ");
        }
        if ((value = this.drillHistory.getSumByValue(level)) != null && (columnName = this.drillHistory.getSumByColumnName(level)) != null) {
            sb.append(columnName.trim());
            sb.append(" = ");
            sb.append(value.toString().trim());
            sb.append(", ");
        }
    }

    private String getParamInfoString() {
        if (this.queryFileInfo == null) {
            return "None";
        }
        QueryInParam[] param = this.queryFileInfo.getInSet().getParameter();
        int nParam = param.length;
        StringBuffer sb = new StringBuffer();
        this.paramHelper(sb, param[0]);
        for (int i = 1; i < nParam; ++i) {
            this.paramHelper(sb, param[i]);
        }
        String result = sb.toString();
        if (result.endsWith(", ")) {
            return result.substring(0, result.length() - 2);
        }
        return result;
    }

    private void paramHelper(StringBuffer sb, QueryInParam param) {
        sb.append(param.getParamName().trim());
        sb.append(" = ");
        if (param.getValue() != null) {
            sb.append(this.getValue(param));
        } else {
            sb.append("NULL");
        }
        sb.append(", ");
    }

    private String getParamInfoName(int idx) {
        if (this.queryFileInfo == null) {
            return "None";
        }
        QueryInParam[] param = this.queryFileInfo.getInSet().getParameter();
        if (idx >= param.length) {
            return "None";
        }
        return param[idx].getParamName().trim();
    }

    private String getParamInfoValue(int idx) {
        if (this.queryFileInfo == null) {
            return "None";
        }
        QueryInParam[] param = this.queryFileInfo.getInSet().getParameter();
        if (idx >= param.length) {
            return "None";
        }
        if (param[idx].getValue() != null) {
            return this.getValue(param[idx]);
        }
        return "NULL";
    }

    private String getParamInfoValue(String pName) {
        QueryInParam[] param;
        if (this.queryFileInfo == null) {
            return pName;
        }
        for (QueryInParam element : param = this.queryFileInfo.getInSet().getParameter()) {
            if (!element.getParamName().trim().equalsIgnoreCase(pName)) continue;
            if (element.getValue() == null) {
                return pName;
            }
            return this.getValue(element);
        }
        return pName;
    }

    private String getValue(QueryInParam param) {
        if (param instanceof QueryMultiValueInParam) {
            Vector<Object> vec = ((QueryMultiValueInParam)param).getValues();
            if (vec == null || vec.size() <= 0) {
                return "NULL";
            }
            String res = vec.elementAt(0).toString().trim();
            for (int i = 1; i < vec.size(); ++i) {
                res = res + ", " + vec.elementAt(i).toString().trim();
            }
            return res;
        }
        return param.getValue().toString().trim();
    }

    private String getDate() {
        LocaleDateTimeFormat format = this.chart.getLocale() == null ? LocaleDateTimeFormat.getDateInstance() : LocaleDateTimeFormat.getDateInstance(this.chart.getLocale());
        if (this.chart.getTimeZone() != null) {
            format.setTimeZone(this.chart.getTimeZone());
        }
        return format.format(new Date());
    }

    private String getTime() {
        LocaleDateTimeFormat format = this.chart.getLocale() == null ? LocaleDateTimeFormat.getTimeInstance() : LocaleDateTimeFormat.getTimeInstance(this.chart.getLocale());
        if (this.chart.getTimeZone() != null) {
            format.setTimeZone(this.chart.getTimeZone());
        }
        return format.format(new Date());
    }

    private String getCategory() {
        return this.chart.colData[this.chart.getCategoryIndex()].getName();
    }

    private String getSeries() {
        int series = this.chart.getSeriesIndex();
        if (series >= 0) {
            return this.chart.colData[series].getName();
        }
        return "None";
    }

    private String getSumBy() {
        int sumBy = this.chart.getSumByIndex();
        if (sumBy >= 0) {
            return this.chart.colData[sumBy].getName();
        }
        return "None";
    }

    private String getValue() {
        return this.chart.colData[this.chart.getPrimaryIndex()].getName();
    }

    private String getSubValue() {
        int subValue = this.chart.getSecondaryIndex();
        if (subValue >= 0) {
            return this.chart.colData[subValue].getName();
        }
        return "None";
    }

    private String getXAxis() {
        if (this.chart.isCircularChart() || this.chart.chartType == 17) {
            return "None";
        }
        return this.chart.axis[0].columnField.getName();
    }

    private String getYAxis() {
        if (this.chart.isCircularChart()) {
            return "None";
        }
        return this.chart.axis[1].columnField.getName();
    }

    private String getZAxis() {
        if (!this.chart.is2DimChart() && Chart.isCoordinateType(this.chart.getChartType())) {
            return this.chart.axis[2].columnField.getName();
        }
        if (this.chart.isCircularChart() || this.chart.chartType == 17) {
            return "None";
        }
        if (this.chart.is2DChart) {
            return "None";
        }
        return this.getSeries();
    }

    private String get2ndAxis() {
        return this.getSubValue();
    }

    public String findUniqueKeyValue(String inString) {
        if (this.uniqueKey == null) {
            return inString;
        }
        String value = this.uniqueKey.get(inString);
        if (value == null) {
            return inString;
        }
        return value;
    }

    public void addUniqueKeyValue(String key, String value) {
        if (this.uniqueKey == null) {
            this.uniqueKey = new Hashtable();
        } else {
            this.uniqueKey.remove(key);
        }
        if (!key.equals(value)) {
            this.uniqueKey.put(key, value);
        }
    }

    public int countUniqueKeys() {
        if (this.uniqueKey == null) {
            return 0;
        }
        return this.uniqueKey.size();
    }

    public Enumeration<String> getUniqueKeyList() {
        if (this.uniqueKey == null) {
            return null;
        }
        return this.uniqueKey.keys();
    }

    public Enumeration<String> getUniqueElementList() {
        if (this.uniqueKey == null) {
            return null;
        }
        return this.uniqueKey.elements();
    }

    void write(DataOutput out) throws IOException {
        if (this.uniqueKey != null) {
            out.writeInt(this.uniqueKey.size());
            Enumeration<String> key = this.uniqueKey.keys();
            Enumeration<String> value = this.uniqueKey.elements();
            while (key.hasMoreElements()) {
                IOUtil.writeString(out, key.nextElement());
                IOUtil.writeString(out, value.nextElement());
            }
        } else {
            out.writeInt(0);
        }
    }

    void read(DataInput din, int version) throws IOException {
        if (version < 106) {
            return;
        }
        int size = din.readInt();
        if (size == 0) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            String key = IOUtil.readString(din, true);
            String value = IOUtil.readString(din, true);
            this.addUniqueKeyValue(key, value);
        }
    }

    private String getRunTimeUniqueKeyValue(String inString) {
        if (this.uniqueKey == null) {
            return inString;
        }
        Enumeration<String> key = this.uniqueKey.keys();
        Enumeration<String> value = this.uniqueKey.elements();
        while (key.hasMoreElements()) {
            inString = ValueTable.replace(inString, key.nextElement(), value.nextElement());
        }
        return inString;
    }

    private static String replace(String str, String oldChars, String newChars) {
        int i = str.indexOf(oldChars);
        int oldCharLen = oldChars.length();
        while (i >= 0) {
            if (i > 0 && str.charAt(i - 1) != '\t' && str.charAt(i - 1) != '\n' && str.charAt(i - 1) != '\r' && str.charAt(i - 1) != '\f' && str.charAt(i - 1) != ' ') {
                i = str.indexOf(oldChars, i + oldCharLen);
                continue;
            }
            if (i + oldCharLen < str.length() && str.charAt(i + oldCharLen) != '\t' && str.charAt(i + oldCharLen) != '\n' && str.charAt(i + oldCharLen) != '\r' && str.charAt(i + oldCharLen) != '\f' && str.charAt(i + oldCharLen) != ' ') {
                i = str.indexOf(oldChars, i + oldCharLen);
                continue;
            }
            String str1 = "";
            String str2 = "";
            if (i != 0) {
                str1 = str.substring(0, i);
            }
            if (i + oldCharLen < str.length()) {
                str2 = str.substring(i + oldCharLen);
            }
            str = str1 + newChars + str2;
            if (i + newChars.length() >= str.length()) break;
            i = str.indexOf(oldChars, i + newChars.length());
        }
        return str;
    }

    public String getRunTimeValue(String inString) {
        if (inString.startsWith("Evaluation copy by Quadbase Systems Inc.")) {
            return inString;
        }
        if (inString.indexOf(PREFIX) < 0) {
            return this.getRunTimeUniqueKeyValue(inString);
        }
        int currentIndex = 0;
        String delimiter = " \t\n\r";
        String inStringCopy = inString;
        while ((currentIndex = inStringCopy.indexOf(PREFIX, currentIndex)) >= 0) {
            String subString;
            StringTokenizer st;
            int length = inStringCopy.length();
            if (currentIndex < length - 1 && (st = new StringTokenizer(subString = inStringCopy.substring(currentIndex + 1, length), delimiter)).hasMoreTokens()) {
                String value;
                String token = st.nextToken();
                int idx = -1;
                idx = token.indexOf(PREFIX);
                if (idx > 0) {
                    token = token.substring(0, idx);
                }
                if ((value = this.findValue(token)) != null) {
                    inStringCopy = inStringCopy.substring(0, currentIndex) + value + inStringCopy.substring(currentIndex + 1 + token.length(), length);
                }
            }
            ++currentIndex;
        }
        return this.getRunTimeUniqueKeyValue(inStringCopy);
    }
}

