/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.chart.Chart;
import quadbase.chart.IOUtil2;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.util.internal.FileInMemTable;
import quadbase.common.util.internal.QbUtil;
import quadbase.util.internal.IOUtil;

public class WriteDataFile {
    private static final Logger LOGGER = Logger.getLogger(WriteDataFile.class.getName());
    int viewerType = 0;
    boolean createHtml = false;
    boolean useSwing = false;
    boolean useXML = false;

    public void output(byte[] barray, String filename) throws Exception {
        this.output(null, barray, filename);
    }

    public void output(Chart chart, byte[] barray, String filename) throws Exception {
        this.output(chart, barray, filename, false);
    }

    public void output(Chart chart, byte[] barray, String filename, boolean isReportPakFile) throws Exception {
        filename.replace('\\', '/');
        FileInMemTable subFilesTable = null;
        if (chart != null) {
            subFilesTable = chart.getSubFilesTable();
        }
        if (subFilesTable != null) {
            Chart.replaceSubFile(subFilesTable, barray, filename, isReportPakFile);
        }
        if (isReportPakFile) {
            return;
        }
        if (ServerMessage.useServer || !ServerMessage.isLoadBalancer) {
            if (filename.startsWith("http://") || filename.startsWith("https://")) {
                this.sendToServer(barray, filename, false);
            } else {
                this.sendToServer(barray, filename, (filename = filename.replace('\\', '/')).startsWith("/") || filename.indexOf(":/") >= 0);
            }
            return;
        }
        if (filename.startsWith("http://") || filename.startsWith("https://")) {
            throw new IOException("Cannot write to HTTP URL :" + filename);
        }
        QbUtil.checkExtensionsBlacklist(filename);
        File outFile = new File(filename);
        if (outFile.getParent() != null) {
            outFile.getParentFile().mkdirs();
        } else {
            filename = System.getProperty("user.dir") + "/" + filename;
        }
        FileOutputStream fstream = IOUtil.createFileOutputStream(filename);
        DataOutputStream out = new DataOutputStream(fstream);
        out.write(barray, 0, barray.length);
        out.flush();
        out.close();
        fstream.flush();
        fstream.close();
    }

    void generateHtmlFile(boolean createHtml, int viewerType, boolean useSwing, boolean useXML) {
        this.createHtml = createHtml;
        this.viewerType = viewerType;
        this.useSwing = useSwing;
        this.useXML = useXML;
    }

    private void sendToServer(byte[] barray, String filename, boolean absolutePath) throws Exception {
        if (!absolutePath) {
            filename = IOUtil.extractHostPath(filename, ServerMessage.getApplet());
        }
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeShort(22071);
        dout.writeBoolean(false);
        dout.writeInt(barray.length);
        IOUtil.writeString(dout, filename);
        dout.writeBoolean(absolutePath);
        dout.writeBoolean(this.createHtml);
        dout.writeShort(this.viewerType);
        dout.writeBoolean(this.useSwing);
        dout.writeBoolean(this.useXML);
        IConnection socket = null;
        try {
            try {
                socket = ServerMessage.createConnection();
                byte[] array = bstream.toByteArray();
                socket.setContentLength(array.length + barray.length);
                socket.getOutputStream().write(array);
                socket.getOutputStream().write(barray);
                socket.getOutputStream().flush();
            }
            catch (Exception ex) {
                if (socket != null) {
                    socket.close();
                }
                LOGGER.log(Level.FINE, "Failed to write data to server", ex);
                throw new IOException("Failed to connect to server !");
            }
            DataInputStream din = new DataInputStream(socket.getInputStream());
            String errMessage = IOUtil2.getErrorString(din.readInt());
            String reason = IOUtil.readString(din, true);
            socket.close();
            if (errMessage != null) {
                throw new IOException(errMessage + "\n" + reason);
            }
        }
        catch (Exception ex) {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINEST, "Can't close socket", ex2);
            }
            LOGGER.log(Level.FINEST, "Failed to write data to server", ex);
            throw ex;
        }
    }
}

