/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart2d;

import java.awt.Color;
import java.awt.Point;
import quadbase.chart.Axis;
import quadbase.chart.CGraphics;
import quadbase.chart.CString;
import quadbase.chart.ColData;
import quadbase.chart.Point3D;
import quadbase.chart.StepSize;
import quadbase.chart.chart2d.Grid2D;
import quadbase.chart.chart2d.Ticker2D;

public class Axis2D
extends Axis {
    public boolean doSwap;

    public Axis2D(int direction, CString name, boolean showgrid) {
        super(direction, name);
        this.grid = new Grid2D(direction, showgrid);
        this.ticker = new Ticker2D(this);
    }

    public Axis2D(Axis2D ax) {
        super(ax);
        this.doSwap = ax.doSwap;
    }

    @Override
    public Object getFaceList() {
        return null;
    }

    @Override
    public Object getFaceList(int i) {
        return null;
    }

    @Override
    public void setWallColor(Object space, Color color) {
    }

    @Override
    public void setTicker(Object sp, Object[] name, Point3D[] p, boolean reverseSide, ColData colField) {
    }

    @Override
    public void setTicker(Object sp, int xmax, int wall_zlength) {
    }

    @Override
    public void setVertex(Object sv, Object ev) {
    }

    @Override
    public void setAxisGridY(Object sp, StepSize sz, int xmax, int ymax, int zmax, ColData colField) {
    }

    @Override
    public void setAxisGridY(Object sp, StepSize sz, int xmax, int ymax, int zmax, ColData colField, int px, int pz) {
    }

    @Override
    public void setAxisGridX(Object sp, StepSize sz, int xmax, int ymax, int zmax, ColData colField) {
    }

    @Override
    public void setAxisGridX(Object sp, StepSize sz, int xmax, int ymax, int zmax, ColData colField, int py, int pz) {
    }

    @Override
    public void setAxisGridZ(Object sp, StepSize sz, int xmax, int ymax, int zmax, ColData colField) {
    }

    @Override
    public void setXWall(Object sp, int xlength, int ylength, int zlength, Color color) {
    }

    @Override
    public void setYWall(Object sp, int xlength, int ylength, int zlength, Color color) {
    }

    @Override
    public void setSWall(Object sp, int xlength, int ylength, int zlength, Color color) {
    }

    @Override
    public void setZWall(Object sp, int xlength, int ylength, int zlength, Color color) {
    }

    @Override
    public void setFaceState() {
    }

    @Override
    public void drawTicker(CGraphics g) {
        if (this.ticker.label != null && this.showTitleTicker) {
            this.ticker.draw(g);
        } else if (!this.is3D) {
            this.ticker.minp = new Point(this.xorigin, this.yorigin);
        }
    }

    @Override
    public void drawAxis(CGraphics g) {
        int thick = Math.abs(this.thickness);
        if (this.bshow) {
            g.setColor(this.color);
            if (!this.is3D) {
                int thick2 = thick / 2;
                if (this.orient == 0) {
                    if (this.thickness < 0) {
                        g.fillArea(this.startp.x, this.startp.y - thick2, this.endp.x, this.startp.y + thick2, 1);
                    } else if (this.arrowType == 2) {
                        this.drawAxisPart(g, this.startp, this.endp, true);
                        this.drawAxisPart(g, this.endp, this.startp, true);
                    } else if (this.arrowType == 0) {
                        this.drawAxisPart(g, this.startp, this.endp, false);
                    } else {
                        this.drawAxisPart(g, this.endp, this.startp, false);
                    }
                } else if (this.thickness < 0) {
                    g.fillArea(this.startp.x, this.startp.y - thick2, this.endp.x, this.startp.y + thick2, 1);
                    g.fillArea(this.endp.x - thick2, this.endp.y, this.endp.x + thick2, this.startp.y, 1);
                } else if (this.arrowType == 2) {
                    this.drawAxisPart(g, this.startp, this.endp, true);
                    this.drawAxisPart(g, this.endp, this.startp, true);
                } else if (this.arrowType == 0 && !this.xAtTop) {
                    this.drawAxisPart(g, this.startp, this.endp, false);
                } else {
                    this.drawAxisPart(g, this.endp, this.startp, false);
                }
            }
        }
        this.drawTicker(g);
        this.drawAxisTitle(g);
    }

    @Override
    public void drawAxisTitle(CGraphics g) {
        if (!this.title.bshow) {
            return;
        }
        if (!this.is3D) {
            if (this.orient == 0) {
                if (this.title.automatic) {
                    this.title.setDirection(0);
                }
                if (this.doSwap) {
                    this.title.setPlacement(1);
                    this.title.setpos(new Point3D((this.startp.x + this.endp.x) / 2 + this.titlevoffset, this.ticker.maxp.y - this.titleoffset, 0));
                } else {
                    int fontH;
                    int yPos = Math.min(this.ticker.minp.y, this.yorigin) - this.titleoffset;
                    if (yPos < (fontH = this.title.getFontWidthHeight(g))) {
                        yPos = fontH;
                    }
                    this.title.setPlacement(3);
                    this.title.setpos(new Point3D((this.startp.x + this.endp.x) / 2 + this.titlevoffset, yPos));
                }
            } else if (this.orient == 3) {
                if (this.startp.x != this.endp.x) {
                    if (this.title.automatic) {
                        this.title.setAngle(0);
                    }
                    if (this.doSwap) {
                        this.title.setpos(new Point3D((this.startp.x + this.endp.x) / 2 + this.titleoffset, this.ticker.minp.y + this.titlevoffset, 0));
                        this.title.setPlacement(3);
                    } else {
                        this.title.setpos(new Point3D((this.startp.x + this.endp.x) / 2 + this.titleoffset, this.ticker.maxp.y + this.titlevoffset, 0));
                        this.title.setPlacement(1);
                    }
                } else {
                    if (this.title.automatic) {
                        this.title.setAngle(90);
                    }
                    this.title.setPlacement(4);
                    if (this.doSwap) {
                        this.title.setpos(new Point3D(this.ticker.minp.x + this.titleoffset, (this.startp.y + this.endp.y) / 2 + this.titlevoffset, 0));
                    } else {
                        this.title.setpos(new Point3D(this.ticker.maxp.x + this.titleoffset + 10, (this.startp.y + this.endp.y) / 2 + this.titlevoffset, 0));
                    }
                }
            } else {
                if (this.title.automatic) {
                    this.title.setAngle(90);
                }
                this.title.setPlacement(4);
                if (this.doSwap) {
                    this.title.setpos(new Point3D(this.ticker.maxp.x - this.titleoffset + 10, (this.startp.y + this.endp.y) / 2 + this.titlevoffset, 0));
                } else {
                    this.title.setpos(new Point3D((this.ticker.minp.x <= 0 ? this.xorigin : Math.min(this.ticker.minp.x, this.xorigin)) - this.titleoffset, (this.startp.y + this.endp.y) / 2 + this.titlevoffset, 0));
                }
            }
        }
        this.title.draw(g);
    }

    @Override
    public void drawFrameWall(CGraphics g) {
    }
}

