/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.util.Vector;
import quadbase.chart.Area;
import quadbase.chart.Axis;
import quadbase.chart.CGraphics;
import quadbase.chart.CString;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.ControlLine;
import quadbase.chart.DataLine;
import quadbase.chart.DataLineSet;
import quadbase.chart.ExportChart;
import quadbase.chart.HorzVertLine;
import quadbase.chart.Line;
import quadbase.chart.MultiDimData;
import quadbase.chart.StackChart;
import quadbase.chart.chart2d.Area2D;
import quadbase.chart.chart2d.Axis2D;
import quadbase.chart.chart2d.DataLineSet2D;
import quadbase.chart.chart2d.ExportChart2D;
import quadbase.chart.chart2d.Grid2D;
import quadbase.chart.chart2d.HorzVertLine2D;
import quadbase.chart.chart2d.MultiDimData2D;
import quadbase.chart.chart2d.Overlay2D;
import quadbase.chart.chart2d.Ticker2D;
import quadbase.common.util.internal.IFlashGraphics;
import quadbase.util.ControlRange;
import quadbase.util.Point_2D;
import quadbase.util.Point_3D;
import quadbase.util.PolyLine;
import quadbase.util.internal.Composite;
import quadbase.util.internal.IOUtil;
import quadbase.util.internal.RenderingChart;

public abstract class Chart2D
extends Chart {
    protected boolean isSwapAxis;
    public HorzVertLine2D horzVertLine2D = new HorzVertLine2D(this);
    public static final int CONTRANGE_ALL = 0;
    public static final int CONTRANGE_DRAW_HIGHLIGHT = 1;
    public static final int CONTRANGE_DRAW_OVER_CANVAS = 2;
    public static final int CONTRANGE_SKIP_HIGHLIGHT = 0;

    public Chart2D(int _chartType, Chart _chart) {
        super(_chartType, true, _chart);
    }

    public Chart2D(Component component, int _chartType, ColData[] _colData) {
        super(component, _chartType, true, _colData);
    }

    public Chart2D(Component component, int _chartType, ColData[] _colData, boolean[] usedColumnsList) {
        super(component, _chartType, true, _colData, usedColumnsList);
    }

    @Override
    public void computeCoord(CGraphics g, int xmin, int xmax, int ymin, int ymax) {
        this.horzVertLine2D.setRangeColor(this);
    }

    @Override
    public Image exportImageObject(int w, int h) {
        ExportChart2D exportchart = new ExportChart2D(this);
        return exportchart.createChartImage(w, h, this.component, false, false);
    }

    @Override
    public ExportChart createExportChart() {
        return new ExportChart2D(this);
    }

    @Override
    public float getlookfrom_x() {
        return -1.0f;
    }

    @Override
    public float getlookto_x() {
        return -1.0f;
    }

    @Override
    public float getlightpos_x() {
        return -1.0f;
    }

    @Override
    public float getlookfrom_y() {
        return -1.0f;
    }

    @Override
    public float getlookto_y() {
        return -1.0f;
    }

    @Override
    public float getlightpos_y() {
        return -1.0f;
    }

    @Override
    public float getlookfrom_z() {
        return -1.0f;
    }

    @Override
    public float getlookto_z() {
        return -1.0f;
    }

    @Override
    public float getlightpos_z() {
        return -1.0f;
    }

    @Override
    public void setlookfrom_x(float x) {
    }

    @Override
    public void setlookfrom_y(float y) {
    }

    @Override
    public void setlookfrom_z(float z) {
    }

    @Override
    public Object getSpace() {
        return null;
    }

    @Override
    public Object gethiddenSurface() {
        return null;
    }

    @Override
    public Area newArea() {
        Area2D newAr = new Area2D();
        return newAr;
    }

    @Override
    public Area newArea(Color c) {
        Area2D newAr = new Area2D(c);
        return newAr;
    }

    @Override
    public Area copyArea(Area ar) {
        Area2D newArea = new Area2D();
        Area newAr = ar.copyArea(newArea);
        return newAr;
    }

    @Override
    public Axis copyAxis(Axis ax) {
        Axis2D newAxis = new Axis2D(ax.orient, ax.title.copy(), ax.bshow);
        Grid2D newGrid = new Grid2D(ax.grid.orient, ax.grid.bshow);
        Ticker2D newTicker = new Ticker2D(newAxis);
        Axis newAx = ax.copy(newAxis, newGrid, newTicker);
        return newAx;
    }

    @Override
    protected DataLineSet newDataLineSet() {
        return new DataLineSet2D(this);
    }

    @Override
    protected DataLineSet newDataLineSet(DataLineSet oldSet) {
        return new DataLineSet2D(this, oldSet);
    }

    @Override
    public void copyChartAttributes3D(Chart _chart) {
    }

    @Override
    public void prepareLabel(boolean bcreate) {
        if (bcreate) {
            this.topLabels.removeAllElements();
        } else {
            this.toplabel_count = 0;
        }
        if (bcreate) {
            this.topLabels2.removeAllElements();
        } else {
            this.toplabel2_count = 0;
        }
        if (this.isShowDoubleValueForLine()) {
            this.mData.prepare_label(bcreate, this.mData2);
            return;
        }
        if (this.is2DChart) {
            if (this.chartType == 11 || !this.isStackType()) {
                this.mData.prepare_label(bcreate);
            } else {
                this.mData.prepare_stacklabel(bcreate);
            }
            if (this.showLegend2()) {
                this.mData2.chart.toplabel2_count = this.toplabel2_count;
                this.mData2.chart.toplabel2_offset_up = this.toplabel2_offset_up;
                this.mData2.chart.toplabel2_offset_side = this.toplabel2_offset_side;
                this.mData2.chart.topvalueLabel2_color = this.topvalueLabel2_color;
                this.mData2.chart.topvalueLabel2_font = this.topvalueLabel2_font;
                this.mData2.chart.topvalueLabel2_angle = this.topvalueLabel2_angle;
                if (!this.isOverlayCombo()) {
                    this.mData2.chart.setSecondaryDataLabelInfo(this.getSecondaryDataLabelInfo());
                } else {
                    this.mData2.chart.setPrimaryDataLabelInfo(this.getSecondaryDataLabelInfo());
                }
                this.mData2.prepare_secondary_label(bcreate);
            }
        }
    }

    @Override
    public MultiDimData setMultiDimData(int lv, Chart _chart, MultiDimData p) {
        MultiDimData2D newMDD = new MultiDimData2D(lv, _chart, p);
        return newMDD;
    }

    @Override
    public Axis setAxis(int direction, CString name, boolean showgrid) {
        Axis2D newAxis = new Axis2D(direction, name, showgrid);
        return newAxis;
    }

    @Override
    public void reCreateTable() {
        this.makeTable(this.mData, this.mData2);
        this.remakeTable = false;
    }

    @Override
    public void setFieldOrder(int dimension, int[] order, boolean reorderColData) {
        if (reorderColData) {
            this.colData[this.mDataMap[dimension]].setFieldOrder(order);
            if (dimension == 0 && this.axisData != null && this.getChartType() == 14 && order.length == this.axisData.length) {
                int i;
                ColData[] tmpData = new ColData[this.axisData.length];
                Axis[] tmpAxis = new Axis[this.axisData.length];
                for (i = 0; i < tmpAxis.length; ++i) {
                    tmpData[i] = this.axisData[i];
                    tmpAxis[i] = this.colDataAxis[i];
                }
                for (i = 0; i < tmpAxis.length; ++i) {
                    this.axisData[i] = tmpData[order[i]];
                    this.colDataAxis[i] = tmpAxis[order[i]];
                }
            }
        }
        this.mData.reorder(order, dimension);
        if (this.showLegend2()) {
            if (!this.isOverlayCombo()) {
                this.mData2.reorder(order, dimension);
            } else if (this.dataDim == 1 && dimension == 0 || this.dataDim > 1 && dimension == 1 && !this.isStackType() || this.dataDim == 2 && dimension == 0 && this.isStackType() || this.dataDim >= 3 && dimension == 1 && this.isStackType()) {
                this.mData2.reorder(order, 1);
            }
        }
        if (this.legend != null) {
            this.legend.init = false;
        }
        if (this.legend2 != null) {
            this.legend2.init = false;
        }
    }

    @Override
    public void setRandomColor3D(Color random1) {
    }

    @Override
    public void mddSetColor(MultiDimData a, MultiDimData b) {
        a.area.setColor(null, b.area.areaColor);
    }

    @Override
    public void setAxisColor(Color color) {
        this.axis[0].setColor(color);
        this.axis[1].setColor(color);
        this.axis[3].setColor(color);
    }

    @Override
    public void setAxisState(int _axis, boolean state) {
        if (_axis > 3 && this.colDataAxis != null) {
            this.colDataAxis[_axis - 4].bshow = state;
        } else {
            this.axis[_axis].bshow = state;
        }
    }

    @Override
    public boolean inside(int x, int y) {
        if (!this.isChartVisible()) {
            return false;
        }
        y = this.winHeight - y;
        return x >= this.chartxorigin && x <= this.chartxorigin + this.chartwidth && y >= this.chartyorigin && y <= this.chartyorigin + this.chartheight;
    }

    @Override
    public Object insideSelect(CGraphics g, int x, int y, Object target, int i, String[] stable) {
        if (this.is2DChart) {
            if (IOUtil.isJava2D() && (target = this.selectControlRange(g, x, y, 1)) != null) {
                ControlRange controlRange = (ControlRange)target;
                this.targetName = controlRange.getTitle() + " " + controlRange.getStartScale(this) + " to " + controlRange.getEndScale(this);
                return target;
            }
            if (this.showLegend2() && (this.chartType != 4 || this.chartType == 4 && this.comboType == 0) && (target = this.mData2.select2(g, x, y)) != null) {
                this.targetName = this.getInformation((MultiDimData)target);
                if (this.chartType == 3 && ((MultiDimData)target).plotData != null) {
                    target = ((MultiDimData)target).parent;
                }
                return target;
            }
            if (this.showLegend2() && this.isOverlayCombo()) {
                target = ((MultiDimData2D)this.mData2).selectOverlayLine(g, x, y);
                if (target != null) {
                    this.targetName = this.getInformation((MultiDimData)target);
                    return target;
                }
                if (this.chartType == 8 && (target = ((MultiDimData2D)this.mData2).selectOverlayArea(g, x, y)) != null) {
                    this.targetName = this.getInformation((MultiDimData)target);
                    return target;
                }
            }
            if ((target = this.mData.select(g, x, y)) != null) {
                this.targetName = this.getInformation((MultiDimData)target);
                if ((this.chartType == 3 || this.chartType == 2 || this.chartType == 13 || this.chartType == 19) && ((MultiDimData)target).plotData != null) {
                    target = ((MultiDimData)target).parent;
                }
                return target;
            }
            target = this.selectDropBar(g, x, y);
            if (target != null) {
                this.targetName = "Drop bar";
                return target;
            }
            if (this.showLegend2()) {
                if (this.chartType == 4 && this.comboType == 1 && (target = this.mData2.selectStackArea(g, x, y)) != null) {
                    this.targetName = this.getInformation((MultiDimData)target);
                    return target;
                }
                if (this.isOverlayCombo() && (target = ((MultiDimData2D)this.mData2).selectOverlayArea(g, x, y)) != null) {
                    this.targetName = this.getInformation((MultiDimData)target);
                    return target;
                }
                if (this.comboType == 2 && this.isHiLow() && (target = this.mData2.select(g, x, y)) != null) {
                    this.targetName = this.getInformation((MultiDimData)target);
                    return target;
                }
            }
            if (this.isStackType() && this.showLine && (target = StackChart.selectLine(g, x, y, this.mData, this.mDataLen, this.dataDim)) != null) {
                this.targetName = this.getInformation((MultiDimData)target);
                return target;
            }
            target = this.selectDataLine(g, x, y);
            if (target != null) {
                this.targetName = ((DataLine)target).getTitle();
                if (target instanceof ControlLine) {
                    this.targetName = this.targetName + " " + ((ControlLine)target).getCalculatedValue();
                } else if (target instanceof HorzVertLine) {
                    this.targetName = this.targetName + " " + ((HorzVertLine)target).getLineValue();
                }
                return target;
            }
            if (!Chart2D.isCircularChart(this.chartType)) {
                for (i = 0; i < 4; ++i) {
                    if (i == 2 || i == 3 && !this.showSecAxis() || this.axis[i].ticker == null || !this.axis[i].ticker.showline || !this.axis[i].ticker.showText || !this.axis[i].ticker.select(g, x, y)) continue;
                    this.targetName = stable[i] + " ticker";
                    return this.axis[i].ticker;
                }
                for (i = 0; i < 2; ++i) {
                    if (!this.axis[i].select(g, x, y)) continue;
                    this.targetName = stable[i] + " axis";
                    return this.axis[i];
                }
                if (this.showSecAxis() && this.axis[3].select(g, x, y)) {
                    this.targetName = stable[3] + " axis";
                    return this.axis[3];
                }
                if (this.border.drawBorder && this.border.borderSelect(g, x, y)) {
                    this.targetName = "chart border";
                    return this.border;
                }
                for (i = 0; i < 2; ++i) {
                    if (!this.axis[i].grid.select(g, x, y)) continue;
                    this.targetName = stable[i] + " grid";
                    return this.axis[i].grid;
                }
            }
            if (this.chartType == 14 && this.colDataAxis != null) {
                for (i = 0; i < this.colDataAxis.length; ++i) {
                    if (this.colDataAxis[i] == null) continue;
                    if (this.colDataAxis[i].ticker != null && this.colDataAxis[i].ticker.showline && this.colDataAxis[i].ticker.showText && this.colDataAxis[i].ticker.select(g, x, y)) {
                        this.targetName = this.colData[this.mDataMap[0]].getFieldName()[i] + " ticker";
                        return this.colDataAxis[i].ticker;
                    }
                    if (this.colDataAxis[i].select(g, x, y)) {
                        this.targetName = this.colData[this.mDataMap[0]].getFieldName()[i] + " axis";
                        return this.colDataAxis[i];
                    }
                    if (!this.colDataAxis[i].grid.select(g, x, y)) continue;
                    this.targetName = this.colData[this.mDataMap[0]].getFieldName()[i] + " grid";
                    return this.colDataAxis[i].grid;
                }
            }
            if ((target = this.selectControlRange(g, x, y, 0)) != null) {
                ControlRange controlRange = (ControlRange)target;
                this.targetName = controlRange.getTitle() + " " + controlRange.getStartScale(this) + " to " + controlRange.getEndScale(this);
                return target;
            }
            if (this.background.drawArea && this.background.select(g, x, y)) {
                this.targetName = "chart background";
                return this.background;
            }
        }
        return null;
    }

    private ControlRange selectControlRange(CGraphics g, int x, int y, int rangeOption) {
        if (this.getChartType() == 16 || Chart2D.isCircularChart(this.chartType)) {
            return null;
        }
        Vector<ControlRange> controlRangeList = this.getControlRangeList();
        for (int i = controlRangeList.size() - 1; i >= 0; --i) {
            ControlRange controlRange = controlRangeList.elementAt(i);
            if (rangeOption == 1 && !controlRange.isOverlapAreaHighlighted()) continue;
            int x1 = controlRange.getX1(this);
            int x2 = controlRange.getX2(this);
            int y1 = controlRange.getY1(this);
            int y2 = controlRange.getY2(this);
            if (x1 == -1 || x2 == -1 || y1 == -1 || y2 == -1 || !g.containsArea(x1, y1, x2, y2, x, y)) continue;
            return controlRange;
        }
        return null;
    }

    public Object selectDropBar(CGraphics g, int x, int y) {
        return null;
    }

    @Override
    public CString selectTopLabel(CGraphics g, int x, int y) {
        CString target;
        if (this.showTopValue && this.is2DChart && (target = CString.selectStrings(g, x, y, this.topLabels)) != null) {
            return target;
        }
        return null;
    }

    @Override
    public CString selectTopLabel2(CGraphics g, int x, int y) {
        CString target;
        if (this.getTopValueState2() && this.is2DChart && (target = CString.selectStrings(g, x, y, this.topLabels2)) != null) {
            return target;
        }
        return null;
    }

    @Override
    public void calcForDraw(int height) {
        this.chartyorigin = height - this.chartyorigin - this.chartheight;
    }

    @Override
    public void doNewSurface() {
    }

    @Override
    public void doComputeDataLines() {
        this.dataLineSet.computeDataLines(!this.is2DChart);
    }

    @Override
    public void drawLabel3D(CGraphics g) {
    }

    @Override
    public void drawLineList(CGraphics cgraphics) {
        Graphics g = cgraphics.g;
        for (int i = 0; i < this.lineList.size(); ++i) {
            Point_3D p;
            Point lastp;
            Point currp;
            int j;
            PolyLine line = (PolyLine)this.lineList.elementAt(i);
            int len = line.getPoints().size();
            if (len < 2) continue;
            g.setColor(line.getColor());
            if (line.getPoints().elementAt(0) instanceof Point_2D) {
                if (line.isFillArea()) {
                    Polygon polygon = new Polygon();
                    for (j = 0; j < len; ++j) {
                        currp = this.transformCoord((Point_2D)line.getPoints().elementAt(j));
                        polygon.addPoint(currp.x, currp.y);
                    }
                    cgraphics.fillPolygon(polygon, null);
                    continue;
                }
                lastp = this.transformCoord((Point_2D)line.getPoints().firstElement());
                for (int j2 = 1; j2 < len; ++j2) {
                    currp = this.transformCoord((Point_2D)line.getPoints().elementAt(j2));
                    cgraphics.fillLine(lastp.x, lastp.y, currp.x, currp.y, line.getThickness(), null, line.getLineStyle());
                    if (line.isArrowAtStartPointVisible() && j2 == 1) {
                        cgraphics.drawArrow(currp.x, currp.y, lastp.x, lastp.y, line.getThickness());
                    }
                    if (line.isArrowAtEndPointVisible() && j2 == len - 1) {
                        cgraphics.drawArrow(lastp.x, lastp.y, currp.x, currp.y, line.getThickness());
                    }
                    lastp = currp;
                }
                continue;
            }
            if (line.isFillArea()) {
                Polygon polygon = new Polygon();
                for (j = 0; j < len; ++j) {
                    p = (Point_3D)line.getPoints().elementAt(j);
                    currp = this.backTransformCoord(p.getX(), p.getY());
                    polygon.addPoint(currp.x, this.winHeight - currp.y);
                }
                cgraphics.fillPolygon(polygon, null);
                continue;
            }
            p = (Point_3D)line.getPoints().firstElement();
            lastp = this.backTransformCoord(p.getX(), p.getY());
            for (int j3 = 1; j3 < len; ++j3) {
                p = (Point_3D)line.getPoints().elementAt(j3);
                currp = this.backTransformCoord(p.getX(), p.getY());
                cgraphics.fillLine(lastp.x, this.winHeight - lastp.y, currp.x, this.winHeight - currp.y, line.getThickness(), null, line.getLineStyle());
                if (line.isArrowAtStartPointVisible() && j3 == 1) {
                    cgraphics.drawArrow(currp.x, this.winHeight - currp.y, lastp.x, this.winHeight - lastp.y, line.getThickness());
                }
                if (line.isArrowAtEndPointVisible() && j3 == len - 1) {
                    cgraphics.drawArrow(lastp.x, this.winHeight - lastp.y, currp.x, this.winHeight - currp.y, line.getThickness());
                }
                lastp = currp;
            }
        }
    }

    @Override
    protected PolyLine selectLineList(int x, int y) {
        for (int i = 0; i < this.lineList.size(); ++i) {
            Point_3D p;
            Point lastp;
            Point currp;
            int j;
            PolyLine line = (PolyLine)this.lineList.elementAt(i);
            if (line.getPoints().size() < 2) continue;
            if (line.getPoints().elementAt(0) instanceof Point_2D) {
                if (line.isFillArea()) {
                    Polygon polygon = new Polygon();
                    for (j = 0; j < line.getPoints().size(); ++j) {
                        currp = this.transformCoord((Point_2D)line.getPoints().elementAt(j));
                        polygon.addPoint(currp.x, this.winHeight - currp.y);
                    }
                    if (!polygon.contains(x, y)) continue;
                    return line;
                }
                lastp = this.transformCoord((Point_2D)line.getPoints().firstElement());
                lastp.y = this.winHeight - lastp.y;
                for (int j2 = 1; j2 < line.getPoints().size(); ++j2) {
                    currp = this.transformCoord((Point_2D)line.getPoints().elementAt(j2));
                    currp.y = this.winHeight - currp.y;
                    if (Line.pickLine(currp.x, currp.y, lastp.x, lastp.y, x, y)) {
                        return line;
                    }
                    lastp = currp;
                }
                continue;
            }
            if (line.isFillArea()) {
                Polygon polygon = new Polygon();
                for (j = 0; j < line.getPoints().size(); ++j) {
                    p = (Point_3D)line.getPoints().elementAt(j);
                    currp = this.backTransformCoord(p.getX(), p.getY());
                    polygon.addPoint(currp.x, currp.y);
                }
                if (!polygon.contains(x, y)) continue;
                return line;
            }
            p = (Point_3D)line.getPoints().firstElement();
            lastp = this.backTransformCoord(p.getX(), p.getY());
            for (int j3 = 1; j3 < line.getPoints().size(); ++j3) {
                p = (Point_3D)line.getPoints().elementAt(j3);
                currp = this.backTransformCoord(p.getX(), p.getY());
                if (Line.pickLine(currp.x, currp.y, lastp.x, lastp.y, x, y)) {
                    return line;
                }
                lastp = currp;
            }
        }
        return null;
    }

    @Override
    public void draw3D(CGraphics g, int ctype) {
    }

    @Override
    public void drawAllAxis(CGraphics g) {
    }

    @Override
    public void draw2D(CGraphics g, int ctype) {
        if (g.g instanceof IFlashGraphics) {
            switch (this.chartType) {
                case 6: {
                    break;
                }
                case 2: {
                    ((IFlashGraphics)((Object)g.g)).setFrameRate(10.0f);
                }
                default: {
                    for (int i = 0; i < this.flashFrameCount; ++i) {
                        ((IFlashGraphics)((Object)g.g)).setFrame(i);
                        this.flashRatio = ((double)i + 1.0) / (double)this.flashFrameCount;
                        this.computeCoord(g, this.chartxorigin, this.chartxorigin + this.chartwidth, this.chartyorigin, this.chartheight + this.chartyorigin);
                        this.draw_2D(g, ctype);
                    }
                    ((IFlashGraphics)((Object)g.g)).setFrame(-1);
                    break;
                }
            }
        } else {
            this.draw_2D(g, ctype);
        }
    }

    private void draw_2D(CGraphics g, int ctype) {
        this.background.draw(g, this.background, null, true, this.background);
        this.drawControlRange(g, 0);
        if (!this.isGridInFront()) {
            this.a_x.drawGrid(g);
            this.a_y.drawGrid(g);
        }
        this.border.draw(g);
        if (IOUtil.isJava2D()) {
            Graphics backupG = g.g;
            Image buffImg = Composite.getBufferedImage(backupG, this.winWidth, this.winHeight);
            g.g = Composite.createGraphics(backupG, buffImg);
            if (g instanceof IFlashGraphics) {
                for (int i = 0; i < this.flashFrameCount; ++i) {
                    ((IFlashGraphics)((Object)g)).setFrame(i);
                    this.flashRatio = ((double)i + 1.0) / (double)this.flashFrameCount;
                    this.drawChart2D(g, ctype);
                }
                ((IFlashGraphics)((Object)g)).setFrame(-1);
            }
            this.drawChart2D(g, ctype);
            this.drawControlRange(g, 1);
            Composite.drawImage(backupG, buffImg);
            g.g = backupG;
        } else {
            this.drawChart2D(g, ctype);
        }
        this.dataLineSet.drawDataLineList();
        boolean restoreRendering = false;
        if (this.setAntiAliasForChartOnly && this.isAntiAliasEnabled()) {
            restoreRendering = true;
            this.setAntiAliasEnabled(false);
            RenderingChart.setRenderingHint(g.g, this.renderingKey, this.renderingValue);
        }
        this.a_y.draw(g);
        if (this.xAxisAtTop) {
            int tmpY = this.a_y.getEnd().y > this.a_y.getStart().y ? this.a_y.getEnd().y : this.a_y.getStart().y;
            this.a_x.setY(tmpY);
            this.a_x.ticker.setY(tmpY);
        }
        this.a_x.draw(g);
        if (this.showLegend2()) {
            this.a_s.draw(g);
        }
        if (IOUtil.isJava2D()) {
            Graphics backupG = g.g;
            Image buffImg = Composite.getBufferedImage(backupG, this.winWidth, this.winHeight);
            g.g = Composite.createGraphics(backupG, buffImg);
            boolean oldImageMap = g.imagemap;
            g.imagemap = false;
            this.drawPoints(g);
            g.imagemap = oldImageMap;
            this.drawControlRange(g, 2);
            Composite.drawImage(backupG, buffImg);
            g.g = backupG;
        }
        if (this.isGridInFront()) {
            this.a_x.drawGrid(g);
            this.a_y.drawGrid(g);
        }
        this.drawLabel(g);
        this.mainTitle.draw(g);
        if (this.legend2.chart != null) {
            this.legend2.chart.cgraphics = g;
        }
        if (restoreRendering) {
            this.setAntiAliasEnabled(true);
            RenderingChart.setRenderingHint(g.g, this.renderingKey, this.renderingValue);
        }
        if (this.checkZoomStatus() && this.getZoomOption() != -1) {
            this.drawScrollBars(g);
        }
    }

    public void drawPoints(CGraphics g) {
        if (this.showPoint) {
            this.mData.drawPoint(g);
        }
        if (this.showLegend2() && this.showPoint2) {
            this.mData2.drawPoint(g);
        }
    }

    public void drawChart2D(CGraphics g, int ctype) {
        boolean isTransparent;
        boolean bl = isTransparent = (this.isOverlayCombo() || this.getControlRangeList().size() > 0 || this.chartType == 18 || this.chartType == 13) && this.isTranslucentSupport();
        if (this.showLegend2() && this.isOverlayCombo()) {
            Overlay2D.drawArea(g, this, this.mData2);
        }
        if (isTransparent) {
            Composite.setCompositeSrcOver(g.g, this.getTranslucentValue());
        }
        if (ctype == 1) {
            this.mData.drawArea(g);
        } else if (this.chartType == 2 && this.showArea) {
            this.mData.drawArea(g);
        }
        if (ctype == 1 && isTransparent) {
            Composite.setOriginalComposite(g.g);
        }
        if (this.showLine) {
            this.mData.drawLine(g);
        }
        if (this.showPoint) {
            this.mData.drawPoint(g);
        }
        if (ctype != 1 && isTransparent) {
            Composite.setOriginalComposite(g.g);
        }
        if (this.showLegend2()) {
            if (this.isOverlayCombo()) {
                if (this.showLine2) {
                    Overlay2D.drawLine(g, this, this.mData2);
                }
            } else if (this.comboType == 2 && this.isHiLow()) {
                this.mData2.drawArea(g);
            } else if (this.showLine2) {
                this.mData2.drawLine(g);
            }
            if (this.showPoint2) {
                this.mData2.drawPoint(g);
            }
        }
    }

    public void drawControlRange(CGraphics g, int drawOption) {
        boolean isTransparent;
        float highLightAlpha = 1.0f;
        Vector<ControlRange> controlRangeList = this.getControlRangeList();
        boolean bl = isTransparent = controlRangeList.size() > 0 && this.isTranslucentSupport();
        if (isTransparent) {
            if (drawOption == 1 || drawOption == 2) {
                highLightAlpha = 0.5f;
            } else {
                Composite.setCompositeSrcOver(g.g, this.getTranslucentValue());
            }
        }
        for (int i = 0; i < controlRangeList.size(); ++i) {
            ControlRange controlRange = controlRangeList.elementAt(i);
            if (drawOption == 0 && controlRange.isOverlapAreaHighlighted() || (drawOption == 1 || drawOption == 2) && !controlRange.isOverlapAreaHighlighted()) continue;
            int x1 = controlRange.getX1(this);
            x1 = x1 == this.a_x.startp.x && drawOption == 2 ? 0 : x1;
            int x2 = controlRange.getX2(this);
            x2 = x2 == this.a_x.endp.x && drawOption == 2 ? this.getSize().width : x2;
            int y1 = controlRange.getY1(this);
            int y2 = controlRange.getY2(this);
            if (x1 == -1 || x2 == -1 || y1 == -1 || y2 == -1 || x2 > this.a_x.endp.x && drawOption != 2 || x2 < this.a_x.startp.x || y2 > this.a_y.endp.y || y2 < this.a_y.startp.y) continue;
            g.setColor(controlRange.getColor());
            if (drawOption == 1 || drawOption == 2) {
                Composite.setCompositeSrcIn(g.g, highLightAlpha);
            }
            g.fillArea(x1, y1, x2, y2, controlRange.getAppearance(), controlRange.getDepth(), null, false, 0, controlRange);
        }
        if (isTransparent || drawOption == 1 || drawOption == 2) {
            Composite.setOriginalComposite(g.g);
        }
    }

    public void drawScrollBars(CGraphics g) {
        if (this.getZoomOption() == 0 || this.getZoomOption() == 2) {
            int yMax = this.winHeight - this.chartyorigin;
            int newX = this.chartxorigin + 1 + (int)((float)this.chartwidth * this.xmin);
            int newW = (int)((float)this.chartwidth * this.xratio);
            g.setColor(Color.black);
            g.drawRect(this.chartxorigin + 1, yMax, this.chartwidth, 9);
            g.setColor(Color.white);
            g.fillRect(this.chartxorigin + 2, yMax + 1, this.chartwidth - 2, 7);
            g.setColor(Color.black);
            g.fillRect(newX, yMax + 2, newW, 5);
        }
        if (this.getZoomOption() == 1 || this.getZoomOption() == 2) {
            int yMin = this.winHeight - this.chartyorigin - this.chartheight;
            int newY = yMin + 1 + (int)((float)this.chartheight * (1.0f - this.ymin - this.yratio));
            int newH = (int)((float)this.chartheight * this.yratio);
            g.setColor(Color.black);
            g.drawRect(this.chartxorigin - 11, yMin, 9, this.chartheight);
            g.setColor(Color.white);
            g.fillRect(this.chartxorigin - 10, yMin + 1, 7, this.chartheight - 2);
            g.setColor(Color.black);
            g.fillRect(this.chartxorigin - 9, newY, 5, newH);
        }
    }

    @Override
    public float[] getViewPoint() {
        return null;
    }

    @Override
    public void setViewPoint(float[] view) {
    }

    @Override
    public Point_3D[] getViewDirection() {
        return null;
    }

    @Override
    public void setViewDirection(Point_3D[] view) {
    }

    @Override
    public float[] getViewTranslate() {
        return null;
    }

    @Override
    public void setViewTranslate(float[] trans) {
    }

    @Override
    public Point_3D getViewTranslation() {
        return null;
    }

    @Override
    public void setViewTranslation(Point_3D p) {
    }

    @Override
    public float[] getLightPos() {
        return null;
    }

    @Override
    public void setLightPos(float[] light) {
    }

    @Override
    public Point_3D getLightPosition() {
        return null;
    }

    @Override
    public void setLightPosition(Point_3D p) {
    }

    @Override
    public void setAmbientLight(Color c) {
    }

    @Override
    public float[] getAmbient() {
        return null;
    }

    @Override
    public void setAmbient(float[] ambient) {
    }

    @Override
    public float[] getIntensity() {
        return null;
    }

    @Override
    public void setIntensity(float[] intensity) {
    }

    @Override
    public Color getLightIntensity() {
        return null;
    }

    @Override
    public void setLightIntensity(Color c) {
    }

    @Override
    public Color getAmbientLight() {
        return null;
    }

    @Override
    public double getAnimateSpeed() {
        return 0.05235987755982988;
    }

    @Override
    public void setAnimateSpeed(double speed) {
    }

    @Override
    public int get3DDrawType() {
        return -1;
    }

    @Override
    public void set3DDrawType(int drawType) {
    }

    @Override
    public float getZoomfactor() {
        return -1.0f;
    }

    @Override
    public void setZoomfactor(float zoomfactor) {
    }

    @Override
    public float getX_scale() {
        return -1.0f;
    }

    @Override
    public float getY_scale() {
        return -1.0f;
    }

    @Override
    public float getZ_scale() {
        return -1.0f;
    }

    @Override
    public void setSwapAxis(boolean state) {
        boolean isBarType = this.chartType == 1 || this.chartType == 5 || this.chartType == 18;
        ((Axis2D)this.a_x).doSwap = state && isBarType;
        ((Axis2D)this.a_y).doSwap = state && !isBarType;
        ((Axis2D)this.a_s).doSwap = state;
        this.isSwapAxis = state;
    }

    @Override
    public boolean isSwapAxis() {
        return this.isSwapAxis;
    }

    @Override
    public void computeBoundingBox() {
        this.chartxorigin = (int)((float)this.winWidth * this.chart_XProp);
        this.chartyorigin = (int)((float)this.winHeight * this.chart_YProp);
        this.chartwidth = (int)((float)this.winWidth * this.chart_widthProp);
        this.chartheight = (int)((float)this.winHeight * this.chart_heightProp);
        if (this.is2DChart) {
            this.chartyorigin = this.winHeight - this.chartyorigin - this.chartheight;
            this.xboundmin = this.chartxorigin;
            this.xboundmax = this.chartxorigin + this.chartwidth;
            this.yboundmin = this.chartyorigin;
            this.yboundmax = this.chartyorigin + this.chartheight;
            return;
        }
    }

    @Override
    public void createSpace(int xmin, int xmax, int ymin, int ymax, float ratio) {
    }

    @Override
    public void newSurface() {
    }

    private Point backTransformCoord(float x, float y) {
        return new Point((int)(x * (float)this.chartwidth / 1000.0f + (float)this.chartxorigin), (int)((float)this.winHeight - (y * (float)this.chartheight / 1000.0f + (float)this.chartyorigin)));
    }

    @Override
    public void zoomSpace(float factor) {
    }

    @Override
    public void translateSpace(float x, float y, float z) {
    }

    @Override
    public void scaleSpace(float x, float y, float z) {
    }

    @Override
    public void setLighting() {
    }
}

