/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart2d;

public class GenMatrix {
    protected double[][] element;
    protected int nr;
    protected int nc;

    public int size() {
        return this.nr * this.nc;
    }

    public int rows() {
        return this.nr;
    }

    public int cols() {
        return this.nc;
    }

    public GenMatrix(int rows, int cols) {
        this.nr = rows;
        this.nc = cols;
        this.element = new double[rows][cols];
    }

    public double get(int row, int col) {
        return this.element[row][col];
    }

    public void set(int row, int col, double value) {
        this.element[row][col] = value;
    }

    public GenMatrix transpose() {
        GenMatrix result = new GenMatrix(this.nc, this.nr);
        for (int i = 0; i < this.nr; ++i) {
            for (int j = 0; j < this.nc; ++j) {
                result.element[j][i] = this.element[i][j];
            }
        }
        return result;
    }

    public GenMatrix times(GenMatrix arg) {
        GenMatrix res = new GenMatrix(this.nr, arg.nc);
        res.inplaceArgTimesArg(this, arg);
        return res;
    }

    public void inplaceArgTimesArg(GenMatrix arg1, GenMatrix arg2) {
        for (int i = 0; i < this.nr; ++i) {
            for (int j = 0; j < this.nc; ++j) {
                double sum = 0.0;
                for (int k = 0; k < arg1.nc; ++k) {
                    sum += arg1.element[i][k] * arg2.element[k][j];
                }
                this.element[i][j] = sum;
            }
        }
    }

    public void destructiveInvert() throws ArithmeticException {
        double temp;
        int l;
        int k;
        int n = this.nr;
        int icol = 0;
        int irow = 0;
        int[] indxc = new int[n];
        int[] indxr = new int[n];
        int[] ipiv = new int[n];
        for (int i = 0; i < n; ++i) {
            double big = 0.0;
            for (int j = 0; j < n; ++j) {
                if (ipiv[j] == 1) continue;
                for (k = 0; k < n; ++k) {
                    if (ipiv[k] == 0) {
                        if (!(Math.abs(this.element[j][k]) >= big)) continue;
                        big = Math.abs(this.element[j][k]);
                        irow = j;
                        icol = k;
                        continue;
                    }
                    if (ipiv[k] <= 1) continue;
                    throw new ArithmeticException("destructiveInvert: Singular Matrix-position 1");
                }
            }
            int n2 = icol;
            ipiv[n2] = ipiv[n2] + 1;
            if (irow != icol) {
                for (l = 0; l < n; ++l) {
                    temp = this.element[irow][l];
                    this.element[irow][l] = this.element[icol][l];
                    this.element[icol][l] = temp;
                }
            }
            indxr[i] = irow;
            indxc[i] = icol;
            if (this.element[icol][icol] == 0.0) {
                throw new ArithmeticException("destructiveInvert: Singular Matrix-position 2");
            }
            double pivinv = 1.0 / this.element[icol][icol];
            this.element[icol][icol] = 1.0;
            l = 0;
            while (l < n) {
                double[] dArray = this.element[icol];
                int n3 = l++;
                dArray[n3] = dArray[n3] * pivinv;
            }
            for (int ll = 0; ll < n; ++ll) {
                if (ll == icol) continue;
                double dum = this.element[ll][icol];
                this.element[ll][icol] = 0.0;
                for (l = 0; l < n; ++l) {
                    double[] dArray = this.element[ll];
                    int n4 = l;
                    dArray[n4] = dArray[n4] - this.element[icol][l] * dum;
                }
            }
        }
        for (l = n - 1; l >= 0; --l) {
            if (indxr[l] == indxc[l]) continue;
            for (k = 0; k < n; ++k) {
                temp = this.element[k][indxr[l]];
                this.element[k][indxr[l]] = this.element[k][indxc[l]];
                this.element[k][indxc[l]] = temp;
            }
        }
    }
}

