/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart2d;

import java.awt.Color;
import java.awt.geom.GeneralPath;
import java.util.Vector;
import quadbase.chart.CGraphics;
import quadbase.chart.Chart;
import quadbase.chart.ControlLine;
import quadbase.chart.DataLine;
import quadbase.chart.HorzVertLine;
import quadbase.chart.MultiDimData;
import quadbase.chart.chart2d.Chart2D;
import quadbase.util.Point_2D;

public class HorzVertLine2D
extends HorzVertLine {
    Color[] rangeColor;
    int[] lineValue;
    Vector<Integer> vectorX = new Vector();
    Vector<Integer> vectorY = new Vector();

    public HorzVertLine2D(Chart chart) {
        super(chart);
        this.copyAttribute(chart);
    }

    public HorzVertLine2D(Chart newChart, HorzVertLine tline) {
        super(newChart, tline);
        this.copyAttribute(this.chart);
    }

    public HorzVertLine2D(Chart chart, int linetype, String title) {
        super(chart, linetype, title);
        this.copyAttribute(chart);
    }

    private void copyAttribute(Chart chart) {
        if (chart == null) {
            return;
        }
        if (!(chart instanceof Chart2D)) {
            return;
        }
        if (((Chart2D)chart).horzVertLine2D == null) {
            return;
        }
        this.rangeColor = ((Chart2D)chart).horzVertLine2D.rangeColor;
        this.lineValue = ((Chart2D)chart).horzVertLine2D.lineValue;
        this.vectorX = ((Chart2D)chart).horzVertLine2D.vectorX;
        this.vectorY = ((Chart2D)chart).horzVertLine2D.vectorY;
    }

    @Override
    public final void setColor(Color color) {
        this.color = color;
    }

    @Override
    public void prepare3DLine() {
    }

    @Override
    protected void drawLine(CGraphics g) {
        if (this.chart.mData2 == null && this.chart.chartType != 14) {
            this.useSubvalue = false;
        }
        if (this.chart.getChartType() == 16) {
            this.drawRadarLine(g);
            return;
        }
        g.g.setColor(this.color);
        int pixelValue = this.getPixelValue();
        GeneralPath path = null;
        if (this.showHorzLine()) {
            int x1 = this.chart.chartxorigin;
            int x2 = this.chart.chartxorigin + this.chart.chartwidth;
            path = this.createLimitPath(g, Integer.MIN_VALUE, Integer.MAX_VALUE, x1, pixelValue, x2, pixelValue, null);
        } else if (this.showVertLine()) {
            int y1 = this.chart.chartyorigin;
            int y2 = this.chart.chartyorigin + this.chart.chartheight;
            path = this.createLimitPath(g, Integer.MIN_VALUE, Integer.MAX_VALUE, pixelValue, y1, pixelValue, y2, null);
        }
        if (path != null) {
            int style = this.lineStyle;
            float dot1 = 1.0f;
            float dot2 = 0.0f;
            if (style == 0) {
                dot1 = 1.0f;
                dot2 = 0.0f;
            } else if (style == 1) {
                dot1 = 5.0f;
                dot2 = 5.0f;
            } else if (style == 2) {
                dot1 = 20.0f;
                dot2 = 5.0f;
            } else {
                dot1 = (float)(style /= 256) / 256.0f;
                dot2 = style % 256;
            }
            g.drawLine(path, this.thickness, new float[]{dot1, dot2});
        }
    }

    private void drawRadarLine(CGraphics g) {
        block7: {
            int centerY;
            int centerX;
            block5: {
                int thick;
                int width;
                int pixelValue;
                block6: {
                    g.g.setColor(this.color);
                    centerX = this.chart.a_y.startp.x;
                    centerY = this.chart.a_y.startp.y;
                    if (!this.chart.isSynchronizeRadarAxis() || this.getLineType() <= 100) break block5;
                    pixelValue = this.getHortLineYPixel();
                    if (this.selectmode) break block6;
                    int width2 = (pixelValue - centerY) * 2 - (int)Math.ceil((double)this.thickness / 2.0);
                    for (int j = 0; j < this.thickness; ++j) {
                        g.drawArc(centerX, centerY, width2 + j, width2 + j, 0, 360);
                    }
                    break block7;
                }
                int dist = (int)Math.rint(Math.sqrt(Math.pow(centerY - this.ypick, 2.0) + Math.pow(centerX - this.xpick, 2.0)));
                if (dist < (width = pixelValue - centerY) - (thick = 1 + (int)Math.ceil((double)this.thickness / 2.0)) || dist > width + thick) break block7;
                this.isObjSelect = true;
                break block7;
            }
            int curX = -1;
            int curY = -1;
            int lastX = -1;
            int lastY = -1;
            int nAxis = this.chart.mDataLen[this.chart.dataDim - 1];
            double sector = Math.PI * 2 / (double)nAxis;
            int width = 0;
            if (this.chart.isSynchronizeRadarAxis()) {
                int pixelValue = this.getHortLineYPixel();
                width = pixelValue - centerY;
            }
            GeneralPath path = null;
            for (int j = 0; j <= nAxis; ++j) {
                double angle = sector * (double)j;
                if (!this.chart.isSynchronizeRadarAxis()) {
                    width = this.chart.colDataAxis[j % nAxis].stepsize.interpolatePixel2(this.line_value) - centerY;
                }
                curX = centerX + (int)(Math.sin(angle) * (double)width);
                curY = centerY + (int)(Math.cos(angle) * (double)width);
                if (lastX != -1) {
                    path = this.drawLimitPath(g, Integer.MIN_VALUE, Integer.MAX_VALUE, lastX, lastY, curX, curY, path);
                }
                lastX = curX;
                lastY = curY;
            }
        }
    }

    @Override
    protected Point_2D getAbsPosition() {
        int x = 0;
        int y = 0;
        int pixelValue = this.getPixelValue();
        if (this.showHorzLine()) {
            x = this.chart.chartxorigin + this.chart.chartwidth;
            y = pixelValue;
        } else if (this.showVertLine()) {
            x = pixelValue;
            y = this.chart.chartyorigin + this.chart.chartheight;
        }
        return new Point_2D(x, y);
    }

    public void setRangeColor(Chart chart) {
        HorzVertLine currentHorzVertLine;
        if (chart.isCircularChart()) {
            this.rangeColor = null;
            this.lineValue = null;
            return;
        }
        Vector<DataLine> dataLine = chart.dataLineSet.getDataLineList();
        Vector<DataLine> horzVertSet = new Vector<DataLine>();
        int nDataLine = dataLine.size();
        for (int i = 0; i < nDataLine; ++i) {
            DataLine currentLine = dataLine.elementAt(i);
            if (!(currentLine instanceof HorzVertLine)) continue;
            if (currentLine instanceof ControlLine && chart.chartType != 15) {
                horzVertSet.addElement(currentLine);
                continue;
            }
            if (chart.getChartType() == 18 && currentLine.getLineValue() == -1.7976931348623157E308) {
                if (!currentLine.isVisible()) continue;
                horzVertSet.addElement(currentLine);
                continue;
            }
            if (!DataLine.isBarChartType(chart) || chart.chartType == 2) {
                if (!((HorzVertLine)currentLine).showHorzLine()) continue;
                horzVertSet.addElement(currentLine);
                continue;
            }
            if (!((HorzVertLine)currentLine).showVertLine()) continue;
            horzVertSet.addElement(currentLine);
        }
        int nHorzVert = horzVertSet.size();
        if (nHorzVert == 0) {
            this.rangeColor = null;
            this.lineValue = null;
            return;
        }
        HorzVertLine[] horzVertLine = new HorzVertLine[nHorzVert];
        this.lineValue = new int[nHorzVert];
        for (int i = 0; i < nHorzVert; ++i) {
            horzVertLine[i] = currentHorzVertLine = (HorzVertLine)horzVertSet.elementAt(i);
            this.lineValue[i] = currentHorzVertLine.getPixelValue();
        }
        for (int i = 0; i < nHorzVert - 1; ++i) {
            for (int j = i + 1; j < nHorzVert; ++j) {
                int value1 = this.lineValue[i];
                int value2 = this.lineValue[j];
                if (value1 <= value2) continue;
                currentHorzVertLine = horzVertLine[i];
                horzVertLine[i] = horzVertLine[j];
                horzVertLine[j] = currentHorzVertLine;
                int temp = value1;
                this.lineValue[i] = value2;
                this.lineValue[j] = temp;
            }
        }
        this.rangeColor = new Color[nHorzVert + 1];
        for (int i = nHorzVert - 1; i >= 0; --i) {
            Color belowColor = horzVertLine[i].getColorBelowLine();
            if (belowColor == null) continue;
            for (int j = i; j >= 0; --j) {
                this.rangeColor[j] = belowColor;
            }
        }
        for (int i = 0; i < nHorzVert; ++i) {
            Color aboveColor = horzVertLine[i].getColorAboveLine();
            if (aboveColor == null) continue;
            for (int j = 0; j < nHorzVert; ++j) {
                this.rangeColor[j + 1] = aboveColor;
            }
        }
        boolean allNullColor = true;
        if (this.rangeColor != null) {
            for (int i = 0; i <= nHorzVert; ++i) {
                if (this.rangeColor[i] == null) continue;
                allNullColor = false;
                break;
            }
        }
        if (allNullColor) {
            this.rangeColor = null;
            this.lineValue = null;
        }
    }

    public void drawLineSegment(CGraphics cg, Color defaultColor, int x1, int y1, int x2, int y2, int thick, MultiDimData data, int style) {
        this.drawLineSegment(cg, defaultColor, x1, y1, x2, y2, thick, data, style, false);
    }

    public void drawLineSegment(CGraphics cg, Color defaultColor, int x1, int y1, int x2, int y2, int thick, MultiDimData data, int style, boolean drawArrow) {
        this.drawLineSegment(cg, defaultColor, x1, y1, x2, y2, thick, data, style, false, drawArrow);
    }

    public void drawLineSegment(CGraphics cg, Color defaultColor, int x1, int y1, int x2, int y2, int thick, MultiDimData data, int style, int maxY) {
        if (maxY < 0) {
            this.drawLineSegment(cg, defaultColor, x1, y1, x2, y2, thick, data, style, false, false);
        } else {
            this.drawLineSegment(cg, defaultColor, x1, y1 <= maxY ? y1 : maxY, x2, y2 <= maxY ? y2 : maxY, thick, data, style, false, false);
        }
    }

    private void drawLineSegment(CGraphics cg, Color defaultColor, int x1, int y1, int x2, int y2, int thick, MultiDimData data, int style, boolean isSwapped, boolean drawArrow) {
        if (this.rangeColor == null) {
            HorzVertLine2D.drawNoSegment(cg, defaultColor, x1, y1, x2, y2, thick, data, style, drawArrow);
            return;
        }
        if (!HorzVertLine2D.isBarChartType(cg.chart) || cg.chart.chartType == 2 || cg.chart.chartType == 19) {
            this.drawLineSegmentHorz(cg, defaultColor, x1, y1, x2, y2, thick, data, style, isSwapped);
        } else {
            this.drawLineSegmentVert(cg, defaultColor, x1, y1, x2, y2, thick, data, style);
        }
    }

    private Color getCurrentColorFromY(Color defaultColor, int y1, int y2) {
        int midY = (y1 + y2) / 2;
        int colorIndex = 0;
        int nHorzVert = this.lineValue.length;
        for (int i = 0; i < nHorzVert; ++i) {
            if (midY <= this.lineValue[i]) continue;
            colorIndex = i + 1;
        }
        Color rangeColorValue = this.rangeColor[colorIndex];
        return rangeColorValue == null ? defaultColor : rangeColorValue;
    }

    private Color getCurrentColorFromX(Color defaultColor, int x1, int x2) {
        int midX = (x1 + x2) / 2;
        int colorIndex = 0;
        int nHorzVert = this.lineValue.length;
        for (int i = 0; i < nHorzVert; ++i) {
            if (midX <= this.lineValue[i]) continue;
            colorIndex = i + 1;
        }
        Color rangeColorValue = this.rangeColor[colorIndex];
        return rangeColorValue == null ? defaultColor : rangeColorValue;
    }

    public void drawCutOffLineSegment(CGraphics cg, Color defaultColor, int x1, int y1, int x2, int y2, int thick, MultiDimData data, int style, boolean swapped, int cutOffY, boolean drawArrow) {
        if (y1 > y2) {
            int temp = y2;
            y2 = y1;
            y1 = temp;
            temp = x2;
            x2 = x1;
            x1 = temp;
            swapped = !swapped;
        }
        int currentX = x1;
        int currentY = y1;
        if (currentY > cutOffY && y2 > cutOffY) {
            HorzVertLine2D.drawNoSegment(cg, defaultColor, currentX, cutOffY, x2, cutOffY, thick, data, style, drawArrow);
            return;
        }
        if (cutOffY >= y2) {
            HorzVertLine2D.drawNoSegment(cg, defaultColor, currentX, currentY, x2, y2, thick, data, style, drawArrow);
            return;
        }
        int breakPointY = cutOffY;
        int breakPointX = (int)((float)currentX + (float)((x2 - currentX) * (breakPointY - currentY)) / (float)(y2 - currentY));
        HorzVertLine2D.drawNoSegment(cg, defaultColor, currentX, currentY, breakPointX, breakPointY, thick, data, style, drawArrow);
        currentX = breakPointX;
        currentY = breakPointY;
        HorzVertLine2D.drawNoSegment(cg, defaultColor, currentX, currentY, x2, currentY, thick, data, style, drawArrow);
    }

    private void drawLineSegmentHorz(CGraphics cg, Color defaultColor, int x1, int y1, int x2, int y2, int thick, MultiDimData data, int style, boolean swapped) {
        if (y1 > y2) {
            int temp = y2;
            y2 = y1;
            y1 = temp;
            temp = x2;
            x2 = x1;
            x1 = temp;
            swapped = !swapped;
        }
        int currentX = x1;
        int currentY = y1;
        int currentHorzVertIndex = 0;
        if (currentY == y2) {
            if (!swapped) {
                this.addThisPoint(cg, x2, y2, false);
            } else {
                this.addThisPoint(cg, x1, y1, false);
            }
            Color currentColor = this.getCurrentColorFromY(defaultColor, currentY, y2);
            HorzVertLine2D.drawNoSegment(cg, currentColor, currentX, currentY, x2, y2, thick, data, style);
            return;
        }
        while (currentY < y2) {
            int breakPointY;
            if (this.lineValue[currentHorzVertIndex] > y2 || this.lineValue[currentHorzVertIndex] < currentY) {
                Color currentColor = this.getCurrentColorFromY(defaultColor, currentY, y2);
                HorzVertLine2D.drawNoSegment(cg, currentColor, currentX, currentY, x2, y2, thick, data, style);
                if (!swapped) {
                    this.addThisPoint(cg, x2, y2, false);
                    break;
                }
                this.addThisPoint(cg, x1, y1, false);
                break;
            }
            if ((breakPointY = this.lineValue[currentHorzVertIndex++]) > y2) {
                breakPointY = y2;
            } else if (breakPointY < y1) {
                breakPointY = y1;
            }
            int breakPointX = (int)((float)currentX + (float)((x2 - currentX) * (breakPointY - currentY)) / (float)(y2 - currentY));
            Color currentColor = this.getCurrentColorFromY(defaultColor, currentY, breakPointY);
            this.addThisPoint(cg, currentX, currentY, false);
            this.addThisPoint(cg, breakPointX, breakPointY, true);
            HorzVertLine2D.drawNoSegment(cg, currentColor, currentX, currentY, breakPointX, breakPointY, thick, data, style);
            currentX = breakPointX;
            currentY = breakPointY;
            this.addThisPoint(cg, breakPointX, breakPointY, false);
            if (swapped) {
                this.addThisPoint(cg, x1, y1, false);
            } else {
                this.addThisPoint(cg, x2, y2, false);
            }
            if (currentHorzVertIndex != this.lineValue.length) continue;
            currentColor = this.getCurrentColorFromY(defaultColor, currentY, y2);
            HorzVertLine2D.drawNoSegment(cg, currentColor, currentX, currentY, x2, y2, thick, data, style);
            break;
        }
    }

    private void drawLineSegmentVert(CGraphics cg, Color defaultColor, int x1, int y1, int x2, int y2, int thick, MultiDimData data, int style) {
        if (x1 > x2) {
            int temp = x2;
            x2 = x1;
            x1 = temp;
            temp = y2;
            y2 = y1;
            y1 = temp;
        }
        int currentX = x1;
        int currentY = y1;
        int currentHorzVertIndex = 0;
        if (currentX == x2) {
            Color currentColor = this.getCurrentColorFromX(defaultColor, currentX, x2);
            HorzVertLine2D.drawNoSegment(cg, currentColor, currentX, currentY, x2, y2, thick, data, style);
            return;
        }
        while (currentX < x2) {
            int breakPointX;
            if (this.lineValue[currentHorzVertIndex] >= x2) {
                Color currentColor = this.getCurrentColorFromX(defaultColor, currentX, x2);
                HorzVertLine2D.drawNoSegment(cg, currentColor, currentX, currentY, y2, x2, thick, data, style);
                break;
            }
            if ((breakPointX = this.lineValue[currentHorzVertIndex++]) > x2) {
                breakPointX = x2;
            } else if (breakPointX < x1) {
                breakPointX = x1;
            }
            int breakPointY = (int)((float)currentY - (float)((currentY - y2) * (currentX - breakPointX)) / (float)(currentX - x2));
            Color currentColor = this.getCurrentColorFromX(defaultColor, currentX, breakPointX);
            HorzVertLine2D.drawNoSegment(cg, currentColor, currentX, currentY, breakPointX, breakPointY, thick, data, style);
            currentX = breakPointX;
            currentY = breakPointY;
            if (currentHorzVertIndex != this.lineValue.length) continue;
            currentColor = this.getCurrentColorFromX(defaultColor, currentX, x2);
            HorzVertLine2D.drawNoSegment(cg, currentColor, currentX, currentY, x2, y2, thick, data, style);
            break;
        }
    }

    private static void drawNoSegment(CGraphics cg, Color defaultColor, int x1, int y1, int x2, int y2, int thick, MultiDimData data, int style) {
        HorzVertLine2D.drawNoSegment(cg, defaultColor, x1, y1, x2, y2, thick, data, style, false);
    }

    private static void drawNoSegment(CGraphics cg, Color defaultColor, int x1, int y1, int x2, int y2, int thick, MultiDimData data, int style, boolean drawArrow) {
        cg.setColor(defaultColor);
        cg.fillLine(x1, y1, x2, y2, thick, data, style);
        if (drawArrow) {
            cg.drawArrow(x1, y1, x2, y2, 1);
        }
    }

    public void addThisPoint(CGraphics cg, int x, int y, boolean drawPolygon) {
        this.vectorX.addElement(x);
        this.vectorY.addElement(y);
        if (drawPolygon) {
            cg.fillPolygon(this.vectorX, this.vectorY);
            this.vectorX.removeAllElements();
            this.vectorY.removeAllElements();
        }
    }
}

