/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart2d;

import java.awt.Color;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.logging.Logger;
import quadbase.chart.Area;
import quadbase.chart.CGraphics;
import quadbase.chart.CString;
import quadbase.chart.Chart;
import quadbase.chart.Coordinate;
import quadbase.chart.DataLine;
import quadbase.chart.HiLowData;
import quadbase.chart.IHLCOChart;
import quadbase.chart.IPieChart;
import quadbase.chart.Line;
import quadbase.chart.MultiDimData;
import quadbase.chart.PieChart;
import quadbase.chart.PlotData;
import quadbase.chart.Point3D;
import quadbase.chart.StackChart;
import quadbase.chart.chart2d.Area2D;
import quadbase.chart.chart2d.Chart2D;
import quadbase.common.util.internal.IFlashGraphics;

public class MultiDimData2D
extends MultiDimData {
    private static final Logger LOGGER = Logger.getLogger(MultiDimData2D.class.getName());
    public static boolean SHOW_STACK_LABEL_REGARDLESS_OF_SIZE = false;
    int labelHeight2D = 10;

    public MultiDimData2D(int lv, Chart _chart, MultiDimData p) {
        super(lv, _chart, p);
        if (this.level < this.chart.dataDim) {
            int len = this.chart.mDataLen[this.level];
            this.multiData = new MultiDimData[len];
            for (int i = 0; i < len; ++i) {
                this.multiData[i] = new MultiDimData2D(this.level + 1, this.chart, this);
            }
            this.area = new Area2D();
        } else {
            this.plotData = new PlotData(this.chart);
            this.area = new Area2D();
        }
        if (this.level == this.chart.dataDim - 1) {
            this.order = new int[this.chart.mDataLen[this.level]];
            for (int i = 0; i < this.order.length; ++i) {
                this.order[i] = i;
            }
        }
        this.point = new Point3D();
        this.flashPoint = new Point3D();
    }

    private MultiDimData2D() {
    }

    public static void drawLineSegmentWithLimitAtAxisScaleCheck(CGraphics g, int x1, int y1, int x2, int y2, Color lineColor, MultiDimData data, int thickness, int shape) {
        Point lastpoint = new Point(x1, y1);
        Point currpoint = new Point(x2, y2);
        double m = (currpoint.y - lastpoint.y) / (currpoint.x - lastpoint.x);
        int cx = currpoint.x;
        int cy = currpoint.y;
        int lx = lastpoint.x;
        int ly = lastpoint.y;
        if (currpoint.y > g.chart.background.p2.y && lastpoint.y > g.chart.background.p2.y || currpoint.y < g.chart.background.p1.y && lastpoint.y < g.chart.background.p1.y) {
            return;
        }
        if (lastpoint.y > g.chart.background.p2.y) {
            lx = (int)(((double)(g.chart.background.p2.y - lastpoint.y) + m * (double)lastpoint.x) / m);
            ly = g.chart.background.p2.y;
        }
        if (lastpoint.y < g.chart.background.p1.y) {
            lx = (int)(((double)(g.chart.background.p1.y - lastpoint.y) + m * (double)lastpoint.x) / m);
            ly = g.chart.background.p1.y;
        }
        if (currpoint.y < g.chart.background.p1.y) {
            cx = (int)(((double)(g.chart.background.p1.y - lastpoint.y) + m * (double)lastpoint.x) / m);
            cy = g.chart.background.p1.y;
        }
        if (currpoint.y > g.chart.background.p2.y) {
            cx = (int)(((double)(g.chart.background.p2.y - lastpoint.y) + m * (double)lastpoint.x) / m);
            cy = g.chart.background.p2.y;
        }
        ((Chart2D)g.chart).horzVertLine2D.drawLineSegment(g, lineColor, lx, ly, cx, cy, thickness, data, shape, false);
    }

    @Override
    public MultiDimData copyMultiDimData() {
        MultiDimData2D newData = new MultiDimData2D();
        newData.labelHeight2D = this.labelHeight2D;
        return super.copyMultiDimData(newData);
    }

    @Override
    public void setColor(Color color) {
        super.setColor(color);
        if (this.chart.getChartType() == 3 && this.chart.dataDim == 1 && !this.chart.isSyncPointColorForLine()) {
            return;
        }
        if (this.chart.dataDim == 1 && this.chart.showLine && this.parent == null) {
            return;
        }
        if (this.level < this.chart.dataDim) {
            for (MultiDimData element : this.multiData) {
                element.setColor(color);
            }
        }
    }

    @Override
    public void setPointCoord(int x, int y, int[] loc) {
        if (this.level < this.chart.dataDim) {
            this.multiData[loc[this.level]].setPointCoord(x, y, loc);
            return;
        }
        this.point.x = x;
        this.point.y = y;
    }

    @Override
    public void setFlashPointCoord(int x, int y, int[] loc) {
        if (this.level < this.chart.dataDim) {
            this.multiData[loc[this.level]].setFlashPointCoord(x, y, loc);
            return;
        }
        this.flashPoint.x = x;
        this.flashPoint.y = y;
    }

    @Override
    public void setPointCoord(int x, int y, int z, int[] loc) {
    }

    @Override
    public void setFlashPointCoord(int x, int y, int z, int[] loc) {
    }

    @Override
    public void drawFace(CGraphics g) {
    }

    @Override
    public void drawLine(CGraphics g, Point3D p, int thickness) {
        if (this.chart.dataDim > 1) {
            if (this.level < this.chart.dataDim - 2) {
                for (MultiDimData element : this.multiData) {
                    ((MultiDimData2D)element).drawLine(g, this.point.automatic ? p : this.point, this.point.automatic ? thickness : this.lineThickness);
                }
            } else if (this.chart.chartType != 14) {
                for (int i = 0; i < this.multiData.length; ++i) {
                    if (this.chart.selectStep == null || i >= this.chart.selectStep.length || !this.chart.selectStep[i]) {
                        ((MultiDimData2D)this.multiData[i]).drawConnectLine(g, this.point.automatic ? p : this.point, this.point.automatic ? thickness : this.lineThickness);
                        continue;
                    }
                    ((MultiDimData2D)this.multiData[i]).drawStepLine(g, this.point.automatic ? p : this.point, this.point.automatic ? thickness : this.lineThickness, this.isPrimary() ? this.chart.stepRatio : this.chart.stepRatio2);
                }
            } else if (!this.chart.showStepLine2) {
                this.drawConnectLine(g, this.point.automatic ? p : this.point, this.point.automatic ? thickness : this.lineThickness);
            } else {
                this.drawStepLine(g, this.point.automatic ? p : this.point, this.point.automatic ? thickness : this.lineThickness, this.chart.stepRatio2);
            }
        } else if (this.isPrimary()) {
            if (this.chart.showStepLine) {
                this.drawStepLine(g, p, thickness, this.chart.stepRatio);
            } else {
                this.drawConnectLine(g, p, thickness);
            }
        } else if (this.chart.showStepLine2) {
            this.drawStepLine(g, p, thickness, this.chart.stepRatio2);
        } else {
            this.drawConnectLine(g, p, thickness);
        }
    }

    private void drawConnectLine(CGraphics g, Point3D p, int thickness) {
        boolean drawArrow;
        Color defaultColor;
        Color color = defaultColor = this.point.automatic ? p.color : this.point.color;
        if (this.chart.getChartType() == 16 || this.chart.getChartType() == 19) {
            defaultColor = new Color(defaultColor.getRed(), defaultColor.getGreen(), defaultColor.getBlue(), (int)Math.rint(255.0 * g.chart.flashRatio));
        }
        Point3D lastpoint = null;
        Point3D lastNonNull = null;
        int shape = this.point.automatic ? p.shape : this.point.shape;
        int dataLineThickness = this.point.automatic ? thickness : this.lineThickness;
        int dataLen = this.multiData.length;
        boolean bl = drawArrow = this.chart.getChartType() == 2 && this.chart.isDrawConnectLineArrows();
        if (this.chart.getChartType() == 16) {
            ++dataLen;
        }
        if (this.order == null) {
            this.order = new int[this.chart.mDataLen[this.level]];
            for (int i = 0; i < this.order.length; ++i) {
                this.order[i] = i;
            }
        }
        int cutOffY = -1;
        if (this.chart.isAreaCutOffSupport()) {
            cutOffY = this.chart.a_y.stepsize.interpolatePixel(this.chart.getAreaCutOffPoint());
        }
        for (int i = 0; i < dataLen; ++i) {
            MultiDimData data = i == this.multiData.length ? this.multiData[this.order[0]] : (this.chart.chartType == 2 && this.chart.isLineInOriginalOrder() || this.chart.chartType == 19 ? this.multiData[i] : this.multiData[this.order[i]]);
            if (data.plotData == null || data.plotData.isEmpty()) {
                lastpoint = null;
                continue;
            }
            Point3D currpoint = data.point;
            this.chart.getControlRangeList();
            if (i == 0) {
                ((Chart2D)this.chart).horzVertLine2D.addThisPoint(g, currpoint.x, this.chart.hLineY, false);
            }
            ((Chart2D)this.chart).horzVertLine2D.addThisPoint(g, currpoint.x, currpoint.y, false);
            if (this.chart.isCatZoom() && this.chart.isVertical()) {
                currpoint.x = this.chart.calculateZoomedX(currpoint.x);
            }
            if (lastpoint != null) {
                if (cutOffY >= 0) {
                    ((Chart2D)this.chart).horzVertLine2D.drawCutOffLineSegment(g, defaultColor, lastpoint.x, lastpoint.y, currpoint.x, currpoint.y, dataLineThickness, data, shape, false, cutOffY, drawArrow);
                } else {
                    this.drawLineSegment(g, defaultColor, lastpoint.x, lastpoint.y, currpoint.x, currpoint.y, dataLineThickness, data, shape, drawArrow);
                }
            } else if (lastNonNull != null) {
                if (this.chart.chartType != 13 && this.chart.chartType != 19) {
                    if (this.chart.showNulldataLine) {
                        if (!this.chart.isApplyLineStyleToNullData()) {
                            this.drawLineSegment(g, defaultColor, lastNonNull.x, lastNonNull.y, currpoint.x, currpoint.y, 1, data, 657921, drawArrow);
                        } else {
                            this.drawLineSegment(g, defaultColor, lastNonNull.x, lastNonNull.y, currpoint.x, currpoint.y, dataLineThickness, data, shape, drawArrow);
                        }
                    }
                } else {
                    this.drawLineSegment(g, defaultColor, lastNonNull.x, lastNonNull.y, currpoint.x, currpoint.y, dataLineThickness, data, shape, drawArrow);
                }
            }
            if (i == dataLen - 1) {
                ((Chart2D)this.chart).horzVertLine2D.addThisPoint(g, currpoint.x, currpoint.y, false);
                ((Chart2D)this.chart).horzVertLine2D.addThisPoint(g, currpoint.x, this.chart.hLineY, true);
            }
            lastpoint = currpoint;
            lastNonNull = currpoint;
        }
    }

    private void drawLineSegment(CGraphics g, Color defaultColor, int x1, int y1, int x2, int y2, int thick, MultiDimData data, int shape, boolean drawArrow) {
        Point[] pt = this.getDrawingPoints(x1, y1, x2, y2);
        if (pt == null) {
            return;
        }
        if (g.chart.isDataLimitAtAxisScale() && (pt[1].y > g.chart.background.p2.y || pt[0].y > g.chart.background.p2.y || pt[1].y < g.chart.background.p1.y || pt[0].y < g.chart.background.p1.y)) {
            MultiDimData2D.drawLineSegmentWithLimitAtAxisScaleCheck(g, pt[0].x, pt[0].y, pt[1].x, pt[1].y, defaultColor, data, thick, shape);
        } else {
            ((Chart2D)this.chart).horzVertLine2D.drawLineSegment(g, defaultColor, (int)pt[0].getX(), (int)pt[0].getY(), (int)pt[1].getX(), (int)pt[1].getY(), thick, data, shape, drawArrow);
        }
    }

    public Polygon getPolygonForArea(int x1, int y1, int x2, int y2) {
        return this.getPolygonForArea(x1, y1, x2, y2, -100);
    }

    public Polygon getPolygonForArea(int x1, int y1, int x2, int y2, int zeroAxis) {
        int xOrigin = this.chart.chartxorigin;
        int yOrigin = this.chart.chartyorigin;
        if (zeroAxis != -100) {
            yOrigin = zeroAxis;
        }
        int xTop = xOrigin + this.chart.chartwidth;
        int yTop = yOrigin + this.chart.chartheight;
        int xLeft = x1 < xOrigin ? xOrigin : x1;
        int xRight = x2 > xTop ? xTop : x2;
        Polygon p = new Polygon();
        if (y1 > yTop && y2 > yTop) {
            p.addPoint(xRight, yOrigin);
            p.addPoint(xLeft, yOrigin);
            p.addPoint(xLeft, yTop);
            p.addPoint(xRight, yTop);
            return p;
        }
        Point[] pts = this.getDrawingPoints(x1, y1, x2, y2, xOrigin);
        if (pts == null) {
            return null;
        }
        if (pts[0].x > xLeft && pts[0].y == yOrigin) {
            xLeft = pts[0].x;
        }
        if (pts[1].x < xRight && pts[1].y == yOrigin) {
            xRight = pts[1].x;
        }
        p.addPoint(xRight, yOrigin);
        LOGGER.finest("PT 1 = " + xRight + ", " + yOrigin);
        p.addPoint(xLeft, yOrigin);
        LOGGER.finest("PT 2 = " + xLeft + ", " + yOrigin);
        if (pts[0].x > xLeft) {
            p.addPoint(xLeft, pts[0].y);
            LOGGER.finest("PT 3 = " + xLeft + ", " + pts[0].y);
        }
        p.addPoint(pts[0].x, pts[0].y);
        LOGGER.finest("PT 4 = " + pts[0].x + ", " + pts[0].y);
        p.addPoint(pts[1].x, pts[1].y);
        LOGGER.finest("PT 5 = " + pts[1].x + ", " + pts[1].y);
        if (pts[1].x < xRight) {
            p.addPoint(xRight, pts[1].y);
            LOGGER.finest("PT 6 = " + xRight + ", " + pts[1].y);
        }
        return p;
    }

    private Point[] getDrawingPoints(int x1, int y1, int x2, int y2) {
        return this.getDrawingPoints(x1, y1, x2, y2, this.chart.chartxorigin);
    }

    private Point[] getDrawingPoints(int x1, int y1, int x2, int y2, int xOrigin) {
        if (this.chart.getChartType() == 19) {
            Point[] pts = new Point[]{new Point(x1, y1), new Point(x2, y2)};
            return pts;
        }
        boolean outOfBound1 = false;
        boolean outOfBound2 = false;
        int xTop = xOrigin + this.chart.chartwidth;
        int yOrigin2 = this.chart.chartyorigin;
        int yTop = yOrigin2 + this.chart.chartheight;
        LOGGER.finest("Origin = (" + xOrigin + ", " + yOrigin2 + ")");
        LOGGER.finest("TOP = (" + xTop + ", " + yTop + ")");
        if (x1 < xOrigin || x1 > xTop) {
            outOfBound1 = true;
        }
        if (y1 < yOrigin2 || y1 > yTop) {
            outOfBound1 = true;
        }
        if (x2 < xOrigin || x2 > xTop) {
            outOfBound2 = true;
        }
        if (y2 < yOrigin2 || y2 > yTop) {
            outOfBound2 = true;
        }
        if (outOfBound1 && outOfBound2 && (y1 < yOrigin2 && y2 < yOrigin2 || y1 > yTop && y2 > yTop || x1 < xOrigin && x2 < xOrigin || x1 > xTop && x2 > xTop)) {
            return null;
        }
        if (!outOfBound1 && !outOfBound2) {
            Point[] pts = new Point[]{new Point(x1, y1), new Point(x2, y2)};
            return pts;
        }
        Point[] pt = this.calcIntersection(x1, y1, x2, y2, xOrigin, yOrigin2, xTop, yTop, outOfBound1, outOfBound2);
        if (pt == null) {
            return null;
        }
        return pt;
    }

    private Point[] calcIntersection(int x1, int y1, int x2, int y2, int xOrigin, int yOrigin, int xTop, int yTop, boolean getPt1, boolean getPt2) {
        Point pt;
        LOGGER.finest("**************FIND INTERSECTION ***************");
        Rectangle plane = this.getPlane(x1, y1, x2, y2);
        Rectangle plane2 = this.getPlane(xOrigin, yOrigin, xTop, yTop);
        Point[] pts = new Point[2];
        if (!getPt1) {
            pts[0] = new Point(x1, y1);
        }
        if (!getPt2) {
            pts[1] = new Point(x2, y2);
        }
        if (this.contains(plane, plane2, pt = this.findIntersection(x1, y1, x2, y2, xOrigin, yTop, xTop, yTop))) {
            LOGGER.finest("INTERSECT WITH UPPER LINE: " + pt);
            if (getPt1) {
                pts[0] = pt;
                getPt1 = false;
            } else if (getPt2) {
                pts[1] = pt;
                getPt2 = false;
            }
            if (!getPt1 && !getPt2) {
                return pts;
            }
        }
        if (this.contains(plane, plane2, pt = this.findIntersection(x1, y1, x2, y2, xOrigin, yOrigin, xOrigin, yTop))) {
            LOGGER.finest("INTERSECT WITH LEFTMOST LINE: " + pt);
            if (getPt1) {
                pts[0] = pt;
                getPt1 = false;
            } else if (getPt2) {
                pts[1] = pt;
                getPt2 = false;
            }
            if (!getPt1 && !getPt2) {
                return pts;
            }
        }
        if (this.contains(plane, plane2, pt = this.findIntersection(x1, y1, x2, y2, xOrigin, yOrigin, xTop, yOrigin))) {
            LOGGER.finest("INTERSECT WITH BOTTOM LINE: " + pt);
            if (getPt1) {
                pts[0] = pt;
                getPt1 = false;
            } else if (getPt2) {
                pts[1] = pt;
                getPt2 = false;
            }
            if (!getPt1 && !getPt2) {
                return pts;
            }
        }
        if (this.contains(plane, plane2, pt = this.findIntersection(x1, y1, x2, y2, xTop, yOrigin, xTop, yTop))) {
            LOGGER.finest("INTERSECT WITH RIGHTMOST LINE: " + pt);
            if (getPt1) {
                pts[0] = pt;
                getPt1 = false;
            } else if (getPt2) {
                pts[1] = pt;
                getPt2 = false;
            }
            if (!getPt1 && !getPt2) {
                return pts;
            }
        }
        return null;
    }

    private Point findIntersection(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) {
        double den = (y4 - y3) * (x2 - x1) - (x4 - x3) * (y2 - y1);
        if (den == 0.0) {
            return null;
        }
        double num = (x4 - x3) * (y1 - y3) - (y4 - y3) * (x1 - x3);
        double u = num / den;
        int x = (int)((double)x1 + u * (double)(x2 - x1));
        int y = (int)((double)y1 + u * (double)(y2 - y1));
        return new Point(x, y);
    }

    private Rectangle getPlane(int x1, int y1, int x2, int y2) {
        int delta = 1;
        int minX = x1;
        int minY = y1 > y2 ? y2 : y1;
        int w = x2 - x1;
        int h = Math.abs(y2 - y1);
        return new Rectangle(minX - delta, minY - delta, w + delta * 2, h + delta * 2);
    }

    private boolean contains(Rectangle plane, Rectangle plane2, Point pt) {
        if (pt == null) {
            return false;
        }
        if (!plane.contains(pt)) {
            return false;
        }
        return plane2.contains(pt);
    }

    @Override
    public void drawLine(CGraphics g, Point3D p, int thickness, MultiDimData primaryData) {
        if (this.level < this.chart.dataDim - 1) {
            for (int i = 0; i < this.multiData.length; ++i) {
                this.multiData[i].drawLine(g, this.point.automatic ? p : this.point, this.point.automatic ? thickness : this.lineThickness, primaryData.multiData[i]);
            }
        } else {
            int dataLineThickness;
            Color defaultColor = this.point.automatic ? p.color : this.point.color;
            int shape = this.point.automatic ? p.shape : this.point.shape;
            int n = dataLineThickness = this.point.automatic ? thickness : this.lineThickness;
            if (this.multiData.length != primaryData.multiData.length) {
                LOGGER.finest("primaryData.length = " + primaryData.multiData.length);
                LOGGER.finest("secondaryData.length = " + this.multiData.length);
            }
            for (int i = 0; i < this.multiData.length; ++i) {
                MultiDimData data = this.multiData[this.order[i]];
                MultiDimData pdata = primaryData.multiData[this.order[i]];
                if (data.plotData.isEmpty() || pdata.plotData.isEmpty()) continue;
                Point3D pcurrpoint = pdata.point;
                Point3D currpoint = data.point;
                if (currpoint.y > pcurrpoint.y) {
                    ((Chart2D)this.chart).horzVertLine2D.drawLineSegment(g, defaultColor, pcurrpoint.x, pcurrpoint.y, currpoint.x, currpoint.y, dataLineThickness, data, shape);
                    continue;
                }
                ((Chart2D)this.chart).horzVertLine2D.drawLineSegment(g, defaultColor, currpoint.x, currpoint.y, pcurrpoint.x, pcurrpoint.y, dataLineThickness, data, shape);
            }
        }
    }

    private void drawStepLine(CGraphics g, Point3D p, int thickness, double stepRatio) {
        Color defaultColor = this.point.automatic ? p.color : this.point.color;
        Point3D lastpoint = null;
        Point3D lastNonNull = null;
        int shape = this.point.automatic ? p.shape : this.point.shape;
        int dataLineThickness = this.point.automatic ? thickness : this.lineThickness;
        int dataLen = this.multiData.length;
        int cutOffY = -1;
        if (this.chart.isAreaCutOffSupport()) {
            cutOffY = this.chart.a_y.stepsize.interpolatePixel(this.chart.getAreaCutOffPoint());
        }
        for (int i = 0; i < dataLen; ++i) {
            MultiDimData data = i == this.multiData.length ? this.multiData[this.order[0]] : ((this.chart.chartType == 2 || this.chart.chartType == 19) && this.chart.isLineInOriginalOrder() ? this.multiData[i] : this.multiData[this.order[i]]);
            if (data.plotData.isEmpty()) {
                lastpoint = null;
                continue;
            }
            Point3D currpoint = data.point;
            if (this.chart.getLayout() == 0) {
                int rX = 0;
                if (lastpoint != null) {
                    rX = lastpoint.x + (int)((double)(currpoint.x - lastpoint.x) * stepRatio);
                    ((Chart2D)this.chart).horzVertLine2D.drawLineSegment(g, defaultColor, lastpoint.x, lastpoint.y, rX, lastpoint.y, dataLineThickness, data, shape, cutOffY);
                    ((Chart2D)this.chart).horzVertLine2D.drawLineSegment(g, defaultColor, rX, lastpoint.y, rX, currpoint.y, dataLineThickness, data, shape, cutOffY);
                    ((Chart2D)this.chart).horzVertLine2D.drawLineSegment(g, defaultColor, rX, currpoint.y, currpoint.x, currpoint.y, dataLineThickness, data, shape, cutOffY);
                } else if (lastNonNull != null && this.chart.showNulldataLine) {
                    if (!this.chart.isApplyLineStyleToNullData()) {
                        rX = lastNonNull.x + (int)((double)(currpoint.x - lastNonNull.x) * stepRatio);
                        ((Chart2D)this.chart).horzVertLine2D.drawLineSegment(g, defaultColor, lastNonNull.x, lastNonNull.y, rX, lastNonNull.y, 1, data, 657921, cutOffY);
                        ((Chart2D)this.chart).horzVertLine2D.drawLineSegment(g, defaultColor, rX, lastNonNull.y, rX, currpoint.y, 1, data, 657921, cutOffY);
                        ((Chart2D)this.chart).horzVertLine2D.drawLineSegment(g, defaultColor, rX, currpoint.y, currpoint.x, currpoint.y, 1, data, 657921, cutOffY);
                    } else {
                        rX = lastNonNull.x + (int)((double)(currpoint.x - lastNonNull.x) * stepRatio);
                        ((Chart2D)this.chart).horzVertLine2D.drawLineSegment(g, defaultColor, lastNonNull.x, lastNonNull.y, rX, lastNonNull.y, dataLineThickness, data, shape, cutOffY);
                        ((Chart2D)this.chart).horzVertLine2D.drawLineSegment(g, defaultColor, rX, lastNonNull.y, rX, currpoint.y, dataLineThickness, data, shape, cutOffY);
                        ((Chart2D)this.chart).horzVertLine2D.drawLineSegment(g, defaultColor, rX, currpoint.y, currpoint.x, currpoint.y, dataLineThickness, data, shape, cutOffY);
                    }
                }
            } else {
                int rY = 0;
                if (lastpoint != null) {
                    rY = lastpoint.y + (int)((double)(currpoint.y - lastpoint.y) * stepRatio);
                    ((Chart2D)this.chart).horzVertLine2D.drawLineSegment(g, defaultColor, lastpoint.x, lastpoint.y, lastpoint.x, rY, dataLineThickness, data, shape, cutOffY);
                    ((Chart2D)this.chart).horzVertLine2D.drawLineSegment(g, defaultColor, lastpoint.x, rY, currpoint.x, rY, dataLineThickness, data, shape, cutOffY);
                    ((Chart2D)this.chart).horzVertLine2D.drawLineSegment(g, defaultColor, currpoint.x, rY, currpoint.x, currpoint.y, dataLineThickness, data, shape, cutOffY);
                } else if (lastNonNull != null && this.chart.showNulldataLine) {
                    if (!this.chart.isApplyLineStyleToNullData()) {
                        rY = lastNonNull.y + (int)((double)(currpoint.y - lastNonNull.y) * stepRatio);
                        ((Chart2D)this.chart).horzVertLine2D.drawLineSegment(g, defaultColor, lastNonNull.x, lastNonNull.y, lastNonNull.x, rY, 1, data, 657921, cutOffY);
                        ((Chart2D)this.chart).horzVertLine2D.drawLineSegment(g, defaultColor, lastNonNull.x, rY, currpoint.x, rY, 1, data, 657921, cutOffY);
                        ((Chart2D)this.chart).horzVertLine2D.drawLineSegment(g, defaultColor, currpoint.x, rY, currpoint.x, currpoint.y, 1, data, 657921, cutOffY);
                    } else {
                        rY = lastNonNull.y + (int)((double)(currpoint.y - lastNonNull.y) * stepRatio);
                        ((Chart2D)this.chart).horzVertLine2D.drawLineSegment(g, defaultColor, lastNonNull.x, lastNonNull.y, lastNonNull.x, rY, dataLineThickness, data, shape, cutOffY);
                        ((Chart2D)this.chart).horzVertLine2D.drawLineSegment(g, defaultColor, lastNonNull.x, rY, currpoint.x, rY, dataLineThickness, data, shape, cutOffY);
                        ((Chart2D)this.chart).horzVertLine2D.drawLineSegment(g, defaultColor, currpoint.x, rY, currpoint.x, currpoint.y, dataLineThickness, data, shape, cutOffY);
                    }
                }
            }
            lastpoint = currpoint;
            lastNonNull = currpoint;
        }
    }

    @Override
    public void prepare3DPoint(Object sp, double thick, Point3D p) {
    }

    @Override
    public void prepare3DLine(Object sp, double thick, double height, Point3D p, boolean bvertical) {
    }

    @Override
    public void prepare3DBox(Object sp) {
    }

    @Override
    public void prepare3DPie(Object sp, double thick) {
    }

    @Override
    public void prepare3DDoughnut(Object sp, double thick) {
    }

    @Override
    public void prepare3DPoint(Object sp, double thick) {
    }

    @Override
    public void prepare3DLine(Object sp, double thick, double height, boolean bvertical) {
    }

    @Override
    public void prepare3DLine(Object sp, double thick, double height) {
    }

    @Override
    public void prepare3DArea(Object sp, double thick, int zeroAxis) {
    }

    @Override
    public void prepare3DStackArea(Object sp, double thick, int zeroAxis) {
    }

    @Override
    public void prepare3DArea(Object sp, double thick, int zeroAxis, Area parea) {
    }

    @Override
    public void prepare3DStackArea(Object sp, double thick, int zeroAxis, Area parea) {
    }

    @Override
    public void addArea(Object sp, Point3D p1, Point3D p2, Point3D p3, Point3D p4, double thick, Area parea) {
    }

    @Override
    public void prepare3DPie(Object sp, double thick, Area parea) {
    }

    @Override
    public void drawHLCOArea(CGraphics g, Area parea) {
        ((IHLCOChart)((Object)this.chart)).drawSym(g, this.area.automatic ? parea.areaColor : this.area.areaColor, this.area.p1.x, this.area.p2.x, this.hilow, this, this.chart.candleStick);
    }

    @Override
    public void drawPoint3D(CGraphics g, Point3D p) {
        int originx = this.chart.chartxorigin;
        int topx = this.chart.chartxorigin + this.chart.chartwidth;
        if (this.point.x > topx || this.point.x < originx) {
            this.point.x = -100;
        }
        int originy = this.chart.chartyorigin;
        int topy = this.chart.chartyorigin + this.chart.chartheight;
        if (this.point.y > topy || this.point.y < originy) {
            this.point.y = -100;
        }
        if (this.isPointVisible()) {
            if (this.chart.chartType == 13) {
                this.point.drawBubble(g, this.point.automatic ? p.color : this.point.color, ((Coordinate)this.plotData.element).z);
            } else {
                this.point.setBorderColor(this.isPrimary() ? this.chart.getDrawPointBorderColor() : this.chart.getDrawPointBorderColor2());
                this.point.drawPt(g, this.point.automatic ? p : this.point, this.isPrimary() ? this.chart.isDrawPointBorder() : this.chart.isDrawPointBorder2(), this.isPrimary() ? this.chart.getDrawPointBorderColor() : this.chart.getDrawPointBorderColor2(), this, this.isPrimary() ? this.chart.getPrimaryDataGradientSupport() : this.chart.getSecondaryDataGradientSupport());
            }
        }
    }

    @Override
    public void randomColor(Point3D p) {
    }

    @Override
    public void setFaceColor(Area parea) {
    }

    @Override
    public void setFaceColor(Color color) {
    }

    @Override
    public void prepare3DBox(Object sp, Area parea) {
    }

    @Override
    public Object select(CGraphics g, int x, int y, int chartType, boolean isStep) {
        return this.select(g, x, y, chartType, isStep, 0);
    }

    private Object select(CGraphics g, int x, int y, int chartType, boolean isStep, int idx) {
        if (chartType == 14) {
            return this.selectOverlay(g, x, y);
        }
        if (chartType == 7) {
            return this.selectArea(g, x, y);
        }
        if (chartType == 8) {
            return this.selectStackArea(g, x, y);
        }
        if (this.level < this.chart.dataDim) {
            int lineno;
            if (this.chart.dataDim > 1) {
                int lineno2;
                if (this.level == this.chart.dataDim - 1 && this.chart.showLine && (lineno2 = this.selectLine(g, x, y, isStep)) >= 0) {
                    return this.multiData[lineno2];
                }
                int tmpLen = this.multiData.length - 1;
                if (chartType == 18) {
                    for (int i = 0; i <= tmpLen; ++i) {
                        Object target = ((MultiDimData2D)this.multiData[i]).select(g, x, y, chartType, this.chart.selectStep == null || i >= this.chart.selectStep.length ? false : this.chart.selectStep[i], i);
                        if (target == null) continue;
                        return target;
                    }
                } else {
                    for (int i = tmpLen; i >= 0; --i) {
                        Object target = ((MultiDimData2D)this.multiData[i]).select(g, x, y, chartType, this.chart.selectStep == null || i >= this.chart.selectStep.length ? false : this.chart.selectStep[i], i);
                        if (target == null) continue;
                        return target;
                    }
                }
                return null;
            }
            if (this.chart.showLine && (lineno = this.selectLine(g, x, y, this.chart.selectStep == null ? false : this.chart.selectStep[0])) >= 0) {
                if (this.chart.dataDim == 1 && (this.chart.getChartType() == 0 || this.chart.getChartType() == 1)) {
                    return this;
                }
                return this.multiData[lineno];
            }
            for (int i = this.multiData.length - 1; i >= 0; --i) {
                Object target = this.multiData[i].select(g, x, y, chartType, this.chart.selectStep == null ? false : this.chart.selectStep[0]);
                if (target == null) continue;
                return target;
            }
            return null;
        }
        if (this.chart.showPoint && chartType == 13) {
            if (!this.isPointVisible()) {
                return null;
            }
            return this.point.isInsideBubble(g, ((Coordinate)this.plotData.element).z, x, g.height - y) ? this : null;
        }
        if (this.chart.showPoint && (chartType == 2 || chartType == 19 || chartType == 3 || chartType == 16)) {
            if (chartType == 2 && this.chart.getAreaState() && this.area.select(g, x, y)) {
                return this;
            }
            if (!(chartType != 2 && chartType != 19 || this.isPointVisible())) {
                return null;
            }
            if (this.plotData.isEmpty()) {
                return null;
            }
            int dx = this.point.x - x;
            int dy = g.height - this.point.y - y;
            return dx * dx + dy * dy < 40 ? this : null;
        }
        if (this.chart.chartType == 6) {
            return this.selectPie(g, x, y, idx);
        }
        if (this.chart.chartType == 20) {
            return this.selectDoughnut(g, x, y, idx);
        }
        if (this.area.select(g, x, y)) {
            return this;
        }
        return this.area2 == null ? null : (this.area2.select(g, x, y) ? this : null);
    }

    @Override
    public Object select2(CGraphics g, int x, int y) {
        return this.select2(g, x, y, this.chart.selectStep == null ? false : this.chart.selectStep[0]);
    }

    private Object select2(CGraphics g, int x, int y, boolean isStep) {
        if (this.chart.isStackType()) {
            return StackChart.selectLine(g, x, y, this, this.chart.mDataLen, this.chart.dataDim);
        }
        if (this.level < this.chart.dataDim) {
            int lineno;
            if (this.level == this.chart.dataDim - 1 && this.chart.showLine2 && (lineno = this.selectLine(g, x, y, isStep)) >= 0) {
                return this.multiData[lineno];
            }
            for (int i = 0; i < this.multiData.length; ++i) {
                Object target = ((MultiDimData2D)this.multiData[i]).select2(g, x, y, this.chart.selectStep == null || i >= this.chart.selectStep.length ? false : this.chart.selectStep[i]);
                if (target == null) continue;
                return target;
            }
            return null;
        }
        if (this.chart.showPoint2 && this.isPointVisible()) {
            if (this.plotData.isEmpty()) {
                return null;
            }
            int dx = this.point.x - x;
            int dy = g.height - this.point.y - y;
            return dx * dx + dy * dy < 40 ? this : null;
        }
        return null;
    }

    private Object selectOverlay(CGraphics g, int x, int y) {
        Object target = null;
        if (this.chart.dataDim == 1) {
            return this.select(g, x, y, 0);
        }
        target = this.selectOverlayLine(g, x, y);
        if (target != null) {
            return target;
        }
        target = this.selectOverlayArea(g, x, y);
        if (target != null) {
            return target;
        }
        return target;
    }

    Object selectOverlayLine(CGraphics g, int x, int y) {
        Object target = null;
        int[] seriesType = this.chart.getSeriesType();
        for (int i = this.chart.getSeriesType().length - 1; i >= 0; --i) {
            int chartType = seriesType[i];
            if (chartType != 3) continue;
            boolean tmp = this.chart.showLine;
            this.chart.showLine = true;
            target = this.multiData[i].select(g, x, y, chartType);
            this.chart.showLine = tmp;
            if (target == null) continue;
            return target;
        }
        return target;
    }

    Object selectOverlayArea(CGraphics g, int x, int y) {
        int chartType;
        int i;
        Object target = null;
        int[] seriesType = this.chart.getSeriesType();
        for (i = this.chart.getSeriesType().length - 1; i >= 0; --i) {
            chartType = seriesType[i];
            if (chartType != 0 || (target = this.multiData[i].select(g, x, y, chartType)) == null) continue;
            return target;
        }
        for (i = this.chart.getSeriesType().length - 1; i >= 0; --i) {
            chartType = seriesType[i];
            if (chartType != 7) continue;
            Point3D[] points = this.chart.a_x.ticker.point;
            for (int j = 0; j < this.chart.mDataLen[1] - 1; ++j) {
                Polygon p = new Polygon();
                p.addPoint(this.multiData[i].multiData[j].point.x, g.height - this.multiData[i].multiData[j].point.y);
                p.addPoint(this.multiData[i].multiData[j + 1].point.x, g.height - this.multiData[i].multiData[j + 1].point.y);
                p.addPoint(points[j + 1].x, g.height - this.chart.yAxisCenter);
                p.addPoint(points[j].x, g.height - this.chart.yAxisCenter);
                if (!p.contains(x, y)) continue;
                target = this.multiData[i].multiData[j].plotData.isEmpty() ? this.multiData[i].multiData[j + 1] : this.multiData[i].multiData[j];
            }
            if (target == null) continue;
            return target;
        }
        return target;
    }

    @Override
    public int selectLine(CGraphics g, int x, int y) {
        return this.selectLine(g, x, y, false);
    }

    private int selectLine(CGraphics g, int x, int y, boolean isStep) {
        Point3D lastpoint = null;
        int dataLen = this.multiData.length;
        if (this.chart.getChartType() == 16) {
            ++dataLen;
        }
        if (this.lineThickness > 0) {
            for (int i = 0; i < dataLen; ++i) {
                int pos = this.order[0];
                if (i < this.multiData.length) {
                    pos = (this.chart.chartType == 2 || this.chart.chartType == 19) && this.chart.isLineInOriginalOrder() ? i : this.order[i];
                }
                if (this.multiData[pos].plotData.isEmpty()) {
                    lastpoint = null;
                    continue;
                }
                Point3D currpoint = this.multiData[pos].point;
                if (lastpoint != null) {
                    if (isStep) {
                        int y1 = g.height - lastpoint.y;
                        int y2 = g.height - currpoint.y;
                        int x1 = lastpoint.x;
                        int x2 = currpoint.x;
                        if (this.chart.getLayout() == 0) {
                            int xr = x1 + (int)((double)(x2 - x1) * (this.isPrimary() ? this.chart.getStepLineRatio() : this.chart.getStepLineRatio2()));
                            if (Line.pickLine(x1, y1, xr, y1, x, y) || Line.pickLine(xr, y1, xr, y2, x, y) || Line.pickLine(xr, y2, x2, y2, x, y)) {
                                if (Math.abs(x2 - x) > Math.abs(x - x1)) {
                                    return pos - 1;
                                }
                                if (Math.abs(x2 - x) == Math.abs(x - x1)) {
                                    if (Math.abs(y2 - y) > Math.abs(y - y1)) {
                                        return pos - 1;
                                    }
                                    return pos;
                                }
                                return pos;
                            }
                        } else {
                            int yr = y1 + (int)((double)(y2 - y1) * (this.isPrimary() ? this.chart.getStepLineRatio() : this.chart.getStepLineRatio2()));
                            if (Line.pickLine(x1, y1, x1, yr, x, y) || Line.pickLine(x1, yr, x2, yr, x, y) || Line.pickLine(x2, yr, x2, y2, x, y)) {
                                if (Math.abs(y2 - y) > Math.abs(y - y1)) {
                                    return pos - 1;
                                }
                                if (Math.abs(y2 - y) == Math.abs(y - y1)) {
                                    if (Math.abs(x2 - x) > Math.abs(x - x1)) {
                                        return pos - 1;
                                    }
                                    return pos;
                                }
                                return pos;
                            }
                        }
                    } else if (Line.pickLine(lastpoint.x, g.height - lastpoint.y, currpoint.x, g.height - currpoint.y, x, y)) {
                        if (Math.abs(currpoint.x - x) > Math.abs(x - lastpoint.x)) {
                            return pos - 1;
                        }
                        return pos;
                    }
                }
                lastpoint = currpoint;
            }
        }
        return -1;
    }

    @Override
    public MultiDimData selectArea(CGraphics g, int x, int y) {
        Point3D[] points = this.chart.a_x.ticker.point;
        if (this.chart.dataDim == 1) {
            for (int i = 0; i < this.chart.mDataLen[0] - 1; ++i) {
                Polygon p = new Polygon();
                p.addPoint(this.multiData[i].point.x, g.height - this.multiData[i].point.y);
                p.addPoint(this.multiData[i + 1].point.x, g.height - this.multiData[i + 1].point.y);
                p.addPoint(points[i + 1].x, g.height - this.chart.yAxisCenter);
                p.addPoint(points[i].x, g.height - this.chart.yAxisCenter);
                if (!p.contains(x, y)) continue;
                return this.multiData[i].plotData.isEmpty() ? this.multiData[i + 1] : this.multiData[i];
            }
        } else {
            for (int i = this.chart.mDataLen[0] - 1; i >= 0; --i) {
                for (int j = 0; j < this.chart.mDataLen[1] - 1; ++j) {
                    Polygon p = new Polygon();
                    p.addPoint(this.multiData[i].multiData[j].point.x, g.height - this.multiData[i].multiData[j].point.y);
                    p.addPoint(this.multiData[i].multiData[j + 1].point.x, g.height - this.multiData[i].multiData[j + 1].point.y);
                    p.addPoint(points[j + 1].x, g.height - this.chart.yAxisCenter);
                    p.addPoint(points[j].x, g.height - this.chart.yAxisCenter);
                    if (!p.contains(x, y)) continue;
                    return this.multiData[i].multiData[j].plotData.isEmpty() ? this.multiData[i].multiData[j + 1] : this.multiData[i].multiData[j];
                }
            }
        }
        return null;
    }

    @Override
    public MultiDimData selectStackArea(CGraphics g, int x, int y) {
        Point3D[] points = this.chart.a_x.ticker.point;
        boolean[] hide = this.chart.colData[this.chart.mDataMap[1]].hideData;
        for (int i = 0; i < this.chart.mDataLen[0] - 1; ++i) {
            int lasty2;
            int lastx1 = points[i].x;
            int lastx2 = points[i + 1].x;
            int lasty1 = lasty2 = this.chart.yAxisCenter;
            for (int j = 0; j < this.chart.mDataLen[1]; ++j) {
                boolean hideDataArea;
                Polygon p = new Polygon();
                p.addPoint(lastx2, g.height - lasty2);
                p.addPoint(lastx1, g.height - lasty1);
                lastx1 = this.multiData[i].multiData[j].point.x;
                lasty1 = this.multiData[i].multiData[j].point.y;
                lastx2 = this.multiData[i + 1].multiData[j].point.x;
                lasty2 = this.multiData[i + 1].multiData[j].point.y;
                p.addPoint(lastx1, g.height - lasty1);
                p.addPoint(lastx2, g.height - lasty2);
                boolean bl = hideDataArea = hide == null ? false : hide[j];
                if (hideDataArea || !p.contains(x, y)) continue;
                return this.multiData[i].multiData[j].plotData.isEmpty() ? this.multiData[i + 1].multiData[j] : this.multiData[i].multiData[j];
            }
        }
        return null;
    }

    @Override
    public MultiDimData selectPie(CGraphics g, int x, int y) {
        return this.selectPie(g, x, y, 0);
    }

    private MultiDimData selectPie(CGraphics g, int x, int y, int idx) {
        PieChart pchart = ((IPieChart)((Object)this.chart)).getPieChart();
        if (this.chart.dataDim == 1) {
            idx = 0;
        }
        if (this.chart.mDataLen[0] == 1) {
            return this.insideArc(pchart.center[idx].x, pchart.center[idx].y, pchart.piewidth[idx], pchart.pieheight[idx], 0, 360, x, y) ? this : null;
        }
        if (this.plotData.bSlice) {
            double angle = (this.arcAngle.start + this.arcAngle.angle / 2.0) * Math.PI / 180.0;
            return this.insideArc((int)((double)pchart.center[idx].x + (double)pchart.piewidth[idx] * pchart.sliceDistance * Math.cos(angle) / 2.0), (int)((double)g.height - ((double)pchart.center[idx].y + (double)pchart.pieheight[idx] * pchart.sliceDistance * Math.sin(angle) / 2.0)), pchart.piewidth[idx], pchart.pieheight[idx], (int)this.arcAngle.start, (int)this.arcAngle.angle, x, y) ? this : null;
        }
        return this.insideArc(pchart.center[idx].x, g.height - pchart.center[idx].y, pchart.piewidth[idx], pchart.pieheight[idx], (int)this.arcAngle.start, (int)this.arcAngle.angle, x, y) ? this : null;
    }

    private MultiDimData selectDoughnut(CGraphics g, int x, int y, int idx) {
        PieChart pchart = ((IPieChart)((Object)this.chart)).getPieChart();
        if (this.chart.dataDim == 1) {
            idx = 0;
        }
        if (this.chart.mDataLen[0] == 1) {
            return this.insideDoughnutArc(pchart.center[idx].x, pchart.center[idx].y, pchart.piewidth[idx], pchart.pieheight[idx], 0, 360, x, y) ? this : null;
        }
        if (this.plotData.bSlice) {
            double angle = (this.arcAngle.start + this.arcAngle.angle / 2.0) * Math.PI / 180.0;
            return this.insideDoughnutArc((int)((double)pchart.center[idx].x + (double)pchart.piewidth[idx] * pchart.sliceDistance * Math.cos(angle) / 2.0), (int)((double)g.height - ((double)pchart.center[idx].y + (double)pchart.pieheight[idx] * pchart.sliceDistance * Math.sin(angle) / 2.0)), pchart.piewidth[idx], pchart.pieheight[idx], (int)this.arcAngle.start, (int)this.arcAngle.angle, x, y) ? this : null;
        }
        return this.insideDoughnutArc(pchart.center[idx].x, g.height - pchart.center[idx].y, pchart.piewidth[idx], pchart.pieheight[idx], (int)this.arcAngle.start, (int)this.arcAngle.angle, x, y) ? this : null;
    }

    private int getStackYPos(Area area) {
        int alignment = this.chart.stackLabel_Alignment;
        return this.getYPos(area, false, alignment);
    }

    private int getYPos(Area area, boolean reverse) {
        return this.getYPos(area, reverse, this.chart.topLabel_Alignment);
    }

    private int getYPos(Area area, boolean reverse, int alignment) {
        if (alignment == 0 || alignment == 3) {
            return !reverse ? area.p1.y : area.p2.y;
        }
        if (alignment == 4 || alignment == 2) {
            return !reverse ? area.p2.y : area.p1.y;
        }
        return (area.p1.y + area.p2.y) / 2;
    }

    private int getStackXPos(Area area) {
        int alignment = this.chart.stackLabel_Alignment;
        int areaW = Math.abs(area.p1.x - area.p2.x);
        if (areaW < this.labelHeight2D * 2) {
            return (area.p1.x + area.p2.x) / 2;
        }
        if (alignment == 0 || alignment == 3) {
            return area.p1.x;
        }
        if (alignment == 4 || alignment == 2) {
            return area.p2.x;
        }
        return (area.p1.x + area.p2.x) / 2;
    }

    private boolean showStackY(Area area) {
        if (SHOW_STACK_LABEL_REGARDLESS_OF_SIZE) {
            return true;
        }
        return Math.abs(area.p1.y - area.p2.y) >= this.labelHeight2D;
    }

    private boolean showStackX(Area area, String str) {
        int width;
        if (this.chart.cgraphics != null) {
            CString tmpString = new CString(str, this.chart.topvalueLabel_font, null, this.chart.topvalueLabel_color, 0, this.chart.topvalueLabel_angle);
            width = tmpString.getWidth(this.chart.cgraphics);
        } else {
            width = this.labelHeight2D;
        }
        return Math.abs(area.p1.x - area.p2.x) >= (width += this.chart.dataBorderThickness + 2);
    }

    private int getOffsetUp() {
        return this.getOffsetUp(this.chart.topLabel_Alignment);
    }

    private int getStackOffsetUp() {
        return this.getOffsetUp(this.chart.stackLabel_Alignment);
    }

    private int getOffsetUp(int alignment) {
        int offset = this.chart.toplabel_offset_up;
        if (alignment == 3) {
            offset -= this.labelHeight2D;
        } else if (alignment == 2) {
            offset -= this.labelHeight2D * 2;
        } else if (alignment == 1) {
            offset -= 10;
        }
        return offset;
    }

    private void set2DLabelHeight() {
        int h = this.getTopLabelHeight();
        if (h == 0) {
            this.labelHeight2D = 300;
        }
        if (h > 10) {
            this.labelHeight2D = h;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void prepare_stacklabel(boolean bcreate) {
        if (this.level < this.chart.dataDim - 1) {
            for (MultiDimData element : this.multiData) {
                element.prepare_stacklabel(bcreate);
            }
        } else {
            this.set2DLabelHeight();
            double total1 = 0.0;
            double total2 = 0.0;
            Area armax = null;
            Area armin = null;
            if (this.chart.chartType == 4) {
                for (MultiDimData element : this.multiData) {
                    double d;
                    double t = element.plotData.getValue();
                    if (d >= 0.0) {
                        total1 += t;
                        armax = element.area;
                        LOGGER.finest("MULTIDIMDATA 2D - CP 1");
                        if ((!this.chart.getStackLabelState() || !this.showStackY(armax)) && !(this.chart.cgraphics.g instanceof IFlashGraphics)) continue;
                        this.addLabels(bcreate, this.chart.topvalueLabel_color, new Point3D((armax.p1.x + armax.p2.x) / 2 + this.chart.toplabel_offset_side, this.getStackYPos(armax) + this.getStackOffsetUp()), t == 0.0 && element.plotData.isEmpty() ? " " : this.chart.getFormatValue((MultiDimData)this, t), 0, element, null, this.chart.getStackLabelState() && this.showStackY(armax));
                        continue;
                    }
                    total2 += t;
                    armin = element.area;
                    Color strColor = this.chart.topvalueLabel_color;
                    if (this.chart.topvalueNegativeLabel_color != null) {
                        strColor = this.chart.topvalueNegativeLabel_color;
                    }
                    if ((!this.chart.getStackLabelState() || !this.showStackY(armin)) && !(this.chart.cgraphics.g instanceof IFlashGraphics)) continue;
                    this.addLabels(bcreate, strColor, new Point3D((armin.p1.x + armin.p2.x) / 2 + this.chart.toplabel_offset_side, this.getStackYPos(armin) - this.getStackOffsetUp()), this.chart.getFormatValue((MultiDimData)this, t), 0, element, null, this.chart.getStackLabelState() && this.showStackY(armin));
                }
                if (armax != null && (this.chart.getStackTotalLabelState() || !this.chart.getStackLabelState())) {
                    int[] nArray = this.getAreaPoints(armax);
                    this.addLabels(bcreate, this.chart.topvalueLabel_color, new Point3D((armax.p1.x + armax.p2.x) / 2 + this.chart.toplabel_offset_side, nArray[1] + this.getOffsetUp()), this.chart.getFormatValue((MultiDimData)this, total1), 0);
                }
                if (armin != null && (this.chart.getStackTotalLabelState() || !this.chart.getStackLabelState())) {
                    int[] nArray = this.getAreaPoints(armin);
                    Color strColor = this.chart.topvalueLabel_color;
                    if (this.chart.topvalueNegativeLabel_color != null) {
                        strColor = this.chart.topvalueNegativeLabel_color;
                    }
                    this.addLabels(bcreate, strColor, new Point3D((armin.p1.x + armin.p2.x) / 2 + this.chart.toplabel_offset_side, nArray[1] - this.getOffsetUp()), this.chart.getFormatValue((MultiDimData)this, total2), 0);
                }
            } else if (this.chart.chartType == 5) {
                for (MultiDimData element : this.multiData) {
                    double d;
                    double t = element.plotData.getValue();
                    if (d >= 0.0) {
                        String str;
                        total1 += t;
                        armax = element.area;
                        String string = str = t == 0.0 && element.plotData.isEmpty() ? " " : this.chart.getFormatValue((MultiDimData)this, t);
                        if ((!this.chart.getStackLabelState() || !this.showStackX(armax, str)) && !(this.chart.cgraphics.g instanceof IFlashGraphics)) continue;
                        int align = this.getCStringAlignForBarChart(this.chart.stackLabel_Alignment, false);
                        this.addLabels(bcreate, this.chart.topvalueLabel_color, new Point3D(this.getStackXPos(armax) + this.getOffsetLeft(this.chart.stackLabel_Alignment), (armax.p2.y + armax.p1.y) / 2 + this.chart.toplabel_offset_side), str, align, element, null, this.chart.getStackLabelState() && this.showStackX(armax, str));
                        continue;
                    }
                    total2 += t;
                    armin = element.area;
                    Color strColor = this.chart.topvalueLabel_color;
                    String str = this.chart.getFormatValue((MultiDimData)this, t);
                    if (this.chart.topvalueNegativeLabel_color != null) {
                        strColor = this.chart.topvalueNegativeLabel_color;
                    }
                    if ((!this.chart.getStackLabelState() || !this.showStackX(armin, str)) && !(this.chart.cgraphics.g instanceof IFlashGraphics)) continue;
                    int align = this.getCStringAlignForBarChart(this.chart.stackLabel_Alignment, true);
                    this.addLabels(bcreate, strColor, new Point3D(this.getStackXPos(armin) - this.getOffsetLeft(this.chart.stackLabel_Alignment), (armin.p2.y + armin.p1.y) / 2 + this.chart.toplabel_offset_side), str, align, element, null, this.chart.getStackLabelState() && this.showStackX(armin, str));
                }
                if (armax != null && (this.chart.getStackTotalLabelState() || !this.chart.getStackLabelState())) {
                    int[] nArray = this.getAreaPoints(armax);
                    int align = this.getCStringAlignForBarChart(this.chart.topLabel_Alignment, false);
                    this.addLabels(bcreate, this.chart.topvalueLabel_color, new Point3D(nArray[0] + this.getOffsetUp(), (armax.p2.y + armax.p1.y) / 2 + this.chart.toplabel_offset_side), this.chart.getFormatValue((MultiDimData)this, total1), align);
                }
                if (armin != null && (this.chart.getStackTotalLabelState() || !this.chart.getStackLabelState())) {
                    int[] nArray = this.getAreaPoints(armin);
                    Color strColor = this.chart.topvalueLabel_color;
                    int align = this.getCStringAlignForBarChart(this.chart.topLabel_Alignment, true);
                    if (this.chart.topvalueNegativeLabel_color != null) {
                        strColor = this.chart.topvalueNegativeLabel_color;
                    }
                    this.addLabels(bcreate, strColor, new Point3D(nArray[0] - this.getOffsetUp(), (armin.p2.y + armin.p1.y) / 2 + this.chart.toplabel_offset_side), this.chart.getFormatValue((MultiDimData)this, total2), align);
                }
            } else {
                void var10_22;
                Point3D point3D;
                total1 = 0.0;
                Point3D pmin = point3D = this.multiData[0].point;
                double t = -1.7976931348623157E308;
                double t2 = Double.MAX_VALUE;
                for (MultiDimData element : this.multiData) {
                    double d;
                    total1 += element.plotData.getValue();
                    if (d > t) {
                        t = total1;
                    }
                    if (total1 < t2) {
                        t2 = total1;
                    }
                    if (element.point.y > var10_22.y) {
                        Point3D point3D2 = element.point;
                        continue;
                    }
                    if (element.point.y >= pmin.y) continue;
                    pmin = element.point;
                }
                if (this.chart.getStackLabelState() || this.chart.cgraphics.g instanceof IFlashGraphics) {
                    int previousPt = this.chart.a_y.stepsize.zeroAxis;
                    for (MultiDimData element : this.multiData) {
                        Point3D tmp = element.point;
                        Point3D flashtmp = element.flashPoint;
                        double value = element.plotData.getValue();
                        boolean isEmpty = element.plotData.isEmpty();
                        Color strColor = this.chart.topvalueLabel_color;
                        if (this.chart.topvalueNegativeLabel_color != null && element.plotData.getValue() < 0.0) {
                            strColor = this.chart.topvalueNegativeLabel_color;
                        }
                        armax = new Area2D();
                        armax.p2.y = previousPt;
                        armax.p1.y = tmp.y;
                        if (this.showStackY(armax) && this.chart.getStackLabelState() || this.chart.cgraphics.g instanceof IFlashGraphics) {
                            this.addLabels(bcreate, strColor, new Point3D(tmp.x + this.chart.toplabel_offset_side, this.getStackYPos(armax) + this.getStackOffsetUp()), value == 0.0 && isEmpty ? " " : this.chart.getFormatValue((MultiDimData)this, value), 0, element, new Point3D(flashtmp.x + this.chart.toplabel_offset_side, element.plotData.getValue() >= 0.0 ? flashtmp.y + this.chart.toplabel_offset_up : flashtmp.y - this.chart.toplabel_offset_up), this.showStackY(armax) && this.chart.getStackLabelState());
                        }
                        previousPt = tmp.y;
                    }
                }
                if (this.chart.getStackTotalLabelState() || !this.chart.getStackLabelState()) {
                    Color strColor = this.chart.topvalueLabel_color;
                    if (this.chart.topvalueNegativeLabel_color != null && total1 < 0.0) {
                        strColor = this.chart.topvalueNegativeLabel_color;
                    }
                    this.addLabels(bcreate, strColor, new Point3D(var10_22.x + this.chart.toplabel_offset_side, total1 >= 0.0 ? var10_22.y + this.chart.toplabel_offset_up : pmin.y - this.chart.toplabel_offset_up), this.chart.getFormatValue((MultiDimData)this, total1 >= 0.0 ? t : t2), 0);
                }
            }
        }
    }

    private boolean showLabel(Area area, String str) {
        if (!this.chart.isStackType()) {
            return true;
        }
        if (this.chart.topLabel_Alignment == 3 || this.chart.topLabel_Alignment == 1 || this.chart.topLabel_Alignment == 4 || this.chart.topLabel_Alignment == 0) {
            if (!DataLine.isBarChartType(this.chart)) {
                return this.showStackY(area);
            }
            return this.showStackX(area, str);
        }
        return true;
    }

    private int[] getAreaPoints(Area area) {
        int p1Y = area.p1.y;
        int p2Y = area.p2.y;
        int p1X = area.p1.x;
        int p2X = area.p2.x;
        if (this.chart.topLabel_Alignment == 2 || this.chart.topLabel_Alignment == 4) {
            if (this.chart.a_y.stepsize != null) {
                p1Y = this.chart.a_y.stepsize.zeroAxis;
                p2Y = this.chart.a_y.stepsize.zeroAxis;
            }
            if (this.chart.a_x.stepsize != null) {
                p1X = this.chart.a_x.stepsize.zeroAxis;
                p2X = this.chart.a_x.stepsize.zeroAxis;
            }
        } else if (this.chart.topLabel_Alignment == 1) {
            if (this.chart.a_y.stepsize != null) {
                p1Y = (p1Y + this.chart.a_y.stepsize.zeroAxis) / 2;
                p2Y = (p2Y + this.chart.a_y.stepsize.zeroAxis) / 2;
            }
            if (this.chart.a_x.stepsize != null) {
                p1X = (p1X + this.chart.a_x.stepsize.zeroAxis) / 2;
                p2X = (p2X + this.chart.a_x.stepsize.zeroAxis) / 2;
            }
        }
        return new int[]{p1X, p1Y, p2X, p2Y};
    }

    @Override
    public void prepare_label(boolean bcreate) {
        if (this.level < this.chart.dataDim) {
            for (MultiDimData element : this.multiData) {
                element.prepare_label(bcreate);
            }
        } else if (this.plotData.element != null) {
            this.set2DLabelHeight();
            int offset = this.getOffsetUp();
            int x = 0;
            int y = 0;
            int fx = 0;
            int fy = 0;
            Color strColor = this.chart.topvalueLabel_color;
            if (this.plotData.element instanceof HiLowData) {
                double value;
                double baseValue = this.chart.a_y.logScale ? this.chart.a_y.exp(this.chart.a_y.getAxisShift()) : this.chart.a_y.getAxisShift();
                HiLowData hilow = (HiLowData)this.plotData.element;
                x = (this.area.p1.x + this.area.p2.x) / 2 + this.chart.toplabel_offset_side;
                y = this.getYPos(this.area, false) + offset;
                boolean bclose = hilow.vclose != -1.7976931348623157E308;
                double d = value = bclose ? hilow.vclose : hilow.vhi;
                if (value < baseValue && this.chart.topvalueNegativeLabel_color != null) {
                    strColor = this.chart.topvalueNegativeLabel_color;
                }
                this.addLabels(bcreate, strColor, new Point3D(x, y), this.chart.getFormatValue((MultiDimData)this, bclose ? hilow.vclose : hilow.vhi), 0);
                if (!bclose) {
                    x = (this.area.p1.x + this.area.p2.x) / 2 + this.chart.toplabel_offset_side;
                    y = (this.area2 == null ? this.getYPos(this.area, true) : this.getYPos(this.area2, true)) - offset;
                    value = hilow.vlow;
                    strColor = this.chart.topvalueLabel_color;
                    if (value < baseValue && this.chart.topvalueNegativeLabel_color != null) {
                        strColor = this.chart.topvalueNegativeLabel_color;
                    }
                    this.addLabels(bcreate, strColor, new Point3D(x, y), this.chart.getFormatValue((MultiDimData)this, hilow.vlow), 0);
                }
            } else {
                String s;
                double baseValue = 0.0;
                double value = this.plotData.getValue();
                if (!this.showLabel(this.area, value + "")) {
                    return;
                }
                int[] pts = this.getAreaPoints(this.area);
                int p1X = pts[0];
                int p1Y = pts[1];
                int p2X = pts[2];
                int p2Y = pts[3];
                switch (this.chart.chartType) {
                    case 0: {
                        baseValue = this.chart.a_y.logScale ? this.chart.a_y.exp(this.chart.a_y.getAxisShift()) : this.chart.a_y.getAxisShift();
                        x = (this.area.p1.x + this.area.p2.x) / 2 + this.chart.toplabel_offset_side;
                        y = this.chart.isLabelOnPositiveSide() ? Math.max(p1Y, p2Y) + offset : (this.chart.isLabelOnNegativeSide() ? Math.min(p1Y, p2Y) - offset : p1Y + (value >= baseValue ? offset : -offset));
                        if (value < baseValue && this.chart.topvalueNegativeLabel_color != null) {
                            strColor = this.chart.topvalueNegativeLabel_color;
                        }
                        s = this.chart.getFormatValue((MultiDimData)this, this.plotData);
                        break;
                    }
                    case 1: {
                        double d = baseValue = this.chart.a_x.logScale ? this.chart.a_x.exp(this.chart.a_x.getAxisShift()) : this.chart.a_x.getAxisShift();
                        x = this.chart.isLabelOnPositiveSide() ? Math.max(p1X, p2X) + offset : (this.chart.isLabelOnNegativeSide() ? Math.min(p1X, p2X) - offset : p1X + (value >= baseValue ? offset : -offset));
                        if (value < baseValue && this.chart.topvalueNegativeLabel_color != null) {
                            strColor = this.chart.topvalueNegativeLabel_color;
                        }
                        y = (this.area.p2.y + this.area.p1.y) / 2 + this.chart.toplabel_offset_side;
                        s = this.chart.getFormatValue((MultiDimData)this, this.plotData);
                        break;
                    }
                    case 11: {
                        x = (this.area.p1.x + this.area.p2.x) / 2 + this.chart.toplabel_offset_side;
                        y = this.chart.topLabel_Alignment == 0 ? Math.max(this.area.p1.y, this.area.p2.y) + this.chart.toplabel_offset_up : (this.chart.topLabel_Alignment == 3 ? Math.max(this.area.p1.y, this.area.p2.y) + this.chart.toplabel_offset_up - this.labelHeight2D * 2 : (this.chart.topLabel_Alignment == 2 ? Math.min(this.area.p1.y, this.area.p2.y) + this.chart.toplabel_offset_up - this.labelHeight2D * 2 : (this.chart.topLabel_Alignment == 4 ? Math.min(this.area.p1.y, this.area.p2.y) + this.chart.toplabel_offset_up : (this.area.p1.y + this.area.p2.y) / 2 + this.chart.toplabel_offset_up - this.labelHeight2D)));
                        if (this.chart.isPrimaryDataLabelInfoNull()) {
                            this.chart.getFormatValue((MultiDimData)this, this.plotData);
                            s = this.chart.getFormatPercent(this.plotData);
                            break;
                        }
                        s = this.chart.getFormatValue((MultiDimData)this, this.plotData);
                        break;
                    }
                    default: {
                        baseValue = this.chart.a_y.logScale ? this.chart.a_y.exp(this.chart.a_y.getAxisShift()) : this.chart.a_y.getAxisShift();
                        x = this.point.x + this.chart.toplabel_offset_side;
                        y = this.point.y + (this.chart.chartType == 7 || this.chart.chartType == 3 || this.chart.chartType == 2 || this.chart.chartType == 13 || this.chart.chartType == 19 || this.chart.chartType == 15 || this.chart.chartType == 16 || this.chart.chartType == 17 || this.chart.chartType == 14 ? this.chart.toplabel_offset_up : -this.chart.toplabel_offset_up);
                        if (this.flashPoint != null && this.chart.chartType == 7) {
                            fx = this.flashPoint.x + this.chart.toplabel_offset_side;
                            fy = this.flashPoint.y + (this.chart.chartType == 7 || this.chart.chartType == 3 || this.chart.chartType == 2 || this.chart.chartType == 13 || this.chart.chartType == 19 || this.chart.chartType == 15 || this.chart.chartType == 16 || this.chart.chartType == 17 || this.chart.chartType == 14 ? this.chart.toplabel_offset_up : -this.chart.toplabel_offset_up);
                        }
                        if (!this.chart.isShowSeriesInTopLabel()) {
                            s = this.chart.getFormatValue((MultiDimData)this, this.plotData);
                        } else {
                            s = this.chart.getInformation(this);
                            s = this.chart.pickdata.category != null && this.chart.pickdata.series != null ? this.chart.pickdata.s_series : this.chart.getFormatValue((MultiDimData)this, this.plotData);
                            this.chart.pickdata.clear();
                        }
                        if (!(value < baseValue) || this.chart.topvalueNegativeLabel_color == null) break;
                        strColor = this.chart.topvalueNegativeLabel_color;
                    }
                }
                if (this.isPointVisible()) {
                    int align = this.chart.getChartType() == 1 || this.chart.getChartType() == 5 ? this.getCStringAlignForBarChart(this.chart.topLabel_Alignment, value < baseValue) : 0;
                    if (this.flashPoint != null && this.chart.chartType == 7) {
                        this.addLabels(bcreate, strColor, new Point3D(x, y), s, align, this, new Point3D(fx, fy));
                    } else {
                        this.addLabels(bcreate, strColor, new Point3D(x, y), s, align);
                    }
                }
            }
        }
    }

    @Override
    public void prepare_secondary_label(boolean bcreate) {
        if (this.chart.comboType == 1) {
            if (this.level < this.chart.dataDim - 1) {
                for (MultiDimData element : this.multiData) {
                    element.prepare_secondary_label(bcreate);
                }
            } else {
                Point3D pmax;
                double total1 = 0.0;
                total1 = this.multiData[0].plotData.getValue();
                Point3D pmin = pmax = this.multiData[0].point;
                double t = -1.7976931348623157E308;
                double t2 = Double.MAX_VALUE;
                for (int i = 1; i < this.multiData.length; ++i) {
                    double d;
                    total1 += this.multiData[i].plotData.getValue();
                    if (d > t) {
                        t = total1;
                    }
                    if (total1 < t2) {
                        t2 = total1;
                    }
                    if (this.multiData[i].point.y > pmax.y) {
                        pmax = this.multiData[i].point;
                        continue;
                    }
                    if (this.multiData[i].point.y >= pmin.y) continue;
                    pmin = this.multiData[i].point;
                }
                this.addLabels2(bcreate, new Point3D(pmax.x + this.chart.toplabel2_offset_side, total1 >= 0.0 ? pmax.y + this.chart.toplabel2_offset_up : pmin.y - this.chart.toplabel2_offset_up), this.chart.getFormatValue((MultiDimData)this, total1 >= 0.0 ? t : t2, -2), 0);
            }
        } else if (this.level < this.chart.dataDim) {
            for (MultiDimData element : this.multiData) {
                element.prepare_secondary_label(bcreate);
            }
        } else if (this.plotData.element != null) {
            String s;
            int y;
            int x;
            double baseValue = 0.0;
            double value = this.plotData.getValue();
            switch (this.chart.comboType) {
                case 2: {
                    baseValue = this.chart.a_s.getAxisShift();
                    x = (this.area.p1.x + this.area.p2.x) / 2 + this.chart.toplabel2_offset_side;
                    y = this.chart.isLabelOnPositiveSide() ? Math.max(this.area.p1.y, this.area.p2.y) + this.chart.toplabel2_offset_up : (this.chart.isLabelOnNegativeSide() ? Math.min(this.area.p1.y, this.area.p2.y) - this.chart.toplabel2_offset_up : this.area.p1.y + (value >= baseValue ? this.chart.toplabel2_offset_up : -this.chart.toplabel2_offset_up));
                    s = this.chart.getFormatValue((MultiDimData)this, this.plotData);
                    break;
                }
                default: {
                    if (this.chart.chartType == 1 || this.chart.chartType == 5) {
                        x = this.point.x + this.chart.toplabel2_offset_up;
                        y = this.point.y + this.chart.toplabel2_offset_side;
                    } else {
                        x = this.point.x + this.chart.toplabel2_offset_side;
                        y = this.point.y + this.chart.toplabel2_offset_up;
                    }
                    s = this.chart.getFormatValue((MultiDimData)this, this.plotData, -2);
                }
            }
            if (this.isPointVisible()) {
                int align = this.chart.getChartType() == 1 || this.chart.getChartType() == 5 ? this.getCStringAlignForBarChart(this.chart.topLabel2_Alignment, value < baseValue) : 0;
                this.addLabels2(bcreate, new Point3D(x, y), s, align);
            }
        }
    }

    @Override
    public void prepare_label(boolean bcreate, MultiDimData secondaryData) {
        if (this.level < this.chart.dataDim) {
            for (int i = 0; i < this.multiData.length; ++i) {
                this.multiData[i].prepare_label(bcreate, secondaryData.multiData[i]);
            }
        } else {
            if (this.plotData.isEmpty() || secondaryData.plotData.isEmpty()) {
                return;
            }
            if (this.plotData.element != null) {
                int x = this.point.x + this.chart.toplabel_offset_side;
                int y = this.point.y + this.chart.toplabel_offset_up;
                String s = this.chart.getFormatValue((MultiDimData)this, this.plotData);
                int x2 = secondaryData.point.x + this.chart.toplabel_offset_side;
                int y2 = secondaryData.point.y + this.chart.toplabel_offset_up;
                String s2 = this.chart.getFormatValue(secondaryData, secondaryData.plotData);
                if (this.isPointVisible()) {
                    this.addLabels(bcreate, this.chart.topvalueLabel_color, new Point3D(x, y), s, 0);
                    this.addLabels(bcreate, this.chart.topvalueLabel_color, new Point3D(x2, y2), s2, 0);
                }
            }
        }
    }

    @Override
    public void prepare_label3D(boolean bcreate) {
    }

    @Override
    public void prepare_secondary_label3D(boolean bcreate) {
    }

    @Override
    public void prepare_stacklabel3D(boolean bcreate) {
    }
}

