/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart2d;

import java.awt.Polygon;
import quadbase.chart.CGraphics;
import quadbase.chart.Chart;
import quadbase.chart.GradientSupport;
import quadbase.chart.MultiDimData;
import quadbase.chart.Point3D;
import quadbase.chart.StepSize;
import quadbase.chart.chart2d.MultiDimData2D;
import quadbase.common.util.internal.IFlashGraphics;
import quadbase.util.internal.Composite;

public class Overlay2D {
    public static Point3D[] computeChart(Chart chart, int dataDim, int[] mDataLen, MultiDimData mData, StepSize ystep, StepSize ystep2, int xmin, int xmax) {
        return Overlay2D.computeChart(chart, dataDim, mDataLen, mData, ystep, ystep2, null, xmin, xmax);
    }

    public static Point3D[] computeChart(Chart chart, int dataDim, int[] mDataLen, MultiDimData mData, StepSize ystep, StepSize ystep2, StepSize[] ystepC, int xmin, int xmax) {
        int noChart = 1;
        int noCategory = mDataLen[dataDim - 1];
        if (dataDim == 2) {
            noChart = mDataLen[dataDim - 2];
        }
        int[] loc = new int[dataDim];
        Point3D[] coord = new Point3D[noCategory];
        int[] seriesType = chart.getSeriesType();
        int[] axisPos = chart.getAxisPosition();
        StepSize tstep = ystep;
        int countColumn = 0;
        for (int i = 0; i < noChart; ++i) {
            if (seriesType[i] != 0) continue;
            ++countColumn;
        }
        int currentColumn = 0;
        for (int i = 0; i < noChart; ++i) {
            if (dataDim == 2) {
                loc[0] = i;
            }
            tstep = dataDim == 1 ? ystep : (axisPos[i] == -1 ? ystep : (axisPos[i] == -2 ? ystep2 : ystepC[axisPos[i]]));
            if (seriesType[i] == 7) {
                Overlay2D.computeAreaChart(chart, dataDim, mData, tstep, noCategory, loc, coord, xmin, xmax);
                continue;
            }
            if (seriesType[i] == 0) {
                Overlay2D.computeColumnChart(chart, dataDim, mData, tstep, noCategory, loc, coord, xmin, xmax, currentColumn, countColumn);
                ++currentColumn;
                continue;
            }
            if (seriesType[i] != 3) continue;
            Overlay2D.computeLineChart(chart, dataDim, mDataLen, mData, tstep, noCategory, loc, coord, xmin, xmax);
        }
        mData.chart.setAutomatic(false);
        return coord;
    }

    private static void computeAreaChart(Chart chart, int dataDim, MultiDimData mData, StepSize ystep, int noCategory, int[] loc, Point3D[] coord, int xmin, int xmax) {
        chart.yAxisCenter = ystep.zeroAxis;
        double delta = (double)(xmax - xmin) / (double)noCategory;
        double nextx = (double)xmin + delta / 2.0;
        boolean zoomXDir = chart.isXZoomed && (chart.getZoomOption() == 0 || chart.getZoomOption() == 2);
        for (int i = 0; i < noCategory; ++i) {
            loc[dataDim - 1] = i;
            double value = chart.isDataLimitAtAxisScale() ? mData.getValue(loc, ystep) * chart.flashRatio : mData.getValue(loc) * chart.flashRatio;
            int m = (int)nextx;
            if (zoomXDir && ((m = chart.calculateZoomedX(m)) < chart.chartxorigin || m > chart.chartxorigin + chart.chartwidth)) {
                m = -100;
            }
            mData.setPointCoord((int)nextx, ystep.interpolatePixel(value), loc);
            coord[i] = new Point3D(m, ystep.zeroAxis, 0);
            nextx += delta;
        }
    }

    private static void computeColumnChart(Chart chart, int dataDim, MultiDimData mData, StepSize ystep, int noCategory, int[] loc, Point3D[] coord, int xmin, int xmax, int currentColumn, int countColumn) {
        boolean zoomXDir;
        double delta = (double)(xmax - xmin) / ((double)noCategory * ((double)countColumn + chart.barwidthRatio));
        double delta2 = delta * chart.barwidthRatio;
        double lastx = (double)xmin + delta2 / 2.0;
        boolean bl = zoomXDir = chart.isXZoomed && (chart.getZoomOption() == 0 || chart.getZoomOption() == 2);
        if (countColumn == 1) {
            for (int i = 0; i < noCategory; ++i) {
                double nextx = lastx + delta;
                loc[dataDim - 1] = i;
                double value = chart.isDataLimitAtAxisScale() ? mData.getValue(loc, ystep) * chart.flashRatio : mData.getValue(loc) * chart.flashRatio;
                mData.setAreaCoord((int)lastx, (int)nextx, ystep.interpolatePixel(value), ystep.zeroAxis, loc);
                int m = (int)((lastx + nextx) / 2.0);
                if (zoomXDir && ((m = chart.calculateZoomedX(m)) < chart.chartxorigin || m > chart.chartxorigin + chart.chartwidth)) {
                    m = -100;
                }
                coord[i] = new Point3D(m, ystep.zeroAxis, 0);
                lastx = nextx + delta2;
            }
        } else {
            double a = (chart.barwidthRatio + (double)countColumn) * delta;
            double b = lastx + (double)countColumn * delta / 2.0;
            for (int i = 0; i < noCategory; ++i) {
                loc[dataDim - 1] = i;
                double nextx = (lastx += delta * (double)currentColumn) + delta;
                double value = chart.isDataLimitAtAxisScale() ? mData.getValue(loc, ystep) * chart.flashRatio : mData.getValue(loc) * chart.flashRatio;
                mData.setAreaCoord((int)lastx, (int)nextx, ystep.interpolatePixel(value), ystep.zeroAxis, loc);
                int m = (int)(a * (double)i + b);
                if (zoomXDir && ((m = chart.calculateZoomedX(m)) < chart.chartxorigin || m > chart.chartxorigin + chart.chartwidth)) {
                    m = -100;
                }
                coord[i] = new Point3D(m, ystep.zeroAxis, 0);
                lastx = (nextx += delta * (double)(countColumn - currentColumn - 1)) + delta2;
            }
        }
    }

    private static void computeLineChart(Chart chart, int dataDim, int[] mDataLen, MultiDimData mData, StepSize ystep, int noCategory, int[] loc, Point3D[] coord, int xmin, int xmax) {
        int i;
        double delta = (double)(xmax - xmin) / (double)noCategory;
        double nextx = (double)xmin + delta / 2.0;
        boolean zoomXDir = chart.isXZoomed && (chart.getZoomOption() == 0 || chart.getZoomOption() == 2);
        for (i = 0; i < noCategory; ++i) {
            if (ystep == null) continue;
            loc[dataDim - 1] = i;
            double value = mData.getValue(loc) * chart.flashRatio;
            mData.setPointCoord((int)nextx, ystep.interpolatePixel(value), loc);
            int m = (int)nextx;
            if (zoomXDir && ((m = chart.calculateZoomedX(m)) < chart.chartxorigin || m > chart.chartxorigin + chart.chartwidth)) {
                m = -100;
            }
            coord[i] = new Point3D(m, ystep.zeroAxis, 0);
            nextx += delta;
        }
        for (i = 0; i < mDataLen[0]; ++i) {
            mData.multiData[i].point.automatic = false;
            for (int j = 0; j < mDataLen[1]; ++j) {
                mData.multiData[i].multiData[j].point.automatic = true;
            }
        }
    }

    private static void fillArea(MultiDimData mData, CGraphics g, Chart chart) {
        Polygon p = null;
        MultiDimData md = mData;
        GradientSupport gradientSupport = chart.getPrimaryDataGradientSupport();
        if (Overlay2D.isSecondary(chart, mData)) {
            gradientSupport = chart.getSecondaryDataGradientSupport();
        }
        int[] mDataLen = mData.chart.mDataLen;
        for (int j = 0; j < mDataLen[1] - 1; ++j) {
            MultiDimData md1 = md.multiData[j];
            MultiDimData md2 = md.multiData[j + 1];
            int x1 = md1.point.x;
            int x2 = md2.point.x;
            if (chart.isCatZoom()) {
                x1 = chart.calculateZoomedX(x1);
                x2 = chart.calculateZoomedX(x2);
            }
            if ((p = ((MultiDimData2D)md).getPolygonForArea(x1, md1.point.y, x2, md2.point.y, chart.a_y.stepsize.zeroAxis)) == null) break;
            g.setColor(md.area.areaColor);
            if (md1.plotData.isEmpty() || md2.plotData.isEmpty()) continue;
            g.fillPolygon(p, md1, gradientSupport);
            if (!chart.drawDataBorder) continue;
            g.drawLineForArea(p, j == 0, j == mDataLen[1] - 2, md.area.areaColor.darker());
        }
        chart.prepareLabel();
    }

    public static void drawChart(CGraphics g, Chart chart, MultiDimData mData) {
        if (mData.chart.dataDim == 1) {
            mData.drawArea(g);
            if (chart.showLine) {
                mData.drawLine(g);
            }
            if (chart.showPoint) {
                mData.drawPoint(g);
            }
        } else {
            Overlay2D.drawArea(g, chart, mData);
            if (chart.showLine) {
                Overlay2D.drawLine(g, chart, mData);
            }
            if (chart.showPoint) {
                mData.drawPoint(g);
            }
        }
    }

    private static boolean isSecondary(Chart chart, MultiDimData mData) {
        if (mData.chart != chart) {
            return true;
        }
        return mData.isSecondary();
    }

    public static void drawArea(CGraphics g, Chart chart, MultiDimData mData) {
        int i;
        boolean isTransparent = chart.isTranslucentSupport();
        if (isTransparent) {
            Composite.setCompositeSrcOver(g.g, chart.getTranslucentValue());
        }
        int[] seriesType = chart.getSeriesType();
        boolean setToolTipsForFlash = false;
        for (i = 0; i < seriesType.length; ++i) {
            if (seriesType[i] != 7) continue;
            Overlay2D.fillArea(mData.multiData[i], g, chart);
        }
        for (i = 0; i < seriesType.length; ++i) {
            if (seriesType[i] != 0) continue;
            if (g.g instanceof IFlashGraphics) {
                setToolTipsForFlash = true;
                ((IFlashGraphics)((Object)g.g)).setToolTipsAndLink(mData.multiData[i]);
            }
            mData.multiData[i].drawArea(g);
            if (!setToolTipsForFlash) continue;
            ((IFlashGraphics)((Object)g.g)).resetToolTipsAndLink();
        }
        if (isTransparent) {
            Composite.setOriginalComposite(g.g);
        }
    }

    public static void drawLine(CGraphics g, Chart chart, MultiDimData mData) {
        int[] seriesType = chart.getSeriesType();
        for (int i = 0; i < seriesType.length; ++i) {
            if (seriesType[i] != 3 || i >= mData.multiData.length) continue;
            mData.multiData[i].drawLine(g);
        }
    }
}

