/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart2d;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.geom.GeneralPath;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.chart.BSpline;
import quadbase.chart.CGraphics;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.DataLine;
import quadbase.chart.MultiDimData;
import quadbase.chart.Point3D;
import quadbase.chart.ReloadChart;
import quadbase.chart.StepSize;
import quadbase.chart.TrendLine;
import quadbase.chart.chart2d.GenMatrix;
import quadbase.chart.chart2d.HorzVertLine2D;
import quadbase.common.util.internal.QbUtil;
import quadbase.util.Point_2D;

public class TrendLine2D
extends TrendLine {
    private static final Logger LOGGER = Logger.getLogger(TrendLine2D.class.getName());
    double mean = 0.0;
    double normalMin = 0.0;
    double stDev = 0.0;
    double[] value = null;
    int[] pixel = null;
    double max = 0.0;
    double nMin = Double.MAX_VALUE;
    double nMax = -1.7976931348623157E308;

    public TrendLine2D(Chart chart) {
        super(chart);
    }

    public TrendLine2D(Chart chart, TrendLine tline) {
        super(chart, tline);
    }

    public TrendLine2D(Chart chart, int linetype, int coeff, String title) {
        super(chart, linetype, coeff, title);
    }

    @Override
    public final void setColor(Color color) {
        this.color = color;
    }

    private void fit_higherOrder(Double[] x, Double[] y) {
        this.error_data = true;
        Double[] doubleArray = x;
        int n = doubleArray.length;
        for (int i = 0; i < n; ++i) {
            double element = doubleArray[i];
            if (x[0] == element) continue;
            this.error_data = false;
            break;
        }
        if (this.error_data) {
            return;
        }
        int order = Math.min(this.coeff, x.length - 1);
        int nrow = x.length;
        int ncol = order + 1;
        GenMatrix matx = new GenMatrix(nrow, ncol);
        for (int i = 0; i < nrow; ++i) {
            double s = 1.0;
            for (int j = 0; j < ncol; ++j) {
                matx.set(i, j, s);
                s *= x[i].doubleValue();
            }
        }
        GenMatrix tran_matx = matx.transpose();
        GenMatrix inv_mat = tran_matx.times(matx);
        try {
            inv_mat.destructiveInvert();
        }
        catch (ArithmeticException ex) {
            LOGGER.log(Level.FINE, "Failed to invert matrix", ex);
            this.error_data = true;
            return;
        }
        GenMatrix maty = new GenMatrix(nrow, 1);
        for (int i = 0; i < nrow; ++i) {
            maty.set(i, 0, y[i]);
        }
        GenMatrix coeffs = inv_mat.times(tran_matx.times(maty));
        this.c = new double[ncol];
        for (int i = 0; i < ncol; ++i) {
            this.c[i] = coeffs.get(i, 0);
        }
    }

    @Override
    public void compute() {
        this.error_data = false;
        if (this.chart.mData2 == null) {
            this.useSubvalue = false;
        }
        if (this.chart.chartType == 6 || this.chart.chartType == 17 || this.chart.chartType == 16) {
            return;
        }
        if (!this.chart.is2DChart || TrendLine2D.horzVertType(this.linetype) || this.chart.chartType == 11) {
            this.makeTitle();
            return;
        }
        boolean xscale = this.chart.a_x.logScale;
        boolean yscale = this.chart.a_y.logScale;
        double xBase = this.chart.a_x.getBaseForLog();
        double yBase = this.chart.a_y.getBaseForLog();
        MultiDimData md = this.useSubvalue ? this.chart.mData2 : this.chart.mData;
        switch (this.chart.chartType) {
            case 2: 
            case 13: {
                if (this.chart.dataDim == 1) {
                    this.getArray(xscale, xBase, yscale, yBase, md);
                    break;
                }
                this.getArray(xscale, xBase, yscale, yBase, md.multiData[this.findSeriesNo(this.series)]);
                break;
            }
            case 9: 
            case 10: 
            case 18: {
                if (this.hlco_value == 2 && this.chart.hilowCol.close < 0 || this.hlco_value == 3 && this.chart.hilowCol.open < 0) {
                    this.hlco_value = 0;
                }
            }
            case 14: {
                for (ColData colData : this.chart.getColData()) {
                    if (colData.getAxisPosition() == null) continue;
                    this.useAxis = colData.getAxisPosition()[this.findSeriesNo(this.series)];
                    if (this.useAxis == -1) {
                        this.useAxis = -3;
                        break;
                    }
                    if (this.useAxis != -2) break;
                    this.useAxis = -1;
                    break;
                }
            }
            default: {
                if (!this.chart.isStackType()) {
                    if (this.chart.dataDim == 1) {
                        this.getArray(xscale, xBase, yscale, yBase, md);
                        break;
                    }
                    this.getArray(xscale, xBase, yscale, yBase, md.multiData[this.findSeriesNo(this.series)]);
                    break;
                }
                if (this.chart.dataDim == 2) {
                    this.getSumArray(md);
                    break;
                }
                this.getSumArray(md.multiData[this.findSeriesNo(this.series)]);
            }
        }
        this.makeTitle();
        boolean bl = this.error_data = this.x == null || this.y == null || this.x.length == 1 || TrendLine2D.averageType(this.linetype) && this.x.length <= this.coeff;
        if (this.error_data) {
            return;
        }
        this.x = TrendLine2D.getArrayWithoutNullValues(this.x);
        this.y = TrendLine2D.getArrayWithoutNullValues(this.y);
        switch (this.linetype) {
            case 0: {
                if (!TrendLine2D.isBarChartType(this.chart)) {
                    this.fit_higherOrder(this.x, this.y);
                    break;
                }
                this.fit_higherOrder(this.y, this.x);
                break;
            }
            case 2: {
                if (!TrendLine2D.isBarChartType(this.chart)) {
                    if (!this.logTransform(this.x)) {
                        return;
                    }
                    this.fit_higherOrder(this.x, this.y);
                    break;
                }
                if (!this.logTransform(this.y)) {
                    return;
                }
                this.fit_higherOrder(this.y, this.x);
                break;
            }
            case 1: {
                if (!TrendLine2D.isBarChartType(this.chart)) {
                    if (!this.logTransform(this.y)) {
                        return;
                    }
                    this.fit_higherOrder(this.x, this.y);
                    break;
                }
                if (!this.logTransform(this.x)) {
                    return;
                }
                this.fit_higherOrder(this.y, this.x);
                break;
            }
            case 3: {
                if (!this.logTransform(this.x) || !this.logTransform(this.y)) {
                    return;
                }
                this.fit_higherOrder(this.x, this.y);
                this.c[0] = Math.exp(this.c[0]);
                break;
            }
            case 4: {
                this.y = TrendLine2D.compute_avg(this.y, this.coeff);
                return;
            }
            case 5: {
                TrendLine2D.compute_exp_avg(this.y, this.coeff);
                return;
            }
            case 6: {
                this.y = TrendLine2D.compute_tri_avg(this.y, this.coeff);
                return;
            }
            case 17: {
                this.computeNormalCurve();
            }
            default: {
                this.bspline = new BSpline(this.x, this.y);
                this.bspline.setChartBound(this.chart.chartxorigin + this.chart.chartwidth, this.chart.chartyorigin + this.chart.chartheight);
            }
        }
        this.y = null;
        this.x = null;
    }

    @Override
    public void prepare3DLine() {
    }

    @Override
    protected final void drawLine(CGraphics g) {
        int newpixel;
        int oldpixel;
        if (this.chart.chartType == 6 || this.chart.chartType == 17 || this.chart.chartType == 16 || this.error_data) {
            return;
        }
        this.chartMaxX = this.chart.chartxorigin + this.chart.chartwidth;
        this.chartMaxY = this.chart.chartyorigin + this.chart.chartheight;
        if (this.chart.chartType == 11 && !TrendLine2D.horzVertType(this.linetype)) {
            return;
        }
        int y1 = this.chart.chartyorigin;
        int y2 = this.chart.chartyorigin + this.chart.chartheight;
        double t = 0.0;
        double initPt = 0.0;
        Point3D[] p = null;
        StepSize sz_x = this.chart.a_x.stepsize;
        int x1 = this.chart.chartxorigin;
        int x2 = this.chart.chartxorigin + this.chart.chartwidth;
        StepSize sz = null;
        if (this.linetype < 7 || this.linetype == 9) {
            if (this.chart.chartType != 2 && this.chart.chartType != 13) {
                int temp2;
                int temp1;
                if (!TrendLine2D.isBarChartType(this.chart)) {
                    p = this.chart.a_x.ticker.point;
                    temp1 = p[0].x;
                    temp2 = p[p.length - 1].x;
                    t = (double)(1 - p.length) / (double)(temp2 - temp1);
                    initPt = 1.0 + (double)(temp1 - x1) * t;
                    sz = this.chart.chartType == 14 && this.useAxis >= -3 ? this.chart.getAxis((int)(this.useAxis + 4)).stepsize : (this.useSubvalue ? this.chart.a_s.stepsize : this.chart.a_y.stepsize);
                } else {
                    p = this.chart.a_y.ticker.point;
                    temp1 = p[0].y;
                    temp2 = p[p.length - 1].y;
                    t = (double)(1 - p.length) / (double)(temp2 - temp1);
                    initPt = 1.0 + (double)(temp1 - y1) * t;
                    sz = this.chart.chartType == 14 && this.useAxis >= -3 ? this.chart.getAxis((int)(this.useAxis + 4)).stepsize : (this.useSubvalue ? this.chart.a_s.stepsize : this.chart.a_x.stepsize);
                }
            } else {
                initPt = sz_x.minvalue;
                t = (initPt - sz_x.maxvalue) / (double)this.chart.chartwidth;
                if (this.chart.chartType == 14 && this.useAxis >= -3) {
                    sz = this.chart.getAxis((int)(this.useAxis + 4)).stepsize;
                } else {
                    StepSize stepSize = sz = this.useSubvalue ? this.chart.a_s.stepsize : this.chart.a_y.stepsize;
                }
            }
        }
        if (!this.calculatemode) {
            g.g.setColor(this.color);
        }
        if (this.linetype == 9 && p != null) {
            if (!TrendLine2D.isBarChartType(this.chart)) {
                this.bspline.draw(this, g, this.chart.chartType == 2 || this.chart.chartType == 13 ? this.chart.a_x.stepsize : new StepSize(p[0].x, 1.0, -1.0 / t), sz);
            } else {
                this.bspline.draw(this, g, sz, new StepSize(p[0].y, 1.0, -1.0 / t));
            }
            this.setAbsPosition(this.bspline.endX, this.bspline.endY);
            return;
        }
        if (this.linetype == 17) {
            this.drawNormalCurve(g);
            return;
        }
        GeneralPath path = null;
        if (this.linetype == 0 || this.linetype == 1 || this.linetype == 2 || this.linetype == 3) {
            int incsize;
            int n = incsize = this.coeff < 2 && this.linetype == 0 ? this.chart.chartwidth : 6;
            if (!DataLine.isBarChartType(this.chart)) {
                int p1 = x1;
                oldpixel = this.fn(sz, initPt + t * (double)(x1 - p1));
                while (p1 < x2) {
                    int p2 = p1 + incsize;
                    if (p2 > x2) {
                        p2 = x2;
                    }
                    newpixel = this.fn(sz, initPt + t * (double)(x1 - p2));
                    path = this.drawLimitPath(g, y1, y2, p1, oldpixel, p2, newpixel, path);
                    p1 = p2;
                    oldpixel = newpixel;
                    this.setAbsPosition(p1, oldpixel);
                }
            } else {
                int p1 = y1;
                oldpixel = this.fn(sz, initPt + t * (double)(y1 - p1));
                while (p1 < y2) {
                    int p2 = p1 + incsize;
                    if (p2 > y2) {
                        p2 = y2;
                    }
                    newpixel = this.fn(sz, initPt + t * (double)(y1 - p2));
                    path = this.drawLimitPathForBar(g, x1, x2, oldpixel, p1, newpixel, p2, path);
                    p1 = p2;
                    oldpixel = newpixel;
                    this.setAbsPosition(oldpixel, p1);
                }
            }
            if (path != null) {
                g.drawLine(path, this.thickness);
            }
        } else if (this.linetype == 4 || this.linetype == 5 || this.linetype == 6) {
            if (sz != null) {
                if (this.chart.chartType != 2 && this.chart.chartType != 13) {
                    if (p != null) {
                        if (!DataLine.isBarChartType(this.chart)) {
                            int index = TrendLine2D.findPrevNotNull(this.coeff - 1, this.y);
                            if (this.y[index] == null) {
                                return;
                            }
                            oldpixel = sz.interpolatePixel2(this.y[index]);
                            for (int i = this.coeff; i < this.x.length; ++i) {
                                if (this.y[i] == null) continue;
                                newpixel = sz.interpolatePixel2(this.y[i]);
                                path = this.drawLimitPath(g, y1, y2, p[TrendLine2D.findPrevNotNull((int)(i - 1), (Double[])this.y)].x, oldpixel, p[i].x, newpixel, path);
                                oldpixel = newpixel;
                                this.setAbsPosition(p[i].x, oldpixel);
                            }
                        } else {
                            int index = TrendLine2D.findPrevNotNull(this.coeff - 1, this.x);
                            if (this.x[index] == null) {
                                return;
                            }
                            oldpixel = sz.interpolatePixel2(this.x[index]);
                            for (int i = this.coeff; i < this.y.length; ++i) {
                                if (this.x[i] == null) continue;
                                newpixel = sz.interpolatePixel2(this.x[i]);
                                path = this.drawLimitPathForBar(g, x1, x2, oldpixel, p[TrendLine2D.findPrevNotNull((int)(i - 1), (Double[])this.x)].y, newpixel, p[i].y, path);
                                oldpixel = newpixel;
                                this.setAbsPosition(oldpixel, p[i].y);
                            }
                        }
                        if (path != null) {
                            g.drawLine(path, this.thickness);
                        }
                    }
                } else {
                    int index = TrendLine2D.findPrevNotNull(this.coeff - 1, this.x);
                    if (this.x[index] == null) {
                        return;
                    }
                    int oldpixel_x = sz_x.interpolatePixel2(this.x[index]);
                    index = TrendLine2D.findPrevNotNull(this.coeff - 1, this.y);
                    if (this.y[index] == null) {
                        return;
                    }
                    oldpixel = sz.interpolatePixel2(this.y[index]);
                    for (int i = this.coeff; i < this.x.length; ++i) {
                        if (this.y[i] == null && this.x[i] == null) continue;
                        newpixel = sz.interpolatePixel2(this.y[i]);
                        int newpixel_x = sz_x.interpolatePixel2(this.x[i]);
                        path = this.drawLimitPath(g, y1, y2, oldpixel_x, oldpixel, newpixel_x, newpixel, path);
                        oldpixel = newpixel;
                        oldpixel_x = newpixel_x;
                        this.setAbsPosition(oldpixel_x, oldpixel);
                    }
                    if (path != null) {
                        g.drawLine(path, this.thickness);
                    }
                }
            } else {
                if (this.linetype == 7) {
                    if (!TrendLine2D.isBarChartType(this.chart)) {
                        newpixel = this.getHortLineYPixel();
                        path = this.drawLimitPath(g, Integer.MIN_VALUE, Integer.MAX_VALUE, x1, newpixel, x2, newpixel, path);
                    } else {
                        newpixel = this.getHortLineYPixel2();
                        path = this.drawLimitPath(g, Integer.MIN_VALUE, Integer.MAX_VALUE, x1, newpixel, x2, newpixel, path);
                    }
                    this.setAbsPosition(x2, newpixel);
                } else {
                    if (TrendLine2D.isBarChartType(this.chart)) {
                        newpixel = this.getVertLineXPixel();
                        path = this.drawLimitPath(g, Integer.MIN_VALUE, Integer.MAX_VALUE, newpixel, y1, newpixel, y2, path);
                    } else {
                        newpixel = this.getVertLineXPixel2();
                        path = this.drawLimitPath(g, Integer.MIN_VALUE, Integer.MAX_VALUE, newpixel, y1, newpixel, y2, path);
                    }
                    this.setAbsPosition(newpixel, y2);
                }
                if (path != null) {
                    g.drawLine(path, this.thickness);
                }
            }
        }
    }

    public static int findPrevNotNull(int coeff, Double[] a) {
        int i;
        for (i = coeff; i > -1 && a[i] == null; --i) {
        }
        if (i < 0) {
            return TrendLine2D.findNextNotNull(coeff, a);
        }
        return i;
    }

    public static int findNextNotNull(int coeff, Double[] a) {
        int i;
        for (i = coeff; i < a.length && a[i] == null; ++i) {
        }
        if (i < a.length) {
            return i;
        }
        return i - 1;
    }

    private final double poly_fn(double v) {
        int len = this.c.length;
        double s = this.c[len - 1];
        for (int i = len - 2; i >= 0; --i) {
            s = this.c[i] + v * s;
        }
        return s;
    }

    private final int fn(StepSize sz, double v) {
        switch (this.linetype) {
            case 0: {
                v = this.poly_fn(v);
                break;
            }
            case 2: {
                v = this.c[0] + this.c[1] * Math.log(v);
                break;
            }
            case 1: {
                v = Math.exp(this.c[0] + this.c[1] * v);
                break;
            }
            case 3: {
                v = this.c[0] * Math.pow(v, this.c[1]);
                break;
            }
        }
        return sz.interpolatePixel2(v);
    }

    private void computeNormalCurve() {
        if (!this.supportNormalCurve()) {
            return;
        }
        this.mean = 0.0;
        this.stDev = 0.0;
        if (this.chart.processedChart) {
            ColData colData = null;
            try {
                int index = this.chart.originalMap[this.chart.getCategoryIndex()];
                ColData[] colDat = ReloadChart.getOriginalColData(this.chart, true);
                if (index < colDat.length) {
                    colData = colDat[index];
                } else if (this.chart.isHistogram()) {
                    colData = colDat[0];
                }
            }
            catch (IllegalArgumentException ex) {
                LOGGER.log(Level.WARNING, "Failed to reload original col data.", ex);
                return;
            }
            if (colData != null) {
                int i;
                int nCol = colData.getSize();
                for (i = 0; i < nCol; ++i) {
                    this.mean += colData.getValue(i);
                }
                this.mean /= (double)nCol;
                for (i = 0; i < nCol; ++i) {
                    double x = colData.getValue(i);
                    this.stDev = Math.pow(x - this.mean, 2.0) + this.stDev;
                    if (x > this.nMax) {
                        this.nMax = x;
                    }
                    if (!(x < this.nMin)) continue;
                    this.nMin = x;
                }
                this.stDev = Math.sqrt(this.stDev / (double)(nCol - 1));
            }
        } else {
            int i;
            ColData colDataCat = this.chart.colData[this.chart.getCategoryIndex()];
            ColData colDataVal = this.chart.colData[this.chart.getPrimaryIndex()];
            int nColCat = colDataCat.getSize();
            double ttlOccur = 0.0;
            this.normalMin = colDataCat.getValue(0);
            for (i = 0; i < nColCat; ++i) {
                double catValue = colDataCat.getValue(i);
                this.mean += catValue * colDataVal.getValue(i);
                ttlOccur += colDataVal.getValue(i);
                if (catValue < this.normalMin) {
                    this.normalMin = catValue;
                }
                if (catValue > this.nMax) {
                    this.nMax = catValue;
                }
                if (!(catValue < this.nMin)) continue;
                this.nMin = catValue;
            }
            this.mean /= ttlOccur;
            for (i = 0; i < nColCat; ++i) {
                this.stDev += Math.pow(colDataCat.getValue(i) - this.mean, 2.0) * colDataVal.getValue(i);
            }
            this.stDev = Math.sqrt(this.stDev / (ttlOccur - 1.0));
        }
        ColData cData = this.chart.colData[this.chart.mDataMap[0]];
        int step = 1;
        int nCol = this.chart.mData.multiData.length;
        if (nCol < 20) {
            step = (int)Math.ceil(20.0 / (double)nCol);
        }
        this.pixel = new int[nCol * step - (step - 1)];
        this.value = new double[nCol * step - (step - 1)];
        int ct = 0;
        double tmpP = 0.0;
        for (int i = 0; i < nCol - 1; ++i) {
            MultiDimData data = this.chart.mData.multiData[i];
            tmpP = TrendLine2D.isBarChartType(this.chart) ? (double)(this.chart.mData.multiData[i + 1].point.y - data.point.y) / (double)step : (double)(this.chart.mData.multiData[i + 1].point.x - data.point.x) / (double)step;
            double cur = ((Number)cData.fieldName[i]).doubleValue();
            double tmpV = ((Number)cData.fieldName[i + 1]).doubleValue();
            tmpV = (tmpV - cur) / (double)step;
            for (int j = 0; j < step; ++j) {
                double in = cur + (double)j * tmpV;
                this.value[ct] = this.getValue(in);
                this.pixel[ct] = TrendLine2D.isBarChartType(this.chart) ? data.point.y + (int)((double)j * tmpP) : data.point.x + (int)((double)j * tmpP);
                ++ct;
            }
        }
        MultiDimData data = this.chart.mData.multiData[nCol - 1];
        double in = ((Number)cData.fieldName[nCol - 1]).doubleValue();
        this.value[ct] = this.getValue(in);
        this.pixel[ct] = TrendLine2D.isBarChartType(this.chart) ? data.point.y : data.point.x;
        this.computeAxis();
    }

    @Override
    public final double getMean() {
        return this.mean;
    }

    @Override
    public final double getMin() {
        return this.nMin;
    }

    @Override
    public final double getMax() {
        return this.nMax;
    }

    @Override
    public final double getStandardDev() {
        return this.stDev;
    }

    @Override
    public final void drawStandardDevLine(Color color, double multipleDev, String label) {
        if (!this.chart.isHistogram() || !this.chart.getPreprocInfo().isLinear) {
            return;
        }
        HorzVertLine2D hv1 = new HorzVertLine2D(this.chart, 15, label);
        this.drawHorzVertLine(hv1, true, color, multipleDev);
        if (multipleDev != 0.0) {
            HorzVertLine2D hv2 = new HorzVertLine2D(this.chart, 15, label);
            this.drawHorzVertLine(hv2, false, color, multipleDev);
        }
    }

    private void drawHorzVertLine(HorzVertLine2D hv, boolean varia, Color color, double mDev) {
        hv.setColor(color);
        double value = 0.0;
        value = varia ? this.mean + mDev * this.stDev : this.mean - mDev * this.stDev;
        double lineValue = 0.0;
        double interval = 1.0;
        if (this.chart.getPreprocInfo().intervalNum != null) {
            interval = this.chart.getPreprocInfo().intervalNum.doubleValue();
        }
        if ((lineValue = this.chart.getPreprocInfo().lBound == null ? 0.5 + (value - this.normalMin) / interval : 0.5 + (value - ((Number)this.chart.getPreprocInfo().lBound).doubleValue()) / interval) >= 0.0) {
            hv.setLineValue(lineValue);
            this.chart.dataLineSet.updateDataLine(hv);
        }
    }

    private void computeAxis() {
        int xmin = this.chart.chartxorigin;
        int xmax = this.chart.chartxorigin + this.chart.chartwidth;
        int ymin = this.chart.chartyorigin;
        int ymax = this.chart.chartheight + this.chart.chartyorigin;
        this.chart.findMinMaxVal2();
        if (this.chart.maxvalue2 < this.max) {
            this.chart.maxvalue2 = this.max;
        }
        if (!TrendLine2D.isBarChartType(this.chart)) {
            int fstep = (ymax - ymin) / 15;
            if (this.chart.cgraphics != null) {
                FontMetrics fm = this.chart.cgraphics.getFontMetrics(QbUtil.resizeViewerFont(this.chart.a_y.font, this.chart.isAdjustFont()));
                fstep = (int)((double)(ymax - ymin) / (2.0 * (double)(fm.getMaxAscent() + fm.getMaxDescent())));
            } else {
                fstep = 10;
            }
            int decimalPoint = 0;
            decimalPoint = this.linetype == 17 ? 4 : this.chart.getVdec();
            StepSize step = new StepSize(this.chart.a_s, ymax, ymin, this.chart.maxvalue2, this.chart.minvalue2, fstep, decimalPoint);
            if (this.chart.secData == null || !this.chart.secData.getName().equals(this.chart.colData[this.chart.valueCol].getName()) || this.chart.secData.getOriginalDataType() != this.chart.colData[this.chart.valueCol].getOriginalDataType()) {
                this.chart.secData = new ColData(this.chart.colData[this.chart.valueCol].getName(), this.chart.colData[this.chart.valueCol].getOriginalDataType(), this.chart.colData.length);
                this.chart.secData.copyAttributes(this.chart.colData[this.chart.valueCol]);
            }
            this.chart.a_s.setAxisGridY(step, xmax, xmin, xmax, this.chart.secData, this.chart.axisThickness);
        } else {
            int fstep = (xmax - xmin) / 15;
            if (this.chart.cgraphics != null) {
                FontMetrics fm = this.chart.cgraphics.getFontMetrics(QbUtil.resizeViewerFont(this.chart.a_y.font, this.chart.isAdjustFont()));
                fstep = (int)((double)(xmax - xmin) / (2.0 * (double)(fm.getMaxAscent() + fm.getMaxDescent())));
            }
            int decimalPoint = 0;
            decimalPoint = this.linetype == 17 ? 4 : this.chart.getVdec();
            StepSize step = new StepSize(this.chart.a_s, xmax, xmin, this.chart.maxvalue2, this.chart.minvalue2, fstep, decimalPoint);
            if (this.chart.secData == null || !this.chart.secData.getName().equals(this.chart.colData[this.chart.valueCol].getName()) || this.chart.secData.getOriginalDataType() != this.chart.colData[this.chart.valueCol].getOriginalDataType()) {
                this.chart.secData = new ColData(this.chart.colData[this.chart.valueCol].getName(), this.chart.colData[this.chart.valueCol].getOriginalDataType(), this.chart.colData.length);
                this.chart.secData.copyAttributes(this.chart.colData[this.chart.valueCol]);
            }
            this.chart.a_s.setAxisGridX(step, ymax, ymin, ymax, this.chart.secData, this.chart.axisThickness);
        }
    }

    private boolean supportNormalCurve() {
        if (this.chart.dataDim != 1 || this.chart.subvalueCol >= 0) {
            return false;
        }
        int categoryType = this.chart.getCategoryType();
        return this.chart.isHistogram() && categoryType != 12 && categoryType != -1 && categoryType != 1 && categoryType != 91 && categoryType != 92 && categoryType != 93 && categoryType != 16 && categoryType != -7;
    }

    private double getValue(double in) {
        double v = -0.5 * Math.pow((in - this.mean) / this.stDev, 2.0);
        if ((v = Math.exp(v) / (Math.sqrt(Math.PI * 2) * this.stDev)) > this.max) {
            this.max = v;
        }
        return v;
    }

    protected void drawNormalCurve(CGraphics g) {
        if (!this.supportNormalCurve()) {
            return;
        }
        try {
            if (g != null) {
                this.chart.a_s.draw(g);
                if (!this.calculatemode) {
                    g.g.setColor(this.color);
                }
            }
            int lastX = -1;
            int lastY = -1;
            int curX = 0;
            int curY = 0;
            int minY = this.chart.chartyorigin;
            int maxY = minY + this.chart.chartheight;
            GeneralPath path = null;
            for (int i = 0; i < this.value.length; ++i) {
                if (TrendLine2D.isBarChartType(this.chart)) {
                    curX = this.chart.a_s.stepsize.interpolatePixel2(this.value[i]);
                    curY = this.pixel[i];
                } else {
                    curX = this.pixel[i];
                    curY = this.chart.a_s.stepsize.interpolatePixel2(this.value[i]);
                }
                if (lastX != -1) {
                    path = this.drawLimitPath(g, minY, maxY, lastX, lastY, curX, curY, path);
                }
                lastX = curX;
                lastY = curY;
                this.setAbsPosition(curX, curY);
            }
            if (path != null) {
                g.drawLine(path, this.thickness);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to draw normal curve", ex);
        }
    }

    public static Double[] getArrayWithoutNullValues(Double[] a) {
        Vector<Double> xx = new Vector<Double>();
        for (Double element : a) {
            if (element == null) continue;
            xx.add(element);
        }
        a = new Double[xx.size()];
        return xx.toArray(a);
    }

    @Override
    protected Point_2D getAbsPosition() {
        return new Point_2D(this.absPosX, this.absPosY);
    }
}

