/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart2d.types2d.general2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import quadbase.chart.CGraphics;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.MultiDimData;
import quadbase.chart.Point3D;
import quadbase.chart.StepSize;
import quadbase.chart.chart2d.Chart2D;
import quadbase.chart.chart2d.MultiDimData2D;
import quadbase.chart.chart2d.types2d.general2d.LineChart2D;
import quadbase.common.util.flash.FlashGraphics;
import quadbase.common.util.internal.IFlashGraphics;
import quadbase.common.util.internal.QbUtil;
import quadbase.util.internal.Composite;
import quadbase.util.internal.IOUtil;
import quadbase.util.internal.RenderingChart;

public class AreaChart2D
extends Chart2D {
    public AreaChart2D(Component component, ColData[] colData, boolean[] usedColumns) {
        super(component, 7, colData, usedColumns);
        if (this.nstring == 0) {
            if (this.nint + this.nreal == 0) {
                throw nocategoryError;
            }
            if (this.nint + this.nreal + this.ntime < 2) {
                throw nonumericError;
            }
            int rindex = 0;
            int iindex = 0;
            this.mDataMap[0] = this.nint > 0 ? this.nintcol[iindex++] : this.nrealcol[rindex++];
            this.dataDim = 1;
            this.valueCol = this.nreal > 0 ? this.nrealcol[rindex++] : this.nintcol[iindex++];
        } else {
            this.mDataMap[0] = this.nstringcol[0];
            if (this.nstring == 1) {
                this.dataDim = 1;
            } else {
                this.mDataMap[1] = this.nstringcol[1];
                this.dataDim = 2;
            }
            if (this.nint + this.nreal + this.ntime < 1) {
                throw nonumericError;
            }
            this.valueCol = this.nreal > 0 ? this.nrealcol[0] : this.nintcol[0];
        }
        this.bvalueCol = true;
        this.makeTable();
    }

    public AreaChart2D(Chart _chart) {
        super(7, _chart);
        if (!this.bvalueCol) {
            this.valueCol = _chart.coordCol[0];
            this.bvalueCol = true;
        }
        if (_chart.isStackType() && _chart.dataDim == 2) {
            this.mDataMap[0] = _chart.mDataMap[1];
            this.mDataMap[1] = _chart.mDataMap[0];
            this.dataDim = 2;
        } else {
            this.dataDim = _chart.dataDim >= 2 || this.bmDataMap[1] ? 2 : 1;
        }
        this.checkSpecialColumn(1);
        this.copyTable(_chart);
    }

    @Override
    public void computeCoord(CGraphics g, int xmin, int xmax, int ymin, int ymax) {
        int m;
        double value;
        int i;
        boolean zoomXDir;
        boolean doSwapAxis;
        if (this.notEnoughData()) {
            return;
        }
        FontMetrics fm = g.getFontMetrics(QbUtil.resizeViewerFont(this.a_y.font, this.mData.chart.isAdjustFont()));
        int fstep = (int)((double)(ymax - ymin) / (2.0 * (double)(fm.getMaxAscent() + fm.getMaxDescent())));
        StepSize ystep = null;
        StepSize ystep2 = null;
        boolean bl = doSwapAxis = this.isSwapAxis && this.subvalueCol >= 0;
        if (this.isJoinAxis()) {
            this.findMinMaxVal();
            this.findMinMaxVal2();
            if (this.maxvalue > this.maxvalue2) {
                this.maxvalue2 = this.maxvalue;
            } else {
                this.maxvalue = this.maxvalue2;
            }
            if (this.minvalue < this.minvalue2) {
                this.minvalue2 = this.minvalue;
            } else {
                this.minvalue = this.minvalue2;
            }
            ystep = new StepSize(this.a_y, ymax, ymin, this.maxvalue, this.minvalue, fstep, this.getVdec());
            this.a_y.setAxisGridY(ystep, xmin, xmin, xmax, this.colData[this.valueCol], this.axisThickness);
            ystep2 = new StepSize(this.a_s, ymax, ymin, this.maxvalue2, this.minvalue2, fstep, this.getSubVdec());
            this.a_s.setAxisGridY(ystep2, xmax, xmin, xmax, this.colData[this.subvalueCol], this.axisThickness);
            LineChart2D.lineData(this.dataDim, xmin, xmax, ystep2, this.mData2, this.mDataLen, this.showOffsetTicker());
        } else if (doSwapAxis) {
            this.findMinMaxVal();
            ystep = new StepSize(this.a_y, ymax, ymin, this.maxvalue, this.minvalue, fstep, this.getVdec());
            this.a_y.setAxisGridY(ystep, xmax, xmin, xmax, this.colData[this.valueCol], this.axisThickness);
            this.findMinMaxVal2();
            ystep2 = new StepSize(this.a_s, ymax, ymin, this.maxvalue2, this.minvalue2, fstep, this.getSubVdec());
            this.a_s.setAxisGridY(ystep2, xmin, xmin, xmax, this.colData[this.subvalueCol], this.axisThickness);
            if (this.subvalueCol >= 0) {
                this.findMinMaxVal();
                ystep = new StepSize(this.a_y, ymax, ymin, this.maxvalue, this.minvalue, fstep, this.getVdec());
                this.a_y.setAxisGridY(ystep, xmax, xmin, xmax, this.colData[this.valueCol], this.axisThickness);
                LineChart2D.lineData(this.dataDim, xmin, xmax, ystep2, this.mData2, this.mDataLen, this.showOffsetTicker());
            }
        } else {
            this.findMinMaxVal();
            ystep = new StepSize(this.a_y, ymax, ymin, this.maxvalue, this.minvalue, fstep, this.getVdec());
            this.a_y.setAxisGridY(ystep, xmin, xmin, xmax, this.colData[this.valueCol], this.axisThickness);
            if (this.subvalueCol >= 0) {
                this.findMinMaxVal2();
                ystep2 = new StepSize(this.a_s, ymax, ymin, this.maxvalue2, this.minvalue2, fstep, this.getSubVdec());
                this.a_s.setAxisGridY(ystep2, xmax, xmin, xmax, this.colData[this.subvalueCol], this.axisThickness);
                LineChart2D.lineData(this.dataDim, xmin, xmax, ystep2, this.mData2, this.mDataLen, this.showOffsetTicker());
            }
        }
        int noCategory = this.mDataLen[this.dataDim - 1];
        int[] loc = new int[this.dataDim];
        Point3D[] coord = new Point3D[noCategory];
        this.yAxisCenter = ystep.zeroAxis;
        double delta = (double)(xmax - xmin) / ((double)noCategory - 1.0);
        double nextx = xmin;
        if (this.showOffsetTicker()) {
            delta = (double)(xmax - xmin) / (double)noCategory;
            nextx = (double)xmin + delta / 2.0;
        }
        boolean bl2 = zoomXDir = this.mData.chart.isXZoomed && (this.mData.chart.getZoomOption() == 0 || this.mData.chart.getZoomOption() == 2);
        if (this.dataDim == 1) {
            for (i = 0; i < noCategory; ++i) {
                loc[0] = i;
                value = this.isDataLimitAtAxisScale() ? this.mData.getValue(loc, this.a_y) : this.mData.getValue(loc);
                if (this.flashRatio != 1.0) {
                    value = (value - this.a_y.axisShift) * this.flashRatio + this.a_y.axisShift;
                }
                m = (int)nextx;
                if (zoomXDir && ((m = this.mData.chart.calculateZoomedX(m)) < this.mData.chart.chartxorigin || m > this.mData.chart.chartxorigin + this.mData.chart.chartwidth)) {
                    m = -100;
                }
                this.mData.setPointCoord((int)nextx, ystep.interpolatePixel(value), loc);
                this.mData.setFlashPointCoord((int)nextx, ystep.interpolatePixel(value / 2.0), loc);
                coord[i] = new Point3D(m, ystep.zeroAxis, 0);
                nextx += delta;
            }
        } else {
            for (i = 0; i < noCategory; ++i) {
                loc[1] = i;
                for (int j = 0; j < this.mDataLen[0]; ++j) {
                    loc[0] = j;
                    value = this.isDataLimitAtAxisScale() ? this.mData.getValue(loc, this.a_y) : this.mData.getValue(loc);
                    if (this.flashRatio != 1.0) {
                        value = (value - this.a_y.axisShift) * this.flashRatio + this.a_y.axisShift;
                    }
                    this.mData.setPointCoord((int)nextx, ystep.interpolatePixel(value), loc);
                    this.mData.setFlashPointCoord((int)nextx, ystep.interpolatePixel(value / 2.0), loc);
                }
                m = (int)nextx;
                if (zoomXDir && ((m = this.mData.chart.calculateZoomedX(m)) < this.mData.chart.chartxorigin || m > this.mData.chart.chartxorigin + this.mData.chart.chartwidth)) {
                    m = -100;
                }
                coord[i] = new Point3D(m, ystep.zeroAxis, 0);
                nextx += delta;
            }
        }
        this.setAutomatic(ystep2 != null);
        int colfield = this.mDataMap[this.dataDim - 1];
        this.a_x.set(xmin, ystep.zeroAxis, xmax, ystep.zeroAxis, this.axisThickness, this.colData[colfield].getFieldName(), coord, ystep.zeroAxis == ymax, this.colData[colfield]);
        Point3D[] coord2 = new Point3D[noCategory];
        for (int i2 = 0; i2 < coord2.length; ++i2) {
            coord2[i2] = new Point3D(coord[i2].x, ymin, 0);
        }
        this.a_x.grid.set(coord2, ymin, ymax);
        super.computeCoord(g, xmin, xmax, ymin, ymax);
    }

    private void fillArea(CGraphics g) {
        Polygon p = null;
        boolean isTranslucent = this.isTranslucentSupport();
        if (isTranslucent) {
            Composite.setCompositeSrcOver(g.g, this.getTranslucentValue());
        }
        if (this.dataDim == 1) {
            for (int i = 0; i < this.mDataLen[0] - 1; ++i) {
                MultiDimData md1 = this.mData.multiData[i];
                MultiDimData md2 = this.mData.multiData[i + 1];
                int x1 = md1.point.x;
                int x2 = md2.point.x;
                if (this.isCatZoom() && this.isVertical()) {
                    x1 = this.calculateZoomedX(md1.point.x);
                    x2 = this.calculateZoomedX(md2.point.x);
                }
                if ((p = this.getPolygon(x1, md1.point.y, x2, md2.point.y)) == null) continue;
                g.setColor(this.mData.area.areaColor);
                if (md1.plotData.isEmpty() || md2.plotData.isEmpty()) continue;
                g.fillPolygon(p, md1);
                if (this.drawDataBorder) {
                    g.drawLineForArea(p, i == 0, i == this.mDataLen[0] - 2, this.mData.area.areaColor.darker());
                }
                if (!this.isDrawBorderForWhiteArea() || this.mData.area.areaColor.getRGB() != Color.white.getRGB()) continue;
                g.drawLineForArea(p, i == 0, i == this.mDataLen[0] - 2, Color.black);
            }
        } else {
            for (int i = 0; i < this.mDataLen[0]; ++i) {
                MultiDimData md = this.mData.multiData[i];
                for (int j = 0; j < this.mDataLen[1] - 1; ++j) {
                    MultiDimData md1 = md.multiData[j];
                    MultiDimData md2 = md.multiData[j + 1];
                    int x1 = md1.point.x;
                    int x2 = md2.point.x;
                    if (this.isCatZoom() && this.isVertical()) {
                        x1 = this.calculateZoomedX(md1.point.x);
                        x2 = this.calculateZoomedX(md2.point.x);
                    }
                    if ((p = this.getPolygon(x1, md1.point.y, x2, md2.point.y)) == null) continue;
                    g.setColor(md.area.areaColor);
                    if (md1.plotData.isEmpty() || md2.plotData.isEmpty()) continue;
                    g.fillPolygon(p, md1);
                    if (this.drawDataBorder) {
                        g.drawLineForArea(p, j == 0, j == this.mDataLen[1] - 2, md.area.areaColor.darker());
                    }
                    if (!this.isDrawBorderForWhiteArea() || md.area.areaColor.getRGB() != Color.white.getRGB()) continue;
                    g.drawLineForArea(p, j == 0, j == this.mDataLen[1] - 2, Color.black);
                }
            }
            if (isTranslucent) {
                Composite.setOriginalComposite(g.g);
            }
        }
        this.prepareLabel();
    }

    private Polygon getPolygon(int x1, int y1, int x2, int y2) {
        if (this.isCatZoom() || this.isValueZoom()) {
            return ((MultiDimData2D)this.mData).getPolygonForArea(x1, y1, x2, y2);
        }
        Polygon p = new Polygon();
        p.addPoint(x1, y1);
        p.addPoint(x2, y2);
        p.addPoint(x2, this.yAxisCenter);
        p.addPoint(x1, this.yAxisCenter);
        return p;
    }

    @Override
    public void draw(CGraphics g) {
        this.background.draw(g, this.background, null, true, this.background);
        this.drawControlRange(g, 0);
        if (!this.isGridInFront()) {
            this.a_x.drawGrid(g);
            this.a_y.drawGrid(g);
        }
        if (IOUtil.isJava2D()) {
            Graphics backupG = g.g;
            Image buffImg = Composite.getBufferedImage(backupG, this.winWidth, this.winHeight);
            g.g = Composite.createGraphics(backupG, buffImg);
            this.drawChart(g);
            this.drawControlRange(g, 1);
            Composite.drawImage(backupG, buffImg);
            g.g = backupG;
        } else {
            this.drawChart(g);
        }
        this.dataLineSet.drawDataLineList();
        boolean restoreRendering = false;
        if (this.setAntiAliasForChartOnly && this.isAntiAliasEnabled()) {
            restoreRendering = true;
            this.setAntiAliasEnabled(false);
            RenderingChart.setRenderingHint(g.g, this.renderingKey, this.renderingValue);
        }
        if (this.isGridInFront()) {
            this.a_x.drawGrid(g);
            this.a_y.drawGrid(g);
        }
        this.border.draw(g);
        this.a_x.draw(g);
        this.a_y.draw(g);
        if (this.showLegend2()) {
            this.a_s.draw(g);
        }
        if (IOUtil.isJava2D()) {
            Graphics backupG = g.g;
            Image buffImg = Composite.getBufferedImage(backupG, this.winWidth, this.winHeight);
            g.g = Composite.createGraphics(backupG, buffImg);
            this.drawPoints(g);
            this.drawControlRange(g, 2);
            Composite.drawImage(backupG, buffImg);
            g.g = backupG;
        }
        this.mainTitle.draw(g);
        if (restoreRendering) {
            this.setAntiAliasEnabled(true);
            RenderingChart.setRenderingHint(g.g, this.renderingKey, this.renderingValue);
        }
        if (this.checkZoomStatus() && this.getZoomOption() != -1) {
            this.drawScrollBars(g);
        }
    }

    @Override
    public void drawChart(CGraphics g) {
        if (g.g instanceof IFlashGraphics) {
            ((FlashGraphics)g.g).initFrameSet(this.flashFrameCount);
            int k = 0;
            for (int i = 0; i < this.flashFrameCount; ++i) {
                ((IFlashGraphics)((Object)g.g)).setFrame(k++);
                this.flashRatio = ((double)i + 1.0) / (double)this.flashFrameCount;
                this.computeCoord(g, this.chartxorigin, this.chartxorigin + this.chartwidth, this.chartyorigin, this.chartheight + this.chartyorigin);
                this.drawChart_INTERNAL(g);
            }
            ((IFlashGraphics)((Object)g.g)).setFrame(-1);
        } else {
            this.drawChart_INTERNAL(g);
        }
    }

    private void drawChart_INTERNAL(CGraphics g) {
        if (this.showLine) {
            this.mData.drawLine(g);
        }
        if (this.showPoint) {
            this.mData.drawPoint(g);
        }
        this.fillArea(g);
        if (this.showLegend2()) {
            if (this.showLine2) {
                this.mData2.drawLine(g);
            }
            if (this.showPoint2) {
                this.mData2.drawPoint(g);
            }
        }
        this.drawLabel(g);
    }

    @Override
    public boolean notEnoughData() {
        return this.nRow <= 1;
    }
}

